---
lang-ref: ch.01-2
lecturer: Yann LeCun
title: Evolución y Usos de las CNNs y ¿Por qué Aprendizaje Profundo?
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
lang: es
translation-date: 27 Mar 2020
translator: victorsergio
---


## [Evolución de las CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!--In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.-->
En el cerebro de los animales, las neuronas reaccionan a bordes en determinadas orientaciones. Grupos de neuronas que reaccionan a las mismas orientaciones son replicados sobre todo el campo visual.

<!--Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling).-->
Fukushima (1982) construyo una red neuronal (NN) que funcionaba de la misma forma que el cerebro, basada en dos conceptos. Primero, las neuronas son replicadas a través del campo visual. Segundo, hay células complejas que agrupan la información de células simples (unidades selectivas de orientación). Como resultado, el corrimiento de la imagen cambiará la activación de células simples, pero no influirá la activación integrada de la célula compleja (agrupación convolucional).

<!--LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top.-->
LeCun (1990) utilizó propagación hacia atrás para entrenar una CNN para el reconocimiento de dígitos escritos a mano. Hay una demostración de 1992 donde el algoritmo reconoce los dígitos de cualquier estilo. Realizar reconocimiento de caracteres/patrones utilizando un modelo entrenado de extremo a extremo era nuevo en ese tiempo. Previamente, personas habían utilizado un modelo supervisado sobre extractores de características.

<!--These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present.-->
Estos nuevos sistemas CNN podían reconocer múltiples caracteres en la imagen al mismo tiempo. Para hacerlo, personas utilizaron una pequeña ventana de entrada para una CNN y la deslizaban sobre toda la imagen. Si se activaba, significaba que ahí había un determinado carácter presente.

<!--Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking.-->
Mas adelante, esta idea fue aplicada a la detección de rostros/personas y segmentación semántica (clasificación entre píxeles). Ejemplos incluyen a Hadsell (2009) y Farabet (2012). Esto eventualmente se tornó popular en la industria, siendo utilizado en aplicaciones de conducción autónoma, por ejemplo en el seguimiento de carril.

<!--Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again.-->
Los tipos de equipo de cómputo especializado para entrenar CNNs fueron un tema popular en los 1980’s, después el interés bajó, y ahora nuevamente ha vuelto a ser popular.

<!--The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% vs 16.4% top-5 error rate.-->
La revolución del Aprendizaje Profundo (aunque el termino no era usado en ese tiempo) inició en 2010-2013. Investigadores se enfocaron en inventar algoritmos que pudieran ayudar a entrenar CNNs más rápido. Krizhevsky (2012) apareció con AlexNet, la cual era una CNN mucho más grande que las utilizadas anteriormente, y entrenada en ImageNet (1.3 millones de ejemplos) utilizando GPUs. Después de ejecutarse por un par de semanas AlexNet superó por un gran margen el rendimiento de los mejores sistemas compitiendo -- un 25.8% contra un 16.4% de la tasa de error top-5.

<!--After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs.-->
Después de ver el éxito de AlexNet, la comunidad de Visión por Computadora (CV) quedó convencida de que las CNNs funcionaban. Mientras que todas las publicaciones del 2011-2012 que mencionaban CNNs fueron rechazadas, desde 2016 las publicaciones más aceptadas en CV utilizan CNNs.

<!--Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster.-->
A través de los años, el número de capas utilizadas ha ido incrementándose: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. Sin embargo, hay una relación entre el número de operaciones necesarias para calcular la salida, el tamaño del modelo y su precisión. En consecuencia, en la actualidad un tema popular es cómo comprimir las redes para realizar los cálculos más rápido.



## [Aprendizaje Profundo y Extracción de Características](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

<!--Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy,  combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature.-->
Las redes multicapa son exitosas porque explotan la estructura composicional de los datos naturales. En una jerarquía composicional, combinaciones de objetos de una capa en la jerarquía forman los objetos de la siguiente capa. Si modelamos esta jerarquía como múltiples capas y dejamos que la red aprenda la combinación apropiada de características, obtenemos lo que llamamos una arquitectura de Aprendizaje Profundo. En consecuencia, las redes de Aprendizaje Profundo son jerárquicas por naturaleza.

<!--Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement.-->
Las arquitecturas de Aprendizaje Profundo nos han llevado a obtener un progreso increíble en tareas de visión por computadora, que van desde identificar y generar máscaras precisas alrededor de objetos hasta identificar propiedades espaciales de los mismos. Principalmente las arquitecturas Mask-RCNN y RetinaNet son las responsables de haber logrado esta mejora.

<!--Mask RCNNs have found their use in segmenting individual objects, i.e. creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, i.e. identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source.-->
Las Mask-RCNNs han encontrado su aplicación en la segmentación de objetos individuales, como por ejemplo creando máscaras para cada objeto en una imagen. Tanto la entrada como la salida son imágenes. Esta arquitectura puede también ser usada para realizar segmentación de instancias, por ejemplo para identificar diferentes objetos del mismo tipo en una imagen. *Detectron*, un sistema de software del centro de investigación de IA de Facebook (FAIR), implementa todos estos algoritmos de detección de objetos de última generación (*SOTA*), y es de código abierto.

<!--Some of the practical applications of CNNs are powering autonomous driving and analysing medical images.-->
Algunas de las aplicaciones prácticas de las CNNs son la conducción autónoma de vehículos y el análisis médico de imágenes.

<!--Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work?-->
A pesar de que la ciencia y las matemáticas detrás del Aprendizaje Profundo son bastante entendidas, aún existen algunas preguntas interesantes que requieren más investigación. Estas preguntas incluyen: ¿Por qué arquitecturas con múltiples capas se desempeñan mejor, si podemos aproximar cualquier función con dos capas solamente? ¿Por qué las CNNs trabajan bien con datos naturales como el habla, imágenes y texto? ¿Cómo es que podemos optimizar funciones no convexas tan bien? ¿Por qué funcionan estas arquitecturas sobre-parametrizadas?

<!--Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes.-->
La extracción de características consiste en expandir la dimensión de representación de tal forma que las características expandidas sean más propensas a ser linealmente separables; puntos en un espacio dimensional más alto son más propensos a ser linealmente separables, debido al incremento en la cantidad de posibles planos separadores.

<!--Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:-->
Los primeros profesionales en el área de Aprendizaje de Máquina dependían de características de alta calidad, seleccionadas manualmente y especializadas en un campo determinado para construir modelos de inteligencia artificial, pero con la llegada del Aprendizaje Profundo, los modelos comenzaron a extraer las características genéricas automáticamente. Algunos enfoques comúnmente utilizados en los algoritmos de extracción de características son listados abajo:

<!--- Space tiling -->
<!--- Random Projections-->
<!--- Polynomial Classifier (feature cross-products)-->
<!--- Radial basis functions-->
<!--- Kernel Machines-->

-   Repetición de espacios
-   Proyecciones Aleatorias
-   Clasificador Polinomial (productos-cruzados de características)
-   Funciones de base radial
-   Maquinas Kernel

<!--Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example:-->
Debido a la naturaleza composicional de los datos, las características aprendidas tienen una jerarquía de representaciones con un nivel incremental de abstracciones. Por ejemplo:

<!---  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.-->
-  Imágenes - En el nivel más granular, las imágenes pueden ser vistas como píxeles. Combinaciones de píxeles forman bordes los cuales al ser combinados forman *textons* (formas multi-borde). Los *textons* forman motivos y los motivos forman partes de la imagen. Uniendo todas estas partes obtenemos la imagen final.
<!---  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.-->
-  Texto - De la misma forma, hay una jerarquía inherente en los datos de tipo texto. Caracteres forman palabras, cuando unimos palabras obtenemos grupos de palabras, después cláusulas, luego uniendo cláusulas obtenemos oraciones. Las oraciones finalmente nos dicen qué historia está siendo transmitida.
<!---  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation.-->
-  Habla - En habla, muestras componen bandas, las cuales forman sonidos, los cuales forman fonos, luego fonemas, luego palabras completas, luego oraciones, así mostrando una clara jerarquía en su representación.


## [Aprendiendo representaciones](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

<!--There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more?-->
Hay quienes rechazan el Aprendizaje Profundo: Si podemos aproximar cualquier función con 2 capas, ¿por qué tener más?
<!--For example: SVMs find a separating hyperplane "in the span of the data," meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in N (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to log(N), the layers become linear in N. There is a trade-off between time and space.-->
Por ejemplo: las SVMs encuentran un hiperplano separador "en el espacio de los datos", las predicciones significativas están basadas en comparaciones con los ejemplos de entrenamiento. Las SVMs son esencialmente una muy simplista red neuronal de 2 capas, donde la primera capa define "plantillas" (*templates*) y la segunda capa es un clasificador lineal. El problema con la falacia de las dos capas es que, la complejidad y el tamaño de la capa intermedia es exponencial en N (para lograrlo correctamente con una tarea difícil, se necesitan grandes cantidades de plantillas). Pero si se expande el número de capas a log(N), las capas llegan a ser lineales en N. Hay una relación de balance entre tiempo y espacio.

<!--An analogy is designing a circuit to compute a boolean function with no more than two layers of gates - we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions.-->
Una analogía es diseñar un circuito para calcular una función booleana con no más de dos capas de compuertas - ¡podemos calcular **cualquier función booleana** de esta forma! Pero, la complejidad y recursos de la primera capa (número de compuertas) rápidamente llegarían a ser inviables para funciones complejas.

<!--What is "deep"?-->
¿Qué es "profundo"?

<!--- An SVM isn't deep because it only has two layers-->
-  Una SVM no es profunda porque solo tiene dos capas.
<!--- A classification tree isn't deep because every layer analyses the same (raw) features-->
-  Un árbol de clasificación no es profundo porque cada capa analiza las mismas características (en bruto).
<!--- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity**-->
-  Una red profunda tiene varias capas y las utiliza para construir una **jerarquía de características de complejidad incremental.**

<!--How can models learn representations (good features)?-->
¿Cómo pueden los modelos aprender representaciones (buenas características)?

<!--Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*).-->
Hipótesis de la superficie cerrada (*manifold*): los datos naturales viven en una superficie cerrada de baja dimensionalidad. El conjunto de imágenes posibles es esencialmente infinito, el conjunto de imágenes "naturales" es un pequeño subconjunto. Por ejemplo: para una imagen de una persona, el conjunto de posibles imágenes está en el orden de magnitud del número de músculos de la cara que la persona puede mover (grados de libertad) ~ 50. Un extractor de características ideal (no realista) representaría todos los factores de variación (cada uno de los músculos, iluminación, *etc.*).


<!--Q&A from the end of lecture:-->
Preguntas y respuestas al final de la lección:

<!--- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?-->
<!--  - Answer: would only work if the manifold surface is a hyperplane, which it is not-->
- Para el ejemplo de rostros, ¿podría alguna otra técnica de reducción de dimensionalidad (como PCA) extraer dichas características?
  - Respuesta: podría funcionar solamente si la superficie cerrada es un hiperplano, lo cual no es así.
