---
lang: es
lang-ref: ch.01-1
lecturer: Yann LeCun
title: Motivación del Aprendizaje Profundo, su Historia e Inspiración
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 24 Mar 2020
translator: LecJackS
---

<!-- 
-->
## [Plan del curso](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!-- 
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
-->
- Conceptos básicos de Aprendizaje Supervisado, Redes Neuronales, Aprendizaje Profundo
- Retropropagación y componentes de la arquitectura.
- Red neuronal convolucional y sus aplicaciones.
- Más Arquitecturas de Aprendizaje Profundo
- Trucos de regularización / Trucos de optimización / Comprendiendo cómo funciona el Aprendizaje Profundo
- Modelos basados en energía.
- Aprendizaje auto supervisado y más allá

<!-- Inspiration of Deep Learning and its history
-->
## Inspiración del Aprendizaje Profundo y su historia.

<!-- On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.
-->
En un nivel conceptual, el aprendizaje profundo está inspirado en el cerebro, pero no todos los detalles del cerebro son relevantes. A modo de comparación, los aviones se inspiraron en las aves. El principio de volar es el mismo, pero los detalles son extremadamente diferentes.

<!-- The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.
-->
La historia del aprendizaje profundo se remonta a un campo llamado cibernética, cuyo nombre a cambiado ahora. Comenzó en la década de 1940 con McCulloch y Pitts. Se les ocurrió la idea de que las neuronas son unidades con cierto umbral, con estados de encendido y apagado. Se podría construir un circuito booleano conectando neuronas entre sí y realizar inferencia lógica con neuronas. El cerebro es básicamente una máquina de inferencia lógica porque las neuronas son binarias. Las neuronas calculan una suma ponderada de entradas y comparan esa suma con su umbral. Se enciende si está por encima del umbral y se apaga si está por debajo, lo cual es una visión simplificada de cómo funcionan las redes neuronales.

<!-- In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.
-->
En 1947, Donald Hebb tuvo la idea de que las neuronas en el cerebro aprenden modificando la fuerza de las conexiones entre ellas. Esto es llamado *hiper aprendizaje*, donde si dos neuronas se disparan juntas, entonces la conexión vinculada entre ellas aumenta; Si no disparan juntas, la fuerza de la conexión disminuye.

<!-- Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.
-->
Más tarde, en 1948, Norbert Wiener propuso la cibernética, que es la idea de que al tener sistemas con sensores y actuadores, se tiene un circuito de retroalimentación y un sistema autorregulador. Las reglas del mecanismo de retroalimentación de un automóvil provienen de este trabajo.

<!-- In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.
-->
En 1957, Frank Rosenblatt propuso el Perceptrón, que es un algoritmo de aprendizaje que modifica los pesos de redes neuronales muy simples.

<!-- Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:
-->
En general, esta idea de tratar de construir máquinas intelectuales simulando muchas neuronas nació en la década de 1940, despegó en la década de 1950 y murió por completo a fines de la década de 1960. Las principales razones de la muerte del campo en 1960 son:

<!-- - The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.
-->
- Los investigadores usaron neuronas que eran binarias. Sin embargo, para hacer funcionar la retropropagación (o propagación hacia atrás, del inglés *backpropagation*) es necesario usar funciones de activación continuas. En ese momento, los investigadores no tenían la idea de usar neuronas continuas y no creían que se pudieran entrenar con gradientes ya que las neuronas binarias no son diferenciables.
- Con neuronas continuas, uno tendría que multiplicar la activación de una neurona por un peso para obtener su contribución a la suma ponderada. Sin embargo, antes de 1980, la multiplicación de dos números, especialmente los números de punto flotante, era extremadamente lenta. Esto resultó en otro incentivo para evitar el uso de neuronas continuas.

<!-- Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->
El Aprendizaje Profundo despegó nuevamente en 1985 con la aparición de la retropropagación. En 1995, el campo murió nuevamente y la comunidad de aprendizaje automático abandonó la idea de las redes neuronales. A principios de 2010, las personas comenzaron a usar redes neuronales en el reconocimiento de voz con una gran mejora en el rendimiento y más tarde se desplegó ampliamente en el campo comercial. En 2013, el campo de visión por computadora comenzó a cambiar a redes neuronales. En 2016, ocurrió la misma transición en el procesamiento del lenguaje natural. Pronto, ocurrirán revoluciones similares en robótica, control y muchos otros campos.

<!-- 
-->
### Aprendizaje Supervisado

<!-- $90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.
-->
El $90\%$ de las aplicaciones de aprendizaje profundo utilizan aprendizaje supervisado. El aprendizaje supervisado es un proceso mediante el cual, se recopilan varios pares de entradas y salidas, y las entradas se introducen en una máquina que debe aprender cuál es la salida correcta. Cuando la salida es correcta, no se hace nada. Si la salida es incorrecta, se modifica el parámetro de la máquina y corrige la salida en dirección a la deseada. El truco aquí es cómo averiguar en qué dirección y cuánto debe modificarse el parámetro, para lo cual se utiliza el cálculo de gradiente y la propagación hacia atrás.

<!-- Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->
El aprendizaje supervisado proviene de Perceptrón y Adaline. Adaline se basa en la misma arquitectura con entradas ponderadas: cuando está por encima del umbral, se enciende y por debajo del umbral, se apaga. El Perceptrón es una red neuronal de 2 capas donde la segunda capa es entrenable y la primera capa es fija. La mayoría de las veces, la primera capa se determina al azar y eso es a lo que llaman capas asociativas.

<!-- History of Pattern Recognition and introduction to Gradient Descent
-->
## [Historia del Reconocimiento de Patrones e introducción al Descenso de Gradiente](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!-- The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.
-->
Lo anterior es la base conceptual del reconocimiento de patrones antes de que el aprendizaje profundo sea desarrollado. El modelo estándar de reconocimiento de patrones consiste en un extractor de características y un clasificador entrenable. La entrada pasa por el extractor de características, extrayendo información útil y relevante de las entradas, como la detección de un ojo cuando el propósito es reconocer una cara. Luego, el vector de características resultante, se alimenta al clasificador entrenable para calcular la suma ponderada y compararla con el umbral. Aquí, un clasificador entrenable podría ser un perceptrón o una red neuronal única. El problema es que el extractor de características debe diseñarse a mano. Lo que significa que el reconocimiento de patrones / visión por computadora se enfoca en el extractor de características considerando cómo diseñarlo para un problema específico, no muy dedicado al clasificador entrenable.

<!-- After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.
-->
Después de la aparición y el desarrollo del aprendizaje profundo, el proceso de 2 etapas cambió a una secuencia de módulos. Cada módulo tiene parámetros ajustables y una no linealidad (función no lineal). Luego, se apilan formando múltiples capas. Por eso se llama "aprendizaje profundo". La razón por la que se usa la no linealidad en lugar de la linealidad, es que dos capas lineales pueden ser formadas por una sola capa lineal, ya que la composición de dos funciones lineales, es también lineal.

<!-- The simplest multi-layer architecture with tunable parameters and nonlinearity could be: input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix which coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.
-->
La arquitectura más simple de múltiples capas con parámetros ajustables y no linealidad podría ser: la entrada se representa como un vector, como por ejemplo una imagen o audio. Esta entrada se multiplica por la matriz de pesos, cuyos coeficientes son los parámetros ajustables. Luego, cada componente del vector resultante se pasa a través de una función no lineal, como una ReLU. Repitiendo este proceso, la arquitectura se convierte en una red neuronal básica. La razón por la que se llama red neuronal es que esta arquitectura calcula una suma ponderada del vector de entrada, a partir del producto de los componentes del vector de entrada por las filas correspondientes de una matriz de pesos.

<!-- Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is loss computing distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.
-->
Volviendo al aprendizaje supervisado, comparamos la salida resultante con la salida objetivo y luego optimizamos la función objetivo, que es el cálculo de la distancia de error / penalización / divergencia entre el resultado y el objetivo. Luego, se promedia esta función de costo sobre el conjunto de datos de entrenamiento. Este es el objetivo que queremos minimizar. En otras palabras, queremos encontrar el valor de los parámetros que minimizan este promedio.

<!-- The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.
-->
El método de cómo encontrarlo es calcular el gradiente. Por ejemplo, si estamos perdidos en una montaña lisa en una noche de niebla y queremos ir al pueblo en el valle, una forma de conseguirlo podría ser girar en el lugar y sentir con los pies cuál es la forma más empinada de bajar, para luego dar un pequeño paso hacia abajo. La dirección es el gradiente (negativo). Suponiendo que el valle es convexo, podríamos llegar al valle.

<!-- The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->
La forma más eficiente se llama Descenso de Gradiente Estocástico (SGD). Dado que queremos minimizar la pérdida promedio sobre el conjunto de entrenamiento, tomamos una sola muestra de entrada, o un pequeño grupo de muestras, calculamos el error sobre ellas, y usamos el descenso de gradiente. Luego, tomamos una nueva muestra, obtenemos un nuevo valor para el error, y calculamos el gradiente, que normalmente es una dirección diferente. Dos de las razones principales para usar SGD son que ayuda al modelo a converger rápidamente (de forma empírica) si el conjunto de entrenamiento es muy grande y permite una mejor generalización, lo que significa obtener un rendimiento similar para varios conjuntos de datos.

<!-- Computing gradients by backpropagation
-->
### [Cálculo de gradientes por retropropagación](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!-- Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:
-->
Calcular gradientes por retropropagación es una aplicación práctica de la regla de la cadena. La ecuación de retropropagación para los gradientes de la entrada es la siguiente:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

<!-- The backpropagation equation for the weight gradients is as follows:
-->
La propagación hacia atrás para los gradientes de los pesos es:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!-- Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.
-->
Hay que tener en cuenta que en lugar de entradas escalares, serán entradas de vectores. Más generalmente, entradas multidimensionales. La retropropagación permite calcular la derivada de la diferencia entre la salida que se desea y la salida que se obtiene (que es el valor de la función objetivo) con respecto a cualquier valor dentro de la red. Finalmente, la retropropagación es esencial ya que se aplica a múltiples capas.

<!-- It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->
Es importante considerar cómo interpretar las entradas. Por ejemplo, una imagen RGB de 256$$\times$$256 requeriría una matriz de 200.000 valores. Estas serían matrices enormes que las capas de la red neuronal deberán procesar. No sería práctico utilizar tales matrices. Por lo tanto, es importante enunciar ciertas hipótesis de la estructura de la matriz.


<!-- Hierarchical representation of the Visual Cortex
-->
## Representación jerárquica de la Corteza Visual.

<!-- Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.
-->
Los experimentos de Fukushima nos dieron una comprensión de cómo nuestro cerebro interpreta la entrada a nuestros ojos. En resumen, se descubrió que las neuronas frente a nuestra retina comprimen la entrada (conocida como normalización de contraste) y esta señal viaja desde nuestros ojos hasta nuestro cerebro. Después de esto, la imagen se procesa en etapas y ciertas neuronas se activan con ciertas categorías. Por lo tanto, la corteza visual realiza reconocimiento de patrones de manera jerárquica.

<!-- Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (e.g. vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->
Experimentos en los que los investigadores conectaron electrodos en áreas específicas de la corteza visual, específicamente en el área V1, hicieron que se dieran cuenta de que ciertas neuronas reaccionan a ciertos patrones que aparecen en un área muy pequeña del campo visual y de manera similar con las neuronas vecinas y las áreas vecinas en el campo visual. Además, las neuronas que reaccionan al mismo campo visual, reaccionan a diferentes tipos de bordes de manera organizada (por ejemplo, bordes verticales u horizontales). También es importante tener en cuenta que existe la idea de que el proceso visual es esencialmente un proceso de retroalimentación. Por lo tanto, de alguna manera se puede hacer un reconocimiento rápido sin algunas conexiones recurrentes.
