---
title: Foreword, FAQ and disclaimer
author: Loïck Bourdois
date: 14 Nov 2021
lang-ref: faq
---


# Foreword 

This course concerns the latest techniques in deep learning and representation learning, focusing on supervised and unsupervised deep learning, embedding methods, metric learning, convolutional and recurrent nets, with applications to computer vision, natural language understanding, and speech recognition. 
The prerequisites include: [DS-GA 1001 Intro to Data Science](https://cds.nyu.edu/academics/ms-curriculum/) or a graduate-level machine learning course.

We invite you to prefer the videos on the [YouTube channel](https://www.youtube.com/watch?v=0bMe_vCZo30&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq) ("official" content) since the course is given by the teaching staff, unlike the website where it is the notes taken by the students during the course.
The website is summaries of the videos, so the videos usually include additional information compared to the website. For example:
- anecdotes about the different concepts discussed,
- jokes, 
- the repetition of the same concept but in the form of different formulations, thus generally making it possible to understand an idea if a first formulation is not understood, 
- the students' questions, which can be the ones you have yourself during the viewing,
If concepts are still not understood at the end of the video, you have the possibility to ask a question in the commentary of the YouTube video, which the website does not allow.
- the references of the articles on which the course is based are present on the slides of the videos whereas they are absent from the website.  

The website thus serves more as a summary of the videos or as a basis for your personal notes that you take while watching the videos. 
Note that you can easily switch from the site to a moment of a given video by clicking on the paragraph titles of the web pages. 


# FAQ

Here are some answers to frequently asked questions:
- **Does taking this course lead to certification?**
> No, it does not. In order to offer a certification, we would have to be able to evaluate you, but the content has not been designed for this (unlike a MOOC for example). As this is a frequent request, we are thinking about proposing a certification for future editions of the course.
- **A more recent version of the course exists. Is this 2020 edition still valid?**
> The 2021 edition is pretty much the same as the 2020 edition but is presented in a different way: practicum is now approached from the point of view of energy-based models (EBMs) and the lectures have been reorganized. The lecture guests are also different. 
- **How much time should I spend on this course?**
> For each week, there is approximately 2h30/3h of video content. With the time dedicated to note taking and playing with the notebooks, a total estimate of 5 hours per week seems reasonable. For the rest, it depends on the level of immersion you want to achieve in a given topic (reading the referenced articles, applying what was seen in class to your own projects, etc.).
- **Where to ask a question after watching a video?**
> You can ask it directly in the comments section under the YouTube video in question, and Alfredo will be happy to answer it. If the question is about a specific point in the video, please include the time stamp.
> You can also do this on the class [Discord](https://discord.gg/CthuqsX8Pb) specifically for students. It is also used to coordinate viewing groups, discuss assignments, suggest improvements, or generally discuss any topic related to the course.
- **Can I use this course?**
> Of course, the course is under the [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-nc-sa/4.0/).
> This means that:
> - You may not use the material for commercial purposes.
> - You must give appropriate credit, provide a link to the license, and indicate if changes were made. You may do so in any reasonable manner, but not in any way that suggests the licensor endorses you or your use.
> - If you remix, transform, or build upon the material, you must distribute your contributions under the same license as the original.  
>  
> For credit, you can use the following BibTeX:
> ```bibtex
> @misc{canziani2020nyudlsp20,  
>   author = {Canziani, Alfredo and LeCun, Yann},  
>   title = {NYU Deep Learning, Spring 2020},  
>   howpublished = "\url{https://atcold.github.io/NYU-DLSP20}",  
>   year = {2020},  
>   note = "[Online; accessed <today>]"  
> }
> ```




# Disclaimer

All other texts found on this site are lecture notes taken by students of the New York University during lectures given by Yann Le Cun, Alfredo Canziani, Aaron Defazio, Ishan Misra, Mike Lewis and Xavier Bresson. 
Thus the texts in English were written by about 130 people, which has an impact on the homogeneity of the texts (some write in the past tense, others in the present tense; the abbreviations used are not always the same; some write short sentences, while others write sentences of up to 5 or 6 lines, etc.).
It is possible that there may be some omissions: typing errors, spelling mistakes, etc. 
If you notice any, we invite you to submit a PR on the [GitHub directory of the site](https://github.com/Atcold/pytorch-Deep-Learning/pulls) specifying with an `[EN]` that it concerns the English translation.

Wishing you a deep reading !
