---
lang-ref: ch.02-3
title: Artificial neural networks (ANNs)
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
typora-root-url: 02-3
lang: bn
translation-date: 28 Jan 2021
translator: Khalid Saifullah
---

<!-- ## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s) -->
## [শ্রেণিবিন্যাস (ক্লাসিফিকেশন) এর জন্য সুপারভাইজড লার্নিং](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

<!-- * Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**. -->
* নিচের **চিত্র ১(ক)** লক্ষ্য কর। এই গ্রাফের বিন্দুগুলো একটি স্পাইরাল (পেঁচানো আকৃতি) এর শাখায় অবস্থান করছে, এবং এগুলো $\R^2$ এর। প্রতিটি রং ই একেকটি শ্রেণী (ক্লাস) বুঝাচ্ছে। একক (ইউনিক) শ্রেণীর সংখ্যা এখানে $K = 3$। গাণিতিকভাবে সমীকরণ **সমীকরণ ১(ক)** তে এটি তুলে ধরা হয়েছে।

<!-- * **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**. -->
* **চিত্র ১(খ)** তেও আরেকটি স্পাইরাল দেখানো হয়েছে, যেখানে গাউসিয়ান নয়েয (একরকম হ্রাসবৃদ্ধি/অস্থিরতা) অতিরিক্ত যুক্ত করা হয়েছে। এটির গাণিতিক রূপটি তোমরা **সমীকরণ ১(খ)** তে দেখতে পারো।.

  <!-- In both cases, these points are not linearly separable. -->
  উভয় ক্ষেত্রেই, চিত্রের বিন্দুগুলি লিনিয়ারলী সেপারেবল নয় (অর্থাৎ, রৈখিকভাবে পৃথক করা সম্ভব হয় না)।
  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>চিত্র ১(ক)</b> "সুগঠিত" 2D (দ্বিমাত্রিক) স্পাইরাল
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "নয়েয সম্পন্ন" 2D (দ্বিমাত্রিক) স্পাইরাল
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>সমীকরণ ১(ক)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>সমীকরণ ১(খ)</b></center>

<!-- What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution! -->
**শ্রেণিবিন্যাস (ক্লাসিফিকেশন)** সম্পাদন করার অর্থ কী? **লজিস্টিক রিগ্রেসশনের** এর ক্ষেত্রে যদি লক্ষ্য কর, এই ডাটা (স্পাইরাল) এর উপর যদি লজিস্টিক রিগ্রেশন ব্যবহার করা হয় ক্লাসিফিকেশন এর জন্য, সেক্ষেত্রে ডাটাগুলোকে তাদের নির্দিষ্ট শ্রেণীতে (ক্লাসে) বিন্যস্ত/আলাদা করতে এটি কিছু **লিনিয়ার প্লেইন** (ডিসিশন বাউন্ডারি) তৈরী করবে। কিন্তু এই সমাধানে সমস্যাটি হচ্ছে, এখানে প্রতিটি অংশেই একাধিক ক্লাসের পয়েন্ট (বিন্দু) অবস্থান করে। অর্থাৎ, স্পাইরালটির শাখাগুলি লিনিয়ার ডিসিশন বাউন্ডারিগুলোকে ছেদ করে। কাজেই, এটি ভালো কোনো সমাধান **নয়**।

<!-- **How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data. -->
**এটা আমরা কিভাবে ঠিক করতে পারি?** আমরা ইনপুট স্পেসকে এমনভাবে ট্রান্সফর্ম (রূপান্তর) করবো যাতে করে ডাটাগুলো লিনিয়ারলি সেপারেবল হওয়ায় বাধ্য হয়। এটি করার জন্য, ট্রেনিং এর সময় নিউরাল নেটয়ার্কটির ডিসিশন বাউন্ডারি (যা এটি শিখে) পর্যায়ক্রমে ট্রেনিং ডাটার ডিস্ট্রিবিউশনের (বিন্যাসের) সাথে মানিয়ে নেয়ার চেষ্টা করতে থাকে।

<!-- **Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level. -->
**লক্ষ্য করো:** একটি নিউরাল নেটওয়ার্ক সবসময় **বটম আপ (নিচ থেকে উপরে)** এভাবে তুলে ধরা হয়। প্রথম লেয়ারটি একেবারে নিচে এবং সর্বশেষ লেয়ারটি সবার উপরে অবস্থান করে। এর কারণ ধারণাগতভাবে, ইনপুট ডাটাগুলো হচ্ছে নিম্ন মানের ফিচার (বৈশিষ্ট) যা নিউরাল নেটওয়ার্কটি শেখার চেষ্টা করে। ডাটাগুলো নেটওয়ার্কের মধ্য দিয়ে যত **উপরের** দিকে পার হতে থাকে, একই সাথে প্রতিটি লেয়ার সেখান থেকে আরও উচ্চ মানের ফিচার বের করে নেয়।


<!-- ## Training data -->
## ট্রেনিং ডাটা

<!-- Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network. -->
গত সপ্তাহে আমরা দেখেছিলাম, প্রাথমিকভাবে যখন নিউরাল নেটওয়ার্কটি তৈরী করা হয়, সেটি ইনপুটটিকে একপ্রকার ইচ্ছামতো/এলোমেলো উপায়ে ট্রান্সফর্ম করে। যদিও এই ট্রান্সফরমেশনটি **প্রথম প্রথম** আমরা এটাকে যা করবে বলে আশা করি (প্রতিটি ক্লাসের ডাটাকে আলাদা করা) সেরকম কিছু করেনা, তবে আমরা এই ট্রান্সফরমেশনটিকে বাধ্য করতে পারি যাতে করে এটি অর্থবহ কিছু করে যেটি আমাদের উদ্দেশ্যকে সফল করবে। একটি নেটওয়ার্কের ট্রেনিং ডাটা হিসেবে নিম্নলিখিত ডাটা ব্যবহৃত হয়।

* $\vect{X}$ দ্বারা ইনপুট ডাটা বুঝানো হয়েছে, যা একটি $m$ (ট্রেনিং ডাটার সংখ্যা) x $n$ ডাইমেনশন (আকৃতির) ম্যাট্রিক্স। চিত্র ১(ক) এবং চিত্র ১(খ) এর ডাটাগুলোর ক্ষেত্রে $n = 2$।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>চিত্র ২</b> ট্রেনিং ডাটা
</center>

<!-- * Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes. -->
* ভেক্টর $\vect{c}$  এবং ম্যাট্রিক্স $\boldsymbol{Y}$ উভয়ই $m$ টি ক্লাসের লেবেল প্রকাশ করে। উপরে উল্লেখিত উদাহরণটিতে $3$ টি পৃথক ক্লাস রয়েছে।

  <!-- * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution. -->
  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, এবং $\vect{c} \in \R^m$. তবে আমরা $\vect{c}$ কে ট্রেনিং ডাটা হিসেবে নাও ব্যবহার করতে পারি। আমরা যদি সংখ্যাসূচক আলাদা আলাদা ক্লাস লেবেল ব্যবহার করি $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, সেটিকে নেটওয়ার্কটি ক্লাসগুলোর মধ্যে একপ্রকার অর্ডার (ক্রম) ধরে নিতে পারে যা আসলে ডাটা ডিস্ট্রিবিউশনের অংশ নয়।
  <!-- * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below). -->
  * এই সমস্যাটিকে দূর করার জন্য আমরা একটি **ওয়ান-হট এনকোডিং** ব্যবহার করি। এখানে আমরা প্রতিটি লেবেল $c_i$ এর জন্য, একটি $K$ ডাইমেনশনাল জিরো-ভেক্টর $\vect{y}^{(i)}$ তৈরী করি, যেখানে শুধু $c_i$-তম অংশটিতে $1$ বসানো হয়। (নিচের **চিত্র ৩** টি দেখো)।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>চিত্র ৩</b> ওয়ান-হট এনকোডিং
</center>

  <!-- * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots. -->
  * অতএব, $\boldsymbol Y \in \R^{m \times K}$. এই ম্যাট্রিক্স টিকেও একটি প্রোবাবিলিস্টিক মাস্ হিসেবে চিন্তা করতে পারো, যার পুরো মান $K$ টি জায়গার মধ্যে শুধু একটিতেই ঘনীভূত


<!-- ## Fully (FC) connected layers -->
## ফুল্লি কানেক্টেড (FC) লেয়ার্স 

<!-- We will now take a look at what a fully connected (FC) network is, and how it works. -->
আমরা এখন দেখবো একটি ফুল্লি কানেক্টেড (FC) নেটওয়ার্ক কি এবং এটি কিভাবে কাজ করে।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>চিত্র ৪</b> ফুল্লি কানেক্টেড নিউরাল নেটওয়ার্ক
</center>

<!-- Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $\boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, *i.e* one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}}$. This network can be represented mathematically by the equations in **Eqn. 2** below. $f$ and $g$ are both non-linearities. -->
উপরের **চিত্র ৪** এ দেখানো নেটওয়ার্কটি লক্ষ্য কর। ইনপুট ডাটা $\boldsymbol x$ কে একটি এফাইন ট্রান্সফরমেশন এবং এর পর একটি নন-লিনিয়ার ট্রান্সফরমেশনের মধ্য দিয়ে নেয়া হয়। এই নন-লিনিয়ার ট্রান্সফর্মেশনের ফলাফল $\boldsymbol h$ দ্বারা প্রকাশ করা হয়েছে, যা এখানে একটি **হিডেন** আউটপুট বুঝাচ্ছে, *অর্থাৎ,* যা নেটওয়ার্কের বাইরে থেকে **দেখা** যায়না। এরপর এই অউটপুটটিকে আরেকটি এফাইন ট্রান্সফরমেশন এবং আরেকটি নন-লিনিয়ার ট্রান্সফরমেশনের মধ্য দিয়ে নেয়া হয়। এটিই আমাদের সর্বশেষ আউটপুট $\boldsymbol{\hat{y}}$ তৈরী করে। এই নেটওয়ার্কটিকে আমরা নিচের **সমীকরণ ২** দ্বারা গাণিতিকভাবে প্রকাশ করতে পারি। $f$ এবং $g$ উভয় দ্বারাই নন-লিনিয়ারিটি বুঝানো হয়েছে।

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>সমীকরণ ২</b> একটি FC নেটওয়ার্কের গাণিতিক রূপ</center>

<!-- A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax. -->
উপরে যেমনটি দেখানো হয়েছে এরূপ সাধারণ একটি নিউরাল নেটওয়ার্ক কেবলই মাত্র সাক্সেসিভ পেয়ার্স (ধারাবাহিক যুগলের/জোড়ার) সমষ্টি, যার প্রতিটি পেয়ার এ (জোড়ায়) থাকে একটি এফাইন ট্রান্সফরমেশন এবং একটি নন-লিনিয়ার অপারেশন (স্কোয়াশিং)। নন-লিনিয়ার ফাংশন হিসেবে বেশিরভাগ ব্যবহৃত ফাংশনগুলো হচ্ছে রেলু (ReLU), সিগময়ড (sigmoid), হাইপারবোলিক টেনজেন্ট (hyperbolic tangent) এবং সফটম্যাক্স (softmax)।

<!-- The network shown above is a 3-layer network: -->
উপরে উল্লেখিত নেটওয়ার্কটি হচ্ছে একটি ৩-লেয়ার বিশিষ্ট নেটওয়ার্ক"

 <!-- 1. input neuron
 2. hidden neuron
 3. output neuron -->
 1. ইনপুট নিউরন
 2. হিডেন নিউরন
 3. আউটপুট নিউরন

<!-- Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extended to a $n$-layer network. -->
অতএব, একটি $৩$-লেয়ার বিশিষ্ট নেটওয়ার্কের মধ্যে $২$ টি এফাইন ট্রান্সফরমেশন সংগঠিত হয়। এই ধারণাটি একটি $n$-লেয়ার বিশিষ্ট নেটওয়ার্কের ক্ষেত্রেও ভাবা যেতে পারে।

চল আরেকটু জটিল অবস্থায় যাওয়া যাক।

<!-- Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5** -->
৩ টি হিডেন লেয়ারের জন্য ভেবে দেখো, যার প্রতিটি লেয়ারই ফুল্লি কানেক্টেড। **চিত্র ৫** এ  এটি ছবি আকারে প্রকাশ করা হয়েছে।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>চিত্র ৫</b> ৩ টি হিডেন লেয়ার বিশিষ্ট নিউরাল নেট
</center>

<!-- Let's consider a neuron $j$ in the second layer. It's activation is: -->
২য় লেয়ারের $j$ নিউরনের কথা ধরে নেয়া যাক। এর এক্টিভেশন হচ্ছে:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

<!-- where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$. -->
যেখানে $\vect{w}^{(j)}$ হচ্ছে $\vect{W}^{(1)}$ এর $j$-তম সারি (row)

<!-- Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, *etc*. -->
খেয়াল কর, এখানে ইনপুট লেয়ারের এক্টিভেশন হচ্ছে আইডেন্টিটি। অপরদিকে, হিডেন লেয়ারগুলোতে রেলু (ReLU), সিগময়ড (sigmoid), হাইপারবোলিক টেনজেন্ট (hyperbolic tangent) এবং সফটম্যাক্স (softmax) এর মতো *ইত্যাদি* এক্টিভেশন থাকতে পারে।

<!-- The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post. -->
শেষ লেয়ারের এক্টিভেশন সাধারণত তোমার নির্দিষ্ট ব্যবহার এর উপর নির্ভর করে, যেমনটি [এই](https://piazza.com/class/k5spqaanqk51ks?cid=36) পিয়াজ্জা পোস্টে বোঝানো হয়েছে।


<!-- ## Neural network (inference) -->
## নিউরাল নেটওয়ার্ক (ইনফারেন্স)

<!-- Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6** -->
আরেকবার তিনটি লেয়ার (ইনপুট, হিডেন, আউটপুট) বিশিষ্ট নিউরাল নেটওয়ার্কের কথা চিন্তা করা যাক, **চিত্র ৬** এ যেভাবে দেখানো হয়েছে।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>চিত্র ৬</b> তিনটি লেয়ার বিশিষ্ট নিউরাল নেটওয়ার্ক
</center>

<!-- What kind of functions are we looking at? -->
এই নেটওয়ার্কের ফাংশনরূপ দেখতে কেমন?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

<!-- However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as: -->
তবে, এখানে যে একটি হিডেন লেয়ার রয়েছে এটি ভিজুয়ালাইজ করলে আমাদের সুবিধা হবে, এবং এর ম্যাপিং টিকে এভাবে প্রকাশ করা যেতে পারে:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<!-- What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$). -->
উপরিউক্ত পরিস্থিতির জন্য একটি উদাহরণ কেমন হতে পারে? এই ক্ষেত্রে, ইনপুট ডাইমেনশন হবে দুই ($n=2$), একটি হিডেন লেয়ার রয়েছে সেটির ডাইমেনশন ১000 ($d = 1000$),  এবং ৩টি ক্লাস রয়েছে ($C=3$)। একটি হিডেন লেয়ারে অনেক বেশি নিউরন না রাখার কিছু ভালো ব্যবহারিক কারণ রয়েছে, তাই আমরা এই একটি হিডেন লেয়ারকে ১0 নিউরন বিশিষ্ট ৩টি হিডেন লেয়ারে রূপান্তর করতে পারি ($1000 \rightarrow 10 \times 10 \times 10$)।


<!-- ## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s) -->
## [নিউরাল নেটওয়ার্ক (ট্রেনিং ১)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

<!-- So what does typical training look like? It is helpful to formulate this into the standard terminology of losses. -->
সাধরণত ট্রেনিং এর ধাপটি কেমন? এটাকে বোধগম্য হওয়ার জন্য আমরা লস এর পরিভাষায় বুঝার চেষ্টা করতে পারি।

<!-- First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm). -->
প্রথমে, চলো সফ্ট (আর্গ) ম্যাক্স এর সাথে আমরা পুনরায় পরিচিত হই এবং সাধারণভাবে এটিই শেষ লেয়ারের এক্টিভেশন থাকে, যখন নেগেটিভ লগ-লাইকলিহুড লস হিসেবে ব্যবহার করি, দুই এর অধিক ক্লাস প্রেডিকশনের ক্ষেত্রে। যেমনটি প্রফেসর লেকুন (LeCun) তার লেকচারে বলেছেন, এটি ব্যবহারের কারণ হচ্ছে এভাবে আমরা সিগময়েড এবং স্কয়ার লসের থেকে আরো ভালো গ্রেডিয়েন্ট পেতে পারি, একইসাথে আমাদের শেষ লায়েরটিও নর্মালাইজ্ড হয়ে যাবে (অর্থাৎ, শেষ লেয়ারের সকল নিউরনের যোগফল ১ হয়), আলাদা করে নর্ম দিয়ে ভাগ করে শেষ লেয়ারটিকে নর্মালাইজ করার থেকে এটি গ্রেডিয়েন্ট মেথডগুলোর জন্য আরো ভালো।

<!-- The soft (arg)max will give you logits in the last layer that look like this: -->
সফ্ট (আর্গ) ম্যাক্স তোমাকে শেষ লেয়ারে যেই লজিট্সগুলো দিবে সেটি দেখতে অনেকটা এরকম:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

<!-- It is important to note that the set is not closed because of the strictly positive nature of the exponential function. -->
এখানে গুরুত্বপূর্ণ উল্লেখিত বিষয়টি হচ্ছে এক্সপোনেন্সিয়াল ফাংশনের কঠোর ধনাত্মক (পজিটিভ) প্রকৃতির কারণে সেটটি ক্লোস্ড নয়।

<!-- Given the set of the predictions $\matr{\hat{Y}}$, the loss will be: -->
$\matr{\hat{Y}}$ সেট প্রেডিকশনের জন্য, লস হবে:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

<!-- Here $c$ denotes the integer label, not the one hot encoding representation. -->
এখানে $c$ দ্বারা ওয়ান-হট এনকোডিং নয় বরং ইন্টিজার লেবেল বুঝানো হয়েছে

<!-- So let's do two examples, one where an example is correctly classified, and one where it is not. -->
তাহলে, চলো দুটো উদাহরণ দেখে নেয়া যাক, যেখানে একটিতে ডাটা লেবেল সঠিকভাবে ক্লাসিফাই করা হয়েছে এবং আরেকটিতে সঠিকভাবে ক্লাসিফাই করা হয়নি।

<!-- Let's say -->
ধরে নেয়া যাক

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

<!-- What is the instance wise loss? -->
একেকটি ইনস্ট্যান্স এর জন্য লস?

<!-- For the case of *nearly perfect prediction* ($\sim$ means *circa*): -->
*কাছাকাছি নির্ভুল প্রেডিকশন* এর জন্য ($\sim$ দিয়ে *প্রায়* বুঝানো হয়েছে):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

<!-- For the case of *nearly absolutely wrong*: -->
*কাছাকাছি সম্পূর্ণ ভুল প্রেডিকশন* এর জন্য:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

<!-- Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think. -->
খেয়াল কর, উপরের উদাহরণটিতে $\sim 0 \rightarrow 0^{+}$ এবং $\sim 1 \rightarrow 1^{-}$। এরকমটি কেন হয়েছে? এক মিনিট ভেবে দেখ।

<!-- **Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice! -->
**মনে রেখো:** এটি জানা গুরুত্বপূর্ণ যে তুমি যদি `CrossEntropyLoss` ব্যবহার করো, তাহলে তুমি `LogSoftMax` এবং নেগেটিভ লগ লাইকলিহুড `NLLLoss` উভয়ই একসাথে পাবে, তাই এটি দুইবার করতে যেওনা!


## [নিউরাল নেটওয়ার্ক (ট্রেনিং ২)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

<!-- For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as: -->
ট্রেনিং এর জন্য, আমরা সকল ট্রেইনেবল প্যারামিটারগুলোকে -- ওয়েট ম্যাট্রিস এবং বায়াসগুলো -- একটি সমষ্টি আকারে একত্রিত করি, যেটিকে আমরা বলতে পারি $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$ এখন অবজেক্টিভ ফাংশনটিকে আমরা এভাবে লিখতে পারি:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

<!-- This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem. -->
এটি আমাদের নেটওয়ার্কের লসকে আউটপুটের উপর ডিপেন্ডেন্ট করে তোলে $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, তাই আমরা এখন এটিকে একটি অপটিমাইজেশন প্রব্লেমে রূপান্তর করতে পারি।

<!-- A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$. -->
এটি কিভাবে কাজ করে তার একটি সংক্ষিপ্ত রূপ **চিত্র ৭** এ তুলে ধরা হয়েছে, যেখানে $J(\vartheta)$ হচ্ছে ঐ ফাংশন যা আমরা মিনিমাইজ (হ্রাস) করবো এবং এর কেবল একটি স্কেলার প্যারামিটার $\vartheta$ রয়েছে।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>চিত্র ৭</b> গ্রেডিয়েন্ট ডিসেন্ট দিয়ে একটি লস ফাংশন অপ্টিমাইজ করা
</center>

<!-- We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$. -->
প্রথমে আমরা একটি রেন্ডম ইনিশিয়ালাইজেশন পয়েন্ট ধরবো $\vartheta_0$ -- ঐ পয়েন্টের লস হচ্ছে $J(\vartheta_0)$। এখন, ঐ পয়েন্টের আমরা ডেরিভেটিভ বের করতে পারি $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$। এক্ষেত্রে, ডেরিভেটিভটির স্লোপ (ঢাল) পজিটিভ। তাই আমাদেরকে স্টিপেস্ট ডিসেন্ট (সর্বোচ্চ নিম্নগামী) পথের দিকে এগোতে হবে। এক্ষেত্রে সেটি হচ্ছে $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$

<!-- The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network. -->
এই প্রক্রিয়াটির পর্যায়ক্রমিক পুনরাবৃত্তিই গ্রেডিয়েন্ট ডিসেন্ট নামে পরিচিত। গ্রেডিয়েন্ট মেথডগুলোই নিউরাল নেটওয়ার্ক ট্রেন করার প্রাথমিক টুল

<!-- In order to compute the necessary gradients, we have to use back-propagation -->
প্রয়োজনীয় গ্রেডিয়েন্টগুলো বের করার জন্য আমাদেরকে ব্যাকপ্রোপাগেশন ব্যবহার করতে হবে।

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$


<!-- ## Spiral classification - Jupyter notebook -->
## স্পাইরাল ক্লাসিফিকেশন - জুপিটার নোটবুক

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md). -->
জুপিটার নোটবুকটি [এখানে](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb) পেয়ে যাবে। নোটবুকটি রান করতে হলে, নিশ্চিত করবে যাতে `the dl-minicourse` এনভায়রনমেন্টটি ইনস্টল করা থাকে যেমনটি [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md) তে বলা হয়েছে।

`torch.device()` কিভাবে ব্যবহার করতে হবে তার একটি ব্যাখ্যা [গত সপ্তাহের নোট](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/) এ পাওয়া যাবে।

<!-- Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels -- in red, yellow and blue -- as can be seen in **Fig. 8**. -->
আগের মতোই,  আমরা $\mathbb{R}^2$ এর পয়েন্টগুলো নিয়ে কাজ করবো যেখানে তিনটি ভিন্ন লেবেল -- লাল, হলুদ, নীল -- রয়েছে, যেমনটি **চিত্র ৮** এ তোমরা দেখতে পারো।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>চিত্র ৮</b> স্পাইরাল ক্লাসিফিকেশনের ডাটা
</center>

<!-- `nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html). -->
`nn.Sequential()` টি হচ্ছে একটি ধারক, যেটি মডিউলগুলোকে যেই ক্রমে যোগ করা হয়েছে সেই একই ক্রমে কন্সট্রাক্টরে পাঠায়; `nn.linear()` নামটি বলা যায় একটু বিভ্রান্তিকর কেননা এটি এখানে পাঠানো ডাটাকে **এফাইন** ট্রান্সফরমেশনের মধ্য দিয়ে নেয়: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$। আরও জানতে, [পাইটর্চ ডকুমেন্টেশন](https://pytorch.org/docs/stable/nn.html) দেখতে পারো।

<!-- Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing. -->
মনে রাখবে, একটি এফাইন ট্রান্সফরমেশনের মাধ্যমে ৫টি রূপান্তর সম্ভব: রোটেশন, রিফ্লেকশন, ট্রান্সলেশন, স্কেলিং, শিয়ারিং।

যেমনটি **চিত্র ৯** এ দেখা যাচ্ছে, যখন স্পাইরাল ডাটাকে লিনিয়ার ডিসিশন বাউন্ডারির মাধ্যমে আলাদা করার চেষ্টা হয় - মাঝখানে কোনো নন-লিনিয়ারিটি না রেখে শুধুমাত্র `nn.linear()` মডিউল ব্যবহার করে - সর্বোচ্চ আমরা যেটি পেতে পারি সেটি হচ্ছে $৫0\%$ একুরেসি এর বেশি নয়।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>চিত্র ৯</b> লিনিয়ার ডিসিশন বাউন্ডারিগুলো
</center>

<!-- When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**. -->
যখন আমরা এই একটি লিনিয়ার মডেল থেকে সরে এসে দুইটি `nn.linear()` মডিউল এবং মাঝখানে একটি `nn.ReLU()` সম্পন্ন মডেল ব্যবহার করি, একুরেসি $৯৫\%$ পর্যন্ত অর্জন করা যায়। এর কারণ হচ্ছে আমাদের ডিসিশন বাউন্ডারি তখন নন-লিনিয়ার হয়ে যায় যা স্পাইরাল আকৃতির ডাটা এর জন্য অনেক উপযোগী, যেমনটি **চিত্র ১0** এ দেখা যাচ্ছে।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>চিত্র ১0</b> নন-লিনিয়ার ডিসিশন বাউন্ডারিগুলো
</center>

<!-- An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression. -->
একটি রিগ্রেশন প্রব্লেম যেটি লিনিয়ার রিগ্রেশন ব্যবহার করে সঠিকভাবে সমাধান করা সম্ভব হয়না, তবে নিউরাল নেটওয়ার্ক ব্যবহার করে সহজেই সমাধান করে ফেলা যায়, এর একটি উদাহরণ তোমরা [এই নোটবুকটিতে](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) পাবে এবং **চিত্র ১১** তে, ১০টি ভিন্ন নেটওয়ার্ক তুলে ধরা হয়েছে, যার মধ্যে ৫ টিতে রয়েছে একটি করে `nn.ReLU()` ফাংশন এবং অপর ৫ টিতে একটি করে `nn.Tanh()`। এখানে প্রথমটি হচ্ছে একটি পিসওয়াইস লিনিয়ার ফাংশন এবং পরেরটি হচ্ছে একটি কন্টিনিউয়াস ও স্মুথ (মসৃণ) রিগ্রেশন।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>চিত্র ১১</b>: ১০টি নিউরাল নেটওয়ার্কস, সাথে সেগুলোর ভ্যারিয়েন্স এবং স্ট্যান্ডার্ড ডেভিয়েশন<br>
বামে: ৫টি <code>ReLU</code> নেটওয়ার্কস।  ডানে: ৫টি <code>tanh</code> নেটওয়ার্কস।
</center>

<!-- The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" -- since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$. -->
হলুদ এবং সবুজ রেখাগুলো নেটওয়ার্কগুলোর ভ্যারিয়েন্স এবং স্ট্যান্ডার্ড ডেভিয়েশন দেখাচ্ছে। "কনফিডেন্স ইন্টারভাল" এর মতোই এগুলোও আমাদের জন্য কার্যকরী -- যেহেতু ফাংশনগুলো প্রতিটি আউটপুটের জন্য কেবল একটিই প্রেডিকশন দেয়, সেহেতু অনসম্বল ভ্যারিয়েন্স প্রেডিকশন ব্যবহারের মাধ্যমে আমরা অনুমান করতে পারি অনিশ্চয়তার সাথে প্রেডিকশনগুলো করা হচ্ছে। এর গুরুত্ব আমরা **চিত্র ১২** তে দেখতে পাই, যেখানে আমরা ডিসিশন ফাংশনগুলোকে ট্রেনিং ইন্ট্রারভাল (ট্রেনিং এর ক্ষেত্র) এর বাইরে বর্ধিত করি যা $+\infty, -\infty$ পর্যন্ত বিস্তৃত।

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>চিত্র ১২</b> নিউরাল নেটওয়ার্কস, সাথে সেগুলোর ভ্যারিয়েন্স এবং স্ট্যান্ডার্ড ডেভিয়েশন, ট্রেনিং ইন্টারভাল এর বাইরে<br>
বামে: ৫টি <code>ReLU</code> নেটওয়ার্কস।  ডানে: ৫টি <code>tanh</code> নেটওয়ার্কস।
</center>

<!-- To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop: -->
পাইটর্চ দিয়ে যেকোনো নিউরাল নেটওয়ার্ক ট্রেন করতে চাইলে, তোমাকে ট্রেনিং লুপে ৫টি মৌলিক ধাপ নিশ্চিত করতে হবে:

<!-- 1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$. -->
১. `output = model(input)` হচ্ছে মডেলের ফরওয়ার্ড পাস্ , যা ইনপুট নেয় এবং আউটপুট তৈরী করে।

২. `J = loss(output, target <or> label)` মডেলের আউটপুট কে নিয়ে প্রকৃত টার্গেট অথবা লেবেলের সাপেক্ষে ট্রেনিং লস বের করে।

৩. `model.zero_grad()` পূর্ববর্তী গ্রাডিয়েন্টসগুলোকে মুছে দেয়, যাতে করে সেগুলো পরবর্তী বারে একত্রিত না হয়ে যায়।

৪. `J.backward()` ব্যাকপ্রোপাগেশন এবং একত্রীকরণ: এটি প্রতিটি ভ্যারিয়েবল $\texttt{x}$ যার জন্য আমরা `requires_grad=True` করেছি সেগুলোর $\nabla_\texttt{x} J$ বের করে। এরপর এগুলো প্রতিটি ভ্যারিয়েবলের গ্রেডিয়েন্ট হিসেবে একত্র করা হয়: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.

৫. `optimiser.step()` গ্রাডিয়েন্ট ডিসেন্ট এ এক ধাপ অগ্রসর হয়: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.


<!-- When training a NN, it is very likely that you need these 5 steps in the order they were presented. -->
একটি NN (নিউরাল নেটওয়ার্ক) ট্রেনিং এর সময় বেশির সম্ভাবনা রয়েছে যে তোমার এই ৫টি ধাপ উপরিউক্ত ক্রমেই ব্যবহার করতে হবে।