---
lang-ref: ch.02-1
lecturer: Yann LeCun
title: গ্রেডিয়েন্ট ডিসেন্ট এবং ব্যাকপ্রোপ্যাগেশন অ্যালগরিদম
authors: Amartya Prasad, Dongning Fang, Yuxin Tang, Sahana Upadhya
date: 3 Feb 2020
lang: bn
translation-date: 11 Dec 2020
translator: Khalid Saifullah
---


## [গ্রেডিয়েন্ট ডিসেন্ট অপ্টিমাইজেশন অ্যালগরিদম](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)


### প্যারামেট্রাইজড মডেল

$$
\bar{y} = G(x,w)
$$

<!-- Parametrised models are simply functions that depend on inputs and trainable parameters. There is no fundamental difference between the two, except that trainable parameters are shared across training samples whereas the input varies from sample to sample. In most deep learning frameworks, parameters are implicit, that is, they aren't passed when the function is called. They are 'saved inside the function', so to speak, at least in the object-oriented versions of models. -->
প্যারামেট্রাইজড মডেলগুলি এমন ফাংশন যা কেবল ইনপুট এবং ট্রেইনেবল প্য়ারামিটারগুলির উপর নির্ভর করে। ট্রেইনেবল প্য়ারামিটারগুলি ট্রেইনিং স্য়ম্পল এর মধ্যে শেয়ার করা হয় যেখানে ইনপুট স্য়ম্পল থেকে স্য়ম্পল এ পরিবর্তিত হয়, উভয়ের মধ্যে এছাড়া তেমন কোনও মৌলিক পার্থক্য নেই। বেশিরভাগ ডীপ লার্নিং ফ্রেমওয়ার্কগুলিতে প্যারামিটারগুলি অন্তর্নিহিত হয়, অর্থাৎ ফাংশনটি কল করার সময় সেগুলো পাস্ করা হয় না। এগুলিকে ফাংশনেরই একটি অংশ হিসেবে ভাবা হয়, অন্তত  অবজেক্ট অরিয়েন্টেড মডেলগুলোতে তাই করা হয়ে থাকে।

<!-- The parametrised model (function) takes in an input, has a parameter vector and produces an output. In supervised learning, this output goes into the cost function ($C(y,\bar{y}$)), which compares the true output (${y}$) with the model output ($\bar{y}$). The computation graph for this model is shown in Figure 1. -->
প্যারামেট্রাইজড মডেল (ফাংশন) একটি ইনপুট নেয়, এছাড়া এর একটি প্যারামিটার ভেক্টর থাকে এবং এটি একটি আউটপুট দেয়। সুপারভাইজড লার্নিং এ, এই আউটপুটটিকে এরপর কস্ট ফাংশন ($C(y,\bar{y}$)) এ পাঠানো হয় যা মডেল এর আউটপুট ($\bar{y}$) টিকে লেবেল/গ্রাউন্ড ট্রুথ (${y}$) এর সাথে তুলনা করে। এই মডেলটির কম্পিউটেশন গ্রাফ চিত্র ১ এ তুলে ধরা হয়েছে।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>চিত্র ১: একটি প্যারামেট্রাইজড মডেল এর কম্পিউটেশন গ্রাফ</center>|

<!-- Examples of parametrised functions -

- Linear Model - Weighted Sum of Components of the Input Vector :

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- Nearest Neighbour - There is an input $\vect{x}$ and a weight matrix $\matr{W}$ with each row of the matrix indexed by $k$. The output is the value of $k$ that corresponds to the row of $\matr{W}$ that is closest to $\vect{x}$:

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  Parameterized models could also involve complicated functions. -->
প্যারামেট্রাইজড ফাংশন এর উদাহরণ  -

- লিনিয়ার মডেল - ইনপুট ভেক্টরের উপাদানগুলির ওয়েটেড সাম / সুষম যোগ :

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- নিয়ারেস্ট নেইবার - এর ইনপুট হচ্ছে ইনপুট ভেক্টর $\vect{x}$ এবং ওয়েট ম্যাট্রিক্স $\matr{W}$ যার প্রতিটি সারি $k$ দ্বারা সূচিত (ইন্ডেক্সড)। $\matr{W}$ এর যেই সারি $\vect{x}$ এর সবচেয়ে নিকটবর্তী সেই সারির $k$ এর মান ই এই ফাংশন এর আউটপুট:

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  জটিল ফাংশনগুলোও প্যারামিটারাইজড মডেল এর অন্তর্ভুক্ত হতে পারে।


#### কম্পিউটেশন গ্রাফগুলোর জন্য ব্লক ডায়াগ্রাম নোটেশন
<!--
- Variables (tensor, scalar, continuous, discrete)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> is an observed input to the system
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> is a computed variable which is produced by a deterministic function

- Deterministic functions

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - Takes in multiple inputs and can produce multiple outputs
    - It has an implicit parameter variable (${w}$)
    - The rounded side indicates the direction in which it is easy to compute. In the above diagram, it is easier to compute ${\bar{y}}$ from ${x}$ than the other way around

- Scalar-valued function

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - Used to represent cost functions
    - Has an implicit scalar output
    - Takes multiple inputs and outputs a single value (usually the distance between the inputs) -->

- ভ্যারিয়েবল/চলক (টেনসর, স্কেলার, কন্টিনিউয়াস/অবিচ্ছিন্ন, ডিসক্রিট)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> হচ্ছে সিস্টেম এর একটি ইনপুট
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> হচ্ছে একটি ডিটারমিনিস্টিক ফাংশন থেকে প্রাপ্ত গণনামূলক ভেরিয়েবল

- ডিটারমিনিস্টিক ফাংশন

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - একাধিক ইনপুট গ্রহণ করে এবং একাধিক আউটপুট দিতে পারে
    - এটিতে একটি অন্তর্নিহিত প্যারামিটার ভেরিয়েবল রয়েছে (${w}$)
    - বৃত্তাকার দিকটি সেই দিক নির্দেশ করে যেখানে এটির মান পাওয়া সহজ। উপরের চিত্রটিতে, ${x}$ থেকে ${\bar{y}}$ গণনা করা সহজ

- স্কেলার-ভ্যালু ফাংশন

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - কস্ট ফাংশন প্রকাশে ব্যাবহৃত হয়
    - একটি অন্তর্নিহিত স্কেলার আউটপুট রয়েছে
    - একাধিক ইনপুট নেয় এবং একক মান আউটপুট দেয় (যা সাধারণত ইনপুটগুলির মধ্যে দূরত্ব)


#### লস ফাংশন

<!-- Loss function is a function that is minimized during training. There are two types of losses:

1) Per Sample Loss -

$$
 L(x,y,w) = C(y, G(x,w))
$$

2) Average Loss -

For any set of Samples

$$S = \lbrace(x[p],y[p]) \mid p \in \lbrace 0, \cdots, P-1 \rbrace \rbrace$$

Average Loss over the Set $S$ is given by:

$$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$ -->
লস ফাংশন এমন একটি ফাংশন যার মান ট্রেইনিং এর সময় হ্রাস করা হয়। লস ২ রকমের হয়ে থাকে:

1) স্যাম্পল প্রতি লস -

$$
 L(x,y,w) = C(y, G(x,w))
$$

2) এভারেজ/গড় লস -

স্যাম্পলগুলোর যেকোনো সেট এর জন্য

$$S = \lbrace(x[p],y[p]) \mid p \in \lbrace 0, \cdots, P-1 \rbrace \rbrace$$

সেট $S$ এর জন্য এভারেজ/গড় লস হচ্ছে:

$$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>চিত্র ২: এভারেজ/গড় লস সংবলিত মডেল এর জন্য কম্পিউটেশন গ্রাফ    </center>|

<!-- In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent. -->
স্ট্যান্ডার্ড সুপারভাইজড লার্নিং প্যারাডাইম এ, লস (স্যাম্পল প্রতি) হচ্ছে কেবল কস্ট ফাংশন এর আউটপুট। মেশিন লার্নিং বেশিরভাগই অপ্টিমাইজিং ফাংশন গুলোকে ঘিরেই হয়ে থাকে (সাধারণত সেগুলোকে মিনিমাইজ/হ্রাস করার ব্যাপারে)। ২ টি ফাংশন এর মধ্যকার ন্যাশ ইকুইলিব্রিয়া খুঁজে বের করাও এর অন্তর্ভুক্ত হতে পারে, যেমনটি GANs এর ক্ষেত্রে। এটি একমাত্র গ্রেডিয়েন্ট ডিসেন্ট ই নয়, বরং গ্রেডিয়েন্ট বেসড মেথডিগুলোর মাধ্যমে করা হয়।


### গ্রেডিয়েন্ট ডিসেন্ট

<!-- A **Gradient Based Method** is a method/algorithm that finds the minima of a function, assuming that one can easily compute the gradient of that function. It assumes that the function is continuous and differentiable almost everywhere (it need not be differentiable everywhere). -->
**গ্রেডিয়েন্ট বেসড মেথড** হ'ল একটি পদ্ধতি / অ্যালগরিদম যা কোনও ফাংশনের মিনিমা খুঁজে বের করে, যদি ধরে নেওয়া যায় যে ঐ ফাংশনটির গ্রেডিয়েন্ট কেউ সহজেই বের করতে পারে। অ্যালগরিদমটি ধরে নেয় যে ফাংশনটি সবজায়গায় কন্টিনিউয়াস এবং ডিফারেনশিয়েবল (যদিও এটি সর্বত্র কন্টিনিউয়াস হওয়ার দরকার নেই)।

<!-- **Gradient Descent Intuition** - Imagine being in a mountain in the middle of a foggy night. Since you want to go down to the village and have only limited vision, you look around your immediate vicinity to find the direction of steepest descent and take a step in that direction. -->
**গ্রেডিয়েন্ট ডিসেন্ট এর ধারণা** - মনে কর একটি কুয়াশাচ্ছন্ন রাতে তুমি কোনো একটি পাহাড়ের উপর দাঁড়িয়ে আছো। যেহেতু তুমি পাহাড় থেকে নেমে নিচের জনবসতি এলাকায় যেতে চাও এবং তুমি চোঁখে তেমন কিছু দেখতে পাচ্ছনা তাহলে তুমি কি করবে? তুমি তোমার পায়ের কাছের সবচেয়ে নিম্নগামী যেই পথটি আছে সেদিকে পা বাড়াবে। গ্রেডিয়েন্ট ডিসেন্ট ও একই কাজ টি করে থাকে।

<!--
**Different methods of Gradient Descent**

- Full (batch) gradient descent update rule :

  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

- For SGD (Stochastic Gradient  Descent), the update rule becomes :

  - Pick a $p \in \lbrace 0, \cdots, P-1 \rbrace$, then update

    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

Where ${w}$ represents the parameter to be optimized.

$\eta$ is a constant here but in more sophisticated algorithms, it could be a matrix. -->
**গ্রেডিয়েন্ট ডিসেন্ট এর বিভিন্ন মেথড**

- পূর্ণ (ব্যাচ) গ্রেডিয়েন্ট ডিসেন্ট আপডেট রুল :

  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

- SGD (স্টোকাস্টিক গ্রেডিয়েন্ট ডিসেন্ট) এর আপডেট রুল :

  - যেকোনো একটি $p \in \lbrace 0, \cdots, P-1 \rbrace$ ধরে নাও, এরপর আপডেট কর

    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

যেখানে ${w}$ হচ্ছে প্যারামিটার যা আমরা অপ্টিমাইজ করছি

$\eta$ এখানে একটি ধ্রুবক তবে আরও জটিল অ্যালগরিদমে এটি ম্যাট্রিক্স হতে পারে।

<!-- If it is a positive semi-definite matrix, we'll still move downhill but not necessarily in the direction of steepest descent. In fact the direction of steepest descent may not always be the direction we want to move in. -->
যদি এটি একটি পজিটিভ সেমি-ডেফিনিট ম্যাট্রিক্স হয়, সেক্ষেত্রেও আমরা নিম্নগামী পথেই অগ্রসর হবো তবে সেই পথটি সর্বোচ্চ নিম্নগামী (স্টিপেস্ট ডিসেন্ট) এর দিকে নাও হতে পারে। এমনকি সর্বোচ্চ নিম্নগামী (স্টিপেস্ট ডিসেন্ট) দিক আমাদের সবসময় প্রধান পছন্দ নাও হতে পারে।

<!-- If the function is not differentiable, i.e, it has a hole or is staircase like or flat, where the gradient doesn't give you any information, one has to resort to other methods - called 0-th Order Methods or Gradient-Free Methods. Deep Learning is all about Gradient Based Methods. -->
যদি ফাংশনটি ডিফারেনশিয়েবল না হয়, অর্থাৎ এর গর্ত থাকে বা দেখতে সিঁড়ির মতো বা সমতল হয় যেখানে গ্রেডিয়েন্ট তোমাকে কোনও তথ্য দেয় না, তখন অন্য পদ্ধতি অবলম্বন করতে হয় - যার নাম 0-th Order Methods বা গ্রেডিয়েন্ট-ফ্রি মেথডস। ডিপ লার্নিং সম্পূর্ণ গ্রেডিয়েন্ট-বেসড মেথডস নিয়ে।

<!-- However, RL (Reinforcement Learning) involves **Gradient Estimation** without the explicit form for the gradient. An example is a robot learning to ride a bike where the robot falls every now and then. The objective function measures how long the bike stays up without falling. Unfortunately, there is no gradient for the objective function. The robot needs to try different things. -->
যদিও, RL (Reinforcement Learning) এ আমরা সরাসরি গ্রেডিয়েন্ট না বের করে **গ্রেডিয়েন্ট অনুমান** পদ্ধতি ব্যবহার করে থাকি. উদাহরণস্বরূপ ধরা যাক একটি রোবট বাইক চালানো শিখছে, এবং একটু পরপর রোবটটি পরে যাচ্ছে। এখানে আমাদের অবজেক্টিভ ফাংশনটি দেখে যে বাইকটি কতক্ষন না পড়ে দাঁড়িয়ে আছে। কিন্তু দুর্ভাগ্যবশত আমাদের এই অবজেক্টিভ ফাংশন এর কোনো গ্রেডিয়েন্ট নেই। তাই রোবট টিকে বিভিন্ন উপায়ে চেষ্টা করে যেতে হবে।

<!-- The RL cost function is not differentiable most of the time but the network that computes the output is gradient-based. This is the main difference between supervised learning and reinforcement learning. With the latter, the cost function $C$ is not differentiable. In fact it completely unknown. It just returns an output when inputs are fed to it, like a blackbox. This makes it highly inefficient and is one of the main drawbacks of RL - particularly when the parameter vector is high dimensional (which implies a huge solution space to search in, making it hard to find where to move). -->
RL এর কস্ট ফাংশনটি বেশিরভাগ সময়ই ডিফারেনশিয়েবল হয় না তবে যেই নেটওয়ার্কটি আউটপুট দেয় সেটি গ্রেডিয়েন্ট বেসড। এটাই সুপারভাইজড লার্নিং এর সাথে রিইনফোর্সমেন্ট লার্নিং (RL) এর প্রধান পার্থক্য। শেষেরটিতে কস্ট ফাংশন ডিফারেনশিয়েবল নয়. এমনকি এটা সম্পূর্ণ অজানা। এটিতে কোনো ইনপুট দিলে, শুধুমাত্র আমরা আউটপুট পেয়ে থাকি, যা অনেকটা ব্ল্যাকবক্স এর মতো। এটিই RL এর অনেক বড় একটি অসুবিধা যা এটাকে অনেক ইনএফিসিয়েন্ট করে তোলে, বিশেষ করে যখন প্যারামিটার ভেক্টরটি হাই ডাইমেনশনাল হয় (যা আমাদের সমাধানের জায়গাকে (সল্যুশন স্পেস) অনেক বড় করে তোলে, ফলে যে কোনো দিকেই আগানো অনেক কঠিন হয়ে যায়)।

<!-- A very popular technique in RL is Actor Critic Methods. A critic method basically consists of a second C module which is a known, trainable module. One is able to train the C module, which is differentiable, to approximate the cost function/reward function. The reward is a negative cost, more like a punishment. That’s a way of making the cost function differentiable, or at least approximating it by a differentiable function so that one can backpropagate. -->
RL এর খুব জনপ্রিয় একটি টেকনিক হচ্ছে আর্কটিক ক্রিটিক মেথডস। আর্কটিক ক্রিটিক মেথডটিতে দ্বিতীয় আরেকটি C মডিউল যুক্ত থাকে যেটি একটি জানা, ডিফারেনশিয়েবল এবং ট্রাইনেবল মডিউল। তাই এই C মডিউল ব্যবহার করে কেউ চাইলে কস্ট ফাংশন / রিওয়ার্ড ফাংশন এর মান অনুমান করতে পারে। রিওয়ার্ড হচ্ছে একটি নেগেটিভ কস্ট যা অনেকটা পানিশমেন্ট এর মতো। এভাবেই আমরা কস্ট ফাংশনটিকে ডিফারেনশিয়েবল এ রূপান্তর করি অথবা আমরা অন্তত আমরা সেটার মান অনুমান করতে পারি অন্য একটি ডিফারেনশিয়েবল ফাংশন ব্যবহার করে যাতে করে আমরা ব্যাকপ্রোপাগেট করতে পারি।


## [নিউরাল নেটওয়ার্ক এর ক্ষেত্রে SGD এবং ব্যাকপ্রোপাগেসন এর সুবিধা](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)


### স্টোকাস্টিক গ্রেডিয়েন্ট ডিসেন্ট (SGD) এর সুবিধা

<!-- In practice, we use stochastic gradient to compute the gradient of the objective function w.r.t the parameters. Instead of computing the full gradient of the objective function, which is the average of all samples, stochastic gradient just takes one sample, computes the loss, $L$, and the gradient of the loss w.r.t the parameters, and then takes one step in the negative gradient direction. -->
আমরা স্টোকাস্টিক গ্রেডিয়েন্ট ডিসেন্ট (SGD) দিয়ে প্যারামিটারগুলোর সাপেক্ষে অবজেক্টিভ ফাংশন এর গ্রেডিয়েন্ট বের করে থাকি। অবজেক্টিভ ফাংশনটির পূর্ণ গ্রেডিয়েন্ট বের না করে SGD তে আমরা শুধু একটি স্যাম্পল নেই, যার জন্য লস $L$ বের করে সেই লস এর গ্রেডিয়েন্ট ক্যালকুলেট করি প্যারামিটারগুলোর সাপেক্ষে, এরপর আমরা সেই গ্রেডিয়েন্ট এর বিপরীত দিকে এক ধাপ অগ্রসর হই।

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

<!-- In the formula, $w$ is approached by $w$ minus the step-size, times the gradient of the per-sample loss function w.r.t the parameters for a given sample, ($x[p]$,$y[p]$). -->
ফর্মুলাটিতে $w$ এর আপডেট রুল দেখানো হয়েছে, যেখানে আমরা $w$ থেকে স্টেপ সাইজ ফ্র্যাকশন পরিমান প্যারামিটার এর সাপেক্ষে স্যাম্পল প্রতি লস ফাংশন এর গ্রেডিয়েন্ট যেকোনো একটি স্যাম্পল এর জন্য ($x[p]$,$y[p]$) বিয়োগ করছি।

<!-- If we do this on a single sample, we will get a very noisy trajectory as shown in Figure 3. Instead of the loss going directly downhill, it’s stochastic. Every sample will pull the loss towards a different direction. It’s just the average that pulls us to the minimum of the average. Although it looks inefficient, it’s much faster than full batch gradient descent at least in the context of machine learning when the samples have some redundancy. -->
আমরা যদি এটি শুধুমাত্র একটি স্যাম্পল এর জন্য করে থাকি তাহলে আমরা খুবই কোলাহলপূর্ণ ট্র্যাজেক্টরি পাবো যেমনটি চিত্র 3 এ দেখানো হয়েছে। লস সম্পূর্ণ নিম্নগামী পথ অনুসরণ এর বদলে স্টোকাস্টিক আচরণ করে। একেকটি স্যাম্পল একেক দিকে লস কে অগ্রসর করাবে। গড় মান টিই মূলত আমাদেরকে মিনিমা এর দিকে পাঠায়। যদিও এটা দেখতে প্রচুর ইনেফিশিয়েন্ট মনে হয়, তবে এটা ফুল ব্যাচ গ্রেডিয়েন্ট ডিসেন্ট এর থেকে অনেক বেশি দ্রুত অন্তত মেশিন লার্নিং এ যখন স্যাম্পল গুলোর মাঝে কিছু রিডান্ডেন্সি থাকে।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>চিত্র ৩: প্রতি স্যাম্পল আপডেট এর জন্য স্টোকাস্টিক গ্রেডিয়েন্ট ডিসেন্ট ট্র্যাজেক্টরি </center>|

<!-- In practice, we use batches instead of doing stochastic gradient descent on a single sample. We compute the average of the gradient over a batch of samples, not a single sample, and then take one step. The only reason for doing this is that we can make more efficient use of the existing hardware  (*i.e.* GPUs, multicore CPUs) if we use batches since it's easier to parallelize. Batching is the simplest way to parallelize. -->
কিন্তু আমরা একটি স্যাম্পল এ স্টোকাস্টিক গ্রেডিয়েন্ট ডিসেন্ট (SGD) ব্যবহার করার থেকে বরং একটি ব্যাচ এর উপর তা ব্যবহার করি। একটি স্যাম্পল এর জন্য গ্রেডিয়েন্ট ক্যালকুলেট না করে পুরো একটু ব্যাচ এর গড় গ্রেডিয়েন্ট ক্যালকুলেট করি, এরপর সেইদিকে এক পা এগুই। এটি করার একমাত্র কারণ হলো আমাদের বিদ্যমান হার্ডওয়্যার এর (অর্থাৎ GPUs, multicore CPUs) সর্বোচ্চ শক্তি কে কাজে লাগানো। কারণ ব্যাচ হচ্ছে আমাদের কাজ কে প্যারালাইজ করার সবচেয়ে সহজ পদ্ধতি।


### প্রচলিত নিউরাল নেটওয়ার্ক

<!-- Traditional Neural Nets are basically interspersed layers of linear operations and point-wise non-linear operations. For linear operations, conceptually it is just a matrix-vector multiplication. We take the (input) vector multiplied by a matrix formed by the weights. The second type of operation is to take all the components of the weighted sums vector and pass it through some simple non-linearity (*i.e.* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …). -->
প্রচলিত নিউরাল নেটওয়ার্কগুলো মূলত কিছু বিক্ষিপ্ত লেয়ার এর মধ্যকার লিনিয়ার অপারেশন এবং পয়েন্ট-ওয়াইজ নন-লিনিয়ার অপারেশন। লিনিয়ার অপারেশনটি হলো সহজভাবে বললে শুধুমাত্র ম্যাট্রিক্স-ভেক্টর গুণ। আমাদের ইনপুট ভেক্টরটিকে আমরা ম্যাট্রিক্স (যা ওয়েইট দিয়ে তৈরী) এর সাথে গুণ করি। দ্বিতীয় অপারেশনটি হচ্ছে এই ম্যাট্রিক্স-ভেক্টর গুণ করে পাওয়া সকল ওয়েইটেড সাম কে সাধারণ কোনো একটি নন-লিনিয়ারিটি এর মধ্য দিয়ে পাঠানো  (*যেমন* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>চিত্র ৪: প্রচলিত নিউরাল নেটওয়ার্ক             </center>|

<!-- Figure 4 is an example of a 2-layer network, because what matters are the pairs (i.e linear+non-linear). Some people call it a 3-layer network because they count the variables. Note that if there are no non-linearities in the middle, we may as well have a single layer because the product of two linear functions is a linear function. -->
চিত্র ৪ হলো একটি ২ লেয়ার বিশিষ্ট নেটওয়ার্ক এর উদাহরণ, কারণ এখানে গুরুত্বপূর্ণ বেপারটি হচ্ছে (লিনিয়ার + নন-লিনিয়ার) এর একত্রিত হওয়া। কেউ কেউ এটাকে ৩ লেয়ার বিশিষ্ট নেটওয়ার্ক ও বলতে পারে কারণ তারা ইনপুট ভ্যারিয়েবলটিকেও হিসাব করে। মনে রাখবে, যদি মধ্যকার লায়েরটিতে কোনো নন-লিনিয়ারিটি না থাকে তাহলে এটা ১ টি লেয়ার বিশিষ্ট নেটওয়ার্ক এ পরিণত হবে, কারণ ২ টি লিনিয়ার ফাংশন এর প্রোডাক্ট ও একটি লিনিয়ার ফাংশনই ।

চিত্র ৫ এ আমরা দেখতে পাই কিভাবে নেটওয়ার্ক এর লিনিয়ার এবং নন-লিনিয়ার ফাংশনাল ব্লক একত্রিত হয়:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>চিত্র ৫: লিনিয়ার এবং নন-লিনিয়ার ব্লক এর ভিতর</center>|

<!-- In the graph, $s[i]$ is the weighted sum of unit ${i}$ which is computed as:

$$
s[i]=\sum_{j \in UP(i)}w[i,j]\cdot z[j]
$$

where $UP(i)$ denotes the predecessors of $i$ and $z[j]$ is the $j$th output from the previous layer.

The output $z[i]$ is computed as:

$$
z[i]=f(s[i])
$$

where $f$ is a non-linear function. -->
গ্রাফটিতে, $s[i]$ হচ্ছে ${i}$ ইউনিট এর ওয়েইটেড সাম যা নিম্নলিখিত উপায়ে বের করা হয়:

$$
s[i]=\sum_{j \in UP(i)}w[i,j]\cdot z[j]
$$

where $UP(i)$ denotes the predecessors of $i$ and $z[j]$ is the $j$th output from the previous layer.যেখানে $UP(i)$ দ্বারা বুঝায় ${i}$ এর পূর্ববর্তী নোডগুলো এবং $z[j]$ হচ্ছে পূর্ববর্তী লেয়ার এর $j$ তম আউটপুট

আউটপুট $z[i]$ নিম্নলিখিত উপায়ে বের করা হয়:

$$
z[i]=f(s[i])
$$

যেখানে $f$ হচ্ছে একটি নন-লিনিয়ার ফাংশন।


### নন-লিনিয়ার ফাংশন এর মধ্য দিয়ে ব্যাকপ্রোপাগেসন

<!-- The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox. -->
ব্যাকপ্রোপাগেসন এর প্রথম উপায় হচ্ছে একটি নন-লিনিয়ার ফাংশন এর মধ্য দিয়ে ব্যাকপ্রোপাগেট করা। আমরা নেটওয়ার্ক থেকে একটি নির্দিষ্ট নন-লিনিয়ার ফাংশন $h$ নেই এবং এছাড়া সব ব্ল্যাকবক্স এ রেখে দেই।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>চিত্র ৬: নন-লিনিয়ার ফাংশন এর মধ্য দিয়ে ব্যাকপ্রোপাগেসন     </center>|

<!-- We are going to use the chain rule to compute the gradients: -->
গ্রেডিয়েন্ট ক্যালকুলেট করার জন্য আমরা চেইন রুল ব্যবহার করবো:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

<!-- where $h'(s)$ is the derivative of $z$ w.r.t $s$ represented by $\frac{\mathrm{d}z}{\mathrm{d}s}$.
To make the connection between derivatives clear, we rewrite the formula above as: -->
যেখানে $h'(s)$ হচ্ছে $s$ এর সাপেক্ষে $z$ এর ডেরিভেটিভ যা প্রকাশ করা হয় এভাবে $\frac{\mathrm{d}z}{\mathrm{d}s}$।
ডেরিভেটিভ এর ব্যাপারটি নিম্নলিখিত উপায়ে আরো পরিষ্কার ভাবে দেখতে পারি:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

<!-- Hence if we have a chain of those functions in the network, we can backpropagate by multiplying by the derivatives of all the ${h}$ functions one after the other all the way back to the bottom. -->
অতএব আমাদের যদি এরকম ফাংশন এর চেইন থাকে নেটওয়ার্ক এ, তাহলে আমরা সবগুলো ডেরিভেটিভ ফাংশন ${h}$ এর গুণ এর মাধ্যমে ব্যাকপ্রোপাগেট করতে পারি একেবারে নিচে এসে পৌঁছানো পর্যন্ত।


<!-- It’s more intuitive to think of it in terms of perturbations. Perturbing $s$ by $\mathrm{d}s$ will perturb $z$ by: -->
এটা পার্টারবেশন এর মাধ্যমে আরো সহজভাবে বুঝা যায়। $s$ কে যদি $\mathrm{d}s$ পার্টার্ব করি তাহলে $z$ তে পার্টার্ব হবে এতটুকু:

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

<!-- This would in turn perturb $C$ by: -->
এটি পর্যায়ক্রমে আবার $C$ কে পার্টার্ব করবে এতটুকু:

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

<!-- Once again, we end up with the same formula as the one shown above. -->
আবারও, আমরা উপরেউল্লেখিত ফর্মুলাই পেলাম।


### ওয়েইটেড সাম এর মধ্য দিয়ে ব্যাকপ্রোপাগেসন

<!-- For a linear module, we do backpropagation through a weighted sum. Here we view the entire network as a blackbox except for 3 connections going from a ${z}$ variable to a bunch of $s$ variables. -->
লিনিয়ার মডেল এ, আমরা ওয়েইটেড সাম এর মধ্য দিয়ে ব্যাকপ্রোপাগেসন করে থাকি। এখানে আমরা ${z}$ ভ্যারিয়েবল থেকে কিছু $s$ ভ্যারিয়েবল এ যাওয়া  শুধু ৩ টি কানেকশন বাদে বাকি সবকিছুকে ব্ল্যাকবক্স হিসেবে ধরবো।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>চিত্র ৭: ওয়েইটেড সাম এর মধ্য দিয়ে ব্যাকপ্রোপাগেসন        </center>|


<!-- This time the perturbation is a weighted sum. $Z$ influences several variables. Perturbing $z$ by $\mathrm{d}z$ will perturb $s[0]$, $s[1]$ and $s[2]$ by: -->
এক্ষেত্রে পার্টারবেশনটি হচ্ছে একটি ওয়েইটেড সাম। $Z$অনেকগুলো ভ্যারিয়েবল প্রভাবিত করে, $z$ তে $\mathrm{d}z$ পরিমান পার্টার্ব $s[0]$, $s[1]$ and $s[2]$ এ পার্টার্ব ঘটাবে এতটুকু:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

 এটি পর্যায়ক্রমে আবার $C$ কে পার্টার্ব করবে এতটুকু

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

তাই $C$ ৩ টি সাম এর ভ্যারিয়েশন পরিমান ভ্যারি করবে::

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$


## [পাইটর্চ এর মাধ্যমে নিউরাল নেটওয়ার্ক এবং একটি জেনারালিজড ব্যাকপ্রোপ এলগোরিদম ইমপ্লিমেন্টেশন](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)


### প্রচলিত নিউরাল নেট এর  ব্লক ডায়াগ্রাম

- লিনিয়ার ব্লক $s_{k+1}=w_kz_k$
- নন-লিনিয়ার ব্লক $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

<!-- $w_k$: matrix $z_k$: vector $h$: application of scalar ${h}$ function to every component. This is a 3-layer neural net with pairs of linear and non-linear functions, though most modern neural nets do not have such clear linear and non-linear separations and are more complex. -->
$w_k$: ম্যাট্রিক্স $z_k$: ভেক্টর $h$: প্রতিটি উপাদানে স্কেলার ${h}$ ফাংশন এর প্রয়োগ। এটি একটি ৩ লেয়ার নিউরাল নেটওয়ার্ক লিনিয়ার এবং নন-লিনিয়ার ফাংশন বিশিষ্ট, যদিও আধুনিক নিউরাল নেট গুলোতে এতো পরিষ্কার লিনিয়ার এবং নন-লিনিয়ার এর বর্ণনা থাকেনা, সেগুলো বরং আরো জটিল।


### পাইটর্চ ইমপ্লিমেন্টেশন

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

<!-- - We can implement neural nets with object oriented classes in PyTorch. First we define a class for the neural net and initialize linear layers in the constructor using predefined `nn.Linear` class. Linear layers have to be separate objects because each of them contains a parameter vector. The `nn.Linear` class also adds the bias vector implicitly. Then we define a forward function on how to compute outputs with $\text{torch.relu}$ function as the nonlinear activation. We don't have to initialize separate relu functions because they don't have parameters. -->
- আমরা পাইটর্চ এর অবজেক্ট ওরিয়েন্টেড  ক্লাসগুলো ব্যবহার করে নিউরাল নেটওয়ার্ক ইমপ্লিমেন্ট করতে পারি। প্রথমে আমরা নিউরাল নেট এর জন্য একটা ক্লাস তৈরী করবো এবং সেই ক্লাস এর কন্সট্রাক্টর এ প্রিডিফাইন `nn.Linear` ক্লাস ব্যবহার করে লিনিয়ার লেয়ারগুলো ইনিশিয়ালইজ করবো। লিনিয়ার লেয়ার গুলোকে আলাদা অবজেক্ট হতে হবে যেহেতু সেগুলোর প্রত্যেকটিতেই প্যারামিটার ভেক্টর রয়েছে। `nn.Linear` ক্লাস একটি বায়াস ও যুক্ত করে দেয়। এরপর  আমরা ফরওয়ার্ড ফাংশন তৈরী করি যেখানে আমাদের আউটপুট কেমন হবে তা বলে দেই এবং $\text{torch.relu}$ কে নন-লিনিয়ার এক্টিভেশন ফাংশন হিসেবে ঠিক করি। আমাদের আলাদা করে রেলু (ReLU)  ফাংশন ইনিশিয়ালইজ করার দরকার নেই, কারণ এর কোনো প্যারামিটার নেই।

<!-- - We do not need to compute the gradient ourselves since PyTorch knows how to back propagate and calculate the gradients given the `forward` function. -->
- আমাদের নিজেদের গ্রেডিয়েন্ট ক্যালকুলেট করার প্রয়োজন নেই, যেহেতু পাইটর্চ জানে `forward` ফাংশন দেয়া থাকলে কিভাবে ব্যাকপ্রোপাগেট করে গ্রেডিয়েন্ট ক্যালকুলেট করতে হয়।


### একটি ফাংশনাল মডিউল এর মধ্য দিয়ে ব্যাকপ্রপ

<!-- We now present a more generalized form of backpropagation. -->
এখানে ব্যাকপ্রোপাগেসন এর আরো জেনেরালাইজড রূপ তুলে ধরা হলো।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>চিত্র ৮: একটি ফাংশনাল মডিউল এর মধ্য দিয়ে ব্যাকপ্রপ     </center>|


- ভেক্টর ফাংশন এর জন্য চেইন রুল ব্যবহার করে

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  <!-- This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector. -->
  এটি $\frac{\partial c}{\partial{z_f}}$ এর চেইন রুল ব্যবহার করে বেসিক ফর্মুলা। লক্ষ্য কর, একটি ভেক্টর এর সাপেক্ষে একটি স্কেলার ফাংশন এর গ্রেডিয়েন্ট হচ্ছে একটি ভেক্টর যার আকার যেই ভেক্টর এর সাপেক্ষে ডিফারেন্সিয়েট করা হয়েছে। নোটেশনগুলোকে সামঞ্জস্যপূর্ণ করার জন্য, এটি কলাম ভেক্টর এর বদলে একটি রো ভেক্টর।

- জ্যাকোবিয়ান ম্যাট্রিক্স

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  <!-- We need $\frac{\partial {z_g}}{\partial {z_f}}$ (Jacobian matrix entries) to compute the gradient of the cost function with respect to $z_f$ given gradient of the cost function with respect to $z_g$. Each entry $ij$ is equal to the partial derivative of the $i$th component of the output vector with respect to the $j$th component of the input vector. -->
  আমাদের  $\frac{\partial {z_g}}{\partial {z_f}}$ (জ্যাকোবিয়ান ম্যাট্রিক্স উপাদানসমূহ) প্রয়োজন $z_f$ এর সাপেক্ষে কস্ট ফাংশন এর গ্রেডিয়েন্ট ক্যালকুলেট করার জন্য যদি ধরে নেই $z_g$ এর সাপেক্ষে কস্ট ফাংশন এর গ্রেডিয়েন্ট দেয়া আছে প্রতিটি $ij$ উপাদান, ইনপুট ভেক্টর এর $j$ তম উপাদান এর সাপেক্ষে আউটপুট ভেক্টর এর $i$th তম উপাদান এর পার্শিয়াল ডেরিভেটিভ এর সমান।

  <!-- If we have a cascade of modules, we keep multiplying the Jacobian matrices of all the modules going down and we get the gradients w.r.t all the internal variables. -->
  যদি আমাদের কাছে মডিউলগুলির একটি ক্যাসকেড থাকে, আমরা নীচে নেমে যাওয়া সমস্ত মডিউলগুলির জ্যাকোবিয়ান ম্যাট্রিক্সগুলি গুণ করতে থাকি এবং আমরা অভ্যন্তরীণ সবগুলো ভ্যারিয়েবল এর সাপেক্ষে গ্রেডিয়েন্ট পেয়ে যাই।


### মাল্টি-স্টেজ গ্রাফের এর মধ্য দিয়ে ব্যাকপ্রপ

<!--
Consider a stack of many modules in a neural network as shown in Figure 9. -->
একটি নিউরাল নেটওয়ার্ক এর মধ্যে অনেকগুলো মডিউল এর সারি চিন্তা করো চিত্র ৯ এর মতো।

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>চিত্র ৯: মাল্টি-স্টেজ গ্রাফের এর মধ্য দিয়ে ব্যাকপ্রপ         </center>|

<!-- For the backprop algorithm, we need two sets of gradients - one with respect to the states (each module of the network) and one with respect to the weights (all the parameters in a particular module). So we have two Jacobian matrices associated with each module. We can again use chain rule for backprop. -->
ব্যাকপ্রপ এলগোরিদমটির জন্য আমাদের গ্রেডিয়েন্ট এর ২ টি সেট প্রয়োজন - একটি স্টেটগুলোর সাপেক্ষে (নেটওয়ার্ক এর প্রতিটি মডিউল) এবং আরেকটি হচ্ছে ওয়েইটগুলোর সাপেক্ষে (কোনো একটি নির্দিষ্ট মডিউল এর সকল প্যারামিটার)। তাই প্রতিটি মডিউল দুটি করে জাকোবিয়ান ম্যাট্রিক্স যুক্ত। আমরা আবারো ব্যাকপ্রপ এর জন্য চেইন রুল ব্যবহার করতে পারি।

- ভেক্টর ফাংশন এর জন্য চেইন রুল ব্যবহার করে

  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

- মডিউলটির জন্য ২ টি জ্যাকোবিয়ান ম্যাট্রিক্স
    - একটি $z[k]$ এর সাপেক্ষে
    - একটি $w[k]$ এর সাপেক্ষে

