---
lang-ref: ch.14-2
lang: ar
lecturer: Yann LeCun
title: أساليب الرسم البياني المبنية على الطاقة
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
translation-date: 15 Sep 2020
translator: Anass El Houd
---

<!--
## Comparing Losses
<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center>
In the figure above, incorrect paths have -1.
Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.
In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.
Q: How is the segmentor implemented in the model above?
A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition.
-->
## مقارنة الخسائر (Losses)

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
الشكل 1: هيكل الشبكة
</center>
في الشكل أعلاه، تحتوي المسارات غير الصحيحة على -1.

يبدأ البروفيسور LeCun بفقدان الإدراك الحسي، والذي يستخدم في مثال نموذج محول الرسم البياني في الشكل أعلاه. الهدف هو جعل الطاقة من الإجابات الخاطئة كبيرة، والإجابات الصحيحة صغيرة.

من حيث التنفيذ، يمكنك تمثيل الأقواس في التصور باستخدام متجه  (vector). بدلاً من استخدام قوس منفصل لكل فئة، يمكننا استعمال متجه واحد يحتوي على كل من الفئات والنتيجة لكل فئة.

س: كيف يتم تنفيذ المقسم (segmentor) في النموذج أعلاه؟

ج: الجزء هو التنبؤ اليدوي(handcrafted heuristics) . يستخدم النموذج مقسمًا يدويًا على الرغم من وجود طريقة لجعله قابلاً للتدريب من طرف إلى طرف (end-to-end). تم استبدال هذا النهج بنهج النافذة المنزلقة للتعرف على الأحرف أو ما يعرف بالإنجليزية the sliding window.

<!--
## Overview of Losses
<center>
Table 1: Various Loss Equations
</center>
| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |
The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.
* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.
Q: How may hinge be better than NLL loss?
A: Hinge is better than NLL becuase NLL will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m).
-->

## نظرة عامة على الخسائر

<center>
الجدول 1: معادلات الخسارة المختلفة
</center>

| Ecuacion de pérdida | Formula  | Margen |
| :---- | :----: | ---:|
| Perdida de energia | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Bisagra  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Cuadrado-cuadrado | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Cuadrado-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


إن خسارة الإدراك الحسي (percepton loss) كما في الجدول أعلاه ليس لها هامش، وبالتالي فإن الخسارة تنطوي على خطر الانهيار.

* فقدان المفصلة  (hinge)  هو أخذ طاقة الإجابة الأكثر ضررًا، والإجابة الصحيحة، وحساب الفرق بينهما. حدسيًا، مع وجود هامش م، ستفقد المفصلة 0 فقط عندما تكون الطاقة الصحيحة أقل من الطاقة الأكثر ضررًا بمقدار _ على الأقل _ م.
* يُستخدم فقدان MCE في التعرف على الكلام، ويبدو مشابهًا للدالة السينية (sigmoid).

* يهدف فقدان NLL إلى جعل طاقة الإجابة الصحيحة صغيرة، وجعل جزء log في المعادلة كبيرًا.

س: كيف يمكن أن تكون المفصلة  (hinge) أفضل من خسارة  NLL؟

ج: المفصلة (hinge)  أفضل من NLL لأن NLL ستحاول دفع الفرق بين الإجابة الصحيحة والإجابات الأخرى إلى ما لا نهاية، في حين أن المفصلة تريد فقط جعلها أكبر من بعض القيم (الهامش م.)

<!--
### DEFINITION:
A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.
Q: What are some examples of problems that can use decoders?
A: Language modelling, machine translation, and sequence tagging.
-->
### تعريف:

يقوم مفكك الشفرة (decoder)  بإدخال سلسلة من المتجهات التي تشير إلى درجات أو طاقة الأصوات أو الصور، وتختار أفضل إخراج ممكن.

س: ما هي بعض الأمثلة على المشاكل التي يمكن أن تستخدم مفككي التشفير (decoders)؟
ج: نمذجة اللغة والترجمة الآلية وعلامات التسلسل.


<!--
## خوارزمية forward في شبكات محول الرسم البياني
### Graph Composition
Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>الشكل 2:</b>: Graph Composition
</center>
The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.
Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?
The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values.
If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.
In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.
As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.
-->

## خوارزمية forward في شبكات محول الرسم البياني

### تكوين الرسم البياني

يسمح لنا تكوين الرسم البياني بدمج رسمين بيانيين. في هذا المثال، يمكننا أن نرى معجم نموذج اللغة يتم تمثيله على شكل $ trie $ (رسم بياني) ورسم بياني للتعرف يتم إنتاجه بواسطة شبكة عصبية.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>الشكل 2:</b>: تكوين الرسم البياني
</center>

يحدد رسم التعرف البياني بقيم طاقة مختلفة (مرتبطة بكل قوس) مدى احتمالية وجود حرف في خطوة معينة.

الآن، في هذا المثال، السؤال الذي نجيب عليه من خلال عملية تكوين الرسم البياني هو، ما هو أفضل مسار في مخطط التعرف هذا الذي يتوافق أيضًا مع قاموسنا؟

القفزة الشائعة من الخطوة 1 إلى الخطوة 2 بين الرسم التعرف البياني هي الحرف $c$، المرتبط بالطاقة 0.4. وبالتالي، فإن الرسم البياني الخاص بنا يحتوي على قوس واحد فقط بين الخطوتين 1 و 2 المقابل لـ $c$. وبالمثل، فإن الأحرف المحتملة بين الخطوتين 2 و 3 هي $x$ و $u$ و $a$ في رسم التعرف البياني. تحتوي الفروع التي تلي $c$ في الرسم البياني النحوي على $u$ و $a$. لذلك، تختار عملية تكوين الرسم البياني الأقواس $u$ و $a$ لتواجدهما في الرسم البياني للتفسير. كما أنه يربط القوس الذي ينسخه من رسم التعرف البياني بقيم الطاقة.

إذا احتوت القواعد النحوية أيضًا على قيم طاقة مرتبطة بالأقواس، فإن تكوين الرسم البياني كان سيضيف قيم الطاقة أو يجمعها باستخدام عامل آخر (operator).

بطريقة مماثلة ، يسمح لنا تكوين الرسم البياني أيضًا بدمج قاعدتين معرفيتين يتم تمثيلهما بواسطة الشبكات العصبية. في المثال السابق، يمكن تمثيل القواعد بشكل أساسي كشبكة عصبية تتنبأ بالحرف التالي. يوفر لنا ناتج softmax الخاص بالشبكات العصبية احتمالات الانتقال إلى الحرف التالي من عقدة معينة.

كملاحظة جانبية، إذا كان نموذج اللغة الموضح في هذا المثال عبارة عن شبكة عصبية، فيمكننا إعادة الانتشار عبر البنية بأكملها. يصبح هذا مثالًا لبرنامج مختلف حيث نقوم بإعادة النشر من خلال برنامج يحتوي على حلقات، شروط، تكرارية، إلخ.

<!--
### قارئ الشيكات من منتصف التسعينيات
تعتبر البنية الكاملة لقارئ الشيكات من منتصف التسعينيات معقدة للغاية، ولكن ما يهمنا في المقام الأول هو الجزء الذي يبدأ من أداة التعرف على الأحرف، والتي تنتج الرسم البياني للتعرف.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>الشكل #</b>: قارئ الشيكات
</center>
This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.
The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.
Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.
-->

### قارئ الشيكات من منتصف التسعينيات

تعتبر البنية الكاملة لقارئ الشيكات من منتصف التسعينيات معقدة للغاية، ولكن ما يهمنا في المقام الأول هو الجزء الذي يبدأ من أداة التعرف على الأحرف، والتي تنتج الرسم البياني للتعرف.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>الشكل #</b>: قارئ الشيكات
</center>

يخضع الرسم البياني للتعرف على عمليتي تكوين منفصلتين، إحداهما مع التفسير الصحيح (أو الحقيقة الأساسية) والثانية مع القواعد النحوية التي تنشئ رسمًا بيانيًا لجميع التفسيرات الممكنة.

يتم تدريب النظام بأكمله عبر دالة الأرجحية اللوغارثمية السلبية (Negative Log-Likelihood). تبين هذه الدالة أن كل مسار في الرسم البياني للتفسير هو تفسير محتمل ومجموع الطاقات على طول هذا المسار هو طاقة ذلك التفسير.

الآن، بدلاً من استخدام خوارزمية Viterbi، نستخدم خوارزمية forward (forward algorithm). تناقش الأقسام الفرعية التالية الاختلافات بين النهجين.

<!--
Viterbi algorithm
Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.
$$F (x, y) = \min_{z} \; E(x, y, z)$$
-->
#### Viterbi خوارزمية

خوارزمية Viterbi هي خوارزمية برمجة ديناميكية تُستخدم للعثور على المسار الأكثر احتمالًا (أو المسار مع الحد الأدنى من الطاقة) في رسم بياني معين. إنه يقلل الطاقة فيما يتعلق بالمتغير الكامن z، حيث يمثل z المسار الذي نسلكه في الرسم البياني.

$$F (x, y) = \min_{z} \; E(x, y, z)$$

<!--
#### The forward algorithm
The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:
$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$
This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.
The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.
The working of the forward algorithm can be shown using the following example defined on an interpretation graph.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center>
-->

#### [خوارزمية forward](https://www.youtube.com/watch?v=gYayCG6YyO8&t=4518s)
من ناحية أخرى، تقوم الخوارزمية الأمامية بحساب اللوغاريثم للمجموع الأسي للقيمة السالبة لطاقات جميع المسارات. يمكن رؤية هذا الفم بسهولة كصيغة أدناه:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

هذا هو التهميش على المتغير الكامن z، الذي يحدد المسارات في الرسم البياني التفسير. يحسب هذا الأسلوب القيمة الأسية لمجموع اللوغاريثم هذا على جميع المسارات الممكنة لعقدة معينة. هذا يشبه تمشيط تكلفة جميع المسارات الممكنة بأدنى حد ممكن.

خوارزمية forward هي خوارزمية سهلة التنفيذ ولا تكلف أكثر من خوارزمية Viterbi. أيضًا،  يمكننا أن نستعمل الانتشار الخلفي من خلال عقدة الخوارزمية الأمامية في الرسم البياني.

يمكن عرض عمل خوارزمية forward باستخدام المثال التالي المحدد في رسم بياني للتفسير.


<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b> الشكل 4 </b>: الرسم التفسيري البياني
</center>

<!--
The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.
For the red node, the value of energy at the node is given by:
$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$
-->
يتم حساب التكلفة من عقدة الإدخال إلى العقدة المظللة باللون الأحمر عن طريق التهميش على جميع المسارات الممكنة التي تصل إلى العقدة الحمراء. تحدد الأسهم التي تدخل العقدة الحمراء هذه المسارات المحتملة في مثالنا.

بالنسبة للعقدة الحمراء، تُعطى قيمة الطاقة في العقدة من خلال:


$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

<!--
#### Neural network analogy of forward algorithm
The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term.
For each node in the interpretation graph, we maintain a variable $\alpha$.
$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$
where $e_{ki}$ is the energy of the link from node $k$ to node $i$.
$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.
We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>
-->

#### تشبيه الشبكة العصبية لخوارزمية forward

تعد خوارزمية forward حالة خاصة لخوارزمية انتشار المعتقد (belief-propagation algorithm)، عندما يكون الرسم البياني الأساسي عبارة عن رسم بياني متسلسل. يمكن النظر إلى هذه الخوارزمية بأكملها على أنها شبكة عصبية تلقائية للأمام حيث تكون الوظيفة في كل عقدة عبارة عن مجموع اللوغاريثم الأسي بإضافة ثابت.

لكل عقدة في الرسم البياني التفسير، نحافظ على متغير $\alpha$.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

حيث $e_{ki}$ هي طاقة الارتباط من العقدة $k$ إلى العقدة $i$.

يشكل $\alpha_i$ تنشيط العقدة $i$ في هذه الشبكة العصبية و $e_{ki}$ هو الوزن بين العقد $k$ والعقدة $i$. هذه الصيغة مكافئة جبريًا لعمليات المجموع الموزون لشبكة عصبية عادية في مجال log.

يمكننا النسخ العكسي من خلال الرسم البياني للتفسير الديناميكي (لأنه يتغير من مثال إلى مثال) الذي نطبق عليه خوارزمية forward. يمكننا حساب تدرجات $F(x, y)$ المحسوبة في العقدة الأخيرة من الرسم البياني بالنسبة إلى أوزان $e_{ki}$ التي تحدد حواف الرسم البياني للتفسير.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>الشكل 5</b>: قارئ الشيكات
</center>

<!--
Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.
The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations.
-->
بالعودة إلى مثال قارئ الشيك، نطبق خوارمية forward على تكوينات الرسم البياني ونحصل على قيمة الطاقة في العقدة الأخيرة باستخدام مجموع اللوغاريثم الأسي log sum exponential. الفرق بين قيم الطاقة هذه هو مقدار خسارة الأرجحية اللوغاريثمية السلبية (negative log-likelihood loss).

القيمة التي تم الحصول عليها من تطبيق  خوارزمية forward على تكوين الرسم البياني بين الإجابة الصحيحة ورسم التعرف على البيانات هي القيمة الأسية لمجموع اللوغاريثم  log sum exponential للإجابة الصحيحة. في المقابل، فإن القيمة الأسية لمجموع اللوغاريثم في العقدة الأخيرة لتكوين الرسم البياني بين الرسم البياني للتعرف والقواعد هي القيمة المهمشة على جميع التفسيرات الصحيحة الممكنة.

<!--
# Lagrangian formulation of Backpropagation
For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.
The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).
To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.
- For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.
-->
# [صيغة لاغرانج للانتشار الخلفي](https://www.youtube.com/watch?v=gYayCG6YyO8&t=5573s)

بالنسبة للإدخال $x$ والمخرج المستهدف $y$، يمكننا صياغة شبكة كمجموعة من الوظائف، $f_k$ والأوزان، $w_k$ مثل تلك الخطوات المتعاقبة في إخراج الشبكة $z_k$ مع $z_{k+1} = f_k(z_k, w_k)$. في الإعداد الخاضع للإشراف، يتمثل هدف الشبكة في تقليل $C(z_n, y)$، وهي تكلفة ناتج الشبكة رقم $n$، فيما يتعلق بالحقيقة الأساسية. هذا يعادل مشكلة تصغير $C(z_n, y)$ فيما يتعلق بالقيود $z_{k+1} = f_k(z_k, w_k)$ و $z_0 = x$.

يمكن كتابة اللاغرانج:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
حيث تشير مصطلحات $ \lambda $ إلى مضاعفات لاجرانج (راجع [ملاحظات بول عبر الإنترنت](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) لتجديد المعلومات إذا كان الحساب 3 منذ فترة)

لتقليل $\mathcal{L}$، نحتاج إلى تعيين المشتقات الجزئية لـ $\mathcal{L}$ بالنسبة لكل من عناصرها إلى الصفر وحلها.

- بالنسبة إلى $\lambda$، نستعيد القيد : $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- بالنسبة إلى $z_k$، $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$,   وهي مجرد صيغة الانتشار الخلفي القياسية.

<!--
This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.
In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.
-->

نشأ هذا النهج مع لاغرانج وهاملتون في سياق الميكانيكا الكلاسيكية، حيث يكون التقليل على طاقة النظام بينما يشير مصطلح $ \ lambda $ إلى القيود المادية للنظام، مثل إجبار كرتين على البقاء على مسافة ثابتة عن بعضها البعض بحكم ربطها بقضيب معدني، على سبيل المثال.

في الحالة التي نحتاج فيها إلى تقليل التكلفة $C$ في كل خطوة زمنية، $k$، يصبح Lagrangian
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.



<!--
# Neural Ordinary Differential Equation
Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.
Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).
-->

# المعادلة التفاضلية العصبية العادية (ODE)
باستخدام هذه الصيغة من  الانتشار الخلفي، يمكننا الآن التحدث عن فئة جديدة من النماذج،  Neural ODEs. هذه شبكات متكررة بشكل أساسي حيث يتم إعطاء الحالة $z$ في الوقت $ t $ بواسطة
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $، حيث يمثل $W$ مجموعة من المعاملات الثابتة. يمكن أيضًا التعبير عن ذلك في صورة معادلة تفاضلية عادية (بدون مشتقات جزئية): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

يعد تدريب مثل هذه الشبكة باستخدام صيغة لاغرانج أمرًا سهلاً للغاية. إذا كان لدينا هدف، $y$، ونريد أن تصل حالة النظام إلى $y$ بمرور الوقت $T$، فإننا ببساطة نؤسس دالة التكلفة على أنها المسافة بين $z_T$ و $y$. يمكن أن يكون الهدف الآخر للشبكة هو العثور على حالة مستقرة للنظام، *أي* حالة تتوقف عن التغيير بعد نقطة معينة. رياضيا، هذا يعادل إعداد $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. بشكل عام، العثور على حل، $y$ لهذه المعادلة أسهل بكثير من الانتشار العكسي عبر الزمن، لأن الشبكة لا تحتاج إلى تذكر التدرج اللوني فيما يتعلق بالتسلسل بأكمله، وعليها فقط تقليل $f$ أو $\lvert f \rvert^2$. لمزيد من المعلومات حول تدريب ODE العصبي للوصول إلى النقاط الثابتة، راجع [(Lecun88)] (http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).

<!--
# Variational Inference in terms of Energy
## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute
$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$
If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.
We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
-->

# [التبنؤ المتغير من حيث الطاقة](https://www.youtube.com/watch?v=gYayCG6YyO8&t=6522s)

## مقدمة
بالنسبة لدالة الطاقة الأولية $E(x,y,z)$، إذا أردنا التهميش على متغير، z، للحصول على خسارة من حيث $x$ و $y$، $L(x,y)$، يجب أن نحسب
$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$
إذا ضربنا بعد ذلك في $ \ frac {q (z)} {q (z)} $، فسنحصل على
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
إذا افترضنا أن $ q (z) $ هو توزيع احتمالي يزيد عن $z$، فيمكننا تفسير دالة الخسارة المعاد كتابتها باعتبارها قيمة متوقعة، فيما يتعلق بتوزيع $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.
نحن نستخدم هذا التفسير، تباين جنسن (Jensen's Inequality)، والتقريب القائم على أخذ العينات، لتحسين وظيفة الخسارة لدينا بشكل غير مباشر.

<!--
## Jensen's Inequality
Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:
<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>
-->
## متباينة جنسن

متباينة جنسن (Jensen's Inequality) هي ملاحظة هندسية تنص على: إذا كانت لدينا دالة محدبة، فإن *توقع* لهذه الدالة، على مدى النطاق، يكون أقل من متوسط الدالة التي تم تقييمها في بداية النطاق ونهايته. أنه أمر بديهي للغاية من الناحية الهندسية:
<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>الشكل 6:</b> متباينة ينسن (مأخوذة من [ويكيبيديا](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

<!--
Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,
$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$
Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
-->
وبالمثل، إذا كان $F$ محدبًا، لتوزيع احتمالية ثابتة $q$، يمكننا أن نستنتج من تباين جنسن أنه في النطاق $z$،

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

لآن، تذكر أن $L(x,y)$ المهمش بعد الضرب في $\frac{q(z)}{q(z)}$ هو،

$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!--
If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that
$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$
$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$
$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$
Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.
-->

إذا صنعنا $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$، نعلم من تباين جنسن $(1)$ ذلك

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

دعنا نواصل عمل هذا، مع دالة خسارة محدبة محددة, $F(x) = -\log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

عظيم! الآن لدينا حد أعلى لدالة الخسارة $L(x,y)$، وهي تتألف من حدين نفهمهما. المصطلح الأول $\int_z q(z)E(x,y,z)$ هو * متوسط * الطاقة. والمصطلح الثاني $\frac{1}{\beta}\int_z\log(q(z))$ هو مجرد بعض العوامل ($-\frac{1}{\beta}$) مضروبًا في *إنتروبيا* التوزيع $q$.

<!--
## What's the point?
We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!
To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.
The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.
Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$.
## Summary
This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about.
-->

## ما هو بيت القصيد؟

لقد قمنا الآن بصياغة حد أعلى بطريقة يمكننا من خلالها تجنب عمليات الدمج المعقدة، وبدلاً من ذلك نقوم ببساطة بتقريب هذه القيم عن طريق أخذ عينات من توزيع بديل ($q(z)$)، من اختيارنا!

للحصول على قيمة المصطلح الأول لدالة الحد الأعلى، نقوم فقط بأخذ عينات من هذا التوزيع، وحساب متوسط قيمة $L$ الذي نحصل عليه من تطبيق $z$ الذي تم أخذ عينات منه.

المصطلح الثاني (عامل إنتروبيا) هو مجرد خاصية لمجموعة التوزيع، ويمكن أيضًا تقريبه بأخذ عينات عشوائية بقيمة $q$.

أخيرًا، يمكننا تصغير $L$ فيما يتعلق بمعاملاته (على سبيل المثال، أوزان الشبكة $W$)، عن طريق تقليل هذه الدالة التي تحدد أعلاه. نجري هذا التصغير عن طريق تحديث المتغيرين لدينا: (1) إنتروبيا $q$، و (2) معاملات النموذج $W$.


## ملخص
هذه هي "وجهة نظر الطاقة" للتنبؤ المتغير. إذا كنت بحاجة إلى حساب لوقاريثم المجموع الأسي log of a sum of exponentials، فاستبدله بمتوسط  دالتك بالإضافة إلى ثابت إنتروبيا والذي يعطينا الحد الأعلى. ثم نقوم بتقليل هذا الحد الأعلى، وبذلك نقلل من الدالة التي نريدها.
