---
lang-ref: ch.13-3
lang: ar
title: شبكات المخططات الإلتفافية III
lecturer: Alfredo Canziani
authors: Go Inoue, Muhammad Osama Khan, Muhammad Shujaat Mirza, Muhammad Muneeb Afzal
date: 28 Apr 2020
translation-date: 02 Oct 2020
translator: Abderrahmane Rahiche
---


<!--## [Introduction to Graph Convolutional Network (GCN)](https://www.youtube.com/watch?v=2aKXWqkbpWg&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=25&t=47s)

Graph Convolutional Network (GCN) is one type of architecture that utilizes the structure of data.
Before going into details, let's have a quick recap on self-attention, as GCN and self-attention are conceptually relevant.
-->


## [مدخل إلى شبكة المخططات الإلتفافية (GCN)](https://www.youtube.com/watch?v=2aKXWqkbpWg&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=25&t=47s)


<!--### Recap: Self-attention-->

### خلاصة: الاهتمام الذاتي

<!--
- In self-attention, we have a set of input $\lbrace\boldsymbol{x}\_{i}\rbrace^{t}_{i=1}$.
Unlike a sequence, it does not have an order.
- Hidden vector $\boldsymbol{h}$ is given by linear combination of the vectors in the set.
- We can express this as $\boldsymbol{X}\boldsymbol{a}$ using matrix vector multiplication, where $\boldsymbol{a}$ contains coefficients that scale the input vector $\boldsymbol{x}_{i}$.

*For a detailed explanation, refer to the notes of [Week 12]({{site.baseurl}}/en/week12/12-3/).*
-->


- في الاهتمام الذاتي ، لدينا مجموعة من المدخلات $lbrace\boldsymbol{x}\_{i}\rbrace^{t}_{i=1}\$.
على عكس التسلسل ، ليس له ترتيب.
- المتجه المخفي $boldsymbol{h}\$ يُعطى بالتوليفة الخطية للمتجهات في المجموعة.
- يمكننا التعبير عن هذا كـ $boldsymbol{X}\boldsymbol{a}\$ باستخدام ضرب متجه المصفوفة، حيث يحتوي $boldsymbol{a}\$ على معاملات تقيس متجه الإدخال $boldsymbol{x}_{i}\$.




<!--### Notation-->

### تأشير

<center>
<img src="{{site.baseurl}}/images/week13/13-3/figure1.png" height="400px" /><br>
<b>Fig. 1</b>: Graph Convolutional Network
</center>

<!--In Figure 1, vertex $v$ is comprised of two vectors: input $\boldsymbol{x}$ and its hidden representation $\boldsymbol{h}$.
We also have multiple vertices $v_{j}$, which is comprised of $\boldsymbol{x}\_j$ and $\boldsymbol{h}\_j$.
In this graph, vertices are connected with directed edges.

We represent these directed edges with adjacency vector $\boldsymbol{a}$, where each element $\alpha_{j}$ is set to $1$ if there is a directed edge from $v_{j}$ to $v$.
-->

في الشكل 1 ، يتكون الرأس ‪$‬v‪$‬ من متجهين:الإدخال $boldsymbol{x}\$ وتمثيله المخفي $boldsymbol{h}\$.
لدينا أيضًا رؤوس متعددة $v_ {j}$، والتي تتكون من $boldsymbol{x}\_j\$ و $boldsymbol{h}\_j\$.
في هذا المخطط ، ترتبط الرؤوس بحواف موجهة.

نمثل هذه الحواف الموجهة مع المتجه المجاور $boldsymbol{a}\$، حيث يأخذ كل عنصر $alpha_{j}\$ القيمة $1$ إذا كان هناك حافة موجهة من $v_{j}$ إلى $v$.


$$
\alpha_{j} \stackrel{\tiny \downarrow}{=} 1 \Leftrightarrow v_{j} \rightarrow v
\tag{Eq. 1}
$$

<!--The degree (number of incoming edges) $d$ is defined as the norm of this adjacency vector, *i.e.* $\Vert\boldsymbol{a}\Vert_{1} $, which is the number of ones in the vector $\boldsymbol{a}$.-->


تُعرَّف الدرجة $d$ (عدد الحواف الواردة) على أنها معيار متجه التقارب هذا، * مثال * $\Vert\boldsymbol{a}\Vert_{1}\$ ، الذي يمثل عدد الآحاد في المتجه $boldsymbol{a}\$.



$$
    d = \Vert\boldsymbol{a}\Vert_{1}
\tag{Eq. 2}
$$

<!--The hidden vector $\boldsymbol{h}$ is given by the following expression:-->

المتجه المخفي $boldsymbol{h}\$ يعطى بالتعبير التالي:

$$
    \boldsymbol{h}=f(\boldsymbol{U}\boldsymbol{x} + \boldsymbol{V}\boldsymbol{X}\boldsymbol{a}d^{-1})
\tag{Eq. 3}
$$

<!--where $f(\cdot)$ is a non-linear function such as ReLU $(\cdot)^{+}$, Sigmoid $\sigma(\cdot)$, and hyperbolic tangent $\tanh(\cdot)$.

The $\boldsymbol{U}\boldsymbol{x}$ term takes into account the vertex $v$ itself, by applying rotation $\boldsymbol{U}$ to the input $v$.

Remember that in self-attention, the hidden vector $\boldsymbol{h}$ is computed by $\boldsymbol{X}\boldsymbol{a}$, which means that the columns in $\boldsymbol{X}$ is scaled by the factors in $\boldsymbol{a}$.
In the context of GCN, this means that if we have multiple incoming edges,*i.e.* multiple ones in adjacency vector $\boldsymbol{a}$, $\boldsymbol{X}\boldsymbol{a}$ gets larger.
On the other hand, if we have only one incoming edge, this value gets smaller.
To remedy this issue of the value being proportionate to the number of incoming edges, we divide it by the number of incoming edges $d$.
We then apply rotation $\boldsymbol{V}$ to $\boldsymbol{X}\boldsymbol{a}d^{-1}$.

We can represent this hidden representation $\boldsymbol{h}$ for the entire set of inputs $\boldsymbol{x}$ using the following matrix notation:
-->


حيث أن $f(\cdot)$ هي دالة غير خطية مثل السيجمويد $\sigma(\cdot)$، والظل الهُذْلولي $\tanh(\cdot)$.

تأخذ العبارة $boldsymbol{U}\boldsymbol{x}\$ في الحسبان الرأس $v$ نفسه، من خلال تطبيق الدوران $boldsymbol{U}\$ على الإدخال $v$.

تذكر أنه في حالة الانتباه الذاتي ، يتم حساب المتجه المخفي $boldsymbol{h}\$ بواسطة $boldsymbol{X}\boldsymbol{a}\$، مما يعني أن الأعمدة الموجودة في $boldsymbol{X}\$ تم تحجيمها بواسطة العوامل في $boldsymbol{a}\$.
في سياق GCN ، هذا يعني أنه إذا كان لدينا حواف واردة متعددة ، * أي * حواف متعددة في المتجه المجاور $\boldsymbol{a}$ فإن $\boldsymbol{X}\boldsymbol{a}$ يصبح أكبر.
من ناحية أخرى ، إذا كان لدينا ميزة واردة واحدة فقط ، فإن هذه القيمة تصبح أصغر.
لمعالجة هذه المشكلة المتعلقة بتناسب القيمة مع عدد الحواف الواردة ، نقوم بقسمتها على عدد الحواف الواردة $ d $.
ثم نطبق الدوران $boldsymbol{V}\$ على$\boldsymbol{X}\boldsymbol{a}d^{-1}$ .

يمكننا تمثيل هذا التمثيل المخفي $boldsymbol{h}\$ لمجموعة المدخلات بالكامل $boldsymbol{x}\$ باستخدام تدوين المصفوفة التالي:


$$
\{\boldsymbol{x}_{i}\}^{t}_{i=1}\rightsquigarrow \boldsymbol{H}=f(\boldsymbol{UX}+ \boldsymbol{VXAD}^{-1})
\tag{Eq. 4}
$$

<!--where $\vect{D} = \text{diag}(d_{i})$.-->

حيث $vect{D} = \text{diag}(d_{i})\$.



<!--## [Residual Gated GCN Theory and Code](https://www.youtube.com/watch?v=2aKXWqkbpWg&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=25&t=992s)

Residual Gated Graph Convolutional Network is a type of GCN that can be represented as shown in Figure 2:
-->

## [البوابات المتبقية GCN النظرية والكود](https://www.youtube.com/watch?v=2aKXWqkbpWg&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=25&t=992s)
 

الشبكة الإلتفافية لمخطط البوابات المتبقية هي نوع ينتمي لعائلة GCN و يمكن تمثيلها كما هو موضح في الشكل 2:

<center>
<img src="{{site.baseurl}}/images/week13/13-3/figure2.png" height="300px" /><br>
<b>Fig. 2</b>: Residual Gated Graph Convolutional Network
</center>

<!--As with the standard GCN, the vertex $v$ consists of two vectors: input $\boldsymbol{x}$ and its hidden representation $\boldsymbol{h}$. However, in this case, the edges also have a feature representation, where $\boldsymbol{e_{j}^{x}}$ represents the input edge representation and $\boldsymbol{e_{j}^{h}}$ represents the hidden edge representation.

The hidden representation $\boldsymbol{h}$ of the vertex $v$ is computed by the following equation:
-->


كما هو الحال مع GCN القياسي ، يتكون الرأس $v$ من متجهين: الإدخال $\boldsymbol{x}$ وتمثيله المخفي $boldsymbol{h}\$. ومع ذلك، في هذه الحالة، تحتوي الحواف أيضًا على تمثيل للميزة، حيث يمثل $boldsymbol{e_{j}^{x}}\$ تمثيل حافة الإدخال ويمثل $boldsymbol{e_{j}^{h}}\$ تمثيل الحافة المخفية.

يتم حساب التمثيل المخفي $boldsymbol{h}\$ للقمة $v$ بالمعادلة التالية:



$$
    \boldsymbol{h}=\boldsymbol{x} + \bigg(\boldsymbol{Ax} + \sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}}\bigg)^{+}
\tag{Eq. 5}
$$

<!--where $\boldsymbol{x}$ is the input representation, $\boldsymbol{Ax}$ represents a rotation applied to the input $\boldsymbol{x}$ and $\sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}}$ denotes the summation of elementwise multiplication of rotated incoming features $\boldsymbol{Bx_{j}}$ and a gate $\eta(\boldsymbol{e_{j}})$. In contrast to the standard GCN above where we average the incoming representations, the gate term is critical to the implementation of Residual Gated GCN since it allows us to modulate the incoming representations based on the edge representations.

Note that the summation is only over vertices ${v_j}$ that have incoming edges to vertex ${v}$. The term residual (in Residual Gated GCN) comes from the fact that in order to calculate the hidden representation $\boldsymbol{h}$, we add the input representation $\boldsymbol{x}$. The gate term $\eta(\boldsymbol{e_{j}})$ is calculated as shown below:
-->


حيث يمثل $boldsymbol{x}\$ تمثيل الإدخال ، يمثل $boldsymbol{Ax}\$ دورانًا مطبقًا على الإدخال $boldsymbol{x}\$ و يشير $sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}}\$ إلى مجموع الجداء العنصري للميزات الواردة التي تم تدويرها. على النقيض من GCN القياسي أعلاه حيث نقوم بتوسيط التمثيلات الواردة ، فإن مصطلح البوابة ضروري لتنفيذ البقايا المبوبة GCN لأنه يسمح لنا بتعديل التمثيلات الواردة بناءً على تمثيلات الحافة.

لاحظ أن التجميع يقع فقط فوق الرؤوس ${v_j}$ التي لها حواف واردة للرأس ${v}$. المصطلح المتبقي (في Residual Gated GCN) يأتي من حقيقة أنه من أجل حساب التمثيل المخفي $boldsymbol{h}\$ ، نضيف تمثيل الإدخال $ boldsymbol{x}\$. يتم حساب مصطلح البوابة $eta(\boldsymbol{e_{j}})\$ كما هو موضح أدناه:

$$
    \eta(\boldsymbol{e_{j}})=\sigma(\boldsymbol{e_{j}})\bigg(\sum_{v_k→v}\sigma(\boldsymbol{e_{k}})\bigg)^{-1}
\tag{Eq. 6}
$$

<!--The gate value $\eta(\boldsymbol{e_{j}})$ is a normalized sigmoid obtained by dividing the sigmoid of the incoming edge representation by the sum of sigmoids of all incoming edge representations. Note that in order to calculate the gate term, we need the representation of the edge $\boldsymbol{e_{j}}$, which can be computed using the equations below:-->

قيمة البوابة $eta(\boldsymbol{e_{j}})\$ هي عبارة عن سيجمويد مسواة تم الحصول عليها بقسمة السيجمويد الخاص بتمثيل الحافة الواردة على مجموع السيجمويد لجميع تمثيلات الحواف الواردة. لاحظ أنه من أجل حساب مصطلح البوابة ، نحتاج إلى تمثيل الحافة $boldsymbol{e_{j}}\$، والتي يمكن حسابها باستخدام المعادلات أدناه:

$$
    \boldsymbol{e_{j}} = \boldsymbol{Ce_{j}^{x}} + \boldsymbol{Dx_{j}} + \boldsymbol{Ex}
\tag{Eq. 7}
$$

$$
    \boldsymbol{e_{j}^{h}}=\boldsymbol{e_{j}^{x}}+(\boldsymbol{e_{j}})^{+}
\tag{Eq. 8}
$$

<!--The hidden edge representation $\boldsymbol{e_{j}^{h}}$ is obtained by the summation of the initial edge representation $\boldsymbol{e_{j}^{x}}$ and $\texttt{ReLU}(\cdot)$ applied to $\boldsymbol{e_{j}}$ where $\boldsymbol{e_{j}}$ is in turn given by the summation of a rotation applied to $\boldsymbol{e_{j}^{x}}$, a rotation applied to the input representation $\boldsymbol{x_{j}}$ of the vertex $v_{j}$ and a rotation applied to the input representation $\boldsymbol{x}$ of the vertex $v$.

*Note: In order to calculate hidden representations downstream (*e.g.* $2^\text{nd}$ layer hidden representations), we can simply replace the input feature representations by the $1^\text{st}$ layer feature representations in the equations above.*
-->

يتم الحصول على تمثيل الحافة المخفية $boldsymbol{e_{j}^{h}}\$ من خلال جمع تمثيل الحافة الأولية $boldsymbol{e_{j}^{x}}\$ أما $texttt{ReLU}(\cdot)\$ فيتم تطبيقه على $boldsymbol{e_{j}}\$ حيث يتم إعطاء $boldsymbol{e_{j}}\$ بدوره من خلال جمع الاستدارة المطبقة على $boldsymbol{e_{j}^{x}}\$ ، استدارة مطبقة على تمثيل الإدخال $boldsymbol{x_{j}}\$ للرأس $ v_ {j} $ وتم استدارة مطبقة على تمثيل الإدخال $boldsymbol{x}\$ للرأس $v$.

* ملاحظة: من أجل حساب التمثيلات المخفية في اتجاه مجرى النهر (* على سبيل المثال * طبقة التمثيلات المخفية الثانية) ، يمكننا ببساطة استبدال تمثيلات ميزة الإدخال عن طريق تمثيلات ميزة الطبقة الأولى في المعادلات أعلاه. *


<!--### Graph Classification and Residual Gated GCN Layer

In this section, we introduce the problem of graph classification and code up a Residual Gated GCN layer. In addition to the usual import statements, we add the following:-->


### تصنيف المخطط وطبقة البوابات المتبقية GCN

في هذا القسم ، نقدم مشكلة تصنيف المخطط وتشفير طبقة البوابات المتبقية GCN. بالإضافة إلى عبارات الاستيراد المعتادة ، نضيف ما يلي:



```python
os.environ['DGLBACKEND'] = 'pytorch'
import dgl
from dgl import DGLGraph
from dgl.data import MiniGCDataset
import networkx as nx
```

<!--The first line tells DGL to use PyTorch as the backend. Deep Graph Library ([DGL](https://www.dgl.ai/)) provides various functionalities on graphs whereas networkx allows us to visualise the graphs.

In this notebook, the task is to classify a given graph structure into one of 8 graph types. The dataset obtained from `dgl.data.MiniGCDataset` yields some number of graphs (`num_graphs`) with nodes between `min_num_v` and `max_num_v`. Hence, all the graphs obtained do not have the same number of nodes/vertices.

*Note: In order to familiarize yourself with the basics of `DGLGraphs`, it is recommended to go through the short tutorial [here](https://docs.dgl.ai/api/python/graph.html).*

Having created the graphs, the next task is to add some signal to the domain. Features can be applied to nodes and edges of a `DGLGraph`. The features are represented as a dictionary of names (strings) and tensors (**fields**). `ndata` and `edata` are syntax sugar to access the feature data of all nodes and edges.

The following code snippet shows how the features are generated. Each node is assigned a value equal to the number of incident edges, whereas each edge is assigned the value 1.
-->

السطر الأول يخبر DGL باستخدام PyTorch كخلفية. توفر مكتبة المخطط العميق ([DGL] (https://www.dgl.ai/)) وظائف متنوعة على المخططات بينما تسمح لنا networkx برؤية المخططات.

في دفتر الملاحظات هذا ، تتمثل المهمة في تصنيف بنية مخطط معينة إلى نوع من أنواع المخططات الثمانية. تنتج مجموعة البيانات التي تم الحصول عليها من `dgl.data.MiniGCDataset` عددًا من المخططات (`num_graphs`) مع عقد بين `min_num_v` و` max_num_v`. وبالتالي ، فإن جميع المخططات التي تم الحصول عليها لا تحتوي على نفس عدد العقد / الرؤوس.

* ملاحظة: من أجل التعرف على أساسيات "DGLGraphs" ، يوصى بالاطلاع على البرنامج التعليمي القصير [هنا] (https://docs.dgl.ai/api/python/graph.html). *

بعد إنشاء المخططات ، فإن المهمة التالية هي إضافة بعض الإشارات إلى المجال. يمكن تطبيق الميزات على عقد وحواف "DGLGraph". يتم تمثيل الميزات كقاموس للأسماء (سلاسل) وموترات (** الحقول **). `ndata` و edata` هي عبارة عن سكر لغوي للوصول إلى بيانات ميزات جميع العقد والحواف.

يوضح مقتطف الشفرة التالي كيفية إنشاء الميزات. يتم تعيين قيمة مساوية لعدد حواف العارضة لكل عقدة ، بينما يتم تعيين القيمة 1 لكل حافة.


```python
def create_artificial_features(dataset):
    for (graph, _) in dataset:
        graph.ndata['feat'] = graph.in_degrees().view(-1, 1).float()
        graph.edata['feat'] = torch.ones(graph.number_of_edges(), 1)
    return dataset
```

<!--Training and testing datasets are created and features are assigned as shown below:-->

يتم إنشاء مجموعات بيانات التدريب والاختبار وتعيين الميزات كما هو موضح أدناه:


```python
trainset = MiniGCDataset(350, 10, 20)
testset = MiniGCDataset(100, 10, 20)

trainset = create_artificial_features(trainset)
testset = create_artificial_features(testset)
```

<!--A sample graph from the trainset has the following representation. Here, we observe that the graph has 15 nodes and 45 edges and both the nodes and edges have a feature representation of shape `(1,)` as expected. Furthermore, the `0` signifies that this graph belongs to class 0.
-->

يحتوي نموذج المخطط من trainset على التمثيل التالي. هنا ، نلاحظ أن المخطط يحتوي على 15 عقدة و 45 حافة وأن كل من العقد والحواف لها تمثيل مميز للشكل "(1)" كما هو متوقع. علاوة على ذلك ، يشير "0" إلى أن هذا المخطط ينتمي إلى الفئة 0.



```python
(DGLGraph(num_nodes=15, num_edges=45,
         ndata_schemes={'feat': Scheme(shape=(1,), dtype=torch.float32)}
         edata_schemes={'feat': Scheme(shape=(1,), dtype=torch.float32)}), 0)
```


<!--### Note about DGL Message and Reduce Functions

>In DGL, the *message functions* are expressed as **Edge UDF**s (User Defined Functions). Edge UDFs take in a single argument `edges`. It has three members `src`, `dst`, and `data` for accessing source node features, destination node features, and edge features respectively.
The *reduce functions* are **Node UDF**s. Node UDFs have a single argument `nodes`, which has two members `data` and `mailbox`. `data` contains the node features and `mailbox` contains all incoming message features, stacked along the second dimension (hence the `dim=1` argument).
`update_all(message_func, reduce_func)` sends messages through all edges and updates all nodes.
-->


### ملاحظة حول رسالة DGL وتقليل الوظائف

> في DGL ، يتم التعبير عن * وظائف الرسالة * كـ (وظائف من تحديد المستخدم) **Edge UDF**. تأخذ Edge UDFs وسيط واحد edges`. يحتوي على ثلاثة أعضاء "src" و "dst" و "data" للوصول إلى ميزات عقدةالمصدر، ميزات عقدة الوجهة، وميزات الحافة على التوالي.
* وظائف التقليل * هي عقد ‪*‬UDF‪*‬. تحتوي عقد UDFs على وسيط واحد "عُقد" ، والتي تحتوي على عضوين هما "data" و "mailbox". تحتوي "data" على ميزات العقدة ويحتوي "mailbox" على جميع ميزات الرسائل الواردة ، مكدسة على طول البعد الثاني (ومن ثم الوسيطة "dim = 1").
ʻupdate_all (message_func، Red_func) `يرسل الرسائل عبر جميع الحواف 



<!--### [Gated Residual GCN Layer Implementation](https://www.youtube.com/watch?v=2aKXWqkbpWg&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=25&t=2098s)

A Gated Residual GCN layer is implemented as shown in the code snippets below.

Firstly, all the rotations of the input features $\boldsymbol{Ax}$, $\boldsymbol{Bx_{j}}$, $\boldsymbol{Ce_{j}^{x}}$, $\boldsymbol{Dx_{j}}$ and $\boldsymbol{Ex}$ are computed by defining `nn.Linear` layers inside the `__init__` function and then forward propagating the input representations `h` and `e` through the linear layers inside the `forward` function.
-->


### [التطبيق البرمجي لطبقة البوابات المتبقية GCN] (https://www.youtube.com/watch؟v=2aKXWqkbpWg&list=PLLHTzKZVU9eaEyErdV26ikyolxOsz6mq&index=25&t=2098s)

يتم تنفيذ طبقة GCN المتبقية ذات البوابات كما هو موضح في مقتطفات التعليمات البرمجية أدناه.

أولاً ، جميع التدويرات لميزات الإدخال $boldsymbol{Ax}$، $\boldsymbol{Bx_{j}}$، $\boldsymbol{Ce_{j}^{x}}$، $\boldsymbol{Dx_{j}}\$ و $boldsymbol{Ex}\$ يتم حسابهما من خلال تحديد طبقات `nn.Linear` داخل وظيفة`__init__` ثم إعادة توجيه تمثيلات الإدخال `h` و ʻe` عبر الطبقات الخطية داخل وظيفة `forward`



```python
class GatedGCN_layer(nn.Module):

    def __init__(self, input_dim, output_dim):
        super().__init__()
        self.A = nn.Linear(input_dim, output_dim)
        self.B = nn.Linear(input_dim, output_dim)
        self.C = nn.Linear(input_dim, output_dim)
        self.D = nn.Linear(input_dim, output_dim)
        self.E = nn.Linear(input_dim, output_dim)
        self.bn_node_h = nn.BatchNorm1d(output_dim)
        self.bn_node_e = nn.BatchNorm1d(output_dim)
```

<!--Secondly, we compute the edge representations. This is done inside the `message_func` function, which iterates over all the edges and computes the edge representations. Specifically, the line `e_ij = edges.data['Ce'] + edges.src['Dh'] + edges.dst['Eh']` computes *(Eq. 7)* from above. The `message_func` function ships `Bh_j` (which is $\boldsymbol{Bx_{j}}$ from (Eq. 5)) and `e_ij` (Eq. 7) through the edge into the destination node's mailbox.
-->

ثانيًا ، نحسب تمثيلات الحواف. يتم ذلك داخل وظيفة `message_func` ، التي تتكرر عبر جميع الحواف وتحسب تمثيلات الحواف. على وجه التحديد ، السطر `e_ij = edges.data['Ce'] + edges.src['Dh'] + edges.dst['Eh']`  يحسب * (المعادلة 7) * من أعلى. تشحن  `Bh_j` بالوظيفة `message_func` (وهو $boldsymbol{Bx_{j}}\$ من (المعادلة 5)) و ʻe_ij` (المعادلة 7) عبر الحافة إلى صندوق بريد عقدة الوجهة.



```python
def message_func(self, edges):
    Bh_j = edges.src['Bh']
    # e_ij = Ce_ij + Dhi + Ehj
    e_ij = edges.data['Ce'] + edges.src['Dh'] + edges.dst['Eh']
    edges.data['e'] = e_ij
    return {'Bh_j' : Bh_j, 'e_ij' : e_ij}
```

<!--Thirdly, the `reduce_func` function collects the shipped messages by the `message_func` function. After collecting the node data `Ah` and shipped data `Bh_j` and `e_ij` from the `mailbox`, the line `h = Ah_i + torch.sum(sigma_ij * Bh_j, dim=1) / torch.sum(sigma_ij, dim=1)` computes the hidden representation of each node as indicated in (Eq. 5). Note however, that this only represents the term $(\boldsymbol{Ax} + \sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}})$ without the $\texttt{ReLU}(\cdot)$ and residual connection.
-->


ثالثًا ، تقوم وظيفة "reduce_func" بتجميع الرسائل المشحونة بواسطة الوظيفة "message_func". بعد جمع بيانات العقدة ‪'‬Ah‪'‬ وشحن البيانات `Bh_j` و ʻe_ij` من` صندوق البريد` ، السطر `h = Ah_i + torch.sum (sigma_ij * Bh_j، dim = 1) / torch.sum (sigma_ij، dim = 1) `يحسب التمثيل الخفي لكل عقدة كما هو مبين في (المعادلة 5). مع ذلك ، لاحظ أن هذا لا يمثل سوى المصطلح $(boldsymbol{Ax} + \sum_{v_j → v} {\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}}\)$ بدون $ texttt{ReLU}(\cdot)\$ و الوصلة المتبقية.


```python
def reduce_func(self, nodes):
    Ah_i = nodes.data['Ah']
    Bh_j = nodes.mailbox['Bh_j']
    e = nodes.mailbox['e_ij']
    # sigma_ij = sigmoid(e_ij)
    sigma_ij = torch.sigmoid(e)
    # hi = Ahi + sum_j eta_ij * Bhj
    h = Ah_i + torch.sum(sigma_ij * Bh_j, dim=1) / torch.sum(sigma_ij, dim=1)
    return {'h' : h}
```

<!--Inside the `forward` function, having called `g.update_all`, we obtain the results of graph convolution `h` and `e`, which represent the terms $(\boldsymbol{Ax} + \sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}})$ from (Eq.5) and $\boldsymbol{e_{j}}$ from (Eq. 7) respectively. Then, we normalize `h` and `e` with respect to the graph node size and graph edge size respectively. Batch normalization is then applied so that we can train the network effectively. Finally, we apply $\texttt{ReLU}(\cdot)$ and add the residual connections to obtain the hidden representations for the nodes and edges, which are then returned by the `forward` function.
-->


داخل وظيفة `forward` ، بعد استدعاء` g.update_all` ، نحصل على نتائج المخطط الإلتفافي `h` و ʻe` ، والتي تمثل المصطلحين $(\boldsymbol{Ax} + \sum_{v_j→v}{\eta(\boldsymbol{e_{j}})\odot \boldsymbol{Bx_{j}}})$ من(المعادلة 5) و $boldsymbol{e_{j}}\$ من (المعادلة 7) على التوالي. بعد ذلك ، نقوم بتسوية "h" و "e" فيما يتعلق بحجم عقد وحواف المخطط على التوالي. ثم يتم تطبيق تسوية الحزم حتى نتمكن من تدريب الشبكة بشكل فعال. أخيرًا ، نطبق $texttt{ReLU}(\cdot)\$ ونضيف الوصلات المتبقية للحصول على التمثيلات المخفية للعقد والحواف ، والتي يتم إرجاعها بعد ذلك بواسطة وظيفة `forward`.



```python
def forward(self, g, h, e, snorm_n, snorm_e):

    h_in = h # residual connection
    e_in = e # residual connection

    g.ndata['h']  = h
    g.ndata['Ah'] = self.A(h)
    g.ndata['Bh'] = self.B(h)
    g.ndata['Dh'] = self.D(h)
    g.ndata['Eh'] = self.E(h)
    g.edata['e']  = e
    g.edata['Ce'] = self.C(e)

    g.update_all(self.message_func, self.reduce_func)

    h = g.ndata['h'] # result of graph convolution
    e = g.edata['e'] # result of graph convolution

    h = h * snorm_n # normalize activation w.r.t. graph node size
    e = e * snorm_e # normalize activation w.r.t. graph edge size

    h = self.bn_node_h(h) # batch normalization
    e = self.bn_node_e(e) # batch normalization

    h = torch.relu(h) # non-linear activation
    e = torch.relu(e) # non-linear activation

    h = h_in + h # residual connection
    e = e_in + e # residual connection

    return h, e
```

<!--Next, we define the `MLP_Layer` module which contains several fully connected layers (FCN). We create a list of fully connected layers and forward through the network.

Finally, we define our `GatedGCN` model which comprises of the previously defined classes: `GatedGCN_layer` and `MLP_layer`. The definition of our model (`GatedGCN`) is shown below.
-->

بعد ذلك، نحدد وحدة `MLP_Layer` التي تحتوي على عدة طبقات متصلة بالكامل (FCN). نقوم بإنشاء قائمة من الطبقات المتصلة بالكامل ونقوم بإعادة توجيهها عبر الشبكة.

أخيرًا ، نقوم بتعريف نموذج "GatedGCN" الخاص بنا والذي يتكون من الفئات المحددة مسبقًا: "GatedGCN_layer" و "MLP_layer". تعريف نموذجنا ("GatedGCN") موضح أدناه.



 ```python
 class GatedGCN(nn.Module):
    def __init__(self, input_dim, hidden_dim, output_dim, L):
        super().__init__()
        self.embedding_h = nn.Linear(input_dim, hidden_dim)
        self.embedding_e = nn.Linear(1, hidden_dim)
        self.GatedGCN_layers = nn.ModuleList([
            GatedGCN_layer(hidden_dim, hidden_dim) for _ in range(L)
        ])
        self.MLP_layer = MLP_layer(hidden_dim, output_dim)
    def forward(self, g, h, e, snorm_n, snorm_e):
        # input embedding
        h = self.embedding_h(h)
        e = self.embedding_e(e)
        # graph convnet layers
        for GGCN_layer in self.GatedGCN_layers:
            h, e = GGCN_layer(g, h, e, snorm_n, snorm_e)
        # MLP classifier
        g.ndata['h'] = h
        y = dgl.mean_nodes(g,'h')
        y = self.MLP_layer(y)
        return y
 ```

<!--In our constructor, we define the embeddings for `e` and `h` (`self.embedding_e ` and `self.embedding_h`), `self.GatedGCN_layers` which is list (of size $L$) of our previously defined model: `GatedGCN_layer`, and finally `self.MLP_layer` which was also defined before. Next, using these initializations, we simply forward through the model and output `y`.

To better understand the model, we initiate an object of the model and print it for better visualization:
-->


في المُنشئ الخاص بنا ، نحدد التضمينات لـ ‪'‬e‪'‬ و `h` (` self.embedding_e `و` self.embedding_h`) ، و `self.GatedGCN_layer` وهي قائمة (حجمها $L$) لنموذجنا المحدد مسبقًا : "GatedGCN_layer" ، وأخيرًا "self.MLP_layer" والذي تم تعريفه أيضًا من قبل. بعد ذلك ، باستخدام هذه التهيئة ، نحن ببساطة نعيد توجيهها عبر النموذج والمخرج `y`.

لفهم النموذج بشكل أفضل ، نهيئ كائنًا من النموذج ونطبعه للحصول على تصور أفضل:


```python
# instantiate network
model = GatedGCN(input_dim=1, hidden_dim=100, output_dim=8, L=2)
print(model)
```

<!--The main structure of the model is shown below:-->

الهيكل الرئيسي للنموذج مبين أدناه:



```python
GatedGCN(
  (embedding_h): Linear(in_features=1, out_features=100, bias=True)
  (embedding_e): Linear(in_features=1, out_features=100, bias=True)
  (GatedGCN_layers): ModuleList(
    (0): GatedGCN_layer(...)
    (1): GatedGCN_layer(... ))
  (MLP_layer): MLP_layer(
    (FC_layers): ModuleList(...))
```

<!--Not surprisingly, we have two layers of `GatedGCN_layer` (since `L=2`) followed by a `MLP_layer` which finally yields an output of 8 values.

Moving on, we define our `train` and `evaluate` functions. In our `train` function, we have our generic code which takes samples from `dataloader`.  Next, `batch_graphs`, `batch_x`, `batch_e`, `batch_snorm_n` and `batch_snorm_e` are fed into our model which returns `batch_scores` (of size 8). The predicted scores are compared with the ground truth in our loss function: `loss(batch_scores, batch_labels)`. Then, we zero out gradients (`optimizer.zero_grad()`), perform backprop (`J.backward()`) and updates our weights (`optimizer.step()`). Finally, loss for epoch and training accuracy is calculated. Furthermore, we use a similar code for our `evaluate` function.

Finally, we are ready to train! We found that after 40 epochs of training, our model has learned to classify the graphs with a test accuracy of $87$%.
-->

ليس من المستغرب أن لدينا طبقتان من "GatedGCN_layer" (منذ "L = 2") متبوعًا بـ "MLP_layer" والذي ينتج أخيرًا مخرجا من 8 قيم.

من الآن فصاعدًا ، نحدد وظيفتي `train` و `evaluate`. في وظيفة `train` ، لدينا الكود العام الذي يأخذ عينات من `dataloader`. بعد ذلك ، يتم إدخال `batch_graphs` ،`batch_x` ،`batch_e`, `batch_snorm_n` و `batch_snorm_e` لتغذية نموذجنا الذي يُرجع `batch_scores` (بحجم 8). تتم مقارنة الدرجات المتوقعة بالحقيقة الأساسية في وظيفة الخسارة لدينا:`loss(batch_scores, batch_labels)`. بعد ذلك ، نحذف التدرجات (`optimizer.zero_grad()`) وننفذ الانتشار الخلفي(`J.backward()`) ونحدّث أوزاننا (`optimizer.step()`). أخيرًا ، يتم حساب الخسارة الحقبة ودقة التدريب. علاوة على ذلك ، نستخدم رمزًا مشابهًا لوظيفة `evaluate` الخاصة بنا.

أخيرًا ، نحن مستعدون للتدريب! وجدنا أنه بعد 40 حقبة من التدريب ، تعلم نموذجنا تصنيف الرسوم البيانية بدقة اختبار تبلغ 87 في المائة.
