---
lang-ref: ch.13-1
lang: ar
title: شبكات المخططات الطيفية الإلتفافية I
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
translation-date: 19 Sep 2020
translator: Abderrahmane Rahiche
---


<!--## [Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)
-->

## [ConvNets التقليدية] (https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)



<!--ConvNets are powerful architectures to solve high-dimensional learning problems.-->

 تعتبر ConvNets هياكل قوية لحل مشاكل التعلم عالية الأبعاد 

<!--### What is the Curse of Dimensionality?-->


### ما هو بلاء الأبعاد ؟ 


<!--Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example.
-->

<!-- - dim(image) = **1024 x 1024** = ${10}^{6}$-->
<!-- - For **N = 10** samples/dim -> **${10}^{1,000,000}$ points**-->

لنأخذ على سبيل المثال  صورة ذات حجم 1024 × 1024 بكسل. يمكن رؤية هذه الصورة كنقطة في الفضاء ذو 1،000،000 بعد. يؤدي استخدام 10 عينات لكل بُعد إلى إنتاج $ {10} ^ {1،000،000} $ صورة ، وهو مبلغ مرتفع للغاية. تعد شبكة ConvNets قوية للغاية لاستخراج أفضل تمثيل لبيانات الصور عالية الأبعاد ، مثل تلك الواردة في المثال.

- أبعاد (الصورة) = **1024x1024**  = ${10}^{6}$ 

- إذا كان ‪**‬ ‪=‬ 10 N‪**‬  عينة لكل بُعد ، الذي يعطينا ‪**‬ ${10}^{1,000,000}$ ‪**‬ نقطة  

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>.1 الشكل </b>:  تمثيل بيانات الصورة عالية الأبعاد تستخلص ConvNets.
</center>

<!--### Main assumptions about ConvNets:-->

### الافتراضات الرئيسية حول ConvNets


<!-- **1. Data (images, videos, speech) is compositional.**-->

** 1. البيانات (الصور، مقاطع الفيديو، والكلام) هي تركيبية. **


<!--It is formed of patterns that are:

* **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.
* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.
* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation.
-->

تتكون من أنماط التي تكون:

* ** محلية ** العصبون في الشبكة العصبية يكون متصلا بالطبقات المجاورة فقط، ولكن ليس بجميع الطبقات في الشبكة. نسمي هذا افتراض مجال الاستقبال المحلي.
* ** ثابتة ** لدينا بعض الأنماط المتشابهة ويتم مشاركتها عبر مجال الصور الخاص بنا. على سبيل المثال ، ملاءة السرير الصفراء في الصورة الوسطى من الشكل 2.
* ** هرمية ** سيتم دمج ميزات المستوى المنخفض لتشكيل ميزات متوسطة المستوى. بعد ذلك ، سيتم دمج ميزات المستوى المتوسط هذه بشكل تدريجي لتشكيل ميزات ذات مستوى أعلى وأعلى. على سبيل المثال ، تمثيل مرئي.



<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>. الشكل 2</b>: البيانات تركيبية.
</center>

<!--**2. ConvNets leverage the compositionality structure.**-->

<!--They extract compositional features and feed them to classifier, recommender, etc.-->

** 2. ConvNets تستفيد من بنية التكوين . **

إنهم يستخرجون الميزات التركيبية ويغذون بها المصنف ، المُوَصّي ، إلخ.


<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>.3 الشكل </b>: تستفيد ConvNets من بنية التكوين.
</center>

<!--## Graph Domain-->

<!--### Data Domain-->

### مجال المخططات

### مجال البيانات



<!--* Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values.-->

* الصور،الأحجام، ومقاطع الفيديو تقع على مجالات 2D ، 3D ، 2D + 1 الإقليدية (الشبكات)‪.‬ كل بكسل يتم تمثيله بواسطة متجه مكون من قيم اللون الأحمر، الأخضر، والأزرق.



<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>.4 الشكل </b>: الصور لها أبعاد متعددة.
</center>


<!--* Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer.-->

* الجمل ، الكلمات ، الكلام الكامن في المجال الإقليدي أحادي البعد. على سبيل المثال يمكن تمثيل كل حرف بعدد صحيح.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>.5 الشكل </b>: التسلسلات لها بعد واحد.
  </center>


<!--* These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined.-->

* تحتوي هذه المجالات على هياكل مكانية منتظمة قوية، مما يسمح لجميع عمليات ال ConvNets أن تكون سريعة ومحددة جيدًا من الناحية الحسابية.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>.6 الشكل </b>: بيانات الكلام لها شبكة أحادية البعد.
  </center>


<!--### Graph Domain-->

<!--#### Motivational Examples of graph domains-->

<!--Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos.
-->


### مجال المخططات

#### أمثلة تحفيزية لمجالات المخططات

لنأخذ على سبيل المثال شبكة اجتماعية. يتم التقاط الشبكة الاجتماعية بشكل أفضل من خلال تمثيل المخططات لأن الاتصال الثنائي بين مستخدمين لا يشكل شبكة. تمثل العُقد مخططات المستخدمين ، بينما تمثل الحواف بين عقدتين الوصلة بين عقدتين (مستخدمين). لكل مستخدم مصفوفة ميزات ثلاثية الأبعاد تحتوي على رسائل، صور، ومقاطع فيديو.


<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>.7 الشكل </b>:الشبكات الاجتماعية عن طريق المخططات.
</center>

<!--The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest.
-->

تقدم الوصلة بين بنية ووظيفة الدماغ للتنبؤ بالأمراض الوراثية العصبية مثالًا تحفيزيًا يجب مراعاته. كما يتضح أدناه ، يتكون الدماغ من عدة مناطق اهتمام (ROI). ترتبط مناطق الإهتمام محليًا ببعض مناطق الاهتمامات المحيطة بها فقط. تمثل مصفوفة المُتَاخَمَة ‪(المُجَاوَرَة)‬ درجة القوة بين مناطق الاهتمام المختلفة.



<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>.8 الشكل </b>: اتصال الدماغ عن طريق تمثيل المخططات.
</center>


<!--Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc.
-->


تقدم كيمياء الكم أيضًا تمثيلًا مثيرًا للاهتمام لمجال المخططات. يتم تمثيل كل ذرة بواسطة عقدة في المخطط والتي بدورها ترتبط بالذرات الأخرى من خلال روابط باستخدام الحواف. كل من هذه الجزيئات / الذرات لها مميزات مختلفة ، مثل الشحنة ونوع الرابطة المتعلق بها وما إلى ذلك.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>.9 الشكل </b>: كيمياء الكم عن طريق تمثيل المخططات.
</center>


<!--### Graph Definition and Characteristics-->

<!--* Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A**
-->

<!--* Graph features:
    * **Node features: $h_{i}$, $h_{j}$** (atom type)
    * **Edge features: $e_{ij}$** (bond type)
    * **Graph features:** g (molecule energy)
-->


### تعريف المخطط وخصائصه

* يتم تعريف المخطط G من خلال:
     * ** الرؤوس V **
     * ** الحواف E **
     * ** مصفوفة المُجَاوَرَة A **


* ميزات المخطط:
     * ** ميزات العقدة: $ h_ {i} $، $ h_ {j} $ ** (نوع الذرة)
     * ** ميزات الحافة: $ e_ {ij} $ ** (نوع السند)
     * ** ميزات المخطط: ** g (طاقة الجزيء)



<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>.10 الشكل </b>: المخطط.
</center>



<!--## [Convolution of Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)
-->
<!--### Convolution
-->

 ## الشبكات الإلتفافية التقليدية (https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s) 

### الإلتفاف


<!--We abstractly define convolution as:-->

<!--$$h^{\ell+l} = w^\ell * h^\ell,$$
where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (*e.g.*, 3 for a colored image).\\
So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\
Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\
Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\
-->
<!--For example, in this image, the kernel may be used to recognize lines.-->

يمكن تعريف الإلتفاف بشكل موجز كما يلي:


$$ h ^ {\ell + l} = w ^ \ell * h ^ \ell، $$
حيث $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
على سبيل المثال ، $ n_1 $ و $ n_2 $ يمكن أن تمثل عدد البكسل في الاتجاهين $x$ و $y$ للصورة ، على التوالي ، و $ d $ هو أبعاد كل بكسل (* على سبيل المثال * ، 3  للصور الملونة). \\
وعليه ، $ h ^ {\ ell + 1} $ تمثل ميزة في الطبقة المخفية $ ( ell + 1\) $ تم الحصول عليها من خلال تطبيق الإلتفاف $w^\ell$ على ميزة في الطبقة ال $  ell\ $ . \\
عادةً ما تكون النواة صغيرة لتمثيل حقل استقبال محلي‪$‬3 \times 3‪$‬  في هذه الحالة ، أو ‪$‬5 \times 5‪$‬ ، على سبيل المثال. \\
ملاحظة: نستخدم الحشو للتأكد من أن أبعاد $ h ^ {\ell + 1} $ هي نفسها أبعاد $ h ^ \ell $. \\

على سبيل المثال ، في هذه الصورة ، يمكن استخدام النواة للتعرف على الخطوط.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>.11 الشكل </b>: يمكن استخدام النواة للتعرف على الخطوط في الصور.
</center>

<!--### How do we define convolution?
-->

<!--More exactly, convolution is defined as follows:-->


### كيف نعرف الإلتفاف؟

 بشكل أكثر دقة ، يتم تعريف الإلتفاف على النحو التالي:

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

<!--The above defines convolution as *template matching*.\\
We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching.-->

<!--However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning.
-->
<!--In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$.-->

<!--The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line.-->

<!--This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image.-->

<!--Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids.-->

<!--The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels.-->


يعرّف ما ورد أعلاه الالتفاف على أنه * مطابقة القالب *.
عادةً ما نستخدم $ h_ {i + j} $ بدلاً من $ h_ {i-j} $ ، لأن الأول هو في الواقع ارتباط ، وهو أشبه بمطابقة القالب.

ومع ذلك ، لا يهم حقًا إذا كنت تستخدم الأول أو الثاني ، لأن النواة الخاصة بك قد انقلبت فقط، وهذا لا يؤثر على التعلم.

في السطر الثالث ، نكتب $ h_{i + j} ^ \ell $ كـ $ h_{ij} ^ \ell $.

النواة صغيرة جدًا ، لذا فبدلاً من جمع الصورة بأكملها $  Omega\ $ ، كما في السطر الثاني ، نجمع في الواقع محيط الخلية ‪$‬i‪$‬ فقط ‪$‬\mathcal‪{‬N‪}_‬i‪$‬، كما هو موضح في السطر الثالث.

هذا يجعل من تعقيد الالتفاف هو $ O(n) $ ، حيث $ n $يمثل عدد البكسل في صورة الإدخال.

الالتفاف هو بالضبط لكل من $ n $ بكسل ، مجمعة على الجداءات الداخلية للمتجهات ذات البعد $ d $ مطبقة على شبكات ‪$‬3 \times 3‪$‬.

وبالتالي يكون التعقيد هو $ n \cdot 3 \cdot 3 \cdot d $ ، وهو $ O(n) $؛ علاوة على ذلك ، يمكن إجراء العمليات الحسابية على كل بكسل من وحدات البكسل $ n $ على حدة بالتوازي مع وحدات معالجة GPUs .

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>.12 الشكل </b>: يتم ترتيب العقد بنفس الطريقة.
</center>

<!--If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.
Therefore, $j_3$ will always be in the top right corner of the pattern.-->

<!--So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.
For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.
Mathematically speaking:-->

إذا كان المخطط الذي تقوم بالالتفاف عليه عبارة عن شبكة، كما هو الحال في الالتفاف القياسي على الصور في الرؤية الحاسوبية ، فإنه سيتم ترتيب العقد كما في الصورة أعلاه.
لذلك ،$ j_3 $ سيكون دائمًا في الزاوية اليمنى العليا من النموذج.

وعليه، بالنسبة لجميع العقد $ i $ في الصورة أدناه مثل $ i $ و $‪'‬i$ ، فإن ترتيب العقدة في النواة هو نفسه دائمًا.
على سبيل المثال، دائمًا نقارن $ j_3 $ في الزاوية اليمنى العليا للنمط مع الزاوية اليمنى العليا من مجزأ الصورة (ما نلتف حوله للبكسل $ i $) ، كما هو موضح أدناه.
بتعبير رياضي:

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

<!--and-->

و

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

<!--are always for the top right corner between the template and the image patches.-->

دائمًا للزاوية اليمنى العلوية بين القالب و مجزأ الصورة.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>.13 الشكل </b>: تتطابق أجزاء الصور مع القوالب.
</center>


<!--### Can we extend template matching for graphs?-->

<!--We have a couple of issues:
1. First, in a graph, there is no ordering of the nodes.-->

<!--So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.
So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\
This is because there is no notion of the *top right corner* of the graph.\\
There is no notion of up, down, left right.\\
Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above.
-->


### هل يمكننا توسيع نطاق مطابقة القوالب للمخططات؟

لدينا بعض المشاكل:
1. أولاً ، في المخطط ، لا يوجد ترتيب للعقد.

لذلك في القالب الموضح أدناه في الصورة ، العقدة $ j_3 $ ليس لها موضع محدد ، ولكنها مجرد فهرس (عشوائي).
لذلك ، عندما نحاول المطابقة مع العقدتين $ i $ و $ i '$ في المخطط أدناه ، لا نعرف ما إذا كان $ j_3 $ يطابق نفس العقد في كلا الالتفافين. \\
هذا بسبب عدم وجود فكرة * الزاوية اليمنى العليا * للمخطط. \\
لا توجد فكرة لأعلى ولأسفل ولليسار لليمين \\
وبالتالي ، فإن مطابقة القالب ليس لها في الواقع أي معنى ولا يمكننا استخدام تعريف مطابقة القالب مباشرة ، على النحو الوارد أعلاه.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>.14 الشكل </b>: لا يوجد ترتيب عقدة في المخطط.
</center>

<!--2. The second issue is that neighborhood sizes may be different.-->

<!--So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.
How can we compare these two?-->


2. المشكلة الثانية هي أن أحجام التجاور قد تكون مختلفة.

لذا فإن القالب $ w ^ \ell $ الموضح أدناه يحتوي على 4 عقد ، لكن العقدة $ i $ بها 7 عقد في جوارها.
فكيف يمكننا المقارنة بينهما؟


<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>.15 الشكل </b>: أحجام المجاورين تكون مختلفة في المخطط.
</center>

<!--## Graph Convolution-->

<!--We now use the **Convolution Theorem** to define convolution for graphs.-->

<!--The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms:-->


## الإلتفاف المخطط

نستخدم الآن ** نظرية الإلتفاف ** لتعريف الإلتفاف للمخطط.

تنص ** نظرية الإلتفاف ** على أن تحويل فوريي لإلتفاف دالتين هو الجداء النقطي لتحويلي فوريي الخاص بهما:


$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

<!--In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT.

### Can we extend the Convolution theorem to graphs?

This raises two questions:
1. How to define Fourier transforms for graphs?
2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)?
-->

بشكل عام ، يحتوي تحويل فوريي على $ O (n ^ 2) $ معقد ، ولكن إذا كان المجال شبكة ، فيمكن تقليل التعقيد إلى $ O (n \ log n) $ باستخدام FFT.


### هل يمكننا توسيع نظرية الإلتفاف إلى المخططات؟

وهذا ينتج عنه سؤالين:
1. كيف نعرف تحويلات فوريي للمخططات؟
2. كيف يتم حساب إلتفافات طيفية سريعة في زمن قدره‪$‬O‪(‬n‪)$‬ للنَّوَى المدمجة (كما في مطابقة القالب)؟

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

<!--We are going to use these two design for graph neural networks:
Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets.
-->

سنستخدم هذين التصميمين للشبكات العصبية للمخططات:
مطابقة القوالب ستكون لمخططات ConvNets المكانية وسيتم استخدام نظرية الالتفاف لشبكات ConvNets الطيفية.


<!--## [Spectral Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)-->

<!--How to perform spectral convolution?-->


### (https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s) [ الطيفية ConvNets مخططات] 

كيف يتم إجراء الالتواء الطيفي؟


<!--### Step 1 : Graph Laplacian

This is the core operator in spectral graph theory.

Define
-->


### الخطوة 1: مخطط لابلاسيان


هذا هو العامل الأساسي في نظرية المخطط الطيفي.

نعرف


$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


<!--Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.


The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$.
-->


لاحظ أن المصفوفة $ A $ هي مصفوفة المجاورة، و $Delta\$ هي لابلاسيان، والتي تساوي المتطابقة مطروحًا منها المصفوفة المجاورة التي تم تسويتها بواسطة المصفوفة $ D $ والتي تمثل مصفوفة قطرية، وكل عنصر على القطر يمثل درجة العقدة. وهذا ما يسمى لابلاسيان المسوى ، أو لابلاسيان افتراضيًا في هذا السياق.


يتم تفسير لابلاسيان على أنه قياس نعومة المخطط ، وبعبارة أخرى ، الفرق بين القيمة المحلية $ h_i $ ومتوسط القيمة المجاورة لها البالغ $ h_j $. $ d_i $ في الصيغة أدناه هي درجة العقدة $ i $ ، و $mathcal{N}_{i}\$ هي جميع العقد المجاورة للعقدة $ i $.


$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

<!--The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and *vice versa*.

### Step 2 : Fourier Functions

The following is the eigen-decomposition of graph Laplacian,
-->

الصيغة أعلاه هي تطبيق لابلاسيان على الدالة $ h $ في العقدة $ i $ ، وهي قيمة $ h_i $ مطروحًا منها متوسط القيمة على العقد المجاورة لها ‪$‬h‪_‬j‪$‬. بشكل أساسي ، إذا كانت الإشارة سلسة جدًا ، تكون قيمة لابلاسيان صغيرة ، * والعكس صحيح *.


### الخطوة الثانية: دوال فوريي

ما يلي هو التحليل الذاتي لمخطط لابلاسيان ،


$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$


<!--The Laplacian is factorized into three matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis.
-->


يتم تقسيم لابلاسيان إلى ثلاث مصفوفات ، $Phi ^ T$ ، $ \Lambda $ ، $ \Phi\ $.

المصفوفة $Phi\$ كما هي معرفة أدناه ، تحتوي على متجهات أعمدة، أو متجهات ذاتية من$phi‪_‬1\$ إلى $phi_n\$ ، كل منها بحجم $ n \times 1 $ ، وتسمى هذه أيضًا دوال فوريي. وتشكل دوال فوريي أساسًا متعامدًا.


$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$



<!--$\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below.
-->


المصفوفة  $\Lambda$ هي مصفوفة قطرية بقيم ذاتية لابلاسية، و القيم على القطر هي $lambda_1\ $ إلى $lambda_n\ $. ومن التطبيقات التي تمت تسويتها ، تكون هذه القيم عادةً بين النطاق من ‪$‬0‪$‬ إلى ‪$‬2‪$‬. تُعرف هذه أيضًا باسم طيف المخطط. انظر الصيغة أدناه.


$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$


<!--Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$.
-->

يوجد أدناه مثال للتحقق من تحليل القيمة الذاتية. مصفوفة لابلاسيان $Lambda\$ مضروبة في المتجهات الذاتية $\phi_k$، وشكل النتيجة‪$‬n \times 1‪$‬ ، والنتيجة هي $lambda_k \phi_k\$.

$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

<!--The image below is the visualization of eigenvectors of 1D Euclidean Laplacian.-->

الصورة أدناه تبين المتجهات الذاتية لـلبعد الأحادي الإقليدي اللابلاسيي.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>.16 الشكل </b>: المجال الشبكي / الإقليدي: المتجهات الذاتية للبعد الأحادي الإقليدي اللابلاسيي.
</center>

<!--For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below.
-->


بالنسبة لمجال المخطط ، من اليسار إلى اليمين ، هو الأول،الثاني، الثالث،‪...‬ دوال فوريي للمخطط. على سبيل المثال ، يحتوي $phi_1\$ على تذبذبات ذات قيم موجبة (حمراء) وسالبة (زرقاء) ، نفس القيم $phi‪_‬2$ ، $ \phi‪_‬3 $. تعتمد هذه التذبذبات على طوبولوجيا المخطط، والتي تتعلق بهندسة المخططات مثل المجتمعات،المحاور، وما إلى ذلك ، وهي مفيدة للتجميع في المخططات. انظر أدناه.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>.17 الشكل </b>: مجال المخططات: دوال فوريي للمخططات.
</center>

<!--### Step 3 : Fourier Transform-->


### الخطوة الثالثة: تحويل فوريي

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

<!--**Fourier series: Decompose function $h$ with Fourier functions.**

Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$.

The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series.

**Fourier Transform/ coefficients of Fourier Series**
-->


** سلاسل فوريي: حلل الدالة $ h $ بدوال فوريي. **

خذ الدالة $ h $ والمسقطة على كل دالة فوريي $\phi_k$، مما ينتج عنه معامل سلاسل فوريي بقيمة $ k $ ، قيمة عددية ، ثم مضروبة في الدالة $phi_k\$.

يقوم تحويل فوريي بشكل أساسي بإسقاط دالة $ h $ على دوال فوريي ، والنتيجة هي معاملات سلسلة فوريي.


** تحويل فوريي / معاملات سلاسل فوريي **

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$


<!--**Inverse Fourier Transform**-->

** تحويل فوريي العكسي **

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


<!--Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$.



### Step 4 : Convolution Theorem


Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms.
-->

تحويلات فوريي هي عمليات خطية، محصلة جداء مصفوفة $Phi ^ {T}\ $ بمتجه $ h $.



### الخطوة الرابعة: نظرية الإلتفاف

تحويل فوريي لإلتفاف دالتين هو الجداء النقطي لتحويلات فوريي.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

<!--The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.-->

<!--The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph.
-->

<!--## Limitation

The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.


## Recommended book
-->


المثال أعلاه هو لإلتفاف $ w $ و $ h $ ، وكلاهما من الشكل ‪$‬n \times 1‪$‬ ، فهو يساوي معكوس تحويل فوريي للجداء النقطي بين تحويل فوريي ل$w$ و $h$. توضح الصيغة أعلاه أنها تساوي أيضًا ضرب المصفوفة $hat{w} (\Delta)\$ و $h$.

إن التفاف دالتين على المخطط $ h $ و $ w $ هو أخذ دالة الطيف $ w $ وتطبيقها على لابلاسيان وضربها في $ h $ ، وهذا هو تعريف التفاف الطيف. ومع ذلك ، فإن درجة تعقيد الحساب هي $mathrm{O}\left (n^{2}\right)\$ ، بينما $n$ هو عدد العقد في المخطط.



## تحديد

لا يؤدي الالتفاف الطيفي مقابل مجال المخطط إلى تغيير الثبات ، مما يعني أنه إذا تم تغييره، فإن شكل الدالة قد يتغير أيضًا، بينما لا يحدث ذلك في المجال الشبكي / الإقليدي.


## كتاب موصى به

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
