---
lang-ref: ch.07-3
lang: ar
title: مقدمة للمشفرات الذاتية 
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 19 Sep 2020
translator: Mahmoud Elnaggar
---


## [تطبيقات المشفرات الذاتية](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)

### توليد الصور


هل يمكنك تحديد الوجه المزيف في الشكل 1؟ في الواقع ، تم إنتاج كلاهما بواسطة المولد StyleGan2. على الرغم من أن تفاصيل الوجه واقعية للغاية ، إلا أن الخلفية تبدو غريبة (على اليسار: تشويش ، على اليمين: كائنات مشوهة). هذا لأن الشبكة العصبية تم تدريبها على عينات للوجوه. عندئذ يكون للخلفية تباين أعلى بكثير. هنا ، يحتوي مجمع البيانات على 50 بعدًا تقريبًا ، ,هو نفس عدد درجات الحرية لصورة وجه إنسان.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>الشكل 1</b>: وجوه مولّده بواسطة StyleGan2
</center>

### اختلاف الاستيفاء في فضاء البكسل والفضاء الكامن

<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>الشكل 2</b>: كلب و طير
</center>


إذا قمنا بالإستيفاء الخطي (Linear Interpolation) بين صورة الكلب والطير (الشكل 2) في فضاء البكسل ، فسنحصل على تراكب باهت لصورتين في الشكل 3. من أعلى اليسار إلى أسفل اليمين ، ينخفض ​​وزن (أو مدى تأثير) صورة الكلب و يزداد وزن (أو مدى تأثير) صورة الطيور.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>الشكل 3</b>: النتائج بعد الإستيفاء الخطي
</center>

إذا قمنا بالإستيفاء الخطي لإثنين من تمثيل الفضاء الكامن وقمنا بإدخالهما إلى وحدة فك التشفير ، فسنحصل على تحول من كلب إلى طائر كما في الشكل 4.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>الشكل 4</b>: النتائج بعد الإدخال إلى وحده فك التشفير
</center>

من الواضح أن الفضاء الكامن أفضل في التقاط بنية الصورة.

### أمثلة للتحولات

<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>الشكل 5</b>: تكبير
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>الشكل 6</b>: إزاحة
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>الشكل 7</b>: سطوع
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>الشكل 8</b>: دوران (لاحظ أن الدوران ممكن أن يكون في البعد الثالث)
</center>


### الصورة فائقة الدقة
يهدف هذا النموذج إلى رفع مستوى الصور وإعادة بناء الوجوه الأصلية.إذا بدأت من اليسار إلى اليمين في الشكل 9 ، ستلاحظ أن العمود الأول هو صورة الإدخال 16 × 16 ، والعمود الثاني هو ما ستحصل عليه من الاستيفاء التكعيبي القياسي (Standard bicubic interpolation) ، والثالث هو الناتج الخارج من الشبكة العصبية ، وعلى اليمين هو الحقيقة الأساسية. (https://github.com/david-gpu/srez)

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>الشكل 9</b>: إعادة بناء الوجوه الأصلية
</center>

من الواضح عند النظر في الصور الموّلده أن هناك تحيزات في بيانات التدريب ، مما يجعل الوجوه المعاد بناؤها غير دقيقة. على سبيل المثال ، تم تصميم الرجل الآسيوي الأيسر العلوي ليبدو أوروبيًا في الناتج بسبب صور التدريب غير المتوازنة. يبدو الوجه المعاد بناؤه للنساء في الجزء اليسار من الأسفل غريبًا بسبب عدم وجود صور التقطت من تلك الزاوية الغريبة في بيانات التدريب.


### إعادة رسم الصور

<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>الشكل 10</b>: وضع رقعة رمادية على الوجوه
</center>

وضع رقعة رمادية على الوجه كما في الشكل 10 يجعل الصورة بعيدة عن مجمع التدريب. تتم إعادة بناء الوجه في الشكل 11 عن طريق إيجاد أقرب صورة عينة على مجمع التدريب عن طريق تصغير دالة الطاقة.
<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>الشكل 11</b>: الصورة المعاد بناؤها من <b>الشكل 10</b>
</center>


### تسمية توضيحية للصورة

<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>الشكل 12</b>: مثال على تسمية توضيحية للصورة
</center>

تتم الترجمة من وصف النص إلى صورة في الشكل 12 عن طريق استخراج تمثيلات لخصائص النص المرتبطة بالمعلومات المرئية المهمة ثم فك تشفيرها إلى صور.

## [ماهي المشفرات الذاتية؟](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

المشفرات الذاتية عبارة عن شبكات عصبية اصطناعية ، يتم تدريبها بطريقة غير خاضعة للإشراف ، وتهدف إلى تعلم التمثيلات المشفرة للبيانات أولاً ثم إنشاء بيانات إدخال (قدر الإمكان) من التمثيلات المشفرة المكتسبة. وبالتالي ، فإن المخرج من المشفر الذاتي هو توقعه للمدخلات.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>الشكل 13</b>: البناء لمشفر ذاتي بسيط<br>
</center>

يوضح الشكل 13 بنية مشفر ذاتي بسيط. كما ذكرنا في السابق ، نبدأ من الأسفل بالمدخل $ \ boldsymbol {x} $ الذي يخضع لمشفر (التحويل الأفيني المحدد بواسطة $ \ boldsymbol {W_h} $ ، متبوعًا بالضغط). ينتج عن هذا الطبقة المخفية الوسيطة $ \ boldsymbol {h} $. هذا يخضع لمفكك التشفير (تحويل أفيني آخر محدد بواسطة $ \ boldsymbol {W_x} $ متبوعًا بسحق آخر). ينتج عن هذا الإخراج $ \ boldsymbol {\ hat {x}} $ ، وهو توقع النموذج (إعادة بناء المدخلات). وفقًا لتقليدنا في وصف الشبكات العصبية ، نقول أن هذه شبكة عصبية من 3 طبقات.

يمكننا تمثيل الشبكة أعلاه رياضيا باستخدام المعادلات التالية:

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

We also specify the following dimensionalities:

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>:ملاحظة</b> من أجل تمثيل PCA ، يمكن أن يكون لدينا أوزان ضيقة (أو أوزان مرتبطة) محددة بواسطة $ \ boldsymbol {W_x} \ \ dot {=} \ \ boldsymbol {W_h} ^ \ top $


## لماذا نستخدم المشفرات الذاتية

في هذه المرحلة ، قد تتساءل عن الهدف من توقع الإدخال وما هي تطبيقات أجهزة التشفير التلقائية.

التطبيقات الأساسية لوحدة التشفير الذاتي هي اكتشاف عيوب أو تقليل تشويش الصورة. نحن نعلم أن مهمة المشفر الذاتي هي أن تكون قادرة على إعادة بناء البيانات التي تعيش في المجمع للبيانات في حالة وجود مجمع للبيانات كمعطى ، نود أن يكون برنامج التشفير الذاتي قادرًا على إعادة بناء المدخلات الموجودة في هذا المجمع فقط. وبالتالي نحن نقيد النموذج لإعادة بناء الأشياء التي تمت ملاحظتها أثناء التدريب ، وبالتالي سيتم إزالة أي اختلاف موجود في المدخلات الجديدة لأن النموذج سيكون غير حساس لتلك الأنواع من الاضطرابات.

هناك تطبيق آخر لوحدة التشفير التلقائي ألا وهو ضغط الصور. إذا كان لدينا أبعاد وسيطة عددها $ d $ أقل من أبعاد الإدخال التي عددها $ n $ ، فيمكن استخدام المشفر كضاغط وستعالج التمثيلات المخفية (التمثيلات المشفرة) جميع (أو معظم) المعلومات الموجودة في إدخال ما ولكن ستأخذ مساحة أقل.

## خسارة إعادة البناء

دعونا نلقي نظرة الآن على خسائر إعادة البناء التي نستخدمها بشكل عام. يتم إعطاء الخسارة الإجمالية لمجموعة البيانات كمتوسط خسارة لكل عينة ، أي

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

عندما يكون الإدخال فئويًا (categorical) ، يمكننا استخدام خسارة مقدار الاضطراب البيني (cross-entropy loss) لكل عينة والتي يتم حسابها بواسطة

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

وعندما تكون المدخلات ذات قيمة حقيقية ، فقد نرغب في استخدام متوسط خسارة الخطأ التربيعي كما يلي

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$


## طبقة مخفية غير مكتملة أو مكتملة للغاية

عندما تكون أبعاد الطبقة المخفية $ d $ أقل من أبعاد المدخلات $ n $ فإننا نقول إنها تحت طبقة مخفية كاملة. وبالمثل ، عندما $ d> n $ ، نسميها طبقة مخفية مكتملة. يُظهر الشكل 14 طبقة مخفية غير مكتملة على اليسار وطبقة مخفية مكتملة على اليمين.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>الشكل 14</b>: طبقة مخفية غير مكتملة مقارنة بطبقة مخفية مكتملة للغاية<br>
</center>

كما ذكرنا مسبقا ، يمكن استخدام طبقة مخفية غير مكتملة للضغط لأننا نقوم بتشفير المعلومات من الإدخال بأبعاد أقل. من ناحية أخرى ، في طبقة مكتملة للغاية ، نستخدم تشفيرا بأبعاد أعلى من الإدخال. هذا يجعل عملية التحسين الأقصى (optimization) أسهل.

نظرًا لأننا نحاول إعادة بناء المدخلات ، فإن النموذج عرضة لنسخ جميع خصائص المدخلات إلى الطبقة المخفية وتمريرها كإخراج وبالتالي تتصرف بشكل أساسي كدالة هوية . يجب تجنب ذلك لأن هذا يعني أن نموذجنا فشل في تعلم أي شيء. وبالتالي ، نحتاج إلى تطبيق بعض القيود الإضافية من خلال تطبيق عنق الزجاجة للمعلومات. نقوم بذلك عن طريق تقييد التكوينات الممكنة التي يمكن للطبقة المخفية اتخاذها فقط لتلك التكوينات التي يتم رؤيتها أثناء التدريب. يسمح ذلك بإعادة البناء الانتقائي ( الذي يقتصر على مجموعة فرعية من فراغ الإدخال) ويجعل النموذج غير حساس لكل شيء ليس في المجمع.

وتجدر الإشارة إلى أن الطبقة غير المكتملة لا يمكن أن تتصرف كدالة هوية لمجرد أن الطبقة المخفية لا تحتوي على أبعاد كافية لنسخ المدخلات. وبالتالي فإن الطبقة المخفية غير المكتملة أقل احتمالا أن تفرط في التلائم من الطبقة المخفية المكتملة ولكن لا يزال من الممكن أن تفعل ذلك. على سبيل المثال ، إذا كان لدينا وحدة تشفير ووحدة فك تشفير قويتان، يمكن للنموذج ببساطة ربط رقم واحد بكل نقطة بيانات وتعلم التحويل. هناك عدة طرق لتجنب الإفراط في التلائم مثل أساليب التنظيم والأساليب المعمارية وما إلى ذلك.


## المشفر الذاتي المزيل للضوضاء

يوضح شكل 15 شكل المجمع للمشفر الذاتي المزيل للضوضاء و الفكرة وراء كيفية عمله

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>الشكل 15</b>:المشفر الذاتي المزيل للضوضاء<br>
</center>

في هذا النموذج ، نفترض أننا نقوم بحقن نفس التوزيع المشوش الذي سنلاحظه في الواقع ، حتى نتمكن من تعلم كيفية التعافي منه بقوة.
من خلال مقارنة المدخلات والمخرجات ، يمكننا أن نقول أن النقاط الموجودة بالفعل في المجمع لم تتحرك ، وأن النقاط التي كانت بعيدة عن المجمع تحركت كثيرًا.

يعطي الشكل 16 العلاقة بين بيانات الإدخال وبيانات الإخراج.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>الشكل 16</b>: المدخلات و المخرجات للمشفر الذاتي المزيل للضوضاء<br>
</center>

يمكننا أيضًا استخدام ألوان مختلفة لتمثيل مسافة تحرك كل نقطة إدخال ، يوضح الشكل 17 الرسم التخطيطي لذلك.
<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>الشكل 17</b>: حساب المسافة المقطوعة للبيانات المدخلة<br>
</center>

كلما كان اللون أفتح ، زادت المسافة التي قطعتها النقطة. يمكننا ملاحظة من الرسم التخطيطي أن النقاط الموجودة في الزوايا تتحرك بالقرب من وحدة واحدة ، في حين أن النقاط الموجودة داخل الفرعين لم تتحرك على الإطلاق نظرًا لأنها مربوطة بالفروع العلوية والسفلية أثناء عملية التدريب.

## المشفر الذاتي التبايني

يوضح الشكل 18 دالة الخسارة للمشفر الذاتي التابيني و المجمع.
Fig.18 shows the loss function of the contractive autoencoder and the manifold.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>الشكل 18</b>:المشفر الذاتي التبايني<br>
</center>

تحتوي دالة الخسارة على جزء إعادة البناء بالإضافة إلى القاعدة التربيعية لتدرج التمثيل الخفي بالنسبة إلى المدخلات. لذلك ، ستقلل الخسارة الإجمالية من تباين الطبقة المخفية نظرًا لتباين المدخلات. وتتمثل الفائدة في جعل النموذج حساسًا لاتجاهات إعادة البناء في حين أنه غير حساس لأي اتجاهات أخرى محتملة.

يوضح الشكل 19 كيفية عمل ذلك المشفر الذاتي بشكل عام.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>الشكل 19</b>:مشفر ذاتي بسيط <br>
</center>

مجمع التدريب هو كائن أحادي البعد يسير في ثلاثة أبعاد. حيث أن $ \ boldsymbol {x} \ in \ boldsymbol {X} \ subseteq \ mathbb {R} ^ {n} $ ، الهدف من المشفر الذاتي هو تمديد الخط المتعرج في اتجاه واحد ، حيث أن $ \ boldsymbol {z} \ in \ boldsymbol {Z} \ subseteq \ mathbb {R} ^ {d} $. نتيجة لذلك ، سيتم تحويل نقطة من طبقة الإدخال إلى نقطة في الطبقة الكامنة. الآن لدينا الملائمات بين النقاط في فراغ الإدخال والنقاط الموجودة في الفضاء الكامن ولكن ليس لدينا الملائمات بين مناطق فراغ الإدخال ومناطق الفضاء الكامن. بعد ذلك ، سوف نستخدم وحدة فك التشفير لتحويل نقطة من الطبقة الكامنة لإنشاء طبقة إخراج ذات معنى.

## [تنفيذ المشفر الذاتي - دفتر (notebook)](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

يمكن العثور على دفتر جوبيتر (Jupyter) [هنا] (https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).

في هذا الدفتر ، سنقوم بتنفيذ برنامج تشفير ذاتي قياسي وجهاز تشفير ذاتي مقلل الضوضاء ثم مقارنة المخرجات خاصتهما.


### تعريف بنية نموذج المشفر الذاتي و خسارة إعادة البناء

سنستخدم $28 \times 28& صورة و طبقة مخفية مكونة من 30 بعدًا. التحويل سيتم من $784\to30\to784$.  من خلال تطبيق دالة الظل الزائدية على وظيفة المشفر و وظيفة فك التشفير ، يمكننا تقييد نطاق الإخراج بـ $ (- 1 ، 1) $. سيتم استخدام متوسط خسارة الخطأ التربيعي (MSE) كدالة خسارة لهذا النموذج. 

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```


### تدريب مشفر ذاتي قياسي

لتدريب برنامج تشفير تلقائي قياسي باستخدام PyTorch ، تحتاج إلى وضع الدالات الخمس التالية في حلقة التدريب:


####: المضي قدمًا

1- إرسال الصورة المدخلة للنموذج عن طريق استدعاء: `output = model(img)` . <br>
2- حساب الخسارة عن طريق: `criterion(output, img.data)`.


####العودة للخلف:

3- امسح قيمة التدرج للتأكد من أننا لا نراكم القيمة `optimizer.zero_grad()`. <br>
4- الإنتشار الخلفي `loss.backward()`<br>
5-خذ خطوة تراجع للخلف  `optimizer.step()`

يوضح الشكل 20 إخراج وحدة التشفير القياسية.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>الشكل 20</b>المخرج من المشفر الذاتي <br>
</center>
<br/>


### تدريب مشفر ذاتي مزيل للضوضاء

يجب إضافة الخطوات التالية للمشفر الذاتي المزيل للضوضاء<br>
1- استدعاء `nn.Dropout()` حتى نغلق الخلايا العصبية بشكل عشوائي.<br>
`do(torch.ones(img.shape))`.<br>2- نخلق قناع للضوضاء: 
3- نخلق صور سيئة عن طريق الضرب الحسابي للصور الجيده مع الأقنعة الثنائية  `img_bad = (img * noise).to(device)`.


يوضح الشكل 21 إخراج وحدة التشفير القياسية المزيلة للضوضاء.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>الشكل 21</b>مخرجات المشفر الذاتي المزيل للضوضاء <br>
</center>


### مقارنة النوى (kernels)
من المهم ملاحظة أنه على الرغم من أن أبعاد الصور المدخلة هي $28 \times 28 = 784$ فإن الطبقة المخفية ذات البعد 500 لا تزال طبقة مكتملة للغاية بسبب عدد النقاط السوداء في الصورة.
فيما يلي أمثلة على النوى المستخدم في  المشفر الذاتي القياسي الغير الكامل المدرب. من الواضح أن وحدات البكسل (النقاط) في المنطقة التي يوجد بها الرقم تشير إلى اكتشاف نوع من الأنماط ، في حين أن وحدات البكسل الموجودة خارج هذه المنطقة عشوائية بشكل أساسي. يشير هذا إلى أن  المشفر الذاتي القياسي لا يهتم بالبكسل خارج المنطقة التي يوجد بها الرقم. 

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>الشكل 22:</b> نوى المشفر الذاتي القياسي
</center>

من ناحية أخرى ، عندما يتم تغذية نفس البيانات إلى مشفر ذاتي مقلل للضوضاء حيث يتم تطبيق قناع غلق الخلايا العصبية على كل صورة قبل ملائمة النموذج ، يحدث شيء مختلف. كل نواة تتعلم نمطًا ما تقوم بتعيين وحدات البكسل خارج المنطقة حيث يوجد الرقم بقيمة ثابتة. نظرًا لتطبيق قناع الغلق على الصور ، فإن النموذج يهتم الآن بالبكسل خارج منطقة الرقم.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>الشكل 23:</b> نوى المشفر الذاتي المقلل للضوضاء.
</center>

بالمقارنة مع أحدث ما توصلت إليه التكنولوجيا ، فإن برنامج المشفر الذاتي لدينا يعمل بشكل أفضل !! يمكنك ان ترى النتائج اسفل.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>الشكل 24:</b> بيانات الإدخال (MNIST أرقام).
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>الشكل 25:</b> إعادة البناء للمشفر الذاتي المقلل للضوضاء.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>الشكل 26:</b> Telea المخرج لإعادة رسم.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>الشكل 27:</b> Navier-Stokes المخرج لإعادة رسم.
</center>
