---
lang: ar
lang-ref: ch.07-1
lecturer: Yann LeCun
title: النماذج المعتمدة على الطاقة
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translator: Haya Alsharif
translation-date: 7 Feb 2021
---


<!-- ## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s) -->
## [نظرة عامة](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

<!-- We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:

1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities. -->

سوف نقدم إطارًا جديدًا لتعريف النماذج. يوفر مظلة موحدة تساعد في تحديد النماذج بالإشراف، وبدرن إشراف، وبالإشراف الذاتي. تلاحظ النماذج المعتمدة على الطاقة (energy-based models) مجموعة من المتغيرات $x$ وتخرج مجموعة من المتغيرات $y$. هناك مشكلتان رئيسيتان في شبكات التغذية الأمامية:

1. ماذا لو كان إجراء التنبؤ عملية حسابية أكثر تعقيدًا من طبقات المجاميع الموزونة؟
2. ماذا لو كان هناك العديد من المخرجات الممكنة لمدخل واحد؟ مثال: توقع إطارات الفيديو المستقبلية. في شبكات التصنيف، نقوم بتدريب هذه الشبكات لإصدار درجة لكل فئة. ومع ذلك، لا يمكن القيام بذلك في مجال مستمر عالي الأبعاد مثل الصور. (لا يمكن أن يكون لدينا softmax على الصور!). حتى إذا كان الإخراج متقطعًا، فقد يحتوي على مساحة عينات كبيرة. على سبيل المثال، النص تركيبي وبالتالي يؤدي إلى عدد كبير من التركيبات الممكنة. توفر النماذج القائمة على الطاقة إطارًا أفضل لنمذجة هذه الطرق.

<!-- ## EBM approach -->
## نهج EBM

<!-- Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`? -->

بدلاً من محاولة تصنيف العديد من الـ $x$ إلى العديد من الـ $y$، نود أن نتوقع ما إذا كان زوج معين من ($x, y$) مناسبًا أم لا. أو بعبارة أخرى، ابحث عن $y$ متوافق مع $x$. يمكننا أيضًا أن نطرح المشكلة على أنها إيجاد $y$ الذي يكون فيه $F(x,y)$ ما بقيمة منخفصة. فمثلا:

- هل $y$ صورة دقيقة بجودة عالية لـ $x$؟
- هل النص `A` ترجمة جيدة للنص `B`؟

<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
 -->


<!-- ### Definition -->
### تعريف

<!-- We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation: -->

نعرف دالة الطاقة $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ حيث تصف $F(x,y)$ مستوى التبعية بين أزواج $(x,y)$. (**لاحظ** أن هذه الطاقة تُستخدم في التنبؤ، **وليس** في التعلم.) يتم التنبؤ بالمعادلة التالية:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


<!-- ### Solution: gradient-based inference -->
### الحل: التنبؤ القائم على التدرج

<!-- We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring. -->

نود أن تكون دالة الطاقة سلسة وقابلة للتفاضل حتى نتمكن من تطبيق أدوات التدرج للتنبؤ. من أجل التنبؤ، نقوم بالبحث في هذه الدالة باستخدام الانحدار التدرجي للعثور على $y$ المتوافق.
هناك العديد من الطرق البديلة لطرق التدرج للحصول على الحد الأدنى.

**نقطة جانبية**: النماذج الرسومية هي حالة خاصة للنماذج القائمة على الطاقة. تتكون دالة الطاقة من مجموع أطراف الطاقة. تأخذ كل مصطلحات الطاقة في الحسبان مجموعة فرعية من المتغيرات التي نتعامل معها. إذا تم تنظيمهم في شكل معين، فهناك خوارزميات التنبؤ فعالة للعثور على الحد الأدنى لمجموع المصطلحات فيما يتعلق بالمتغير الذي نحن مهتمون بالتنبؤ به.

<!-- There are a type of Energy Based Models that are quite popular. These are
 -->

<!-- ## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s) -->
## [EBM مع المتغيرات الكامنة](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

<!-- The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (*e.g.* French). Hence, having this latent variable in our model will be very useful to interpret such an input. -->

يعتمد الناتج $y$ على $x$ بالإضافة إلى متغير إضافي $z$ (المتغير الكامن) الذي لا نعرف قيمته. يمكن أن توفر هذه المتغيرات الكامنة معلومات مساعدة. على سبيل المثال، يمكن أن يخبرك المتغير الكامن بمواضع حدود الكلمات في جزء من النص. سيكون هذا مفيدًا لمعرفة متى نريد تفسير الكتابة اليدوية بدون مسافات. هذا مفيد أيضًا بشكل خاص لمعرفة الكلام الذي يمكن أن يكون به فجوات يصعب فك تشفيرها. بالإضافة إلى ذلك، تحتوي بعض اللغات على حدود كلمات باهتة جدًا (*على سبيل المثال* الفرنسية). ومن ثم، فإن وجود هذا المتغير الكامن في نموذجنا سيكون مفيدًا جدًا لتفسير مثل هذا المدخلات.

<!-- ### Inference -->
### التنبؤ

<!-- To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z. -->
للقيام بالتنبؤ باستخدام EBM مع المتغير الكامن، نريد تقليل دالة الطاقة في نفس الوقت بالنسبة لـ $y$ و$z$.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

<!-- And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$. -->

وهذا يعادل إعادة تعريف دالة الطاقة على النحو التالي: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$، والذي يساوي: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
عندما تكون $\beta \rightarrow \infty$، فإن $\check{y} = \text{argmin}_{y}F(x,y)$.

<!--  ## Latent-Variable EBM -->
<!-- Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one. -->

ميزة أخرى كبيرة للسماح بالمتغيرات الكامنة، هي أنه من خلال تغيير المتغير الكامن على مجموعة، يمكننا أن نجعل ناتج التنبؤ $y$ يتشكل حسب مجموعة التنبؤات المحتملة أيضًا (يظهر الشريط في الرسم البياني أدناه): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

هذا يسمح للآلة بإنتاج نواتج متعددة، وليس واحدة فقط.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>شكل 1</b>: الرسم البياني الحسابي للنماذج القائمة على الطاقة
</center>


<!-- ### Examples -->
### أمثلة

<!-- One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced. -->

أحد الأمثلة على ذلك هو توقع الفيديو. هناك العديد من التطبيقات الجيدة لاستخدام التنبؤ بالفيديو، ومن الأمثلة على ذلك إنشاء نظام ضغط الفيديو. تطبيق آخر هو استخدام فيديو مأخوذ من سيارة ذاتية القيادة والتنبؤ بما ستفعله السيارات الأخرى.

مثال آخر هو الترجمة. لطالما كانت ترجمة اللغة مشكلة صعبة لأنه لا توجد ترجمة صحيحة واحدة لجزء من النص من لغة إلى أخرى. عادة، هناك الكثير من الطرق المختلفة للتعبير عن نفس الفكرة ويجد الناس صعوبة في تفسير سبب اختيارهم لأحدهم على الآخر. لذلك قد يكون من الجيد أن يكون لدينا طريقة ما لتحديد جميع الترجمات الممكنة التي يمكن أن ينتجها النظام للرد على نص معين. لنفترض أنه إذا أردنا الترجمة من الألمانية إلى الإنجليزية، فقد تكون هناك ترجمات متعددة باللغة الإنجليزية كلها صحيحة، ومن خلال تغيير بعض المتغيرات الكامنة، يمكنك تغيير الترجمة المنتجة.

<!-- ## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s) -->
## [النماذج القائمة على الطاقة *مقابل* النماذج الاحتمالية](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

<!-- We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is: -->
يمكننا النظر إلى الطاقات على أنها احتمالات لوقارثمية سالبة بدون تسوية، واستخدام توزيع Gibbs-Boltzmann للتحويل من الطاقة إلى الاحتمال بعد التسوية هو:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

<!-- where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero). -->
حيث يكون $\beta$ ثابتًا موجبًا ويحتاج إلى معايرته لتناسب نموذجك. يعطي $\beta$ الأكبر نموذجًا أكثر تقلبًا بينما يعطي $\beta$ الأصغر نموذجًا أكثر سلاسة. (في الفيزياء ، $\beta$ هو درجة حرارة معكوسة: $\beta \rightarrow \infty$ يعني أن درجة الحرارة تذهب إلى الصفر).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

<!-- Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have: -->
الآن إذا أوجدنا دالة الاحتمال الهامشية بالنسبة إلى $y$: $P(y \mid x) = \int_z P(y,z \mid x)$، يصبح لدينا:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

<!-- Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy) -->

وبالتالي، إذا كان لدينا نموذج متغير كامن وأردنا استبعاد المتغير الكامن $z$ بطريقة صحيحة احتمالية، فنحن نحتاج فقط إلى إعادة تعريف دالة الطاقة $F_\beta$ (الطاقة الحرة)

<!-- ### Free Energy -->
### الطاقة الحرة

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

<!-- Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.

Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy. -->

قد يكون حساب هذا صعبًا جدًا... في الواقع ، في معظم الحالات، من المحتمل أن يكون الأمر صعب الحل. لذلك إذا كان لديك متغير كامن تريد تصغيره داخل نموذجك، أو إذا كان لديك متغير كامن تريد تهميشه (وهو ما تفعله من خلال تحديد دالة الطاقة $F$)، والتقليل يتوافق مع حد $\beta$ اللانهائي لهذه الصيغة، ثم يمكن القيام بذلك.

بموجب تعريف $F_\beta(x, y)$ أعلاه ، فإن $P(y \mid x)$ هو مجرد تطبيق لصيغة Gibbs-Boltzmann وتم تهميش $z$ ضمنيًا داخها. يسمي الفيزيائيون ذلك "بالطاقة الحرة" ، ولهذا نسميها $F$. إذن، $e$ هي الطاقة، و $F$ هي الطاقة الحرة.

<!-- ***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.*** -->
***سؤال: هل يمكنك توضيح الميزة التي تقدمها النماذج القائمة على الطاقة؟ في النماذج المستندة على الاحتمالات، يمكن أن يكون لديك أيضًا متغيرات كامنة يمكن تهميشها.***

<!-- The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, way more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them. -->

الفرق هو أنه في النماذج الاحتمالية، ليس لديك في الأساس خيار الدالة الموضوعية التي ستقوم بتقليلها، وعليك أن تظل صادقًا مع الإطار الاحتمالي، بمعنى أن كل عنصر تتلاعب به يجب أن يكون ذو توزيع احتمال طبيعي (والذي يمكنك تقريبه باستخدام طرق التباين، وما إلى ذلك). هنا، نقول إن ما تريد فعله بهذه النماذج هو اتخاذ القرارات. إذا قمت ببناء نظام يقود سيارة، ويخبرك النظام "أحتاج إلى الانعطاف يسارًا مع احتمال 0.8 أو الانعطاف يمينًا مع احتمال 0.2"، فسوف تنعطف يسارًا. حقيقة أن الاحتمالين 0.2 و 0.8 لا يهم - ما تريده هو اتخاذ القرار الأفضل، لأنك مضطر لاتخاذ قرار. لذا فإن الاحتمالات غير مجدية إذا كنت ترغب في اتخاذ قرارات. إذا كنت ترغب في الجمع بين مخرجات نظام آلي وآخر (على سبيل المثال، نظام بشري أو نظام آخر)، ولم يتم تدريب هذه الأنظمة معًا، بل تم تدريبها بشكل منفصل، فما تريده هو درجات معايرة بحيث يمكنك الجمع بين درجات النظامين حتى يمكنك اتخاذ قرار جيد. هناك طريقة واحدة فقط لمعايرة الدرجات، وهي تحويلها إلى احتمالات. جميع الطرق الأخرى إما أقل شأنا أو مكافئة. ولكن إذا كنت ستقوم بتدريب نظام من البداية إلى النهاية على اتخاذ القرارات، فإن دالة حساب النتائج التي تستخدمها ستكون جيدة، طالما أنها تعطي أفضل نتيجة للقرار الأفضل. تمنحك النماذج القائمة على الطاقة المزيد من الخيارات في كيفية التعامل مع النموذج، وخيارات أكثر لكيفية تدريبه، والوظيفة الموضوعية التي تستخدمها. إذا كنت تصر على أن نموذجك احتمالي، فعليك استخدام أقصى احتمالية - عليك بشكل أساسي تدريب النموذج الخاص بك بطريقة تجعل الاحتمالية التي يقدمها للبيانات التي لاحظتها هي الحد الأقصى. تكمن المشكلة في أن هذا لا يمكن إثبات فعاليته إلا في الحالة التي يكون فيها نموذجك "صحيحًا" - ولن يكون نموذجك "صحيحًا" أبدًا. هناك اقتباس من عالم الإحصاء الشهير [Goerge Box] يقول فيه ***"كل النماذج خاطئة ، لكن بعضها مفيد."*** لذا فالنماذج الاحتمالية، لا سيما تلك الموجودة في المساحات عالية الأبعاد، وفي المساحات المتراكبة مثل النص، كلها نماذج تقريبية. كلهم مخطئون بطريقة ما، وإذا حاولت تطبيعهم، فإنك تجعلهم أكثر خطأ. لذلك من الأفضل عدم تطبيعهم.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>شكل 2</b>: تصور دالة الطاقة التي تلتقط التبعية بين x و y
</center>

<!-- This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example: -->

هذه دالة طاقة تهدف إلى التقاط التبعية بين *x* و*y*. إنها مثل سلسلة جبال إذا صح التعبير. الوديان هي المكان الذي توجد فيه النقاط السوداء (نقاط البيانات)، وهناك جبال في كل مكان. إذا قمت بتدريب نموذج احتمالي على ذلك، تخيل أن النقاط موجودة في الواقع على مشعب (manifold) رفيع للغاية. لذا فإن توزيع البيانات للنقاط السوداء هو في الواقع مجرد خط، وهناك ثلاثة منهم. ليس لديهم في الواقع أي عرض. لذلك إذا قمت بتدريب نموذج احتمالي، يجب أن يخبرك عندما تكون على هذا المشعب. في هذا المشعب، تكون الكثافة غير محدودة، ويجب أن يكون $\varepsilon$ خارجها فقط صفرًا. سيكون هذا هو النموذج الصحيح لهذا التوزيع. لا يجب أن تكون الكثافة لانهائية فحسب، بل يجب أن يكون التكامل على [x و y] يساوي 1. وهذا أمر صعب التنفيذ في الكمبيوتر! ليس ذلك فحسب، بل إنه مستحيل في الأساس. لنفترض أنك تريد حساب هذه الدالة من خلال نوع من الشبكة العصبية - يجب أن تحتوي شبكتك العصبية على أوزان غير محدودة، وستحتاج إلى معايرتها بطريقة تجعل تكامل ناتج هذا النظام على النطاق بأكمله هو 1. هذا مستحيل في الأساس. النموذج الاحتمالي الدقيق والصحيح لمثال البيانات هذا مستحيل. هذا هو ما يريد منك الاحتمال الأقصى (maximum likelihood) إنتاجه، ولا يوجد كمبيوتر في العالم يمكنه حساب ذلك. لذا في الحقيقة، إنها ليست مثيرة للاهتمام. تخيل أن لديك نموذج الكثافة المثالي لهذا المثال، وهو عبارة عن لوحة رفيعة في تلك المساحة (x, y) - لا يمكنك التنبؤ! إذا أعطيتك قيمة x ، وسألتك "ما هي أفضل قيمة لـ y؟" لن تتمكن من العثور عليه لأن جميع قيم y باستثناء مجموعة الاحتمال الصفري لها احتمالية تساوي صفرًا، وهناك عدد قليل من القيم الممكنة. على سبيل المثال، لقيم x هذه:

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>شكل 3</b>: Example for multiple prediction of EBM as an implicit function
</center>

<!-- There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]! -->

هناك 3 قيم محتملة لـ y ، وهي ضيقة بشكل لا نهائي. لذلك لن تتمكن من العثور عليهم. لا توجد خوارزمية استدلال تسمح لك بالعثور عليها. الطريقة الوحيدة التي يمكنك من خلالها العثور عليها هي إذا قمت بجعل دالة التباين سلسة وقابلة للتفاضل، وبعد ذلك يمكنك البدء من أي نقطة ومن خلال الانحدار التدرجي يمكنك العثور على قيمة جيدة لـ y لأي قيمة x. لكن هذا لن يكون نموذجًا احتماليًا جيدًا للتوزيع إذا كان التوزيع من النوع الذي ذكرته. إذًا، هذه حالة يكون فيها الإصرار على الحصول على نموذج احتمالي جيد أمرًا سيئًا بالفعل. يعد الاحتمال الأقصى في غاية السوء [في هذه الحالة]!

<!-- So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regulariser})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser. -->

لذا، إذا كنت بايزيًا (Bayesian) حقيقيًا ، فأنت تقول "أوه، لكن يمكنك تصحيح هذا من خلال وجود سابق (prior) قوي حيث يدل السابق على أن دالة الكثافة الخاصة بك يجب أن تكون سلسة". يمكنك التفكير في هذا على أنه سابق. لكن، كل ما تفعله بمصطلحات بايز - خذ لوغاريثمة، انسَ التسوية - تحصل على نماذج قائمة على الطاقة. النماذج القائمة على الطاقة والتي تحتوي على منظم، وهو مضاف إلى دالة الطاقة الخاصة بك، مكافئة تمامًا لنماذج بايز حيث يكون الاحتمال أسيًا بالنسبة للطاقة، فتحصل على $\exp(\text{energy}) \exp(\text{regulariser})$، وبالتالي فهي تساوي $\exp(\text{energy} + \text{regulariser})$. وإذا قمت بإزالة العامل الأسي، فسيكون لديك نموذج قائم على الطاقة مع إضافة منظم.

<!-- So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong. -->

لذلك هناك تطابق بين الطرق الاحتمالية والبايزية، لكن الإصرار على استخدام الاحتمال الأقصى هو أمر سيئ أحيانًا بالنسبة لك، خاصة في الفضاءات عالية الأبعاد أو الفضاءات التوافقية حيث يكون نموذجك الاحتمالي خاطئًا للغاية. إنه ليس في غاية الخطأ في التوزيعات المتقطعة (لا بأس به) ولكن في الحالات المستمرة، يمكن أن يصبح خاطئًا للغاية. وجميع النماذج خاطئة.