---
lang-ref: ch.06-2
lang: ar
lecturer: Yann LeCun
title: الشبكات العصبية التكرارية، وحدات البوابات المتكررة، الذاكرة القصيرة المدى المطولة، الانتباه، تسلسل/تسلسل و شبكة الذاكرة.
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 Mar 2020
translation-date: 5 Sep 2020
translator: Ali Elfilali
---

<!-- ## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.

As with what we saw with convolutional networks, network architecture is important. -->


## [معماريات التعلم العميق](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

في التعلم العميق، هناك نماذج مختلفة لأداء مهام مختلفة. تتضمن خبرة التعلم العميق تصميم المعماريات (الخوارزميات) لإنجاز مهام معينة. على غرار كتابة برامج باستخدام الخوارزميات لإعطاء تعليمات محددة لجهاز الكمبيوتر كما في الأيام الخوالي، يقلل التعلم العميق من مهمة معقدة إلى رسم بياني للوحدات الوظيفية (ربما الديناميكية)، والتي يتم الانتهاء من مهامها عن طريق التعلم.

كما هو الحال مع ما رأيناه مع الشبكات الإلتفافية، فإن معمارية الشبكة مهمة جدا.


<!-- ## Recurrent Networks

In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.

As shown in Figure 1, there are loops in Recurrent Neural Networks. -->

## الشبكات العصبية التكرارية

في الشبكة العصبية الإلتفافية، لا يمكن أن يحتوي الرسم البياني أو الروابط ما بين النماذج على حلقات (loops). يوجد على الأقل ترتيب جزئي بين النماذج بحيث تكون المدخلات متاحة عندما نحسب المخرجات.

كما هو مبين في الشكل 1، توجد حلقات في الشبكات العصبية التكرارية.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
الشكل  1. إلتفاف الشبكات العصبية التكرارية
</center>


<!-- - $x(t)$ : input that varies across time
- $\text{Enc}(x(t))$: encoder that generates a representation of input
- $h(t)$: a representation of the input
- $w$: trainable parameters
- $z(t-1)$: previous hidden state, which is the output of the previous time step
- $z(t)$: current hidden state
- $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
- $\text{Dec}(z(t))$: decoder that generates an output
-->

- $x(t)$: مدخل يتغير بمرور الوقت.
- $\text{Enc}(x(t))$: مشفِر يقوم بإنشاء تمثيل للمدخل.
- $h(t)$: تمثيل للمدخلات.
- $w$: معاملات قابلة للتدريب.
- $z(t-1)$: الحالة الخفية السابقة، وهي ناتج الخطوة الزمنية السابقة.
- $z(t)$: الحالة الخفية الحالية.
- $g$: دالة يمكن أن تكوِن شبكة عصبية معقدة؛ أحد المدخلات هو $z(t-1)$ وهو ناتج الخطوة الزمنية السابقة.
- $\text{Dec}(z(t))$: وحدة فك الترميز وهي تولِد المخرجات.


<!-- ## Recurrent Networks: Unroll the loop

Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$. -->

## الشبكات العصبية التكرارية: فتح الحلقة

قم بفتح الحلقة بالنسبة للزمن. المدخل عبارة عن تسلسل  `x_T ,....,x_3 ,x_2 ,x_1`


<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
الشكل 2. شبكات عصبية تكرارية ذات حلقات مفتوحة
</center>

<!-- In Figure 2, the input is $x_1, x_2, x_3$.

At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.

As there are no loops in this network, and we can implement backpropagation.

Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.

BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN. -->

في شكل 2، المدخلات هي  $x_1$، $x_2$، و $x_3$.

في الزمن $t=0$، يتم تمرير المدخل $x(0)$ إلى المشفِر ويولِد التمثيل $h(x(0)) = \text{Enc}(x(0))$ ثم يمرره إلى الدالة $G$ لإنشاء الحالة الخفية $z(0) = G(h_0, z', w)$. عند $t=0$، يمكن تهيئة $z'$ في الدالة $G$ كـ $0$ أو تهيئته عشوائيًا. يتم تمرير $z(0)$ إلى مفكك الشفرة لتوليد مخرجات وكذلك توليد الخطوة الزمنية التالية.

نظرًا لعدم وجود حلقات في هذه الشبكة، يمكننا تنفيذ الانتشار العكسي.

يوضح الشكل 2 شبكة منتظمة بخاصية معينة: تشترك كل مجموعة في نفس الأوزان. ثلاثة مشفرات و وحدات فك التشفير و دوال $G$ لها نفس الأوزان على التوالي عبر خطوات زمنية مختلفة.

BPTT: الانتشار العكسي عبر الزمن (Backprop through time). للأسف، BPTT لا يعمل بشكل جيد في الشكل البسيط للـ RNN.

<!-- Problems with RNNs:

1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work. -->

مشاكل  نواجهها الـ RNNs:

1. تلاشي التدرجات
   - في تسلسل طويل، يتم ضرب التدرجات في (transpose أو منقول)مصفوفة الأوزان في كل خطوة زمنية. إذا كانت هناك قيم صغيرة في مصفوفة الوزن، فإن معيار (norm) التدرج يتقلص بمقدار أسي.
2. انفجار التدرجات
   - إذا كانت لدينا مصفوفة ذات أوزان كبيرة و اللاخطية في الطبقة التكرارية غير مشبعة، فسوف تنفجر التدرجات. سوف تتباعد الأوزان في كل خطوة. و قد نُضطر إلى استخدام معدل تعلم صغير حتى يعمل الانحدار التدريجي بشكل جيد.


<!-- One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.

An example that has vanishing gradient problem:

The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program. -->

أحد أسباب استخدام الـ RNNs هو ميزة تذكر المعلومات السابقة. ومع ذلك، قد تفشل RNN بسيطة في حفظ المعلومات لفترة طويلة دون بعض الحيل.

مثال لمشكلة التدرجات المتلاشية:

تمثل المدخلات رموزًا من برنامج بلغة C. سيحدد النظام ما إذا كان برنامجًا صحيحًا نحويًا أم لا. يجب أن يحتوي البرنامج الصحيح نحويًا على عدد صالح من الأقواس. و بالتالي، يجب أن تتذكر الشبكة عدد الأقواس والأقواس المفتوحة التي يجب التحقق منها، و ما إذا كنا قد أغلقناها جميعًها. يجب أيضا على الشبكة تخزين هذه المعلومات في حالات مخفية مثل العداد. ومع ذلك، و بسبب التدرجات المتلاشية، فإنها ستفشل في الحفاظ على هذه المعلومات في برنامج لمدة طويلة.

<!-- ##  RNN Tricks

- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix. -->


##  حيل للشبكات العصبية التكرارية

- قص التدرجات: (بغية تجنب انفجار التدرجات)
اختزل التدرجات عندما تصبح كبيرة جدًا.

- التهيئة: (ابدأ عند المقدار الصحيح لتفادي انفجار/تلاشي التدرجات)
تهيئة مصفوفات الأوزان للحفاظ على المعدل إلى حد ما. على سبيل المثال، تؤدي التهيئة المتعامِدة إلى تهيئة مصفوفة الأوزان كمصفوفة متعامدة عشوائية.

<!-- ## Multiplicative Modules

In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.

Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor. -->


## النماذج المضاعفة

في النماذج المضاعفة بدلاً من حساب فقط مجموع أوزان المدخلات، نقوم بحساب جداء المدخلات ثم نحسب مجموع أوزان ذلك.

نفترض أن $x \in {R}^{n\times1}$، $W \in {R}^{m \times n}$، $U \in {R}^{m \times n \times d}$، و $z \in {R}^{d\times1}$. هنا نجد أن $U$ عبارة عن موتر.

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$

<!-- where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.

Hypernetwork architecture: weights are computed by another network. -->

حيث: $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

مخرجات النظام عبارة عن المجموع الموزون المتعارف عليه للمدخلات والأوزان. الأوزان نفسها هي أيضًا مجموع موزون للأوزان والمدخلات.

معمارية الشبكة الفائقة: يتم حساب الأوزان بواسطة شبكة أخرى.

<!-- ## Attention

$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.

$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.

By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.

The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.

Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.

The weights are data independent because z is data independent. -->

## الانتباه

$x_1$  و  $x_2$ عبارة عن متجهان، $w_1$  و  $w_2$ هما كميتان قياسيتان بعد دخول دالة softmax حيث $w_1 + w_2 = 1$، و $w_1$ و $w_2$ تتراوح ما بين 0 و 1.
$w_1x_1 + w_2x_2$ مجموع موزون لـ $x_1$ و $x_2$ و هو موزون بمعاملات $w_1$ و $w_2$.

من خلال تغيير الحجم النسبي لـ $w_1$ و $w_2$، يمكننا تغيير مُخرج $w_1x_1 + w_2x_2$ إلى $x_1$ أو $x_2$ أو بعض المجموعات الخطية من $x_1$ و $x_2$.

يمكن أن تحتوي المدخلات على متجهات $x$ متعددة (أكثر من $x_1$ و $x_2$). سيختار النظام مجموعة مناسبة، يتم تحديد اختيارها بواسطة متغير آخر $z$. تسمح آلية الانتباه للشبكة العصبية بتركيز انتباهها على مدخلات معينة وتجاهل الآخرين.

يتزايد الاهتمام بالانتباه في أنظمة الـ NLP التي تستخدم بنى المحولات أو أنواع انتباه أخرى.

الأوزان مستقلة عن البيانات لأن $z$ مستقلة عن البيانات.


<!-- ## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below: -->

## [وحدات البوابات المتكررة (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

كما ذكرنا سابقًا، يعاني RNN من تلاشي/انفجار التدرجات ولا يمكنه تذكر الحالات لفترة طويلة جدًا. وحدات البوابات المتكررة [Cho 2014](https://arxiv.org/abs/1406.1078)، هو تطبيق للنماذج المضاعفة التي تحاول حل هذه المشكلات. إنه مثال لشبكة تكرارية مع ذاكرة (LSTM). يظهر هيكل الـ GRU أدناه:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
    الشكل 3. وحدة البوابات المتكررة
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

<!-- where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.

To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.

The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input. -->

حيث تشير $\odot$ إلى الضرب حسب العنصر (عملية ضرب Hadamard).
$x_t$ هو متجه الإدخال، $h_t$ هو متجه الإخراج، $z_t$ هو متجه بوابة التحديث، $r_t$ هو متجه بوابة إعادة الضبط، $\phi_h$ هي دالة الظل الزائدي (tanh)، و $W$، $U$، $b$ هي معاملات قابلة للتعلم.

لأكون دقيقا، فإن $z_t$ عبارة عن متجه بوابة يحدد مقدار المعلومات السابقة التي يجب تمريرها إلى المستقبل. يطبق دالة sigmoid لمجموع طبقتين خطيتين و انحياز على المدخل $x_t$ والحالة السابقة $h_{t-1}$. يحتوي $z_t$ على معاملات بين 0 و 1 نتيجة لتطبيق دالة sigmoid. حالة الإخراج النهائية $h_t$ عبارة عن تركيبة محدبة من $h_{t-1}$ و $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$ عبر $z_t$. إذا كان المعامل يساوي 1، فإن ناتج الوحدة الحالية هو مجرد نسخة من الحالة السابقة و يتم تجاهل المدخلات (و هو السلوك الافتراضي). إذا كان المعامل أقل من واحد، فإنه يأخذ في الاعتبار بعض المعلومات الجديدة من المدخل.

يتم استخدام بوابة إعادة الضبط $r_t$ لتحديد مقدار المعلومات السابقة التي يجب التخلي عنها. في محتوى الذاكرة الجديد $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$، إذا كان معامل $r_t$ هو 0، فإنه لا يخزن أيًا من المعلومات السابقة. أما إذا كانت قيمة $z_t$ تساوي 0 في ذات الوقت، فسيتم إعادة ضبط النظام بالكامل لأن $h_t$ ستنظر فقط إلى المدخل.

<!-- ## LSTM (Long Short-Term Memory)

GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below: -->

## LSTM (Long Short-Term Memory أو الذاكرة القصيرة المدى المطولة)

GRU هي في الواقع نسخة مبسطة من الـ LSTM والتي ظهرت قبل ذلك بكثير، [Hochreiter، Schmidhuber، 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). من خلال بناء خلايا الذاكرة للحفاظ على المعلومات السابقة، تهدف LSTM أيضًا إلى حل مشكلة فقدان الذاكرة على المدى الطويل في RNNs. يظهر هيكل LSTM أدناه:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
الشكل 4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$


<!-- where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.

An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.

Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers. -->


حيث تشير $\odot$ إلى الضرب بالعنصر، $x_t\in\mathbb{R}^a$ هو متجه المدخل إلى وحدة الـ LSTM، $f_t\in\mathbb{R}^h$ هو متجه تنشيط بوابة النسيان، $i_t\in\mathbb{R}^h$ هو متجه تنشيط بوابة الإدخال/التحديث، $o_t\in\mathbb{R}^h$ هو متجه تنشيط بوابة الإخراج، $h_t\in\mathbb{R}^h$ هو متجه الحالة الخفية (المعروف أيضًا باسم الإخراج)، $c_t\in\mathbb{R}^h$ هو متجه حالة الخلية.

تستخدم وحدة LSTM حالة الخلية $c_t$ لنقل المعلومات من خلال الوحدة. ينظم كيفية حفظ المعلومات أو إزالتها من حالة الخلية من خلال هياكل تسمى البوابات. تحدد بوابة النسيان $f_t$ مقدار المعلومات التي نريد الاحتفاظ بها من حالة الخلية السابقة $c_{t-1}$ وذلك بالنظر إلى المدخلات الحالية والحالة الخفية السابقة، وتنتج رقمًا بين 0 و 1 كمعامل $c_{t-1}$. $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ يحسب مرشحًا جديدًا لتحديث حالة الخلية، ومثل بوابة النسيان، تحدد بوابة الإدخال $i_t$ مقدار التحديث الذي سيتم تطبيقه. أخيرًا، سيعتمد الإخراج $h_t$ على حالة الخلية $c_t$، ولكن سيتم تمريره عبر دالة الـ $\tanh$ ثم تصفيته بواسطة بوابة الإخراج $o_t$.

على الرغم من أن LSTM تُستخدَم على نطاق واسع في الـ NLP، إلا أن شعبيتها آخذة في التناقص شيئا فشيئا. على سبيل المثال، يتجه التعرف على الكلام نحو استخدام CNN زمنية، ويتجه مجال الـ NLP نحو استخدام المحولات.


<!-- ## Sequence to Sequence Model

The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs. -->

## نموذج تسلسل إلى تسلسل (Seq2Seq)

النهج الذي اقترحه [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) هو أول نظام آلي عصبي للترجمة له أداء مشابه للأنظمة الكلاسيكية. فهو يستخدم معمارية التشفير و فك التشفير حيث يكون كل من المشفر و وحدة فك التشفير عبارة عن شبكة LSTM متعددة الطبقات.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
الشكل 5. Seq2Seq
</center>

<!-- Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.

This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information. -->

كل خلية في الشكل هي LSTM. بالنسبة لبرنامج التشفير (الجزء الموجود على اليسار)، فإن عدد الخطوات الزمنية يساوي طول الجملة المراد ترجمتها. في كل خطوة، توجد مجموعة من LSTMs (أربع طبقات في هذه الورقة) حيث يتم تمرير الحالة الخفية للـ LSTM  السابقة إلى المرحلة التالية. مخرجات الطبقة الأخيرة في الخطوة الزمنية الأخيرة عبارة عن متجهٍ يمثل معنى الجملة بأكملها، والتي يتم إدخالها بعد ذلك في LSTM أخرى متعددة الطبقات (وحدة فك التشفير)، والتي تنتج كلمات في اللغة المراد الترجمة إليها. في وحدة فك التشفير، يتم إنشاء النص بطريقة متسلسلة. تنتج كل خطوة كلمة واحدة يتم تغذيتها كمدخل للخطوة الزمنية التالية.

هذه المعمارية غير مرضية من ناحيتين: أولاً، يجب تلخيص المعنى الكامل للجملة في الحالة الخفية بين المشفر و وحدة فك التشفير. ثانيًا، لا تحتفظ شبكات LSTMs بالمعلومات لأكثر من 20 كلمة تقريبًا. يتم إصلاح هذه المشكلات بواسطة Bi-LSTM، والذي يقوم بتشغيل وحدتي LSTM في اتجاهين متعاكسين. في Bi-LSTM يتم ترميز المعنى في متجهين، أحدهما يتم إنشاؤه عن طريق تشغيل LSTM من اليسار إلى اليمين، والآخر من اليمين إلى اليسار. هذا يسمح بمضاعفة طول الجملة دون فقدان الكثير من المعلومات.

<!--
## Seq2seq with Attention

The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, *i.e.* the attention mechanism. -->

## Seq2seq مع الانتباه

كان نجاح النظام أعلاه قصير الأجل. حيث اقترح بحث آخر بقلم [Bahdanau، Cho، و Bengio](https://arxiv.org/abs/1409.0473) أنه بدلاً من وجود شبكة عملاقة تختصر معنى الجملة بأكملها في متجه واحد، سيكون من المنطقي أكثر إذا ركزنا الانتباه فقط في كل خطوة على المواقع ذات الصلة في لغة النص الأصلي و ذات معنى مكافئ، *أي* آلية الانتباه.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
الشكل 6. Seq2Seq مع الانتباه
</center>

<!-- In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!

Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention. -->

في آلية الانتباه، لإنتاج الكلمة الحالية في كل خطوة زمنية، نحتاج أولاً إلى تحديد التمثيلات الخفية للكلمات في الجملة المدخلة التي يجب التركيز عليها. بشكل أساسي، ستتعلم الشبكة تسجيل مدى تطابق كل مدخل مشفر مع المخرج الحالي لوحدة فك التشفير. يتم تسوية هذه المخرجات بواسطة softmax، ثم يتم استخدام المعاملات لحساب مجموع موزون للحالات الخفية في المشفر في خطوات زمنية مختلفة. من خلال ضبط الأوزان، يمكن للنظام تعديل منطقة المدخلات التي يجب التركيز عليها. سحر هذه الآلية هو أن الشبكة المستخدمة لحساب المعاملات يمكن تدريبها بواسطة الانتشار الخلفي. ليست هناك حاجة لبنائها يدويا!

غيرت آليات الانتباه من الترجمة الآلية العصبية تمامًا. في وقت لاحق، نشرت Google ورقة بحثية تحت عنوان "الانتباه هو كل ما تحتاجه" " [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762)"، ووضعوا فيها المحولات الأمامية (forward transformer)، حيث تقوم كل طبقة و مجموعة من الخلايا العصبية بتنفيذ الانتباه.

<!-- ## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.

The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.

For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result. -->


## [شبكة الذاكرة](https://www.youtube.com/watch?v=ycbMGyCPzvE& t=4575s)

نبعت فكرة شبكات الذاكرة من العمل في Facebook الذي بدأه [Antoine Bordes](https://arxiv.org/abs/1410.3916) في عام 2014 و [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) في عام 2015.

فكرة شبكة الذاكرة هي أن هناك جزئين مهمين في دماغك: أحدهما هو **القشرة (cortex)**، حيث يكون لديك ذاكرة طويلة المدى. هناك قطعة منفصلة أخرى من الخلايا العصبية تسمى **الحُصين (hippocampus)** و التي ترسل إشارات إلى كل مكان تقريبًا في القشرة. يُعتقد أن الحُصين يُستخدم للذاكرة قصيرة المدى، وتذكر الأشياء لفترة قصيرة نسبيًا. النظرية السائدة هي أنه عندما تنام، يتم نقل الكثير من المعلومات من الحُصين إلى القشرة ليتم ترسيخها في الذاكرة طويلة المدى لأن الحُصين له سعة محدودة.

بالنسبة لشبكة الذاكرة، يوجد مدخل للشبكة، $x$ (فكر في الأمر كموقع في الذاكرة) و قارن هذا المتجه $x$ بالمتجهات $k_1, k_2, k_3, \cdots$ ("المفاتيح") باستخدام الضرب نقطي. ضعهم في دالة softmax، وستحصل على مجموعة من الأرقام التي مجموعها يساوي واحد. وهناك مجموعة من المتجهات الأخرى $v_1, v_2, v_3, \cdots$ ("القيم"). اضرب هذه المتجهات بالأعداد من دالة الـ softmax و قم بجمع هذه المتجهات لتحصل على النتيجة (لاحظ التشابه مع آلية الانتباه).

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
الشكل 7. شبكة الذاكرة
</center>


<!-- If one of the keys (*e.g.* $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.

This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.

What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.

This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions. -->

إذا تطابق أحد المفاتيح (*مثلاً،* $k_i$) تمامًا مع $x$، فسيكون المعامل المرتبط بهذا المفتاح قريبًا جدًا من واحد. لذلك سيكون ناتج النظام أساسًا $v_i$.

إنها **ذاكرة ارتباطية معنونة**. الذاكرة الارتباطية هي أنه إذا تطابقت مدخلاتك مع مفتاح، تحصل على *تلك* القيمة. وهذه هي مجرد نسخة سهلة التفاضل منها، و التي تسمح لك بإلانتشار الخلفي وتغيير المتجهات من خلال الانحدار التدريجي.

ما فعله المؤلفون هو سرد قصة لنظام من خلال إعطائه سلسلة من الجمل. يتم ترميز الجمل في متجهات عن طريق تمريرها عبر شبكة عصبية لم يتم تمرينها مسبقًا. يتم إرجاع الجمل إلى الذاكرة. عندما تطرح سؤالاً على النظام، تقوم بتشفير السؤال وتضعه كمدخل للشبكة العصبية، و تنتج الشبكة العصبية متغير $x$ في الذاكرة، فتعيد الذاكرة قيمة ما.

تُستخدم هذه القيمة، بالإضافة إلى الحالة السابقة للشبكة، لإعادة الوصول إلى الذاكرة. وتقوم بتدريب هذه الشبكة بأكملها للحصول على جواب لسؤالك. بعد تدريب مكثف، يتعلم هذا النموذج بالفعل تخزين القصص و الإجابة على الأسئلة.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

<!-- In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write. -->

في شبكة الذاكرة، توجد شبكة عصبية تأخذ مدخلاً ثم تنتج عنوانًا أو موقعًا في الذاكرة، وتستعيد قيمته إلى الشبكة، و تستمر هكذا إلى أن تُنتِج مخرجات في النهاية. يشبه هذا الكمبيوتر إلى حد كبير، عند وجود وحدة معالجة مركزية و ذاكرة خارجية للقراءة و الكتابة.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

الشكل 8. مقارنة بين شبكة الذاكرة و الكمبيوتر (الصورة من <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

<!-- There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.

The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks. -->

هناك أشخاص تخيلوا أنه يمكن بالفعل بناء **حاسبات اشتقاقية** بناءً على هذا. أحد الأمثلة على ذلك هو [آلة تورنغ العصبية](https://arxiv.org/abs/1410.5401) من DeepMind، والتي تم جعلها متاحة للعامة بعد ثلاثة أيام من نشر Facebook لورقة علمية على الـ arXiv.

الفكرة هي مقارنة المدخلات بالمفاتيح، وتوليد المعاملات، وإنتاج القيم - والتي تمثل أساسًا المحول. المحول هو في الأساس شبكة عصبية تكون فيها كل مجموعة من الخلايا العصبية واحدة من هذه الشبكات.
