---
lang-ref: ch.06-1
lang: ar
lecturer: Yann LeCun
title: تطبيقات الشبكات الالتفافية
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
translation-date: 1 Sep 2020
translator: Ali elfilali
---

<!-- ## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network.
 -->

## [التعرف على الرمز البريدي](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

في الدرس السابق، أوضحنا كيف يمكن للشبكات الالتفافية التعرف على الأرقام، لكننا لم نجب على سؤال كيف يمكن للنموذج معرفة الارتباك الناجم عن الأرقام المجاورة له عند اختيار كل رقم. تتمثل الخطوة التالية في اكتشاف الكائنات المتداخلة / غير المتداخلة واستخدام نهج ((Non-Maximum Supression (NMS)  بالنظر إلى افتراض أن المدخلات عبارة عن أرقام غير متداخلة في هذا المثال، فإن الاستراتيجية التي يجب اتباعها هي تدريب شبكات الالتفافية متعددة واختيار الرقم الحاصل على أعلى الدرجات الناتجة عن الشبكة أو عن طريق التصويت بالأغلبية.


<!-- ### Recognition with CNN

Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes. -->

###  CNN التعرف بواسطة  

نقدم هنا مهمة التعرف على الرموز البريدية غير المتداخلة المكونة من خمسة أرقام. لم يتم إعطاء النظام تعليمات حول كيفية فصل كل رقم، لكن النظام يعرف أنه يجب عليه تقدير خمسة أرقام. كما هو موضح في (الشكل 1)، يتكون النظام من شبكات الالتفافية بـ 4 أبعاد مختلفة، ينتج كل منها مخرجات مختلفة. تظهر المخرجات على شكل مصفوفة. تأتي مصفوفات الإخراج الأربع من نماذج ذات عروض نواة مختلفة في الطبقة الأخيرة. يحتوي كل ناتج على 10 صفوف تمثل 10 فئات من 0 إلى 9. يمثل المربع الأبيض الأكبر درجة أعلى في تلك الفئة. في كتل الإخراج الأربعة هذه، تكون أبعاد نوى الطبقة الأخيرة على المحور الأفقي هي 5 و 4 و 3 و 2 على التوالي. يحدد حجم النواة عرض النافذة التي ينظر النموذج من خلالها إلى المدخلات. ثم يختار النموذج الفئة التي حصلت على أعلى الدرجات في تلك النافذة. يأخذ النموذج بعد ذلك تصويت الأغلبية لاستخراج معلومات مفيدة، يجب على المرء أن يضع في اعتباره أنه ليست كل مجموعات الأحرف ممكنة، وبالتالي يمكن تصحيح تلك الأخطاء بفرض قيود على المدخلات للتأكد من أن المخرجات هي الرموز البريدية الصحيحة.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>الشكل 1 :</b> مصنفات متعددة للتعرف على الرمز البريدي
</center>

<!-- Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit. -->


الحيلة هي استخدام أقصر خوارزمية مسار لتحديد ترتيب الأحرف. نظرًا لأننا نعرف فترات الأحرف المحتملة وعدد الأرقام الإجمالي التي نحتاج إلى التنبؤ بها، يمكننا التعامل مع هذه المشكلة من خلال حساب الحد الأدنى لتكلفة الأرقام  و الانتقال بينها. يجب أن يكون المسار مستمراً من الخلية اليسرى السفلية إلى الخلية اليمنى العلوية على الرسم البياني ويجب أن يكون مقيدًا ليشمل حركات معينة من اليمين إلى اليسار، ومن أعلى إلى أسفل. لاحظ أنه في حالة تكرار نفس الأرقام جنبًا إلى جنب، يجب أن تكون الخوارزمية قادرة على التمييز بين هذه الأرقام كأرقام متكررة بدلاً من تخمينها بأرقام فردية.

<!-- ## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist. -->



## [التعرف على الوجه](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

تعمل الشبكات العصبية الالتفافية بشكل جيد في مهام الكشف ولا يعد الكشف عن الوجوه استثناءً. لإجراء التعرف على الوجوه، نحتاج إلى إنشاء مجموعة بيانات من الصور الوجوه و أخرى بدونها، حيث سنقوم بتدريب شبكة الالتفافية، ونسأل عما إذا كان المدخل إلى الشبكة يحتوي على وجه. عندما نطبق النموذج على صورة جديدة بعد التدريب، إذا كان هناك وجه فسوف تتوهج الشبكة الالتفافية في المواضع المقابلة. ومع ذلك، هناك مشكلتان:

<!-- - **False Positives**: There are many different variations of non-face objects that may appear in a patch of an image. During the training stage, the model may not see all of them (*i.e.* a fully representative set of non-face patches). Therefore, the model may suffer from a lot of false positives at test time. For example, if the network has not been trained on images containing hands, it may detect faces based on skin tones and incorrectly classify patches of images containing hands as faces, thereby giving rise to false positives. -->

- **الموجب المزيف**: هناك العديد من الأشكال المختلفة التي لا تعد وجهًا والتي قد تظهر في رقعة من الصورة. خلال مرحلة التدريب، قد لا يرى النموذج كل منهم (*أي* مجموعة تمثيلية بالكامل من الرقع التي لا تمثل الوجه). لذلك، قد يعاني النموذج من الكثير من الإيجابيات الخاطئة في وقت الاختبار. على سبيل المثال، إذا لم يتم تدريب الشبكة على الصور التي تحتوي على الأيدي، فقد تكتشف الوجوه بناءً على درجات لون البشرة وتصنف بشكل غير صحيح بقع من الصور التي تحتوي على الأيدي كوجوه، مما يؤدي إلى ظهور إيجابيات زائفة.


<!-- - **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost. -->

- **اختلاف حجم الوجوه:** ليست كل الوجوه بحجم 30 $\times$ 30 من البيكسلات لذلك قد لا يتم اكتشاف الوجوه ذات الأحجام المختلفة. تتمثل إحدى طرق التعامل مع هذه المشكلة في إنشاء إصدارات متعددة المقاييس من نفس الصورة. 
سيكتشف النموذج الأساسي الوجوه التي تتراوح أحجامها حول 30 $\times$ 30 بيكسل. في حالة تطبيق مقياس على صورة بعامل $\sqrt 2$، سيكتشف النموذج الوجوه الأصغر في الصورة الأصلية، وذلك لأن الأبعاد التي كانت في السابق 30 $\times$ 30 قد أصبحت 20 $\times$ 20 بيكسل. لاكتشاف الوجوه الأكبر، يمكننا تصغير حجم الصورة. هذه العملية غير مكلفة لأن نصف النفقات تأتي من معالجة الصورة الأصلية غير المقاسة. مجموع نفقات جميع الشبكات الأخرى مجتمعة هو نفسه تقريبًا مثل معالجة الصورة الأصلية غير المقاسة. حجم الشبكة هو مربع حجم الصورة على جانب واحد، لذلك إذا قمت بتصغير الصورة $\sqrt 2$، فإن الشبكة التي تحتاج إلى تشغيلها تكون أصغر بمعامل 2. وبالتالي فإن التكلفة الإجمالية هي $1+1/2+1/4+1/8+1/16…$، والذي يساوي 2. أداء نموذج متعدد المقاييس يضاعف فقط التكلفة الحسابية.


<!-- ### A multi-scale face detection system -->

###  نظام كشف الوجوه متعدد المقاييس

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>الشكل 2:</b> نظام الكشف عن الوجه
</center>

<!-- The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face. -->

تشير الخرائط الموضحة في (الشكل 3) إلى نتائج كاشفات الأوجه. يتعرف كاشف الوجه هذا على الوجوه التي يبلغ حجمها 20 $\times$ 20 بكسل. في المقياس الدقيق (المقياس 3) هناك العديد من الدرجات العالية ولكنها ليست نهائية للغاية. عندما يرتفع عامل التحجيم (المقياس 6)، نرى المزيد من المناطق البيضاء المتجمعة. تمثل تلك المناطق البيضاء الوجوه المكتشفة. نطبق بعد ذلك إخماد القيم الدنيا للحصول على الموقع النهائي للوجه.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>الشكل 3:</b> درجات كشف الوجه لمعايير التحجيم المختلفة
</center>


<!-- ### Non-maximum suppression

For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location.
 -->

###  إخماد القيم الدنيا (Non-maximum suppression)

لكل منطقة بقيم عالية، من المحتمل أن يكون عندها وجه. إذا تم اكتشاف المزيد من الوجوه بالقرب من الأول، فهذا يعني أنه يجب اعتبار وجه واحد فقط صحيحًا والباقي خاطئ. مع خوارزمية *إخماد القيم الدنيا* نأخذ أعلى درجات للمربعات المحيطة المتداخلة ونزيل المربعات الأخرى. ستكون النتيجة إحاطة مربع واحد في الموقع الأمثل.


<!-- ### Negative mining

In the last section, we discussed how the model may run into a large number of false positives at test time as there are many ways for non-face objects to appear similar to a face. No training set will include all the possible non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches which the model has (erroneously) detected as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives. -->

###  التعدين السلبي (Negative Mining)

في القسم الأخير، ناقشنا كيف يمكن أن يواجه النموذج عددًا كبيرًا من الإيجابيات الخاطئة في وقت الاختبار حيث توجد العديد من الطرق التي تظهر الأشكال التي لا تعد وجوهًا بشكل مشابه للوجه. لن تتضمن أي مجموعة تدريب جميع الممكنة لهذه الأشكال المشابهة للوجوه ولكن لا تعد وجهًا. يمكننا تخفيف هذه المشكلة من خلال التعدين السلبي. في التعدين السلبي، نقوم بإنشاء مجموعة بيانات سلبية عبارة عن رقع لا تمثل وجوهًا والتي اكتشفها النموذج (خطأ) كوجوه. يتم جمع البيانات عن طريق تشغيل النموذج على المدخلات المعروف أنها لا تحتوي على وجوه. ثم نقوم بإعادة تدريب الكاشف باستخدام مجموعة البيانات السلبية. يمكننا تكرار هذه العملية لزيادة دقة (robustness) نموذجنا ضد الإيجابيات الزائفة.

<!-- ## Semantic segmentation

Semantic segmentation is the task of assigning a category to every pixel in an input image. -->

## **التجزئة الدلالية** (*Semantic segmentation*)

التجزئة الدلالية هي مهمة تعيين فئة لكل بكسل في صورة الإدخال.


<!-- ### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red. -->

### [الشبكات العصبية الالتفافية لرؤية الروبوتات التكيفية طويلة المدى](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

في هذا المشروع، كان الهدف هو تسمية المناطق من الصور المدخلة حتى يتمكن الروبوت من التمييز بين الطرق والعقبات. في الشكل، المناطق الخضراء هي مناطق يمكن للروبوت أن يقود عليها والمناطق الحمراء تمثل عوائق مثل العشب الطويل. لتدريب الشبكة على هذه المهمة، أخذنا رقعة من الصورة وقمنا يدويًا بتسميتها بأنها قابل للعبور أو لا (أخضر أو أحمر). ثم نقوم بتدريب الشبكة الالتفافية على الرقع من خلال مطالبتها بالتنبؤ بلون الرقعة. بمجرد أن يتم تدريب النظام بشكل كافٍ، يتم تطبيقه على الصورة بأكملها، مع تسمية جميع مناطق الصورة باللون الأخضر أو الأحمر.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>الشكل 4:</b> الشبكات العصبية الالتفافية لرؤية الروبوتات التكيفية طويلة المدى
</center>

<!-- There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle. -->

كانت هناك خمس فئات للتنبؤ: 1) الأخضر الفائق، 2) الأخضر، 3) الأرجواني: خط يوضح حدود العائق، 4) العائق الأحمر 5) الأحمر الفائق: بالتأكيد عقبة.

<!-- **Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it. -->

**تسميات ستيريو** (الشكل 4, العمود 2)
يتم التقاط الصور بالكاميرات الأربع الموجودة على الروبوت، والتي تم تجميعها كزوحين من رؤية ستريو. باستخدام المسافات المعروفة بين الكاميرات الاستريو المزدوجة، يتم بعد ذلك تقدير مواضع كل بكسل في الفضاء ثلاثي الأبعاد عن طريق قياس المسافات النسبية بين وحدات البكسل التي تظهر في كلتا الكاميرتين في زوج استريو. هذه هي نفس العملية التي تستخدمها أدمغتنا لتقدير مسافة الأشياء التي نراها. باستخدام معلومات الموقع المقدرة، يتلاءم المستوى مع الأرض، ثم يتم تصنيف وحدات البكسل على أنها خضراء إذا كانت بالقرب من الأرض والأحمر إذا كانت فوقها.

<!-- * **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly. -->

* **القيود والمحفزات للـ ConvNet**: تعمل الرؤية المجسمة فقط حتى 10 أمتار وتتطلب قيادة الروبوت رؤية بعيدة المدى. ومع ذلك، فإن الشبكة الالتفافية قادرة على اكتشاف الأشياء على مسافات أكبر بكثير، إذا تم تدريبها بشكل صحيح.

  

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>الشكل 5:</b> هرم الحجوم الثابتة للصور المقاسة عن بعد
</center>

<!-- * **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales. 

**Model Outputs** (Figure 4, Column 3)

The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network. -->

* **توظيف كمدخلات للنموذج:**  تتضمن المعالجة المسبقة المهمة بناء هرم الحجوم الثابتة للصور المقاسة عن بعد (شكل 5). إنه مشابه لما فعلناه في وقت سابق من هذه المحاضرة عندما حاولنا اكتشاف الوجوه ذات المقاييس المتعددة.


**مخرجات النموذج** (الشكل 4، العمود 3)

يقوم النموذج بإخراج تسمية لكل بكسل في الصورة *حتى الأفق*. هذه هي مخرجات المصنف للشبكة الالتفافية متعددة المقاييس.     

<!-- * **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed. -->

* **كيف يصبح النموذج قابلاً للتكيف**: تتمتع الروبوتات بوصول مستمر إلى تسميات الاستريو، مما يسمح للشبكة بإعادة التدريب والتكيف مع البيئة الجديدة التي توجد بها. يرجى ملاحظة أنه سيتم إعادة تدريب الطبقة الأخيرة فقط من الشبكة. يتم تدريب الطبقات السابقة في المعمل وتثبيتها.

<!-- **System Performance**

When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away. -->

### **أداء النظام**

عند محاولة الوصول إلى إحداثيات GPS على الجانب الآخر من الحاجز، الروبوت "رأى" الحاجز من بعيد وخطط لطريق كي يتجنبه. هذا بفضل شبكة CNN التي تقوم باكتشاف الأجسام على بعد 50-100 متر.

<!-- **Limitation**

Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly. -->

### قيود

رجوعا إلى 2000s، كانت الموارد الحاسوبية محدودة. كان الروبوت حينها قادرًا على معالجة حوالي صورة أو ما يعرف بإطار واحد فقط في الثانية، مما يعني أنه لن يكون قادرًا على اكتشاف شخص يسير في طريقه لمدة ثانية كاملة قبل أن يكون قادرًا على الرد. الحل لهذا الضغف هو بناء نموذج **لتقدير التغير في موقع الروبوت بتكلفة منخفضة**. فلا يعتمد على الشبكات العصبية، وله مسافة رؤية تتراوح حول 2.5 متر تقريبًا ولكنه قادر على الاستجابة بسرعة.

<!-- ### Scene Parsing and Labelling

In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6). -->

#### **تحليل المشهد و وضع الأسماء** 

في هذه المهمة، يُخرج النموذج فئة الكائن (مبنى، سيارة، سماء، إلخ) لكل بكسل. تكون المعمارية أيضًا متعددة المقاييس (الشكل 6).

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>الشكل 6:</b>شبكة عصبية إلتفافية متعددة المقاييس لتحليل المشاهد
</center>

<!-- Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.

However, sometimes this context size is not enough to determine the category for larger objects. -->

لاحظ أنه إذا قمنا بإعادة عرض مخرج واحد من الـ CNN على المدخلات، فإنه يتوافق مع مدخل بحجم $46\times46$ على الصورة الأصلية في أسفل هرم لابلاس. هذا يعني أننا نستخدم **سياق 46 × 46 بكسل لتحديد فئة البكسل المركزي**.

ومع ذلك، أحيانًا لا يكون حجم هذا السياق كافيًا لتحديد فئة كائنات أكبر.


<!-- **The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.


Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$. -->

**يتيح النهج متعدد النطاقات رؤية أوسع من خلال توفير صور إضافية تم إعادة قياسها كمدخلات.** والخطوات هي كما يلي:
1.  خذ نفس الصورة، قلص حجمها بمعامل 2 ثم معامل 4، كل على حدة.
2.  يتم تغذية هاتين الصورتين الإضافيتين المعاد تحجيمهما إلى **نفس الـ ConvNet** (نفس الأوزان ونفس الأنوية) ونحصل على مجموعتين أخريين من خصائص المستوى 2.
3. قم **بتكبير (Upsample)** هذه الخصائص بحيث يكون لها نفس حجم خصائص المستوى 2 للصورة الأصلية.
4. **كدس** المجموعات الثلاث من الخصائص بعد التكبير معًا ثم قم بتغذيتها للمصنف.


الآن أكبر حجم فعال للمحتوى، والذي يأتي من الصورة التي تم تغيير حجمها بمقذار 1/4، هو $184\times 184\, (46\times 4=184)$.


<!-- **Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking. -->


**الأداء**: مع عدم وجود معالجة لاحقة وتشغيل إطار بإطار، يعمل النموذج بسرعة كبيرة حتى على الأجهزة العادية. يحتوي النموذج على حجم صغير إلى حد ما من بيانات التدريب (2k ~ 3k)، لكن النتائج لا تزال تحطم أرقامًا قياسية.
