---
lang-ref: ch.05-3
lang: ar
title: شرح عمليات الإلتفاف و جهاز التفاضل التلقائي
lecturer: Alfredo Canziani
authors: Leyi Zhu, Siqi Wang, Tao Wang, Anqi Zhang
translation-date: 30 Sep 2020
translator: Mohammed Almakki
---

<!--
## [Understanding 1D convolution](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)

In this part we will discuss convolution, since we would like to explore the sparsity, stationarity, compositionality of the data.

Instead of using the matrix $A$ discussed in the [previous week]({{site.baseurl}}/en/week04/04-1), we will change the matrix width to the kernel size $k$. Therefore, each row of the matrix is a kernel. We can use the kernels by stacking and shifting (see Fig 1). Then we can have $m$ layers of height $n-k+1$.
--> 

## [فهم الإلتفاف في بعد واحد (Understanding 1D convolution)](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)

في هذا الجزء سوف نقوم بمناقشة الإلتفاف لأننا نريد أن نستكشف إنتشارية (sparisty) و ثباتية (stationarity) و تكوينية (compositionality) البيانات.   

بدلاً عن استخدام المصفوفة $A$ التي تم مناقشتها في [العمل السابق]({{site.baseurl}}/ar/week04/04-1) سوف نغير عرض المصفوفة إلى حجم النواة  $k$. بالتالي أي صف في المصفوفة يمثل نواة. يمكننا استخدام هذه الأنوية عن طريق تجميعهم وإزاحتهم (انظر إلى شكل 1). إذًا، لدينا $m$ من الطبقات بإرتفاع $n-k+1$.   

<!--
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>Fig 1</b>: Illustration of 1D Convolution
</center>

The output is $m$ (thickness) vectors of size $n-k+1$.

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>Fig 2</b>: Result of 1D Convolution
</center>

Furthermore, a single input vector can viewed as a monophonic signal.

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>Fig 3</b>: Monophonic Signal
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>شكل 1</b>: توضيح للإلتفاف ذو البعد الواحد (1D)
</center>

المخرج هو $m$ (سماكة) المتجهات التي حجمها $n-k+1$. 

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>شكل 2 </b>: نتيجة الإلتفاف 1D
</center>

أيضا مدخل واحد يمكن أن ينظر إليه كموجة أحادية الصوت 

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>شكل 3</b>: موجة أحادية الصوت
</center>

<!--
Now, the input $x$ is a mapping
--> 

الآن المدخل $x$ هو عبارة عن تحويل

$$
x:\Omega\rightarrow\mathbb{R}^{c}
$$

<!--
where $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (since this is $1$ dimensional signal / it has a $1$ dimensional domain) and in this case the channel number $c$ is $1$. When $c = 2$ this becomes a stereophonic signal.

For the 1D convolution, we can just compute the scalar product, kernel by kernel (see Fig 4).

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<b>Fig 4</b>: Layer-by-layer Scalar Product of 1D Convolution
</center>
-->

حيث $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (لأن  هذه موجة ذات بعد واحد أو مجال ذو بعد واحد) و في هذه الحالة رقم القناة $c$ هو $1$. عندما $c$ = $2$ فإن الموجة تصبح موجة ستيريو .   

<!--
## [Dimension of kernels and output width in PyTorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

Tips: We can use ***question mark*** in IPython to get access to the documents of functions. For example,
-->

## [أبعاد الأنوية (kernels) و عرض المخرجات في PyTorch ](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

تلميح: يمكننا استخدام ***question mark*** في IPython للحصول على مستندات الدوال. مثلاً

```python
Init signature:
nn.Conv1d(
	in_channels,           # number of channels in the input image
	out_channels,          # number of channels produced by the convolution
	kernel_size,           # size of the convolving kernel
	stride=1,              # stride of the convolution
	padding=0,             # zero-padding added to both sides of the input
	dilation=1,            # spacing between kernel elements
	groups=1,              # nb of blocked connections from input to output
	bias=True,             # if `True`, adds a learnable bias to the output
	padding_mode='zeros',  # accepted values `zeros` and `circular`
)
```

<!--
### 1D convolution

We have $1$ dimensional convolution going from $2$ channels (stereophonic signal) to $16$ channels ($16$ kernels) with kernel size of $3$ and stride of $1$. We then have $16$ kernels with thickness $2$ and length $3$. Let's assume that the input signal has a batch of size $1$ (one signal), $2$ channels and $64$ samples. The resulting output layer has $1$ signal, $16$ channels and the length of the signal is $62$ ($=64-3+1$). Also, if we output the bias size, we'll find the bias size is $16$, since we have one bias per weight.
-->

### الإلتفاف ذو البعد الواحد

لدينا إلتفاف ذو بعد $1$ من $2$ من القنوات (موجة ستيريو) إلى $16$ قناة ($16$ أنوية) بحجم نواة $3$ و طول خطوة $1$. و بعد ذلك لدينا $16$ أنوية بسمك $2$ و طول $3$. لنفترض أن الموجة المدخلة لديها طول حزمة $1$ (موجة واحدة) و $2$ من القنوات و $64$ عينة. الطبقة المخرجة الناتجة لديها $1$ موجة و $16$ قناة و طول الموجة $62$ (حيث أن $64-3+1$). أيضا أذا أخرجنا حجم معامل الإنحياز سوف نجد أن حجم  معامل الإنحياز هو $16$ لأننا لدينا معامل إنحياز واحد لكل وزن.   

```python
conv = nn.Conv1d(2, 16, 3)  # 2 channels (stereo signal), 16 kernels of size 3
conv.weight.size()          # output: torch.Size([16, 2, 3])
conv.bias.size()            # output: torch.Size([16])

x = torch.rand(1, 2, 64)    # batch of size 1, 2 channels, 64 samples
conv(x).size()              # output: torch.Size([1, 16, 62])

conv = nn.Conv1d(2, 16, 5)  # 2 channels, 16 kernels of size 5
conv(x).size()              # output: torch.Size([1, 16, 60])
```

<!--
### 2D convolution

We first define the input data as $1$ sample, $20$ channels (say, we're using an hyperspectral image) with height $64$ and width $128$. The 2D convolution has $20$ channels from input and $16$ kernels with size of $3 \times 5$. After the convolution, the output data has $1$ sample, $16$ channels with height $62$ ($=64-3+1$) and width $124$ ($=128-5+1$).
--> 

### الإلتفاف ذو البعدين 

أولاً نعرف البيانات المدخلة كـ $1$ عينة و$20$ قناة (افترض أنها صورة لديه أطياف عدة) بإرتفاع  $64$ وعرض $128$. فأن الإلتفاف ذو بعدين يكون لديه $20$ قناة من المدخل و$16$ نواة بحجم $3 \times 5$. بعد تطبيق الإلتفاف فأن البيانات المخرجة لديها $1$ عينة و $16$ قناة بإرتفاع $62$ (حيث أن $64-3+1$) و عرض $124$ (لأن $128-5+1$). 

```python
x = torch.rand(1, 20, 64, 128)    # 1 sample, 20 channels, height 64, and width 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 channels, 16 kernels, kernel size is 3 x 5
conv.weight.size()                # output: torch.Size([16, 20, 3, 5])
conv(x).size()                    # output: torch.Size([1, 16, 62, 124])
```

<!--
If we want to achieve the same dimensionality, we can have paddings. Continuing the code above, we can add new parameters to the convolution function: `stride=1` and `padding=(1, 2)`, which means $1$ on $y$ direction ($1$ at the top and $1$ at the bottom) and $2$ on $x$ direction. Then the output signal is in the same size compared to the input signal. The number of dimensions that is required to store the collection of kernels when you perform 2D convolution is $4$.
--> 

إذا أردنا أن نصل إلى نفس البعد يمكننا استخدام تبطينات. في الكود أعلاه، يمكننا إضافة عوامل لدالة الإلتفاف `stride=1` و `padding=(1, 2)` و هذا يعني $1$ في إتجاه $y$ (واحد في الأعلى وواحد في الأسفل) و $2$ في إتجاه $x$. بالتالي تكون الموجة المخرجة يكون لها نفس الحجم مقارنة بالموجة المدخلة. عدد الأبعاد المطلوب لتخزين مجموعة الأنوية عندما نستعمل إلتفاف ذو بعدين هو $4$. 

```python
# 20 channels, 16 kernels of size 3 x 5, stride is 1, padding of 1 and 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # output: torch.Size([1, 16, 64, 128])
```

<!--
## [How automatic gradient works?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

In this section we're going to ask torch to check all the computation over the tensors so that we can perform the computation of partial derivatives.

- Create a $2\times2$ tensor $\boldsymbol{x}$ with gradient-accumulation capabilities;
- Deduct $2$ from all elements of $\boldsymbol{x}$ and get $\boldsymbol{y}$; (If we print `y.grad_fn`, we will get `<SubBackward0 object at 0x12904b290>`, which means that `y` is generated by the module of subtraction $\boldsymbol{x}-2$. Also we can use `y.grad_fn.next_functions[0][0].variable` to derive the original tensor.)
- Do more operations: $\boldsymbol{z} = 3\boldsymbol{y}^2$;
- Calculate the mean of $\boldsymbol{z}$.

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>Fig 5</b>: Flow Chart of the Auto-gradient Example
</center>

Back propagation is used for computing the gradients. In this example, the process of back propagation can be viewed as computing the gradient $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. After computing $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ by hand as a validation, we can find that the execution of `a.backward()` gives us the same value of *x.grad* as our computation.

Here is the process of computing back propagation by hand:
--> 

## [كيف يعمل حساب الإنحدار التلقائي](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

في هذ الجزء سوف نطلب من torch تفحص كل الحسابات على الموترات (tensors) حتى نتمكن من حساب التفاضلات الجزئية. 

- عرف موتر $\boldsymbol{x}$ بالأبعاد $2\times2$  مع إمكانية تجميع الإنحدار. 
- إطرح $2$ من كل عناصر $\boldsymbol{x}$ لنحصل على $\boldsymbol{y}$ (إذا طبعنا `y.grad_fn` فسوف يكون المخرج   `<SubBackward0 object at 0x12904b290>` و هذا يعني أن `y`  تساوي القيمة المطلقة لحاصل الطرح $\boldsymbol{x}-2$. أيضاً يمكننا استخدام `y.grad_fn.next_functions[0][0].variable` لنشتق الموتر الأصلي.)
- قم بالمزيد من الحسابات: $\boldsymbol{z} = 3\boldsymbol{y}^2$;    
- أحسب متوسط $\boldsymbol{z}$.      

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>شكل 5</b>: مخطط لمثال التدرج التلقائي
</center>

يستخدم الانتشار الخلفي لحساب التدرجات. في هذا المثال، يمكن النظر إلى عملية الانتشار الخلفي على أنها حساب التدرج $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. بعد حساب $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ يدويًا للتحقق من الصحة، يمكننا أن نجد أن تنفيذ `a.backward()` يعطينا نفس القيمة *x.grad* في حساباتنا.

فيما يلي عملية حساب الانتشار الخلفي يدويًا:

$$
\begin{aligned}
a &= \frac{1}{4} (z_1 + z_2 + z_3 + z_4) \\
z_i &= 3y_i^2 = 3(x_i-2)^2 \\
\frac{da}{dx_i} &= \frac{1}{4}\times3\times2(x_i-2) = \frac{3}{2}x_i-3 \\
x &= \begin{pmatrix} 1&2\\3&4\end{pmatrix} \\
\left(\frac{da}{dx_i}\right)^\top &= \begin{pmatrix} 1.5-3&3-3\\[2mm]4.5-3&6-3\end{pmatrix}=\begin{pmatrix} -1.5&0\\[2mm]1.5&3\end{pmatrix}
\end{aligned}
$$

<!--
Whenever you use partial derivative in PyTorch, you get the same shape of the original data. But the correct Jacobian thing should be the transpose.
--> 
عندما تريد استخدام التفاضل الجزئي في PyTorch سوف تحصل على نفس أبعاد البيانات. لكن المصفوفة الجاكوبية الصحيحة هي منقولها (transpose).  

<!--
### From basic to more crazy

Now we have a $1\times3$ vector $x$, assign $y$ to the double $x$ and keep doubling $y$ until its norm is smaller than $1000$. Due to the randomness we have for $x$, we cannot directly know the number of iterations when the procedure terminates.
--> 

### من الأساسيات إلى الأكثر جنوناً 

الآن لدينا متجه بأبعاد $1\times3$ والمسمى بـ $x$، قم بتعيين $y$ لضعف $x$ واستمر في مضاعفة $y$ حتى يصبح معياره (norm) أصغر من $1000$. نظرًا للعشوائية التي لدينا لـ $x$، لا يمكننا معرفة عدد التكرارات بشكل مباشر بعد إنتهاء هذا الإجراء.

```python
x = torch.randn(3, requires_grad=True)

y = x * 2
i = 0
while y.data.norm() < 1000:
    y = y * 2
    i += 1
```

<!--
However, we can infer it easily by knowing the gradients we have.
--> 

لكن يمكننا أن نتوقعها بسهولة إذا عرفنا قيم الإنحدارات. 

```python
gradients = torch.FloatTensor([0.1, 1.0, 0.0001])
y.backward(gradients)

print(x.grad)
tensor([1.0240e+02, 1.0240e+03, 1.0240e-01])
print(i)
9
```

<!--
As for the inference, we can use `requires_grad=True` to label that we want to track the gradient accumulation as shown below. If we omit `requires_grad=True` in either $x$ or $w$'s declaration and call `backward()` on $z$, there will be runtime error due to we do not have gradient accumulation on $x$ or $w$.
--> 

كما في عملية التوقع فإننا نستخدم `requires_grad=True` لنوضح أننا نريد متابعة مجموع الإنحدارات كما موضح أدناه. إذا كنا قمنا بإزالة `requires_grad=True` في حالة تعريف $x$ أو $w$ و استخدام `backward()` على $z$ فسينتج خطأ في زمن التنفيذ ﻷنه ليس لدينا مجموع إنحدارات لـ $x$ أو $w$.     

```python
# Both x and w that allows gradient accumulation
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
```

<!--
And, we can have `with torch.no_grad()` to omit the gradient accumulation.
--> 

و يمكن استخدام `with torch.no_grad()` لتجاهل مجموع الإنحدارات.  

```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# All torch tensors will not have gradient accumulation
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch will throw an error here, since z has no grad accum.
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
```

<!--
## More stuff -- custom gradients

Also, instead of basic numerical operations, we can generate our own self-defined modules / functions, which can be plugged into the neural graph. The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).

To do so, we need to inherit `torch.autograd.Function` and override `forward()` and `backward()` functions. For example, if we want to training nets, we need to get the forward pass and know the partial derivatives of the input respect to the output, such that we can use this module in any kind of point in the code. Then, by using back-propagation (chain rule), we can plug the thing anywhere in the chain of operations, as long as we know the partial derivatives of the input respect to the output.

In this case, there are three examples of ***custom modules*** in the *notebook*, the `add`, `split`, and `max` modules. For example, the custom addition module:
--> 

### جزء إضافي -- الإنحدار المخصص

أيضاً بدلاً عن العمليات العددية الأساسية فأننا يمكن أن نعمل دوال أو وحدات خاصة بنا و التي يمكن أن نستعملها في الشبكة العصبية. يمكن أن تجد الـ Jupyter Notebook [هنا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).

لنفعل ذلك نحتاج لأن نرث الكلاس `torch.autograd.Function` و نعيد تعريف الدوال `forward()` و `backward()`. مثلاً إذا كنا نريد تدريب شبكة ما فأننا نحتاج إلى أن نمرر المدخل عبر الشبكة و نعرف التفاضلات الجزئية للمدخل بالنسبة للمخرج لذلك يمكننا استخدام هذه الوحدة في أي نقطة في الكود. ثم باستخدام الإنتشار الخلفي (قاعدة السلسلة) يمكننا استخدام هذه الوحدة في أي مكان في سلسلة العمليات طالماً أننا نعلم التفاضلات الجزئية للمدخل بالنسبة للمخرج.

في هذه الحالة لدينا تلاتة أمثلة **للوحدات المخصصة** في هذا الـ *notebook* الوحدات `add` و `split` و `max`. مثلاً الوحدة المخصصة للجمع:        

```python
# Custom addition module
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx is a context where we can save
        # computations for backward.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # need to return grads in order
        # of inputs to forward (excluding ctx)
        return grad_x1, grad_x2
```

<!--
If we have addition of two things and get an output, we need to overwrite the forward function like this. And when we go down to do back propagation, the gradients copied over both sides. So we overwrite the backward function by copying.

For `split` and `max`, see the code of how we overwrite forward and backward functions in the *notebook*. If we come from the same thing and **Split**, when go down doing gradients, we should add / sum them. For `argmax`, it selects the index of the highest thing, so the index of the highest should be $1$ while others being $0$. Remember, according to different custom modules, we need to overwrite its own forward pass and how they do gradients in backward function.
-->

إذا كان لدينا حاصل جمع شيئين والمخرج واحد فنحتاج إلى إعادة تعريف دالة الـ forward بهذه الطريقة. ولما نعود للأسفل للقيام بالإنشار الخلفي فإن الإنحدارات يتم نسخها عبر الجهتين. لذلك نعيد تعريف دالة الـ backward عن طريق النسخ. 

بالنسبة إلى `split` و`max`، راجع الكود الخاص بكيفية كتابة دالة الـ forward و الـ backward في *هذه المذكرة*. إذا أتينا من نفس الشيء و قمنا **بالانقسام** عند النزول لعمل التدرجات، يجب أن نجمعها. بالنسبة لـ `argmax`، فإنه يحدد مؤشر الشيء الأعلى، لذلك يجب أن يكون المؤشر الأعلى هو $1$ بينما يكون الآخر $0$. تذكر أن وفقًا للوحدات النمطية المختلفة، نحتاج إلى إعادة تعريف دالة الـ  forward الخاصة بها، وكيفية حساب التدرجات في دالة الـ backward.