---
lang-ref: ch.05-2
lang: ar
title: تقنيات التحسين الجزء الثاني
lecturer: Aaron Defazio
authors: Guido Petri, Haoyue Ping, Chinmay Singhal, Divya Juneja
date: 24 Feb 2020
translation-date: 28 Sep 2020
translator: Mohammed Almakki
---


<!--
## [Adaptive methods](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

SGD with momentum is currently the state of the art optimization method for a lot of ML problems. But there are other methods, generally called Adaptive Methods, innovated over the years that are particularly useful for poorly conditioned problems (if SGD does not work). 
-->

## [(Adaptive methods) الطرق التَكَيُّفية](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

حاليا طريقة SGD مع الزخم هي أفضل طرق التحسين لكثير من مشاكل تعلم الآلة. لكن هنالك طرق أخرى مفيدة - يطلق عليها الطرق التَكَيُّفية و تم تطويرها عبر السنين - تساعد في التعامل مع المشاكل الصعبة والتي لا تنجح طريقة SGD في حلها.

<!-- 
In the SGD formulation, every single weight in network is updated using an equation with the same learning rate (global $\gamma$). Here, for adaptive methods, we *adapt a learning rate for each weight individually*. For this purpose, the information we get from gradients for each weight is used. 
-->

في طريقة SGD فإن كل وزن في الشبكة يتم تحديثه باستخدام معادلة بمعدل تعلم ثابت ($\gamma$). لكن في الطرق التَكَيُّفية فيتم *تكييف معدل تعلم لكل وزن*. لهذا السبب فإننا نستخدم المعلومات التي نحصل عليها من إنحدار كل وزن.  

<!-- 
Networks that are often used in practice have different structure in different parts of them. For instance, early parts of CNN may be very shallow convolution layers on large images and later in the network we might have convolutions of large number of channels on small images. Both of these operations are very different so a learning rate which works well for the beginning of the network may not work well for the latter sections of the network. This means adaptive learning rates by layer could be useful. 
-->

عملياً يختلف هيكل الشبكات في الأغلب تكون في مختلف أجزاءها. مثلاً، قد تتكون الأجزاء الأولى من الشبكات العصبية الإلتفافية (CNN) من طبقات إلتفافية عدد قنواتها قليل وأبعاد كبيرة للقناة ولكن في الأجزاء الأخيرة قد تكون الطبقات ذات قنوات أكثر ولكن بأبعاد أصغر. فالعمليات تكون مختلقة في مختلف أجزاء الشبكة، لذلك فإن معدل التعلم قد يكون مناسب للأجزاء الأولى و غير مناسب للأجزاء الأخيرة. و هذا يعني أن استخدام معدلات تعلم تَكَيُّفية قد يكون أمرًا مفيدًا. 

<!-- 
Weights in the latter part of the network (4096 in figure 1 below) directly dictate the output and have a very strong effect on it. Hence, we need smaller learning rates for those. In contrast, earlier weights will have smaller individual effects on the output, especially when initialized randomly. 
-->

الأوزان في الأجزاء الأخيرة من الشبكة (4096 في الشكل رقم 1) لها تأثير كبير على مخرجات الشبكة. لذلك نحتاج إلى معدل تعلم صغير لهذه الأجزاء. في المقابل فإن الأوزان في الأجزاء الأولى يكون تأثيرها صغير على مخرجات الشبكة خصوصاً عندما يتم تهيأتها بأوزان عشوائية. 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>شكل 1: </b>VGG16
</center>

<!-- 
### RMSprop

The key idea of *Root Mean Square Propagation* is that the gradient is normalized by its root-mean-square.

In the equation below, squaring the gradient denotes that each element of the vector is squared individually. 
-->

### RMSprop

الفكرة الأساسية *لإنتشار جذر تربيع المتوسط* (RMSprop, Root Mean Square Propagation) هي أن الإنحدار يتم تسويته باستخدام جذر تربيع المتوسط. 

في المعادلة أدناه تربيع الإنحدار يدل على تربيع كل عنصر في المتجه منفرداً. 

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!-- 
where $\gamma$ is the global learning rate, $\epsilon$ is a value close to machine $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) -- in order to avoid division by zero errors, and $v_{t+1}$ is the 2nd moment estimate. 
-->

حيث $\gamma$ هي معدل التعلم العام و  $\epsilon$ هي قيمة قريبة من $\epsilon$ الآلة (وتكون من مضاعفات $10^{-7}$ أو $10^{-8}$) -- و تستعمل من أجل تجنب القسمة على صفر و $v_{t+1}$ هي عبارة عن مقدار العزم الثاني. 

<!-- 
We update $v$ to estimate this noisy quantity via an *exponential moving average* (which is a standard way of maintaining an average of a quantity that may change over time). We need to put larger weights on the newer values as they provide more information. One way to do that is down-weight old values exponentially. The values in the $v$ calculation that are very old are down-weighted at each step by an $\alpha$ constant, which varies between 0 and 1. This dampens the old values until they are no longer an important part of the exponential moving average. 
-->

و نقوم بتحديث $v$ لتقدير القيمة المشوشة عن طريق *المتوسط الأسي المتحرك* (و هي طريقة أساسية لحساب متوسط كمية قد يمكن أن تتغير مع الزمن). نحن نحتاج أن نضع وزن كبير للقيم الجديدة ﻷنها تعطينا معلومات أكثر. واحدة من الطرق لفعل ذلك عن طريق تقليل وزن القيم القديمة أسياً. القيم القديمة جداً في حساب $v$ يتم تقليل وزنها في كل خطوة ثابتة $\alpha$ (تتراوح قيمتها بين صفر وواحد). هذا يؤدي إلى تثبيت القيم القديمة حتي تصير جزء غير معتبر في حساب المتوسط الأسي المتحرك. 

<!-- 
The original method keeps an exponential moving average of a non-central second moment, so we don't subtract the mean here. The *second moment* is used to normalize the gradient element-wise, which means that every element of the gradient is divided by the square root of the second moment estimate. If the expected value of gradient is small, this process is similar to dividing the gradient by the standard deviation. 
-->

تحافظ الطريقة الأصلية على متوسط أسي متحرك لعزم ثاني غير مركزي، لذلك لا نقوم بطرح قيمة المتوسط من المقدار هنا. يستخدم *العزم الثاني* لتسوية التدرج و هذا يعني أن كل عنصر في التدرج يتم قسمته على الجذر التربيعي للعزم الثاني. إذا كانت القيمة المتوقعة للتدرج صغيرة فأن هذه العملية مشابهة لقسمة التدرج على الانحراف المعياري. 

<!-- 
Using a small $\epsilon$ in the denominator doesn't diverge because when $v$ is very small, the momentum is also very small. 
-->

استخدام قيمة صغيرة لـ $\epsilon$  في المقام لا يؤدي إلى الابتعاد عن النتيجة النهائية لأن عندما تكون $v$ صغيرة جدًا فإن الزخم يكون صغير جدًا.

<!--
### ADAM

ADAM, or *Adaptive Moment Estimation*, which is RMSprop plus momentum, is a more commonly used method. The momentum update is converted to an exponential moving average and we don't need to change the learning rate when we deal with $\beta$. Just as in RMSprop, we take an exponential moving average of the squared gradient here. 
-->

### ADAM

*التقدير التَكَيُّفي للعزم* (ADAM, Adaptive Moment Estimation) هي طريقة تتكون من RMSprop مع إضافة زخم (momentum). و هي طريقة شائع استخدامها. تحديث الزخم يتم تعدليه ليصبح متوسط أسي متحرك و لا نحتاج إلى تغيير معدل التعلم عندما نتعامل مع $\beta$. مثل RMSprop فأننا نأخذ جذر تربيع أسي متحرك لمربع الإنحدار. 

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!-- 
where $m_{t+1}$ is the momentum's exponential moving average.

Bias correction that is used to keep the moving average unbiased during early iterations is not shown here. 
-->

حيث $m_{t+1}$ هي عبارة عن متوسط أسي متحرك.

تصحيح الإنحياز الذي يستخدم لجعل المتوسط الأسي المتحرك غير منحاز أثناء أول تكرارات غير موضح هنا. 

<!-- 
### Practical side

When training neural networks, SGD often goes in the wrong direction in the beginning of the training process, whereas RMSprop hones in on the right direction. However, RMSprop suffers from noise just as regular SGD, so it bounces around the optimum significantly once it's close to a local minimizer. Just like when we add momentum to SGD, we get the same kind of improvement with ADAM. It is a good, not-noisy estimate of the solution, so **ADAM is generally recommended over RMSprop**. 
-->

### جانب عملي

عند تدريب الشبكات العصبية فأن الإنحدار في SGD أحياناً يذهب في إتجاه خاطئ في بداية عملية التدريب و لكن RMSprop تقوم بتصحيح إتجاه الإنحدار. لكن RMSprop تعاني من التشويش مثل SGD فهي أيضاً قد تتردد حول قيمة محلية صغرى. مثل عندما نضيف زخم إلى SGD فإننا نحصل على نفس مقدار التحسين مع ADAM.  ADAM تعتبر تقدير جيد و غير مشوش للحل و لذلك **ADAM عموماً يوصى بها على RMSprop** . 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>شكل 2: </b> SGD *ضد* RMSprop *ضد* ADAM
</center><br>

<!--
ADAM is necessary for training some of the networks for using language models. For optimizing neural networks, SGD with momentum or ADAM is generally preferred. However, ADAM's theory in papers is poorly understood and it also has several disadvantages:

* It can be shown on very simple test problems that the method does not converge.
* It is known to give generalization errors. If the neural network is trained to give zero loss on the data you trained it on, it will not give zero loss on other data points that it has never seen before. It is quite common, particularly on image problems, that we get worse generalization errors than when SGD is used. Factors could include that it finds the closest local minimum, or less noise in ADAM, or its structure, for instance.
* With ADAM we need to maintain 3 buffers, whereas SGD needs 2 buffers. This doesn't really matter unless we train a model on the order of several gigabytes in size, in which case it might not fit in memory.
* 2 momentum parameters need to be tuned instead of 1. 
--> 

ADAM ضرورية في تدريب بعض الشبكات مثل تلك التي تُستخدم لتكوين نماذج اللغات. من أجل تحسين الشبكات العصبية عادة ما يتم استخدام SGD مع الزخم أو ADAM. لكن الجانب النظري لـ ADAM غير مفهوم بصورة جيدة، كما لها عدة مساوىء منها: 

* يمكن أن يثبت عن طريق إختبار بسيط أن الطريقة لا تتقارب لقيمة معينة 
* من المعروف أن الطريقة تعطي أخطاء تعميم. إذا تم تدريب الشبكة العصبية لتعطي خسارة صفرية في البيانات التي تم تدريبها عليها فأنها لن تعطي خسارة صفرية على البيانات التي لم تراها الشبكة. أيضاً شائع - تحديداً في مشاكل الصور - أن تعطي أخطاء تعميم أسوء مقارنة بتلك الناتجة من SGD. الأسباب قد تتضمن مثلاً أنها تجد أقرب نقطة صغرى محلية أو أن هنالك تشويش أقل في ADAM أو من بنيتها.  
* في ADAM نحتاج لإستخدام 3 مستودعات بينما في SGD نحتاج إلى إثنان فقط. هذا غير مؤثر إلا عندما ندرب نموذج حجمه يصل لعدد من القيقابايت و في هذه الحالة قد تكون الذاكرة غير كافية. 
* نحتاج إلى ضبط معاملي زخم بدلاً عن واحد.


<!--
## [Normalization layers](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

Rather than improving the optimization algorithms, *normalization layers* improve the network structure itself. They are additional layers in between existing layers. The goal is to improve the optimization and generalization performance.

In neural networks, we typically alternate linear operations with non-linear operations. The non-linear operations are also known as activation functions, such as ReLU. We can place normalization layers before the linear layers, or after the activation functions. The most common practice is to put them between the linear layers and activation functions, as in the figure below. 
-->

## [طبقات التسوية (Normalization layers)](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

بدلاً عن تطوير خوارزيميات التحسين، *طبقات التسوية* تطور بنية الشبكة نفسها. هي عبارة عن طبقات إضافية بين الطبقات الموجودة سابقاً في الشبكة. الهدف من وضعها هو تطوير جودة التحسين و التعميم. 

في الشبكات العصبية، ننتقل بين عمليات خطية وعمليات غير خطية. العمليات اللاخطية تعرف أيضاً بدوال التنشيط، مثلاً ReLU. يمكننا وضع طبقات التسوية قبل الطبقات الخطية أو بعد الطبقات اللاخطية. أكثر مكان شائع لوضعها هو ما بين الطبقات الخطية ودوال التنشيط كما موضح في الشكل أدناه.  


<!--
| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Before adding normalization                              |                (b) After adding normalization                |                    (c) An example in CNNs                    |

<center><b>Figure 3:</b> Typical positions of normalization layers.</center>

In figure 3(c), the convolution is the linear layer, followed by batch normalization, followed by ReLU.

Note that the normalization layers affect the data that flows through, but they don't change the power of the network in the sense that, with proper configuration of the weights, the unnormalized network can still give the same output as a normalized network. 
-->

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) قبل إضافة طبقات التسوية                            |                (b) بعد إضافة طبقات التسوية                |                    (c) مثال باستخدام  CNNs                    |

<center><b>شكل 3:</b> مواقع طبقات التسوية</center>

في شكل 3 (c) طبقة الإلتفاف هي الطبقة الخطية تتبعها طبقة تسوية ثم طبقة غير خطية ReLU.

لاحظ أن طبقات التسوية تؤثر على البيانات التي تمر من خلالها لكن لا تغير من قوة الشبكة مع تهيئة مناسبة للأوزان فأن شبكة بدون طبقات تسوية يمكن أن تعطي نفس المخرج لشبكة تستخدم طبقات تسوية. 

<!-- 
### Normalization operations

This is the generic notation for normalization: 
-->

### عمليات التسوية

هذا هو التعبير العام للتسوية: 

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

<!--
where $x$ is the input vector, $y$ is the output vector, $\mu$ is the estimate of the mean of $x$, $\sigma$ is the estimate of the standard deviation (std) of $x$, $a$ is the learnable scaling factor, and $b$ is the learnable bias term.

Without the learnable parameters $a$ and $b$, the distribution of output vector $y$ will have fixed mean 0 and std 1. The scaling factor $a$ and bias term $b$ maintain the representation power of the network,*i.e.*the output values can still be over any particular range. Note that $a$ and $b$ do not reverse the normalization, because they are learnable parameters and are much more stable than $\mu$ and $\sigma$. 
--> 

حيث $x$ هو متجه الإدخال و $y$ هو متجه الإخراج و $\mu$ هي المقدر لمتوسط $x$و $\sigma$ هي المقدر للإنحراف المعياري لـ $x$ و $a$ هي معامل تكبير قابل للتعلم و $b$ هي معامل إنحياز قابل للتعلم.    

بدون المعاملات القابلة للتعلم $a$ و $b$ فأن توزيع متجه الإخراج $y$ سوف يكون له متوسط ثابت 0 و إنحراف معياري 1. معامل التكبير $a$ و معامل الإنحياز $b$ يحافظان على قوة تمثيل الشبكة و يعني ذلك أن قيم المخرجات تكون في أي فترة معينة. لاحظ أن $a$ و $b$  لا يعكسان التسوية ﻷنهما عوامل قابلة للتعلم و أكثر ثباتاً من $\mu$ و $\sigma$.        

<!-- 
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Normalization operations.
</center>
--> 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>شكل 4:</b> عمليات التسوية.
</center>

<!--
There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels: 
--> 

يوجد طرق عدة لتسوية متجه الإدخال إعتماداً على كيفية إختيار العينات التي يتم إستعمالها في التسوية. الشكل 4 يوضح 4 طرق مختلفة للتسوية. إذا كان لدينا حزمة صغيرة تتكون من $N$ صورة بإرتفاع $H$ و عرض $W$ و عدد قنوات $C$ فأن طرق التسوية هي:      

<!--
 - *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information.
- *Layer norm*: the normalization is applied within one image across all channels.
- *Instance norm*: the normalization is applied only over one image and one channel.
- *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD. 
--> 

- *تسوية حزمة* (Batch norm): التسوية يتم تطبيقها فقط على قناة واحدة من المدخل. هذه أول طريقة تم إقتراحها و أكثر الطرق شيوعاً. رجاءاً إقرأ هذا المقال [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) لتحصل على معلومات أكثر. 
- *تسوية طبقة* (Layer norm): التسوية يتم تطبيقها على صورة واحدة عبر كل القنوات. 
- *تسوية مثال* (Instance norm): التسوية يتم تطبيقها على صورة واحدة و قناة واحدة. 
- *تسوية مجموعة* (Group norm): التسوية يتم تطبيقها على صورة واحدة و عدة قنوات. مثلاً القناة 0 إلى 9 هي مجموعة ثم القناة من 10 إلى 19 هي مجموعة أخرى و هكذا. عملياً فأن حجم المجموعة يكون غالباً 32. هذا الطريقة موصى بها من قبل Aaron Defazio لأن أدائها عملياً جيد و لا تتعارض مع SGD. 

<!--
In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems.
--> 

عملياً فأن تسوية الحزمة و تسوية المجموعة تعمل جيداً في مشاكل رؤية الحاسوب بينما تسوية الطبقة و المثال تستخدم بكثرة في مشاكل معالجة اللغات. 

<!-- 
### Why does normalization help?

Although normalization works well in practice, the reasons behind its effectiveness are still disputed. Originally, normalization is proposed to reduce "internal covariate shift", but some scholars proved it wrong in experiments. Nevertheless, normalization clearly has a combination of the following factors:

- Networks with normalization layers are easier to optimize, allowing for the use of larger learning rates. Normalization has an optimization effect that speeds up the training of neural networks.
- The mean/std estimates are noisy due to the randomness of the samples in batch. This extra "noise" results in better generalization in some cases. Normalization has a regularization effect.
- Normalization reduces sensitivity to weight initialization.

As a result, normalization lets you be more "careless" -- you can combine almost any neural network building blocks together and have a good chance of training it without having to consider how poorly conditioned it might be.
-->

### لماذا تساعد التسوية في تحسين التدريب؟

رغماً أن التسوية تعمل جيداً عملياً إلا أن الأسباب وراء فعاليتها غير متفق عليها. تم إقتراح التسوية لتقليل الإزاحة المتغيرة داخلياً  "internal covariate shift" لكن بعض الباحثين أثبتوا أن هذا الأفتراض خاطىء في التجارب. بالإضافة التسوية تتكون من مجموعة العوامل التالية: 

- الشبكة التي تحتوي على طبقات تسوية تحسينها أسهل و هذا يسمح باستعمال معدلات تعلم عالية. التسوية لديها تأثير تحسيني يسرع من عملية تدريب الشبكة العصبية. 
- تقديرات المتوسط و الإنحراف تكون مشوشة بسبب عشوائية العينات في الحزمة المعينة. هذه العشوائية الزائدة تؤدي إلى تعميمات أفضل في بعض الحالات. التسوية لها تأثير تنظيمي (regularization).
- التسوية تقلل من حساسية تهيأة الأوزان.

كنتيجة التسوية تجعلك أقل حذراً فيمكنك تكوين شبكة من أي أجزاء و تحصل على نتائج جيدة بدون إعتبار سوء تنفيذك.   

<!--
### Practical considerations

It’s important that back-propagation is done through the calculation of the mean and std, as well as the application of the normalization: the network training will diverge otherwise. The back-propagation calculation is fairly difficult and error-prone, but PyTorch is able to automatically calculate it for us, which is very helpful. Two normalization layer classes in PyTorch are listed below:

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

Batch norm was the first method developed and is the most widely known. However, **Aaron Defazio recommends using group norm** instead. It’s more stable, theoretically simpler, and usually works better. Group size 32 is a good default.

Note that for batch norm and instance norm, the mean/std used are fixed after training, rather than re-computed every time the network is evaluated, because multiple training samples are needed to perform normalization. This is not necessary for group norm and layer norm, since their normalization is over only one training sample.
--> 

### إعتبارات عملية 
من المهم أن يحسب الإنتشار الخلفي من خلال حساب المتوسط و الإنحراف المعياري كما يتم في تطبيق التسوية و إلا فأن تدريب الشبكة سوف يتباعد. حساب الإنتشار الخلفي صعب و معرض للأخطاء لكن إطار PyTorch يستطيع أن يحسبه تلقائياً و هذا مفيد جداً. طبقتين تسوية من نوعين مختلفين في PyTorch موضحات أدناه:

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

تسوية الحزمة هي أول طريقة تم تطويرها و أكثر الطرق شيوعاً. لكن **Aaron Defazio يوصي باستخدام تسوية المجموعة**. تسوية المجموعة أكثر ثباتاً و نظرياً أبسط و غالباً تعمل بصورة جيدة. استعمال حجم مجموعة مساو ل 32 إختيار جيد. 

لاحظ أنه بالنسبة لتسوية حزمة و تسوية مثال، يتم إصلاح المتوسط ​​/ الانحراف المعياري بعد التدريب ، بدلاً من إعادة حسابه في كل مرة يتم فيها تقييم الشبكة، لأن هناك حاجة إلى عينات تدريب متعددة لإجراء التسوية. هذا ليس ضروريًا لتسوية مجموعة أو طبقة، نظرًا لأن تسويتها يتجاوز عينة تدريب واحدة فقط.

<!--
## [The Death of Optimization](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

Sometimes we can barge into a field we know nothing about and improve how they are currently implementing things. One such example is the use of deep neural networks in the field of Magnetic Resonance Imaging (MRI) to accelerate MRI image reconstruction.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5:</b> Sometimes it actually works!
</center>
-->

## [موت التحسينات](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

أحياناً ندخل في مجال لا نعلم عنه شيئاً و نطور الطرق المستعملة فيه. كمثال استخدام الشبكات العصبية العميقة في مجال تصوير الرنين المغنيطيسي (MRI) في تسريع إعادة تكوين صور الMRI. 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>شكل 5:</b> أحياناً، إنها تعمل بالفعل! 
</center>

<!--
### MRI Reconstruction

In the traditional MRI reconstruction problem, raw data is taken from an MRI machine and an image is reconstructed from it using a simple pipeline/algorithm. MRI machines capture data in a 2-dimensional Fourier domain, one row or one column at a time (every few milliseconds). This raw input is composed of a frequency and a phase channel and the value represents the magnitude of a sine wave with that particular frequency and phase. Simply speaking, it can be thought of as a complex valued image, having a real and an imaginary channel. If we apply an inverse Fourier transform on this input, i.e add together all these sine waves weighted by their values, we can get the original anatomical image.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Fig. 6:</b> MRI reconstruction
</center><br>

A linear mapping currently exists to go from the Fourier domain to the image domain and it's very efficient, literally taking milliseconds, no matter how big the image is. But the question is, can we do it even faster?
-->

### إعادة تكوين صور الرنين المغنطيسي (MRI Reconstruction) 

في مشكلة إعادة تكوين صور الـ MRI تؤخذ البيانات المجردة من جهاز الرنين المغنطيسي و يتم إعادة تكوين الصورة باستخدام خوارزمية. أجهزة الـ MRI تلتقط البيانات في مجال فورير ثنائي الأبعاد، صف واحد أو عمود واحد في المرة الواحدة (كل أجزاء من الثانية). هذا المدخل يتكون من تردد و قناة طور و القيمة تمثل مقدار دالة جيبية لديها نفس التردد و الطور. ببساطة يمكن أن نعتبرها صورة قيمها أعداد مركبة و تحتوي على قناة حقيقية و قناة تخيلية. إذا طبقنا تحويل فورير العكسي على هذا المدخل - عن طريق جمع كل الموجات الجيبية (sine waves) موزونة بقيمها - فأننا سنحصل على الصورة الأصلية. 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>شكل 6:</b>  إعادة تكوين MRI  
</center><br>

يوجد تحويل خطي من مجال فورير إلى مجال الصورة و كفاءته جيدة و يأخذ أجزاء من الثانية بغض النظر عن كبر حجم الصورة. لكن السؤال هل يمكن أن نحصل على سرعة أكبر.  

<!--
### Accelerated MRI

The new problem that needs to be solved is accelerated MRI, where by acceleration we mean making the MRI reconstruction process much faster. We want to run the machines quicker and still be able to produce identical quality images. One way we can do this and the most successful way so far has been to not capture all the columns from the MRI scan. We can skip some columns randomly, though it's useful in practice to capture the middle columns, as they contain a lot of information across the image, but outside them we just capture randomly. The problem is that we can't use our linear mapping anymore to reconstruct the image. The rightmost image in Figure 7 shows the output of a linear mapping applied to the subsampled Fourier space. It's clear that this method doesn't give us very useful outputs, and that there's room to do something a little bit more intelligent.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Fig.</b> Linear mapping on subsampled Fourier-space
</center><br>
-->

### MRI المسرعة

المشكلة الجديدة التي تحتاج إلى أن حل هي تسريع الـ MRI و نعني بالتسريع أن نجعل عملية إعادة تكوين الـ MRI أسرع. و نريد  أن نحافظ على جودة الصورة. واحدة من الطرق ومن الطرق الأكثر نجاحاً هي أن لا نلتقط جميع الأعمدة من ماسح الـ MRI. يمكننا أن نتجاهل بعض الأعمدة عشوائياً لكن عملياً إلتقاط الأعمدة الموجودة في الوسط أكثر فائدة ﻷنها تحتوي على معلومات كثيرة و يمكن أن نختار عشوائياً خارج المنطقة الوسطى. تكون المشكلة أنه لا يمكننا إستعمال التحويل الخطي لإعادة تكوين الصورة مرة أخرى. الصورة الموجودة على أقصى اليمين في شكل 7 توضح مخرج التحويل الخطي المطبق على فضاء فورير. من الواضح أن هذه الطريقة لا تعطينا مخرجات مفيدة جداً و هنالك مجال لتحسينها.  

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b> شكل 7</b> التحويل الخطي في فراغ فورير
</center><br>

<!--
### Compressed sensing

One of the biggest breakthroughs in theoretical mathematics for a long time was compressed sensing. A paper by <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> showed that theoretically, we can get a perfect reconstruction from the subsampled Fourier-domain image. In other words, when the signal we are trying to reconstruct is sparse or sparsely structured, then it is possible to perfectly reconstruct it from fewer measurements. But there are some practical requirements for this to work -- we don't need to sample randomly, rather we need to sample incoherently -- though in practice, people just end up sampling randomly. Additionally, it takes the same time to sample a full column or half a column, so in practice we also sample entire columns.

Another condition is that we need to have *sparsity* in our image, where by sparsity we mean a lot of zeros or black pixels in the image. The raw input can be represented sparsely if we do a wavelength decomposition, but even this decomposition gives us an approximately sparse and not an exactly sparse image. So, this approach gives us a pretty good but not perfect reconstruction, as we can see in Figure 8. However, if the input were very sparse in the wavelength domain, then we would definitely get a perfect image.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8: </b>Compressed sensing
</center><br>

Compressed sensing is based on the theory of optimization. The way we can get this reconstruction is by solving a mini-optimization problem which has an additional regularization term:
-->

###  Compressed sensing (الاستشعار المضغوط)

 واحدة من أكبر الاكتشافات في مجال الرياضيات النظرية لوقت طويل هي الاستشعار المضغوط. ورقة علمية بواسطة  <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> توضح نظرياً أنه يمكن الحصول صورة مثالية معاد تكوينها من مجال فورير. بصورة أخرى فأن الموجة التي نحاول أن نعيد تكوينها تكون منتشرة أو بنيتها منتشرة لكن يمكننا أن نعيد تكوينها بصورة مثالية من عدة قياسات قليلة. لكن توجد متطلبات عملية لكي تعمل هذه الطريقة -- لا نحتاج لأخذ عينات عشوائياً لكن نحتاج لأخذ عينات بصورة غير منتظمة -- لكن عملياً الناس يأخذون عينات عشوائية. بالأضافة أخذ عينة من عمود كامل أو نص عمود يحتاج إلى زمن لذلك عملياً نأخذ عينات من أعمدة كاملة. 

و نحتاج إلى شرط أخر و هو أن وجود الانتشار (sparsity) في الصورة و نعني بالإنتشار أن تكون في الصورة بيكسلات صفرية أو سوداء كثيرة. المدخل يمكن أن نمثله إنتشارياً عن طريق مفكوك الطول الموجي  لكن حتى هذا المفكوك يعطينا إنتشاراً مقرباً و ليس صورة منتشرة بالتحديد. لذلك هذه الطريقة تعطينا صورة جيدة جداً كما في الشكل 8. لكن إذا كان المدخل منتشر جداً في مجال الطول الموجي فإننا سنحصل على صورة مثالية.       


$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

<!--
where $M$ is the mask function that zeros out non-sampled entries, $\mathcal{F}$ is the Fourier transform, $y$ is the observed Fourier-domain data, $\lambda$ is the regularization penalty strength, and $V$ is the regularization function.

The optimization problem must be solved for each time step or each "slice" in an MRI scan, which often takes much longer than the scan itself. This gives us another reason to find something better.
--> 

حيث $M$ هي دالة غطائية تُصفِّر كل عنصر غير مختار و $\mathcal{F}$ هو عبارة عن تحويل فورير و  $y$ هي البيانات المشاهدة في مجال فورير و  $\lambda$ هي معامل قوة التنظيم و $V$ هي دالة التنظيم. 

مشكلة التحسين يجب أن تُحل لكل خطوة زمن أو كل قطعة في مسح الـ MRI و أحياناً تأخذ زمناً أطول من المسح نفسه. و هذا سبب آخر للبحث عن شيء أفضل.      

<!-- 
### Who needs optimization?

Instead of solving the little optimization problem at every time step, why not use a big neural network to produce the required solution directly? Our hope is that we can train a neural network with sufficient complexity that it essentially solves the optimization problem in one step and produces an output that is as good as the solution obtained from solving the optimization problem at each time step.
-->

### ماالذي بحاجة للتحسين؟

بدلاً عن حل مشكلة التحسين الصغيرة هذه في كل خطوة زمن لماذا لا نستعمل شبكة عصبية كبيرة لإنتاج الحل المطلوب؟  أملنا هو أن ندرب شبكة عصبية بتعقيد مناسب من أجل حل مشكلة التحسين في خطوة واحدة و إنتاج مخرج جيد مثل الذي نحصل عليه من حل مشكلة التحسين في كل خطوة زمنية. 

$$
\hat{x} = B(y)
$$

<!--
where $B$ is our deep learning model and $y$ is the observed Fourier-domain data.

15 years ago, this approach was difficult -- but nowadays this is a lot easier to implement. Figure 9 shows the result of a deep learning approach to this problem and we can see that the output is much better than the compressed sensing approach and looks very similar to the actual scan.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Deep Learning approach
</center><br>

The model used to generate this reconstruction uses an ADAM optimizer, group-norm normalization layers, and a U-Net based convolutional neural network. Such an approach is very close to practical applications and we will hopefully be seeing these accelerated MRI scans happening in clinical practice in a few years' time.
-->

حيث $B$ هو نموذج الشبكة العصبية العميق و $y$ هي بيانات مجال فورير التي نراقبها. 

قبل 15 سنة، كانت هذه الطريقة صعبة، لكن اﻵن أصبح تنفيذها أكثر سهولةً. شكل 9 يوضح نتائج طريقة التعلم العميق و نرى أن المخرج أفضل من مخرج طريقة الإستشعار المضغوط و يشبه جداً الصورة المأخوذة من مسح عادي. 

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>شكل 9: </b> طريقة التعلم العميق
</center><br>

النموذج المستخدم لإعادة تكوين الصور يستخدم محسن ADAM و طبقات تسوية مجموعة و U-Net CNN. هذه الطريقة قريبة جداً من التطبيقات العملية و نأمل أن نرى مسح MRI المسرع قريباً  يستخدم في العيادات في السنوات القليلة القادمة.  
