---
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: الجبر الخطي و الالتفاف
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
lang: ar
translation-date: 22 Aug 2020
translator: Ahmed Alhassan
---

<!-- ## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s) -->

## [مراجعة الجبر الخطي](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

<!-- This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$: -->

هذا الجزء مراجعة للجبر الخطي ضمن صياغ الشبكات العصبية. فلنبدأ بطبقة مخفية واحدة $\boldsymbol{h}$:

<!-- $$
\boldsymbol{h} = f(\boldsymbol{z})
$$ -->

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!-- The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$: -->

الناتج هو دالة غير خطية $f$ مطبقة على المتجه $z$. هنا $z$ عبارة عن مخرج التحويل التآلفي $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ للمتجه $\boldsymbol{x} \in\mathbb{R^n}$:

<!-- $$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$ -->

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!-- For simplicity biases are ignored. The linear equation can be expanded as: -->

لتبسيط التحويل سنتجاهل الحدود المطلقة، لتصبح المعادلات هكذا:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$ 

<!-- where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$. -->

حيث تمثل $i$ في $\boldsymbol{a}^{(i)}$ رقم الصف في المصفوفة $\boldsymbol{A}$.

<!-- To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$. -->

حتى نفهم المعنى وراء هذا التحويل، علينا أن نحلل إحدى مكونات $\boldsymbol{z}$، على سبيل المثال $a^{(1)}\boldsymbol{x}$. دع $n=2$، و من ثم $\boldsymbol{a} = (a_1,a_2)$ و $\boldsymbol{x}  = (x_1,x_2)$.

<!-- $\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as: -->

يمكن رسم $\boldsymbol{a}$ و $\boldsymbol{x}$ كمتجهين في نظام إحداثي ثنائي الأبعاد. الآن. إذا كانت الزاوية بين $\boldsymbol{a}$ و $\hat{\boldsymbol{\imath}}$ هي $\alpha$ و الزاوية بين $\boldsymbol{x}$ و $\hat{\boldsymbol{\imath}}$ هي $\xi$, عندها الصيغة المثلثية $a^\top\boldsymbol{x}$ تصبح:

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$


<!-- The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can be understood by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well. -->

يقيس الناتج مدى محاذاة المدخل بالنسبة لصف معين من المصفوفة $\boldsymbol{A}$. بإمكاننا فهم ذلك بملاحظة الزاوية بين المتجهين، $\xi-\alpha$. عندما يكون $\xi = \alpha$، نجد أن المتجهان متحاذيان تماماً و الناتج يكون في أقصى قيمه. أما إذا $\xi - \alpha = \pi$، عندها $\boldsymbol{a}^\top\boldsymbol{x}$ تصل أدنى قيمها و المتجهان يشيران إلى إتجاهين متعاكسين. كخلاصة، التحويل الخطي يمكننا من إسقاط المدخل على محاور مختلفة مُعرفة بدلالة المصفوفة $A$. يمكن استخدام هذا التفسير للأبعاد العليا أيضاً.

<!-- Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as: -->

بطريقة أخرى نستطيع فهم التحويل الخطي بأن $\boldsymbol{z}$ يمكن إعادة صياغتها كما يلي:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$



<!-- The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input. -->

يمثل المخرج مجموع أوزان أعمدة المصفوفة $\boldsymbol{A}$. ولذلك فإن الإشارات الناتجة ليست إلا تركيبة من المدخل.

<!-- ## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s) -->

## [من الجبر الخطي إلى الالتفاف](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!-- Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: - -->

سنقوم الآن بالتوسع والانتقال من التحويل الخطي إلى الالتفاف، مستخدمين تحليل البيانات الصوتية كمثال. بداية، نقوم بتمثيل الطبقة كلية الإتصال بعمليات الضرب:

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


<!-- In this example، the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$. -->

في هذا المثال، مصفوفة الأوزان بالأبعاد $4 \times 3$، و المتجه المدخل بالأبعاد $3 \times 1$ و المتجه المخرج بالأبعاد $4 \times 1$.

<!-- However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (_e.g._ 3 seconds) times the sampling rate (_e.g._ 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat". -->

و لكن, بالنسبة للبيانات الصوتية، عادة ما تكون البيانات أطول بكثير (ليست 3 عينات فقط). عدد العينات للبيانات الصوتية تساوي مدة المقطع الصوتي (في هذا المثال 3 ثوان) مضروبة في معدل أخذ العينات (في هذا المثال 22.05 كيلو هرتز). يعد المتجه المدخل $\boldsymbol{x}$ طويلاً كما هو موضح أدناه. و بالمثل, مصفوفة الأوزان ستأخذ مساحة كبيرة.

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


<!-- The above formulation will be difficult to train. Fortunately there are ways to simplify the same. -->

بالتالي الصيغة أعلاه صعبة للتدريب. ولحسن الحظ بإمكاننا تبسيطها.

<!-- ### Property: locality -->

### خاصية المحلية

<!-- Due to locality (_i.e._ we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$. -->

بسبب المحلية (وهي عدم الإكتراث بالنقاط البعيدة في البيانات عن نقطتنا هذه) يمكن استبدال البيانات $w_{1k}$ في مصفوفة الأوزان أعلاه بالأصفار عندما تكون $k$ كبيرة كفاية. عندها، يصبح الصف الأول للمصفوفة مرشحاً بطول 3. فلنسم هذا المرشح بالرمز $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$


<!-- ### Property: stationarity -->

### خاصية السكون

<!-- Natural data signals have the property of stationarity (_i.e._ certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (_i.e._ stride is 1), resulting in the following: -->

تمتلك موجات البيانات الطبيعة خاصية الثبات (إذ تتكو عدد من الأنماط الثابتة فيها). يساعدنا ذلك في إعادة استخدام المرشح $\mathbf{a}^{(1)}$ المعرف مسبقاً. نستخدم المرشح بتحريكه خطوة عند كل مرة (كل خطوة انتقالية تساوي 1), منتجاً الآتي:

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$


<!-- Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing. -->

يمتلئ الجزء العلوي والسفلي من المصفوفة بالأصفار بسبب المحلية، مما يؤدي إلى تناثر القيم التي لا تساوي صفر. إعادة استخدام مرشح معين باستمرار يسمى بمشاركة الأوزان.

<!-- ### Multiple layers of Toeplitz matrix -->

### الطبقات المتعددة لمصفوفة توبلتز (Toeplitz)

<!-- After these changes, the number of parameters we are left with is 3 (_i.e._ $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (_i.e._ $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same. -->

بعد تلك التغييرات، يثبح عدد المعاملات المتبقية مساويًا إلى 3 (_وهي_ $a_1,a_2,a_3$). بالمقارنة المصفوفة السابقة ذات الـ 12 معاملًا ($w_{11},w_{12},\cdots,w_{43}$)، نجد أن عدد المعاملات الحالي مقيد جداً ولذلك يجب نمدده للوصول لنفس العدد.

<!-- The previous matrix can be considered to be a layer (_i.e._ a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters. -->

تعتبر المصفوفة السابقة طبقة بحد زاتها (طبقة التفافية) مع المرشح $\boldsymbol{a}^{(1)}$. عندها يمكننا أن نبني عدة طبقات باستخدام مرشحات مختلفة $\boldsymbol{a}^{(2)}$، $\boldsymbol{a}^{(3)}$، الخ، وبالتالي نزيد من عدد المعاملات.

<!-- Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well. -->

كل طبقة تحتوي على مرشح واحد فقط مكرر عدة مرات. يدعى هذا النوع من المصفوفات مصفوفة توبلتز. في كل مصفوفة من هذا النوع، تمثل عناصر كل قطر نازل من اليسار إلى اليمين ذات الثابت. مصفوفات توبلتز المستخدمة هنا هي مصفوفة متناثرة القيم.

<!-- Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector looks like the following: - -->

باعتبار المرشح الأول كمعطى $\boldsymbol{a}^{(1)}$ و كذلك المتجه المدخل $\boldsymbol{x}$، أول عنصر بالناتج من هذه الطبقة هو $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. ومنها يصبح المتجه الناتج:

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$



<!-- The same matrix multiplication method can be applied on following convolutional layers with other kernels (_e.g._ $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results. -->

يمكن استعمال ذات الصيغة في الطبقات الالتفافية التالية ($\boldsymbol{a}^{(2)}$ و $\boldsymbol{a}^{(3)}$) للحصول على نتائج مشابهة.

<!-- ## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s) -->

## [الاستماع للالتفاف - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb). -->

يمكنك إيجاد الملف [هنا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).

<!-- In this notebook, we are going to explore Convolution as a 'running scalar product'. -->

في الملف أعلاه, سنكتشف الالتفاف كـ 'ضرب نقطي متحرك'.

<!-- The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and its sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2). -->

المكتبة `librosa` ستمكننا من تحميل المقطع الصوتي $\boldsymbol{x}$ و معدل أخذ العينات. في هذه الحالة، هناك 70641 عينة، و معدل أخذ العينات هو 22.05 كيلو هرتز، كما أن زمن المقطع هو 3.2 ثوان. المقطع المحمل متموج (انظر الشكل 1) ويمكننا أن نتوقع الصوت بالنظر إالى قيم المحور $y$ . الإشارة الصوتية $x(t)$ هو الصوت الذي يصدر عن إغلاق نظام ويندوز (انظر الشكل 2).

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: A visualization of the audio signal. <br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>الشكل. 1</b>: الإشارة الصوتية. <br>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Notes for the above audio signal.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>الشكل. 2</b>: ملاحوظات للموجة الصوتية أعلاه.<br>
</center>

<!-- We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (_e.g._ first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal. -->

في البداية نحتاج لعزل الدرجات الموسيقية عن بعضها في الموجة. إذا استعملنا تحويل فوريه (Fourier transform) سنحصل على كافة الدرجات وسيكون من الصعب تحديد زمن وموقع كل درجة. لذلك، سنستعمل تحويل فوريه على فترات قصيرة من الزمن (والذي يعرف بالمخطط الطيفي). كما نرى من المخطط الطيفي (انظر الشكل 3), تعلوا الدرجات المختلف عند ترددات مختلفة (_على سبيل المثال_ الدرجة الأولى عند 1600). عند دمج الأربعة درجات، نستعيد المقطع الأصلي.

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Audio signal and its spectrogram.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>الشكل. 3</b>: الإشارة الصوتية و مخطط طيفها.<br>
</center>

<!-- Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes in the input piece (_i.e._ the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolutions of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the convolutions prove the effectiveness of the convolutions in extracting the notes. -->

يساعد التفاف الإشارة المدخلة مع كل الدرجات الموسيقية (مثلاً كل مفاتيح البيانو) على استخراج كل الدرجات من المقطع المدخل (_أي_ عدنما يساوي التسجيل درجة مرشح ما). شكل 4 يوضح المخطط الطيفي للمقطع الأصلي وإلى جانبه المقطع المركب من الدرجات، في حين أن شكل 5 يوضح ترددات المقطع الأصلي والدرجات الأربع. أما شكل 6 فيوضح نتيجة التفاف المرشحات الأربعة مع المقطع الأصلي. يثبت الشكل 6 إضافة للمقاطع الصوتية للالتفاف يثبتان كفاءة الالتفاف في استخراج الدرجات الموسيقية.

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>الشكل. 4</b>: مخطط الطيف للإشارة الأساسية (يسار) و المخطط الطيفي لتركيز الدرجات الصوتية (يمين).<br>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: First note of the melody.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>الشكل. 5</b>: أول درجة موسيقية في المقطع.<br>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolution of four kernels.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>الشكل. 6</b>: الالتفاف لأربعة مرشحات.<br>
</center>

<!-- ## Dimensionality of different datasets -->

## أبعاد البيانات المختلفة

<!-- The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of functions mapping from domains $\Omega$ to channels $c$. -->

في هذا الجزء، سنبتعد قليلاً عما سبق لنتحدث عن التمثيلات المختلفة للأبعاد مع أمثلة على ذلك. سنأخذ بعين الاعتبار المجال $X$ المعطى بالعلاقة من $\Omega$ إلى القنوات $c$.

<!-- ### Examples -->

### أمثلة

<!-- - Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), _etc._
- Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), _etc._
- Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it is called Hamiltonian. -->

- البيانات الصوتية: عناصر المجال أحادية البعد، إشارة رقمية متقطعة مجدولة بالزمن؛ عدد القنوات $c$ يتراوح بين 1 (أحادي)، 2 (ستريو)، 5+1 (دولبي 5.1) الخ
- الصور: عناصر المجال ثنائية الأبعاد (pixels)؛ $c$ يتراوح بين 1(تدرج رمادي)، 3(ملون)، 20(فائق الطيفية)، الخ
- النسبية الخاصة: المجال هو $\mathbb{R^4} \times \mathbb{R^4}$ (الزمكان $\times$ كميات الحركة الأربعة)؛ عند $c = 1$ المسمى بالهاملتوني (Hamiltonian)

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Fig. 7</b>: Different dimensions of different types of signals.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>الشكل. 7</b>: الأبعاد المختلفة لأنواع مختلفة من الإشارات.<br>
</center>
