---
lang-ref: ch.03-3
title: خصائص الإشارات الطبيعية
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
lang: ar
translation-data: 27 Aug 2020
translator: Mohamed Adel Musallam
---

<!--
## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)
-->


## [خصائص الإشارات الطبيعية](https://www.youtube.com/watch؟v=kwPWpVverkw&t=26s)

<!--All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language *i.e.* it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.
-->

يمكن التفكير في مختلف أنواع الاشارات على أنها متجهات. على سبيل المثال الإشارة الصوتية يمكن اعتبارها متجه أحادي البعد $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$  حيث كل قيمة $x_t$ تمثل اتساع الموجة الصوتية في الزمن $t$. ولكي تستطيع أن تفهم ما ينطق به شخص ما، تقوم قَوْقَعَةُ الأُذُن اولا بتحويل ضغط الهواء الناتج عن الموجات الصوتية إلى اشارات وبعد ذلك يقوم العقل باستخدام نموذج لغوي إلى تحويل تلك الموجات إلى لغة، *أي* عليه اختيار الكلام الأقرب احتمالاً من الموجة المسموعة. بالنسبة للموسيقى، تكون الإشارة مجسمة تحتوي على قناتين أو أكثر لتوهم أن الصوت يأتي من اتجاهات متعددة. و  على الرغم من أنها تحتوي على قناتين، إلا أنها لا تزال إشارة 1D لأن الوقت هو المتغير الوحيد.

<!--An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.
-->

الصورة هي إشارة ثنائية الأبعاد لأن المعلومات مصورة مكانيًا. لاحظ أن كل نقطة يمكن أن تكون متجهًا في حد ذاته. هذا يعني أنه إذا كان لدينا قنوات $d$ في صورة ما، فإن كل نقطة مكانية في الصورة هي متجه للأبعاد $d$.
تحتوي الصورة الملونة على مستويات RGB، مما يعني أن $d = 3$. لأي نقطة $x_{i,j}$، هذا يتوافق مع شدة الألوان الأحمر والأخضر والأزرق على التوالي.


<!--We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.
-->

يمكننا حتى تمثيل اللغة بالمنطق أعلاه. تتوافق كل كلمة مع متجه  واحد نشط بمعنى وجود واحد في الموضع الذي يظهر في مفرداتنا وأصفارنا في كل مكان آخر. هذا يعني أن كل كلمة هي متجه لحجم المفردات.

<!--Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.
-->

تتبع إشارات البيانات الطبيعية هذه الخصائص:
1. الثبات: تتكرر أشكال معينة خلال الإشارة. في الإشارات الصوتية، نلاحظ نفس النوع من الأنماط مرارًا وتكرارًا عبر المجال الزمني.
اما في الصور، هذا يعني أنه يمكننا توقع تكرار أنماط بصرية مماثلة عبر الأبعاد.

2. الموقع المحلي: النقاط القريبة أكثر ارتباطًا من النقاط البعيدة. بالنسبة للإشارة 1D، هذا يعني أننا إذا لاحظنا ذروة عند نقطة ما $t_i$، فإننا نتوقع أن يكون للنقاط في نافذة صغيرة حول $t_i$ قيم مماثلة لـ $t_i$ ولكن لنقطة $t_j$ بعيدة عن $t_i$، $x_{t_i}$ له تأثير أقل على $x_{t_j}$. بشكل أكثر تحديدا، يكون الالتفاف بين الإشارة ونظيرتها المقلوبة ذروته عندما تتداخل الإشارة تمامًا مع نسختها المقلوبة. الالتفاف بين إشارتين 1D (الارتباط المتبادل) ليس سوى حاصل الضرب النقطي الخاص بهما وهو مقياس لمدى تشابه أو قرب المتجهين. وبالتالي، يتم احتواء المعلومات في أجزاء وأجزاء محددة من الإشارة. بالنسبة للصور، هذا يعني أن الارتباط بين نقطتين في صورة ما يقل كلما ابتعدنا عن النقاط. إذا كان $x_{0,0}$ باللون الأزرق، فإن احتمال أن يكون البكسل التالي ($x_{1,0},x_{0,1}$)
أزرق أيضًا يكون مرتفعًا جدًا  ولكن  مع انتقالك  إلى  الطرف  المقابل  للصورة  ($x_{-1,-1}$) ، قيمة هذا 
البكسل مستقلة عن قيمة البكسل عند   $x_{0,0}$ .

3. التكوين: كل شيء في الطبيعة يتكون من أجزاء تتكون من أجزاء فرعية وما إلى ذلك. على سبيل المثال، تشكل الحروف سلاسل تشكل الكلمات، والتي تشكل الجمل بشكل أكبر. يمكن دمج الجمل لتشكيل المستندات. تسمح التركيبة للعالم بأن يكون قابلاً للتفسير.

<!--If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.
-->

إذا أظهرت بياناتنا الثبات، والمكان، والتكوين، فيمكننا استغلالها مع الشبكات التي تستخدم التباين ومشاركة الوزن وتكديس الطبقات.

<!--
## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
-->


## [استغلال خصائص الإشارات الطبيعية لبناء الثبات والتوازن](https://www.youtube.com/watch؟v=kwPWpVverkw&t=1074s)


<!--
### Locality  $\Rightarrow$ sparsity
-->

### المحلية  $\Leftarrow$ التناثر.

<!--Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.
-->

يوضح الشكل 1 شبكة متصلة بالكامل من 5 طبقات. يمثل كل سهم وزنًا يتم ضربه في المدخلات. كما نرى، هذه الشبكة مكلفة للغاية من الناحية الحسابية.

<!--<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1:</b> Fully Connected Network</center>
-->

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b> الشكل 1: </b>   شبكة متصلة بالكامل </center>


<!--If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.
-->

إذا كانت بياناتنا تعرض مكانًا محليًا، فكل خلية عصبية تحتاج إلى الاتصال ببضعة خلايا عصبية محلية فقط من الطبقة السابقة. وبالتالي، يمكن إسقاط بعض الاتصالات كما هو موضح في الشكل 2. يمثل الشكل 2 (أ) شبكة تامة الاتصال FC. الاستفادة من الخاصية المحلية لبياناتنا، نقوم بإسقاط الاتصالات بين الخلايا العصبية البعيدة في الشكل 2 (ب). على الرغم من أن الخلايا العصبية المخفية (باللون الأخضر) في الشكل 2 (ب) لا تغطي المدخلات بالكامل، فإن الهيكل العام سيكون قادرًا على حساب جميع الخلايا العصبية المدخلة. المجال الاستقبالي (RF) هو عدد الخلايا العصبية في الطبقات السابقة، والتي يمكن لكل خلية عصبية في طبقة معينة رؤيتها أو أخذها في الاعتبار. لذلك، فإن RF للطبقة المخرجة باعتبار الطبقة المخفية هي 3، RF للطبقة المخفية باعتبار الطبقة المدخلة هي 3، لكن RF للطبقة الناتجة باعتبار طبقة الإدخال هي 5.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> Before Applying Sparsity | <b>Figure 2(b):</b> After Applying Sparsity|
-->

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/> |
| <b> الشكل 2 (أ): </b> قبل تطبيق التباين | <b> الشكل 2 (ب): </b> بعد تطبيق التباين |

<!--
### Stationarity $\Rightarrow$ parameters sharing
-->

### الثبات  $\Leftarrow$ مشاركة المتغيرات.

<!--If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.
-->

إذا كانت بياناتنا تعرض حالة ثابتة، فيمكننا استخدام مجموعة صغيرة من المتغيرات عدة مرات عبر بنية الشبكة. على سبيل المثال في شبكتنا المتفرقة، الشكل 3(أ)، يمكننا استخدام مجموعة من 3 متغيرات مشتركة (الأصفر والبرتقالي والأحمر). ثم سينخفض ​​عدد المعلمات من 9 إلى 3! قد تعمل البنية الجديدة بشكل أفضل لأن لدينا المزيد من البيانات لتدريب تلك الأوزان المحددة.
تسمى الأوزان بعد تطبيق التباين ومشاركة المعلمات نواة الالتفاف.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> Before Applying Parameter Sharing | <b>Figure 3(b):</b> After Applying Parameter Sharing|
-->

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
| <b> الشكل 3 (أ): </b> قبل تطبيق مشاركة المعلمات | <b> الشكل 3 (ب): </b> بعد تطبيق مشاركة المعلمات |

<!--Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation
-->

فيما يلي بعض مزايا استخدام التباين ومشاركة المعلمات: -
* مشاركة المتغيرات
  * تقارب أسرع
  * تعميم أفضل
  * غير معتمد على حجم الإدخال
  * استقلال نواة الالتفاف $\Leftarrow$ زيادة المعالجة على التوازي
* الاتصال المتناثر
  * تقليل مقدار الحوسبة

<!--Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).
-->

يوضح الشكل 4 مثالاً على حبات على بيانات 1D، حيث يكون حجم النواة: 2 (عدد النوى) * 7 (سمك الطبقة السابقة) * 3 (عدد التوصيلات / الأوزان الفريدة).

<!--The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.
-->

اختيار حجم النواة تجريبي. يبدو أن الالتفاف 3 * 3 هو الحجم الأدنى للبيانات المكانية. يمكن استخدام الالتفاف بالحجم 1 للحصول على طبقة نهائية يمكن تطبيقها على صورة إدخال أكبر. قد يقلل حجم النواة للأرقام الزوجية من جودة البيانات، وبالتالي لدينا دائمًا حجم نواة للأرقام الفردية، عادةً 3 أو 5.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> Kernels on 1D Data | <b>Figure 4(b):</b> Data with Zero Padding|
-->

| <img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
| <b> الشكل 4 (أ): </b> نواة على بيانات 1D | <b> الشكل 4 (ب): </b> بيانات ذات مساحة صفرية |

<!--### Padding
-->

### تبطين

<!--Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.
-->

يؤدي التبطين عمومًا إلى إضرار النتائج النهائية، ولكنه مناسب برمجيًا. نستخدم عادةً حشوة صفرية: `size =  (kernel size - 1)/2`.

<!--
### Standard spatial CNN
-->

### الشبكات الالتفافية المعيارية

<!--A standard spatial CNN has the following properties:
-->

يحتوي CNN المكاني القياسي على الخصائص التالية:

<!--* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection
-->

* طبقات متعددة
  * الالتفافية
  *  الدول اللاخطية (ReLU و Leaky)
  * التجميع
  * تطبيع الحزمة
* اتصال الالتفافية المتبقية

<!--Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.
-->

تعد تسوية الحزمات واتصالات التجاوز المتبقية مفيدة جدًا في جعل الشبكة تتدرب جيدًا.
يمكن أن تضيع أجزاء من الإشارة إذا تم تكديس العديد من الطبقات، لذا فإن التوصيلات الإضافية عبر التجاوز المتبقي تضمن مسارًا من الأسفل إلى الأعلى وأيضًا لمسار التدرجات القادمة من أعلى إلى أسفل.

<!--In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.
-->

في الشكل 5، بينما تحتوي صورة الإدخال في الغالب على معلومات مكانية عبر بعدين (بصرف النظر عن المعلومات المميزة، وهي لون كل بكسل)، فإن طبقة الإخراج سميكة. في منتصف الطريق، هناك مفاضلة بين المعلومات المكانية والمعلومات المميزة ويصبح التمثيل أكثر كثافة. لذلك، مع تقدمنا ​​في التسلسل الهرمي، نحصل على تمثيل أكثر كثافة حيث نفقد المعلومات المكانية.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5:</b> Information Representations Moving up the Hierarchy</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b> الشكل 5: </b> تمثيلات المعلومات تتقدم في التسلسل الهرمي </center>

<!--
### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)
-->

### [التجميع](https://www.youtube.com/watch؟v=kwPWpVverkw&t=2376s)

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6:</b> Illustration of Pooling</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>الشكل 6: </b> رسم توضيحي للتجميع </center>

<!--A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.
-->

يتم تطبيق عامل معين، $L_p$-norm، على مناطق مختلفة (راجع الشكل 6). يعطي عامل التشغيل هذا قيمة واحدة فقط لكل منطقة (قيمة واحدة لـ 4 بكسل في مثالنا). ثم نقوم بتكرار هذه العملية عبر منطقة البيانات بأكملها منطقة تلو الأخرى، واتخاذ خطوات بناءً على الخطوة. إذا بدأنا بـ $m * n$ data بقنوات $c$، فسننتهي بـ $\frac {m} {2} * \frac {n} {2}$ data مع قنوات $c$ (راجع الشكل 7).
التجميع ليس محددًا ؛ ومع ذلك، يمكننا اختيار أنواع مختلفة من الاقتراع مثل التجميع الأقصى ومتوسط ​​التجميع وما إلى ذلك. الغرض الرئيسي من التجميع يقلل من كمية البيانات حتى نتمكن من الحساب في فترة زمنية معقولة.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7:</b> Pooling results </center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b> الشكل 7: </b> تجميع النتائج </center>

<!--
## CNN - Jupyter Notebook
-->

## الشبكات الاتفافية - Jupyter Notebook

<!--The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->

يمكن العثور على Jupyter Notebook [هنا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). لتشغيل Jupyter Notebook، تأكد من تثبيت بيئة `pDL` على النحو المحدد في [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md) .

<!--In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)
-->

في هذا الكمبيوتر الدفتري، نقوم بتدريب شبكة متعدد الطبقات (شبكة FC) وشبكة عصبية التفافية (CNN) لمهمة التصنيف في مجموعة بيانات MNIST. لاحظ أن كلا الشبكتين لهما عدد متساوٍ من المعلمات. (الشكل 8)

<!--<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8:</b> Instances from the Original MNIST Dataset </center>
-->

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b> الشكل 8: </b> مثيلات من مجموعة بيانات MNIST الأصلية </center>

<!--Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:
-->

قبل بدأ عملية التعليم، نقوم بتطبيع بياناتنا بحيث تتناسب تهيئة الشبكة مع توزيع البيانات لدينا (مهم جدًا!). تأكد أيضًا من أن العمليات / الخطوات الخمس التالية موجودة في عملية التعليم:

<!-- 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method
-->

1. تغذية البيانات إلى المعمارية
 2. حساب دالة الفرق
 3. تنظيف ذاكرة التخزين المؤقت للتدرجات المتراكمة بـ `zero_grad ()`
2. حساب التدرجات
 4. تنفيذ خطوة في طريقة المحسن

<!--First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.
-->

أولاً، نقوم بتدريب كلتا الشبكتين على بيانات MNIST الطبيعية. تبين أن دقة شبكة FC بلغت $87\%$ بينما تبين أن دقة شبكة CNN بلغت $95\%$. نظرًا لنفس العدد من المعلمات، تمكنت CNN من تدريب العديد من المرشحات. في شبكة FC، يتم تدريب المرشحات التي تحاول الحصول على بعض التبعيات بين الأشياء البعيدة عن الأشياء القريبة. لقد ضاعوا تماما. بدلاً من ذلك، في الشبكة التلافيفية، تركز كل هذه المعلمات على العلاقة بين وحدات البكسل المجاورة.

<!--Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.
-->

بعد ذلك، نقوم بإجراء تبديل عشوائي لجميع وحدات البكسل في جميع صور مجموعة بيانات MNIST الخاصة بنا. هذا يحول الشكل 8 لدينا إلى الشكل 9. ثم نقوم بتدريب كلتا الشبكتين على مجموعة البيانات المعدلة هذه.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9:</b> Instances from Permuted MNIST Dataset</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b> الشكل 9: </ b> مثيلات من مجموعة بيانات MNIST المتغيرة </center>

<!--The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->

ظل أداء شبكة FC دون تغيير تقريبًا ($85\%$)، لكن دقة CNN انخفضت إلى $83\%$. هذا لأنه، بعد التقليب العشوائي، لم تعد الصور تحمل الخصائص الثلاثة للموقع، والثبات، والتكوين، التي يمكن لشبكة CNN استغلالها.


