---
lang-ref: ch.03-2
lang: ar
lecturer: Yann LeCun
title: .الشبكات الالتفافية تطورها, معماريتها, تفاصيل التطبيق البرمجي ومميزاتها
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translation-date: 20 Aug 2020
translator: Mohamed Adel Musallam
---

<!--
## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)
-->
# [النماذج الأولية للشبكات الالتفافية وتطورها](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)


<!--
### Proto-convolutional neural nets on small data sets
-->
## تطبيق الشبكات العصبية البدائية على مجموعات  من البيانات الصغيرة
<!--Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:
-->
طورت أول طُورت أول CNN والمستوحاة من عمل البرفيسور فوكوشيما في نمذجة القشرة البصرية، وباستخدام تركيب هرمي  من الوحدات العصبية الصناعية البسيطة و المعقدة، جنبًا إلى جنب مع التدريب الخاضع للإشراف و خوارزمية الانتشار العكسي في جامعة تورنتو ما بين عامي 1988-1989 بواسطة البروفيسور Yann LeCun. استخدمت التجارب مجموعة بيانات صغيرة من 320 رقمًا.

تمت مقارنة أداء البنى التالية:-

<!--1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps)
-->

1. طبقة  واحدة تامة الاتصال

2. طبقتان متصلتان

3. طبقات متصلة محليًا بدون أوزان مشتركة

4. شبكة مقيدة مع أوزان مشتركة واتصالات محلية

5. شبكة مقيدة مع أوزان مشتركة واتصالات محلية 2 (بالمزيد من نماذج الخصائص)

<!--The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit.
-->
تتمتع أكثر الشبكات نجاحاً (الشبكة المقيدة ذات الأوزان المشتركة) بأقوى قابلية للتعميم وتشكل الأساس للـ CNN الحديثة، بينما تميل الطبقة تامة الاتصال إلى فرط التخصيص.

<!--
### First "real" ConvNets at Bell Labs
-->
###   أول ConvNets "حقيقية" في Bell Labs

<!--After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:
-->

بعد إنتقاله إلى Bell Labs، تحول عمل LeCunn إلى استخدام الرموز البريدية المكتوبة بخط اليد عن طريق خدمة البريد الأمريكية لتدريب CNN أكبر:

<!--* 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling
-->

*  طبقة مدخلات بسعة 256 تسمح لصورة بحجم (16$\times$16).
*  12 (5$\times$5) مرشح  بخطوة انتقالية مقدارها 2 بيكسل , لتقليل دقة الطبقة اللاحقة.
*  **لم** يتم استخدام أي نوع من انواع التجميع (pooling).

<!--
### Convolutional network architecture with pooling
-->
###   معمارية الشبكات الالتفافية مع التجميع

<!--The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half.
-->
في العام التالي، تم إجراء بعض التغييرات على معمارية الشبكات الالتفافية: منها تقديم التجميع المنفصل. حيث يتم تجميع قيم المدخلات عن طريق حساب متوسط ​​قيم الإدخال وإضافة قيمة معامل الانحياز، وتمريرهم إلى دالة غير خطية (دالة الظل المماسية). عملية التجميع تتم على مساحة (2$\times$2) بخطوة انتقالية مقدارها 2 بيكسل، وبالتالي تقليل دقة الصورة المدخلة بمقدار النصف.


<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>شكل 1. </b> معمارية الشبكات الالتفافية
</center>

<!--An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels
-->

مثال على طبقة واحدة من الشبكات الالتفافية سيكون كما يلي:

1. خذ مُدخلاً بحجم *32$\times$32*
2. تقوم الطبقة الالتفافية بتمرير مرشح بحجم 5$\times$5 مع خطوة إنتقالية مقدارها 1 بيكسل على مساحة الصورة، ينتج عنها ربط الخصائص مقداره *28$\times$28*.
3.  مرر نموذج ربط الخصائص إلى دالة غير خطية: حجمها *28$\times$28*.
4.  مرره إلى طبقة التجميع، حيث تقوم بحساب المتوسط على مساحة 2$\times$2 بخطوة إنتقالية مقدارها 2 بيكسل: حجمه *14$\times$14*.
5.  يتم تكرار الخطوات السابقة من 1 إلى 4 لـ 4 مرشحات.


<!--The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map:
-->
المرحلة الاولى، مكونة من طبقة (التفافية وتجميعية) عادة تقوم باكتشاف الخصائص البسطية في الصورة المدخلة، مثل التعرف على الحواف والحدود للأشكال الموجودة في الصورة.
بعد المرحلة الاولى يكون الهدف هو التعرف على مجوعة اكثر تعقيدا من خصائص الصورة، عن طريق تجميع الخصائص البسيطة التي تم اكتشافها في المرحلة السابقة.
للتمكن من تحقيق ذلك يتم تكرار الخطوات من 2 إلى 4 بمرشحات مختلفة، بتمريرها على نماذج ربط الخصائص الناتجة من المرحلة السابقة يتم تجميع الناتج كنموذج تنشيط جديد.

<!--1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map
-->
1. يتم تمرير مرشح جديد بحجم 5$\times$5 على جميع نماذج ربط الخصائص السابقة مع تجميع الناتج (لاحظ ان البرفيسور LeCun  في تجاربه السابقة التي اجراها في عام 1989 الطبقات لم تكن تامة الاتصال لاسباب لها علاقة بالقدرة الحاسوبية المتوفرة في هذا الوقت، لكن في الوقت الحالي يتم تأكيد الاتصال بين الطبقات ) يكون الناتج مقداره *10$\times$10*.
2. مرر الناتج من الطبقة الالتفافية لدالة غير خطية يكون الناتج مقداره *10$\times$10*.
3. اعد تكرار الخطوة 1/2 مع 16 مرشح.
4. مرر الناتج لطبقة التجميع لتقوم بحساب متوسط القيم على مساحة 2$\times$2 بخطوة انتقالية مقدارها 2، ليكون الناتج بعد هذه العملية مقداره *5$\times$5* لكل  نموذج ربط خصائص.

<!--To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional.
-->
   لإنتاج المخرجات، يتم تنفيذ الطبقة الأخيرة من  عملية الالتفاف، والتي تبدو وكأنها وصلات كاملة ولكنها في الواقع التفافية.

<!-- 1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel) -->
1. يتم تمرير مرشح جديد بحجم 5$\times$5 على جميع نماذج ربط الخصائص السابقة مع تجميع الناتج  يكون الناتج مقداره *1$\times$1*.
2. مرر الناتج من الطبقة الالتفافية لدالة غير خطية يكون الناتج مقداره *1$\times$1*.
3.  يتم إنتاج قيمة خارج واحد لكل فئة.
4.  تعاد جميع الخطوات السابقة لكل فئة من فئات الخارج على التوازي.

<!--See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).
-->

شاهد [هذه الرسوم المتحركة](http://cs231n.github.io/convolutional-networks/)  على موقع Andrej Karpathy على الويب للتعرف على كيفية تغيير الطبقة الالتفافية  لشكل نماذج ربط الخصائص للطبقة التالية. يمكن العثور على الورقة الكاملة [هنا](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).

<!--
### Shift equivariance
-->
## الإزاحة متساوية التغير

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>شكل 2.</b>  الإزاحة متساوية التغير
</center>

<!--As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. *E.g.* the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, *i.e.* making the representation more abstract and less sensitive to shifts and distortions.
-->
كما هو موضح من خلال الرسوم المتحركة على الشرائح (إليك مثال آخر)، فإن إزاحة الصورة المدخلة ينتج عنها نفس الإزاحة لنماذج الخصائص. ومع ذلك، يتم قياس التغييرات في نماذج الخصائص من خلال عمليات الالتفاف / التجميع. *على سبيل المثال* تجميع 2$\times$2  مع خطوة انتقالية  2 سيقلل إزاحة 1 بكسل في طبقة الإدخال إلى 0.5 بكسل إزاحة في نماذج الخصائص التالية. يتم بعد ذلك استبدال الدقة المكانية لزيادة عدد أنواع الخصائص،  أي جعل التمثيل أكثر تجريدًا وأقل حساسية للتحولات والتشوهات.

<!--
### Overall architecture breakdown

Generic CNN architecture can be broken down into several basic layer archetypes:
-->

## تحليل إجمالي للمعمارية

يمكن تحليل المعمارية العامة للـ CNN لمجموعة من الطبقات الاساسية كما يلي:

<!-- **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods *e.g.* average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation
 -->

* **التسوية المعيارية**
  * ضبط التبييض الإحصائي (اختياري)
  * الطرق الطرحية *على سبيل المثال* إزالة المتوسط، ترشيح للترددات العالية
  *  الطرق التَقسِيمِيّة: تطبيع أو تسوية التَبايُنٌ المحلي، تسوية التفاوت

<!-- **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections
  -->

* **حزمة الترشيح**
  * زيادة الابعاد
  * الإسقاط على أساس عياري متعامد
  * التعرف على الحواف وحدود الاشكال في الصور

<!--  **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$
  -->
* **الدوال اللاخطية**
  *  التنثير (تحويل القيم إلى مصفوفة متناثرة)
  *   وحدة خطية مصححة نموذجية (ReLU): $\text{ReLU}(x) = \max(x, 0)$


<!-- **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$
  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$
  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$
 -->
* **التجميع**
  *  تجميع نماذج الخصائص
  *  تجميع القيم الاعلى  <center> $\text{MAX}= \text{Max}_i(X_i)$  </center>
  *  تجميع على الفضاء المعياري LP-Norm  <center>  $\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$  </center>
  * التجميع اللوغاريثمي  <center>  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$  </center>

<!--
## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)
-->

## [   التعرف على الأرقام باستخدام  LeNet5 ](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)

<!--
### Implementation of LeNet5 in PyTorch
-->

## تطبيق برمجي لمعمارية LeNet5 باستخدام Pytorch

<!-- LeNet5 consists of the following layers (1 being the top-most layer):
-->

تتكون معمارية LeNet5 من الطبقات التالية بداية من اعلى إلى اسفل :-

<!--
1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
 -->

1. Log-Softmax
2. طبقة واحدة تامة الاتصال ابعادها 500$\times$10.
3. ReLu
4. طبقة واحدة تامة الاتصال ابعادها (4$\times$4$\times$50)$\times$500
5. طبقة تجميع القيم الاعلى بحجم 2$\times$2 مع خطوة انتقالية مقدارها 2 بيكسل.
6. ReLu
7. طبقة التفافية بقيمة خارج 20  قناة، مرشح 5$\times$5 مع خطوة انتقالية مقدارها 1 بيكسل.
8. طبقة تجميع القيم الاعلى بحجم 2$\times$2 مع خطوة انتقالية مقدارها 2 بيكسل.
9.  ReLu
10. طبقة التفافية بقيمة خارج 20  قناة، مرشح 5$\times$5 مع خطوة انتقالية مقدارها 1 بيكسل.

<!--The input is a 32$\times$32 grey scale image (1 input channel).
-->

قيمة الدخل للمعمارية 32$\times$32 بيكسل  على رمادية تدرج الالوان وقناة واحدة.

<!--LeNet5 can be implemented in PyTorch with the following code:
-->

 تطبيق برمجي لمعمارية LeNet5 باستخدام Pytorch

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

<!--Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes.
-->

على الرغم من ان `fc1` و `fc2` طبقات تامة الاتصال، إلا ان يمكن اعتبارهم طبقة التفافية ذات مرشح يغطي الصورة باكملها. يتم استخدام طبقات تامة الاتصال لأسباب مرتبطة بالفاعلية.

<!--The same code can be expressed using `nn.Sequential`, but it is outdated.
-->

يمكن انتاج نفس المعمارية في Pytorch باستخدام  `nn.Sequential`.

<!-- ## Advantages of CNN -->

## ميزات الـ CNN

<!--In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output.
-->

في الشبكة الالتفافية الكاملة، ليست هناك حاجة لتحديد حجم المدخلات. ومع ذلك، فإن تغيير حجم الإدخال يغير حجم المخرجات.

<!--Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image.
-->

خذ بعين الاعتبار نظام التعرف على الكتابة بخط اليد. لا يتعين علينا تقسيم صورة الإدخال إلى شرائح. يمكننا تطبيق CNN على الصورة بأكملها: ستغطي المرشحات جميع المواقع في الصورة بأكملها وتسجيل نفس الإخراج بغض النظر عن مكان وجود النمط.
يعد تطبيق CNN على صورة كاملة أرخص بكثير من تطبيقه في مواقع متعددة بشكل منفصل. ليس هناك حاجة إلى تجزئة مسبقة، وهو أمر مريح لأن مهمة تجزئة الصورة مكلفة للغاية.

<!--
### Example: MNIST
-->

## مثال: MNIST
<!--LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre.
-->

تم تدريب LeNet5 على صور MNIST بحجم 32$\times$32  لتصنيف الأرقام المنفردة في وسط الصورة. تم تطبيق زيادة البيانات عن طريق إزاحة الرقم في اتجاهات مختلفة، وتغيير حجم الرقم، وإدخال الأرقام في الجانب. كما تم تدريبها بالفئة الحادية عشرة التي لم تمثل أيًا مما سبق.
تم إنشاء الصور التي تم تصنيفها بواسطة هذه الفئة إما عن طريق إنتاج صور فارغة، أو وضع أرقام على الجانب وليس المركز.


<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>شكل 3.</b> نافذة إزاحة التفافية
</center>

<!--
The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations.
-->

توضح الصورة أعلاه أن شبكة LeNet5 المدربة على  32$\times$32 يمكن تطبيقها على صورة  32$\times$64   للتعرف على الرقم في مواقع متعددة.

<!-- ## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s) -->

## [مشكلة ربط الخصائص](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

<!--
### What is the feature binding problem?
-->

### ما هي مشكلة ربط الخصائص؟

<!--Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object?
-->

يواجه علماء الرؤية الاعصاب البصرية ورؤية الكمبيوتر مشكلة تحديد الكائن ككائن. الكائن عبارة عن مجموعة من الخصائص، ولكن كيف يتم ربط جميع الخصائص لتشكيل هذا الكائن؟

<!-- ### How to solve it? -->

### كيف يمكن حل هذه المشكلة؟

<!--We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN.
-->

يمكننا حل مشكلة ربط الخصائص هذه باستخدام  بمعمارية CNN بسيط للغاية: طبقتان فقط من لالتفافية مع التجميعات بالإضافة إلى طبقتين آخرتين متصلتين بالكامل بدون أي آلية محددة لذلك، نظرًا لأن لدينا ما يكفي من البيانات ودول غير خطية لتدريب CNN الخاص بنا.


<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>شكل 4.</b>  حل مشكلة ربط الخصائص باستخدام شبكة التفافية
</center>

<!--The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, *i.e.* recognizing features in a hierarchical, compositional way.
-->

تُظهر الرسوم المتحركة أعلاه قدرة CNN على التعرف على الأرقام المختلفة عن طريق تحريك ضربة واحدة حولها، مما يدل على قدرتها على معالجة مشاكل ربط الخصائص، *أي* التعرف على الخصائص بطريقة هرمية وتركيبية.

<!--
### Example: dynamic input length
-->
### مثال: مدخلات متغيرة الابعاد

<!--We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output.
-->

يمكننا بناء CNN بطبقتين من الالتفافية بخطوة انتقالية مقدارها 1 بيكسل، مع طبقتين للتجميع مع خطوة انتقالية مقدارها  2  بيكسل بحيث تكون الخطوة الإجمالية 4. وبالتالي، إذا أردنا الحصول على مخرجات جديدة، فنحن بحاجة إلى إزاحة نافذة الإدخال بمقدار 4.  بشكل أكثر وضوحا، يمكننا أن نرى الشكل أدناه (الوحدات الخضراء). أولاً، لدينا إدخال بحجم 10،
ونقوم بإجراء التفاف  بمرشح بالحجم 3 للحصول على 8 وحدات. بعد ذلك، نقوم بتجميع الحجم 2 للحصول على 4 وحدات. وبالمثل، نكرر الالتفاف والتجميع مرة أخرى، وفي النهاية نحصل على ناتج واحد.

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>شكل 5.</b> معمارية شبكة التفافية بمدخلات متغيرة الابعاد
</center>

<!--Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2 Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs.-->

لنفترض أننا أضفنا 4 وحدات في طبقة الإدخال (الوحدات الوردية أعلاه)، حتى نتمكن من الحصول على 4 وحدات أخرى بعد طبقة الالتفاف الأولى، ووحدتين أخريين بعد طبقة التجميع الأولى، ووحدتين أخريين بعد طبقة الالتفاف الثانية، و 1 مخرج جديد.

 لذلك، حجم النافذة لإنشاء مخرجات جديدة هو 4 (خطوتان $\times$2)
 علاوة على ذلك، هذا دليل على حقيقة أننا إذا قمنا بزيادة حجم المدخلات، فسنزيد حجم كل طبقة، مما يثبت قدرة الـ CNN على التعامل مع مدخلات متغيرة الابعاد.


<!--
## What are CNN good for
-->

### فيما تفيد الشبكات الالتفافية؟

<!--CNNs are good for natural signals that come in the form of multidimensional arrays and have three major properties:
1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections.
2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image.
3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells.
-->

تعد الـ CNN جيدة للإشارات الطبيعية التي تأتي في شكل مصفوفات متعددة الأبعاد ولها ثلاث خصائص رئيسية:
1. **المحلية**: الميزة الاولى هو وجود ارتباط محلي قوي بين القيم. إذا أخذنا بكسلين قريبين من صورة طبيعية، فمن المحتمل جدًا أن يكون لتلك البكسلات نفس اللون. عندما تصبح وحدات البكسل متباعدة،
سيقل التشابه بينهما. يمكن أن تساعدنا الارتباطات المحلية في اكتشاف الميزات والخصائص المحلية، وهو ما تفعله الـ CNN. إذا قمنا بتغذية CNN بوحدات البكسل التي تم اعادة فرزها بعشوائية، فلن تعمل بشكل جيد في التعرف على الصور المدخلة، بينما لن تتأثرالشبكات تامة الاتصال FC. الارتباط المحلي يبرر الاتصالات المحلية.
2. **استقرار الاشارة**: الميزة الثانية هو أن الخصائص ضرورية ويمكن أن تظهر في أي مكان على الصورة، مما يبرر الأوزان المشتركة والتجميع. علاوة على ذلك، يتم توزيع الإشارات الإحصائية بشكل موحد، مما يعني أننا بحاجة إلى تكرار اكتشاف نفس الخاصية لكل موقع في صورة الإدخال.
3. **التراكبية**: الميزة الثالثة أن الصور الطبيعية تركيبية، بمعنى أن الخصائص تؤلف الصورة بطريقة هرمية. هذا يبرر استخدام طبقات متعددة من الخلايا العصبية، والتي تتوافق أيضًا بشكل وثيق مع أبحاث Hubel و Weisel حول الخلايا البسيطة والمعقدة

<!--Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition.
-->

علاوة على ذلك، يستفاد بشكل جيد من الـ CNN في مقاطع الفيديو والصور والنصوص والتعرف على الكلام.
