---
lang: ar
lang-ref: ch.03-1
lecturer: Yann LeCun
title: تصور عملية تحويل المعاملات للشبكات العصبية والمفاهيم الأساسية للالتفاف
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
typora-root-url: 03-1
translator: Haya Alsharif
translation-date: 4 Feb 2021
---


<!-- ## [Visualization of neural networks](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s) -->

## [تصور الشبكات العصبية](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

<!-- In this section we will visualise the inner workings of a neural network. -->

في هذا الجزء سوف نتخيل العملية الداخلية للشبكة العصبية.

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
شكل 1 هيكل الشبكة</center>

<!-- Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize. -->

يصور شكل 1 بنية الشبكة العصبية التي نرغب في تصورها. عادةً، عندما نرسم بنية الشبكة العصبية، يظهر الإدخال في الأسفل أو على اليسار، ويظهر الناتج في الجانب العلوي أو على اليمين. في الشكل 1، تمثل الخلايا العصبية باللون الوردي المدخلات، وتمثل الخلايا العصبية الزرقاء المخرجات. في هذه الشبكة، لدينا 4 طبقات مخفية (باللون الأخضر)، مما يعني أن لدينا 6 طبقات في المجموع (4 طبقات مخفية + طبقة إدخال واحدة + طبقة إخراج واحدة). في هذه الحالة، لدينا 2 من الخلايا العصبية لكل طبقة مخفية، وبالتالي فإن أبعاد مصفوفة الوزن ($W$) لكل طبقة هي 2 $\times$ 2. هذا لأننا نريد تحويل سطح أو مستوى الإدخال إلى مستوى آخر يمكننا تخيله.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
شكل 2 تصور المساحة القابلة للطي</center>

<!-- The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$. -->

تشبه عملية تحويل كل طبقة بطي السطح الخاص بنا في بعض المناطق المحددة كما هو موضح في الشكل 2. هذه الطيات حادة للغاية، وذلك لأن جميع التحويلات تتم في الطبقة ثنائية الأبعاد. في التجربة، وجدنا أنه إذا كان لدينا خليتان فقط في كل طبقة مخفية، فإن التحسين سيستغرق وقتًا أطول؛ يسهل التحسين إذا كان لدينا المزيد من الخلايا العصبية في الطبقات المخفية. هذا يتركنا مع سؤال مهم: لماذا يصعب تدريب الشبكة بعدد أقل من الخلايا العصبية في الطبقات المخفية؟ يجب أن تفكر في هذا السؤال بنفسك وسنعود إليه بعد تخيل $\texttt{ReLU}$.

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(أ)|(ب)|

<center>شكل 3 تصور عامل ReLU</center>

<!-- When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4. -->

عندما نعبر الشبكة بالمرور على طبقة مخفية واحدة في كل مرة، نرى أنه مع كل طبقة نقوم بنوع من التحويل التآلفي (affine transformation) متبوعًا بتطبيق عملية ReLU غير الخطية، والتي تتخلص من أي قيم سلبية. في الشكلين 3 (أ) و (ب) ، يمكننا أن نرى تصور عامل ReLU. يساعدنا عامل ReLU على القيام بتحولات غير خطية. بعد خطوات متعددة لإجراء تحويل تآلفي متبوعًا عامل ReLU، يمكننا في النهاية فصل البيانات خطيًا كما هو موضح في شكل 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
شكل 4 تصور المخرجات</center>

<!-- This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - *i.e.* adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned. -->

يوفر لنا ما ذكرناه بعض الأفكار حول سبب صعوبة تدريب الطبقات المخفية المكونة من خليتين عصبيتين فقط. تحتوي شبكتنا المكونة من 6 طبقات على تحيز واحد في كل طبقة مخفية. لذلك، إذا نقل أحد هذه التحيزات أي من النقاط إلى خارج الربع العلوي الأيمن، فإن تطبيق عامل ReLU سيقضي على هذه النقاط إلى الصفر. بعد ذلك، بغض النظر عن كيفية تحويل الطبقات للبيانات لاحقًا، ستبقى القيم لتلك النقاذ بصفر. يمكننا أن نجعل تدريب الشبكة العصبية أسهل عن طريق جعل الشبكة "أكثر بدانة" - *أي* إضافة المزيد من الخلايا العصبية في الطبقات المخفية - أو يمكننا إضافة المزيد من الطبقات المخفية، أو مزيج من الطريقتين. خلال هذه الدورة التدريبية، سوف نستكشف كيفية تحديد أفضل بنية شبكة لمشكلة معينة، ترقبوا ذلك. 

<!-- ## [Parameter transformations](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s) -->

## [تحويل المعاملات](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

<!-- General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows, -->

معنى تحويل المعاملات أن متجه المعاملات $w$ هو ناتج لدالة. من خلال هذا التحويل، يمكننا تعيين فضاء المعاملات الأصلية إلى فضاء آخر. في الشكل 5، $w$ هو ناتج $H$ بالمعامل $u$.  $G(x,w)$ هي عبارة عن شبكة و $C(y,\bar y)$ هي دالة تكلفة. تتكيف أيضًا صياغة الانتشار الخلفي على النحو التالي،

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

<!-- These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent. -->

يتم تطبيق هذه الصيغ على شكل مصفوفة. لاحظ أن أبعاد العناصر يجب أن تكون متسقة. أبعاد $u$، $w$، $\frac{\partial H}{\partial u}^\top$، $\frac{\partial C}{\partial w}^\top$، تساوي $[N_u \times 1]$، $[N_w \times 1]$، $[N_u \times N_w]$، $[N_w \times 1]$، على التوالي. لذلك، أبعاد صيغة الانتشار الخلفي لدينا متسقة.

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
شكل 5 الشكل العام لتحويل المعاملات</center>

<!-- ### A simple parameter transformation: weight sharing -->
### تحويل بسيط للمعاملات: مشاركة الأوزان

<!-- A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as, -->

تحويل مشاركة الأوزان يعني أن $H(u)$ تنسخ عنصرًا واحدًا من $u$ إلى عناصر متعددة لـ $w$. تشبه $H(u)$ فرع **Y** لنسخ $u_1$ إلى $w_2$، $w_1$. يمكن التعبير عن هذا على النحو التالي،

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

<!-- We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$. -->

نفرض على المعاملات المشتركة بأن تكون متساوية، لذا فإن التدرج بالنسبة إلى المعاملات المشتركة سيتم جمعها في الانتشار الخلفي. على سبيل المثال، التدرج لدالة التكلفة $C(y, \bar y)$ بالنسبة إلى $u_1$ سيكون مجموع تدرج دالة التكلفة $C(y, \bar y)$ بالنسبة لـ $w_1$ وتدرج دالة التكلفة $C(y, \bar y)$ بالنسبة لـ $w_2$.

<!-- ### Hypernetwork -->
### الشبكة الفائقة

<!-- A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful. -->

الشبكة الفائقة هي شبكة يكون فيها وزن إحدى الشبكات هو ناتج شبكة أخرى. يوضح شكل 6 الرسم البياني لحساب "الشبكة الفائقة". هنا الدالة $H$ عبارة عن شبكة ذات متجه معامل $u$ وإدخال $x$. نتيجة لذلك، يتم تكوين أوزان $G(x,w)$ ديناميكيًا بواسطة الشبكة $H(x,u)$. على الرغم من أن هذه فكرة قديمة، إلا أنها تظل قوية للغاية.

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
شكل 6 الشبكات الفائقة</center>


<!-- ### Motif detection in sequential data -->
### اكتشاف العناصر الرئيسية في البيانات المتسلسلة

<!-- Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (*i.e.* a particular sound in speech signal), and the outputs (*i.e.* a score) goes into a maximum function. -->

يمكن تطبيق تحويل مشاركة الوزن لاكتشاف العناصر الرئيسية في البيانات (motif detection). يعني اكتشاف العناصر الرئيسية العثور على بعض الأشكال في البيانات المتسلسلة مثل الكلمات الرئيسية في الكلام أو النص. تتمثل إحدى طرق تحقيق ذلك، كما هو موضح في شكل 7، في استخدام نافذة منزلقة على البيانات، والتي تنقل وظيفة مشاركة الوزن لاكتشاف فكرة معينة (*أي* صوت معين في إشارة الكلام) ، ويتم توجيه المخرجات (*أي* النتيجة) إلى دالة قصوى.

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
شكل 7 اكتشاف العناصر الرئيسية في البيانات المتسلسلة</center>

<!-- In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient. -->

في هذا المثال لدينا 5 من هذه الدوال. كنتيجة لهذا الحل، نلخص خمسة تدرجات ونعيد نشر الخطأ لتحديث المعامل $w$. عند تنفيذ هذا في PyTorch، يجب أن نمنع التراكم الضمني لهذه التدرجات، لذلك نحتاج إلى استخدام `zero_grad()` لتهيئة التدرج.

<!-- ### Motif detection in images -->
### اكتشاف العناصر الرئيسية في الصور

<!-- The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C". -->

التطبيق المفيد الآخر هو اكتشاف العناصر الرئيسية في الصور. عادةً ما نقوم بتمرير "القوالب" الخاصة بنا فوق الصور لاكتشاف الأشكال المستقلة عن الموقع وتشوه الأشكال. مثال بسيط هو التمييز بين "C" و"D" ، كما هو موضح في شكل 8. الفرق بين "C" و "D" هو أن "C" لها نقطتا نهاية و"D" لها ركنان. إذًا، يمكننا تصميم "قوالب نقطة النهاية" و "قوالب الزاوية". إذا كان الشكل مشابهًا لـ "القوالب" ، فسيكون له مخرجات قيمتها تتجاوز الحد الأدنى. ثم يمكننا تمييز الحروف من هذه المخرجات عن طريق جمعها. في شكل 8، تكتشف الشبكة نقطتي نهاية، ولا ترى أي زوايا، لذلك تقوم بتنشيط "C".

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
شكل 8 الكشف عن العناصر الرئيسية في الصور</center>

<!-- It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (*i.e.* the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection. -->

من المهم أيضًا أن تكون "عملية مطابقة القالب" الخاصة بنا لا تتأثر بالتحول - عندما نزيح المدخلات، يجب ألا يتغير الناتج (*أي* الحرف المكتشف). يمكن حل هذا من خلال تحويل مشاركة الأوزان. كما يوضح شكل 9، عندما نغير موقع "D"، لا يزال بإمكاننا اكتشاف أشكال الزوايا حتى وإن تم إزاحتها. عندما بجمع العناصر الرئيسية (motifs)، سيتم تنشيط اكتشاف "D".

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
شكل 9 مقاومة الإزاحة</center>

<!-- This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates". -->

تم استخدام هذه الطريقة المصنوعة يدويًا لاستخدام أجهزة الكشف المحلية والتجميع للتعرف على الأرقام لسنوات عديدة. لكنها تمثل لنا المشكلة التالية: كيف يمكننا تصميم هذه "القوالب" تلقائيًا؟ هل يمكننا استخدام الشبكات العصبية لتعلم هذه "القوالب"؟ بعد ذلك ، سوف نقدم مفهوم **الالتفافات** ، أي العملية التي نستخدمها لمطابقة الصور مع "القوالب".

<!-- ## Discrete convolution -->
## الالتفاف المتقطعة

<!-- ### Convolution -->
### الالتفاف

<!-- The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is: -->

التعريف الرياضي الدقيق للالتفاف في الحالة أحادية البعد بين المدخلات $x$ و $w$ هو:

$$y_i = \sum_j w_j x_{i-j}$$

<!-- In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted. -->

كلاميًا، يُحسب العنصر رقم $i$ من المخرجات كحاصل الضرب النقطي بين **معكوس** $w$ ونافذة من نفس الحجم في $x$. لحساب الناتج كاملًا، ابدأ بالنافذة من البداية، وانقل هذه النافذة بمقدار عنصر واحد في كل مرة وكرر العملية حتى يتم استنفاد $x$.

<!-- ### Cross-correlation -->
### الارتباط المتبادل

من الناحية العملية، تختلف المنهجية المعتمدة في أطر التعلم العميق مثل PyTorch قليلاً. يتم تنفيذ الالتفاف في PyTorch حيث **لا يتم عكس**  $w$:

$$y_i = \sum_j w_j x_{i+j}$$

<!-- Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.

Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts. -->

يطلق علماء الرياضيات على هذه الصيغة اسم "الارتباط المتبادل". في سياقنا، هذا الاختلاف هو مجرد اختلاف في الاصطلاح. عمليًا، يمكن أن يكون استخدام أي من مصطلحي الارتباط المتبادل أو التفاف إذا قرأ المرء الأوزان المخزنة في الذاكرة من الأمام أو الخلف.

إن إدراك هذا الاختلاف مهم، على سبيل المثال، عندما يرغب المرء في الاستفادة من بعض الخصائص الرياضية للالتفاف/الارتباط من النصوص الرياضية.

<!-- ### Higher dimensional convolution -->
### التفاف الأبعاد الأعلى

<!-- For two dimensional inputs such as images, we make use of the two dimensional version of convolution: -->

بالنسبة لمدخلات ثنائية الأبعاد مثل الصور، فإننا نستخدم النسخة ثنائية الأبعاد من الالتفاف:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

<!-- This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel* -->

يمكن توسيع هذا التعريف بسهولة إلى ما بعد البعدين إلى ثلاثة أو أربعة أبعاد. هنا $w$ يسمى *نواة الالتفاف*

<!-- ### Regular twists that can be made with the convolutional operator in DCNNs -->
### التقلبات المنتظمة التي يمكن إجراؤها باستخدام العامل التلافيفي في الـ DCNN

<!-- 1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below: -->
1. **توسيع الخطوات**: بدلاً من إزاحة النافذة على $x$ بمقدار عنصر واحد كل مرة، يمكن للمرء القيام بذلك بخطوة أكبر (على سبيل المثال، إدخالان أو ثلاثة إدخالات في المرة الواحدة).
مثال: لنفترض أن المدخل $x$  ذو بعد واحد وله حجم 100، أما $w$ فلها حجم 5. حجم المخرجات بخطوة بمقدار 1 أو 2 موضحة في الجدول أدناه:

<!-- | Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ | -->

| الخطوة       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| حجم المخرجات: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |

<!-- 2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable. -->

2. **الحشو**: في كثير من الأحيان عند تصميم بنى الشبكات العصبية العميقة، نريد أن يكون ناتج الالتفاف بنفس حجم المدخلات. يمكن تحقيق ذلك عن طريق حشو نهايات المدخلات (عادةً) بأصفار، على كلا الجانبين عادةً. يتم إجراء الحشو في الغالب للتسهيل. يمكن أن يؤثر في بعض الأحيان على الأداء وينتج عنه تأثيرات حدودية غريبة، ومع ذلك، عند استخدام ReLU غير الخطية، فإن الحشو الصفري ليس بذاك السوء.

<!-- ## Deep Convolution Neural Networks (DCNNs) -->
## الشبكات العصبية الالتفافية العميقة (DCNNs)

<!-- As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.

The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties. -->
<!-- NOTE: There is a missing word -->

كما وصفنا سابقًا، عادةً ما يتم تنظيم الشبكات العصبية العميقة كتناوب متكرر ما بين العوامل الخطية والطبقات اللاخطية النقطية. في الشبكات العصبية الالتفافية، سيكون العامل الخطي هو عامل الالتفاف الموصوف أعلاه. يوجد أيضًا نوع ثالث اختياري من الطبقات يسمى طبقة التجميع (pooling layer).

السبب في تكديس العديد من هذه الطبقات هو أننا نريد بناء تمثيل هرمي للبيانات. لا يجب أن تقتصر شبكات CNN على معالجة الصور، فقد تم تطبيقها بنجاح على الكلام واللغة. من الناحية الفنية، يمكن تطبيقها على أي نوع من البيانات التي تأتي في شكل مصفوفات، طالما أنها تحقق خصائص معينة.

<!-- Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world. -->

لماذا نريد التقاط التمثيل الهرمي للعالم؟ لأن العالم الذي نعيش فيه مركب. تمت الإشارة إلى هذه النقطة في الأقسام السابقة. يمكن ملاحظة هذه الطبيعة الهرمية من حقيقة أن البيكسلات المحلية تتجمع لتشكيل أشكال بسيطة مثل الحواف الموجهة. يتم تجميع هذه الحواف بدورها لتشكيل سمات محلية مثل الزوايا والوصلات على شكل حرف T وما إلى ذلك. يتم تجميع هذه الحواف لتشكيل أشكال أكثر تجريدًا. يمكننا الاستمرار في البناء على هذا التمثيل الهرمي نهايةً لتشكيل الأشياء التي نلاحظها في العالم الحقيقي.

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
شكل 10 تصور ميزة الشبكة الالتفافية المدربة على ImageNet من [Zeiler & Fergus 2013]
</center>
<!-- NOTE: There is a missing hyperlink. -->

<!-- This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.

The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in: -->

إن هذه الطبيعة الهرمية التركيبية التي نلاحظها في العالم الطبيعي ليست نتيجة إدراكنا البصري فحسب، بل هي أيضًا حقيقية على المستوى المادي. في أدنى مستوى من الوصف، لدينا جسيمات أولية، تتجمع لتكوين ذرات، وتشكل الذرات معًا جزيئات، ونستمر في البناء على هذه العملية لتشكيل المواد، وأجزاء من الكائنات، وفي النهاية كائنات كاملة في العالم المادي.

قد تكون الطبيعة التركيبية للعالم هي الإجابة على سؤال أينشتاين البلاغي حول كيفية فهم البشر للعالم الذي يعيشون فيه:

<!-- > The most incomprehensible thing about the universe is that it is comprehensible.

The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:

> The world is compositional or God exists. -->

> أكثر ما لا يمكن فهمه في الكون هو أنه يمكن فهمه.

حقيقة أن البشر يفهمون العالم بفضل هذه الطبيعة التركيبية لا تزال تبدو وكأنها مؤامرة بالنسبة لـ Yann. ومع ذلك، يقال إنه بدون التكوين، سوف يتطلب الأمر المزيد من السحر حتى يفهم البشر العالم الذي يعيشون فيه. نقلاً عن عالم الرياضيات العظيم ستيوارت جيمان:

> العالم مؤلف أو الله موجود.

<!-- ## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s) -->
## [إلهام من علم الأحياء](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

<!-- So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next: -->

إذًا، لماذا يجب أن يتأصل التعلم العميق في فكرة أن عالمنا مفهوم وله طبيعة تركيبية؟ ساعد البحث الذي أجراه Simon Thorpe في تحفيز هذا الأمر بشكل أكبر. أظهر أن الطريقة التي نتعرف بها على الأشياء اليومية سريعة للغاية. تضمنت تجاربه وميض مجموعة من الصور كل 100 مللي ثانية، ثم يطلب من المستخدمين تحديد هذه الصور، وهو ما تمكنوا من القيام به بنجاح. أظهر هذا أن الأمر يستغرق حوالي 100 مللي ثانية بالنسبة للبشر لاكتشاف الأشياء. علاوة على ذلك، ضع في اعتبارك الرسم التخطيطي أدناه، والذي يوضح أجزاء من الدماغ مشروحة بالوقت الذي تستغرقه الخلايا العصبية للانتشار من منطقة إلى أخرى:

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">شكل 11 نموذج سايمون ثورب لتدفق المعلومات المرئية في الدماغ <div>

<!-- Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.

Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process. -->

تنتقل الإشارات من شبكية العين إلى الـ LGN (تساعد في تحسين التباين، والتحكم في البوابة، وما إلى ذلك) ، ثم إلى القشرة البصرية الأولية V1، وV2، وV4، ثم إلى القشرة الباطنية الصدغية (PIT) ، وهي جزء من الدماغ حيث يتم تعريف الفئات أو الأصناف. أظهرت الملاحظات من جراحة الدماغ المفتوح أنه إذا عرضت فيلمًا على الإنسان، فإن الخلايا العصبية في الـ PIT ستطلق فقط عندما تكتشف صورًا معينة - مثل جينيفر أنيستون أو جدة شخص ما - ولا شيء آخر. الاشتعالات العصبية لا تتأثر بأمور كالموضع والحجم والإضاءة واتجاه جدتك وما ترتديه وما إلى ذلك.

علاوة على ذلك، فإن أوقات رد الفعل السريعة التي تمكن البشر من تصنيف هذه العناصر - وقت لا يكاد يسمح إلا بانتقال بضع إشارات - توضح أنه من الممكن القيام بذلك دون قضاء وقت إضافي في العمليات الحسابية المتكررة المعقدة. بدلا من ذلك، هذه عملية تغذية أمامية واحدة.

<!-- These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.

One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways: -->

تقترح هذه الأفكار أنه يمكننا تطوير بنية شبكة عصبية تكون متطورة تمامًا، ومع ذلك لا تزال قادرة على حل مشكلة التعرف، بطريقة لا تتأثر بالتحولات التي لا علاقة لها بالمدخلات.

هناك منطور أخرى للدماغ البشري من Gallant وVan Essen، اللذين يوضح نموذجهما للدماغ البشري مسارين متميزين:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">شكل 12 نموذج Gallen وVan Essen للممرات الظهرية والبطنية في الدماغ <div>

<!-- The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course). -->

يُظهر الجانب الأيمن المسار البطني، الذي يخبرك بما تنظر إليه، بينما يُظهر الجانب الأيسر المسار الظهري، والذي يحدد المواقع والهندسة والحركة. يبدو أنها منفصلة إلى حد ما عند الإنسان (والثديات) في القشرة البصرية (مع وجود بعض التفاعلات بينهما بالطبع).

<!-- ### Hubel & Weisel's contributions (1962) -->
### مساهمات Hubel و Weisel (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">شكل 13 تجارب Hubel و Wiesel مع المحفزات البصرية في أدمغة القطط<div>

<!-- Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.

They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions". -->

استخدمت تجارب Hubel و Weisel أقطابًا كهربائية لقياس الاشتعلات العصبية في أدمغة القطط استجابةً للمنبهات البصرية. اكتشفوا أن الخلايا العصبية في منطقة V1 حساسة فقط لمناطق معينة من المجال البصري (تسمى "المجالات المستقبلة")، وتكتشف الحواف الموجهة في تلك المنطقة. على سبيل المثال، أوضحوا أنه إذا عرضت على القط شريطًا رأسيًا وبدأت في تدويره، عند زاوية معينة سيتم تحفيز خلية عصبية. وبالمثل، عندما يتحرك الشريط بعيدًا عن تلك الزاوية، يتضاءل ذاك الاشتعال في تلك الخلية. أطلق Hubel و Weisel على هذه الخلايا العصبية الانتقائية للتنشيط  اسم "الخلايا البسيطة"، لقدرتها على اكتشاف السمات المحلية.

اكتشفوا أيضًا أنه إذا قمت بتحريك الشريط خارج المجال الاستقبالي، فإن تلك الخلية العصبية تتوقف عن الاشتعال تمامًا، ولكن خلية عصبية أخرى ستنطلق. هناك كواشف لخصائص محلية تتوافق مع جميع مناطق المجال البصري، ومن هنا جاءت فكرة أن الدماغ البشري يعالج المعلومات المرئية كمجموعة من "الالتفافات".

<!-- Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input. -->

نوع آخر من الخلايا العصبية، أطلقوا عليه اسم "الخلايا المعقدة"، يجمع ناتج خلايا بسيطة متعددة في منطقة معينة. يمكننا التفكير في تلك الخلايا على أنها تحسب إجمالي عمليات التنشيط باستخدام دوال مثل الحد الأقصى (maximum) أو المجموع (sum) أو مجموع المربعات (sum of squares) أو أي وظيفة أخرى لا تعتمد على الترتيب. تكتشف هذه الخلايا المعقدة الحواف والتوجهات في منطقة ما، بغض النظر عن مكان تواجد هذه المحفزات داخل المنطقة تحديدًا. بمعنى آخر، فهي مقاومة للإزاحة فيما بالنسبة للاختلافات الصغيرة في مواقع المدخلات.

<!-- ### Fukushima's contributions (1982) -->
### مساهمات فوكوشيما (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">شكل 14 نموذج فوكوشيما للـ CNN <div>

<!-- Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.

Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.) -->

كان فوكوشيما أول من طبق فكرة الطبقات المتعددة من الخلايا البسيطة والخلايا المعقدة بنماذج الكمبيوتر، باستخدام مجموعة بيانات من الأرقام المكتوبة بخط اليد. تم تصميم بعض أجهزة الكشف عن الميزات هذه يدويًا أو بالتعلم، على الرغم من أن التعلم استخدم خوارزميات تجميع بدون إشراف، تم تدريبها بشكل منفصل لكل طبقة، حيث لم يتم استخدام الانتشار الخلفي بعد.

جاء Yann LeCun بعد بضع سنوات (1989، 1998) ونفذ نفس الهيكل، لكن هذه المرة دربهم في بيئة خاضعة للإشراف باستخدام الانتشار الخلفي. يُنظر إلى هذا على نطاق واسع على أنه نشأة الشبكات العصبية الالتفافية الحديثة. (ملاحظة: في عام 1999 أعاد Riesenhuber من MIT اكتشاف هذه البنية أيضًا، ولكن لم يستخدم الانتشار الخلفي).