---
lang: ar
lang-ref: ch.02-3
title: الشبكات العصبية الاصطناعية (ANNs)
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
typora-root-url: 02-3
translation-date: 1 Feb 2021
translator: Haya Alsharif
---

<!--
## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)
-->

## [التعلم بالإشراف للتصنيف](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

<!--
* Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**.

* **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**.
-->

* لنأخذ في عين الاعتبار **الشكل 1 (أ)** أدناه. تقع النقاط في هذا الرسم البياني على فروع اللولب، في $\R^2$. يمثل كل لون تسمية لفئة أو فصيلة. عدد الفئات الفريدة هو $K = 3$. يتم تمثيل هذا رياضياً بواسطة **معادلة 1 (أ)**.

* **شكل 1 (ب)** يُظهر لولبًا مشابهًا، مع اضافة عنصر التشويش الغاوسي (Gaussian noise). يتم تمثيل هذا رياضياً بواسطة **معادلة 1 (ب)**.

  في كلتا الحالتين، لا يمكن فصل هذه النقاط خطيًا.

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>الشكل 1(أ)</b> لولب "نظيف" ثنائي الأبعاد
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>الشكل 1(ب)</b> لولب "مشوش" ثنائي الأبعاد
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>معادلة 1(أ)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>معادلة 1(ب)</b></center>

<!--
What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution!

**How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data.

**Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level.
-->

ماذا يعني القيام **بالتصنيف**؟ خذ بعين الاعتبار حالة **الانحدار اللوجستي**. إذا تم تطبيق الانحدار اللوجستي للتصنيف على هذه البيانات، فسيؤدي ذلك إلى إنشاء مجموعة من **المستويات الخطية** (حدود القرار) في محاولة لفصل البيانات إلى فئاتها. المشكلة في هذا الحل هي أنه في كل منطقة، هناك نقاط تنتمي إلى فئات متعددة. تتخطى فروع اللولب حدود القرار الخطي. هذا **ليس** حلاً رائعًا!

**كيف نصلح ذلك؟** نقوم بتحويل مساحة المدخلات بحيث يتم إجبار البيانات على الفصل خطيًا. خلال تدريب الشبكة العصبية، ستقوم حدود القرار التي تتعلمها الشبكة بالتكيف مع توزيع بيانات التدريب.

**ملاحظة:** يتم دائمًا تمثيل الشبكة العصبية من **أسفل إلى أعلى**. الطبقة الأولى في الأسفل والأخيرة في الأعلى. هذا لأنه من الناحية النظرية، تعد المدخلات بأنها ذات خصائص منخفضة المستوى لأي مهمة تقوم بها الشبكة العصبية. عندما تنتقل البيانات **لأعلى** عبر الشبكة، تستخرج كل طبقة لاحقة خصائصًا على مستوى أعلى.

<!--
## Training data
-->

## بيانات التدريب

<!--
Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network.

* $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$.
-->

في الأسبوع الماضي، رأينا أن الشبكة العصبية التي يتم تهيئتها حديثًا تحول مدخلاتها بطريقة عشوائية. ومع ذلك، فإن هذا التحول غير مفيد **(في البداية)** في أداء المهمة المرادة. سنكتشف كيف يمكننا باستخدام البيانات إجبار هذا التحول على الحصول على بعض المعاني ذات الصلة بالمهمة قيد البحث. فيما يلي، تجدون البيانات المستخدمة كمدخل لتدريب الشبكة.

* يمثل $\vect{X}$ بيانات المدخلات وهي مصفوفة بأبعاد $m$ (عدد نقاط بيانات التدريب) $times$ $n$ (أبعاد كل نقطة إدخال). في حالة البيانات الموضحة في الأشكال **1 (أ)** و **1 (ب)**، $n = 2$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>شكل 2</b> بيانات التدريب
</center>

<!--
* Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below).
-->

* يمثل كل من متجه $\vect{c}$ ومصفوفة $\boldsymbol{Y}$ مسميات فئة كل نقطة من نقاط البيانات $m$. في المثال أعلاه، هناك 3 فئات مختلفة.

   * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$، و $\vect{c} \in \R^m$. ومع ذلك، قد لا نستخدم $\vect{c}$ كبيانات تدريب. إذا استخدمنا مسميات رقمية للفئات المختلفة $c_i \in \lbrace 1, 2, \cdots, K \rbrace$، فقد تستنتج الشبكة ترتيبًا داخليًا للفئات لا علاقة له بتوزيع البيانات.
   * لتجاوز هذه المشكلة، نستخدم **ترميز فعال ذو بت واحد (one-hot encoding)**. لكل فئة $c_i$، يتم إنشاء متجه صفري ببعد $K$ والمعرف كـ $\vect{y}^{(i)}$، والذي يكون عنصره الـ $c_i$ مضبوطًا على $1$ (انظر **شكل 3** أدناه).

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>شكل 3</b> ترميز فعال ذو بت واحد (one-hot encoding)
</center>

<!--
* Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots.
-->

  * لذلك ، $\boldsymbol Y \in \R^{m \times K}$. يمكن أيضًا اعتبار هذه المصفوفة على أنها تحتوي على بعض الكتلة الاحتمالية، والتي تتركز بشكل كامل على إحدى نقاط $K$.

<!--
## Fully (FC) connected layers
-->

## الطبقات المتصلة بالكامل (FC)

<!--
We will now take a look at what a fully connected (FC) network is, and how it works.
-->

سنلقي الآن نظرة على ماهية الشبكة المتصلة بالكامل (FC) وكيفية عملها.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>شكل 4</b> شبكة عصبية متصلة بالكامل
</center>


<!-- Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $\boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, *i.e* one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}}$. This network can be represented mathematically by the equations in **Eqn. 2** below. $f$ and $g$ are both non-linearities. -->

لنأخذ بعين الاعتبار الشبكة الموضحة أعلاه في **الشكل 4**. تخضع المدخلات، $\boldsymbol x$، لتحويل تآلفي (affine transformation) معرف بواسطة $\boldsymbol W_h$، متبوعًا بتحويل غير خطي. يُشار إلى نتيجة هذا التحويل غير الخطي بـ $\boldsymbol h$، والتي تمثل ناتجًا **خفيًا** ، *أي* ناتج *غير مرئي* من خارج الشبكة. يتبع ذلك تحول تآلفي آخر ($\boldsymbol W_y$)، متبوعًا بتحويل غير خطي آخر. ينتج عن هذا الناتج النهائي $\boldsymbol{\hat{y}}$. يمكن تمثيل هذه الشبكة رياضياً بواسطة المعادلات في **معادلة 2** أدناه. $f$ و$g$ كلاهما غير خطيين.

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>معادلة 2</b> الرياضيات وراء شبكة FC</center>

<!-- A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax. -->

الشبكة العصبية الأساسية مثل الشبكة الموضحة أعلاه هي مجرد مجموعة من الأزواج المتتالية، حيث يكون كل زوج عبارة عن تحويل تآلفي متبوعًا بعملية غير خطية (عملية سحق). تتضمن الوظائف غير الخطية المستخدمة بشكل متكرر الآتي: ReLU ، السيني (sigmoid)، الظل الزائدي (hyperbolic tangent)، وsoftmax.

<!-- The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron

Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extended to a $n$-layer network.

Now let's move to a more complicated case.

Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5** -->

الشبكة الموضحة أعلاه عبارة عن شبكة ثلاثية الطبقات:

  1. مدخلات الخلايا العصبية
  2. الخلايا العصبية الخفية
  3. مخرجات الخلايا العصبية

لذلك، تحتوي الشبكة العصبية المكونة من $3$ طبقات على اثنين من التحولات التآلفية. يمكن أن يمتد هذا إلى شبكة لها $n$ من الطبقات.

الآن دعونا ننتقل إلى حالة أكثر تعقيدًا.

لندرس حالة مكونة من 3 طبقات خفية، ومتصلة بالكامل في كل طبقة. يمكن العثور على رسم توضيحي في **شكل 5**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>شكل 5</b> شبكة عصبية بثلاث طبقات مخفية
</center>

<!-- Let's consider a neuron $j$ in the second layer. It's activation is: -->

لنأخذ في عين الاعتبار خلية عصبية $j$ في الطبقة الثانية. التنشيط لها هو:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

<!-- where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$.

Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, *etc*.

The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post. -->

حيث $\vect{w}^{(j)}$ هو الصف رقم $j$ من $\vect{W}^{(1)}$.

لاحظ أن تنشيط طبقة المدخلات في هذه الحالة هو مجرد مصفوفة الوحدة. يمكن أن تحتوي الطبقات المخفية على عمليات تنشيط مثل ReLU، الظل الزائدي (hyperbolic tangent)، السيني (sigmoid)، soft (arg)max ، *إلخ*.

سيعتمد تنشيط الطبقة الأخيرة بشكل عام على التطبيق الخاص بك، كما هو موضح في [هذا](https://piazza.com/class/k5spqaanqk51ks?cid=36) المنشور على Piazza.


<!-- ## Neural network (inference) -->
## الشبكة العصبية (التنبؤ)

<!-- Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6** -->

دعنا نفكر في الشبكة العصبية ثلاثية الطبقات مرة أخرى (المدخلات والطبقة الخفية والمخرجات)، كما هو موضح في **الشكل 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>شكل 6</b> شبكة عصبية ثلاثية الطبقات
</center>

<!-- What kind of functions are we looking at? -->
ما نوع الوظائف التي نبحث عنها؟

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

<!-- However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as: -->

ومع ذلك، من المفيد تصور حقيقة وجود طبقة مخفية، ويمكن توسيع التعيين على النحو التالي:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<!-- What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$). -->

كيف يمكن أن يبدو نموذج التكوين للحالة أعلاه؟ في هذه الحالة، يكون لدى المرء مدخلات من البعد الثاني ($n=2$) ، ويمكن أن يكون للطبقة المخفية الفردية أبعاد بمقدار 1000 ($d = 1000$) ، ولدينا 3 فئات ($C=3$). هناك أسباب عملية جيدة لعدم وجود الكثير من الخلايا العصبية في طبقة مخفية واحدة ، لذلك قد يكون من المنطقي تقسيم الطبقة المخفية الواحدة إلى 3 طبقات تحتوي كل منها على 10 خلايا عصبية ($1000 \rightarrow 10 \times 10 \times 10$)

<!-- ## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s) -->

## [الشبكة العصبية (التدريب الأول)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

<!-- So what does typical training look like? It is helpful to formulate this into the standard terminology of losses.

First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm).

The soft (arg)max will give you logits in the last layer that look like this: -->

إذن كيف يبدو التدريب النموذجي؟ من المفيد صياغة ذلك باستخدام المصطلحات المتعارف عليها للخسائر.

أولاً، دعنا نعيد تقديم soft (arg)max ونشير صراحةً إلى أنها دالة تنشيط شائعة للطبقة الأخيرة، عند استخدام خسارة الأرجحية اللوغاريثمية السلبية (negative log-likelihood loss)، في حالات التنبؤ متعدد الفئات. كما ذكر البروفيسور لوكان (LeCun) في المحاضرة، هذا لأنك تحصل على تدرجات أفضل مما لو كنت تستخدم sigmoids وفقدان المربع (square loss). بالإضافة إلى ذلك، ستكون طبقتك الآخير قد سبق تسويها (مجموع كل الخلايا العصبية في الطبقة الأخيرة يساوي 1)، وهذا أفضل لطرق التدرج من التسوية الصريحة (بالقسمة على المعيار norm).

سوف يعطيك soft (arg)max عدد من الـ logits في الطبقة الأخيرة التي تبدو كما يلي:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

<!-- It is important to note that the set is not closed because of the strictly positive nature of the exponential function.

Given the set of the predictions $\matr{\hat{Y}}$, the loss will be: -->

من المهم ملاحظة أن المجموعة ليست مغلقة بسبب إيجابية الدالة الأسية.

بالنظر إلى مجموعة التوقعات $\matr{\hat{Y}}$، ستكون الخسارة:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

<!-- Here $c$ denotes the integer label, not the one hot encoding representation.

So let's do two examples, one where an example is correctly classified, and one where it is not.

Let's say -->

هنا يشير $c$ إلى تسمية العدد الصحيح، وليس تمثيلاً بالترميز ذو بت واحد.

لذلك دعونا نقوم بطرح مثالين، أحدهما يتم فيه تصنيف المثال بشكل صحيح، وأما الآخر فلا.

لنقول

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

<!-- What is the instance wise loss?

For the case of *nearly perfect prediction* ($\sim$ means *circa*): -->

ما هو مقدار الخسارة لكل مثال؟

في حالة *التنبؤ شبه المثالي* ($\sim$ يعني *حوالي*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

<!-- For the case of *nearly absolutely wrong*: -->

في حالة *التنبؤ الخاطئ تمامًا تقريبًا*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

<!-- Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think.

**Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice! -->

لاحظ في الأمثلة أعلاه، $\sim 0 \rightarrow 0^{+}$ و $\sim 1 \rightarrow 1^{-}$. لماذا هو كذلك؟ خذ دقيقة للتفكير.

**ملاحظة**: من المهم أن تعرف أنه إذا كنت تستخدم `CrossEntropyLoss`، فستحصل على `LogSoftMax` وأرجحية لوغاريثمية سلبية `NLLLoss` مجتمعة معًا، لذا لا تفعل ذلك مرتين!

<!-- ## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s) -->

## [الشبكة العصبية (التدريب الثاني)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

<!-- For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as: -->

للتدريب، نقوم بتجميع جميع المعاملات القابلة للتدريب - مصفوفات الأوزان والتحيزات - في مجموعة نسميها $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. هذا يسمح لنا بكتابة دالة الهدف أو الخسارة على النحو التالي:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

<!-- This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem.

A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$. -->

هذا يجعل الخسارة تعتمد على ناتج الشبكة $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$، لذا يمكننا تحويل هذا إلى مشكلة تحسين.

يمكن رؤية توضيح بسيط لكيفية عمل ذلك في **الشكل 7**، حيث $J(\vartheta)$، وهي الدالة التي نحتاج إلى تصغيرها، ولها فقط معامل عددي $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شكل 7</b> تحسين دالة الخسارة من خلال الانحدار التدرجي.
</center>

<!-- We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network.

In order to compute the necessary gradients, we have to use back-propagation -->

نختار نقطة تهيئة عشوائية $\vartheta_0$ - مع الخسارة المرتبطة بها $J(\vartheta_0)$. يمكننا حساب المشتقة عند تلك الننقطة $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. في تلك الحالة، يصبح ميل المشتقة موجبًا. لذلك نحن بحاجة إلى اتخاذ خطوة في اتجاه أقصى انحدار. في هذه الحالة الاتجاه هو $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

تُعرف الإعادة التكرارية لهذه العملية بالانحدار التدرجي. طرق التدرج هي الأدوات الأساسية لتدريب الشبكة العصبية.

من أجل حساب التدرجات اللازمة، علينا استخدام الانتشار الخلفي

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$


<!-- ## Spiral classification - Jupyter notebook -->
## التصنيف اللولبي - Jupyter مذكرة

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels -- in red, yellow and blue -- as can be seen in **Fig. 8**. -->

يمكن العثور على مذكرة Jupyter [هنا](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). لتشغيل المذكرة، تأكد من تثبيت بيئة `the dl-minicourse` كما هو موضح في [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

يمكن العثور على شرح لكيفية استخدام `torch.device()` في [ملاحظات الأسبوع الماضي](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

كما في السابق، سنعمل مع النقاط في $\mathbb{R}^2$ بثلاث تسميات لفئات مختلفة - باللون الأحمر والأصفر والأزرق - كما هو موضح في **شكل 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>شكل 8</b> بيانات التصنيف اللولبي.
</center>

<!-- `nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html).

Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing.

As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of $50\%$. -->

`nn.Sequential()` هو عبارة عن حاوية (container)، تمرر الوحدات إلى المُنشئ (constructor) بالترتيب الذي تم إضافتها إليها. مسمى `nn.linear()` هو تسمية غير مطابقة للوظيفة حيث أنه يسخدم لتطبيق تحويل **تآلفي (affine)** على البيانات الواردة: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. لمزيد من المعلومات، راجع [PyTorch وثائق](https://pytorch.org/docs/stable/nn.html).

تذكر أن التحول التآلفي يشمل خمسة تحولات: الدوران، والانعكاس، التحريك، التحجيم، والقص (shearing).

كما يمكن رؤيته في **شكل 9**، عند محاولة فصل البيانات اللولبية بحدود القرار الخطية - فقط باستخدام وحدات `nn.linear()`، دون وجود دوال لاخطية بينها - أفضل ما يمكننا تحقيقه هو دقة تصل إلى $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شكل 9</b> حدود القرار الخطية.
</center>

<!-- When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**. -->

عندما ننتقل من نموذج خطي إلى نموذج يحتوي على وحدتين من الـ `nn.linear()` ويتخللها `nn.ReLU()`، ترتفع الدقة إلى $95\%$. هذا لأن الحدود تصبح غير خطية وتتكيف بشكل أفضل مع الشكل اللولبي للبيانات، كما يمكن رؤيته في **شكل 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>شكل 10</b> حدود القرار غير الخطية.
</center>

<!-- An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression. -->

أحد الأمثلة على مشكلة الانحدار التي لا يمكن حلها بشكل صحيح باستخدام الانحدار الخطي، ولكن تُحل بسهولة باستخدام ذات بنية الشبكة العصبية يمكن إيجادها في هذه [المذكرة](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) و**شكل 11**، الذي يُظهر 10 شبكات مختلفة، حيث 5 منها لها دالة ربط `nn.ReLU()` و 5 لها `nn.Tanh()`. الدالة الأولى هي دالة خطية متعددة التعريف (piecewise)، في حين أن الدالة الثانية هي انحدار مستمر وسلس.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>شكل 11</b>: 10 شبكات عصبية مع تباينها وانحرافها المعياري.<br>
اليسار: خمسة شبكات <code>ReLU</code>.  اليمين: خمسة شبكات <code>tanh</code>.
</center>

<!-- The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" -- since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$. -->

يظهر الخطان الأصفر والأخضر الانحراف المعياري والتباين للشبكات. يعد استخدام هذه العناصر مفيدًا لشيء مشابه لـ "مجال الثقة" - لأن الدوال تعطي تنبؤًا واحدًا لكل ناتج. يسمح استخدام توقع تباين المجموعة بتقدير درجة عدم اليقين بذاك التنبؤ. يمكننا ملاحظة أهمية ذلك في **الشكل 12**، حيث نقوم نمدد تطبيق دوال القرار خارج فترة التدريب ونلاحظ أنها تميل نحو $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>شكل 12</b> شبكات عصبية، مع الانحراف المعياري والمتوسط، خارج فترة التدريب.<br>
اليسار: خمسة شبكات <code>ReLU</code>.  اليمين: خمسة شبكات <code>tanh</code>.
</center>

<!-- To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop:

1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

When training a NN, it is very likely that you need these 5 steps in the order they were presented. -->

لتدريب أي شبكة عصبية باستخدام PyTorch، تحتاج إلى 5 خطوات أساسية في حلقة التدريب:

1. `output = model(input)` هو الممر الأمامي للنموذج، والذي يأخذ المدخلات ويولد المخرجات.
2. `J = loss(output, target <or> label)` يأخذ ناتج النموذج ويحسب خسارة التدريب بالنسبة للهدف الحقيقي أو اسم الفئة.
3. `model.zero_grad()` يقوم بتنظيف حسابات التدرج، بحيث لا يتم تجميعها للمرور التالي.
4. `J.backward()` يقوم بالانتشار الخلفي والتراكم: فهو يحسب $\nabla_\texttt{x} J$ لكل متغير $\texttt{x}$ والذي حددناه بـ `requires_grad=True`. يتم تجميع السابق في تدرج كل متغير: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` يأخذ خطوة في انحدار التدرج: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

عند تدريب NN ، من المحتمل جدًا أنك بحاجة إلى هذه الخطوات الخمس بالترتيب الذي قُدمت به.
