---
lang-ref: ch.02-2
lang: ar
lecturer: Yann LeCun
title: حساب التدرجات لوحدات NN والحيل العملية للانتشار الخلفي
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
translation-date: 27 Jan 2021
translator: Haya Alsharif
---


<!--
## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)
-->

## [مثال ملموس على الانتشار الخلفي ومقدمة إلى وحدات الشبكة العصبية الأساسية](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)

<!--
### Example
-->

### مثال

<!--
We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is input into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e. the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.)
-->

في ما يلي، سننظر إلى مثال ملموس على الانتشار الخلفي بمساعدة بعض الرسومات البيانية. الوظيفة العشوائية $G(w)$ هي مدخل لدالة التكلفة $C$ ،والتي يمكن تمثيلها كرسم بياني (a graph). من خلال التلاعب بضرب المصفوفات الجاكوبية، يمكننا تحويل هذا الرسم البياني إلى الرسم البياني الذي سيحسب التدرجات في الاتجاه المعاكس. (لاحظ أن PyTorch و TensorFlow يقومان بذلك تلقائيًا للمستخدم، أي أن الرسم البياني الأمامي "معكوس" تلقائيًا لإنشاء الرسم البياني المشتق والذي يقوم بعملية الانتشار الخلفي للتدرج.)


<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="مخطط التدرج" style="zoom:40%;" /></center>

<!--
In this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that
-->

في هذا المثال، يمثل الرسم البياني الأخضر على اليمين مخطط التدرج. بتتبع الرسم البياني ابتداءً من أعلى عقدة، يتبع ذلك

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

<!--
In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.
-->

من حيث الأبعاد، $\frac{\partial C(y,\bar{y})}{\partial w}$ هو متجه صفي بحجم $1\times N$ حيث $N$ هو عدد عناصر $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$ هو متجه صفي بحجم $1\times M$, حيث $M$ هو عدد حجم المخرجات؛ $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ هي مصفوفة بحجم $M\times N$, حيث $M$ هو عدد مخرجات $G$ و$N$ هو حجم $w$.

<!--
Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount.
-->

لاحظ أن بعض التعقيدات قد تنشأ عندما لا تكون بنية الرسم البياني ثابتة، ولكنها تعتمد على البيانات. على سبيل المثال، يمكننا اختيار وحدة الشبكة العصبية اعتمادًا على طول متجه الإدخال. على الرغم من أن هذا ممكن، إلا أنه يصبح من الصعب بشكل متزايد إدارة هذا الاختلاف عندما يتجاوز عدد الحلقات رقمًا معقولاً.

<!--
### Basic neural net modules
-->

### وحدات الشبكة العصبية الأساسية

<!--
There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules).
-->

توجد أنواع مختلفة من الوحدات المبنية مسبقًا إلى جانب الوحدات النمطية Linear و ReLU المألوفة. تلك الوحدات مفيدة لأنها مطورة ومحسّنة بشكل فريد لأداء وظائفها الخاصة (على عكس كونها مبنية من خلال مجموعة من الوحدات الأولية الأخرى).

<!--
- Linear: $Y=W\cdot X$
-->

- خطي: $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
  $$

<!--
- Duplicate: $Y_1=X$, $Y_2=X$

  - Akin to a "Y - splitter" where both outputs are equal to the input.

  - When backpropagating, the gradients get summed

  - Can be split into $n$ branches similarly

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$
-->

- كرر: $Y_1=X$, $Y_2=X$

  - أقرب إلى "Y - splitter" حيث كلا المخرجات والمدخلات متساوية.

  - عند الانتشار الخلفي، يتم تلخيص التدرجات

  - يمكن تقسيمها إلى $ n $ من الفروق

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$

<!--
- Add: $Y=X_1+X_2$

  - With two variables being summed, when one is perturbed, the output will be perturbed by the same quantity, i.e.

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$
-->

- اجمع: $Y=X_1+X_2$

  - مع جمع متغيرين، عندما يحدث اضطراب في أحدهما، سيضطرب الناتج بنفس الكمية، أي

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$

<!--
- Max: $Y=\max(X_1,X_2)$

  -  Since this function can also be represented as

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$

  - Therefore, by the chain rule,

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$
-->

- كبر: $Y=\max(X_1,X_2)$

  -  لأنه يمكن أيضًا تمثيل هذه الدالة كما يلي،

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$

  - إذًا، باستخدام قاعدة السلسلة،

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$

<!--
## [LogSoftMax *vs.* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)
-->

## [LogSoftMax *مقابل* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

<!--
*SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between $0$ and $1$ that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories.
-->

*SoftMax* ، وهي أيضًا وحدة PyTorch ، هي طريقة ملائمة لتحويل مجموعة من الأرقام إلى مجموعة من الأرقام الموجبة تتراوح ما بين $0$ و $1$ وحاصل جمعها يساوي واحد. يمكن تفسير هذه الأرقام على أنها توزيع احتمالي (probability distribution). لذلك، يتم استخدامه بشكل شائع في مشاكل التصنيف. $y_i$ في المعادلة أدناه هو متجه للاحتمالات لجميع الفئات.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

<!--
However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when $s$ is large, $h(s)$ is $1$, and when s is small, $h(s)$ is $0$. Because the sigmoid function is flat at $h(s) = 0$ and $h(s) = 1$, the gradient is $0$, which results in a vanishing gradient.
-->

ومع ذلك، فإن استخدام softmax يترك الشبكة عرضة لتلاشي التدرجات. يعد التدرج المتلاشي مشكلة، لأنه يمنع تعديل الأوزان في اتجاه التيار بواسطة الشبكة العصبية، مما قد يوقف الشبكة العصبية تمامًا عن التعلم. تُظهر الدالة السيني اللوجيستية (logistic sigmoid function)، وهي دالة softmax لقيمة واحدة، أنه عندما يكون $s$ كبيرًا ، فإن $h(s)$ تساوي  $1$، ولما تكون $s$ صغيرة، تساوي $h(s)$ قيمة الـ $0$. نظرًا لأن الدالة sigmoid ثابتة عند $h(s) = 0$ و$h(s) = 1$، فإن التدرج هو $0$، مما ينتج عنه تدرج متلاشي.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="دالة sigmoid لتوضيح التدرج المتلاشي" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

<!--
Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log.
-->

توصل علماء الرياضيات إلى فكرة logsoftmax من أجل حل مشكلة التدرج المتلاشي الذي ينشأ من دالة الـ softmax. *LogSoftMax* هي وحدة نمطية أساسية أخرى في PyTorch. كما يتضح من المعادلة أدناه، *LogSoftMax* هي مزيج من softmax و log.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

<!--
The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When $s$ is very small, the value is $0$, and when $s$ is very large, the value is $s$. As a result it doesn’t saturate, and the vanishing gradient problem is avoided.
-->

توضح المعادلة أدناه طريقة أخرى للنظر إلى نفس المعادلة. يوضح الشكل أدناه الجزء التالي من الدالة: $\log(1 + \exp(s))$. عندما يكون $s$ صغيرًا جدًا، تكون القيمة $0$، وعندما يكون $s$ كبيرًا جدًا، تصبح القيمة هي $s$. ونتيجة لذلك، لا تتشبع النتيجة وتصل لقيمة قصوى ثابتة (saturate)، وبذلك نتجنب مشكلة التدرج المتلاشي.


$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="رسم للجزء اللوغاريتمي من الدالة" /></center>


<!-- ## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s) -->

## [حيل عملية للانتشار الخلفي](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)


<!--
### Use ReLU as the non-linear activation function

ReLU works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.
-->

### استخدم ReLU كدالة التنشيط اللاخطية

يعمل ReLU بشكل أفضل مع الشبكات ذات الطبقات المتعددة، وهذا سبب قلة استخدام بدائل كدالة sigmoid ودوال الظل الزائدية $\tanh(\cdot)$. السبب وراء نجاح هذه الطريقة هو وجود ذاك الالتواء في الدالة والذي يجعلها متكافئة للمقايس المختلفة. 

<!--
### Use cross-entropy loss as the objective function for classification problems

Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).
-->

### استخدم الخسارة عبر الانتروبيا كدالة الهدف للتصنيف

Log softmax، والذي ناقشناه سابقًا في المحاضرة، هو حالة خاصة من فقدان الانتروبيا. في PyTorch، تأكد من توفير دالة الخسارة عبر الانتروبيا مع  *log* softmax كمدخل (على عكس الـ softmax العادي).

<!--
### Use stochastic gradient descent on minibatches during training

As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.
-->

### استخدم الانحدار التدرجي العشوائي على حزم صغيرة أثناء التدريب

كما تمت مناقشته سابقًا، تتيح لك الحزم الصغيرة (minibatches) التدريب بشكل أكثر كفاءة نظرًا لوجود تكرار في البيانات؛ لا يجب أن تقوم بالتنبؤ وحساب الخسارة على كل ملاحظة في كل خطوة لتقدير التدرج.

<!--
### Shuffle the order of the training examples when using stochastic gradient descent

Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, *etc*. Ideally, you should have samples from every class in every minibatch.

However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch).
-->

### تبديل ترتيب أمثلة التدريب عشوائيًا عند استخدام الانحدار التدرجي العشوائي

الترتيب مهم. إذا رأى النموذج أمثلة فقط من فصيلة واحدة فقط أثناء كل خطوة تدريب، فسوف يتعلم التنبؤ بهذه الفصيلة دون معرفة سبب وجوب توقع تلك الفصيلة. على سبيل المثال، إذا كنت تحاول تصنيف الأرقام من مجموعة بيانات MNIST ولم يتم خلط البيانات، فإن معاملات التحيز في الطبقة الأخيرة ستتنبأ دائمًا بالصفر، ثم تتكيف لتتنبأ دائمًا بواحد، ثم اثنين، *إلخ*. من الناحية المثالية، يجب أن يكون لديك عينات من كل فصيلة في كل حزمة صغيرة.

ومع ذلك، هناك جدل مستمر حول ما إذا كنت بحاجة إلى تغيير ترتيب العينات في كل دفعة (epoch).

<!--
### Normalize the inputs to have zero mean and unit variance

Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as
-->

### تسوية المدخلات بحيث يكون لها صفرية المتوسط وتباين الوحدة

قبل التدريب، من المفيد تسوية كل خاصية إدخال بحيث يكون لها متوسط صفر وانحراف معياري يساوي الواحد. عند استخدام بيانات صورة RGB، من الشائع أخذ الانحراف المعياري والمتوسط لكل قناة على حدة وتسوية (normalize) الصورة من حيث القناة. على سبيل المثال، خذ المتوسط $m_b$ والانحراف المعياري $\sigma_b$ لجميع القيم الزرقاء في مجموعة البيانات، ثم قم بتسوية القيم الزرقاء لكل صورة على حدة كما يلي

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

<!--
where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none.
-->

حيث $\epsilon$ رقم صغير عشوائيًا نستخدمه لتجنب القسمة على الصفر. كرر الأمر نفسه للقنوات الخضراء والحمراء. يعد ذلك ضروريًا للحصول على إشارة ذات مغزى من الصور الملتقطة في إضاءة مختلفة؛ على سبيل المثال، تحتوي الصور المضاءة بالنهار على الكثير من اللون الأحمر بينما الصور تحت الماء لا تحتوي على أي شيء تقريبًا.


<!--
### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam which adapt the learning rate instead of simple SGD with a constant learning rate.
-->

### استخدم جدولًا لخفض معدل التعلم

يجب أن ينخفض معدل التعلم مع استمرار التدريب. عمليًا، يتم تدريب معظم النماذج المتقدمة باستخدام خوارزميات مثل Adam والتي تكيف معدل التعلم بدلاً من SGD البسيط بمعدل تعلم ثابت.

<!--
### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows:
-->

### استخدم تنظيم L1 و/أو L2 لتناقص الوزن

يمكنك إضافة تكلفة للأوزان الكبيرة إلى دالة التكلفة. على سبيل المثال، باستخدام تنظيم L2، سنقوم بتعريف الخسارة $w$ وتحديث الأوزان $w$ على النحو التالي:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

<!--
To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.
-->

لفهم سبب تسمية هذا بتناقص الوزن، لاحظ أنه يمكننا إعادة كتابة الصيغة أعلاه لتوضيح أننا نضرب $w_i$ في ثابت أقل من واحد أثناء التحديث.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

<!--
L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to $0$.
-->

تنظيم L1 (Lasso) مشابه لما سبق، باستثناء أننا نستخدم $\sum_i \vert w_i\vert$  بدلاً من $\Vert w \Vert^2$.

بشكل أساسي، يحاول التنظيم إخبار النظام بتقليل دالة التكلفة إلى الحد الأدنى باستخدام أصغر متجه أوزان ممكن. مع تنظيم L1، يتم تقليص الأوزان غير المفيدة إلى $0$.

<!--
### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the variance of the weights is inversely proportional to square root of number of inputs.
-->

### تهيئة الوزن

يجب تهيئة الأوزان بشكل عشوائي، ومع ذلك، لا ينبغي أن تكون كبيرة جدًا أو صغيرة جدًا بحيث يكون المخرجات تقريبًا بذات تباين المدخلات. هناك حيل مختلفة لتهيئة الوزن مضمنة في PyTorch. إحدى الحيل التي تعمل جيدًا للنماذج العميقة هي تهيئة Kaiming حيث يتناسب تباين الأوزان عكسياً مع الجذر التربيعي لعدد المدخلات.

<!--
### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.
-->

### استخدام الإسقاط

الإسقاط هو شكل آخر من أشكال التنظيم. يمكن اعتبارها طبقة أخرى من الشبكة العصبية: فهي تأخذ المدخلات، وتضبط عشوائياً $n/2$  من المدخلات للصفر، وتعيد النتيجة كمخرجات. هذا يفرض على النظام أخذ المعلومات من جميع وحدات الإدخال بدلاً من الاعتماد بشكل مفرط على عدد صغير من وحدات الإدخال وبالتالي توزيع المعلومات عبر جميع الوحدات في الطبقة. تم اقتراح هذه الطريقة لأول مرة بواسطة <a href="https://arxiv.org/abs/1207.0580">Hinton وآخرون (2012)</a>.

<!--
For more tricks, see  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules.
-->

لمزيد من الحيل، راجع <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf"> LeCun وآخرون 1998 </a>.

أخيرًا ، لاحظ أن الانتشار الخلفي لا يعمل فقط مع النماذج المكدسة؛ يمكن أن يعمل مع أي رسم بياني لا دوري موجه أو ما يعرف بـ directed acyclic graph (DAG) طالما أن هناك ترتيب جزئي على الوحدات.