---
lang-ref: ch.02-1
lang: ar
lecturer: Yann LeCun
title: مقدمة في خوارزمية الانحدار التدريجي والانتشار الخلفي
authors: Amartya Prasad, Dongning Fang, Yuxin Tang, Sahana Upadhya
date: 3 Feb 2020
translation-date: 24 Jan 2021
translator: Haya Alsharif
---


<!--
## [Gradient Descent optimization algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)
-->


## [خوازمية تحسين الانحدار التدريجي](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)

<!--
### Parametrised models
-->


### النماذج ذات المعاملات

$$
\bar{y} = G(x,w)
$$

<!--Parametrised models are simply functions that depend on inputs and trainable parameters. There is no fundamental difference between the two, except that trainable parameters are shared across training samples whereas the input varies from sample to sample. In most deep learning frameworks, parameters are implicit, that is, they aren't passed when the function is called. They are 'saved inside the function', so to speak, at least in the object-oriented versions of models.
-->

النماذج ذات المعاملات هي ببساطة دوال تعتمد على المدخلات والمعاملات القابلة للتدريب. لا يوجد فرق أساسي بين الاثنين، باستثناء أن المعاملات القابلة للتدريب يتم مشاركتها عبر عينات التدريب حيث تختلف المدخلات من عينة إلى أخرى. في معظم أنظمة التعلم العميق، تكون تلك المعاملات ضمنية، أي لا يتم تمريرها عند استدعاء الدالة. على الأقل في النماذج الموجهة بالكائنات (object-oriented models)، يتم "حفظها تلك المعاملات داخل الدالة" إذا جاز التعبير.

<!--The parametrised model (function) takes in an input, has a parameter vector and produces an output. In supervised learning, this output goes into the cost function ($C(y,\bar{y}$)), which compares the true output (${y}$) with the model output ($\bar{y}$). The computation graph for this model is shown in Figure 1.
-->

يأخد النموذج ذو المعاملات المدخلات، ويملك متجه من المعاملات، ومن ثم يتنج المخرجات. تدخل تلك المخرجات في حالة التعلم بالإشراف إلى (دالة) وهو دالة التكلفة ($C(y,\bar{y}$))، حيث يتم مقارنة القيمة الفعلية المرادة  (${y}$) بمخرجات النموذج ($\bar{y}$). شكل ١ يظهر الرسم البياني الحسابي.

<!--| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Figure 1: Computation Graph representation for a Parametrised Model </center>|
-->

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Figure 1: الرسم البياني الحسابي لنموذج بمعاملات </center>|

<!--Examples of parametrised functions -
-->

أمثلة على دوال بمعاملات -

<!--- Linear Model - Weighted Sum of Components of the Input Vector :
-->

- النماذج الخطية - المجموع الموزون لعناصر المتجه المدخل:

<!--  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$
-->

$$
\bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
$$

<!--- Nearest Neighbour - There is an input $\vect{x}$ and a weight matrix $\matr{W}$ with each row of the matrix indexed by $k$. The output is the value of $k$ that corresponds to the row of $\matr{W}$ that is closest to $\vect{x}$:
-->

- خوارزمية أقرب جار - لدينا مدخل $\vect{x}$ و مصفوفة أوزان $\matr{W}$ يعبر عن كل صف فيها بالرمز $k$. تمثل المخرجات قيمة الصف $k$ من $\matr{W}$ الأقرب إلى $\vect{x}$.

$$
\bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
$$

<!--  Parameterized models could also involve complicated functions.
-->

 قد تشمل النماذج ذات معاملات دوالًا معقدة.

<!--
#### Block diagram notations for computation graphs
-->


#### Block diagram notations for computation graphs

<!--
    - Variables (tensor, scalar, continuous, discrete)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> is an observed input to the system
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> is a computed variable which is produced by a deterministic function
-->

- المتغيرات (موتر، عددي، متصل، منفصل)
- <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> مدخلات للنظام يمكن ملاحظتها
- <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> متغير محسوب يتم إنتاجه بواسطة دالة محددة

<!--- Deterministic functions
-->

- الدوالة المحددة

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

<!--    - Takes in multiple inputs and can produce multiple outputs
    - It has an implicit parameter variable (${w}$)
    - The rounded side indicates the direction in which it is easy to compute. In the above diagram, it is easier to compute ${\bar{y}}$ from ${x}$ than the other way around
-->

- تأخذ مدخلات متعددة ويمكن أن ينتج مخرجات متعددة أيضًا
- تحتوي على متغير معامل ضمني (${w}$)
- يشير الجانب المستدير إلى الاتجاه الذي يسهل فيه الحساب. في الرسم البياني أعلاه، من الأسهل حساب${\bar{y}}$ باستخدام ${x}$  مقارنة بالعكس

<!--- Scalar-valued function
-->

- الدوال العددية

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

<!--    - Used to represent cost functions
    - Has an implicit scalar output
    - Takes multiple inputs and outputs a single value (usually the distance between the inputs)
-->

- تستخدم لتمثيل دالة التكلفة
     - لها ناتج عددي ضمني
     - تأخذ مدخلات عدة وتنتج مخرجًا واحدًا (عادة المسافة بين المدخلات)


<!--
#### Loss functions
-->


#### دالة الخسارة

<!--Loss function is a function that is minimized during training. There are two types of losses:
-->

دالة الخسارة هي الدالة التي نعمل على التقليل من قيمتها خلال مرحلة التدريب. يوجد نوعان من هذه الخسارة:

<!--1) Per Sample Loss -
-->

1) الخسارة لكل عنصر -

$$
 L(x,y,w) = C(y, G(x,w))
$$

<!--2) Average Loss -
-->

2) متوسط الخسارة -

<!--For any set of Samples
-->

لكل مجموعة من العينات

$$S = \lbrace(x[p],y[p]) \mid p \in \lbrace 0, \cdots, P-1 \rbrace \rbrace$$

<!--Average Loss over the Set $S$ is given by:
-->

يُمثل متوسط الخسارة على المجموعة $S$ بالآتي:

$$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

<!--| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>Figure 2: Computation graph for model with Average Loss    </center>|
-->

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>شكل ٢: الرسم البياني الحسابي للنموذج بمتوسط الخسارة   </center>|

<!--In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent.
-->

في نموذج التعلم بالإشراف القياسي، فإن الخسارة (لكل عينة) هي ببساطة ناتج دالة التكلفة. يتعلق التعلم الآلي في الغالب بتحسين الدوال (وعادةً ما يكون التحسين بتقليل قيمة نتائجها). يمكن أن يتضمن ذلك أيضًا العثور على توازن ناش (Nash Equilibria) بين وظيفتين كما هو الحال مع شبكات GAN. يتم ذلك باستخدام طرق قائمة على التدرج، ولكن ليس بالضرورة الانحدار التدريجي.

<!--
### Gradient descent
-->


### الانحدار التدريجي

<!--A **Gradient Based Method** is a method/algorithm that finds the minima of a function, assuming that one can easily compute the gradient of that function. It assumes that the function is continuous and differentiable almost everywhere (it need not be differentiable everywhere).
-->

**الطرق القائمة على التدرج** هي طرق/خوارزميات للبحث عن الحد الأدنى لدالة ما، بافتراض أنه يمكن للمرء بسهولة حساب التدرج لتلك الدالة. تفترض تلك الطرق بأن الدالة متصلة وقابلة للتفاضل في كل مكان تقريبًا (ولا يلزم ذلك أن تكون قابلة للتفاضل في كل مكان).

<!--**Gradient Descent Intuition** - Imagine being in a mountain in the middle of a foggy night. Since you want to go down to the village and have only limited vision, you look around your immediate vicinity to find the direction of steepest descent and take a step in that direction.
-->

**مبدأ الانحدار التدريجي** - تخيل أنك في جبل في منتصف ليلة ضبابية. نظرًا لأنك تريد النزول إلى القرية ولديك رؤية محدودة فقط، فبإمكانك فقط النظر حول المنطقة المجاورة لك مباشرة والبحث على اتجاه المنحدر الأكثر حدة، ومن ثم اتخاذ خطوة في ذاك الاتجاه.

<!--**Different methods of Gradient Descent**
-->

**طرق مختلفة للانحدار التدريجي**

<!--- Full (batch) gradient descent update rule :
-->

- قاعدة لتحديث الانحدار التدريجي بحزمة كاملة:

<!--  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$
-->

$$
w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
$$

<!--- For SGD (Stochastic Gradient  Descent), the update rule becomes :
-->

- بالنسبة لـ SGD (الانحدار التدرجي العشوائي)، تصبح قاعدة التحديث كالآتي:

<!--  - Pick a $p \in \lbrace 0, \cdots, P-1 \rbrace$, then update
-->

  - اختر قيمة لـ $p \in \lbrace 0, \cdots, P-1 \rbrace$، ومن ثم قُم بالتحديث:

<!--    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$
-->

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

<!--Where ${w}$ represents the parameter to be optimized.
-->

حيث تمثل ${w}$ المعامل الذي نرغب بتحسينه.

<!--$\eta$ is a constant here but in more sophisticated algorithms, it could be a matrix.
-->

$\eta$ هي ثابت عددي في هذه الحالة، ولكن بعض الخوارزميات المتقدمة، تكون عبارة عن مصفوفة.

<!--If it is a positive semi-definite matrix, we'll still move downhill but not necessarily in the direction of steepest descent. In fact the direction of steepest descent may not always be the direction we want to move in.
-->

إذا كانت مصفوفة موجبة شبه مُعرَّفة، فسنظل نتحرك إلى أسفل ولكن ليس بالضرورة في اتجاه أقصى هبوط. في الواقع، قد لا يكون اتجاه الهبوط الحاد دائمًا هو الاتجاه الذي نريد أن نتحرك فيه.

<!--If the function is not differentiable, i.e, it has a hole or is staircase like or flat, where the gradient doesn't give you any information, one has to resort to other methods - called 0-th Order Methods or Gradient-Free Methods. Deep Learning is all about Gradient Based Methods.
-->

إذا كانت الوظيفة غير قابلة للتفاضل، أي أنها تحتوي على فتحة أو تدرج درجي أو مسطحة، حيث لا يمنحك للتدرج أي معلومات، يجب على المرء أن يلجأ إلى طرق أخرى - تسمى طرقية الترتيب الصفرية أو طرق خالية من التدرج. التعلم العميق قائم على التدرج.

<!--However, RL (Reinforcement Learning) involves **Gradient Estimation** without the explicit form for the gradient. An example is a robot learning to ride a bike where the robot falls every now and then. The objective function measures how long the bike stays up without falling. Unfortunately, there is no gradient for the objective function. The robot needs to try different things.
-->

في المقابل، يتضمن التعلم المعزز (RL) **تقدير التدرج** بدون الشكل الواضح للتدرج. مثال على ذلك هو الروبوت الذي يتعلم ركوب الدراجة حيث يسقط الروبوت بين الحين والآخر. تقيس دالة الهدف مدة بقاء الدراجة دون أن تسقط. لسوء الحظ، لا يوجد تدرج لوظيفة الهدف. يحتاج الروبوت إلى تجربة أشياء مختلفة.

<!--The RL cost function is not differentiable most of the time but the network that computes the output is gradient-based. This is the main difference between supervised learning and reinforcement learning. With the latter, the cost function $C$ is not differentiable. In fact it completely unknown. It just returns an output when inputs are fed to it, like a blackbox. This makes it highly inefficient and is one of the main drawbacks of RL - particularly when the parameter vector is high dimensional (which implies a huge solution space to search in, making it hard to find where to move).
-->

لا يمكن اشتقاق دالة تكلفة الـ RL في معظم الأوقات، لكن الشبكة التي تحسب الناتج تعتمد على التدرج. هذا هو الفرق الرئيسي بين التعلم بالإشراف والتعلم المعزز، حيث تكون دالة التكلفة $C$ في التعلم المعزز غير قابلة للتفاضل. في الواقع هذه الدالة غير معروفة تمامًا، وكل ما تقوم به هو إرجاع مخرجات بناءً على المدخلات إليه، وتعمل مثل الصندوق الأسود. هذا تحديدًا ما يجعلها غير فعالة للغاية وهو أحد المشاكل الرئيسية في الـ RL - خاصة عندما يكون المتجه ذو أبعاد عالية (مما يعني وجود مساحة حل ضخمة للبحث فيها، مما يزيد من صعوبة إيجاد مكان التحرك).

<!--A very popular technique in RL is Actor Critic Methods. A critic method basically consists of a second C module which is a known, trainable module. One is able to train the C module, which is differentiable, to approximate the cost function/reward function. The reward is a negative cost, more like a punishment. That’s a way of making the cost function differentiable, or at least approximating it by a differentiable function so that one can backpropagate.
-->

تقنية شائعة جدًا في الـ RL هي طرق انتقاد الفاعل. تتكون طريقة الناقد بشكل أساسي من وحدة C ثانية وهي وحدة معروفة وقابلة للتدريب. يستطيع المرء تدريب الوحدة C والتي يمكن تفاضلها  لتقارب دالة التكلفة/المكافأة. حيث للمكافأة قيمة سلبية مشكلةً عقوبة للفاعل. هذه طريقة لجعل دالة التكلفة قابلة للتفاضل، أو على الأقل تقريبها من خلال دالة أخرى قابلة للتفاضل بحيث يمكن للمرء تطبيق الانتشار الخلفي.

<!--
## [Advantages of SGD and backpropagation for traditional neural nets](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)
-->


## [مزايا SGD و الانتشار الخلفي للشبكات العصبية التقليدية](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)

<!--
### Advantages of Stochastic Gradient Descent (SGD)
-->


### مزايا الانحدار التدرجي العشوائي (SGD)

<!--In practice, we use stochastic gradient to compute the gradient of the objective function w.r.t the parameters. Instead of computing the full gradient of the objective function, which is the average of all samples, stochastic gradient just takes one sample, computes the loss, $L$, and the gradient of the loss w.r.t the parameters, and then takes one step in the negative gradient direction.
-->

في الممارسة العملية، نستخدم التدرج العشوائي لحساب التدرج لدالة الهدف بالنسبة للمعاملات. بدلاً من حساب التدرج الكامل لدالة الهدف، وهو متوسط جميع العينات، يأخذ التدرج العشوائي عينة واحدة فقط ويحسب الخسارة، $L$، وتدرج الخسارة في المعاملات، ثم يأخذ خطوة واحدة في اتجاه التدرج السلبي.

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

<!--In the formula, $w$ is approached by $w$ minus the step-size, times the gradient of the per-sample loss function w.r.t the parameters for a given sample, ($x[p],y[p]$).
-->

في الصيغة أعلاه، تقترب قيمة $w$ من  $w$ مطروحًا منها حجم الخطوة، ومضروبةً في اشتقاق دالة الخسارة لكل عينة بالنسبة لمعاملات تلك العينة ($x[p],y[p]$).


<!--If we do this on a single sample, we will get a very noisy trajectory as shown in Figure 3. Instead of the loss going directly downhill, it’s stochastic. Every sample will pull the loss towards a different direction. It’s just the average that pulls us to the minimum of the average. Although it looks inefficient, it’s much faster than full batch gradient descent at least in the context of machine learning when the samples have some redundancy.
-->

إذا قمنا بذلك على عينة واحدة، فسنحصل على مسار مشوشٍ للغاية كما هو موضح في الشكل 3. بدلاً من الخسارة التي تنحدر مباشرة، فإنها عشوائية (stochastic). وستسحب كل عينة الخسارة نحو اتجاه مختلف. فقط المتوسط هو ​​الذي يقودنا إلى الحد الأدنى من المتوسط. على الرغم من أنها تبدو غير فعالة، إلا أنها على الأقل أسرع بكثير من الانحدار التدريجي بحزمة كاملة في سياق التعلم الآلي عندما تحتوي العينات على بعض من التكرار.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>الشكل 3: مسار نزول الانحدار التدرجي العشوائي لتحديث كل عينة</center>|


<!--
In practice, we use batches instead of doing stochastic gradient descent on a single sample. We compute the average of the gradient over a batch of samples, not a single sample, and then take one step. The only reason for doing this is that we can make more efficient use of the existing hardware  (*i.e.* GPUs, multicore CPUs) if we use batches since it's easier to parallelize. Batching is the simplest way to parallelize.
-->

من الناحية العملية، نستخدم الدُفعات بدلاً من إجراء انحدار تدريجي عشوائي على عينة واحدة. من ثم نحسب متوسط التدرج على مجموعة من العينات، وليس عينة واحدة، ثم نأخذ خطوة واحدة. السبب الوحيد للقيام بذلك هو أنه الدفعات تمكنا من الاستفادة بشكل أكثر كفاءة من الأجهزة الموجودة (*على سبيل المثال،* وحدات GPU و CPU متعددة النواة) لأنه من السهل تنفيذها على التوازي. الدفعات هو أبسط طريقة للتوازي.

<!--
### Traditional neural network
-->

### الشبكة العصبية التقليدية

<!--Traditional Neural Nets are basically interspersed layers of linear operations and point-wise non-linear operations. For linear operations, conceptually it is just a matrix-vector multiplication. We take the (input) vector multiplied by a matrix formed by the weights. The second type of operation is to take all the components of the weighted sums vector and pass it through some simple non-linearity (*i.e.* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).
-->

الشبكات العصبية التقليدية هي في الأساس طبقات متناثرة من العمليات الخطية والعمليات غير الخطية النقطية. بالنسبة للعمليات الخطية، من الناحية المفاهيمية، فهي مجرد عملية ضرب متجه بمصفوفة. نأخذ المتجه (المدخلات) ونضربه في مصفوفة مكونة من الأوزان. النوع الثاني من العملية هو أخذ كافة مكونات متجه المجاميع الموزونة ونمررها من خلال بعض العمليات اللاخطية البسيطة (*على سبييل المثال* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>الشكل 4: الشبكة العصبية التقليدية </center>|


<!--Figure 4 is an example of a 2-layer network, because what matters are the pairs (i.e linear+non-linear). Some people call it a 3-layer network because they count the variables. Note that if there are no non-linearities in the middle, we may as well have a single layer because the product of two linear functions is a linear function.
-->

الشكل 4 مثال لشبكة من طبقتين، لأن ما يهم هو زوجي الطبقات (الخطية + واللاخطية). يسميها بعض الناس شبكة من 3 طبقات لأنهم يحسبون المتغيرات كطبقة. لاحظ أنه إذا لم تكن هناك عناصر غير خطية في الوسط، فقد يكون لدينا أيضًا طبقة واحدة لأن ضرب دالتين خطيتين هو دالة خطية واحدة.

<!--Figure 5 shows how the linear and non-linear functional blocks of the network stack:
-->

يوضح الشكل 5 كيفية تتكدس مجموعات الدوال الخطية واللاخطية:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>الشكل 5: النظر داخل الكتل الخطية وغير الخطية   </center>|


<!--In the graph, $s[i]$ is the weighted sum of unit ${i}$ which is computed as:
-->

في الرسم البياني، $s[i]$  هو المجموع الموزون للوحدة ${i}$ والذي يتم حسابه على النحو التالي:

$$
s[i]=\sum_{j \in UP(i)}w[i,j]\cdot z[j]
$$

<!--where $UP(i)$ denotes the predecessors of $i$ and $z[j]$ is the $j$th output from the previous layer.
-->

حيث يشير $UP(i)$ إلى أسلاف $i$ و $z[j]$ هو الناتج العنصر رقم $j$ من الطبقة السابقة.

<!--The output $z[i]$ is computed as:
-->

الناتج $z[i]$ يحسب على النحو التالي:

$$
z[i]=f(s[i])
$$

<!--where $f$ is a non-linear function.
-->

حيث $f$ دالة غير خطية.

<!--
### Backpropagation through a non-linear function
-->

### الانتشار الخلفي من خلال دالة غير خطية

<!--The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox.
-->

الطريقة الأولى للقيام بالانتشار الخلفي هي إعادة الانتشار من خلال دالة غير خطية. نأخذ دالة غير خطية معينة $h$ من الشبكة ونترك كل شيء آخر في الصندوق الأسود.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>الشكل 6: الانتشار الخلفي من خلال دالة غير خطية    </center>|


<!--We are going to use the chain rule to compute the gradients:
-->

سنستخدم قاعدة السلسلة لحساب التدرجات:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

<!--where $h'(s)$ is the derivative of $z$ w.r.t $s$ represented by $\frac{\mathrm{d}z}{\mathrm{d}s}$.
To make the connection between derivatives clear, we rewrite the formula above as:
-->

حيث $h'(s)$ هو مشتق $z$ بالنسبة إلى $s$ ويمثله $\frac{\mathrm{d}z}{\mathrm{d}s}$.
لتوضيح العلاقة بين المشتقات، نعيد كتابة الصيغة أعلاه على النحو التالي:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

<!--Hence if we have a chain of those functions in the network, we can backpropagate by multiplying by the derivatives of all the ${h}$ functions one after the other all the way back to the bottom.
-->

ومن ثم، إذا كان لدينا سلسلة من هذه الدوال في الشبكة، فيمكننا الانتشار للخلف من خلال الضرب في مشتقات جميع الدوال ${h}$ واحدة تلو الأخرى طوال الطريق للخلف.

<!--It’s more intuitive to think of it in terms of perturbations. Perturbing $s$ by $\mathrm{d}s$ will perturb $z$ by:
-->

من البديهي التفكير في الأمر من منظور الاضطرابات. سيؤدي اضطراب $s$ بمقدار $\mathrm{d}s$ إلى إرباك $z$ بواسطة:

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

<!--This would in turn perturb $C$ by:
-->

سيؤدي هذا بدوره إلى إرباك $C$ من خلال:

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

<!--Once again, we end up with the same formula as the one shown above.
-->

مرة أخرى، ينتهي بنا الأمر بنفس الصيغة الموضحة أعلاه.

<!--
### Backpropagation through a weighted sum
-->

### الانتشار الخلفي من خلال المجموع الموزون

<!--For a linear module, we do backpropagation through a weighted sum. Here we view the entire network as a blackbox except for 3 connections going from a ${z}$ variable to a bunch of $s$ variables.
-->

بالنسبة لوحدة نمطية خطية، نطبق الانتشار الخلفي باستخدام المجموع المرجح. هنا، ننظر إلى الشبكة بالكامل على أنها صندوق أسود باستثناء 3 توصيلات تنطلق من متغير ${z}$ إلى مجموعة متغيرات $s$.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>الشكل 7: الانتشار الخلفي من خلال المجموع الموزون  </center>|


<!--
This time the perturbation is a weighted sum. $Z$ influences several variables. Perturbing $z$ by $\mathrm{d}z$ will perturb $s[0]$, $s[1]$ and $s[2]$ by:
-->

هذه المرة، الاضطراب هو المجموع الموزون. يؤثر $Z$ على عدة متغيرات. سيؤدي تشويش $z$ بواسطة $\mathrm{d}z$ إلى إرباك $s[0]$ و $s[1]$ و $s[2]$ بواسطة:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$


$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

<!-- This will perturb $C$ by
-->

سيؤدي هذا إلى اضطراب $C$ بواسطة

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$


<!--Hence $C$ is going to vary by the sum of the 3 variations:
-->

ومن ثم، فإن $C$ ستختلف باختلاف مجموع الأشكال الثلاثة:

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$


<!--
## [PyTorch implementation of neural network and a generalized backprop algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)
-->

## [تطبيق باستخدام PyTorch للشبكة العصبية وخوارزمية عامة للانتشار الخلفي] (https://www.youtube.com/watch؟v=d9vdh3b787Y&t=2288s)

<!--
### Block diagram of a traditional neural net
-->

### رسم تخطيطي للشبكة العصبية التقليدية

<!--- Linear blocks $s_{k+1}=w_kz_k$
- Non-linear blocks $z_k=h(s_k)$
-->

- الأجزاء الخطية $s_{k+1}=w_kz_k$
- الأجزاء غير الخطية $z_k=h(s_k)$

<center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

<!--$w_k$: matrix $z_k$: vector $h$: application of scalar ${h}$ function to every component. This is a 3-layer neural net with pairs of linear and non-linear functions, though most modern neural nets do not have such clear linear and non-linear separations and are more complex.
-->

$w_k$: مصفوفة $z_k$: متجه $h$: تطبيق دالة عددية ${h}$ لكل مكون. هذه شبكة عصبية من 3 طبقات مع أزواج من الدوال الخطية وغير الخطية، ولكن معظم الشبكات العصبية الحديثة لا تحتوي على مثل هذه الفواصل الخطية وغير الخطية الواضحة وعادة ما تكون أكثر تعقيدًا.

<!--
### PyTorch implementation
-->

### تطبيق باستخدام PyTorch

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

<!--- We can implement neural nets with object oriented classes in PyTorch. First we define a class for the neural net and initialize linear layers in the constructor using predefined `nn.Linear` class. Linear layers have to be separate objects because each of them contains a parameter vector. The `nn.Linear` class also adds the bias vector implicitly. Then we define a forward function on how to compute outputs with $\text{torch.relu}$ function as the nonlinear activation. We don't have to initialize separate relu functions because they don't have parameters.
-->

- يمكننا تطبيق الشبكات العصبية باستخدام فئات كائنية التوجه (object oriented classes) في PyTorch. أولاً، نحدد الـ class للشبكة العصبية ونهيئ الطبقات الخطية في الـ constructor باستخدام فئة `nn.Linear` المعرفة مسبقًا. يجب أن تكون الطبقات الخطية كائنات منفصلة لأن كل منها تحتوي على متجه من المعاملات. تضيف `nn.Linear` class أيضًا متجه التحيز (bias vector) ضمنيًا. ثم نقوم بتعريف دالة forward تُعرّف كيفية حساب المخرجات بدالة $\text{torch.relu}$ كتفعيل غير خطي. لا يتعين علينا تهيئة (initialize) وظائف relu منفصلة لأنها لا تحتوي على معاملات.

<!--- We do not need to compute the gradient ourselves since PyTorch knows how to back propagate and calculate the gradients given the `forward` function.
-->

- لسنا بحاجة إلى حساب التدرج بأنفسنا لأن PyTorch يعرف كيفية دعم الانتشار وحساب التدرجات مع الأخذ في الاعتبار دالة "forward".

<!--
### Backprop through a functional module
-->

### الانتشار الخلفي من خلال وحدة وظيفية

<!--We now present a more generalized form of backpropagation.
-->

نقدم الآن شكلاً أكثر عمومية من الانتشار الخلفي.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center> الشكل 8: الانتشار الخلفي من خلال وحدة وظيفية </center>|


<!--
- Using chain rule for vector functions
-->

- استخدام قاعدة السلسلة لدوال المتجهات

$$
 z_g : [d_g\times 1]
$$

$$
 z_f:[d_f\times 1]
$$


$$
\frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
$$

$$
[1\times d_f]= [1\times d_g]\times[d_g\times d_f]
$$

<!--  This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector.
-->

هذه هي الصيغة الأساسية لـ $\frac{\partial c}{\partial{z_f}}$ باستخدام قاعدة السلسلة. لاحظ أن التدرج لدالة عددية بالنسبة إلى المتجه هو متجه له نفس حجم المتجه الذي تشتقه. من أجل جعل الرموز متسقة، فإن المتجه عبارة عن بدلاً من عمود.

<!--- Jacobian matrix
-->

- مصفوفة جاكوبية

$$
\left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
$$

<!--  We need $\frac{\partial {z_g}}{\partial {z_f}}$ (Jacobian matrix entries) to compute the gradient of the cost function with respect to $z_f$ given gradient of the cost function with respect to $z_g$. Each entry $ij$ is equal to the partial derivative of the $i$th component of the output vector with respect to the $j$th component of the input vector.
-->

نحتاج إلى $\frac{\partial {z_g}}{\partial {z_f}}$ دولار (عناصر مصفوفة جاكوبية) لحساب تدرج دالة التكلفة بالنسبة إلى $z_f$ باعتبار أن انحدار دالة التكلفة بالنسبة إلى $z_g$ معطى. كل عنصر $ij$ يساوي الاشتقاق الجزئي للعنصر رقم $i$ من متجه المخرجات بالنسبة للعنصر $j$ من متجه المدخلات.

<!--  If we have a cascade of modules, we keep multiplying the Jacobian matrices of all the modules going down and we get the gradients w.r.t all the internal variables.
-->

إذا كان لدينا سلسلة من الوحدات، فإننا نستمر في ضرب المصفوفات الجاكوبية لجميع الوحدات في الأسفل ونحصل على التدرجات مع جميع المتغيرات الداخلية.

<!--
### Backprop through a multi-stage graph
-->

### الانتشار الخلفي من خلال رسم بياني متعدد المراحل

<!--Consider a stack of many modules in a neural network as shown in Figure 9.
-->

لنأخد في عين الاعتبار مجموعة من العديد من الوحدات في الشبكة العصبية كما هو موضح في الشكل 9.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>الشكل 9: الانتشار الخلفي من خلال رسم بياني متعدد المراحل </center>|


<!--For the backprop algorithm, we need two sets of gradients - one with respect to the states (each module of the network) and one with respect to the weights (all the parameters in a particular module). So we have two Jacobian matrices associated with each module. We can again use chain rule for backprop.
-->

بالنسبة لخوارزمية الانتشار الخلفي، نحتاج إلى مجموعتين من التدرجات - واحدة بالنسبة إلى الحالات أو ما يعرف بـ states (كل وحدة من وحدات الشبكة) والأخرى بالنبسة إلى الأوزان (جميع المعاملات في وحدة معينة). لذلك لدينا مصفوفتان جاكوبيتان مرتبطتان بكل وحدة. يمكننا مرة أخرى استخدام قاعدة السلسلة للانتشار الخلفي.

<!--- Using chain rule for vector functions
-->

- استخدام قاعدة السلسلة للدوال المتجهة

$$
\frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
$$

$$
\frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
$$

<!--- Two Jacobian matrices for the module
    - One with respect to $z[k]$
    - One with respect to $w[k]$
-->

- مصفوفتان جاكوبيتان للوحدة
    - واحد بالنسبة إلى $z[k]$
    - واحد بالنسبة إلى $w[k]$
