---
lang: ar
lang-ref: ch.01-3
title: تحفيز المشكلة والجبر الخطي والتمثيل
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translation-date: 05 Oct 2020
translator: Reem AlYami
---


<!--
## Resources

Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box.
-->

## المراجع
يرجى مراجعة حساب ألفريدو كنزياني [على تويتر @alfcnz](https://twitter.com/alfcnz). على سبيل المثال، بإمكانك إيجاد العديد من الفيديوهات والكتب بتفاصيل ذات علاقة بالجبر الخطي وتحليل القيم المنفردة (SVD) عن طريق كتابة `linear algebra (from:alfcnz)` في خانة البحث.

<!--
## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)
-->

## [التحولات والتحفيز](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

<!--
As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:
-->

كمثال تحفيزي دعونا ننظر لتصنيف الصور، لنفترض بأننا ألتقطنا صوره من كاميرا وضوحها ١  ميجابيكسل. هذه الصوره سوف تحتوي على مايقارب ١٠٠٠ بيكسل عامودي و١٠٠٠ بيكسل أفقي، وكل بيكسل مكون من ثلاث أبعاد لونيه: أحمر و أخضر وأزرق (RGB). وبالتالي كل صوره تعتبر كنقطه في فضاء ذو 3 ملايين بُعد. وبوجود حجم هائل من الأبعاد قد نريد تصنيف العديد من الصور المثيره للإهتمام -كتصنيف صورة القط *مقابل* صورة الكلب- ولكنها سوف تكون بنفس المنطقه في هذه الأبعاد.

لتصنيف هذه الصور بطريقه فعّاله علينا الأخذ بعين الإعتبار الطرق المختلفة لتحويل البيانات وتغيير موقع النقاط. علينا أن نتذكر أن في البعد الثنائي (2D) التحويل الخطي هو نفس ضرب المصفوفة. كمثال التحويل الخطي التالي:

<!--
-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections.
-->

-  الدوران (عندما تكون المصفوفة متعامدة).

-   التحجيم (عندما تكون المصفوفة قطرية).

-   الإنعكاس (عندما تكون المحددة سالبة).

-   القص.

مع ملاحظة أن عملية التحريك لوحدها لا تعد خطية لأن الصفر لا يناظر الصفر بعد العملية ولكن هو عباره عن تحويل تآلفي (affine transformation). والآن نعود لمثال الصوره الذي بدأنا به، حيث نقوم بتحويل نقاط البيانات بتحريكها لتصبح حول نقطة الصفر ونحجمها باستخدام المصفوفة القطرية وكأننا قمنا بعمل "تكبير" المنطقة. وأخيرا نستطيع عمل التصنيف عن طريق إيجاد خطوط عبر الفضاء حيث يقوم الخط بفصل النقاط المختلفة وتصنيفها بالشكل المناسب. بعبارة أخرى الفكرة هي إستخدام التحويل الخطي وغير الخطي لنقل تلك النقاط إلى فضاء جديد يسمح لنا بفصلها بواسطة خط مستقيم. هذه الفكره ستكون أكثر وضوحا خلال الأقسام التالية.

<!--
## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)
-->
## [تمثيل البيانات – فصل النقاط حسب اللون بإستخدام الشبكة](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

<!--
In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.
-->

في النموذج أدناه، لدينا خمس تفرعات لولبية لكل منها لون مختلف. توجد النقاط في فضاء ثنائي البعد ونستطيع تمثيلها بزوجين من الأرقام ويمثل اللون بُعدًا ثالثًا نستخدمه للتصنيف بين النقاط. وبعد ذلك نستطيع إستخدام الشبكة العصبية لفصل كل نقطة من النقاط بناءً على اللون.

<!--
| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
-->

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (أ) النقاط المدخلة، ما قبل الشبكة            |            (ب) النقاط المخرجة، ما بعد الشبكة            |

<center> شكل ١: لولب الألوان الخمسة  </center>

<!--
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one *vs.* all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities.
-->

تقوم الشبكة /"بتمديد/" نسيج الفضاء حتى نستطيع فصل كل نقطة إلى أجزاء فرعية مختلفة. عند التقارب للتنيجة نجد أن الشبكة قد فصلت كل لون إلى فضاء فرعي مختلف من المتشعب النهائي (manifold). بعبارة أخرى يمكن فصل كل لون في الفضاء الجديد فصله بشكل خطي عن طريق استخدام انحدار واحد *مقابل* عدة انحدارات. يمكن تمثيل المتجهات بالرسم التوضيحي عن طريق مصفوفه بحجم 2 $times$ 5، وضرب تلك المصفوفة بكل نقطة لاسترجاع درجة كل لون من الألوان الخمسة. حينئذ يمكن تصنيف النقاط باللون حسب درجات كل نقطة. تتكون المخرجات من خمسة عناصر، حيث يمثل كل منها لونًا ما، بينما تتكون المدخلات من عنصرين واحد للإحداثي السيني وآخر للإحداثي الصادي للنقاط. للتلخيص هذه الشبكة تأخذ نسيج الفضاء وتقوم بتشكيله باستخدام عدة مصفوفات يتلوها عمليات لاخطية.



<!--
### Network architecture
-->
### معمارية الشبكة

<!--
<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center>
-->

<center> <img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br> شكل ٢: هندسة الشبكة</center>

<!--
The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour.

-->

تربط المصفوفة الأولى المدخل ثنائي الأبعاد بطبقة خفية وسطية ذات ١٠٠ بعد. لدينا وبعد ذلك طبقة لاخطية ألا وهي دالة `ReLU`  وهي وحدة خطية مصححة، والتي تعبر ببساطة عن *الجزء الموجب* $(\cdot)^+$ من المعادلة. وليتم عرض الصورة بشكل رسومي نضيف طبقة التضمين (embedding layer) والتي تقوم بربط الطبقة الخفية المدخلة ذات الـ ١٠٠ بُعد بمخرج ثنائي الأبعاد. أخيرا يتم إسقاط طبقة التضمين على الطبقة ذات الأبعاد الخمسة في الشبكة، والتي تمثل قيمة لكل لون.


<!--
## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

The Jupyter Notebook can be found [here] (https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

-->

## [إسقاطات عشوائية – مفكرة جوبيتر](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)



مفكرة جوبيتر بالإمكان الوصول لها من [هنا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). للتمكن من تشغيل المفكرة عليك التأكد من تحميل بيئة `pDL`  كما هو موضح في [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

<!--
### PyTorch `device`
-->

### `جهاز` PyTorch

<!--
PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code:
-->

بالإمكان تشغيل PyTorch على كلاً من الـ CPU أو الـ GPU. يعد الـ CPU مناسبًا للمهام المتسلسلة بينما يناسب الـ GPU المهام المتوازية. قبل تنفيذ البرنامج على الجهاز المطلوب علينا التأكد من أن الموترات (tensors) والنماذج قد تم نقلها على ذاكرة الجهاز. بالإمكان عمل ذلك باستخدام هذين السطرين:


<!--
```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`.
-->


```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```
يعرف السطر الأول متغير يسمى `device` ويعنيه للـ GPU في حال توفره، أو للـ CPU كقيمة افتراضية. في السطر الثاني، يتم إنشاء الموتر ويرسل لذاكرة الجهاز عن طريق إستدعاء `to(device)`.



<!--
### Jupyter Notebook tip

To see the documentation for a function in a notebook cell, use `Shift + Tab.`
-->


### إرشادات مفكرة جوبيتر



للاطلاع على التعليمات الخاصة بدالة ما في أحد خلايا المفكرة اضغط `Shift + Tab`

<!--

### Visualizing linear transformations

Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation.

-->

### تصوير التحولات الخطية


تذكر أنه بالإمكان تمثيل التحويلات الخطية كمصفوفة عن طريق تحليل القيمة المنفردة، بإمكاننا تحليل هذه المصفوفة إلى ثلاث مصفوفات مكونة لها يمثل كلٌ منها تحولاً خطيًا مختلفًا.

<!--
$$
W=U\left[\begin{array}{cc}
s_{1} & 0 \\
0 & s_{2}
\end{array}\right] V^{\top}
$$
-->

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$



<!--
In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations.
-->

في المعادلة رقم (١) المصفوفتان $U$ و$V^\top$ متعامدتان ويمثلان تحولات الدوران والانعكاس. المصفوفة الوسطى قطرية وتمثل تحول في الحجم.

مثلنا التحولات الخطية للعديد من المصفوفات العشوائية في شكل ٣. لاحظ تأثير القيم الفردية على التحولات الناتجة.


تم إنشاء المصفوفات المستخدمة باستخدام Numpy ؛ وبالرغم من ذلك، يمكننا أيضًا استخدام فئة `nn.Linear` من PyTorch مع بقيمة `bias = False` لإنشاء تحويلات خطية.

<!--
| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figure 3:  Linear transformations from random matrices </center>
-->


| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (أ) النقاط الأساسية       |   (ب) $s_1$ = 1.540, $s_2$ = 0.304  |   (ج) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> شكل ٣: التحولات الخطية من المصفوفات العشوائية

</center>

<!--
### Non-linear transformations

Next, we visualize the following transformation:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Recall, the graph of $\tanh(\cdot)$ in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center>

The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center>

-->
### التحولات غير الخطية



لنقوم الآن بتمثيل التحول التالي


$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

تذكر رسمة  $\tanh(\cdot)$  في شكل ٤

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
الشكل ٤: الظل الزائدي غير الخطي
</center>

تقوم عدم الخطية بحد القيم ما بين -١ و +١ مشكلةً مربعًا. عندما تزداد قيمة s في المعادلة (٢) فإن ذلك يدفع النقاط أكثر فأكثر لأطراف المربع كما هو موضح في شكل ٥. يمكن ذلك الدفع للأطراف من إبعاد ا لنقاط عن بعضها البعض حتى نتمكن من تصنيفها.


| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (أ) اللاخطية مع $s=1$                 |                 (ب) اللاخطية مع $s=5$                  |

<center> الشكل ٥: التحولات غير الخطية </center>

<!--
### Random neural net

Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center>
-->

### الشبكات العصبية العشوائية




أخيرا وليس آخرا، نقوم بتمثيل التحولات التي حدثت باستخدام شبكه عصبيه بسيطة غير مدربة. الشبكة تتكون من طبقة خطية تقوم بتحليل تآلفي يعقب ذلك مماس زائدي للتعامل مع اللاخطية وأخيرا طبقة خطية أخرى. عند فحص التحول بالشكل ٦ نرى أنه مختلف عن التحولات الخطية وغير الخطية التي رأيناها مسبقا. سوف نرى كيف نجعل هذه التحولات التي تقوم بها الشبكات العصبية مفيدة لهدفنا النهائي ألا وهو التصنيف.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
الشكل ٦: التحول من شبكة عصبية غير مدربة
</center>
