---
lang-ref: ch.01-2
lang: ar
lecturer: Yann LeCun
title: تطور واستخدامات ال CNNs ولماذا التعلم العميق؟
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translation date: 20 Aug 2020
translator: Ahmed Shahin
---


## [تطور ال CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!--In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.-->

تتفاعل الخلايا العصبية في مخ الحيوان مع الحدود ذات اتجاه معين، وتكون مكررة في مجموعات تتفاعل مع ذات الاتجاه في كافة أنحاء مجال الرؤية.

<!-- Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling). -->

فوكوشيما (1982) قام بتصميم شبكة عصبية تعمل بنفس الطريقة التي يعمل بها المخ. اولاً، تتكرر الخلايا العصبية في مجال الرؤية. ثانياً، هناك خلايا معقدة تجمع المعلومات من الخلايا البسيطة (التي تستخلص المعلومات بناء على الاتجاه فقط). نتيجة لذلك، تحريك الصورة سيؤدي إلى تغيير تفعيل الخلايا البسيطة، لكن لن يؤثر على التفعيل النهائي للخلايا المعقدة (التجميع الالتفافي).

<!-- LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top. -->

استخدم لوكان (1990) الانتشار الخلفي لتدريب الشبكات العصبية الالتفافية (CNN, Convolutional Neural Network) للتعرف على الأرقام المكتوبة بخط اليد. يوجد عرض تجريبي من 1992 يظهر أن الخوارزمية قادرة على التعرف على الأرقام المكتوبة بأي أسلوب. امكانية التعرف على الأرقام باستخدام نموذج مدرب كلياً كان سبقاً جديداً في هذا الوقت. قبل ذلك، مستخرجات الخصائص كانت تستخدم اولاً، ثم يتم اضافة نموذج على الخصائص المستخلصة بعد ذلك.

<!-- These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present. -->

نظم الـ CNN الجديدة كان لها القدرة على التعرف على أنماط/حروف متعددة في الصورة في نفس الوقت. لفعل ذلك، كان الناس يستخدمون نافذة صغيرة من الصورة كمدخل للـ CNN. تقوم تلك النافذة بمسح كل أجزاء الصورة. اذا تم تفعيل النافذة، هذا يعني ان هناك حرف/نمط ما موجود في هذا الجزء من الصورة.

<!-- Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking. -->

لاحقاً، تم تطبيق هذه الفكرة علي التعرف علي الوجوه/الأشخاص وتنفيذ عمليات التقسيم الدلالي (تصنيف كل بيكسل في الصورة على حدة). أمثلة على ذلك تتضمن هادسيل (2009) وفارابت (2012). انتشرت تطبيقات على ذلك في الصناعة، واستخدمت في تطبيقات القيادة الآلية للسيارات مثل تعقب خطوط الطريق.

<!-- Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again. -->

انواع خاصة من المعدات تستخدم في تدريب الCNN كانت محل اهتمام الباحثين في الثمانينات، ولكن سرعان ما قل هذا الاهتمام، ثم عاد مرة أخرى لاحقاً.

<!-- The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% *vs.* 16.4% top-5 error rate. -->

بدأت ثورة التعلم العميق (رغم أن هذا المصطلح لم يكن مستخدمًا في ذلك الوقت) ما بين 2010 الى 2013. قام الباحثون بالتركيز على ابتكار خوارزميات قادرة على تدريب شبكات CNN ضخمة بصورة أسرع. كريزيفسكي (2012) قدم شبكة AlexNet، التي كانت أضخم بكثير من كل الشبكات المستخدمة من قبل، وتم تدريبها علي قاعدة بيانات ImageNet التي تحتوي على 1.3 مليون صورة باستخدام ال GPUs. بعد التدريب لمدة أسبوعين، شبكة AlexNet كانت قادرة علي هزيمة أفضل النظم والخوارزميات المنافسة بفارق كبير -- معدل خطأ على افضل خمس توقعات 16.4% مقابل 25.8%.

<!-- After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs. -->

بعد رؤية النجاح الذي حققته شبكة AlexNet، اقتنع مجتمع رؤية الحاسب بقدرة شبكات الCNN على العمل بصورة جيدة. في حين أن كل الاوراق البحثية في الفترة من 2011 الى 2012 التي كانت تستخدم ال CNNs كان يتم رفضها، بداية من 2016 غالبية الأوراق المقبولة في الرؤية بالحاسب كانت تستخدم الـ CNNs.

<!-- Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster. -->

علي مر السنين، ازداد عدد الطبقات المستخدمة: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. ولكن يجب التنازل عن ميزة للحصول على أخرى: عدد العمليات للحصول على النتيجة المطلوبة، وحجم النموذج ودقته. بناءً على ذلك، أحد الموضوعات البحثية المنتشرة حالياً هو كيفية ضغط وتقليل حجم الشبكات لتنفيذ العمليات بشكل أسرع.

<!-- Deep Learning and Feature Extraction -->

## [التعلم العميق واستخلاص الخصائص](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

<!-- Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy, combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature. -->

أظهرت الشبكات متعددة الطبقات نجاحاً بسبب قدرتها علي استغلال الهيكل التركيبي للبيانات الطبيعية. تشكل مجموعة العناصر في طبقة معينة عنصرًا جديدًا في الطبقة التالية بتركيبات هرمية. إذا قمنا بمحاكاة هذا التسلسل الهرمي كمجموعة من الطبقات وتركنا للشبكة مهمة استخلاص وتعلم الخصائص المناسبة لذلك، نكون قد كوننا ما يعرف بنموذج التعلم العميق. ومن هنا يمكن القول أن شبكات التعلم العميق هي شبكات هرمية.

<!-- Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement. -->

معماريات التعلم العميق كانت السبب في تقدم غير مسبوق في تطبيقات الرؤية بالحاسب بدايةً من التعرف على العناصر في الصور وتحديد أماكنها بدقة، وصولاً إلى تحديد خصائص مكانية للعنصر المراد التعرف عليه في الصورة. معماريات مثل Mask-RCNN وRetinaNet كان لها دور كبير في هذا التطور.

<!-- Mask RCNNs have found their use in segmenting individual objects, *i.e.* creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, *i.e.* identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source. -->

تستخدم المعماريات المبنية علي Mask-RCNN في تجزئة العناصر، حيث تنشئ غطاء لكل نوع من العناصر في الصورة. في هذه النماذج، المدخلات المخرجات عبارة عن صور. يمكن أيضًا أن يستخدم النموذج لتجزئة المثيل، بمعنى تحديد عناصر مختلفة ولكن من ذات النوع في أي صورة. ديتيكترون Detectron هو أحد النظم التي تم تطويرها في فيسبوك للذكاء الاصطناعي، يوفر هذا النظام تصاميم مفتوحة المصدر لكافة هذه النماذج الحديثة في مجال الكشف عن عناصر الصورة.

<!-- Some of the practical applications of CNNs are powering autonomous driving and analysing medical images. -->

بعض التطبيقات العملية لل CNNs يتم توظيفها في القيادة الآلية، وتحليل الصور الطبية.

<!-- Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work? -->

علي الرغم من أن الخلفية العلمية والرياضية للتعلم العميق لم يتم فهمها بشكل كامل، إلا أنه مازال هناك بعض الاسئلة البحثية الجديرة بالاهتمام التي تتطلب المزيد من الدراسة، منها: لماذا أداء النماذج متعددة الطبقات افضل، مع العلم أنه يمكننا تقريب أي دالة رياضية بطبقتين فقط؟ لماذا تعمل شبكات الـ CNN بشكل جيد مع البيانات الطبيعية مثل الكلام، الصور، والنصوص؟ كيف يمكننا تحسين الدوال الغير محدبة non-convex بهذا الشكل الجيد؟ عملياً، وجدنا أنه حتى النماذج التي تحتوي عدد من المتغيرات اكثر من اللازم تعمل بشكل مقبول، لماذا؟

<!-- Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes. -->

يتضمن استخلاص الخصائص نقلها إلى أبعاد أعلى، حيث عادة يمكن فصلها خطياً في تلك الأبعاد العالية بسبب زيادة عدد مستويات الفصل الممكنة في الأبعاد الأعلى.

<!-- Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:

- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines -->

ممارسو تعلم الآلة في العصور السابقة كانوا يستخلصون خصائص عالية الجودة بطرق يدوية. هذه الخصائص عادةً ما تكون مرتبطة بالمهمة المراد تنفيذها. بعد ذلك، يتم استخدام هذه الخصائص في نماذج الذكاء الاصطناعي. ولكن، ومع قدوم التعلم العميق، أصبحت النماذج قادرة على استخلاص خصائص عامة (غير مرتبطة بمهمة معينة) بصورة آلية. بعض الأساليب المشهورة في خوارزميات استخلاص الخصائص هي:

- تغطية فضاء المعلومات
- الإسقاطات العشوائية
- المصنفات متعددة الحدود
- دوال القواعد الشعاعية
- آلات النووية

<!-- Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example: -->

بسبب الطبيعة التركيبية للمعلومات، الخصائص المستخلصة لها تمثيلات هرمية ذات مستوى متصاعد من التجريد. علي سبيل المثال:

<!-- -  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image. -->

- الصور - على أصغر وأدق نطاق، يمكن التفكير فيها كمجموعة من النقاط. تجميع هذه النقاط مع بعضها البعض ينتج حواف، تجميع الحواف ينتج عناصر متعددة الحواف، تجميع هذه العناصر ينتج أشكال غير منتظمة والتي بدورها تكون جزء من الصورة، تجميع مجموعة من هذه الأشكال ينتج الصورة كما نراها.

<!-- -  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed. -->

- النصوص - بنفس الطريقة، هناك هرمية متأصلة في المعلومات النصية. الحروف تكون كلمات، الكلمات تكون جمل، والجمل تكون النص الذي يحكي القصة المراد حكايتها.

<!-- -  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation. -->

- الكلام - الأصوات تكون نغمات ثم حروف ثم كلمات ثم جمل. ومن هنا نرى هرمية واضحة في تمثيل الكلام.

<!-- Learning representations -->

## [تعلم التمثيلات](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

<!-- There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more? -->

هناك بعض الناس الذين يرفضون التعلم العميق: اذا كنا نستطيع تمثيل أي دالة باستخدام طبقتين فقط، لم الحاجة إلى طبقات كثيرة؟

<!-- For example: SVMs find a separating hyperplane "in the span of the data", meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in $N$ (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to $\log(N)$, the layers become linear in $N$. There is a trade-off between time and space. -->

علي سبيل المثال، نماذج المتجهات المتوازية (SVMs, Support Vector Machines) تبحث عن مستوي فاصل للمعلومات، بمعنى أن النتائج سوف تعتمد على المقارنة مع المعلومات المستخدمة في عملية التدريب. SVMs شبكة عصبية بسيطة مكونة من طبقتين، الطبقة الأولى تقوم بتعريف القوالب، والثانية هي مصنِف خطي. المشكلة في مغالطة الطبقتين، هي أن حجم ومدى تعقيد الطبقة الوسطى ينمو كدالة أسية، وهو ما يعني أنه للحصول على أداء جيد في مهمة أكثر صعوبة، يستلزم الأمر عمل عدد قوالب كثيرة جداً. بينما اذا قمنا بزيادة عدد الطبقات يصبح التناسب خطياً بدلاً من التناسب الاسي. هناك دائماً موائمة بين الوقت والمساحة المطلوبة.

<!-- An analogy is designing a circuit to compute a boolean function with no more than two layers of gates -- we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions. -->

مثال مشابه لذلك يظهر في تصميم الدوائر الكهربية لحساب دالة منطقية بطبقتين من البوابات -- يمكننا حساب **أي دالة منطقية** بطبقتين فقط! ولكن، تعقيد وعدد البوابات المستخدمة في الطبقة الأولى سرعان ما يصبح غير منطقي للدوال المعقدة.

<!-- What is "deep"? -->

ما معنى "عميق"؟

<!-- - An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity** -->

- ال SVM غير عميق ﻷنه يحتوي فقط على طبقتين
- شجرة التصنيف غير عميقة ﻷن كل طبقة تعالج نفس مجموعة الخصائص الاصلية
- الشبكة العميقة لها طبقات عديدة وتستخدمهم لبناء **هرمية من الخصائص متزايدة التعقيد**

<!-- How can models learn representations (good features)? -->

كيف يمكن للنماذج تعلم تمثيلات (خصائص جيدة)؟

<!-- Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*). -->

فرضية المعلومات متعددة الخصائص: المعلومات الطبيعية لها خصائص متعددة ومتشعبة في فضاء منخفض الأبعاد. مجموعة الصور الممكنة تحتوي عدد لا نهائي من الصور، مجموعة الصور "الطبيعية" هي جزء صغير منها. علي سبيل المثال: صورة شخص، مجموعة الصور الممكنة يتغير بعدد عضلات الوجه التي يمكن لهذا الشخص تحريكها، ومن ثم تغيير الصورة (تقريباً 50). مستخلص الخصائص المثالي (والغير واقعي) يمثل كل عوامل التغيير الممكنة (عضلات الوجه، مستوي الاضاءة، الخ).


<!-- Q&A from the end of lecture:

- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not -->

أسئلة وإجابات من نهاية المحاضرة:

- فيما يتعلق بمثال الوجه، هل يمكن لتقنيات تقليل الابعاد الاخرى *(علي سبيل المثال محلل الأبعاد الأساسية Principal Component Analysis, PCA)* استخلاص كل هذه الخصائص؟
- الاجابة: سوف يعمل فقط إذا كان مستوي الخصائص عالي الأبعاد، وهو ما لم يحدث هنا.
