---
lang: ar
lang-ref: ch.01-1
lecturer: Yann LeCun
title: الدافع وراء التعلم العميق، تاريخه، وإلهامه
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 19 Sep 2020
translator: Haya Alsharif
---

<!-- 
## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s) 
-->

## [خطة الدورة](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s) 

<!-- 
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
 -->

- أساسيات التعلم بالخبرة، الشبكات العصبية، التعلم العميق
- الانتشار الخلفي، والمكونات البنائية  
- الشبكات العصبية الالتفافية وتطبيقاتها
- المزيد من نماذج التعلم العميق
- حيل للتنظيم / حيل للتحسين / فهم كيفية عمل التعلم العميق
- النماذج المبنية على مفهوم الطاقة
- التعلم بالإشراف الذاتي وما بعده

<!-- 
## Inspiration of Deep Learning and its history
 -->

## الإلهام وراء التعلم العميق وتاريخه

<!-- On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.

The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work. -->
مفهوم التعلم العميق مستوحى من الدماغ، ولكن ليست كل تفاصيل الدماغ ذات علاقة. يمكن مقارنة ذلك بالطائرات المستوحاة من الطيور. مبدأ الطيران هو نفسه ولكن التفاصيل مختلفة للغاية. 

يعود تاريخ التعلم العميق إلى مجال أصبح اسمه الآن علم الـ cybernetics أي علم التحكم الآلي. بدأ هذا العلم في الأربعينيات مع McCulloch وPitts، حيث توصلوا إلى فكرة أن الخلايا العصبية هي وحدات ذات قيم محدودة وحالتي تشغيل وإيقاف. يمكنك بناء دائرة منطقية (boolean) من خلال ربط تلك الخلايا مع بعضها البعض وإجراء استدلال منطقي. إن الدماغ في الأساس هو آلة استدلال منطقي لأن الخلايا العصبية ثنائية القيمة (binary). تقوم الخلايا العصبية بحساب مجموعًا موزونًا للمدخلات وتقارنه بالحد الأدنى: إذا كانت القيمة أعلى من الحد الأدنى فإن الخلايا العصبية تبدأ في العمل، أم إذا كانت أقل من ذلك، فإنها تتوقف. وهذا شرح مبسط لكيفية عمل الشبكات العصبية.

<!-- In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.

Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.

In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.

Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are: -->

في عام 1947، وردت لدونالد هب فكرة أن الخلايا العصبية في الدماغ تتعلم من خلال تعديل قوة الروابط بين الخلايا العصبية، وهو ما يسمى بالتعلم المفرط: إذا تم تشغيل خليتين عصبيتين معًا، فإن الاتصال المرتبط بينهما يزيد، أما إذا لم يعملا معًا ، فإن الاتصال يقل. 

في وقت لاحق من عام 1948، اقترح نوربرت وينر علم الـ cybernetics، والذي يقوم على فكرة أنه من خلال امتلاك أنظمة مزودة بأجهزة استشعار ومشغلات، يكون لديك حلقة تغذية مرتدة feedback loop ونظام ينظم نفسه ذاتيا self-regulatory system. كافة قواعد ردود فعل السيارة تأتي من هذا العمل.

في عام 1957، اقترح فرانك روزنبلات خوارزمية الـ Perceptron، وهي خوارزمية تعليمية تعدل أوزان الشبكات العصبية البسيطة جدًا. 

بشكل عام، وُلدت فكرة بناء آلات فكرية تحاكي الخلايا العصبية في الأربعينيات من القرن الماضي، ثم انطلقت في الخمسينيات من القرن الماضي، وانتهت تمامًا في أواخر الستينيات. الأسباب الرئيسية لانقراض هذا الحقل من الأبحاث في عام 1960 هي:

<!--- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons. -->

- استخدم الباحثون الخلايا العصبية ثنائية القيمة. ومع ذلك، فإن طريقة عمل الانتشار الخلفي للأخطاء (backpropagation) هو استخدام دالة تفعيل متصلة (continuous activation functions). في ذلك الحين، لم يكن لدى الباحثين فكرة استخدام الخلايا العصبية المتصلة ولم يعتقدوا أنهم يستطيعون التدريب باستخدام الانحدارات (gradients) لأن الخلايا العصبية ثنائية القيمة ولا يمكن اشتقاقها.
- استخدام خلايا عصبية متصلة تتطلب أن يقوم المرء بحساب حاصل ضرب دالة تفعيل الخلية بوزن ما للحصول على مساهمة تلك القيمة في المجموع الموزون. ولكن قبل عام 1980 كانت عملية ضرب عددين وخاصة أعداد الفاصلة العائمة (floating-point numbers) بطيئة للغاية مما أدى إلى تجنب استخدام الخلايا العصبية المتصلة.


<!--Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->

انطلق التعلم العميق مرة أخرى في عام 1985 مع ظهور الانتشار الخلفي للأخطاء. في عام 1995، توقف المجال مرة أخرى وتخلّى مجتمع التعلم الآلي عن فكرة الشبكات العصبية. في أوائل عام 2010، بدأ الناس في استخدام شبكات الخلايا العصبية للتعرف على الكلام وحصل تحسن كبير في الأداء، وبعد ذلك انتشرت شبكات الخلايا العصبية على نطاق واسع في المجال التجاري. في عام 2013، بدأ مجال رؤية الكمبيوتر (computer vision) يالتحول إلى استخدام الشبكات الخلايا العصبية. وحدث نفس الانتقال في مجال معالجة اللغة الطبيعية (natural language processing) في عام 2016. وقريباً، ستحدث ثورات مماثلة في مجال الروبوتات والتحكم والعديد من المجالات الأخرى.

<!--
### Supervised Learning
-->

### التعلم بالإشراف

<!--$90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.
-->

90 $\%$ من تطبيقات التعلم العميق تستخدم التعلم بالإشراف (Supervised Learning). في هذا النوع من التعلم نقوم من خلاله بجمع مجموعة من المدخلات والمخرجات. يتم إدخال المدخلات في آلة لمعرفة المخرجات. عندما تكون المخرجات صحيحة، لا نقوم بأي شيء. ولكن إذا كان المخرج خاطئًا ، يمكنك تعديل معاملات الجهاز وتصحيحها للحصول على النتيجة المطلوبة. السؤال هنا هو كيف يمكننا تحديد الاتجاه ومقدار تعديل هذه المعاملات، وهذا يعود  بنا إلى موضوع حساب الانحدارات والانتشار الخلفي.

<!--Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->

التعلم بالإشراف ينبع من مفهومي الـ Perceptron و الـ Adaline. يقوم مفهوم Adaline على نفس النموذج مع مدخلات موزونة: عندما تكون أعلى من الحد الأدنى يتم تشغيلها، ولكن إذا كانت أقل منه فتتوقف عن العمل. في حين أن مفهوم الـ Perceptron يستخدم لوصف الشبكة العصبية المكونة من طبقتين حيث تكون الطبقة الثانية قابلة للتدريب والطبقة الأولى ثابتة. في معظم الأحيان ، يتم تحديد الطبقة الأولى بشكل عشوائي وهذا ما يسمونه الطبقات الترابطية (associative layers).

<!--
## [History of Pattern Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)
-->

## [تاريخ التعرف على الأنماط ومقدمة في الإنحدار التدريجي](https://www.youtube.com/watch؟v=0bMe_vCZo30&t=1461s) 

<!--The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.
-->

ما سبق هو الأساس لمفهوم التعرف على الأنماط (pattern recognition) قبل تطور مجال التعلم العميق. يتكون نموذج التعرف على الأنماط عادة من مستخرج للخواص المميزة والمصنف القابل للتدريب. يتم إدخال المدخلات في مستخرج الميزات لاستخراج الخصائص المفيدة من المدخلات مثل اكتشاف العين عندما يكون الغرض هو التعرف على الوجه. بعد ذلك، يتم تغذية متجه الصفات المميزة إلى المصنف القابل للتدريب لحساب المجموع الموزون ومقارنته بالحد الأدنى. يمكن أن يكون المصنف القابل للتدريب عبارة عن perceptron أو شبكة عصبية (neural network) واحدة. ولكن تكمن المشكلة في أنه يجب تصميم مستخرج الميزات يدويًا. مما يعني أن التعرف على الأنماط / رؤية الكمبيوتر يركز على مستخرج الميزات مع الأخذ في الاعتبار كيفية تصميمه لمشكلة معينة، ولا يهتم كثيرًا ببناء مُصنف قابل للتدريب.

<!--After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.
-->

بعد ظهور التعلم العميق وتطوره، تغيرت العملية المكونة من مرحلتين إلى عدد متسلسل من الوحدات. تحتوي كل وحدة على معاملات غير خطية وقابلة للضبط. تلك المعاملات يتم جمعها وبناء عدد من الطبقات منها. هذا هو سبب تسميته "التعلم العميق". السبب في استخدام معاملات غير خطية بدلاً من الخطية هو أن كل طبقتين خطيتين يمكن أن تكونا طبقة خطية واحدة لأن حاصل تركيب عمليتين خطيتين هي عملية خطية أيضًا.

<!--The simplest multi-layer architecture with tunable parameters and nonlinearity could be: the input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix whose coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.
-->

قد يكون أبسط نموذج متعددة الطبقات مع معاملات غير خطية وقابلة للضبط هو الآتي: يتم تمثيل المدخلات كمتجه مثل صورة أو صوت. يتم ضرب هذا الإدخال في مصفوفة الأوزان التي تكون معاملاتها قابلةً للضبط. بعد ذلك، يتم تمرير كل متجه ناتج عبر دالة غير خطية مثل ReLU. بتكرار هذه العملية تتكون لدينا شبكة عصبية أساسية. السبب وراء تسميتها بالشبكة العصبية هو أن هذه البنية تعمل على حساب المجموع الموزون للمدخلات مقابل صفوف المصفوفة.

<!--Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is the loss, computing a distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.
-->

بإمكاننا الآن العودة إلى موضوع التعلم بالإشراف، حيث نقارن الناتج من العملية مع المخرجات التي نهدف الوصول لها، ثم نحسن من دالة الهدف (objective function) وفي مقدار الخسارة، أي المسافة/العقوبة/الاختلاف بين النتيجة والهدف. ثم نحسب متوسط ​​دالة التكلفة هذه على كافة بيانات التدريب. هذا هو الهدف الذي نريد تقليله. بمعنى آخر، نريد إيجاد قيمة معاملات تقلل قيمة هذا المتوسط.

<!--The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.
-->

يمكننا التقليل من قيمة المتوسط عن طريق حساب الانحدار. على سبيل المثال، إذا فقدنا الطريق فوق جبل ناعم في ليلة ضبابية وأردنا الذهاب إلى القرية في الوادي. يمكن أن تكون إحدى الطرق هي الالتفاف ومعرفة الطريقة الأكثر انحدارًا هي النزول ثم اتخاذ خطوة صغيرة للأسفل. هذا الاتجاه هو انحدار (سلبي). كل ذلك يعد صحيحًا بعد افتراض أن الوادي محدب، وأنه بالإمكان الوصول إلى الوادي.

<!--The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->

الطريقة الأكثر فعالية تسمى الانحدار التدريجي العشوائي (Stochastic Gradient Descent) واختصارها SGD. نظرًا لأننا نريد تقليل متوسط ​​الخسارة خلال مجموعة التدريب، فإننا نأخذ عينة واحدة أو مجموعة صغيرة من العينات ونحسب الخطأ، ثم نقوم بعملية الانحدار التدريجي. بعد ذلك ، نأخذ عينة جديدة والتي ينتج عنها قيمة جديدة للخطأ، ثم نعيد عملية الانحدار والذي قد تكون في اتجاه آخر مختلف. اثنان من الأسباب الرئيسية لاستخدام SGD هو أنه يساعد النموذج على الوصول للقيمة المطلوبة سريعًا إذا كانت مجموعة التدريب كبيرة جدًا، كما يؤدي إلى التعميم بشكل أفضل، مما يعني الحصول على أداء مشابه ولكن على مجموعات آخرى من البيانات.

<!--
### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)
-->

### [حساب التدرجات بواسطة الانتشار الخلفي](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!--Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:
-->

حساب التدرجات عن طريق الانتشار الخلفي هو تطبيق عملي لقاعدة السلسلة (chain rule). معادلة الانتشار الخلفي لانحدار المدخلات هي كالآتي:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

<!--The backpropagation equation for the weight gradients is as follows:
-->

معادلة الانتشار الخلفي لتدرجات الوزن كما يلي:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!--Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.
-->

لاحظ أنه بدلاً من المدخلات العددية، ستكون المدخلات عبارة عن متجهات، أو بشكل عام، مدخلات متعددة الأبعاد. يسمح لك الانتشار الخلفي بحساب مشتقة الفرق في المخرجات التي تريدها والمخرجات التي تحصل عليها (وهي قيمة دالة الهدف) مقابل أي قيمة من داخل الشبكة. أخيرًا، يعد الانتشار الخلفي ضروريًا لأنه ينطبق على طبقات متعددة.

<!--It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->

من المهم النظر في كيفية تفسير المدخلات. على سبيل المثال، قد تتطلب الصورة 256$$\times$$256 مصفوفة قيمتها 200,000. هذه مصفوفات تعد ضخمة وستحتاج طبقات الشبكة العصبية للتعامل معها. ولكن من غير العملي استخدام مثل هذه المصفوفات. لذلك، من المهم وضع فرضية حول بنية المصفوفة.

<!--
## Hierarchical representation of the Visual Cortex
-->

## التمثيل الهرمي للقشرة المرئية

<!--Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.
-->

وضحت لنا تجارب فوكوشيما كيفية تفسير دماغنا للمدخلات إلى أعيننا. باختصار، حيث اكتشف بأن الخلايا العصبية الموجودة في مقدمة شبكية العين تقوم بالضغط على المدخلات (المعروفة باسم contrast normalization) وتنتقل الإشارة من أعيننا إلى الدماع. ثم تتم معالجة الصورة على مراحل، ويتم تنشيط بعض الخلايا العصبية لفئات معينة. وبالتالي، فإن القشرة البصرية تتعرف على الأنماط بطريقة هرمية.

<!--Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (*e.g.* vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->

التجارب التي قام فيها الباحثون بدس أقطاب كهربائية في مناطق معينة من القشرة البصرية وتحديداً منطقة V1  التي جعلت الباحثين يدركون أن بعض الخلايا العصبية تتفاعل مع عناصر معينة ضمن مساحة ضيقة جدًا من المجال البصري، ولاحظوا أمرًا مماثلاً مع الخلايا العصبية المجاورة والمناطق المحيطة في المجال البصري. بالإضافة إلى ذلك، وجد الباحثون بأن الخلايا العصبية التي تتفاعل مع نفس المجال البصري، تتفاعل أيضًا مع أنواع مختلفة من الحواف بطريقة منظمة (على سبيل المثال، الحواف الرأسية أو الأفقية). من المهم أيضًا التنويه بنظرية أن العملية المرئية هي في الأساس عملية تغذية أمامية (feed forward). وبالتالي ، تتم عملية التعرف والإدراك بشكل سريع بدون بعض عمليات الاتصال المتكررة.
