String.prototype.trim = function() {
    return this.replace(/^\s+|\s+$/g,"");
}

String.prototype.count=function(s1) { 
	return (this.length - this.replace(new RegExp(s1,"g"), '').length) / s1.length;
}

String.prototype.repeat = function(l){
	return new Array(l+1).join(this);
};

function _form_collect_data(thisform) {
    var s_data = "";
    for (var i = 0; i < thisform.elements.length; i++) {
    	if (typeof(FCKeditorAPI) != "undefined" && 
    			typeof(FCKeditorAPI.GetInstance(thisform.elements[i].name)) != "undefined") {
    		s_data += "&" + thisform.elements[i].name + "=" + encodeURIComponent(FCKeditorAPI.GetInstance(thisform.elements[i].name).GetXHTML());
    	} else {
	    	if (thisform.elements[i].tagName.toLowerCase() == "input" && 
	    			(thisform.elements[i].type.toLowerCase() == "checkbox" || thisform.elements[i].type.toLowerCase() == "radio") && 
	    			!thisform.elements[i].checked) {
	    		continue;
	    	} else if (thisform.elements[i].tagName.toLowerCase() == "select") {
	    		for (var j = 0; j < thisform.elements[i].options.length; j++) {
	    			if (thisform.elements[i].options[j].selected) {
	    				s_data += "&" + thisform.elements[i].name + "=" + encodeURIComponent(thisform.elements[i].options[j].value);
	    			}
	    		}
	    	} else {
	    		s_data += "&" + thisform.elements[i].name + "=" + encodeURIComponent(thisform.elements[i].value);
	    	}
    	}
    }
    return s_data.substring(1);
}

function _ajax_submit(thisform, fn_success, fn_failure) {
    // This function require Prototype library
    //var thisform_id = thisform.id;
    $.ajax({
        type: "POST",
        url: thisform.action,
        data: _form_collect_data(thisform),
        success: fn_success,
        error: fn_failure
    });
}

function _ajax_request(module, action, params, fn_success, fn_failure) {
    // This function require Prototype library
    var url = "index.php?_m=" + module + "&_a=" + action + "&_r=_ajax";
    // Reform query string
    for (key in params) {
       url += "&" + key + "=" + params[key];
    }
    
    $.ajax({
        type: "GET",
        url: url,
        success: fn_success,
        error: fn_failure
    });
}

function _eval_json(s_json) {
    if (s_json.trim().length == 0) return false;
    return eval("(" + s_json + ")");
}

function random_str(len) {
    var chars = "abcdefghijklmnopqrstuvwxyz" 
        + "ABCDEFGHIJKLMNOPQRSTUVWXYZ" 
        + "1234567890";
    var idx = 0;
    var random_s = "";
    
    len = parseInt(len);
    if (!len || len == "NaN" || len < 6) {
        len = 6;
    }
    for (var i = 0; i < len; i++) {
        idx = Math.floor(Math.random() * chars.length);
        random_s += chars.substr(idx, 1);
    }
    
    return random_s;
}

function show_inline_win(load_url, title_txt, w_width, w_height) {
    if (!title_txt) title_txt = "";
    if (!w_width) w_width = 640;
    if (!w_height) w_height = 480;
    load_url += "&width=" + w_width;
    load_url += "&height=" + w_height;
    
    tb_show(title_txt, load_url, false);
}

function show_iframe_win(load_url, title_txt, w_width, w_height) {
    if (!title_txt) title_txt = "";
    if (!w_width) w_width = 640;
    if (!w_height) w_height = 480;
    load_url += "&width=" + w_width;
    load_url += "&height=" + w_height;
    //load_url += "&modal=true";
    load_url += "&TB_iframe=true";
    
    tb_show(title_txt, load_url, false);
}

function show_iframe_win_n_modal(load_url, title_txt, w_width, w_height) {
    if (!title_txt) title_txt = "";
    if (!w_width) w_width = 640;
    if (!w_height) w_height = 480;
    load_url += "&width=" + w_width;
    load_url += "&height=" + w_height;
    load_url += "&TB_iframe=true";
    
    tb_show(title_txt, load_url, false);
}

function show_imgpicker(img_id) {
	var picker_url = "index.php?_m=mod_media&_a=image_picker&imgid=" + img_id;
    show_iframe_win_n_modal(picker_url, "Choose Image", 380, 60);
}

function show_flvpicker(flv_id) {
	var picker_url = "index.php?_m=mod_media&_a=flash_picker&flvid=" + flv_id;
    show_iframe_win_n_modal(picker_url, "Choose Flash", 380, 60);
}

function save_position(thisform, fn_success, fn_failure) {
    _ajax_submit(thisform, fn_success, fn_failure);
}

function _reform_url(url, q_extra) {
    var q_hash = Array();
    var url_parts = url.split(/#/);
    var anchor = url_parts[1];
    var q_new = "";
    
    // Parse query string
    url_parts = url_parts[0].split(/\?/);
	if (url_parts[1] != "undefined") {
	    var queries = url_parts[1].split(/&/);
	    for (var i in queries) {
	        q_parts = queries[i].split(/=/);
	        q_hash[q_parts[0]] = q_parts[1];
	    }
	}
	for (q_key in q_extra) {
	    q_hash[q_key] = q_extra[q_key];
	}
	
	// Reform query string
	for (q_key in q_hash) {
	   q_new += "&" + q_key + "=" + q_hash[q_key];
	}
	
	return url_parts[0] + "?" + q_new.substr(1) + "#" + anchor;
}

function goto(url, q_extra) {
	window.location.href = _reform_url(url, q_extra);
}

function reloadPage() {
    window.location.reload();
}

function reloadParent() {
    window.parent.location.reload();
}

function goto_d(url) {
    window.location.href = url;
}

function parent_goto_d(url) {
    window.parent.location.href = url;
}

function confirm_r(module, action, params, fn_success, fn_failure, message) {
	if (confirm(message)) {
		_ajax_request(module, action, params, fn_success, fn_failure);
	}
}

function remove_block(mb_id,mb_lang) {
	confirm_r('mod_tool', 'rm_mblock', {mb_id:mb_id}, 
			rmblock_success, rmblock_failure, mb_lang=='zh_CN'?"您确认删除该模板吗?":"Delete the module block");
}

function rmblock_success(response) {
    var o_result = _eval_json(response);
    if (!o_result) {
        return rmblock_failure(response);
    }
    
    if (o_result.result == "ERROR") {
        alert(o_result.errmsg);
        return false;
    } else if (o_result.result == "OK") {
	    miss_block(o_result.dom_id);
    } else {
        return rmblock_failure(response);
    }
}

function rmblock_failure(response) {
    alert("Request failed!");
    return false;
}

function miss_block(dom_id) {
	if (typeof(document.getElementById(dom_id)) != 'undefined') {
		$("#" + dom_id).hide("normal");
	}
}

function resizeImg(el, maxwidth) {
    if (!maxwidth) {
        maxwidth = 280;
    }
    
	if (el.width > maxwidth) {
		el.height = el.height / el.width * maxwidth;
		el.width = maxwidth;
	}
}

function totop() {
    window.scroll(0,0);
}

function changePic(isTrue,id,url)
{
	$.ajax({
		type:"POST",
		url:url,
		beforeSend:function(data){
			$("#"+id).attr('src','template/images/loader.gif');
		},
		success:function(data){
			if(data == 1)
			{
				$("#"+id).attr('src','template/images/yes.gif').attr('alt','Yes');
			}
			else
			{
				$("#"+id).attr('src','template/images/no.gif').attr('alt','No');
			}
		},
		error:function(data){
			$("#"+id).attr('src','template/images/warning.gif');
		}
	});
}

function menuCollapse()
{
	if(findCookie("collapseStatus=") == 'extend')
	{
		$("#menu_collapse").hide(1000);
		document.cookie = 'collapseStatus=collapse';
	}
	else
	{
		$("#menu_collapse").show(1000);
		document.cookie = 'collapseStatus=extend';
	}
}

function menuToolCollapse()
{
	if(findCookie("collapseMenuToolStatus=") == 'menuToolExtend')
	{
		$("#menu_tool").hide("slow");
		document.cookie = 'collapseMenuToolStatus=menuToolCollapse';
	}
	else
	{
		$("#menu_tool").show("slow");
		document.cookie = 'collapseMenuToolStatus=menuToolExtend';
	}
}

function menuSystemCollapse()
{
	if(findCookie("collapseMenuSystemStatus=") == 'menuSystemExtend')
	{
		$("#menu_system").hide("slow");
		document.cookie = 'collapseMenuSystemStatus=menuSystemCollapse';
	}
	else
	{
		$("#menu_system").show("slow");
		document.cookie = 'collapseMenuSystemStatus=menuSystemExtend';
	}
}

function findCookie(search)
{
	var cookieValue;
	if (document.cookie.length > 0)
	{
		offset = document.cookie.indexOf(search)
	    if (offset != -1)
	    {
	         offset += search.length ;
	         end = document.cookie.indexOf(";", offset)
	         if (end == -1)
	            end = document.cookie.length;  
	         cookieValue = unescape(document.cookie.substring(offset, end))
	    }
		return cookieValue;
	 }
	else
	{
		return false;
	}
}

function select_for_menu_item(text, id) {
    window.top.show_selected(text);
    window.top.set_tmp_id(id);
    window.top.tb_remove();
}

function clickCheckbox()
{
	var uid;
	uid = $('#uid').val();
	
	$.ajax({
        type: "GET",
        url: "index.php?_m=mod_wizard&_a=admin_wizard&_r=_ajax&action=wizard&uid="+uid,
        success:function(msg){
		//alert(msg);
		},
		error:function(msg){
			//alert(msg);
		}
    });
}

$(document).ready(function(){
	var search = "collapseStatus=";
	cookieValue = findCookie(search);
	if(cookieValue == 'collapse')
	{
		$("#menu_collapse").hide();
	}
	else if(cookieValue == 'extend')
	{
		$("#menu_collapse").show();
	}
	else
	{
		document.cookie = 'collapseStatus=collapse';
	}
	
	search = "collapseMenuToolStatus=";
	cookieValue = findCookie(search);
	if(cookieValue == 'menuToolCollapse')
	{
		$("#menu_tool").hide();
	}
	else if(cookieValue == 'menuToolExtend')
	{
		$("#menu_tool").show();
	}
	else
	{
		document.cookie = 'collapseMenuToolStatus=menuToolCollapse';
	}
	
	search = "collapseMenuSystemStatus=";
	cookieValue = findCookie(search);
	if(cookieValue == 'menuSystemCollapse')
	{
		$("#menu_system").hide();
	}
	else if(cookieValue == 'menuSystemExtend')
	{
		$("#menu_system").show();
	}
	else
	{
		document.cookie = 'collapseMenuSystemStatus=menuSystemCollapse';
	}
	
	$(".exit").bind('click',function(){
		document.cookie = 'collapseStatus=collapse';
		document.cookie = 'collapseMenuToolStatus=menuToolCollapse';
		document.cookie = 'collapseMenuSystemStatus=menuSystemCollapse';
	});
	
	$("#collapse,#menuTool,#menuSystem").hover(
			function(){
				$(this).css('cursor','pointer');
			},
			function(){
				$(this).css('cursor','default');
	});
});

