import React from 'react';
import {SafeAreaView, StyleSheet} from 'react-native';

import SwipeButton from './src/Swipe/components/SwipeButton';
import AnimatedAccordion from './src/Swipe/components/AnimatedAccordion';
import AnimatedSwitchButton from './src/Swipe/components/AnimatedSwitchButton';
import SwitchListItems from './src/Swipe/toggleSwitchList/toggleSwitchList';
import FlaotingTextInput from './src/Swipe/components/FloatingTextInput'

const App = () => {
  return (
    <SafeAreaView style={styles.container}>
      <SwipeButton onToggle={() => {}}/>
      <AnimatedAccordion />
      <AnimatedSwitchButton />
      <SwitchListItems/>
      <FlaotingTextInput />
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  container: {
    height: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor:'#95C8D8',
  },
});

export default App;
