/*!
 * jQuery JavaScript Library v3.6.3
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2022-12-20T21:28Z
 */
(function(global,factory){"use strict";if(typeof module==="object"&&typeof module.exports==="object"){module.exports=global.document?factory(global,true):function(w){if(!w.document){throw new Error("jQuery requires a window with a document")}return factory(w)}}else{factory(global)}})(typeof window!=="undefined"?window:this,(function(window,noGlobal){"use strict";var arr=[];var getProto=Object.getPrototypeOf;var slice=arr.slice;var flat=arr.flat?function(array){return arr.flat.call(array)}:function(array){return arr.concat.apply([],array)};var push=arr.push;var indexOf=arr.indexOf;var class2type={};var toString=class2type.toString;var hasOwn=class2type.hasOwnProperty;var fnToString=hasOwn.toString;var ObjectFunctionString=fnToString.call(Object);var support={};var isFunction=function isFunction(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"&&typeof obj.item!=="function"};var isWindow=function isWindow(obj){return obj!=null&&obj===obj.window};var document=window.document;var preservedScriptAttributes={type:true,src:true,nonce:true,noModule:true};function DOMEval(code,node,doc){doc=doc||document;var i,val,script=doc.createElement("script");script.text=code;if(node){for(i in preservedScriptAttributes){val=node[i]||node.getAttribute&&node.getAttribute(i);if(val){script.setAttribute(i,val)}}}doc.head.appendChild(script).parentNode.removeChild(script)}function toType(obj){if(obj==null){return obj+""}return typeof obj==="object"||typeof obj==="function"?class2type[toString.call(obj)]||"object":typeof obj}var version="3.6.3",jQuery=function(selector,context){return new jQuery.fn.init(selector,context)};jQuery.fn=jQuery.prototype={jquery:version,constructor:jQuery,length:0,toArray:function(){return slice.call(this)},get:function(num){if(num==null){return slice.call(this)}return num<0?this[num+this.length]:this[num]},pushStack:function(elems){var ret=jQuery.merge(this.constructor(),elems);ret.prevObject=this;return ret},each:function(callback){return jQuery.each(this,callback)},map:function(callback){return this.pushStack(jQuery.map(this,(function(elem,i){return callback.call(elem,i,elem)})))},slice:function(){return this.pushStack(slice.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(jQuery.grep(this,(function(_elem,i){return(i+1)%2})))},odd:function(){return this.pushStack(jQuery.grep(this,(function(_elem,i){return i%2})))},eq:function(i){var len=this.length,j=+i+(i<0?len:0);return this.pushStack(j>=0&&j<len?[this[j]]:[])},end:function(){return this.prevObject||this.constructor()},push:push,sort:arr.sort,splice:arr.splice};jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=false;if(typeof target==="boolean"){deep=target;target=arguments[i]||{};i++}if(typeof target!=="object"&&!isFunction(target)){target={}}if(i===length){target=this;i--}for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){copy=options[name];if(name==="__proto__"||target===copy){continue}if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=Array.isArray(copy)))){src=target[name];if(copyIsArray&&!Array.isArray(src)){clone=[]}else if(!copyIsArray&&!jQuery.isPlainObject(src)){clone={}}else{clone=src}copyIsArray=false;target[name]=jQuery.extend(deep,clone,copy)}else if(copy!==undefined){target[name]=copy}}}}return target};jQuery.extend({expando:"jQuery"+(version+Math.random()).replace(/\D/g,""),isReady:true,error:function(msg){throw new Error(msg)},noop:function(){},isPlainObject:function(obj){var proto,Ctor;if(!obj||toString.call(obj)!=="[object Object]"){return false}proto=getProto(obj);if(!proto){return true}Ctor=hasOwn.call(proto,"constructor")&&proto.constructor;return typeof Ctor==="function"&&fnToString.call(Ctor)===ObjectFunctionString},isEmptyObject:function(obj){var name;for(name in obj){return false}return true},globalEval:function(code,options,doc){DOMEval(code,{nonce:options&&options.nonce},doc)},each:function(obj,callback){var length,i=0;if(isArrayLike(obj)){length=obj.length;for(;i<length;i++){if(callback.call(obj[i],i,obj[i])===false){break}}}else{for(i in obj){if(callback.call(obj[i],i,obj[i])===false){break}}}return obj},makeArray:function(arr,results){var ret=results||[];if(arr!=null){if(isArrayLike(Object(arr))){jQuery.merge(ret,typeof arr==="string"?[arr]:arr)}else{push.call(ret,arr)}}return ret},inArray:function(elem,arr,i){return arr==null?-1:indexOf.call(arr,elem,i)},merge:function(first,second){var len=+second.length,j=0,i=first.length;for(;j<len;j++){first[i++]=second[j]}first.length=i;return first},grep:function(elems,callback,invert){var callbackInverse,matches=[],i=0,length=elems.length,callbackExpect=!invert;for(;i<length;i++){callbackInverse=!callback(elems[i],i);if(callbackInverse!==callbackExpect){matches.push(elems[i])}}return matches},map:function(elems,callback,arg){var length,value,i=0,ret=[];if(isArrayLike(elems)){length=elems.length;for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}else{for(i in elems){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}return flat(ret)},guid:1,support:support});if(typeof Symbol==="function"){jQuery.fn[Symbol.iterator]=arr[Symbol.iterator]}jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),(function(_i,name){class2type["[object "+name+"]"]=name.toLowerCase()}));function isArrayLike(obj){var length=!!obj&&"length"in obj&&obj.length,type=toType(obj);if(isFunction(obj)||isWindow(obj)){return false}return type==="array"||length===0||typeof length==="number"&&length>0&&length-1 in obj}var Sizzle=
/*!
 * Sizzle CSS Selector Engine v2.3.9
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2022-12-19
 */
function(window){var i,support,Expr,getText,isXML,tokenize,compile,select,outermostContext,sortInput,hasDuplicate,setDocument,document,docElem,documentIsHTML,rbuggyQSA,rbuggyMatches,matches,contains,expando="sizzle"+1*new Date,preferredDoc=window.document,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),nonnativeSelectorCache=createCache(),sortOrder=function(a,b){if(a===b){hasDuplicate=true}return 0},hasOwn={}.hasOwnProperty,arr=[],pop=arr.pop,pushNative=arr.push,push=arr.push,slice=arr.slice,indexOf=function(list,elem){var i=0,len=list.length;for(;i<len;i++){if(list[i]===elem){return i}}return-1},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|"+"ismap|loop|multiple|open|readonly|required|scoped",whitespace="[\\x20\\t\\r\\n\\f]",identifier="(?:\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",attributes="\\["+whitespace+"*("+identifier+")(?:"+whitespace+"*([*^$|!~]?=)"+whitespace+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+identifier+"))|)"+whitespace+"*\\]",pseudos=":("+identifier+")(?:\\(("+"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|"+"((?:\\\\.|[^\\\\()[\\]]|"+attributes+")*)|"+".*"+")\\)|)",rwhitespace=new RegExp(whitespace+"+","g"),rtrim=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rcombinators=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+"*"),rdescend=new RegExp(whitespace+"|>"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={ID:new RegExp("^#("+identifier+")"),CLASS:new RegExp("^\\.("+identifier+")"),TAG:new RegExp("^("+identifier+"|[*])"),ATTR:new RegExp("^"+attributes),PSEUDO:new RegExp("^"+pseudos),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),bool:new RegExp("^(?:"+booleans+")$","i"),needsContext:new RegExp("^"+whitespace+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rhtml=/HTML$/i,rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rnative=/^[^{]+\{\s*\[native \w/,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,runescape=new RegExp("\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\([^\\r\\n\\f])","g"),funescape=function(escape,nonHex){var high="0x"+escape.slice(1)-65536;return nonHex?nonHex:high<0?String.fromCharCode(high+65536):String.fromCharCode(high>>10|55296,high&1023|56320)},rcssescape=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,fcssescape=function(ch,asCodePoint){if(asCodePoint){if(ch==="\0"){return"�"}return ch.slice(0,-1)+"\\"+ch.charCodeAt(ch.length-1).toString(16)+" "}return"\\"+ch},unloadHandler=function(){setDocument()},inDisabledFieldset=addCombinator((function(elem){return elem.disabled===true&&elem.nodeName.toLowerCase()==="fieldset"}),{dir:"parentNode",next:"legend"});try{push.apply(arr=slice.call(preferredDoc.childNodes),preferredDoc.childNodes);arr[preferredDoc.childNodes.length].nodeType}catch(e){push={apply:arr.length?function(target,els){pushNative.apply(target,slice.call(els))}:function(target,els){var j=target.length,i=0;while(target[j++]=els[i++]){}target.length=j-1}}}function Sizzle(selector,context,results,seed){var m,i,elem,nid,match,groups,newSelector,newContext=context&&context.ownerDocument,nodeType=context?context.nodeType:9;results=results||[];if(typeof selector!=="string"||!selector||nodeType!==1&&nodeType!==9&&nodeType!==11){return results}if(!seed){setDocument(context);context=context||document;if(documentIsHTML){if(nodeType!==11&&(match=rquickExpr.exec(selector))){if(m=match[1]){if(nodeType===9){if(elem=context.getElementById(m)){if(elem.id===m){results.push(elem);return results}}else{return results}}else{if(newContext&&(elem=newContext.getElementById(m))&&contains(context,elem)&&elem.id===m){results.push(elem);return results}}}else if(match[2]){push.apply(results,context.getElementsByTagName(selector));return results}else if((m=match[3])&&support.getElementsByClassName&&context.getElementsByClassName){push.apply(results,context.getElementsByClassName(m));return results}}if(support.qsa&&!nonnativeSelectorCache[selector+" "]&&(!rbuggyQSA||!rbuggyQSA.test(selector))&&(nodeType!==1||context.nodeName.toLowerCase()!=="object")){newSelector=selector;newContext=context;if(nodeType===1&&(rdescend.test(selector)||rcombinators.test(selector))){newContext=rsibling.test(selector)&&testContext(context.parentNode)||context;if(newContext!==context||!support.scope){if(nid=context.getAttribute("id")){nid=nid.replace(rcssescape,fcssescape)}else{context.setAttribute("id",nid=expando)}}groups=tokenize(selector);i=groups.length;while(i--){groups[i]=(nid?"#"+nid:":scope")+" "+toSelector(groups[i])}newSelector=groups.join(",")}try{if(support.cssSupportsSelector&&!CSS.supports("selector(:is("+newSelector+"))")){throw new Error}push.apply(results,newContext.querySelectorAll(newSelector));return results}catch(qsaError){nonnativeSelectorCache(selector,true)}finally{if(nid===expando){context.removeAttribute("id")}}}}}return select(selector.replace(rtrim,"$1"),context,results,seed)}function createCache(){var keys=[];function cache(key,value){if(keys.push(key+" ")>Expr.cacheLength){delete cache[keys.shift()]}return cache[key+" "]=value}return cache}function markFunction(fn){fn[expando]=true;return fn}function assert(fn){var el=document.createElement("fieldset");try{return!!fn(el)}catch(e){return false}finally{if(el.parentNode){el.parentNode.removeChild(el)}el=null}}function addHandle(attrs,handler){var arr=attrs.split("|"),i=arr.length;while(i--){Expr.attrHandle[arr[i]]=handler}}function siblingCheck(a,b){var cur=b&&a,diff=cur&&a.nodeType===1&&b.nodeType===1&&a.sourceIndex-b.sourceIndex;if(diff){return diff}if(cur){while(cur=cur.nextSibling){if(cur===b){return-1}}}return a?1:-1}function createInputPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&elem.type===type}}function createButtonPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&elem.type===type}}function createDisabledPseudo(disabled){return function(elem){if("form"in elem){if(elem.parentNode&&elem.disabled===false){if("label"in elem){if("label"in elem.parentNode){return elem.parentNode.disabled===disabled}else{return elem.disabled===disabled}}return elem.isDisabled===disabled||elem.isDisabled!==!disabled&&inDisabledFieldset(elem)===disabled}return elem.disabled===disabled}else if("label"in elem){return elem.disabled===disabled}return false}}function createPositionalPseudo(fn){return markFunction((function(argument){argument=+argument;return markFunction((function(seed,matches){var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;while(i--){if(seed[j=matchIndexes[i]]){seed[j]=!(matches[j]=seed[j])}}}))}))}function testContext(context){return context&&typeof context.getElementsByTagName!=="undefined"&&context}support=Sizzle.support={};isXML=Sizzle.isXML=function(elem){var namespace=elem&&elem.namespaceURI,docElem=elem&&(elem.ownerDocument||elem).documentElement;return!rhtml.test(namespace||docElem&&docElem.nodeName||"HTML")};setDocument=Sizzle.setDocument=function(node){var hasCompare,subWindow,doc=node?node.ownerDocument||node:preferredDoc;if(doc==document||doc.nodeType!==9||!doc.documentElement){return document}document=doc;docElem=document.documentElement;documentIsHTML=!isXML(document);if(preferredDoc!=document&&(subWindow=document.defaultView)&&subWindow.top!==subWindow){if(subWindow.addEventListener){subWindow.addEventListener("unload",unloadHandler,false)}else if(subWindow.attachEvent){subWindow.attachEvent("onunload",unloadHandler)}}support.scope=assert((function(el){docElem.appendChild(el).appendChild(document.createElement("div"));return typeof el.querySelectorAll!=="undefined"&&!el.querySelectorAll(":scope fieldset div").length}));support.cssSupportsSelector=assert((function(){return CSS.supports("selector(*)")&&document.querySelectorAll(":is(:jqfake)")&&!CSS.supports("selector(:is(*,:jqfake))")}));support.attributes=assert((function(el){el.className="i";return!el.getAttribute("className")}));support.getElementsByTagName=assert((function(el){el.appendChild(document.createComment(""));return!el.getElementsByTagName("*").length}));support.getElementsByClassName=rnative.test(document.getElementsByClassName);support.getById=assert((function(el){docElem.appendChild(el).id=expando;return!document.getElementsByName||!document.getElementsByName(expando).length}));if(support.getById){Expr.filter["ID"]=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId}};Expr.find["ID"]=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var elem=context.getElementById(id);return elem?[elem]:[]}}}else{Expr.filter["ID"]=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return node&&node.value===attrId}};Expr.find["ID"]=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var node,i,elems,elem=context.getElementById(id);if(elem){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}elems=context.getElementsByName(id);i=0;while(elem=elems[i++]){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}}}return[]}}}Expr.find["TAG"]=support.getElementsByTagName?function(tag,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(tag)}else if(support.qsa){return context.querySelectorAll(tag)}}:function(tag,context){var elem,tmp=[],i=0,results=context.getElementsByTagName(tag);if(tag==="*"){while(elem=results[i++]){if(elem.nodeType===1){tmp.push(elem)}}return tmp}return results};Expr.find["CLASS"]=support.getElementsByClassName&&function(className,context){if(typeof context.getElementsByClassName!=="undefined"&&documentIsHTML){return context.getElementsByClassName(className)}};rbuggyMatches=[];rbuggyQSA=[];if(support.qsa=rnative.test(document.querySelectorAll)){assert((function(el){var input;docElem.appendChild(el).innerHTML="<a id='"+expando+"'></a>"+"<select id='"+expando+"-\r\\' msallowcapture=''>"+"<option selected=''></option></select>";if(el.querySelectorAll("[msallowcapture^='']").length){rbuggyQSA.push("[*^$]="+whitespace+"*(?:''|\"\")")}if(!el.querySelectorAll("[selected]").length){rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")")}if(!el.querySelectorAll("[id~="+expando+"-]").length){rbuggyQSA.push("~=")}input=document.createElement("input");input.setAttribute("name","");el.appendChild(input);if(!el.querySelectorAll("[name='']").length){rbuggyQSA.push("\\["+whitespace+"*name"+whitespace+"*="+whitespace+"*(?:''|\"\")")}if(!el.querySelectorAll(":checked").length){rbuggyQSA.push(":checked")}if(!el.querySelectorAll("a#"+expando+"+*").length){rbuggyQSA.push(".#.+[+~]")}el.querySelectorAll("\\\f");rbuggyQSA.push("[\\r\\n\\f]")}));assert((function(el){el.innerHTML="<a href='' disabled='disabled'></a>"+"<select disabled='disabled'><option/></select>";var input=document.createElement("input");input.setAttribute("type","hidden");el.appendChild(input).setAttribute("name","D");if(el.querySelectorAll("[name=d]").length){rbuggyQSA.push("name"+whitespace+"*[*^$|!~]?=")}if(el.querySelectorAll(":enabled").length!==2){rbuggyQSA.push(":enabled",":disabled")}docElem.appendChild(el).disabled=true;if(el.querySelectorAll(":disabled").length!==2){rbuggyQSA.push(":enabled",":disabled")}el.querySelectorAll("*,:x");rbuggyQSA.push(",.*:")}))}if(support.matchesSelector=rnative.test(matches=docElem.matches||docElem.webkitMatchesSelector||docElem.mozMatchesSelector||docElem.oMatchesSelector||docElem.msMatchesSelector)){assert((function(el){support.disconnectedMatch=matches.call(el,"*");matches.call(el,"[s!='']:x");rbuggyMatches.push("!=",pseudos)}))}if(!support.cssSupportsSelector){rbuggyQSA.push(":has")}rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|"));rbuggyMatches=rbuggyMatches.length&&new RegExp(rbuggyMatches.join("|"));hasCompare=rnative.test(docElem.compareDocumentPosition);contains=hasCompare||rnative.test(docElem.contains)?function(a,b){var adown=a.nodeType===9&&a.documentElement||a,bup=b&&b.parentNode;return a===bup||!!(bup&&bup.nodeType===1&&(adown.contains?adown.contains(bup):a.compareDocumentPosition&&a.compareDocumentPosition(bup)&16))}:function(a,b){if(b){while(b=b.parentNode){if(b===a){return true}}}return false};sortOrder=hasCompare?function(a,b){if(a===b){hasDuplicate=true;return 0}var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;if(compare){return compare}compare=(a.ownerDocument||a)==(b.ownerDocument||b)?a.compareDocumentPosition(b):1;if(compare&1||!support.sortDetached&&b.compareDocumentPosition(a)===compare){if(a==document||a.ownerDocument==preferredDoc&&contains(preferredDoc,a)){return-1}if(b==document||b.ownerDocument==preferredDoc&&contains(preferredDoc,b)){return 1}return sortInput?indexOf(sortInput,a)-indexOf(sortInput,b):0}return compare&4?-1:1}:function(a,b){if(a===b){hasDuplicate=true;return 0}var cur,i=0,aup=a.parentNode,bup=b.parentNode,ap=[a],bp=[b];if(!aup||!bup){return a==document?-1:b==document?1:aup?-1:bup?1:sortInput?indexOf(sortInput,a)-indexOf(sortInput,b):0}else if(aup===bup){return siblingCheck(a,b)}cur=a;while(cur=cur.parentNode){ap.unshift(cur)}cur=b;while(cur=cur.parentNode){bp.unshift(cur)}while(ap[i]===bp[i]){i++}return i?siblingCheck(ap[i],bp[i]):ap[i]==preferredDoc?-1:bp[i]==preferredDoc?1:0};return document};Sizzle.matches=function(expr,elements){return Sizzle(expr,null,null,elements)};Sizzle.matchesSelector=function(elem,expr){setDocument(elem);if(support.matchesSelector&&documentIsHTML&&!nonnativeSelectorCache[expr+" "]&&(!rbuggyMatches||!rbuggyMatches.test(expr))&&(!rbuggyQSA||!rbuggyQSA.test(expr))){try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&elem.document.nodeType!==11){return ret}}catch(e){nonnativeSelectorCache(expr,true)}}return Sizzle(expr,document,null,[elem]).length>0};Sizzle.contains=function(context,elem){if((context.ownerDocument||context)!=document){setDocument(context)}return contains(context,elem)};Sizzle.attr=function(elem,name){if((elem.ownerDocument||elem)!=document){setDocument(elem)}var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):undefined;return val!==undefined?val:support.attributes||!documentIsHTML?elem.getAttribute(name):(val=elem.getAttributeNode(name))&&val.specified?val.value:null};Sizzle.escape=function(sel){return(sel+"").replace(rcssescape,fcssescape)};Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)};Sizzle.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;hasDuplicate=!support.detectDuplicates;sortInput=!support.sortStable&&results.slice(0);results.sort(sortOrder);if(hasDuplicate){while(elem=results[i++]){if(elem===results[i]){j=duplicates.push(i)}}while(j--){results.splice(duplicates[j],1)}}sortInput=null;return results};getText=Sizzle.getText=function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(!nodeType){while(node=elem[i++]){ret+=getText(node)}}else if(nodeType===1||nodeType===9||nodeType===11){if(typeof elem.textContent==="string"){return elem.textContent}else{for(elem=elem.firstChild;elem;elem=elem.nextSibling){ret+=getText(elem)}}}else if(nodeType===3||nodeType===4){return elem.nodeValue}return ret};Expr=Sizzle.selectors={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:true}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:true},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(match){match[1]=match[1].replace(runescape,funescape);match[3]=(match[3]||match[4]||match[5]||"").replace(runescape,funescape);if(match[2]==="~="){match[3]=" "+match[3]+" "}return match.slice(0,4)},CHILD:function(match){match[1]=match[1].toLowerCase();if(match[1].slice(0,3)==="nth"){if(!match[3]){Sizzle.error(match[0])}match[4]=+(match[4]?match[5]+(match[6]||1):2*(match[3]==="even"||match[3]==="odd"));match[5]=+(match[7]+match[8]||match[3]==="odd")}else if(match[3]){Sizzle.error(match[0])}return match},PSEUDO:function(match){var excess,unquoted=!match[6]&&match[2];if(matchExpr["CHILD"].test(match[0])){return null}if(match[3]){match[2]=match[4]||match[5]||""}else if(unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,true))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)){match[0]=match[0].slice(0,excess);match[2]=unquoted.slice(0,excess)}return match.slice(0,3)}},filter:{TAG:function(nodeNameSelector){var nodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return nodeNameSelector==="*"?function(){return true}:function(elem){return elem.nodeName&&elem.nodeName.toLowerCase()===nodeName}},CLASS:function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+")"+className+"("+whitespace+"|$)"))&&classCache(className,(function(elem){return pattern.test(typeof elem.className==="string"&&elem.className||typeof elem.getAttribute!=="undefined"&&elem.getAttribute("class")||"")}))},ATTR:function(name,operator,check){return function(elem){var result=Sizzle.attr(elem,name);if(result==null){return operator==="!="}if(!operator){return true}result+="";return operator==="="?result===check:operator==="!="?result!==check:operator==="^="?check&&result.indexOf(check)===0:operator==="*="?check&&result.indexOf(check)>-1:operator==="$="?check&&result.slice(-check.length)===check:operator==="~="?(" "+result.replace(rwhitespace," ")+" ").indexOf(check)>-1:operator==="|="?result===check||result.slice(0,check.length+1)===check+"-":false}},CHILD:function(type,what,_argument,first,last){var simple=type.slice(0,3)!=="nth",forward=type.slice(-4)!=="last",ofType=what==="of-type";return first===1&&last===0?function(elem){return!!elem.parentNode}:function(elem,_context,xml){var cache,uniqueCache,outerCache,node,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType,diff=false;if(parent){if(simple){while(dir){node=elem;while(node=node[dir]){if(ofType?node.nodeName.toLowerCase()===name:node.nodeType===1){return false}}start=dir=type==="only"&&!start&&"nextSibling"}return true}start=[forward?parent.firstChild:parent.lastChild];if(forward&&useCache){node=parent;outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});cache=uniqueCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex&&cache[2];node=nodeIndex&&parent.childNodes[nodeIndex];while(node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop()){if(node.nodeType===1&&++diff&&node===elem){uniqueCache[type]=[dirruns,nodeIndex,diff];break}}}else{if(useCache){node=elem;outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});cache=uniqueCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex}if(diff===false){while(node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop()){if((ofType?node.nodeName.toLowerCase()===name:node.nodeType===1)&&++diff){if(useCache){outerCache=node[expando]||(node[expando]={});uniqueCache=outerCache[node.uniqueID]||(outerCache[node.uniqueID]={});uniqueCache[type]=[dirruns,diff]}if(node===elem){break}}}}}diff-=last;return diff===first||diff%first===0&&diff/first>=0}}},PSEUDO:function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||Sizzle.error("unsupported pseudo: "+pseudo);if(fn[expando]){return fn(argument)}if(fn.length>1){args=[pseudo,pseudo,"",argument];return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction((function(seed,matches){var idx,matched=fn(seed,argument),i=matched.length;while(i--){idx=indexOf(seed,matched[i]);seed[idx]=!(matches[idx]=matched[i])}})):function(elem){return fn(elem,0,args)}}return fn}},pseudos:{not:markFunction((function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrim,"$1"));return matcher[expando]?markFunction((function(seed,matches,_context,xml){var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;while(i--){if(elem=unmatched[i]){seed[i]=!(matches[i]=elem)}}})):function(elem,_context,xml){input[0]=elem;matcher(input,null,xml,results);input[0]=null;return!results.pop()}})),has:markFunction((function(selector){return function(elem){return Sizzle(selector,elem).length>0}})),contains:markFunction((function(text){text=text.replace(runescape,funescape);return function(elem){return(elem.textContent||getText(elem)).indexOf(text)>-1}})),lang:markFunction((function(lang){if(!ridentifier.test(lang||"")){Sizzle.error("unsupported lang: "+lang)}lang=lang.replace(runescape,funescape).toLowerCase();return function(elem){var elemLang;do{if(elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang")){elemLang=elemLang.toLowerCase();return elemLang===lang||elemLang.indexOf(lang+"-")===0}}while((elem=elem.parentNode)&&elem.nodeType===1);return false}})),target:function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id},root:function(elem){return elem===docElem},focus:function(elem){return elem===document.activeElement&&(!document.hasFocus||document.hasFocus())&&!!(elem.type||elem.href||~elem.tabIndex)},enabled:createDisabledPseudo(false),disabled:createDisabledPseudo(true),checked:function(elem){var nodeName=elem.nodeName.toLowerCase();return nodeName==="input"&&!!elem.checked||nodeName==="option"&&!!elem.selected},selected:function(elem){if(elem.parentNode){elem.parentNode.selectedIndex}return elem.selected===true},empty:function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling){if(elem.nodeType<6){return false}}return true},parent:function(elem){return!Expr.pseudos["empty"](elem)},header:function(elem){return rheader.test(elem.nodeName)},input:function(elem){return rinputs.test(elem.nodeName)},button:function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&elem.type==="button"||name==="button"},text:function(elem){var attr;return elem.nodeName.toLowerCase()==="input"&&elem.type==="text"&&((attr=elem.getAttribute("type"))==null||attr.toLowerCase()==="text")},first:createPositionalPseudo((function(){return[0]})),last:createPositionalPseudo((function(_matchIndexes,length){return[length-1]})),eq:createPositionalPseudo((function(_matchIndexes,length,argument){return[argument<0?argument+length:argument]})),even:createPositionalPseudo((function(matchIndexes,length){var i=0;for(;i<length;i+=2){matchIndexes.push(i)}return matchIndexes})),odd:createPositionalPseudo((function(matchIndexes,length){var i=1;for(;i<length;i+=2){matchIndexes.push(i)}return matchIndexes})),lt:createPositionalPseudo((function(matchIndexes,length,argument){var i=argument<0?argument+length:argument>length?length:argument;for(;--i>=0;){matchIndexes.push(i)}return matchIndexes})),gt:createPositionalPseudo((function(matchIndexes,length,argument){var i=argument<0?argument+length:argument;for(;++i<length;){matchIndexes.push(i)}return matchIndexes}))}};Expr.pseudos["nth"]=Expr.pseudos["eq"];for(i in{radio:true,checkbox:true,file:true,password:true,image:true}){Expr.pseudos[i]=createInputPseudo(i)}for(i in{submit:true,reset:true}){Expr.pseudos[i]=createButtonPseudo(i)}function setFilters(){}setFilters.prototype=Expr.filters=Expr.pseudos;Expr.setFilters=new setFilters;tokenize=Sizzle.tokenize=function(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached){return parseOnly?0:cached.slice(0)}soFar=selector;groups=[];preFilters=Expr.preFilter;while(soFar){if(!matched||(match=rcomma.exec(soFar))){if(match){soFar=soFar.slice(match[0].length)||soFar}groups.push(tokens=[])}matched=false;if(match=rcombinators.exec(soFar)){matched=match.shift();tokens.push({value:matched,type:match[0].replace(rtrim," ")});soFar=soFar.slice(matched.length)}for(type in Expr.filter){if((match=matchExpr[type].exec(soFar))&&(!preFilters[type]||(match=preFilters[type](match)))){matched=match.shift();tokens.push({value:matched,type:type,matches:match});soFar=soFar.slice(matched.length)}}if(!matched){break}}return parseOnly?soFar.length:soFar?Sizzle.error(selector):tokenCache(selector,groups).slice(0)};function toSelector(tokens){var i=0,len=tokens.length,selector="";for(;i<len;i++){selector+=tokens[i].value}return selector}function addCombinator(matcher,combinator,base){var dir=combinator.dir,skip=combinator.next,key=skip||dir,checkNonElements=base&&key==="parentNode",doneName=done++;return combinator.first?function(elem,context,xml){while(elem=elem[dir]){if(elem.nodeType===1||checkNonElements){return matcher(elem,context,xml)}}return false}:function(elem,context,xml){var oldCache,uniqueCache,outerCache,newCache=[dirruns,doneName];if(xml){while(elem=elem[dir]){if(elem.nodeType===1||checkNonElements){if(matcher(elem,context,xml)){return true}}}}else{while(elem=elem[dir]){if(elem.nodeType===1||checkNonElements){outerCache=elem[expando]||(elem[expando]={});uniqueCache=outerCache[elem.uniqueID]||(outerCache[elem.uniqueID]={});if(skip&&skip===elem.nodeName.toLowerCase()){elem=elem[dir]||elem}else if((oldCache=uniqueCache[key])&&oldCache[0]===dirruns&&oldCache[1]===doneName){return newCache[2]=oldCache[2]}else{uniqueCache[key]=newCache;if(newCache[2]=matcher(elem,context,xml)){return true}}}}}return false}}function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){var i=matchers.length;while(i--){if(!matchers[i](elem,context,xml)){return false}}return true}:matchers[0]}function multipleContexts(selector,contexts,results){var i=0,len=contexts.length;for(;i<len;i++){Sizzle(selector,contexts[i],results)}return results}function condense(unmatched,map,filter,context,xml){var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=map!=null;for(;i<len;i++){if(elem=unmatched[i]){if(!filter||filter(elem,context,xml)){newUnmatched.push(elem);if(mapped){map.push(i)}}}}return newUnmatched}function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){if(postFilter&&!postFilter[expando]){postFilter=setMatcher(postFilter)}if(postFinder&&!postFinder[expando]){postFinder=setMatcher(postFinder,postSelector)}return markFunction((function(seed,results,context,xml){var temp,i,elem,preMap=[],postMap=[],preexisting=results.length,elems=seed||multipleContexts(selector||"*",context.nodeType?[context]:context,[]),matcherIn=preFilter&&(seed||!selector)?condense(elems,preMap,preFilter,context,xml):elems,matcherOut=matcher?postFinder||(seed?preFilter:preexisting||postFilter)?[]:results:matcherIn;if(matcher){matcher(matcherIn,matcherOut,context,xml)}if(postFilter){temp=condense(matcherOut,postMap);postFilter(temp,[],context,xml);i=temp.length;while(i--){if(elem=temp[i]){matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem)}}}if(seed){if(postFinder||preFilter){if(postFinder){temp=[];i=matcherOut.length;while(i--){if(elem=matcherOut[i]){temp.push(matcherIn[i]=elem)}}postFinder(null,matcherOut=[],temp,xml)}i=matcherOut.length;while(i--){if((elem=matcherOut[i])&&(temp=postFinder?indexOf(seed,elem):preMap[i])>-1){seed[temp]=!(results[temp]=elem)}}}}else{matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut);if(postFinder){postFinder(null,results,matcherOut,xml)}else{push.apply(results,matcherOut)}}}))}function matcherFromTokens(tokens){var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator((function(elem){return elem===checkContext}),implicitRelative,true),matchAnyContext=addCombinator((function(elem){return indexOf(checkContext,elem)>-1}),implicitRelative,true),matchers=[function(elem,context,xml){var ret=!leadingRelative&&(xml||context!==outermostContext)||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml));checkContext=null;return ret}];for(;i<len;i++){if(matcher=Expr.relative[tokens[i].type]){matchers=[addCombinator(elementMatcher(matchers),matcher)]}else{matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches);if(matcher[expando]){j=++i;for(;j<len;j++){if(Expr.relative[tokens[j].type]){break}}return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:tokens[i-2].type===" "?"*":""})).replace(rtrim,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens(tokens=tokens.slice(j)),j<len&&toSelector(tokens))}matchers.push(matcher)}}return elementMatcher(matchers)}function matcherFromGroupMatchers(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find["TAG"]("*",outermost),dirrunsUnique=dirruns+=contextBackup==null?1:Math.random()||.1,len=elems.length;if(outermost){outermostContext=context==document||context||outermost}for(;i!==len&&(elem=elems[i])!=null;i++){if(byElement&&elem){j=0;if(!context&&elem.ownerDocument!=document){setDocument(elem);xml=!documentIsHTML}while(matcher=elementMatchers[j++]){if(matcher(elem,context||document,xml)){results.push(elem);break}}if(outermost){dirruns=dirrunsUnique}}if(bySet){if(elem=!matcher&&elem){matchedCount--}if(seed){unmatched.push(elem)}}}matchedCount+=i;if(bySet&&i!==matchedCount){j=0;while(matcher=setMatchers[j++]){matcher(unmatched,setMatched,context,xml)}if(seed){if(matchedCount>0){while(i--){if(!(unmatched[i]||setMatched[i])){setMatched[i]=pop.call(results)}}}setMatched=condense(setMatched)}push.apply(results,setMatched);if(outermost&&!seed&&setMatched.length>0&&matchedCount+setMatchers.length>1){Sizzle.uniqueSort(results)}}if(outermost){dirruns=dirrunsUnique;outermostContext=contextBackup}return unmatched};return bySet?markFunction(superMatcher):superMatcher}compile=Sizzle.compile=function(selector,match){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){if(!match){match=tokenize(selector)}i=match.length;while(i--){cached=matcherFromTokens(match[i]);if(cached[expando]){setMatchers.push(cached)}else{elementMatchers.push(cached)}}cached=compilerCache(selector,matcherFromGroupMatchers(elementMatchers,setMatchers));cached.selector=selector}return cached};select=Sizzle.select=function(selector,context,results,seed){var i,tokens,token,type,find,compiled=typeof selector==="function"&&selector,match=!seed&&tokenize(selector=compiled.selector||selector);results=results||[];if(match.length===1){tokens=match[0]=match[0].slice(0);if(tokens.length>2&&(token=tokens[0]).type==="ID"&&context.nodeType===9&&documentIsHTML&&Expr.relative[tokens[1].type]){context=(Expr.find["ID"](token.matches[0].replace(runescape,funescape),context)||[])[0];if(!context){return results}else if(compiled){context=context.parentNode}selector=selector.slice(tokens.shift().value.length)}i=matchExpr["needsContext"].test(selector)?0:tokens.length;while(i--){token=tokens[i];if(Expr.relative[type=token.type]){break}if(find=Expr.find[type]){if(seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context)){tokens.splice(i,1);selector=seed.length&&toSelector(tokens);if(!selector){push.apply(results,seed);return results}break}}}}(compiled||compile(selector,match))(seed,context,!documentIsHTML,results,!context||rsibling.test(selector)&&testContext(context.parentNode)||context);return results};support.sortStable=expando.split("").sort(sortOrder).join("")===expando;support.detectDuplicates=!!hasDuplicate;setDocument();support.sortDetached=assert((function(el){return el.compareDocumentPosition(document.createElement("fieldset"))&1}));if(!assert((function(el){el.innerHTML="<a href='#'></a>";return el.firstChild.getAttribute("href")==="#"}))){addHandle("type|href|height|width",(function(elem,name,isXML){if(!isXML){return elem.getAttribute(name,name.toLowerCase()==="type"?1:2)}}))}if(!support.attributes||!assert((function(el){el.innerHTML="<input/>";el.firstChild.setAttribute("value","");return el.firstChild.getAttribute("value")===""}))){addHandle("value",(function(elem,_name,isXML){if(!isXML&&elem.nodeName.toLowerCase()==="input"){return elem.defaultValue}}))}if(!assert((function(el){return el.getAttribute("disabled")==null}))){addHandle(booleans,(function(elem,name,isXML){var val;if(!isXML){return elem[name]===true?name.toLowerCase():(val=elem.getAttributeNode(name))&&val.specified?val.value:null}}))}return Sizzle}(window);jQuery.find=Sizzle;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.pseudos;jQuery.uniqueSort=jQuery.unique=Sizzle.uniqueSort;jQuery.text=Sizzle.getText;jQuery.isXMLDoc=Sizzle.isXML;jQuery.contains=Sizzle.contains;jQuery.escapeSelector=Sizzle.escape;var dir=function(elem,dir,until){var matched=[],truncate=until!==undefined;while((elem=elem[dir])&&elem.nodeType!==9){if(elem.nodeType===1){if(truncate&&jQuery(elem).is(until)){break}matched.push(elem)}}return matched};var siblings=function(n,elem){var matched=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){matched.push(n)}}return matched};var rneedsContext=jQuery.expr.match.needsContext;function nodeName(elem,name){return elem.nodeName&&elem.nodeName.toLowerCase()===name.toLowerCase()}var rsingleTag=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function winnow(elements,qualifier,not){if(isFunction(qualifier)){return jQuery.grep(elements,(function(elem,i){return!!qualifier.call(elem,i,elem)!==not}))}if(qualifier.nodeType){return jQuery.grep(elements,(function(elem){return elem===qualifier!==not}))}if(typeof qualifier!=="string"){return jQuery.grep(elements,(function(elem){return indexOf.call(qualifier,elem)>-1!==not}))}return jQuery.filter(qualifier,elements,not)}jQuery.filter=function(expr,elems,not){var elem=elems[0];if(not){expr=":not("+expr+")"}if(elems.length===1&&elem.nodeType===1){return jQuery.find.matchesSelector(elem,expr)?[elem]:[]}return jQuery.find.matches(expr,jQuery.grep(elems,(function(elem){return elem.nodeType===1})))};jQuery.fn.extend({find:function(selector){var i,ret,len=this.length,self=this;if(typeof selector!=="string"){return this.pushStack(jQuery(selector).filter((function(){for(i=0;i<len;i++){if(jQuery.contains(self[i],this)){return true}}})))}ret=this.pushStack([]);for(i=0;i<len;i++){jQuery.find(selector,self[i],ret)}return len>1?jQuery.uniqueSort(ret):ret},filter:function(selector){return this.pushStack(winnow(this,selector||[],false))},not:function(selector){return this.pushStack(winnow(this,selector||[],true))},is:function(selector){return!!winnow(this,typeof selector==="string"&&rneedsContext.test(selector)?jQuery(selector):selector||[],false).length}});var rootjQuery,rquickExpr=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,init=jQuery.fn.init=function(selector,context,root){var match,elem;if(!selector){return this}root=root||rootjQuery;if(typeof selector==="string"){if(selector[0]==="<"&&selector[selector.length-1]===">"&&selector.length>=3){match=[null,selector,null]}else{match=rquickExpr.exec(selector)}if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;jQuery.merge(this,jQuery.parseHTML(match[1],context&&context.nodeType?context.ownerDocument||context:document,true));if(rsingleTag.test(match[1])&&jQuery.isPlainObject(context)){for(match in context){if(isFunction(this[match])){this[match](context[match])}else{this.attr(match,context[match])}}}return this}else{elem=document.getElementById(match[2]);if(elem){this[0]=elem;this.length=1}return this}}else if(!context||context.jquery){return(context||root).find(selector)}else{return this.constructor(context).find(selector)}}else if(selector.nodeType){this[0]=selector;this.length=1;return this}else if(isFunction(selector)){return root.ready!==undefined?root.ready(selector):selector(jQuery)}return jQuery.makeArray(selector,this)};init.prototype=jQuery.fn;rootjQuery=jQuery(document);var rparentsprev=/^(?:parents|prev(?:Until|All))/,guaranteedUnique={children:true,contents:true,next:true,prev:true};jQuery.fn.extend({has:function(target){var targets=jQuery(target,this),l=targets.length;return this.filter((function(){var i=0;for(;i<l;i++){if(jQuery.contains(this,targets[i])){return true}}}))},closest:function(selectors,context){var cur,i=0,l=this.length,matched=[],targets=typeof selectors!=="string"&&jQuery(selectors);if(!rneedsContext.test(selectors)){for(;i<l;i++){for(cur=this[i];cur&&cur!==context;cur=cur.parentNode){if(cur.nodeType<11&&(targets?targets.index(cur)>-1:cur.nodeType===1&&jQuery.find.matchesSelector(cur,selectors))){matched.push(cur);break}}}}return this.pushStack(matched.length>1?jQuery.uniqueSort(matched):matched)},index:function(elem){if(!elem){return this[0]&&this[0].parentNode?this.first().prevAll().length:-1}if(typeof elem==="string"){return indexOf.call(jQuery(elem),this[0])}return indexOf.call(this,elem.jquery?elem[0]:elem)},add:function(selector,context){return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),jQuery(selector,context))))},addBack:function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector))}});function sibling(cur,dir){while((cur=cur[dir])&&cur.nodeType!==1){}return cur}jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null},parents:function(elem){return dir(elem,"parentNode")},parentsUntil:function(elem,_i,until){return dir(elem,"parentNode",until)},next:function(elem){return sibling(elem,"nextSibling")},prev:function(elem){return sibling(elem,"previousSibling")},nextAll:function(elem){return dir(elem,"nextSibling")},prevAll:function(elem){return dir(elem,"previousSibling")},nextUntil:function(elem,_i,until){return dir(elem,"nextSibling",until)},prevUntil:function(elem,_i,until){return dir(elem,"previousSibling",until)},siblings:function(elem){return siblings((elem.parentNode||{}).firstChild,elem)},children:function(elem){return siblings(elem.firstChild)},contents:function(elem){if(elem.contentDocument!=null&&getProto(elem.contentDocument)){return elem.contentDocument}if(nodeName(elem,"template")){elem=elem.content||elem}return jQuery.merge([],elem.childNodes)}},(function(name,fn){jQuery.fn[name]=function(until,selector){var matched=jQuery.map(this,fn,until);if(name.slice(-5)!=="Until"){selector=until}if(selector&&typeof selector==="string"){matched=jQuery.filter(selector,matched)}if(this.length>1){if(!guaranteedUnique[name]){jQuery.uniqueSort(matched)}if(rparentsprev.test(name)){matched.reverse()}}return this.pushStack(matched)}}));var rnothtmlwhite=/[^\x20\t\r\n\f]+/g;function createOptions(options){var object={};jQuery.each(options.match(rnothtmlwhite)||[],(function(_,flag){object[flag]=true}));return object}jQuery.Callbacks=function(options){options=typeof options==="string"?createOptions(options):jQuery.extend({},options);var firing,memory,fired,locked,list=[],queue=[],firingIndex=-1,fire=function(){locked=locked||options.once;fired=firing=true;for(;queue.length;firingIndex=-1){memory=queue.shift();while(++firingIndex<list.length){if(list[firingIndex].apply(memory[0],memory[1])===false&&options.stopOnFalse){firingIndex=list.length;memory=false}}}if(!options.memory){memory=false}firing=false;if(locked){if(memory){list=[]}else{list=""}}},self={add:function(){if(list){if(memory&&!firing){firingIndex=list.length-1;queue.push(memory)}(function add(args){jQuery.each(args,(function(_,arg){if(isFunction(arg)){if(!options.unique||!self.has(arg)){list.push(arg)}}else if(arg&&arg.length&&toType(arg)!=="string"){add(arg)}}))})(arguments);if(memory&&!firing){fire()}}return this},remove:function(){jQuery.each(arguments,(function(_,arg){var index;while((index=jQuery.inArray(arg,list,index))>-1){list.splice(index,1);if(index<=firingIndex){firingIndex--}}}));return this},has:function(fn){return fn?jQuery.inArray(fn,list)>-1:list.length>0},empty:function(){if(list){list=[]}return this},disable:function(){locked=queue=[];list=memory="";return this},disabled:function(){return!list},lock:function(){locked=queue=[];if(!memory&&!firing){list=memory=""}return this},locked:function(){return!!locked},fireWith:function(context,args){if(!locked){args=args||[];args=[context,args.slice?args.slice():args];queue.push(args);if(!firing){fire()}}return this},fire:function(){self.fireWith(this,arguments);return this},fired:function(){return!!fired}};return self};function Identity(v){return v}function Thrower(ex){throw ex}function adoptValue(value,resolve,reject,noValue){var method;try{if(value&&isFunction(method=value.promise)){method.call(value).done(resolve).fail(reject)}else if(value&&isFunction(method=value.then)){method.call(value,resolve,reject)}else{resolve.apply(undefined,[value].slice(noValue))}}catch(value){reject.apply(undefined,[value])}}jQuery.extend({Deferred:function(func){var tuples=[["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory"),2],["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),0,"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),1,"rejected"]],state="pending",promise={state:function(){return state},always:function(){deferred.done(arguments).fail(arguments);return this},catch:function(fn){return promise.then(null,fn)},pipe:function(){var fns=arguments;return jQuery.Deferred((function(newDefer){jQuery.each(tuples,(function(_i,tuple){var fn=isFunction(fns[tuple[4]])&&fns[tuple[4]];deferred[tuple[1]]((function(){var returned=fn&&fn.apply(this,arguments);if(returned&&isFunction(returned.promise)){returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject)}else{newDefer[tuple[0]+"With"](this,fn?[returned]:arguments)}}))}));fns=null})).promise()},then:function(onFulfilled,onRejected,onProgress){var maxDepth=0;function resolve(depth,deferred,handler,special){return function(){var that=this,args=arguments,mightThrow=function(){var returned,then;if(depth<maxDepth){return}returned=handler.apply(that,args);if(returned===deferred.promise()){throw new TypeError("Thenable self-resolution")}then=returned&&(typeof returned==="object"||typeof returned==="function")&&returned.then;if(isFunction(then)){if(special){then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special))}else{maxDepth++;then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special),resolve(maxDepth,deferred,Identity,deferred.notifyWith))}}else{if(handler!==Identity){that=undefined;args=[returned]}(special||deferred.resolveWith)(that,args)}},process=special?mightThrow:function(){try{mightThrow()}catch(e){if(jQuery.Deferred.exceptionHook){jQuery.Deferred.exceptionHook(e,process.stackTrace)}if(depth+1>=maxDepth){if(handler!==Thrower){that=undefined;args=[e]}deferred.rejectWith(that,args)}}};if(depth){process()}else{if(jQuery.Deferred.getStackHook){process.stackTrace=jQuery.Deferred.getStackHook()}window.setTimeout(process)}}}return jQuery.Deferred((function(newDefer){tuples[0][3].add(resolve(0,newDefer,isFunction(onProgress)?onProgress:Identity,newDefer.notifyWith));tuples[1][3].add(resolve(0,newDefer,isFunction(onFulfilled)?onFulfilled:Identity));tuples[2][3].add(resolve(0,newDefer,isFunction(onRejected)?onRejected:Thrower))})).promise()},promise:function(obj){return obj!=null?jQuery.extend(obj,promise):promise}},deferred={};jQuery.each(tuples,(function(i,tuple){var list=tuple[2],stateString=tuple[5];promise[tuple[1]]=list.add;if(stateString){list.add((function(){state=stateString}),tuples[3-i][2].disable,tuples[3-i][3].disable,tuples[0][2].lock,tuples[0][3].lock)}list.add(tuple[3].fire);deferred[tuple[0]]=function(){deferred[tuple[0]+"With"](this===deferred?undefined:this,arguments);return this};deferred[tuple[0]+"With"]=list.fireWith}));promise.promise(deferred);if(func){func.call(deferred,deferred)}return deferred},when:function(singleValue){var remaining=arguments.length,i=remaining,resolveContexts=Array(i),resolveValues=slice.call(arguments),primary=jQuery.Deferred(),updateFunc=function(i){return function(value){resolveContexts[i]=this;resolveValues[i]=arguments.length>1?slice.call(arguments):value;if(!--remaining){primary.resolveWith(resolveContexts,resolveValues)}}};if(remaining<=1){adoptValue(singleValue,primary.done(updateFunc(i)).resolve,primary.reject,!remaining);if(primary.state()==="pending"||isFunction(resolveValues[i]&&resolveValues[i].then)){return primary.then()}}while(i--){adoptValue(resolveValues[i],updateFunc(i),primary.reject)}return primary.promise()}});var rerrorNames=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;jQuery.Deferred.exceptionHook=function(error,stack){if(window.console&&window.console.warn&&error&&rerrorNames.test(error.name)){window.console.warn("jQuery.Deferred exception: "+error.message,error.stack,stack)}};jQuery.readyException=function(error){window.setTimeout((function(){throw error}))};var readyList=jQuery.Deferred();jQuery.fn.ready=function(fn){readyList.then(fn).catch((function(error){jQuery.readyException(error)}));return this};jQuery.extend({isReady:false,readyWait:1,ready:function(wait){if(wait===true?--jQuery.readyWait:jQuery.isReady){return}jQuery.isReady=true;if(wait!==true&&--jQuery.readyWait>0){return}readyList.resolveWith(document,[jQuery])}});jQuery.ready.then=readyList.then;function completed(){document.removeEventListener("DOMContentLoaded",completed);window.removeEventListener("load",completed);jQuery.ready()}if(document.readyState==="complete"||document.readyState!=="loading"&&!document.documentElement.doScroll){window.setTimeout(jQuery.ready)}else{document.addEventListener("DOMContentLoaded",completed);window.addEventListener("load",completed)}var access=function(elems,fn,key,value,chainable,emptyGet,raw){var i=0,len=elems.length,bulk=key==null;if(toType(key)==="object"){chainable=true;for(i in key){access(elems,fn,i,key[i],true,emptyGet,raw)}}else if(value!==undefined){chainable=true;if(!isFunction(value)){raw=true}if(bulk){if(raw){fn.call(elems,value);fn=null}else{bulk=fn;fn=function(elem,_key,value){return bulk.call(jQuery(elem),value)}}}if(fn){for(;i<len;i++){fn(elems[i],key,raw?value:value.call(elems[i],i,fn(elems[i],key)))}}}if(chainable){return elems}if(bulk){return fn.call(elems)}return len?fn(elems[0],key):emptyGet};var rmsPrefix=/^-ms-/,rdashAlpha=/-([a-z])/g;function fcamelCase(_all,letter){return letter.toUpperCase()}function camelCase(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase)}var acceptData=function(owner){return owner.nodeType===1||owner.nodeType===9||!+owner.nodeType};function Data(){this.expando=jQuery.expando+Data.uid++}Data.uid=1;Data.prototype={cache:function(owner){var value=owner[this.expando];if(!value){value={};if(acceptData(owner)){if(owner.nodeType){owner[this.expando]=value}else{Object.defineProperty(owner,this.expando,{value:value,configurable:true})}}}return value},set:function(owner,data,value){var prop,cache=this.cache(owner);if(typeof data==="string"){cache[camelCase(data)]=value}else{for(prop in data){cache[camelCase(prop)]=data[prop]}}return cache},get:function(owner,key){return key===undefined?this.cache(owner):owner[this.expando]&&owner[this.expando][camelCase(key)]},access:function(owner,key,value){if(key===undefined||key&&typeof key==="string"&&value===undefined){return this.get(owner,key)}this.set(owner,key,value);return value!==undefined?value:key},remove:function(owner,key){var i,cache=owner[this.expando];if(cache===undefined){return}if(key!==undefined){if(Array.isArray(key)){key=key.map(camelCase)}else{key=camelCase(key);key=key in cache?[key]:key.match(rnothtmlwhite)||[]}i=key.length;while(i--){delete cache[key[i]]}}if(key===undefined||jQuery.isEmptyObject(cache)){if(owner.nodeType){owner[this.expando]=undefined}else{delete owner[this.expando]}}},hasData:function(owner){var cache=owner[this.expando];return cache!==undefined&&!jQuery.isEmptyObject(cache)}};var dataPriv=new Data;var dataUser=new Data;var rbrace=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,rmultiDash=/[A-Z]/g;function getData(data){if(data==="true"){return true}if(data==="false"){return false}if(data==="null"){return null}if(data===+data+""){return+data}if(rbrace.test(data)){return JSON.parse(data)}return data}function dataAttr(elem,key,data){var name;if(data===undefined&&elem.nodeType===1){name="data-"+key.replace(rmultiDash,"-$&").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=getData(data)}catch(e){}dataUser.set(elem,key,data)}else{data=undefined}}return data}jQuery.extend({hasData:function(elem){return dataUser.hasData(elem)||dataPriv.hasData(elem)},data:function(elem,name,data){return dataUser.access(elem,name,data)},removeData:function(elem,name){dataUser.remove(elem,name)},_data:function(elem,name,data){return dataPriv.access(elem,name,data)},_removeData:function(elem,name){dataPriv.remove(elem,name)}});jQuery.fn.extend({data:function(key,value){var i,name,data,elem=this[0],attrs=elem&&elem.attributes;if(key===undefined){if(this.length){data=dataUser.get(elem);if(elem.nodeType===1&&!dataPriv.get(elem,"hasDataAttrs")){i=attrs.length;while(i--){if(attrs[i]){name=attrs[i].name;if(name.indexOf("data-")===0){name=camelCase(name.slice(5));dataAttr(elem,name,data[name])}}}dataPriv.set(elem,"hasDataAttrs",true)}}return data}if(typeof key==="object"){return this.each((function(){dataUser.set(this,key)}))}return access(this,(function(value){var data;if(elem&&value===undefined){data=dataUser.get(elem,key);if(data!==undefined){return data}data=dataAttr(elem,key);if(data!==undefined){return data}return}this.each((function(){dataUser.set(this,key,value)}))}),null,value,arguments.length>1,null,true)},removeData:function(key){return this.each((function(){dataUser.remove(this,key)}))}});jQuery.extend({queue:function(elem,type,data){var queue;if(elem){type=(type||"fx")+"queue";queue=dataPriv.get(elem,type);if(data){if(!queue||Array.isArray(data)){queue=dataPriv.access(elem,type,jQuery.makeArray(data))}else{queue.push(data)}}return queue||[]}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),startLength=queue.length,fn=queue.shift(),hooks=jQuery._queueHooks(elem,type),next=function(){jQuery.dequeue(elem,type)};if(fn==="inprogress"){fn=queue.shift();startLength--}if(fn){if(type==="fx"){queue.unshift("inprogress")}delete hooks.stop;fn.call(elem,next,hooks)}if(!startLength&&hooks){hooks.empty.fire()}},_queueHooks:function(elem,type){var key=type+"queueHooks";return dataPriv.get(elem,key)||dataPriv.access(elem,key,{empty:jQuery.Callbacks("once memory").add((function(){dataPriv.remove(elem,[type+"queue",key])}))})}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--}if(arguments.length<setter){return jQuery.queue(this[0],type)}return data===undefined?this:this.each((function(){var queue=jQuery.queue(this,type,data);jQuery._queueHooks(this,type);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type)}}))},dequeue:function(type){return this.each((function(){jQuery.dequeue(this,type)}))},clearQueue:function(type){return this.queue(type||"fx",[])},promise:function(type,obj){var tmp,count=1,defer=jQuery.Deferred(),elements=this,i=this.length,resolve=function(){if(!--count){defer.resolveWith(elements,[elements])}};if(typeof type!=="string"){obj=type;type=undefined}type=type||"fx";while(i--){tmp=dataPriv.get(elements[i],type+"queueHooks");if(tmp&&tmp.empty){count++;tmp.empty.add(resolve)}}resolve();return defer.promise(obj)}});var pnum=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;var rcssNum=new RegExp("^(?:([+-])=|)("+pnum+")([a-z%]*)$","i");var cssExpand=["Top","Right","Bottom","Left"];var documentElement=document.documentElement;var isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)},composed={composed:true};if(documentElement.getRootNode){isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)||elem.getRootNode(composed)===elem.ownerDocument}}var isHiddenWithinTree=function(elem,el){elem=el||elem;return elem.style.display==="none"||elem.style.display===""&&isAttached(elem)&&jQuery.css(elem,"display")==="none"};function adjustCSS(elem,prop,valueParts,tween){var adjusted,scale,maxIterations=20,currentValue=tween?function(){return tween.cur()}:function(){return jQuery.css(elem,prop,"")},initial=currentValue(),unit=valueParts&&valueParts[3]||(jQuery.cssNumber[prop]?"":"px"),initialInUnit=elem.nodeType&&(jQuery.cssNumber[prop]||unit!=="px"&&+initial)&&rcssNum.exec(jQuery.css(elem,prop));if(initialInUnit&&initialInUnit[3]!==unit){initial=initial/2;unit=unit||initialInUnit[3];initialInUnit=+initial||1;while(maxIterations--){jQuery.style(elem,prop,initialInUnit+unit);if((1-scale)*(1-(scale=currentValue()/initial||.5))<=0){maxIterations=0}initialInUnit=initialInUnit/scale}initialInUnit=initialInUnit*2;jQuery.style(elem,prop,initialInUnit+unit);valueParts=valueParts||[]}if(valueParts){initialInUnit=+initialInUnit||+initial||0;adjusted=valueParts[1]?initialInUnit+(valueParts[1]+1)*valueParts[2]:+valueParts[2];if(tween){tween.unit=unit;tween.start=initialInUnit;tween.end=adjusted}}return adjusted}var defaultDisplayMap={};function getDefaultDisplay(elem){var temp,doc=elem.ownerDocument,nodeName=elem.nodeName,display=defaultDisplayMap[nodeName];if(display){return display}temp=doc.body.appendChild(doc.createElement(nodeName));display=jQuery.css(temp,"display");temp.parentNode.removeChild(temp);if(display==="none"){display="block"}defaultDisplayMap[nodeName]=display;return display}function showHide(elements,show){var display,elem,values=[],index=0,length=elements.length;for(;index<length;index++){elem=elements[index];if(!elem.style){continue}display=elem.style.display;if(show){if(display==="none"){values[index]=dataPriv.get(elem,"display")||null;if(!values[index]){elem.style.display=""}}if(elem.style.display===""&&isHiddenWithinTree(elem)){values[index]=getDefaultDisplay(elem)}}else{if(display!=="none"){values[index]="none";dataPriv.set(elem,"display",display)}}}for(index=0;index<length;index++){if(values[index]!=null){elements[index].style.display=values[index]}}return elements}jQuery.fn.extend({show:function(){return showHide(this,true)},hide:function(){return showHide(this)},toggle:function(state){if(typeof state==="boolean"){return state?this.show():this.hide()}return this.each((function(){if(isHiddenWithinTree(this)){jQuery(this).show()}else{jQuery(this).hide()}}))}});var rcheckableType=/^(?:checkbox|radio)$/i;var rtagName=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i;var rscriptType=/^$|^module$|\/(?:java|ecma)script/i;(function(){var fragment=document.createDocumentFragment(),div=fragment.appendChild(document.createElement("div")),input=document.createElement("input");input.setAttribute("type","radio");input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);support.checkClone=div.cloneNode(true).cloneNode(true).lastChild.checked;div.innerHTML="<textarea>x</textarea>";support.noCloneChecked=!!div.cloneNode(true).lastChild.defaultValue;div.innerHTML="<option></option>";support.option=!!div.lastChild})();var wrapMap={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!support.option){wrapMap.optgroup=wrapMap.option=[1,"<select multiple='multiple'>","</select>"]}function getAll(context,tag){var ret;if(typeof context.getElementsByTagName!=="undefined"){ret=context.getElementsByTagName(tag||"*")}else if(typeof context.querySelectorAll!=="undefined"){ret=context.querySelectorAll(tag||"*")}else{ret=[]}if(tag===undefined||tag&&nodeName(context,tag)){return jQuery.merge([context],ret)}return ret}function setGlobalEval(elems,refElements){var i=0,l=elems.length;for(;i<l;i++){dataPriv.set(elems[i],"globalEval",!refElements||dataPriv.get(refElements[i],"globalEval"))}}var rhtml=/<|&#?\w+;/;function buildFragment(elems,context,scripts,selection,ignored){var elem,tmp,tag,wrap,attached,j,fragment=context.createDocumentFragment(),nodes=[],i=0,l=elems.length;for(;i<l;i++){elem=elems[i];if(elem||elem===0){if(toType(elem)==="object"){jQuery.merge(nodes,elem.nodeType?[elem]:elem)}else if(!rhtml.test(elem)){nodes.push(context.createTextNode(elem))}else{tmp=tmp||fragment.appendChild(context.createElement("div"));tag=(rtagName.exec(elem)||["",""])[1].toLowerCase();wrap=wrapMap[tag]||wrapMap._default;tmp.innerHTML=wrap[1]+jQuery.htmlPrefilter(elem)+wrap[2];j=wrap[0];while(j--){tmp=tmp.lastChild}jQuery.merge(nodes,tmp.childNodes);tmp=fragment.firstChild;tmp.textContent=""}}}fragment.textContent="";i=0;while(elem=nodes[i++]){if(selection&&jQuery.inArray(elem,selection)>-1){if(ignored){ignored.push(elem)}continue}attached=isAttached(elem);tmp=getAll(fragment.appendChild(elem),"script");if(attached){setGlobalEval(tmp)}if(scripts){j=0;while(elem=tmp[j++]){if(rscriptType.test(elem.type||"")){scripts.push(elem)}}}}return fragment}var rtypenamespace=/^([^.]*)(?:\.(.+)|)/;function returnTrue(){return true}function returnFalse(){return false}function expectSync(elem,type){return elem===safeActiveElement()===(type==="focus")}function safeActiveElement(){try{return document.activeElement}catch(err){}}function on(elem,types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined}for(type in types){on(elem,type,selector,data,types[type],one)}return elem}if(data==null&&fn==null){fn=selector;data=selector=undefined}else if(fn==null){if(typeof selector==="string"){fn=data;data=undefined}else{fn=data;data=selector;selector=undefined}}if(fn===false){fn=returnFalse}else if(!fn){return elem}if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments)};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++)}return elem.each((function(){jQuery.event.add(this,types,fn,data,selector)}))}jQuery.event={global:{},add:function(elem,types,handler,data,selector){var handleObjIn,eventHandle,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.get(elem);if(!acceptData(elem)){return}if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector}if(selector){jQuery.find.matchesSelector(documentElement,selector)}if(!handler.guid){handler.guid=jQuery.guid++}if(!(events=elemData.events)){events=elemData.events=Object.create(null)}if(!(eventHandle=elemData.handle)){eventHandle=elemData.handle=function(e){return typeof jQuery!=="undefined"&&jQuery.event.triggered!==e.type?jQuery.event.dispatch.apply(elem,arguments):undefined}}types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){continue}special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:origType,data:data,handler:handler,guid:handler.guid,selector:selector,needsContext:selector&&jQuery.expr.match.needsContext.test(selector),namespace:namespaces.join(".")},handleObjIn);if(!(handlers=events[type])){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===false){if(elem.addEventListener){elem.addEventListener(type,eventHandle)}}}if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid}}if(selector){handlers.splice(handlers.delegateCount++,0,handleObj)}else{handlers.push(handleObj)}jQuery.event.global[type]=true}},remove:function(elem,types,handler,selector,mappedTypes){var j,origCount,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.hasData(elem)&&dataPriv.get(elem);if(!elemData||!(events=elemData.events)){return}types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,true)}continue}special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;handlers=events[type]||[];tmp=tmp[2]&&new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)");origCount=j=handlers.length;while(j--){handleObj=handlers[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!tmp||tmp.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){handlers.splice(j,1);if(handleObj.selector){handlers.delegateCount--}if(special.remove){special.remove.call(elem,handleObj)}}}if(origCount&&!handlers.length){if(!special.teardown||special.teardown.call(elem,namespaces,elemData.handle)===false){jQuery.removeEvent(elem,type,elemData.handle)}delete events[type]}}if(jQuery.isEmptyObject(events)){dataPriv.remove(elem,"handle events")}},dispatch:function(nativeEvent){var i,j,ret,matched,handleObj,handlerQueue,args=new Array(arguments.length),event=jQuery.event.fix(nativeEvent),handlers=(dataPriv.get(this,"events")||Object.create(null))[event.type]||[],special=jQuery.event.special[event.type]||{};args[0]=event;for(i=1;i<arguments.length;i++){args[i]=arguments[i]}event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===false){return}handlerQueue=jQuery.event.handlers.call(this,event,handlers);i=0;while((matched=handlerQueue[i++])&&!event.isPropagationStopped()){event.currentTarget=matched.elem;j=0;while((handleObj=matched.handlers[j++])&&!event.isImmediatePropagationStopped()){if(!event.rnamespace||handleObj.namespace===false||event.rnamespace.test(handleObj.namespace)){event.handleObj=handleObj;event.data=handleObj.data;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){if((event.result=ret)===false){event.preventDefault();event.stopPropagation()}}}}}if(special.postDispatch){special.postDispatch.call(this,event)}return event.result},handlers:function(event,handlers){var i,handleObj,sel,matchedHandlers,matchedSelectors,handlerQueue=[],delegateCount=handlers.delegateCount,cur=event.target;if(delegateCount&&cur.nodeType&&!(event.type==="click"&&event.button>=1)){for(;cur!==this;cur=cur.parentNode||this){if(cur.nodeType===1&&!(event.type==="click"&&cur.disabled===true)){matchedHandlers=[];matchedSelectors={};for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector+" ";if(matchedSelectors[sel]===undefined){matchedSelectors[sel]=handleObj.needsContext?jQuery(sel,this).index(cur)>-1:jQuery.find(sel,this,null,[cur]).length}if(matchedSelectors[sel]){matchedHandlers.push(handleObj)}}if(matchedHandlers.length){handlerQueue.push({elem:cur,handlers:matchedHandlers})}}}}cur=this;if(delegateCount<handlers.length){handlerQueue.push({elem:cur,handlers:handlers.slice(delegateCount)})}return handlerQueue},addProp:function(name,hook){Object.defineProperty(jQuery.Event.prototype,name,{enumerable:true,configurable:true,get:isFunction(hook)?function(){if(this.originalEvent){return hook(this.originalEvent)}}:function(){if(this.originalEvent){return this.originalEvent[name]}},set:function(value){Object.defineProperty(this,name,{enumerable:true,configurable:true,writable:true,value:value})}})},fix:function(originalEvent){return originalEvent[jQuery.expando]?originalEvent:new jQuery.Event(originalEvent)},special:{load:{noBubble:true},click:{setup:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click",returnTrue)}return false},trigger:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click")}return true},_default:function(event){var target=event.target;return rcheckableType.test(target.type)&&target.click&&nodeName(target,"input")&&dataPriv.get(target,"click")||nodeName(target,"a")}},beforeunload:{postDispatch:function(event){if(event.result!==undefined&&event.originalEvent){event.originalEvent.returnValue=event.result}}}}};function leverageNative(el,type,expectSync){if(!expectSync){if(dataPriv.get(el,type)===undefined){jQuery.event.add(el,type,returnTrue)}return}dataPriv.set(el,type,false);jQuery.event.add(el,type,{namespace:false,handler:function(event){var notAsync,result,saved=dataPriv.get(this,type);if(event.isTrigger&1&&this[type]){if(!saved.length){saved=slice.call(arguments);dataPriv.set(this,type,saved);notAsync=expectSync(this,type);this[type]();result=dataPriv.get(this,type);if(saved!==result||notAsync){dataPriv.set(this,type,false)}else{result={}}if(saved!==result){event.stopImmediatePropagation();event.preventDefault();return result&&result.value}}else if((jQuery.event.special[type]||{}).delegateType){event.stopPropagation()}}else if(saved.length){dataPriv.set(this,type,{value:jQuery.event.trigger(jQuery.extend(saved[0],jQuery.Event.prototype),saved.slice(1),this)});event.stopImmediatePropagation()}}})}jQuery.removeEvent=function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle)}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props)}if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=src.defaultPrevented||src.defaultPrevented===undefined&&src.returnValue===false?returnTrue:returnFalse;this.target=src.target&&src.target.nodeType===3?src.target.parentNode:src.target;this.currentTarget=src.currentTarget;this.relatedTarget=src.relatedTarget}else{this.type=src}if(props){jQuery.extend(this,props)}this.timeStamp=src&&src.timeStamp||Date.now();this[jQuery.expando]=true};jQuery.Event.prototype={constructor:jQuery.Event,isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse,isSimulated:false,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=returnTrue;if(e&&!this.isSimulated){e.preventDefault()}},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopPropagation()}},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopImmediatePropagation()}this.stopPropagation()}};jQuery.each({altKey:true,bubbles:true,cancelable:true,changedTouches:true,ctrlKey:true,detail:true,eventPhase:true,metaKey:true,pageX:true,pageY:true,shiftKey:true,view:true,char:true,code:true,charCode:true,key:true,keyCode:true,button:true,buttons:true,clientX:true,clientY:true,offsetX:true,offsetY:true,pointerId:true,pointerType:true,screenX:true,screenY:true,targetTouches:true,toElement:true,touches:true,which:true},jQuery.event.addProp);jQuery.each({focus:"focusin",blur:"focusout"},(function(type,delegateType){jQuery.event.special[type]={setup:function(){leverageNative(this,type,expectSync);return false},trigger:function(){leverageNative(this,type);return true},_default:function(event){return dataPriv.get(event.target,type)},delegateType:delegateType}}));jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},(function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var ret,target=this,related=event.relatedTarget,handleObj=event.handleObj;if(!related||related!==target&&!jQuery.contains(target,related)){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix}return ret}}}));jQuery.fn.extend({on:function(types,selector,data,fn){return on(this,types,selector,data,fn)},one:function(types,selector,data,fn){return on(this,types,selector,data,fn,1)},off:function(types,selector,fn){var handleObj,type;if(types&&types.preventDefault&&types.handleObj){handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this}if(typeof types==="object"){for(type in types){this.off(type,selector,types[type])}return this}if(selector===false||typeof selector==="function"){fn=selector;selector=undefined}if(fn===false){fn=returnFalse}return this.each((function(){jQuery.event.remove(this,types,fn,selector)}))}});var rnoInnerhtml=/<script|<style|<link/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rcleanScript=/^\s*<!\[CDATA\[|\]\]>\s*$/g;function manipulationTarget(elem,content){if(nodeName(elem,"table")&&nodeName(content.nodeType!==11?content:content.firstChild,"tr")){return jQuery(elem).children("tbody")[0]||elem}return elem}function disableScript(elem){elem.type=(elem.getAttribute("type")!==null)+"/"+elem.type;return elem}function restoreScript(elem){if((elem.type||"").slice(0,5)==="true/"){elem.type=elem.type.slice(5)}else{elem.removeAttribute("type")}return elem}function cloneCopyEvent(src,dest){var i,l,type,pdataOld,udataOld,udataCur,events;if(dest.nodeType!==1){return}if(dataPriv.hasData(src)){pdataOld=dataPriv.get(src);events=pdataOld.events;if(events){dataPriv.remove(dest,"handle events");for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i])}}}}if(dataUser.hasData(src)){udataOld=dataUser.access(src);udataCur=jQuery.extend({},udataOld);dataUser.set(dest,udataCur)}}function fixInput(src,dest){var nodeName=dest.nodeName.toLowerCase();if(nodeName==="input"&&rcheckableType.test(src.type)){dest.checked=src.checked}else if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue}}function domManip(collection,args,callback,ignored){args=flat(args);var fragment,first,scripts,hasScripts,node,doc,i=0,l=collection.length,iNoClone=l-1,value=args[0],valueIsFunction=isFunction(value);if(valueIsFunction||l>1&&typeof value==="string"&&!support.checkClone&&rchecked.test(value)){return collection.each((function(index){var self=collection.eq(index);if(valueIsFunction){args[0]=value.call(this,index,self.html())}domManip(self,args,callback,ignored)}))}if(l){fragment=buildFragment(args,collection[0].ownerDocument,false,collection,ignored);first=fragment.firstChild;if(fragment.childNodes.length===1){fragment=first}if(first||ignored){scripts=jQuery.map(getAll(fragment,"script"),disableScript);hasScripts=scripts.length;for(;i<l;i++){node=fragment;if(i!==iNoClone){node=jQuery.clone(node,true,true);if(hasScripts){jQuery.merge(scripts,getAll(node,"script"))}}callback.call(collection[i],node,i)}if(hasScripts){doc=scripts[scripts.length-1].ownerDocument;jQuery.map(scripts,restoreScript);for(i=0;i<hasScripts;i++){node=scripts[i];if(rscriptType.test(node.type||"")&&!dataPriv.access(node,"globalEval")&&jQuery.contains(doc,node)){if(node.src&&(node.type||"").toLowerCase()!=="module"){if(jQuery._evalUrl&&!node.noModule){jQuery._evalUrl(node.src,{nonce:node.nonce||node.getAttribute("nonce")},doc)}}else{DOMEval(node.textContent.replace(rcleanScript,""),node,doc)}}}}}}return collection}function remove(elem,selector,keepData){var node,nodes=selector?jQuery.filter(selector,elem):elem,i=0;for(;(node=nodes[i])!=null;i++){if(!keepData&&node.nodeType===1){jQuery.cleanData(getAll(node))}if(node.parentNode){if(keepData&&isAttached(node)){setGlobalEval(getAll(node,"script"))}node.parentNode.removeChild(node)}}return elem}jQuery.extend({htmlPrefilter:function(html){return html},clone:function(elem,dataAndEvents,deepDataAndEvents){var i,l,srcElements,destElements,clone=elem.cloneNode(true),inPage=isAttached(elem);if(!support.noCloneChecked&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){destElements=getAll(clone);srcElements=getAll(elem);for(i=0,l=srcElements.length;i<l;i++){fixInput(srcElements[i],destElements[i])}}if(dataAndEvents){if(deepDataAndEvents){srcElements=srcElements||getAll(elem);destElements=destElements||getAll(clone);for(i=0,l=srcElements.length;i<l;i++){cloneCopyEvent(srcElements[i],destElements[i])}}else{cloneCopyEvent(elem,clone)}}destElements=getAll(clone,"script");if(destElements.length>0){setGlobalEval(destElements,!inPage&&getAll(elem,"script"))}return clone},cleanData:function(elems){var data,elem,type,special=jQuery.event.special,i=0;for(;(elem=elems[i])!==undefined;i++){if(acceptData(elem)){if(data=elem[dataPriv.expando]){if(data.events){for(type in data.events){if(special[type]){jQuery.event.remove(elem,type)}else{jQuery.removeEvent(elem,type,data.handle)}}}elem[dataPriv.expando]=undefined}if(elem[dataUser.expando]){elem[dataUser.expando]=undefined}}}}});jQuery.fn.extend({detach:function(selector){return remove(this,selector,true)},remove:function(selector){return remove(this,selector)},text:function(value){return access(this,(function(value){return value===undefined?jQuery.text(this):this.empty().each((function(){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){this.textContent=value}}))}),null,value,arguments.length)},append:function(){return domManip(this,arguments,(function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.appendChild(elem)}}))},prepend:function(){return domManip(this,arguments,(function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.insertBefore(elem,target.firstChild)}}))},before:function(){return domManip(this,arguments,(function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this)}}))},after:function(){return domManip(this,arguments,(function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this.nextSibling)}}))},empty:function(){var elem,i=0;for(;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(getAll(elem,false));elem.textContent=""}}return this},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?false:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map((function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents)}))},html:function(value){return access(this,(function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined&&elem.nodeType===1){return elem.innerHTML}if(typeof value==="string"&&!rnoInnerhtml.test(value)&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=jQuery.htmlPrefilter(value);try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(getAll(elem,false));elem.innerHTML=value}}elem=0}catch(e){}}if(elem){this.empty().append(value)}}),null,value,arguments.length)},replaceWith:function(){var ignored=[];return domManip(this,arguments,(function(elem){var parent=this.parentNode;if(jQuery.inArray(this,ignored)<0){jQuery.cleanData(getAll(this));if(parent){parent.replaceChild(elem,this)}}}),ignored)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},(function(name,original){jQuery.fn[name]=function(selector){var elems,ret=[],insert=jQuery(selector),last=insert.length-1,i=0;for(;i<=last;i++){elems=i===last?this:this.clone(true);jQuery(insert[i])[original](elems);push.apply(ret,elems.get())}return this.pushStack(ret)}}));var rnumnonpx=new RegExp("^("+pnum+")(?!px)[a-z%]+$","i");var rcustomProp=/^--/;var getStyles=function(elem){var view=elem.ownerDocument.defaultView;if(!view||!view.opener){view=window}return view.getComputedStyle(elem)};var swap=function(elem,options,callback){var ret,name,old={};for(name in options){old[name]=elem.style[name];elem.style[name]=options[name]}ret=callback.call(elem);for(name in options){elem.style[name]=old[name]}return ret};var rboxStyle=new RegExp(cssExpand.join("|"),"i");var whitespace="[\\x20\\t\\r\\n\\f]";var rtrimCSS=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g");(function(){function computeStyleTests(){if(!div){return}container.style.cssText="position:absolute;left:-11111px;width:60px;"+"margin-top:1px;padding:0;border:0";div.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;"+"margin:auto;border:1px;padding:1px;"+"width:60%;top:1%";documentElement.appendChild(container).appendChild(div);var divStyle=window.getComputedStyle(div);pixelPositionVal=divStyle.top!=="1%";reliableMarginLeftVal=roundPixelMeasures(divStyle.marginLeft)===12;div.style.right="60%";pixelBoxStylesVal=roundPixelMeasures(divStyle.right)===36;boxSizingReliableVal=roundPixelMeasures(divStyle.width)===36;div.style.position="absolute";scrollboxSizeVal=roundPixelMeasures(div.offsetWidth/3)===12;documentElement.removeChild(container);div=null}function roundPixelMeasures(measure){return Math.round(parseFloat(measure))}var pixelPositionVal,boxSizingReliableVal,scrollboxSizeVal,pixelBoxStylesVal,reliableTrDimensionsVal,reliableMarginLeftVal,container=document.createElement("div"),div=document.createElement("div");if(!div.style){return}div.style.backgroundClip="content-box";div.cloneNode(true).style.backgroundClip="";support.clearCloneStyle=div.style.backgroundClip==="content-box";jQuery.extend(support,{boxSizingReliable:function(){computeStyleTests();return boxSizingReliableVal},pixelBoxStyles:function(){computeStyleTests();return pixelBoxStylesVal},pixelPosition:function(){computeStyleTests();return pixelPositionVal},reliableMarginLeft:function(){computeStyleTests();return reliableMarginLeftVal},scrollboxSize:function(){computeStyleTests();return scrollboxSizeVal},reliableTrDimensions:function(){var table,tr,trChild,trStyle;if(reliableTrDimensionsVal==null){table=document.createElement("table");tr=document.createElement("tr");trChild=document.createElement("div");table.style.cssText="position:absolute;left:-11111px;border-collapse:separate";tr.style.cssText="border:1px solid";tr.style.height="1px";trChild.style.height="9px";trChild.style.display="block";documentElement.appendChild(table).appendChild(tr).appendChild(trChild);trStyle=window.getComputedStyle(tr);reliableTrDimensionsVal=parseInt(trStyle.height,10)+parseInt(trStyle.borderTopWidth,10)+parseInt(trStyle.borderBottomWidth,10)===tr.offsetHeight;documentElement.removeChild(table)}return reliableTrDimensionsVal}})})();function curCSS(elem,name,computed){var width,minWidth,maxWidth,ret,isCustomProp=rcustomProp.test(name),style=elem.style;computed=computed||getStyles(elem);if(computed){ret=computed.getPropertyValue(name)||computed[name];if(isCustomProp&&ret){ret=ret.replace(rtrimCSS,"$1")||undefined}if(ret===""&&!isAttached(elem)){ret=jQuery.style(elem,name)}if(!support.pixelBoxStyles()&&rnumnonpx.test(ret)&&rboxStyle.test(name)){width=style.width;minWidth=style.minWidth;maxWidth=style.maxWidth;style.minWidth=style.maxWidth=style.width=ret;ret=computed.width;style.width=width;style.minWidth=minWidth;style.maxWidth=maxWidth}}return ret!==undefined?ret+"":ret}function addGetHookIf(conditionFn,hookFn){return{get:function(){if(conditionFn()){delete this.get;return}return(this.get=hookFn).apply(this,arguments)}}}var cssPrefixes=["Webkit","Moz","ms"],emptyStyle=document.createElement("div").style,vendorProps={};function vendorPropName(name){var capName=name[0].toUpperCase()+name.slice(1),i=cssPrefixes.length;while(i--){name=cssPrefixes[i]+capName;if(name in emptyStyle){return name}}}function finalPropName(name){var final=jQuery.cssProps[name]||vendorProps[name];if(final){return final}if(name in emptyStyle){return name}return vendorProps[name]=vendorPropName(name)||name}var rdisplayswap=/^(none|table(?!-c[ea]).+)/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssNormalTransform={letterSpacing:"0",fontWeight:"400"};function setPositiveNumber(_elem,value,subtract){var matches=rcssNum.exec(value);return matches?Math.max(0,matches[2]-(subtract||0))+(matches[3]||"px"):value}function boxModelAdjustment(elem,dimension,box,isBorderBox,styles,computedVal){var i=dimension==="width"?1:0,extra=0,delta=0;if(box===(isBorderBox?"border":"content")){return 0}for(;i<4;i+=2){if(box==="margin"){delta+=jQuery.css(elem,box+cssExpand[i],true,styles)}if(!isBorderBox){delta+=jQuery.css(elem,"padding"+cssExpand[i],true,styles);if(box!=="padding"){delta+=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles)}else{extra+=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles)}}else{if(box==="content"){delta-=jQuery.css(elem,"padding"+cssExpand[i],true,styles)}if(box!=="margin"){delta-=jQuery.css(elem,"border"+cssExpand[i]+"Width",true,styles)}}}if(!isBorderBox&&computedVal>=0){delta+=Math.max(0,Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-computedVal-delta-extra-.5))||0}return delta}function getWidthOrHeight(elem,dimension,extra){var styles=getStyles(elem),boxSizingNeeded=!support.boxSizingReliable()||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",false,styles)==="border-box",valueIsBorderBox=isBorderBox,val=curCSS(elem,dimension,styles),offsetProp="offset"+dimension[0].toUpperCase()+dimension.slice(1);if(rnumnonpx.test(val)){if(!extra){return val}val="auto"}if((!support.boxSizingReliable()&&isBorderBox||!support.reliableTrDimensions()&&nodeName(elem,"tr")||val==="auto"||!parseFloat(val)&&jQuery.css(elem,"display",false,styles)==="inline")&&elem.getClientRects().length){isBorderBox=jQuery.css(elem,"boxSizing",false,styles)==="border-box";valueIsBorderBox=offsetProp in elem;if(valueIsBorderBox){val=elem[offsetProp]}}val=parseFloat(val)||0;return val+boxModelAdjustment(elem,dimension,extra||(isBorderBox?"border":"content"),valueIsBorderBox,styles,val)+"px"}jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret}}}},cssNumber:{animationIterationCount:true,columnCount:true,fillOpacity:true,flexGrow:true,flexShrink:true,fontWeight:true,gridArea:true,gridColumn:true,gridColumnEnd:true,gridColumnStart:true,gridRow:true,gridRowEnd:true,gridRowStart:true,lineHeight:true,opacity:true,order:true,orphans:true,widows:true,zIndex:true,zoom:true},cssProps:{},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return}var ret,type,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name),style=elem.style;if(!isCustomProp){name=finalPropName(origName)}hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rcssNum.exec(value))&&ret[1]){value=adjustCSS(elem,name,ret);type="number"}if(value==null||value!==value){return}if(type==="number"&&!isCustomProp){value+=ret&&ret[3]||(jQuery.cssNumber[origName]?"":"px")}if(!support.clearCloneStyle&&value===""&&name.indexOf("background")===0){style[name]="inherit"}if(!hooks||!("set"in hooks)||(value=hooks.set(elem,value,extra))!==undefined){if(isCustomProp){style.setProperty(name,value)}else{style[name]=value}}}else{if(hooks&&"get"in hooks&&(ret=hooks.get(elem,false,extra))!==undefined){return ret}return style[name]}},css:function(elem,name,extra,styles){var val,num,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name);if(!isCustomProp){name=finalPropName(origName)}hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(hooks&&"get"in hooks){val=hooks.get(elem,true,extra)}if(val===undefined){val=curCSS(elem,name,styles)}if(val==="normal"&&name in cssNormalTransform){val=cssNormalTransform[name]}if(extra===""||extra){num=parseFloat(val);return extra===true||isFinite(num)?num||0:val}return val}});jQuery.each(["height","width"],(function(_i,dimension){jQuery.cssHooks[dimension]={get:function(elem,computed,extra){if(computed){return rdisplayswap.test(jQuery.css(elem,"display"))&&(!elem.getClientRects().length||!elem.getBoundingClientRect().width)?swap(elem,cssShow,(function(){return getWidthOrHeight(elem,dimension,extra)})):getWidthOrHeight(elem,dimension,extra)}},set:function(elem,value,extra){var matches,styles=getStyles(elem),scrollboxSizeBuggy=!support.scrollboxSize()&&styles.position==="absolute",boxSizingNeeded=scrollboxSizeBuggy||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",false,styles)==="border-box",subtract=extra?boxModelAdjustment(elem,dimension,extra,isBorderBox,styles):0;if(isBorderBox&&scrollboxSizeBuggy){subtract-=Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-parseFloat(styles[dimension])-boxModelAdjustment(elem,dimension,"border",false,styles)-.5)}if(subtract&&(matches=rcssNum.exec(value))&&(matches[3]||"px")!=="px"){elem.style[dimension]=value;value=jQuery.css(elem,dimension)}return setPositiveNumber(elem,value,subtract)}}}));jQuery.cssHooks.marginLeft=addGetHookIf(support.reliableMarginLeft,(function(elem,computed){if(computed){return(parseFloat(curCSS(elem,"marginLeft"))||elem.getBoundingClientRect().left-swap(elem,{marginLeft:0},(function(){return elem.getBoundingClientRect().left})))+"px"}}));jQuery.each({margin:"",padding:"",border:"Width"},(function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i=0,expanded={},parts=typeof value==="string"?value.split(" "):[value];for(;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0]}return expanded}};if(prefix!=="margin"){jQuery.cssHooks[prefix+suffix].set=setPositiveNumber}}));jQuery.fn.extend({css:function(name,value){return access(this,(function(elem,name,value){var styles,len,map={},i=0;if(Array.isArray(name)){styles=getStyles(elem);len=name.length;for(;i<len;i++){map[name[i]]=jQuery.css(elem,name[i],false,styles)}return map}return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name)}),name,value,arguments.length>1)}});function Tween(elem,options,prop,end,easing){return new Tween.prototype.init(elem,options,prop,end,easing)}jQuery.Tween=Tween;Tween.prototype={constructor:Tween,init:function(elem,options,prop,end,easing,unit){this.elem=elem;this.prop=prop;this.easing=easing||jQuery.easing._default;this.options=options;this.start=this.now=this.cur();this.end=end;this.unit=unit||(jQuery.cssNumber[prop]?"":"px")},cur:function(){var hooks=Tween.propHooks[this.prop];return hooks&&hooks.get?hooks.get(this):Tween.propHooks._default.get(this)},run:function(percent){var eased,hooks=Tween.propHooks[this.prop];if(this.options.duration){this.pos=eased=jQuery.easing[this.easing](percent,this.options.duration*percent,0,1,this.options.duration)}else{this.pos=eased=percent}this.now=(this.end-this.start)*eased+this.start;if(this.options.step){this.options.step.call(this.elem,this.now,this)}if(hooks&&hooks.set){hooks.set(this)}else{Tween.propHooks._default.set(this)}return this}};Tween.prototype.init.prototype=Tween.prototype;Tween.propHooks={_default:{get:function(tween){var result;if(tween.elem.nodeType!==1||tween.elem[tween.prop]!=null&&tween.elem.style[tween.prop]==null){return tween.elem[tween.prop]}result=jQuery.css(tween.elem,tween.prop,"");return!result||result==="auto"?0:result},set:function(tween){if(jQuery.fx.step[tween.prop]){jQuery.fx.step[tween.prop](tween)}else if(tween.elem.nodeType===1&&(jQuery.cssHooks[tween.prop]||tween.elem.style[finalPropName(tween.prop)]!=null)){jQuery.style(tween.elem,tween.prop,tween.now+tween.unit)}else{tween.elem[tween.prop]=tween.now}}}};Tween.propHooks.scrollTop=Tween.propHooks.scrollLeft={set:function(tween){if(tween.elem.nodeType&&tween.elem.parentNode){tween.elem[tween.prop]=tween.now}}};jQuery.easing={linear:function(p){return p},swing:function(p){return.5-Math.cos(p*Math.PI)/2},_default:"swing"};jQuery.fx=Tween.prototype.init;jQuery.fx.step={};var fxNow,inProgress,rfxtypes=/^(?:toggle|show|hide)$/,rrun=/queueHooks$/;function schedule(){if(inProgress){if(document.hidden===false&&window.requestAnimationFrame){window.requestAnimationFrame(schedule)}else{window.setTimeout(schedule,jQuery.fx.interval)}jQuery.fx.tick()}}function createFxNow(){window.setTimeout((function(){fxNow=undefined}));return fxNow=Date.now()}function genFx(type,includeWidth){var which,i=0,attrs={height:type};includeWidth=includeWidth?1:0;for(;i<4;i+=2-includeWidth){which=cssExpand[i];attrs["margin"+which]=attrs["padding"+which]=type}if(includeWidth){attrs.opacity=attrs.width=type}return attrs}function createTween(value,prop,animation){var tween,collection=(Animation.tweeners[prop]||[]).concat(Animation.tweeners["*"]),index=0,length=collection.length;for(;index<length;index++){if(tween=collection[index].call(animation,prop,value)){return tween}}}function defaultPrefilter(elem,props,opts){var prop,value,toggle,hooks,oldfire,propTween,restoreDisplay,display,isBox="width"in props||"height"in props,anim=this,orig={},style=elem.style,hidden=elem.nodeType&&isHiddenWithinTree(elem),dataShow=dataPriv.get(elem,"fxshow");if(!opts.queue){hooks=jQuery._queueHooks(elem,"fx");if(hooks.unqueued==null){hooks.unqueued=0;oldfire=hooks.empty.fire;hooks.empty.fire=function(){if(!hooks.unqueued){oldfire()}}}hooks.unqueued++;anim.always((function(){anim.always((function(){hooks.unqueued--;if(!jQuery.queue(elem,"fx").length){hooks.empty.fire()}}))}))}for(prop in props){value=props[prop];if(rfxtypes.test(value)){delete props[prop];toggle=toggle||value==="toggle";if(value===(hidden?"hide":"show")){if(value==="show"&&dataShow&&dataShow[prop]!==undefined){hidden=true}else{continue}}orig[prop]=dataShow&&dataShow[prop]||jQuery.style(elem,prop)}}propTween=!jQuery.isEmptyObject(props);if(!propTween&&jQuery.isEmptyObject(orig)){return}if(isBox&&elem.nodeType===1){opts.overflow=[style.overflow,style.overflowX,style.overflowY];restoreDisplay=dataShow&&dataShow.display;if(restoreDisplay==null){restoreDisplay=dataPriv.get(elem,"display")}display=jQuery.css(elem,"display");if(display==="none"){if(restoreDisplay){display=restoreDisplay}else{showHide([elem],true);restoreDisplay=elem.style.display||restoreDisplay;display=jQuery.css(elem,"display");showHide([elem])}}if(display==="inline"||display==="inline-block"&&restoreDisplay!=null){if(jQuery.css(elem,"float")==="none"){if(!propTween){anim.done((function(){style.display=restoreDisplay}));if(restoreDisplay==null){display=style.display;restoreDisplay=display==="none"?"":display}}style.display="inline-block"}}}if(opts.overflow){style.overflow="hidden";anim.always((function(){style.overflow=opts.overflow[0];style.overflowX=opts.overflow[1];style.overflowY=opts.overflow[2]}))}propTween=false;for(prop in orig){if(!propTween){if(dataShow){if("hidden"in dataShow){hidden=dataShow.hidden}}else{dataShow=dataPriv.access(elem,"fxshow",{display:restoreDisplay})}if(toggle){dataShow.hidden=!hidden}if(hidden){showHide([elem],true)}anim.done((function(){if(!hidden){showHide([elem])}dataPriv.remove(elem,"fxshow");for(prop in orig){jQuery.style(elem,prop,orig[prop])}}))}propTween=createTween(hidden?dataShow[prop]:0,prop,anim);if(!(prop in dataShow)){dataShow[prop]=propTween.start;if(hidden){propTween.end=propTween.start;propTween.start=0}}}}function propFilter(props,specialEasing){var index,name,easing,value,hooks;for(index in props){name=camelCase(index);easing=specialEasing[name];value=props[index];if(Array.isArray(value)){easing=value[1];value=props[index]=value[0]}if(index!==name){props[name]=value;delete props[index]}hooks=jQuery.cssHooks[name];if(hooks&&"expand"in hooks){value=hooks.expand(value);delete props[name];for(index in value){if(!(index in props)){props[index]=value[index];specialEasing[index]=easing}}}else{specialEasing[name]=easing}}}function Animation(elem,properties,options){var result,stopped,index=0,length=Animation.prefilters.length,deferred=jQuery.Deferred().always((function(){delete tick.elem})),tick=function(){if(stopped){return false}var currentTime=fxNow||createFxNow(),remaining=Math.max(0,animation.startTime+animation.duration-currentTime),temp=remaining/animation.duration||0,percent=1-temp,index=0,length=animation.tweens.length;for(;index<length;index++){animation.tweens[index].run(percent)}deferred.notifyWith(elem,[animation,percent,remaining]);if(percent<1&&length){return remaining}if(!length){deferred.notifyWith(elem,[animation,1,0])}deferred.resolveWith(elem,[animation]);return false},animation=deferred.promise({elem:elem,props:jQuery.extend({},properties),opts:jQuery.extend(true,{specialEasing:{},easing:jQuery.easing._default},options),originalProperties:properties,originalOptions:options,startTime:fxNow||createFxNow(),duration:options.duration,tweens:[],createTween:function(prop,end){var tween=jQuery.Tween(elem,animation.opts,prop,end,animation.opts.specialEasing[prop]||animation.opts.easing);animation.tweens.push(tween);return tween},stop:function(gotoEnd){var index=0,length=gotoEnd?animation.tweens.length:0;if(stopped){return this}stopped=true;for(;index<length;index++){animation.tweens[index].run(1)}if(gotoEnd){deferred.notifyWith(elem,[animation,1,0]);deferred.resolveWith(elem,[animation,gotoEnd])}else{deferred.rejectWith(elem,[animation,gotoEnd])}return this}}),props=animation.props;propFilter(props,animation.opts.specialEasing);for(;index<length;index++){result=Animation.prefilters[index].call(animation,elem,props,animation.opts);if(result){if(isFunction(result.stop)){jQuery._queueHooks(animation.elem,animation.opts.queue).stop=result.stop.bind(result)}return result}}jQuery.map(props,createTween,animation);if(isFunction(animation.opts.start)){animation.opts.start.call(elem,animation)}animation.progress(animation.opts.progress).done(animation.opts.done,animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);jQuery.fx.timer(jQuery.extend(tick,{elem:elem,anim:animation,queue:animation.opts.queue}));return animation}jQuery.Animation=jQuery.extend(Animation,{tweeners:{"*":[function(prop,value){var tween=this.createTween(prop,value);adjustCSS(tween.elem,prop,rcssNum.exec(value),tween);return tween}]},tweener:function(props,callback){if(isFunction(props)){callback=props;props=["*"]}else{props=props.match(rnothtmlwhite)}var prop,index=0,length=props.length;for(;index<length;index++){prop=props[index];Animation.tweeners[prop]=Animation.tweeners[prop]||[];Animation.tweeners[prop].unshift(callback)}},prefilters:[defaultPrefilter],prefilter:function(callback,prepend){if(prepend){Animation.prefilters.unshift(callback)}else{Animation.prefilters.push(callback)}}});jQuery.speed=function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!isFunction(easing)&&easing};if(jQuery.fx.off){opt.duration=0}else{if(typeof opt.duration!=="number"){if(opt.duration in jQuery.fx.speeds){opt.duration=jQuery.fx.speeds[opt.duration]}else{opt.duration=jQuery.fx.speeds._default}}}if(opt.queue==null||opt.queue===true){opt.queue="fx"}opt.old=opt.complete;opt.complete=function(){if(isFunction(opt.old)){opt.old.call(this)}if(opt.queue){jQuery.dequeue(this,opt.queue)}};return opt};jQuery.fn.extend({fadeTo:function(speed,to,easing,callback){return this.filter(isHiddenWithinTree).css("opacity",0).show().end().animate({opacity:to},speed,easing,callback)},animate:function(prop,speed,easing,callback){var empty=jQuery.isEmptyObject(prop),optall=jQuery.speed(speed,easing,callback),doAnimation=function(){var anim=Animation(this,jQuery.extend({},prop),optall);if(empty||dataPriv.get(this,"finish")){anim.stop(true)}};doAnimation.finish=doAnimation;return empty||optall.queue===false?this.each(doAnimation):this.queue(optall.queue,doAnimation)},stop:function(type,clearQueue,gotoEnd){var stopQueue=function(hooks){var stop=hooks.stop;delete hooks.stop;stop(gotoEnd)};if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined}if(clearQueue){this.queue(type||"fx",[])}return this.each((function(){var dequeue=true,index=type!=null&&type+"queueHooks",timers=jQuery.timers,data=dataPriv.get(this);if(index){if(data[index]&&data[index].stop){stopQueue(data[index])}}else{for(index in data){if(data[index]&&data[index].stop&&rrun.test(index)){stopQueue(data[index])}}}for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){timers[index].anim.stop(gotoEnd);dequeue=false;timers.splice(index,1)}}if(dequeue||!gotoEnd){jQuery.dequeue(this,type)}}))},finish:function(type){if(type!==false){type=type||"fx"}return this.each((function(){var index,data=dataPriv.get(this),queue=data[type+"queue"],hooks=data[type+"queueHooks"],timers=jQuery.timers,length=queue?queue.length:0;data.finish=true;jQuery.queue(this,type,[]);if(hooks&&hooks.stop){hooks.stop.call(this,true)}for(index=timers.length;index--;){if(timers[index].elem===this&&timers[index].queue===type){timers[index].anim.stop(true);timers.splice(index,1)}}for(index=0;index<length;index++){if(queue[index]&&queue[index].finish){queue[index].finish.call(this)}}delete data.finish}))}});jQuery.each(["toggle","show","hide"],(function(_i,name){var cssFn=jQuery.fn[name];jQuery.fn[name]=function(speed,easing,callback){return speed==null||typeof speed==="boolean"?cssFn.apply(this,arguments):this.animate(genFx(name,true),speed,easing,callback)}}));jQuery.each({slideDown:genFx("show"),slideUp:genFx("hide"),slideToggle:genFx("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},(function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback)}}));jQuery.timers=[];jQuery.fx.tick=function(){var timer,i=0,timers=jQuery.timers;fxNow=Date.now();for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1)}}if(!timers.length){jQuery.fx.stop()}fxNow=undefined};jQuery.fx.timer=function(timer){jQuery.timers.push(timer);jQuery.fx.start()};jQuery.fx.interval=13;jQuery.fx.start=function(){if(inProgress){return}inProgress=true;schedule()};jQuery.fx.stop=function(){inProgress=null};jQuery.fx.speeds={slow:600,fast:200,_default:400};jQuery.fn.delay=function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,(function(next,hooks){var timeout=window.setTimeout(next,time);hooks.stop=function(){window.clearTimeout(timeout)}}))};(function(){var input=document.createElement("input"),select=document.createElement("select"),opt=select.appendChild(document.createElement("option"));input.type="checkbox";support.checkOn=input.value!=="";support.optSelected=opt.selected;input=document.createElement("input");input.value="t";input.type="radio";support.radioValue=input.value==="t"})();var boolHook,attrHandle=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(name,value){return access(this,jQuery.attr,name,value,arguments.length>1)},removeAttr:function(name){return this.each((function(){jQuery.removeAttr(this,name)}))}});jQuery.extend({attr:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value)}if(nType!==1||!jQuery.isXMLDoc(elem)){hooks=jQuery.attrHooks[name.toLowerCase()]||(jQuery.expr.match.bool.test(name)?boolHook:undefined)}if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return}if(hooks&&"set"in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}elem.setAttribute(name,value+"");return value}if(hooks&&"get"in hooks&&(ret=hooks.get(elem,name))!==null){return ret}ret=jQuery.find.attr(elem,name);return ret==null?undefined:ret},attrHooks:{type:{set:function(elem,value){if(!support.radioValue&&value==="radio"&&nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val}return value}}}},removeAttr:function(elem,value){var name,i=0,attrNames=value&&value.match(rnothtmlwhite);if(attrNames&&elem.nodeType===1){while(name=attrNames[i++]){elem.removeAttribute(name)}}}});boolHook={set:function(elem,value,name){if(value===false){jQuery.removeAttr(elem,name)}else{elem.setAttribute(name,name)}return name}};jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),(function(_i,name){var getter=attrHandle[name]||jQuery.find.attr;attrHandle[name]=function(elem,name,isXML){var ret,handle,lowercaseName=name.toLowerCase();if(!isXML){handle=attrHandle[lowercaseName];attrHandle[lowercaseName]=ret;ret=getter(elem,name,isXML)!=null?lowercaseName:null;attrHandle[lowercaseName]=handle}return ret}}));var rfocusable=/^(?:input|select|textarea|button)$/i,rclickable=/^(?:a|area)$/i;jQuery.fn.extend({prop:function(name,value){return access(this,jQuery.prop,name,value,arguments.length>1)},removeProp:function(name){return this.each((function(){delete this[jQuery.propFix[name]||name]}))}});jQuery.extend({prop:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}if(nType!==1||!jQuery.isXMLDoc(elem)){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name]}if(value!==undefined){if(hooks&&"set"in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}return elem[name]=value}if(hooks&&"get"in hooks&&(ret=hooks.get(elem,name))!==null){return ret}return elem[name]},propHooks:{tabIndex:{get:function(elem){var tabindex=jQuery.find.attr(elem,"tabindex");if(tabindex){return parseInt(tabindex,10)}if(rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href){return 0}return-1}}},propFix:{for:"htmlFor",class:"className"}});if(!support.optSelected){jQuery.propHooks.selected={get:function(elem){var parent=elem.parentNode;if(parent&&parent.parentNode){parent.parentNode.selectedIndex}return null},set:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex}}}}}jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],(function(){jQuery.propFix[this.toLowerCase()]=this}));function stripAndCollapse(value){var tokens=value.match(rnothtmlwhite)||[];return tokens.join(" ")}function getClass(elem){return elem.getAttribute&&elem.getAttribute("class")||""}function classesToArray(value){if(Array.isArray(value)){return value}if(typeof value==="string"){return value.match(rnothtmlwhite)||[]}return[]}jQuery.fn.extend({addClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each((function(j){jQuery(this).addClass(value.call(this,j,getClass(this)))}))}classNames=classesToArray(value);if(classNames.length){return this.each((function(){curValue=getClass(this);cur=this.nodeType===1&&" "+stripAndCollapse(curValue)+" ";if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];if(cur.indexOf(" "+className+" ")<0){cur+=className+" "}}finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}}))}return this},removeClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each((function(j){jQuery(this).removeClass(value.call(this,j,getClass(this)))}))}if(!arguments.length){return this.attr("class","")}classNames=classesToArray(value);if(classNames.length){return this.each((function(){curValue=getClass(this);cur=this.nodeType===1&&" "+stripAndCollapse(curValue)+" ";if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];while(cur.indexOf(" "+className+" ")>-1){cur=cur.replace(" "+className+" "," ")}}finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}}))}return this},toggleClass:function(value,stateVal){var classNames,className,i,self,type=typeof value,isValidValue=type==="string"||Array.isArray(value);if(isFunction(value)){return this.each((function(i){jQuery(this).toggleClass(value.call(this,i,getClass(this),stateVal),stateVal)}))}if(typeof stateVal==="boolean"&&isValidValue){return stateVal?this.addClass(value):this.removeClass(value)}classNames=classesToArray(value);return this.each((function(){if(isValidValue){self=jQuery(this);for(i=0;i<classNames.length;i++){className=classNames[i];if(self.hasClass(className)){self.removeClass(className)}else{self.addClass(className)}}}else if(value===undefined||type==="boolean"){className=getClass(this);if(className){dataPriv.set(this,"__className__",className)}if(this.setAttribute){this.setAttribute("class",className||value===false?"":dataPriv.get(this,"__className__")||"")}}}))},hasClass:function(selector){var className,elem,i=0;className=" "+selector+" ";while(elem=this[i++]){if(elem.nodeType===1&&(" "+stripAndCollapse(getClass(elem))+" ").indexOf(className)>-1){return true}}return false}});var rreturn=/\r/g;jQuery.fn.extend({val:function(value){var hooks,ret,valueIsFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get"in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret}ret=elem.value;if(typeof ret==="string"){return ret.replace(rreturn,"")}return ret==null?"":ret}return}valueIsFunction=isFunction(value);return this.each((function(i){var val;if(this.nodeType!==1){return}if(valueIsFunction){val=value.call(this,i,jQuery(this).val())}else{val=value}if(val==null){val=""}else if(typeof val==="number"){val+=""}else if(Array.isArray(val)){val=jQuery.map(val,(function(value){return value==null?"":value+""}))}hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set"in hooks)||hooks.set(this,val,"value")===undefined){this.value=val}}))}});jQuery.extend({valHooks:{option:{get:function(elem){var val=jQuery.find.attr(elem,"value");return val!=null?val:stripAndCollapse(jQuery.text(elem))}},select:{get:function(elem){var value,option,i,options=elem.options,index=elem.selectedIndex,one=elem.type==="select-one",values=one?null:[],max=one?index+1:options.length;if(index<0){i=max}else{i=one?index:0}for(;i<max;i++){option=options[i];if((option.selected||i===index)&&!option.disabled&&(!option.parentNode.disabled||!nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value}values.push(value)}}return values},set:function(elem,value){var optionSet,option,options=elem.options,values=jQuery.makeArray(value),i=options.length;while(i--){option=options[i];if(option.selected=jQuery.inArray(jQuery.valHooks.option.get(option),values)>-1){optionSet=true}}if(!optionSet){elem.selectedIndex=-1}return values}}}});jQuery.each(["radio","checkbox"],(function(){jQuery.valHooks[this]={set:function(elem,value){if(Array.isArray(value)){return elem.checked=jQuery.inArray(jQuery(elem).val(),value)>-1}}};if(!support.checkOn){jQuery.valHooks[this].get=function(elem){return elem.getAttribute("value")===null?"on":elem.value}}}));support.focusin="onfocusin"in window;var rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,stopPropagationCallback=function(e){e.stopPropagation()};jQuery.extend(jQuery.event,{trigger:function(event,data,elem,onlyHandlers){var i,cur,tmp,bubbleType,ontype,handle,special,lastElement,eventPath=[elem||document],type=hasOwn.call(event,"type")?event.type:event,namespaces=hasOwn.call(event,"namespace")?event.namespace.split("."):[];cur=lastElement=tmp=elem=elem||document;if(elem.nodeType===3||elem.nodeType===8){return}if(rfocusMorph.test(type+jQuery.event.triggered)){return}if(type.indexOf(".")>-1){namespaces=type.split(".");type=namespaces.shift();namespaces.sort()}ontype=type.indexOf(":")<0&&"on"+type;event=event[jQuery.expando]?event:new jQuery.Event(type,typeof event==="object"&&event);event.isTrigger=onlyHandlers?2:3;event.namespace=namespaces.join(".");event.rnamespace=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"):null;event.result=undefined;if(!event.target){event.target=elem}data=data==null?[event]:jQuery.makeArray(data,[event]);special=jQuery.event.special[type]||{};if(!onlyHandlers&&special.trigger&&special.trigger.apply(elem,data)===false){return}if(!onlyHandlers&&!special.noBubble&&!isWindow(elem)){bubbleType=special.delegateType||type;if(!rfocusMorph.test(bubbleType+type)){cur=cur.parentNode}for(;cur;cur=cur.parentNode){eventPath.push(cur);tmp=cur}if(tmp===(elem.ownerDocument||document)){eventPath.push(tmp.defaultView||tmp.parentWindow||window)}}i=0;while((cur=eventPath[i++])&&!event.isPropagationStopped()){lastElement=cur;event.type=i>1?bubbleType:special.bindType||type;handle=(dataPriv.get(cur,"events")||Object.create(null))[event.type]&&dataPriv.get(cur,"handle");if(handle){handle.apply(cur,data)}handle=ontype&&cur[ontype];if(handle&&handle.apply&&acceptData(cur)){event.result=handle.apply(cur,data);if(event.result===false){event.preventDefault()}}}event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(eventPath.pop(),data)===false)&&acceptData(elem)){if(ontype&&isFunction(elem[type])&&!isWindow(elem)){tmp=elem[ontype];if(tmp){elem[ontype]=null}jQuery.event.triggered=type;if(event.isPropagationStopped()){lastElement.addEventListener(type,stopPropagationCallback)}elem[type]();if(event.isPropagationStopped()){lastElement.removeEventListener(type,stopPropagationCallback)}jQuery.event.triggered=undefined;if(tmp){elem[ontype]=tmp}}}}return event.result},simulate:function(type,elem,event){var e=jQuery.extend(new jQuery.Event,event,{type:type,isSimulated:true});jQuery.event.trigger(e,null,elem)}});jQuery.fn.extend({trigger:function(type,data){return this.each((function(){jQuery.event.trigger(type,data,this)}))},triggerHandler:function(type,data){var elem=this[0];if(elem){return jQuery.event.trigger(type,data,elem,true)}}});if(!support.focusin){jQuery.each({focus:"focusin",blur:"focusout"},(function(orig,fix){var handler=function(event){jQuery.event.simulate(fix,event.target,jQuery.event.fix(event))};jQuery.event.special[fix]={setup:function(){var doc=this.ownerDocument||this.document||this,attaches=dataPriv.access(doc,fix);if(!attaches){doc.addEventListener(orig,handler,true)}dataPriv.access(doc,fix,(attaches||0)+1)},teardown:function(){var doc=this.ownerDocument||this.document||this,attaches=dataPriv.access(doc,fix)-1;if(!attaches){doc.removeEventListener(orig,handler,true);dataPriv.remove(doc,fix)}else{dataPriv.access(doc,fix,attaches)}}}}))}var location=window.location;var nonce={guid:Date.now()};var rquery=/\?/;jQuery.parseXML=function(data){var xml,parserErrorElem;if(!data||typeof data!=="string"){return null}try{xml=(new window.DOMParser).parseFromString(data,"text/xml")}catch(e){}parserErrorElem=xml&&xml.getElementsByTagName("parsererror")[0];if(!xml||parserErrorElem){jQuery.error("Invalid XML: "+(parserErrorElem?jQuery.map(parserErrorElem.childNodes,(function(el){return el.textContent})).join("\n"):data))}return xml};var rbracket=/\[\]$/,rCRLF=/\r?\n/g,rsubmitterTypes=/^(?:submit|button|image|reset|file)$/i,rsubmittable=/^(?:input|select|textarea|keygen)/i;function buildParams(prefix,obj,traditional,add){var name;if(Array.isArray(obj)){jQuery.each(obj,(function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v)}else{buildParams(prefix+"["+(typeof v==="object"&&v!=null?i:"")+"]",v,traditional,add)}}))}else if(!traditional&&toType(obj)==="object"){for(name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add)}}else{add(prefix,obj)}}jQuery.param=function(a,traditional){var prefix,s=[],add=function(key,valueOrFunction){var value=isFunction(valueOrFunction)?valueOrFunction():valueOrFunction;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value==null?"":value)};if(a==null){return""}if(Array.isArray(a)||a.jquery&&!jQuery.isPlainObject(a)){jQuery.each(a,(function(){add(this.name,this.value)}))}else{for(prefix in a){buildParams(prefix,a[prefix],traditional,add)}}return s.join("&")};jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map((function(){var elements=jQuery.prop(this,"elements");return elements?jQuery.makeArray(elements):this})).filter((function(){var type=this.type;return this.name&&!jQuery(this).is(":disabled")&&rsubmittable.test(this.nodeName)&&!rsubmitterTypes.test(type)&&(this.checked||!rcheckableType.test(type))})).map((function(_i,elem){var val=jQuery(this).val();if(val==null){return null}if(Array.isArray(val)){return jQuery.map(val,(function(val){return{name:elem.name,value:val.replace(rCRLF,"\r\n")}}))}return{name:elem.name,value:val.replace(rCRLF,"\r\n")}})).get()}});var r20=/%20/g,rhash=/#.*$/,rantiCache=/([?&])_=[^&]*/,rheaders=/^(.*?):[ \t]*([^\r\n]*)$/gm,rlocalProtocol=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,prefilters={},transports={},allTypes="*/".concat("*"),originAnchor=document.createElement("a");originAnchor.href=location.href;function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*"}var dataType,i=0,dataTypes=dataTypeExpression.toLowerCase().match(rnothtmlwhite)||[];if(isFunction(func)){while(dataType=dataTypes[i++]){if(dataType[0]==="+"){dataType=dataType.slice(1)||"*";(structure[dataType]=structure[dataType]||[]).unshift(func)}else{(structure[dataType]=structure[dataType]||[]).push(func)}}}}}function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR){var inspected={},seekingTransport=structure===transports;function inspect(dataType){var selected;inspected[dataType]=true;jQuery.each(structure[dataType]||[],(function(_,prefilterOrFactory){var dataTypeOrTransport=prefilterOrFactory(options,originalOptions,jqXHR);if(typeof dataTypeOrTransport==="string"&&!seekingTransport&&!inspected[dataTypeOrTransport]){options.dataTypes.unshift(dataTypeOrTransport);inspect(dataTypeOrTransport);return false}else if(seekingTransport){return!(selected=dataTypeOrTransport)}}));return selected}return inspect(options.dataTypes[0])||!inspected["*"]&&inspect("*")}function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:deep||(deep={}))[key]=src[key]}}if(deep){jQuery.extend(true,target,deep)}return target}function ajaxHandleResponses(s,jqXHR,responses){var ct,type,finalDataType,firstDataType,contents=s.contents,dataTypes=s.dataTypes;while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("Content-Type")}}if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break}}}if(dataTypes[0]in responses){finalDataType=dataTypes[0]}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break}if(!firstDataType){firstDataType=type}}finalDataType=finalDataType||firstDataType}if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType)}return responses[finalDataType]}}function ajaxConvert(s,response,jqXHR,isSuccess){var conv2,current,conv,tmp,prev,converters={},dataTypes=s.dataTypes.slice();if(dataTypes[1]){for(conv in s.converters){converters[conv.toLowerCase()]=s.converters[conv]}}current=dataTypes.shift();while(current){if(s.responseFields[current]){jqXHR[s.responseFields[current]]=response}if(!prev&&isSuccess&&s.dataFilter){response=s.dataFilter(response,s.dataType)}prev=current;current=dataTypes.shift();if(current){if(current==="*"){current=prev}else if(prev!=="*"&&prev!==current){conv=converters[prev+" "+current]||converters["* "+current];if(!conv){for(conv2 in converters){tmp=conv2.split(" ");if(tmp[1]===current){conv=converters[prev+" "+tmp[0]]||converters["* "+tmp[0]];if(conv){if(conv===true){conv=converters[conv2]}else if(converters[conv2]!==true){current=tmp[0];dataTypes.unshift(tmp[1])}break}}}}if(conv!==true){if(conv&&s.throws){response=conv(response)}else{try{response=conv(response)}catch(e){return{state:"parsererror",error:conv?e:"No conversion from "+prev+" to "+current}}}}}}}return{state:"success",data:response}}jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:location.href,type:"GET",isLocal:rlocalProtocol.test(location.protocol),global:true,processData:true,async:true,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":allTypes,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":true,"text json":JSON.parse,"text xml":jQuery.parseXML},flatOptions:{url:true,context:true}},ajaxSetup:function(target,settings){return settings?ajaxExtend(ajaxExtend(target,jQuery.ajaxSettings),settings):ajaxExtend(jQuery.ajaxSettings,target)},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined}options=options||{};var transport,cacheURL,responseHeadersString,responseHeaders,timeoutTimer,urlAnchor,completed,fireGlobals,i,uncached,s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=s.context&&(callbackContext.nodeType||callbackContext.jquery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},requestHeaders={},requestHeadersNames={},strAbort="canceled",jqXHR={readyState:0,getResponseHeader:function(key){var match;if(completed){if(!responseHeaders){responseHeaders={};while(match=rheaders.exec(responseHeadersString)){responseHeaders[match[1].toLowerCase()+" "]=(responseHeaders[match[1].toLowerCase()+" "]||[]).concat(match[2])}}match=responseHeaders[key.toLowerCase()+" "]}return match==null?null:match.join(", ")},getAllResponseHeaders:function(){return completed?responseHeadersString:null},setRequestHeader:function(name,value){if(completed==null){name=requestHeadersNames[name.toLowerCase()]=requestHeadersNames[name.toLowerCase()]||name;requestHeaders[name]=value}return this},overrideMimeType:function(type){if(completed==null){s.mimeType=type}return this},statusCode:function(map){var code;if(map){if(completed){jqXHR.always(map[jqXHR.status])}else{for(code in map){statusCode[code]=[statusCode[code],map[code]]}}}return this},abort:function(statusText){var finalText=statusText||strAbort;if(transport){transport.abort(finalText)}done(0,finalText);return this}};deferred.promise(jqXHR);s.url=((url||s.url||location.href)+"").replace(rprotocol,location.protocol+"//");s.type=options.method||options.type||s.method||s.type;s.dataTypes=(s.dataType||"*").toLowerCase().match(rnothtmlwhite)||[""];if(s.crossDomain==null){urlAnchor=document.createElement("a");try{urlAnchor.href=s.url;urlAnchor.href=urlAnchor.href;s.crossDomain=originAnchor.protocol+"//"+originAnchor.host!==urlAnchor.protocol+"//"+urlAnchor.host}catch(e){s.crossDomain=true}}if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional)}inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(completed){return jqXHR}fireGlobals=jQuery.event&&s.global;if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart")}s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);cacheURL=s.url.replace(rhash,"");if(!s.hasContent){uncached=s.url.slice(cacheURL.length);if(s.data&&(s.processData||typeof s.data==="string")){cacheURL+=(rquery.test(cacheURL)?"&":"?")+s.data;delete s.data}if(s.cache===false){cacheURL=cacheURL.replace(rantiCache,"$1");uncached=(rquery.test(cacheURL)?"&":"?")+"_="+nonce.guid+++uncached}s.url=cacheURL+uncached}else if(s.data&&s.processData&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0){s.data=s.data.replace(r20,"+")}if(s.ifModified){if(jQuery.lastModified[cacheURL]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[cacheURL])}if(jQuery.etag[cacheURL]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[cacheURL])}}if(s.data&&s.hasContent&&s.contentType!==false||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType)}jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i])}if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===false||completed)){return jqXHR.abort()}strAbort="abort";completeDeferred.add(s.complete);jqXHR.done(s.success);jqXHR.fail(s.error);transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport")}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s])}if(completed){return jqXHR}if(s.async&&s.timeout>0){timeoutTimer=window.setTimeout((function(){jqXHR.abort("timeout")}),s.timeout)}try{completed=false;transport.send(requestHeaders,done)}catch(e){if(completed){throw e}done(-1,e)}}function done(status,nativeStatusText,responses,headers){var isSuccess,success,error,response,modified,statusText=nativeStatusText;if(completed){return}completed=true;if(timeoutTimer){window.clearTimeout(timeoutTimer)}transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;isSuccess=status>=200&&status<300||status===304;if(responses){response=ajaxHandleResponses(s,jqXHR,responses)}if(!isSuccess&&jQuery.inArray("script",s.dataTypes)>-1&&jQuery.inArray("json",s.dataTypes)<0){s.converters["text script"]=function(){}}response=ajaxConvert(s,response,jqXHR,isSuccess);if(isSuccess){if(s.ifModified){modified=jqXHR.getResponseHeader("Last-Modified");if(modified){jQuery.lastModified[cacheURL]=modified}modified=jqXHR.getResponseHeader("etag");if(modified){jQuery.etag[cacheURL]=modified}}if(status===204||s.type==="HEAD"){statusText="nocontent"}else if(status===304){statusText="notmodified"}else{statusText=response.state;success=response.data;error=response.error;isSuccess=!error}}else{error=statusText;if(status||!statusText){statusText="error";if(status<0){status=0}}}jqXHR.status=status;jqXHR.statusText=(nativeStatusText||statusText)+"";if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR])}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error])}jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger(isSuccess?"ajaxSuccess":"ajaxError",[jqXHR,s,isSuccess?success:error])}completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!--jQuery.active){jQuery.event.trigger("ajaxStop")}}}return jqXHR},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script")}});jQuery.each(["get","post"],(function(_i,method){jQuery[method]=function(url,data,callback,type){if(isFunction(data)){type=type||callback;callback=data;data=undefined}return jQuery.ajax(jQuery.extend({url:url,type:method,dataType:type,data:data,success:callback},jQuery.isPlainObject(url)&&url))}}));jQuery.ajaxPrefilter((function(s){var i;for(i in s.headers){if(i.toLowerCase()==="content-type"){s.contentType=s.headers[i]||""}}}));jQuery._evalUrl=function(url,options,doc){return jQuery.ajax({url:url,type:"GET",dataType:"script",cache:true,async:false,global:false,converters:{"text script":function(){}},dataFilter:function(response){jQuery.globalEval(response,options,doc)}})};jQuery.fn.extend({wrapAll:function(html){var wrap;if(this[0]){if(isFunction(html)){html=html.call(this[0])}wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){wrap.insertBefore(this[0])}wrap.map((function(){var elem=this;while(elem.firstElementChild){elem=elem.firstElementChild}return elem})).append(this)}return this},wrapInner:function(html){if(isFunction(html)){return this.each((function(i){jQuery(this).wrapInner(html.call(this,i))}))}return this.each((function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html)}else{self.append(html)}}))},wrap:function(html){var htmlIsFunction=isFunction(html);return this.each((function(i){jQuery(this).wrapAll(htmlIsFunction?html.call(this,i):html)}))},unwrap:function(selector){this.parent(selector).not("body").each((function(){jQuery(this).replaceWith(this.childNodes)}));return this}});jQuery.expr.pseudos.hidden=function(elem){return!jQuery.expr.pseudos.visible(elem)};jQuery.expr.pseudos.visible=function(elem){return!!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length)};jQuery.ajaxSettings.xhr=function(){try{return new window.XMLHttpRequest}catch(e){}};var xhrSuccessStatus={0:200,1223:204},xhrSupported=jQuery.ajaxSettings.xhr();support.cors=!!xhrSupported&&"withCredentials"in xhrSupported;support.ajax=xhrSupported=!!xhrSupported;jQuery.ajaxTransport((function(options){var callback,errorCallback;if(support.cors||xhrSupported&&!options.crossDomain){return{send:function(headers,complete){var i,xhr=options.xhr();xhr.open(options.type,options.url,options.async,options.username,options.password);if(options.xhrFields){for(i in options.xhrFields){xhr[i]=options.xhrFields[i]}}if(options.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(options.mimeType)}if(!options.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest"}for(i in headers){xhr.setRequestHeader(i,headers[i])}callback=function(type){return function(){if(callback){callback=errorCallback=xhr.onload=xhr.onerror=xhr.onabort=xhr.ontimeout=xhr.onreadystatechange=null;if(type==="abort"){xhr.abort()}else if(type==="error"){if(typeof xhr.status!=="number"){complete(0,"error")}else{complete(xhr.status,xhr.statusText)}}else{complete(xhrSuccessStatus[xhr.status]||xhr.status,xhr.statusText,(xhr.responseType||"text")!=="text"||typeof xhr.responseText!=="string"?{binary:xhr.response}:{text:xhr.responseText},xhr.getAllResponseHeaders())}}}};xhr.onload=callback();errorCallback=xhr.onerror=xhr.ontimeout=callback("error");if(xhr.onabort!==undefined){xhr.onabort=errorCallback}else{xhr.onreadystatechange=function(){if(xhr.readyState===4){window.setTimeout((function(){if(callback){errorCallback()}}))}}}callback=callback("abort");try{xhr.send(options.hasContent&&options.data||null)}catch(e){if(callback){throw e}}},abort:function(){if(callback){callback()}}}}}));jQuery.ajaxPrefilter((function(s){if(s.crossDomain){s.contents.script=false}}));jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, "+"application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(text){jQuery.globalEval(text);return text}}});jQuery.ajaxPrefilter("script",(function(s){if(s.cache===undefined){s.cache=false}if(s.crossDomain){s.type="GET"}}));jQuery.ajaxTransport("script",(function(s){if(s.crossDomain||s.scriptAttrs){var script,callback;return{send:function(_,complete){script=jQuery("<script>").attr(s.scriptAttrs||{}).prop({charset:s.scriptCharset,src:s.url}).on("load error",callback=function(evt){script.remove();callback=null;if(evt){complete(evt.type==="error"?404:200,evt.type)}});document.head.appendChild(script[0])},abort:function(){if(callback){callback()}}}}}));var oldCallbacks=[],rjsonp=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var callback=oldCallbacks.pop()||jQuery.expando+"_"+nonce.guid++;this[callback]=true;return callback}});jQuery.ajaxPrefilter("json jsonp",(function(s,originalSettings,jqXHR){var callbackName,overwritten,responseContainer,jsonProp=s.jsonp!==false&&(rjsonp.test(s.url)?"url":typeof s.data==="string"&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0&&rjsonp.test(s.data)&&"data");if(jsonProp||s.dataTypes[0]==="jsonp"){callbackName=s.jsonpCallback=isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback;if(jsonProp){s[jsonProp]=s[jsonProp].replace(rjsonp,"$1"+callbackName)}else if(s.jsonp!==false){s.url+=(rquery.test(s.url)?"&":"?")+s.jsonp+"="+callbackName}s.converters["script json"]=function(){if(!responseContainer){jQuery.error(callbackName+" was not called")}return responseContainer[0]};s.dataTypes[0]="json";overwritten=window[callbackName];window[callbackName]=function(){responseContainer=arguments};jqXHR.always((function(){if(overwritten===undefined){jQuery(window).removeProp(callbackName)}else{window[callbackName]=overwritten}if(s[callbackName]){s.jsonpCallback=originalSettings.jsonpCallback;oldCallbacks.push(callbackName)}if(responseContainer&&isFunction(overwritten)){overwritten(responseContainer[0])}responseContainer=overwritten=undefined}));return"script"}}));support.createHTMLDocument=function(){var body=document.implementation.createHTMLDocument("").body;body.innerHTML="<form></form><form></form>";return body.childNodes.length===2}();jQuery.parseHTML=function(data,context,keepScripts){if(typeof data!=="string"){return[]}if(typeof context==="boolean"){keepScripts=context;context=false}var base,parsed,scripts;if(!context){if(support.createHTMLDocument){context=document.implementation.createHTMLDocument("");base=context.createElement("base");base.href=document.location.href;context.head.appendChild(base)}else{context=document}}parsed=rsingleTag.exec(data);scripts=!keepScripts&&[];if(parsed){return[context.createElement(parsed[1])]}parsed=buildFragment([data],context,scripts);if(scripts&&scripts.length){jQuery(scripts).remove()}return jQuery.merge([],parsed.childNodes)};jQuery.fn.load=function(url,params,callback){var selector,type,response,self=this,off=url.indexOf(" ");if(off>-1){selector=stripAndCollapse(url.slice(off));url=url.slice(0,off)}if(isFunction(params)){callback=params;params=undefined}else if(params&&typeof params==="object"){type="POST"}if(self.length>0){jQuery.ajax({url:url,type:type||"GET",dataType:"html",data:params}).done((function(responseText){response=arguments;self.html(selector?jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector):responseText)})).always(callback&&function(jqXHR,status){self.each((function(){callback.apply(this,response||[jqXHR.responseText,status,jqXHR])}))})}return this};jQuery.expr.pseudos.animated=function(elem){return jQuery.grep(jQuery.timers,(function(fn){return elem===fn.elem})).length};jQuery.offset={setOffset:function(elem,options,i){var curPosition,curLeft,curCSSTop,curTop,curOffset,curCSSLeft,calculatePosition,position=jQuery.css(elem,"position"),curElem=jQuery(elem),props={};if(position==="static"){elem.style.position="relative"}curOffset=curElem.offset();curCSSTop=jQuery.css(elem,"top");curCSSLeft=jQuery.css(elem,"left");calculatePosition=(position==="absolute"||position==="fixed")&&(curCSSTop+curCSSLeft).indexOf("auto")>-1;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0}if(isFunction(options)){options=options.call(elem,i,jQuery.extend({},curOffset))}if(options.top!=null){props.top=options.top-curOffset.top+curTop}if(options.left!=null){props.left=options.left-curOffset.left+curLeft}if("using"in options){options.using.call(elem,props)}else{curElem.css(props)}}};jQuery.fn.extend({offset:function(options){if(arguments.length){return options===undefined?this:this.each((function(i){jQuery.offset.setOffset(this,options,i)}))}var rect,win,elem=this[0];if(!elem){return}if(!elem.getClientRects().length){return{top:0,left:0}}rect=elem.getBoundingClientRect();win=elem.ownerDocument.defaultView;return{top:rect.top+win.pageYOffset,left:rect.left+win.pageXOffset}},position:function(){if(!this[0]){return}var offsetParent,offset,doc,elem=this[0],parentOffset={top:0,left:0};if(jQuery.css(elem,"position")==="fixed"){offset=elem.getBoundingClientRect()}else{offset=this.offset();doc=elem.ownerDocument;offsetParent=elem.offsetParent||doc.documentElement;while(offsetParent&&(offsetParent===doc.body||offsetParent===doc.documentElement)&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.parentNode}if(offsetParent&&offsetParent!==elem&&offsetParent.nodeType===1){parentOffset=jQuery(offsetParent).offset();parentOffset.top+=jQuery.css(offsetParent,"borderTopWidth",true);parentOffset.left+=jQuery.css(offsetParent,"borderLeftWidth",true)}}return{top:offset.top-parentOffset.top-jQuery.css(elem,"marginTop",true),left:offset.left-parentOffset.left-jQuery.css(elem,"marginLeft",true)}},offsetParent:function(){return this.map((function(){var offsetParent=this.offsetParent;while(offsetParent&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.offsetParent}return offsetParent||documentElement}))}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},(function(method,prop){var top="pageYOffset"===prop;jQuery.fn[method]=function(val){return access(this,(function(elem,method,val){var win;if(isWindow(elem)){win=elem}else if(elem.nodeType===9){win=elem.defaultView}if(val===undefined){return win?win[prop]:elem[method]}if(win){win.scrollTo(!top?val:win.pageXOffset,top?val:win.pageYOffset)}else{elem[method]=val}}),method,val,arguments.length)}}));jQuery.each(["top","left"],(function(_i,prop){jQuery.cssHooks[prop]=addGetHookIf(support.pixelPosition,(function(elem,computed){if(computed){computed=curCSS(elem,prop);return rnumnonpx.test(computed)?jQuery(elem).position()[prop]+"px":computed}}))}));jQuery.each({Height:"height",Width:"width"},(function(name,type){jQuery.each({padding:"inner"+name,content:type,"":"outer"+name},(function(defaultExtra,funcName){jQuery.fn[funcName]=function(margin,value){var chainable=arguments.length&&(defaultExtra||typeof margin!=="boolean"),extra=defaultExtra||(margin===true||value===true?"margin":"border");return access(this,(function(elem,type,value){var doc;if(isWindow(elem)){return funcName.indexOf("outer")===0?elem["inner"+name]:elem.document.documentElement["client"+name]}if(elem.nodeType===9){doc=elem.documentElement;return Math.max(elem.body["scroll"+name],doc["scroll"+name],elem.body["offset"+name],doc["offset"+name],doc["client"+name])}return value===undefined?jQuery.css(elem,type,extra):jQuery.style(elem,type,value,extra)}),type,chainable?margin:undefined,chainable)}}))}));jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],(function(_i,type){jQuery.fn[type]=function(fn){return this.on(type,fn)}}));jQuery.fn.extend({bind:function(types,data,fn){return this.on(types,null,data,fn)},unbind:function(types,fn){return this.off(types,null,fn)},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn)},undelegate:function(selector,types,fn){return arguments.length===1?this.off(selector,"**"):this.off(types,selector||"**",fn)},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver)}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup contextmenu").split(" "),(function(_i,name){jQuery.fn[name]=function(data,fn){return arguments.length>0?this.on(name,null,data,fn):this.trigger(name)}}));var rtrim=/^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;jQuery.proxy=function(fn,context){var tmp,args,proxy;if(typeof context==="string"){tmp=fn[context];context=fn;fn=tmp}if(!isFunction(fn)){return undefined}args=slice.call(arguments,2);proxy=function(){return fn.apply(context||this,args.concat(slice.call(arguments)))};proxy.guid=fn.guid=fn.guid||jQuery.guid++;return proxy};jQuery.holdReady=function(hold){if(hold){jQuery.readyWait++}else{jQuery.ready(true)}};jQuery.isArray=Array.isArray;jQuery.parseJSON=JSON.parse;jQuery.nodeName=nodeName;jQuery.isFunction=isFunction;jQuery.isWindow=isWindow;jQuery.camelCase=camelCase;jQuery.type=toType;jQuery.now=Date.now;jQuery.isNumeric=function(obj){var type=jQuery.type(obj);return(type==="number"||type==="string")&&!isNaN(obj-parseFloat(obj))};jQuery.trim=function(text){return text==null?"":(text+"").replace(rtrim,"$1")};if(typeof define==="function"&&define.amd){define("jquery",[],(function(){return jQuery}))}var _jQuery=window.jQuery,_$=window.$;jQuery.noConflict=function(deep){if(window.$===jQuery){window.$=_$}if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery}return jQuery};if(typeof noGlobal==="undefined"){window.jQuery=window.$=jQuery}return jQuery}));(function($,window,document,undefined){$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};$.site=$.fn.site=function(parameters){var time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),settings=$.isPlainObject(parameters)?$.extend(true,{},$.site.settings,parameters):$.extend({},$.site.settings),namespace=settings.namespace,error=settings.error,moduleNamespace="module-"+namespace,$document=$(document),$module=$document,element=this,instance=$module.data(moduleNamespace),module,returnedValue;module={initialize:function(){module.instantiate()},instantiate:function(){module.verbose("Storing instance of site",module);instance=module;$module.data(moduleNamespace,module)},normalize:function(){module.fix.console();module.fix.requestAnimationFrame()},fix:{console:function(){module.debug("Normalizing window.console");if(console===undefined||console.log===undefined){module.verbose("Console not available, normalizing events");module.disable.console()}if(typeof console.group=="undefined"||typeof console.groupEnd=="undefined"||typeof console.groupCollapsed=="undefined"){module.verbose("Console group not available, normalizing events");window.console.group=function(){};window.console.groupEnd=function(){};window.console.groupCollapsed=function(){}}if(typeof console.markTimeline=="undefined"){module.verbose("Mark timeline not available, normalizing events");window.console.markTimeline=function(){}}},consoleClear:function(){module.debug("Disabling programmatic console clearing");window.console.clear=function(){}},requestAnimationFrame:function(){module.debug("Normalizing requestAnimationFrame");if(window.requestAnimationFrame===undefined){module.debug("RequestAnimationFrame not available, normalizing event");window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){setTimeout(callback,0)}}}},moduleExists:function(name){return $.fn[name]!==undefined&&$.fn[name].settings!==undefined},enabled:{modules:function(modules){var enabledModules=[];modules=modules||settings.modules;$.each(modules,(function(index,name){if(module.moduleExists(name)){enabledModules.push(name)}}));return enabledModules}},disabled:{modules:function(modules){var disabledModules=[];modules=modules||settings.modules;$.each(modules,(function(index,name){if(!module.moduleExists(name)){disabledModules.push(name)}}));return disabledModules}},change:{setting:function(setting,value,modules,modifyExisting){modules=typeof modules==="string"?modules==="all"?settings.modules:[modules]:modules||settings.modules;modifyExisting=modifyExisting!==undefined?modifyExisting:true;$.each(modules,(function(index,name){var namespace=module.moduleExists(name)?$.fn[name].settings.namespace||false:true,$existingModules;if(module.moduleExists(name)){module.verbose("Changing default setting",setting,value,name);$.fn[name].settings[setting]=value;if(modifyExisting&&namespace){$existingModules=$(":data(module-"+namespace+")");if($existingModules.length>0){module.verbose("Modifying existing settings",$existingModules);$existingModules[name]("setting",setting,value)}}}}))},settings:function(newSettings,modules,modifyExisting){modules=typeof modules==="string"?[modules]:modules||settings.modules;modifyExisting=modifyExisting!==undefined?modifyExisting:true;$.each(modules,(function(index,name){var $existingModules;if(module.moduleExists(name)){module.verbose("Changing default setting",newSettings,name);$.extend(true,$.fn[name].settings,newSettings);if(modifyExisting&&namespace){$existingModules=$(":data(module-"+namespace+")");if($existingModules.length>0){module.verbose("Modifying existing settings",$existingModules);$existingModules[name]("setting",newSettings)}}}}))}},enable:{console:function(){module.console(true)},debug:function(modules,modifyExisting){modules=modules||settings.modules;module.debug("Enabling debug for modules",modules);module.change.setting("debug",true,modules,modifyExisting)},verbose:function(modules,modifyExisting){modules=modules||settings.modules;module.debug("Enabling verbose debug for modules",modules);module.change.setting("verbose",true,modules,modifyExisting)}},disable:{console:function(){module.console(false)},debug:function(modules,modifyExisting){modules=modules||settings.modules;module.debug("Disabling debug for modules",modules);module.change.setting("debug",false,modules,modifyExisting)},verbose:function(modules,modifyExisting){modules=modules||settings.modules;module.debug("Disabling verbose debug for modules",modules);module.change.setting("verbose",false,modules,modifyExisting)}},console:function(enable){if(enable){if(instance.cache.console===undefined){module.error(error.console);return}module.debug("Restoring console function");window.console=instance.cache.console}else{module.debug("Disabling console function");instance.cache.console=window.console;window.console={clear:function(){},error:function(){},group:function(){},groupCollapsed:function(){},groupEnd:function(){},info:function(){},log:function(){},markTimeline:function(){},warn:function(){}}}},destroy:function(){module.verbose("Destroying previous site for",$module);$module.removeData(moduleNamespace)},cache:{},setting:function(name,value){if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){settings[name]=value}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Element:element,Name:message[0],Arguments:[].slice.call(message,1)||"","Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{module.error(error.method,query);return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){module.destroy()}module.initialize()}return returnedValue!==undefined?returnedValue:this};$.site.settings={name:"Site",namespace:"site",error:{console:"Console cannot be restored, most likely it was overwritten outside of module",method:"The method you called is not defined."},debug:false,verbose:false,performance:true,modules:["accordion","api","calendar","checkbox","dimmer","dropdown","embed","form","modal","nag","popup","slider","rating","shape","sidebar","state","sticky","tab","toast","transition","visibility","visit"],siteNamespace:"site",namespaceStub:{cache:{},config:{},sections:{},section:{},utilities:{}}};$.extend($.expr[":"],{data:$.expr.createPseudo?$.expr.createPseudo((function(dataName){return function(elem){return!!$.data(elem,dataName)}})):function(elem,i,match){return!!$.data(elem,match[3])}})})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Form Validation
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.form=function(parameters){var $allModules=$(this),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],legacyParameters=arguments[1],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),returnedValue;$allModules.each((function(){var $module=$(this),element=this,formErrors=[],keyHeldDown=false,$field,$group,$message,$prompt,$submit,$clear,$reset,settings,validation,metadata,selector,className,regExp,error,namespace,moduleNamespace,eventNamespace,submitting=false,dirty=false,history=["clean","clean"],instance,module;module={initialize:function(){module.get.settings();if(methodInvoked){if(instance===undefined){module.instantiate()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy");module.refresh()}module.verbose("Initializing form validation",$module,settings);module.bindEvents();module.set.defaults();if(settings.autoCheckRequired){module.set.autoCheck()}module.instantiate()}},instantiate:function(){module.verbose("Storing instance of module",module);instance=module;$module.data(moduleNamespace,module)},destroy:function(){module.verbose("Destroying previous module",instance);module.removeEvents();$module.removeData(moduleNamespace)},refresh:function(){module.verbose("Refreshing selector cache");$field=$module.find(selector.field);$group=$module.find(selector.group);$message=$module.find(selector.message);$prompt=$module.find(selector.prompt);$submit=$module.find(selector.submit);$clear=$module.find(selector.clear);$reset=$module.find(selector.reset)},refreshEvents:function(){module.removeEvents();module.bindEvents()},submit:function(){module.verbose("Submitting form",$module);submitting=true;$module.submit()},attachEvents:function(selector,action){action=action||"submit";$(selector).on("click"+eventNamespace,(function(event){module[action]();event.preventDefault()}))},bindEvents:function(){module.verbose("Attaching form events");$module.on("submit"+eventNamespace,module.validate.form).on("blur"+eventNamespace,selector.field,module.event.field.blur).on("click"+eventNamespace,selector.submit,module.submit).on("click"+eventNamespace,selector.reset,module.reset).on("click"+eventNamespace,selector.clear,module.clear);if(settings.keyboardShortcuts){$module.on("keydown"+eventNamespace,selector.field,module.event.field.keydown)}$field.each((function(index,el){var $input=$(el),type=$input.prop("type"),inputEvent=module.get.changeEvent(type,$input);$input.on(inputEvent+eventNamespace,module.event.field.change)}));if(settings.preventLeaving){$(window).on("beforeunload"+eventNamespace,module.event.beforeUnload)}$field.on("change click keyup keydown blur",(function(e){module.determine.isDirty()}));$module.on("dirty"+eventNamespace,(function(e){settings.onDirty.call()}));$module.on("clean"+eventNamespace,(function(e){settings.onClean.call()}))},clear:function(){$field.each((function(index,el){var $field=$(el),$element=$field.parent(),$fieldGroup=$field.closest($group),$prompt=$fieldGroup.find(selector.prompt),$calendar=$field.closest(selector.uiCalendar),defaultValue=$field.data(metadata.defaultValue)||"",isCheckbox=$element.is(selector.uiCheckbox),isDropdown=$element.is(selector.uiDropdown)&&module.can.useElement("dropdown"),isCalendar=$calendar.length>0&&module.can.useElement("calendar"),isErrored=$fieldGroup.hasClass(className.error);if(isErrored){module.verbose("Resetting error on field",$fieldGroup);$fieldGroup.removeClass(className.error);$prompt.remove()}if(isDropdown){module.verbose("Resetting dropdown value",$element,defaultValue);$element.dropdown("clear",true)}else if(isCheckbox){$field.prop("checked",false)}else if(isCalendar){$calendar.calendar("clear")}else{module.verbose("Resetting field value",$field,defaultValue);$field.val("")}}));module.remove.states()},reset:function(){$field.each((function(index,el){var $field=$(el),$element=$field.parent(),$fieldGroup=$field.closest($group),$calendar=$field.closest(selector.uiCalendar),$prompt=$fieldGroup.find(selector.prompt),defaultValue=$field.data(metadata.defaultValue),isCheckbox=$element.is(selector.uiCheckbox),isDropdown=$element.is(selector.uiDropdown)&&module.can.useElement("dropdown"),isCalendar=$calendar.length>0&&module.can.useElement("calendar"),isErrored=$fieldGroup.hasClass(className.error);if(defaultValue===undefined){return}if(isErrored){module.verbose("Resetting error on field",$fieldGroup);$fieldGroup.removeClass(className.error);$prompt.remove()}if(isDropdown){module.verbose("Resetting dropdown value",$element,defaultValue);$element.dropdown("restore defaults",true)}else if(isCheckbox){module.verbose("Resetting checkbox value",$element,defaultValue);$field.prop("checked",defaultValue)}else if(isCalendar){$calendar.calendar("set date",defaultValue)}else{module.verbose("Resetting field value",$field,defaultValue);$field.val(defaultValue)}}));module.remove.states()},determine:{isValid:function(){var allValid=true;$.each(validation,(function(fieldName,field){if(!module.validate.field(field,fieldName,true)){allValid=false}}));return allValid},isDirty:function(e){var formIsDirty=false;$field.each((function(index,el){var $el=$(el),isCheckbox=$el.filter(selector.checkbox).length>0,isDirty;if(isCheckbox){isDirty=module.is.checkboxDirty($el)}else{isDirty=module.is.fieldDirty($el)}$el.data(settings.metadata.isDirty,isDirty);formIsDirty|=isDirty}));if(formIsDirty){module.set.dirty()}else{module.set.clean()}}},is:{bracketedRule:function(rule){return rule.type&&rule.type.match(settings.regExp.bracket)},shorthandRules:function(rules){return typeof rules=="string"||Array.isArray(rules)},empty:function($field){if(!$field||$field.length===0){return true}else if($field.is(selector.checkbox)){return!$field.is(":checked")}else{return module.is.blank($field)}},blank:function($field){return String($field.val()).trim()===""},valid:function(field,showErrors){var allValid=true;if(field){module.verbose("Checking if field is valid",field);return module.validate.field(validation[field],field,!!showErrors)}else{module.verbose("Checking if form is valid");$.each(validation,(function(fieldName,field){if(!module.is.valid(fieldName,showErrors)){allValid=false}}));return allValid}},dirty:function(){return dirty},clean:function(){return!dirty},fieldDirty:function($el){var initialValue=$el.data(metadata.defaultValue);if(initialValue==null){initialValue=""}else if(Array.isArray(initialValue)){initialValue=initialValue.toString()}var currentValue=$el.val();if(currentValue==null){currentValue=""}else if(Array.isArray(currentValue)){currentValue=currentValue.toString()}var boolRegex=/^(true|false)$/i;var isBoolValue=boolRegex.test(initialValue)&&boolRegex.test(currentValue);if(isBoolValue){var regex=new RegExp("^"+initialValue+"$","i");return!regex.test(currentValue)}return currentValue!==initialValue},checkboxDirty:function($el){var initialValue=$el.data(metadata.defaultValue);var currentValue=$el.is(":checked");return initialValue!==currentValue},justDirty:function(){return history[0]==="dirty"},justClean:function(){return history[0]==="clean"}},removeEvents:function(){$module.off(eventNamespace);$field.off(eventNamespace);$submit.off(eventNamespace)},event:{field:{keydown:function(event){var $field=$(this),key=event.which,isInput=$field.is(selector.input),isCheckbox=$field.is(selector.checkbox),isInDropdown=$field.closest(selector.uiDropdown).length>0,keyCode={enter:13,escape:27};if(key==keyCode.escape){module.verbose("Escape key pressed blurring field");$field[0].blur()}if(!event.ctrlKey&&key==keyCode.enter&&isInput&&!isInDropdown&&!isCheckbox){if(!keyHeldDown){$field.one("keyup"+eventNamespace,module.event.field.keyup);module.submit();module.debug("Enter pressed on input submitting form");event.preventDefault()}keyHeldDown=true}},keyup:function(){keyHeldDown=false},blur:function(event){var $field=$(this),$fieldGroup=$field.closest($group),validationRules=module.get.validation($field);if(validationRules&&(settings.on=="blur"||$fieldGroup.hasClass(className.error)&&settings.revalidate)){module.debug("Revalidating field",$field,validationRules);module.validate.field(validationRules);if(!settings.inline){module.validate.form(false,true)}}},change:function(event){var $field=$(this),$fieldGroup=$field.closest($group),validationRules=module.get.validation($field);if(validationRules&&(settings.on=="change"||$fieldGroup.hasClass(className.error)&&settings.revalidate)){clearTimeout(module.timer);module.timer=setTimeout((function(){module.debug("Revalidating field",$field,validationRules);module.validate.field(validationRules);if(!settings.inline){module.validate.form(false,true)}}),settings.delay)}}},beforeUnload:function(event){if(module.is.dirty()&&!submitting){event=event||window.event;if(event){event.returnValue=settings.text.leavingMessage}return settings.text.leavingMessage}}},get:{ancillaryValue:function(rule){if(!rule.type||!rule.value&&!module.is.bracketedRule(rule)){return false}return rule.value!==undefined?rule.value:rule.type.match(settings.regExp.bracket)[1]+""},ruleName:function(rule){if(module.is.bracketedRule(rule)){return rule.type.replace(rule.type.match(settings.regExp.bracket)[0],"")}return rule.type},changeEvent:function(type,$input){if(type=="checkbox"||type=="radio"||type=="hidden"||$input.is("select")){return"change"}else{return module.get.inputEvent()}},inputEvent:function(){return document.createElement("input").oninput!==undefined?"input":document.createElement("input").onpropertychange!==undefined?"propertychange":"keyup"},fieldsFromShorthand:function(fields){var fullFields={};$.each(fields,(function(name,rules){if(!Array.isArray(rules)&&typeof rules==="object"){fullFields[name]=rules}else{if(typeof rules=="string"){rules=[rules]}fullFields[name]={rules:[]};$.each(rules,(function(index,rule){fullFields[name].rules.push({type:rule})}))}}));return fullFields},prompt:function(rule,field){var ruleName=module.get.ruleName(rule),ancillary=module.get.ancillaryValue(rule),$field=module.get.field(field.identifier),value=$field.val(),prompt=$.isFunction(rule.prompt)?rule.prompt(value):rule.prompt||settings.prompt[ruleName]||settings.text.unspecifiedRule,requiresValue=prompt.search("{value}")!==-1,requiresName=prompt.search("{name}")!==-1,$label,name,parts,suffixPrompt;if(ancillary&&["integer","decimal","number"].indexOf(ruleName)>=0&&ancillary.indexOf("..")>=0){parts=ancillary.split("..",2);if(!rule.prompt){suffixPrompt=parts[0]===""?settings.prompt.maxValue.replace(/\{ruleValue\}/g,"{max}"):parts[1]===""?settings.prompt.minValue.replace(/\{ruleValue\}/g,"{min}"):settings.prompt.range;prompt+=suffixPrompt.replace(/\{name\}/g," "+settings.text.and)}prompt=prompt.replace(/\{min\}/g,parts[0]);prompt=prompt.replace(/\{max\}/g,parts[1])}if(requiresValue){prompt=prompt.replace(/\{value\}/g,$field.val())}if(requiresName){$label=$field.closest(selector.group).find("label").eq(0);name=$label.length==1?$label.text():$field.prop("placeholder")||settings.text.unspecifiedField;prompt=prompt.replace(/\{name\}/g,name)}prompt=prompt.replace(/\{identifier\}/g,field.identifier);prompt=prompt.replace(/\{ruleValue\}/g,ancillary);if(!rule.prompt){module.verbose("Using default validation prompt for type",prompt,ruleName)}return prompt},settings:function(){if($.isPlainObject(parameters)){var keys=Object.keys(parameters),isLegacySettings=keys.length>0?parameters[keys[0]].identifier!==undefined&&parameters[keys[0]].rules!==undefined:false;if(isLegacySettings){settings=$.extend(true,{},$.fn.form.settings,legacyParameters);validation=$.extend(true,{},$.fn.form.settings.defaults,parameters);module.error(settings.error.oldSyntax,element);module.verbose("Extending settings from legacy parameters",validation,settings)}else{if(parameters.fields){parameters.fields=module.get.fieldsFromShorthand(parameters.fields)}settings=$.extend(true,{},$.fn.form.settings,parameters);validation=$.extend(true,{},$.fn.form.settings.defaults,settings.fields);module.verbose("Extending settings",validation,settings)}}else{settings=$.extend(true,{},$.fn.form.settings);validation=$.extend(true,{},$.fn.form.settings.defaults);module.verbose("Using default form validation",validation,settings)}namespace=settings.namespace;metadata=settings.metadata;selector=settings.selector;className=settings.className;regExp=settings.regExp;error=settings.error;moduleNamespace="module-"+namespace;eventNamespace="."+namespace;instance=$module.data(moduleNamespace);(instance||module).refresh()},field:function(identifier){module.verbose("Finding field with identifier",identifier);identifier=module.escape.string(identifier);var t;if((t=$field.filter("#"+identifier)).length>0){return t}if((t=$field.filter('[name="'+identifier+'"]')).length>0){return t}if((t=$field.filter('[name="'+identifier+'[]"]')).length>0){return t}if((t=$field.filter("[data-"+metadata.validate+'="'+identifier+'"]')).length>0){return t}module.error(error.noField.replace("{identifier}",identifier));return $("<input/>")},fields:function(fields){var $fields=$();$.each(fields,(function(index,name){$fields=$fields.add(module.get.field(name))}));return $fields},validation:function($field){var fieldValidation,identifier;if(!validation){return false}$.each(validation,(function(fieldName,field){identifier=field.identifier||fieldName;$.each(module.get.field(identifier),(function(index,groupField){if(groupField==$field[0]){field.identifier=identifier;fieldValidation=field;return false}}))}));return fieldValidation||false},value:function(field){var fields=[],results;fields.push(field);results=module.get.values.call(element,fields);return results[field]},values:function(fields){var $fields=Array.isArray(fields)?module.get.fields(fields):$field,values={};$fields.each((function(index,field){var $field=$(field),$calendar=$field.closest(selector.uiCalendar),name=$field.prop("name"),value=$field.val(),isCheckbox=$field.is(selector.checkbox),isRadio=$field.is(selector.radio),isMultiple=name.indexOf("[]")!==-1,isCalendar=$calendar.length>0&&module.can.useElement("calendar"),isChecked=isCheckbox?$field.is(":checked"):false;if(name){if(isMultiple){name=name.replace("[]","");if(!values[name]){values[name]=[]}if(isCheckbox){if(isChecked){values[name].push(value||true)}else{values[name].push(false)}}else{values[name].push(value)}}else{if(isRadio){if(values[name]===undefined||values[name]===false){values[name]=isChecked?value||true:false}}else if(isCheckbox){if(isChecked){values[name]=value||true}else{values[name]=false}}else if(isCalendar){var date=$calendar.calendar("get date");if(date!==null){if(settings.dateHandling=="date"){values[name]=date}else if(settings.dateHandling=="input"){values[name]=$calendar.calendar("get input date")}else if(settings.dateHandling=="formatter"){var type=$calendar.calendar("setting","type");switch(type){case"date":values[name]=settings.formatter.date(date);break;case"datetime":values[name]=settings.formatter.datetime(date);break;case"time":values[name]=settings.formatter.time(date);break;case"month":values[name]=settings.formatter.month(date);break;case"year":values[name]=settings.formatter.year(date);break;default:module.debug("Wrong calendar mode",$calendar,type);values[name]=""}}}else{values[name]=""}}else{values[name]=value}}}}));return values},dirtyFields:function(){return $field.filter((function(index,e){return $(e).data(metadata.isDirty)}))}},has:{field:function(identifier){module.verbose("Checking for existence of a field with identifier",identifier);identifier=module.escape.string(identifier);if(typeof identifier!=="string"){module.error(error.identifier,identifier)}return $field.filter("#"+identifier).length>0||$field.filter('[name="'+identifier+'"]').length>0||$field.filter("[data-"+metadata.validate+'="'+identifier+'"]').length>0}},can:{useElement:function(element){if($.fn[element]!==undefined){return true}module.error(error.noElement.replace("{element}",element));return false}},escape:{string:function(text){text=String(text);return text.replace(regExp.escape,"\\$&")}},add:{rule:function(name,rules){module.add.field(name,rules)},field:function(name,rules){if(validation[name]===undefined||validation[name].rules===undefined){validation[name]={rules:[]}}var newValidation={rules:[]};if(module.is.shorthandRules(rules)){rules=Array.isArray(rules)?rules:[rules];$.each(rules,(function(_index,rule){newValidation.rules.push({type:rule})}))}else{newValidation.rules=rules.rules}$.each(newValidation.rules,(function(_index,rule){if($.grep(validation[name].rules,(function(item){return item.type==rule.type})).length==0){validation[name].rules.push(rule)}}));module.debug("Adding rules",newValidation.rules,validation);module.refreshEvents()},fields:function(fields){validation=$.extend(true,{},validation,module.get.fieldsFromShorthand(fields));module.refreshEvents()},prompt:function(identifier,errors,internal){var $field=module.get.field(identifier),$fieldGroup=$field.closest($group),$prompt=$fieldGroup.children(selector.prompt),promptExists=$prompt.length!==0;errors=typeof errors=="string"?[errors]:errors;module.verbose("Adding field error state",identifier);if(!internal){$fieldGroup.addClass(className.error)}if(settings.inline){if(!promptExists){$prompt=$("<div/>").addClass(className.label);$prompt.appendTo($fieldGroup)}$prompt.html(settings.templates.prompt(errors));if(!promptExists){if(settings.transition&&module.can.useElement("transition")&&$module.transition("is supported")){module.verbose("Displaying error with css transition",settings.transition);$prompt.transition(settings.transition+" in",settings.duration)}else{module.verbose("Displaying error with fallback javascript animation");$prompt.fadeIn(settings.duration)}}else{module.verbose("Inline errors are disabled, no inline error added",identifier)}}},errors:function(errors){module.debug("Adding form error messages",errors);module.set.error();$message.html(settings.templates.error(errors))}},remove:{errors:function(){module.debug("Removing form error messages");$message.empty()},states:function(){$module.removeClass(className.error).removeClass(className.success);if(!settings.inline){module.remove.errors()}module.determine.isDirty()},rule:function(field,rule){var rules=Array.isArray(rule)?rule:[rule];if(validation[field]===undefined||!Array.isArray(validation[field].rules)){return}if(rule===undefined){module.debug("Removed all rules");validation[field].rules=[];return}$.each(validation[field].rules,(function(index,rule){if(rule&&rules.indexOf(rule.type)!==-1){module.debug("Removed rule",rule.type);validation[field].rules.splice(index,1)}}))},field:function(field){var fields=Array.isArray(field)?field:[field];$.each(fields,(function(index,field){module.remove.rule(field)}));module.refreshEvents()},rules:function(field,rules){if(Array.isArray(field)){$.each(field,(function(index,field){module.remove.rule(field,rules)}))}else{module.remove.rule(field,rules)}},fields:function(fields){module.remove.field(fields)},prompt:function(identifier){var $field=module.get.field(identifier),$fieldGroup=$field.closest($group),$prompt=$fieldGroup.children(selector.prompt);$fieldGroup.removeClass(className.error);if(settings.inline&&$prompt.is(":visible")){module.verbose("Removing prompt for field",identifier);if(settings.transition&&module.can.useElement("transition")&&$module.transition("is supported")){$prompt.transition(settings.transition+" out",settings.duration,(function(){$prompt.remove()}))}else{$prompt.fadeOut(settings.duration,(function(){$prompt.remove()}))}}}},set:{success:function(){$module.removeClass(className.error).addClass(className.success)},defaults:function(){$field.each((function(index,el){var $el=$(el),$parent=$el.parent(),isCheckbox=$el.filter(selector.checkbox).length>0,isDropdown=$parent.is(selector.uiDropdown)&&module.can.useElement("dropdown"),$calendar=$el.closest(selector.uiCalendar),isCalendar=$calendar.length>0&&module.can.useElement("calendar"),value=isCheckbox?$el.is(":checked"):$el.val();if(isDropdown){$parent.dropdown("save defaults")}else if(isCalendar){$calendar.calendar("refresh")}$el.data(metadata.defaultValue,value);$el.data(metadata.isDirty,false)}))},error:function(){$module.removeClass(className.success).addClass(className.error)},value:function(field,value){var fields={};fields[field]=value;return module.set.values.call(element,fields)},values:function(fields){if($.isEmptyObject(fields)){return}$.each(fields,(function(key,value){var $field=module.get.field(key),$element=$field.parent(),$calendar=$field.closest(selector.uiCalendar),isMultiple=Array.isArray(value),isCheckbox=$element.is(selector.uiCheckbox)&&module.can.useElement("checkbox"),isDropdown=$element.is(selector.uiDropdown)&&module.can.useElement("dropdown"),isRadio=$field.is(selector.radio)&&isCheckbox,isCalendar=$calendar.length>0&&module.can.useElement("calendar"),fieldExists=$field.length>0,$multipleField;if(fieldExists){if(isMultiple&&isCheckbox){module.verbose("Selecting multiple",value,$field);$element.checkbox("uncheck");$.each(value,(function(index,value){$multipleField=$field.filter('[value="'+value+'"]');$element=$multipleField.parent();if($multipleField.length>0){$element.checkbox("check")}}))}else if(isRadio){module.verbose("Selecting radio value",value,$field);$field.filter('[value="'+value+'"]').parent(selector.uiCheckbox).checkbox("check")}else if(isCheckbox){module.verbose("Setting checkbox value",value,$element);if(value===true||value===1||value==="on"){$element.checkbox("check")}else{$element.checkbox("uncheck")}if(typeof value==="string"){$field.val(value)}}else if(isDropdown){module.verbose("Setting dropdown value",value,$element);$element.dropdown("set selected",value)}else if(isCalendar){$calendar.calendar("set date",value)}else{module.verbose("Setting field value",value,$field);$field.val(value)}}}))},dirty:function(){module.verbose("Setting state dirty");dirty=true;history[0]=history[1];history[1]="dirty";if(module.is.justClean()){$module.trigger("dirty")}},clean:function(){module.verbose("Setting state clean");dirty=false;history[0]=history[1];history[1]="clean";if(module.is.justDirty()){$module.trigger("clean")}},asClean:function(){module.set.defaults();module.set.clean()},asDirty:function(){module.set.defaults();module.set.dirty()},autoCheck:function(){module.debug("Enabling auto check on required fields");$field.each((function(_index,el){var $el=$(el),$elGroup=$(el).closest($group),isCheckbox=$el.filter(selector.checkbox).length>0,isRequired=$el.prop("required")||$elGroup.hasClass(className.required)||$elGroup.parent().hasClass(className.required),isDisabled=$el.is(":disabled")||$elGroup.hasClass(className.disabled)||$elGroup.parent().hasClass(className.disabled),validation=module.get.validation($el),hasEmptyRule=validation?$.grep(validation.rules,(function(rule){return rule.type=="empty"}))!==0:false,identifier=validation.identifier||$el.attr("id")||$el.attr("name")||$el.data(metadata.validate);if(isRequired&&!isDisabled&&!hasEmptyRule&&identifier!==undefined){if(isCheckbox){module.verbose("Adding 'checked' rule on field",identifier);module.add.rule(identifier,"checked")}else{module.verbose("Adding 'empty' rule on field",identifier);module.add.rule(identifier,"empty")}}}))},optional:function(identifier,bool){bool=bool!==false;$.each(validation,(function(fieldName,field){if(identifier==fieldName||identifier==field.identifier){field.optional=bool}}))}},validate:{form:function(event,ignoreCallbacks){var values=module.get.values();if(keyHeldDown){return false}formErrors=[];if(module.determine.isValid()){module.debug("Form has no validation errors, submitting");module.set.success();if(!settings.inline){module.remove.errors()}if(ignoreCallbacks!==true){return settings.onSuccess.call(element,event,values)}}else{module.debug("Form has errors");submitting=false;module.set.error();if(!settings.inline){module.add.errors(formErrors)}if(event&&$module.data("moduleApi")!==undefined){event.stopImmediatePropagation()}if(settings.errorFocus&&ignoreCallbacks!==true){var focusElement,hasTabIndex=true;if(typeof settings.errorFocus==="string"){focusElement=$(document).find(settings.errorFocus);hasTabIndex=focusElement.is("[tabindex]");if(!hasTabIndex){focusElement.attr("tabindex",-1)}}else{focusElement=$group.filter("."+className.error).first().find(selector.field)}focusElement.focus();if(!hasTabIndex){focusElement.removeAttr("tabindex")}}if(ignoreCallbacks!==true){return settings.onFailure.call(element,formErrors,values)}}},field:function(field,fieldName,showErrors){showErrors=showErrors!==undefined?showErrors:true;if(typeof field=="string"){module.verbose("Validating field",field);fieldName=field;field=validation[field]}var identifier=field.identifier||fieldName,$field=module.get.field(identifier),$dependsField=field.depends?module.get.field(field.depends):false,fieldValid=true,fieldErrors=[];if(!field.identifier){module.debug("Using field name as identifier",identifier);field.identifier=identifier}var isDisabled=!$field.filter(":not(:disabled)").length;if(isDisabled){module.debug("Field is disabled. Skipping",identifier)}else if(field.optional&&module.is.blank($field)){module.debug("Field is optional and blank. Skipping",identifier)}else if(field.depends&&module.is.empty($dependsField)){module.debug("Field depends on another value that is not present or empty. Skipping",$dependsField)}else if(field.rules!==undefined){if(showErrors){$field.closest($group).removeClass(className.error)}$.each(field.rules,(function(index,rule){if(module.has.field(identifier)){var invalidFields=module.validate.rule(field,rule,true)||[];if(invalidFields.length>0){module.debug("Field is invalid",identifier,rule.type);fieldErrors.push(module.get.prompt(rule,field));fieldValid=false;if(showErrors){$(invalidFields).closest($group).addClass(className.error)}}}}))}if(fieldValid){if(showErrors){module.remove.prompt(identifier,fieldErrors);settings.onValid.call($field)}}else{if(showErrors){formErrors=formErrors.concat(fieldErrors);module.add.prompt(identifier,fieldErrors,true);settings.onInvalid.call($field,fieldErrors)}return false}return true},rule:function(field,rule,internal){var $field=module.get.field(field.identifier),ancillary=module.get.ancillaryValue(rule),ruleName=module.get.ruleName(rule),ruleFunction=settings.rules[ruleName],invalidFields=[],isCheckbox=$field.is(selector.checkbox),isValid=function(field){var value=isCheckbox?$(field).filter(":checked").val():$(field).val();value=value===undefined||value===""||value===null?"":settings.shouldTrim&&rule.shouldTrim!==false||rule.shouldTrim?String(value+"").trim():String(value+"");return ruleFunction.call(field,value,ancillary,$module)};if(!$.isFunction(ruleFunction)){module.error(error.noRule,ruleName);return}if(isCheckbox){if(!isValid($field)){invalidFields=$field}}else{$.each($field,(function(index,field){if(!isValid(field)){invalidFields.push(field)}}))}return internal?invalidFields:!(invalidFields.length>0)}},setting:function(name,value){if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){settings[name]=value}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if($allModules.length>1){title+=" "+"("+$allModules.length+")"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};module.initialize()}));return returnedValue!==undefined?returnedValue:this};$.fn.form.settings={name:"Form",namespace:"form",debug:false,verbose:false,performance:true,fields:false,keyboardShortcuts:true,on:"submit",inline:false,delay:200,revalidate:true,shouldTrim:true,transition:"scale",duration:200,autoCheckRequired:false,preventLeaving:false,errorFocus:true,dateHandling:"date",onValid:function(){},onInvalid:function(){},onSuccess:function(){return true},onFailure:function(){return false},onDirty:function(){},onClean:function(){},metadata:{defaultValue:"default",validate:"validate",isDirty:"isDirty"},regExp:{htmlID:/^[a-zA-Z][\w:.-]*$/g,bracket:/\[(.*)\]/i,decimal:/^\d+\.?\d*$/,email:/^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i,escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|:,=@]/g,flags:/^\/(.*)\/(.*)?/,integer:/^\-?\d+$/,number:/^\-?\d*(\.\d+)?$/,url:/(https?:\/\/(?:www\.|(?!www))[^\s\.]+\.[^\s]{2,}|www\.[^\s]+\.[^\s]{2,})/i},text:{and:"and",unspecifiedRule:"Please enter a valid value",unspecifiedField:"This field",leavingMessage:"There are unsaved changes on this page which will be discarded if you continue."},prompt:{range:"{name} must be in a range from {min} to {max}",maxValue:"{name} must have a maximum value of {ruleValue}",minValue:"{name} must have a minimum value of {ruleValue}",empty:"{name} must have a value",checked:"{name} must be checked",email:"{name} must be a valid e-mail",url:"{name} must be a valid url",regExp:"{name} is not formatted correctly",integer:"{name} must be an integer",decimal:"{name} must be a decimal number",number:"{name} must be set to a number",is:'{name} must be "{ruleValue}"',isExactly:'{name} must be exactly "{ruleValue}"',not:'{name} cannot be set to "{ruleValue}"',notExactly:'{name} cannot be set to exactly "{ruleValue}"',contain:'{name} must contain "{ruleValue}"',containExactly:'{name} must contain exactly "{ruleValue}"',doesntContain:'{name} cannot contain  "{ruleValue}"',doesntContainExactly:'{name} cannot contain exactly "{ruleValue}"',minLength:"{name} must be at least {ruleValue} characters",exactLength:"{name} must be exactly {ruleValue} characters",maxLength:"{name} cannot be longer than {ruleValue} characters",match:"{name} must match {ruleValue} field",different:"{name} must have a different value than {ruleValue} field",creditCard:"{name} must be a valid credit card number",minCount:"{name} must have at least {ruleValue} choices",exactCount:"{name} must have exactly {ruleValue} choices",maxCount:"{name} must have {ruleValue} or less choices"},selector:{checkbox:'input[type="checkbox"], input[type="radio"]',clear:".clear",field:'input:not(.search):not([type="file"]):not([type="reset"]):not([type="button"]):not([type="submit"]), textarea, select',group:".field",input:'input:not([type="file"])',message:".error.message",prompt:".prompt.label",radio:'input[type="radio"]',reset:'.reset:not([type="reset"])',submit:'.submit:not([type="submit"])',uiCheckbox:".ui.checkbox",uiDropdown:".ui.dropdown",uiCalendar:".ui.calendar"},className:{error:"error",label:"ui basic red pointing prompt label",pressed:"down",success:"success",required:"required",disabled:"disabled"},error:{identifier:"You must specify a string identifier for each field",method:"The method you called is not defined.",noRule:"There is no rule matching the one you specified",oldSyntax:"Starting in 2.0 forms now only take a single settings object. Validation settings converted to new syntax automatically.",noField:"Field identifier {identifier} not found",noElement:"This module requires ui {element}"},templates:{error:function(errors){var html='<ul class="list">';$.each(errors,(function(index,value){html+="<li>"+value+"</li>"}));html+="</ul>";return html},prompt:function(errors){if(errors.length===1){return errors[0]}var html='<ul class="ui list">';$.each(errors,(function(index,value){html+="<li>"+value+"</li>"}));html+="</ul>";return html}},formatter:{date:function(date){return Intl.DateTimeFormat("en-GB").format(date)},datetime:function(date){return Intl.DateTimeFormat("en-GB",{year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit"}).format(date)},time:function(date){return Intl.DateTimeFormat("en-GB",{hour:"2-digit",minute:"2-digit",second:"2-digit"}).format(date)},month:function(date){return Intl.DateTimeFormat("en-GB",{month:"2-digit",year:"numeric"}).format(date)},year:function(date){return Intl.DateTimeFormat("en-GB",{year:"numeric"}).format(date)}},rules:{empty:function(value){return!(value===undefined||""===value||Array.isArray(value)&&value.length===0)},checked:function(){return $(this).filter(":checked").length>0},email:function(value){return $.fn.form.settings.regExp.email.test(value)},url:function(value){return $.fn.form.settings.regExp.url.test(value)},regExp:function(value,regExp){if(regExp instanceof RegExp){return value.match(regExp)}var regExpParts=regExp.match($.fn.form.settings.regExp.flags),flags;if(regExpParts){regExp=regExpParts.length>=2?regExpParts[1]:regExp;flags=regExpParts.length>=3?regExpParts[2]:""}return value.match(new RegExp(regExp,flags))},minValue:function(value,range){return $.fn.form.settings.rules.range(value,range+"..","number")},maxValue:function(value,range){return $.fn.form.settings.rules.range(value,".."+range,"number")},integer:function(value,range){return $.fn.form.settings.rules.range(value,range,"integer")},range:function(value,range,regExp){if(typeof regExp=="string"){regExp=$.fn.form.settings.regExp[regExp]}if(!(regExp instanceof RegExp)){regExp=$.fn.form.settings.regExp.integer}var min,max,parts;if(!range||["",".."].indexOf(range)!==-1){}else if(range.indexOf("..")==-1){if(regExp.test(range)){min=max=range-0}}else{parts=range.split("..",2);if(regExp.test(parts[0])){min=parts[0]-0}if(regExp.test(parts[1])){max=parts[1]-0}}return regExp.test(value)&&(min===undefined||value>=min)&&(max===undefined||value<=max)},decimal:function(value,range){return $.fn.form.settings.rules.range(value,range,"decimal")},number:function(value,range){return $.fn.form.settings.rules.range(value,range,"number")},is:function(value,text){text=typeof text=="string"?text.toLowerCase():text;value=typeof value=="string"?value.toLowerCase():value;return value==text},isExactly:function(value,text){return value==text},not:function(value,notValue){value=typeof value=="string"?value.toLowerCase():value;notValue=typeof notValue=="string"?notValue.toLowerCase():notValue;return value!=notValue},notExactly:function(value,notValue){return value!=notValue},contains:function(value,text){text=text.replace($.fn.form.settings.regExp.escape,"\\$&");return value.search(new RegExp(text,"i"))!==-1},containsExactly:function(value,text){text=text.replace($.fn.form.settings.regExp.escape,"\\$&");return value.search(new RegExp(text))!==-1},doesntContain:function(value,text){text=text.replace($.fn.form.settings.regExp.escape,"\\$&");return value.search(new RegExp(text,"i"))===-1},doesntContainExactly:function(value,text){text=text.replace($.fn.form.settings.regExp.escape,"\\$&");return value.search(new RegExp(text))===-1},minLength:function(value,requiredLength){return value!==undefined?value.length>=requiredLength:false},exactLength:function(value,requiredLength){return value!==undefined?value.length==requiredLength:false},maxLength:function(value,maxLength){return value!==undefined?value.length<=maxLength:false},match:function(value,identifier,$module){var matchingValue,matchingElement;if((matchingElement=$module.find('[data-validate="'+identifier+'"]')).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find("#"+identifier)).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find('[name="'+identifier+'"]')).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find('[name="'+identifier+'[]"]')).length>0){matchingValue=matchingElement}return matchingValue!==undefined?value.toString()==matchingValue.toString():false},different:function(value,identifier,$module){var matchingValue,matchingElement;if((matchingElement=$module.find('[data-validate="'+identifier+'"]')).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find("#"+identifier)).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find('[name="'+identifier+'"]')).length>0){matchingValue=matchingElement.val()}else if((matchingElement=$module.find('[name="'+identifier+'[]"]')).length>0){matchingValue=matchingElement}return matchingValue!==undefined?value.toString()!==matchingValue.toString():false},creditCard:function(cardNumber,cardTypes){var cards={visa:{pattern:/^4/,length:[16]},amex:{pattern:/^3[47]/,length:[15]},mastercard:{pattern:/^5[1-5]/,length:[16]},discover:{pattern:/^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)/,length:[16]},unionPay:{pattern:/^(62|88)/,length:[16,17,18,19]},jcb:{pattern:/^35(2[89]|[3-8][0-9])/,length:[16]},maestro:{pattern:/^(5018|5020|5038|6304|6759|676[1-3])/,length:[12,13,14,15,16,17,18,19]},dinersClub:{pattern:/^(30[0-5]|^36)/,length:[14]},laser:{pattern:/^(6304|670[69]|6771)/,length:[16,17,18,19]},visaElectron:{pattern:/^(4026|417500|4508|4844|491(3|7))/,length:[16]}},valid={},validCard=false,requiredTypes=typeof cardTypes=="string"?cardTypes.split(","):false,unionPay,validation;if(typeof cardNumber!=="string"||cardNumber.length===0){return}cardNumber=cardNumber.replace(/[\s\-]/g,"");if(requiredTypes){$.each(requiredTypes,(function(index,type){validation=cards[type];if(validation){valid={length:$.inArray(cardNumber.length,validation.length)!==-1,pattern:cardNumber.search(validation.pattern)!==-1};if(valid.length&&valid.pattern){validCard=true}}}));if(!validCard){return false}}unionPay={number:$.inArray(cardNumber.length,cards.unionPay.length)!==-1,pattern:cardNumber.search(cards.unionPay.pattern)!==-1};if(unionPay.number&&unionPay.pattern){return true}var length=cardNumber.length,multiple=0,producedValue=[[0,1,2,3,4,5,6,7,8,9],[0,2,4,6,8,1,3,5,7,9]],sum=0;while(length--){sum+=producedValue[multiple][parseInt(cardNumber.charAt(length),10)];multiple^=1}return sum%10===0&&sum>0},minCount:function(value,minCount){if(minCount==0){return true}if(minCount==1){return value!==""}return value.split(",").length>=minCount},exactCount:function(value,exactCount){if(exactCount==0){return value===""}if(exactCount==1){return value!==""&&value.search(",")===-1}return value.split(",").length==exactCount},maxCount:function(value,maxCount){if(maxCount==0){return false}if(maxCount==1){return value.search(",")===-1}return value.split(",").length<=maxCount}}}})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Dimmer
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.dimmer=function(parameters){var $allModules=$(this),time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),returnedValue;$allModules.each((function(){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.dimmer.settings,parameters):$.extend({},$.fn.dimmer.settings),selector=settings.selector,namespace=settings.namespace,className=settings.className,error=settings.error,eventNamespace="."+namespace,moduleNamespace="module-"+namespace,moduleSelector=$allModules.selector||"",clickEvent="ontouchstart"in document.documentElement?"touchstart":"click",$module=$(this),$dimmer,$dimmable,element=this,instance=$module.data(moduleNamespace),module;module={preinitialize:function(){if(module.is.dimmer()){$dimmable=$module.parent();$dimmer=$module}else{$dimmable=$module;if(module.has.dimmer()){if(settings.dimmerName){$dimmer=$dimmable.find(selector.dimmer).filter("."+settings.dimmerName)}else{$dimmer=$dimmable.find(selector.dimmer)}}else{$dimmer=module.create()}}},initialize:function(){module.debug("Initializing dimmer",settings);module.bind.events();module.set.dimmable();module.instantiate()},instantiate:function(){module.verbose("Storing instance of module",module);instance=module;$module.data(moduleNamespace,instance)},destroy:function(){module.verbose("Destroying previous module",$dimmer);module.unbind.events();module.remove.variation();$dimmable.off(eventNamespace)},bind:{events:function(){if(settings.on=="hover"){$dimmable.on("mouseenter"+eventNamespace,module.show).on("mouseleave"+eventNamespace,module.hide)}else if(settings.on=="click"){$dimmable.on(clickEvent+eventNamespace,module.toggle)}if(module.is.page()){module.debug("Setting as a page dimmer",$dimmable);module.set.pageDimmer()}if(module.is.closable()){module.verbose("Adding dimmer close event",$dimmer);$dimmable.on(clickEvent+eventNamespace,selector.dimmer,module.event.click)}}},unbind:{events:function(){$module.removeData(moduleNamespace);$dimmable.off(eventNamespace)}},event:{click:function(event){module.verbose("Determining if event occurred on dimmer",event);if($dimmer.find(event.target).length===0||$(event.target).is(selector.content)){module.hide();event.stopImmediatePropagation()}}},addContent:function(element){var $content=$(element);module.debug("Add content to dimmer",$content);if($content.parent()[0]!==$dimmer[0]){$content.detach().appendTo($dimmer)}},create:function(){var $element=$(settings.template.dimmer(settings));if(settings.dimmerName){module.debug("Creating named dimmer",settings.dimmerName);$element.addClass(settings.dimmerName)}$element.appendTo($dimmable);return $element},show:function(callback){callback=$.isFunction(callback)?callback:function(){};if((!module.is.dimmed()||module.is.animating())&&module.is.enabled()){if(settings.onShow.call(element)===false){module.verbose("Show callback returned false cancelling dimmer show");return}module.debug("Showing dimmer",$dimmer,settings);module.set.variation();module.animate.show(callback);settings.onChange.call(element)}else{module.debug("Dimmer is already shown or disabled")}},hide:function(callback){callback=$.isFunction(callback)?callback:function(){};if(module.is.dimmed()||module.is.animating()){if(settings.onHide.call(element)===false){module.verbose("Hide callback returned false cancelling dimmer hide");return}module.debug("Hiding dimmer",$dimmer);module.animate.hide(callback);settings.onChange.call(element)}else{module.debug("Dimmer is not visible")}},toggle:function(){module.verbose("Toggling dimmer visibility",$dimmer);if(!module.is.dimmed()){module.show()}else{if(module.is.closable()){module.hide()}}},animate:{show:function(callback){callback=$.isFunction(callback)?callback:function(){};if(settings.useCSS&&$.fn.transition!==undefined&&$dimmer.transition("is supported")){if(settings.useFlex){module.debug("Using flex dimmer");module.remove.legacy()}else{module.debug("Using legacy non-flex dimmer");module.set.legacy()}if(settings.opacity!=="auto"){module.set.opacity()}$dimmer.transition({debug:settings.debug,verbose:settings.verbose,silent:settings.silent,displayType:settings.useFlex?"flex":"block",animation:(settings.transition.showMethod||settings.transition)+" in",queue:false,duration:module.get.duration(),useFailSafe:true,onStart:function(){module.set.dimmed()},onComplete:function(){module.set.active();settings.onVisible.call($dimmer);callback()}})}else{module.verbose("Showing dimmer animation with javascript");module.set.dimmed();if(settings.opacity=="auto"){settings.opacity=.8}$dimmer.stop().css({opacity:0,width:"100%",height:"100%"}).fadeTo(module.get.duration(),settings.opacity,(function(){$dimmer.removeAttr("style");module.set.active();settings.onVisible.call($dimmer);callback()}))}},hide:function(callback){callback=$.isFunction(callback)?callback:function(){};if(settings.useCSS&&$.fn.transition!==undefined&&$dimmer.transition("is supported")){module.verbose("Hiding dimmer with css");$dimmer.transition({debug:settings.debug,verbose:settings.verbose,silent:settings.silent,displayType:settings.useFlex?"flex":"block",animation:(settings.transition.hideMethod||settings.transition)+" out",queue:false,duration:module.get.duration(),useFailSafe:true,onComplete:function(){module.remove.dimmed();module.remove.variation();module.remove.active();settings.onHidden.call($dimmer);callback()}})}else{module.verbose("Hiding dimmer with javascript");$dimmer.stop().fadeOut(module.get.duration(),(function(){module.remove.dimmed();module.remove.active();$dimmer.removeAttr("style");settings.onHidden.call($dimmer);callback()}))}}},get:{dimmer:function(){return $dimmer},duration:function(){if(module.is.active()){return settings.transition.hideDuration||settings.duration.hide||settings.duration}else{return settings.transition.showDuration||settings.duration.show||settings.duration}}},has:{dimmer:function(){if(settings.dimmerName){return $module.find(selector.dimmer).filter("."+settings.dimmerName).length>0}else{return $module.find(selector.dimmer).length>0}}},is:{active:function(){return $dimmer.hasClass(className.active)},animating:function(){return $dimmer.is(":animated")||$dimmer.hasClass(className.animating)},closable:function(){if(settings.closable=="auto"){return settings.on!="hover"}return settings.closable},dimmer:function(){return $module.hasClass(className.dimmer)},dimmable:function(){return $module.hasClass(className.dimmable)},dimmed:function(){return $dimmable.hasClass(className.dimmed)},disabled:function(){return $dimmable.hasClass(className.disabled)},enabled:function(){return!module.is.disabled()},page:function(){return $dimmable.is("body")},pageDimmer:function(){return $dimmer.hasClass(className.pageDimmer)}},can:{show:function(){return!$dimmer.hasClass(className.disabled)}},set:{opacity:function(opacity){var color=$dimmer.css("background-color"),colorArray=color.split(","),isRGB=colorArray&&colorArray.length>=3;opacity=settings.opacity===0?0:settings.opacity||opacity;if(isRGB){colorArray[2]=colorArray[2].replace(")","");colorArray[3]=opacity+")";color=colorArray.join(",")}else{color="rgba(0, 0, 0, "+opacity+")"}module.debug("Setting opacity to",opacity);$dimmer.css("background-color",color)},legacy:function(){$dimmer.addClass(className.legacy)},active:function(){$dimmer.addClass(className.active)},dimmable:function(){$dimmable.addClass(className.dimmable)},dimmed:function(){$dimmable.addClass(className.dimmed)},pageDimmer:function(){$dimmer.addClass(className.pageDimmer)},disabled:function(){$dimmer.addClass(className.disabled)},variation:function(variation){variation=variation||settings.variation;if(variation){$dimmer.addClass(variation)}}},remove:{active:function(){$dimmer.removeClass(className.active)},legacy:function(){$dimmer.removeClass(className.legacy)},dimmed:function(){$dimmable.removeClass(className.dimmed)},disabled:function(){$dimmer.removeClass(className.disabled)},variation:function(variation){variation=variation||settings.variation;if(variation){$dimmer.removeClass(variation)}}},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if($allModules.length>1){title+=" "+"("+$allModules.length+")"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{module.error(error.method,query);return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};module.preinitialize();if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize()}}));return returnedValue!==undefined?returnedValue:this};$.fn.dimmer.settings={name:"Dimmer",namespace:"dimmer",silent:false,debug:false,verbose:false,performance:true,useFlex:true,dimmerName:false,variation:false,closable:"auto",useCSS:true,transition:"fade",on:false,opacity:"auto",duration:{show:500,hide:500},displayLoader:false,loaderText:false,loaderVariation:"",onChange:function(){},onShow:function(){},onHide:function(){},onVisible:function(){},onHidden:function(){},error:{method:"The method you called is not defined."},className:{active:"active",animating:"animating",dimmable:"dimmable",dimmed:"dimmed",dimmer:"dimmer",disabled:"disabled",hide:"hide",legacy:"legacy",pageDimmer:"page",show:"show",loader:"ui loader"},selector:{dimmer:"> .ui.dimmer",content:".ui.dimmer > .content, .ui.dimmer > .content > .center"},template:{dimmer:function(settings){var d=$("<div/>").addClass("ui dimmer"),l;if(settings.displayLoader){l=$("<div/>").addClass(settings.className.loader).addClass(settings.loaderVariation);if(!!settings.loaderText){l.text(settings.loaderText);l.addClass("text")}d.append(l)}return d}}}})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Dropdown
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.dropdown=function(parameters){var $allModules=$(this),$document=$(document),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),returnedValue;$allModules.each((function(elementIndex){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.dropdown.settings,parameters):$.extend({},$.fn.dropdown.settings),className=settings.className,message=settings.message,fields=settings.fields,keys=settings.keys,metadata=settings.metadata,namespace=settings.namespace,regExp=settings.regExp,selector=settings.selector,error=settings.error,templates=settings.templates,eventNamespace="."+namespace,moduleNamespace="module-"+namespace,$module=$(this),$context=[window,document].indexOf(settings.context)<0?$document.find(settings.context):$(settings.context),$text=$module.find(selector.text),$search=$module.find(selector.search),$sizer=$module.find(selector.sizer),$input=$module.find(selector.input),$icon=$module.find(selector.icon),$clear=$module.find(selector.clearIcon),$combo=$module.prev().find(selector.text).length>0?$module.prev().find(selector.text):$module.prev(),$menu=$module.children(selector.menu),$item=$menu.find(selector.item),$divider=settings.hideDividers?$item.parent().children(selector.divider):$(),activated=false,itemActivated=false,internalChange=false,iconClicked=false,element=this,focused=false,instance=$module.data(moduleNamespace),selectActionActive,initialLoad,pageLostFocus,willRefocus,elementNamespace,id,selectObserver,menuObserver,classObserver,module;module={initialize:function(){module.debug("Initializing dropdown",settings);if(module.is.alreadySetup()){module.setup.reference()}else{if(settings.ignoreDiacritics&&!String.prototype.normalize){settings.ignoreDiacritics=false;module.error(error.noNormalize,element)}module.create.id();module.setup.layout();if(settings.values){module.set.initialLoad();module.change.values(settings.values);module.remove.initialLoad()}module.refreshData();module.save.defaults();module.restore.selected();module.bind.events();module.observeChanges();module.instantiate()}},instantiate:function(){module.verbose("Storing instance of dropdown",module);instance=module;$module.data(moduleNamespace,module)},destroy:function(){module.verbose("Destroying previous dropdown",$module);module.remove.tabbable();module.remove.active();$menu.transition("stop all");$menu.removeClass(className.visible).addClass(className.hidden);$module.off(eventNamespace).removeData(moduleNamespace);$menu.off(eventNamespace);$document.off(elementNamespace);module.disconnect.menuObserver();module.disconnect.selectObserver();module.disconnect.classObserver()},observeChanges:function(){if("MutationObserver"in window){selectObserver=new MutationObserver(module.event.select.mutation);menuObserver=new MutationObserver(module.event.menu.mutation);classObserver=new MutationObserver(module.event.class.mutation);module.debug("Setting up mutation observer",selectObserver,menuObserver,classObserver);module.observe.select();module.observe.menu();module.observe.class()}},disconnect:{menuObserver:function(){if(menuObserver){menuObserver.disconnect()}},selectObserver:function(){if(selectObserver){selectObserver.disconnect()}},classObserver:function(){if(classObserver){classObserver.disconnect()}}},observe:{select:function(){if(module.has.input()&&selectObserver){selectObserver.observe($module[0],{attributes:true,childList:true,subtree:true})}},menu:function(){if(module.has.menu()&&menuObserver){menuObserver.observe($menu[0],{childList:true,subtree:true})}},class:function(){if(module.has.search()&&classObserver){classObserver.observe($module[0],{attributes:true})}}},create:{id:function(){id=(Math.random().toString(16)+"000000000").slice(2,10);elementNamespace="."+id;module.verbose("Creating unique id for element",id)},userChoice:function(values){var $userChoices,$userChoice,html;values=values||module.get.userValues();if(!values){return false}values=Array.isArray(values)?values:[values];$.each(values,(function(index,value){if(module.get.item(value)===false){html=settings.templates.addition(module.add.variables(message.addResult,value));$userChoice=$("<div />").html(html).attr("data-"+metadata.value,value).attr("data-"+metadata.text,value).addClass(className.addition).addClass(className.item);if(settings.hideAdditions){$userChoice.addClass(className.hidden)}$userChoices=$userChoices===undefined?$userChoice:$userChoices.add($userChoice);module.verbose("Creating user choices for value",value,$userChoice)}}));return $userChoices},userLabels:function(value){var userValues=module.get.userValues();if(userValues){module.debug("Adding user labels",userValues);$.each(userValues,(function(index,value){module.verbose("Adding custom user value");module.add.label(value,value)}))}},menu:function(){$menu=$("<div />").addClass(className.menu).appendTo($module)},sizer:function(){$sizer=$("<span />").addClass(className.sizer).insertAfter($search)}},search:function(query){query=query!==undefined?query:module.get.query();module.verbose("Searching for query",query);if(settings.fireOnInit===false&&module.is.initialLoad()){module.verbose("Skipping callback on initial load",settings.onSearch)}else if(module.has.minCharacters(query)&&settings.onSearch.call(element,query)!==false){module.filter(query)}else{module.hide(null,true)}},select:{firstUnfiltered:function(){module.verbose("Selecting first non-filtered element");module.remove.selectedItem();$item.not(selector.unselectable).not(selector.addition+selector.hidden).eq(0).addClass(className.selected)},nextAvailable:function($selected){$selected=$selected.eq(0);var $nextAvailable=$selected.nextAll(selector.item).not(selector.unselectable).eq(0),$prevAvailable=$selected.prevAll(selector.item).not(selector.unselectable).eq(0),hasNext=$nextAvailable.length>0;if(hasNext){module.verbose("Moving selection to",$nextAvailable);$nextAvailable.addClass(className.selected)}else{module.verbose("Moving selection to",$prevAvailable);$prevAvailable.addClass(className.selected)}}},setup:{api:function(){var apiSettings={debug:settings.debug,urlData:{value:module.get.value(),query:module.get.query()},on:false};module.verbose("First request, initializing API");$module.api(apiSettings)},layout:function(){if($module.is("select")){module.setup.select();module.setup.returnedObject()}if(!module.has.menu()){module.create.menu()}if(module.is.clearable()&&!module.has.clearItem()){module.verbose("Adding clear icon");$clear=$("<i />").addClass("remove icon").insertBefore($text)}if(module.is.search()&&!module.has.search()){module.verbose("Adding search input");var labelNode=$module.prev("label");$search=$("<input />").addClass(className.search).prop("autocomplete",module.is.chrome()?"fomantic-search":"off");if(labelNode.length){if(!labelNode.attr("id")){labelNode.attr("id","_"+module.get.id()+"_formLabel")}$search.attr("aria-labelledby",labelNode.attr("id"))}$search.insertBefore($text)}if(module.is.multiple()&&module.is.searchSelection()&&!module.has.sizer()){module.create.sizer()}if(settings.allowTab){module.set.tabbable()}},select:function(){var selectValues=module.get.selectValues();module.debug("Dropdown initialized on a select",selectValues);if($module.is("select")){$input=$module}if($input.parent(selector.dropdown).length>0){module.debug("UI dropdown already exists. Creating dropdown menu only");$module=$input.closest(selector.dropdown);if(!module.has.menu()){module.create.menu()}$menu=$module.children(selector.menu);module.setup.menu(selectValues)}else{module.debug("Creating entire dropdown from select");$module=$("<div />").attr("class",$input.attr("class")).addClass(className.selection).addClass(className.dropdown).html(templates.dropdown(selectValues,fields,settings.preserveHTML,settings.className)).insertBefore($input);if($input.hasClass(className.multiple)&&$input.prop("multiple")===false){module.error(error.missingMultiple);$input.prop("multiple",true)}if($input.is("[multiple]")){module.set.multiple()}if($input.prop("disabled")){module.debug("Disabling dropdown");$module.addClass(className.disabled)}if($input.is("[required]")){settings.forceSelection=true}$input.removeAttr("required").removeAttr("class").detach().prependTo($module)}module.refresh()},menu:function(values){$menu.html(templates.menu(values,fields,settings.preserveHTML,settings.className));$item=$menu.find(selector.item);$divider=settings.hideDividers?$item.parent().children(selector.divider):$()},reference:function(){module.debug("Dropdown behavior was called on select, replacing with closest dropdown");$module=$module.parent(selector.dropdown);instance=$module.data(moduleNamespace);element=$module[0];module.refresh();module.setup.returnedObject()},returnedObject:function(){var $firstModules=$allModules.slice(0,elementIndex),$lastModules=$allModules.slice(elementIndex+1);$allModules=$firstModules.add($module).add($lastModules)}},refresh:function(){module.refreshSelectors();module.refreshData()},refreshItems:function(){$item=$menu.find(selector.item);$divider=settings.hideDividers?$item.parent().children(selector.divider):$()},refreshSelectors:function(){module.verbose("Refreshing selector cache");$text=$module.find(selector.text);$search=$module.find(selector.search);$input=$module.find(selector.input);$icon=$module.find(selector.icon);$combo=$module.prev().find(selector.text).length>0?$module.prev().find(selector.text):$module.prev();$menu=$module.children(selector.menu);$item=$menu.find(selector.item);$divider=settings.hideDividers?$item.parent().children(selector.divider):$()},refreshData:function(){module.verbose("Refreshing cached metadata");$item.removeData(metadata.text).removeData(metadata.value)},clearData:function(){module.verbose("Clearing metadata");$item.removeData(metadata.text).removeData(metadata.value);$module.removeData(metadata.defaultText).removeData(metadata.defaultValue).removeData(metadata.placeholderText)},clearItems:function(){$menu.empty();module.refreshItems()},toggle:function(){module.verbose("Toggling menu visibility");if(!module.is.active()){module.show()}else{module.hide()}},show:function(callback,preventFocus){callback=$.isFunction(callback)?callback:function(){};if((focused||iconClicked)&&module.is.remote()&&module.is.noApiCache()){module.clearItems()}if(!module.can.show()&&module.is.remote()){module.debug("No API results retrieved, searching before show");module.queryRemote(module.get.query(),module.show,[callback,preventFocus])}if(module.can.show()&&!module.is.active()){module.debug("Showing dropdown");if(module.has.message()&&!(module.has.maxSelections()||module.has.allResultsFiltered())){module.remove.message()}if(module.is.allFiltered()){return true}if(settings.onShow.call(element)!==false){module.remove.empty();module.animate.show((function(){module.bind.intent();if(module.has.search()&&!preventFocus){module.focusSearch()}module.set.visible();callback.call(element)}))}}},hide:function(callback,preventBlur){callback=$.isFunction(callback)?callback:function(){};if(module.is.active()&&!module.is.animatingOutward()){module.debug("Hiding dropdown");if(settings.onHide.call(element)!==false){module.animate.hide((function(){module.remove.visible();if(module.is.focusedOnSearch()&&preventBlur!==true){$search.blur()}callback.call(element)}));var $subMenu=$module.find(selector.menu);if($subMenu.length>0){module.verbose("Hiding sub-menu",$subMenu);$subMenu.each((function(){module.animate.hide(false,$(this))}))}}}else{module.unbind.intent()}iconClicked=false;focused=false},hideOthers:function(){module.verbose("Finding other dropdowns to hide");$allModules.not($module).has(selector.menu+"."+className.visible).dropdown("hide")},hideMenu:function(){module.verbose("Hiding menu  instantaneously");module.remove.active();module.remove.visible();$menu.transition("destroy").transition("hide")},hideSubMenus:function(){var $subMenus=$menu.children(selector.item).find(selector.menu);module.verbose("Hiding sub menus",$subMenus);$subMenus.transition("hide")},bind:{events:function(){module.bind.keyboardEvents();module.bind.inputEvents();module.bind.mouseEvents()},keyboardEvents:function(){module.verbose("Binding keyboard events");$module.on("keydown"+eventNamespace,module.event.keydown);if(module.has.search()){$module.on(module.get.inputEvent()+eventNamespace,selector.search,module.event.input)}if(module.is.multiple()){$document.on("keydown"+elementNamespace,module.event.document.keydown)}},inputEvents:function(){module.verbose("Binding input change events");$module.on("change"+eventNamespace,selector.input,module.event.change);if(module.is.multiple()&&module.is.searchSelection()){$module.on("paste"+eventNamespace,selector.search,module.event.paste)}},mouseEvents:function(){module.verbose("Binding mouse events");if(module.is.multiple()){$module.on("click"+eventNamespace,selector.label,module.event.label.click).on("click"+eventNamespace,selector.remove,module.event.remove.click)}if(module.is.searchSelection()){$module.on("mousedown"+eventNamespace,module.event.mousedown).on("mouseup"+eventNamespace,module.event.mouseup).on("mousedown"+eventNamespace,selector.menu,module.event.menu.mousedown).on("mouseup"+eventNamespace,selector.menu,module.event.menu.mouseup).on("click"+eventNamespace,selector.icon,module.event.icon.click).on("click"+eventNamespace,selector.clearIcon,module.event.clearIcon.click).on("focus"+eventNamespace,selector.search,module.event.search.focus).on("click"+eventNamespace,selector.search,module.event.search.focus).on("blur"+eventNamespace,selector.search,module.event.search.blur).on("click"+eventNamespace,selector.text,module.event.text.focus);if(module.is.multiple()){$module.on("click"+eventNamespace,module.event.click).on("click"+eventNamespace,module.event.search.focus)}}else{if(settings.on=="click"){$module.on("click"+eventNamespace,selector.icon,module.event.icon.click).on("click"+eventNamespace,module.event.test.toggle)}else if(settings.on=="hover"){$module.on("mouseenter"+eventNamespace,module.delay.show).on("mouseleave"+eventNamespace,module.delay.hide).on("touchstart"+eventNamespace,module.event.test.toggle).on("touchstart"+eventNamespace,selector.icon,module.event.icon.click)}else{$module.on(settings.on+eventNamespace,module.toggle)}$module.on("mousedown"+eventNamespace,module.event.mousedown).on("mouseup"+eventNamespace,module.event.mouseup).on("focus"+eventNamespace,module.event.focus).on("click"+eventNamespace,selector.clearIcon,module.event.clearIcon.click);if(module.has.menuSearch()){$module.on("blur"+eventNamespace,selector.search,module.event.search.blur)}else{$module.on("blur"+eventNamespace,module.event.blur)}}$menu.on("mouseenter"+eventNamespace,selector.item,module.event.item.mouseenter).on("touchstart"+eventNamespace,selector.item,module.event.item.mouseenter).on("mouseleave"+eventNamespace,selector.item,module.event.item.mouseleave).on("click"+eventNamespace,selector.item,module.event.item.click)},intent:function(){module.verbose("Binding hide intent event to document");$document.on("click"+elementNamespace,module.event.test.hide)}},unbind:{intent:function(){module.verbose("Removing hide intent event from document");$document.off("click"+elementNamespace)}},filter:function(query){var searchTerm=query!==undefined?query:module.get.query(),afterFiltered=function(){if(module.is.multiple()){module.filterActive()}if(query||!query&&module.get.activeItem().length==0){module.select.firstUnfiltered()}if(module.has.allResultsFiltered()){if(settings.onNoResults.call(element,searchTerm)){if(settings.allowAdditions){if(settings.hideAdditions){module.verbose("User addition with no menu, setting empty style");module.set.empty();module.hideMenu()}}else{module.verbose("All items filtered, showing message",searchTerm);module.add.message(message.noResults)}}else{module.verbose("All items filtered, hiding dropdown",searchTerm);module.set.empty();module.hideMenu()}}else{module.remove.empty();module.remove.message()}if(settings.allowAdditions){module.add.userSuggestion(module.escape.htmlEntities(query))}if(module.is.searchSelection()&&module.can.show()&&module.is.focusedOnSearch()&&!module.is.empty()){module.show()}};if(settings.useLabels&&module.has.maxSelections()){return}if(settings.apiSettings){if(module.can.useAPI()){module.queryRemote(searchTerm,(function(){if(settings.filterRemoteData){module.filterItems(searchTerm)}var preSelected=$input.val();if(!Array.isArray(preSelected)){preSelected=preSelected&&preSelected!==""?preSelected.split(settings.delimiter):[]}if(module.is.multiple()){$.each(preSelected,(function(index,value){$item.filter('[data-value="'+value+'"]').addClass(className.filtered)}))}module.focusSearch(true);afterFiltered()}))}else{module.error(error.noAPI)}}else{module.filterItems(searchTerm);afterFiltered()}},queryRemote:function(query,callback,callbackParameters){if(!Array.isArray(callbackParameters)){callbackParameters=[callbackParameters]}var apiSettings={errorDuration:false,cache:"local",throttle:settings.throttle,urlData:{query:query}},apiCallbacks={onError:function(errorMessage,$module,xhr){module.add.message(message.serverError);iconClicked=false;focused=false;callback.apply(null,callbackParameters);if(typeof settings.apiSettings.onError==="function"){settings.apiSettings.onError.call(this,errorMessage,$module,xhr)}},onFailure:function(response,$module,xhr){module.add.message(message.serverError);iconClicked=false;focused=false;callback.apply(null,callbackParameters);if(typeof settings.apiSettings.onFailure==="function"){settings.apiSettings.onFailure.call(this,response,$module,xhr)}},onSuccess:function(response,$module,xhr){var values=response[fields.remoteValues];if(!Array.isArray(values)){values=[]}module.remove.message();var menuConfig={};menuConfig[fields.values]=values;module.setup.menu(menuConfig);if(values.length===0&&!settings.allowAdditions){module.add.message(message.noResults)}else{var value=module.is.multiple()?module.get.values():module.get.value();if(value!==""){module.verbose("Value(s) present after click icon, select value(s) in items");module.set.selected(value,null,true,true)}}iconClicked=false;focused=false;callback.apply(null,callbackParameters);if(typeof settings.apiSettings.onSuccess==="function"){settings.apiSettings.onSuccess.call(this,response,$module,xhr)}}};if(!$module.api("get request")){module.setup.api()}apiSettings=$.extend(true,{},apiSettings,settings.apiSettings,apiCallbacks);$module.api("setting",apiSettings).api("query")},filterItems:function(query){var searchTerm=module.remove.diacritics(query!==undefined?query:module.get.query()),results=null,escapedTerm=module.escape.string(searchTerm),regExpFlags=(settings.ignoreSearchCase?"i":"")+"gm",beginsWithRegExp=new RegExp("^"+escapedTerm,regExpFlags);if(module.has.query()){results=[];module.verbose("Searching for matching values",searchTerm);$item.each((function(){var $choice=$(this),text,value;if($choice.hasClass(className.unfilterable)){results.push(this);return true}if(settings.match==="both"||settings.match==="text"){text=module.remove.diacritics(String(module.get.choiceText($choice,false)));if(text.search(beginsWithRegExp)!==-1||settings.fullTextSearch==="exact"&&module.exactSearch(searchTerm,text)||settings.fullTextSearch===true&&module.fuzzySearch(searchTerm,text)){results.push(this);return true}}if(settings.match==="both"||settings.match==="value"){value=module.remove.diacritics(String(module.get.choiceValue($choice,text)));if(value.search(beginsWithRegExp)!==-1||settings.fullTextSearch==="exact"&&module.exactSearch(searchTerm,value)||settings.fullTextSearch===true&&module.fuzzySearch(searchTerm,value)){results.push(this);return true}}}))}module.debug("Showing only matched items",searchTerm);module.remove.filteredItem();if(results){$item.not(results).addClass(className.filtered)}if(!module.has.query()){$divider.removeClass(className.hidden)}else if(settings.hideDividers===true){$divider.addClass(className.hidden)}else if(settings.hideDividers==="empty"){$divider.removeClass(className.hidden).filter((function(){var lastDivider=$(this).nextUntil(selector.item);return(lastDivider.length?lastDivider:$(this)).nextUntil(selector.divider).filter(selector.item+":not(."+className.filtered+")").length===0})).addClass(className.hidden)}},fuzzySearch:function(query,term){var termLength=term.length,queryLength=query.length;query=settings.ignoreSearchCase?query.toLowerCase():query;term=settings.ignoreSearchCase?term.toLowerCase():term;if(queryLength>termLength){return false}if(queryLength===termLength){return query===term}search:for(var characterIndex=0,nextCharacterIndex=0;characterIndex<queryLength;characterIndex++){var queryCharacter=query.charCodeAt(characterIndex);while(nextCharacterIndex<termLength){if(term.charCodeAt(nextCharacterIndex++)===queryCharacter){continue search}}return false}return true},exactSearch:function(query,term){query=settings.ignoreSearchCase?query.toLowerCase():query;term=settings.ignoreSearchCase?term.toLowerCase():term;return term.indexOf(query)>-1},filterActive:function(){if(settings.useLabels){$item.filter("."+className.active).addClass(className.filtered)}},focusSearch:function(skipHandler){if(module.has.search()&&!module.is.focusedOnSearch()){if(skipHandler){$module.off("focus"+eventNamespace,selector.search);$search.focus();$module.on("focus"+eventNamespace,selector.search,module.event.search.focus)}else{$search.focus()}}},blurSearch:function(){if(module.has.search()){$search.blur()}},forceSelection:function(){var $currentlySelected=$item.not(className.filtered).filter("."+className.selected).eq(0),$activeItem=$item.not(className.filtered).filter("."+className.active).eq(0),$selectedItem=$currentlySelected.length>0?$currentlySelected:$activeItem,hasSelected=$selectedItem.length>0;if(settings.allowAdditions||hasSelected&&!module.is.multiple()){module.debug("Forcing partial selection to selected item",$selectedItem);module.event.item.click.call($selectedItem,{},true)}else{module.remove.searchTerm()}},change:{values:function(values){if(!settings.allowAdditions){module.clear()}module.debug("Creating dropdown with specified values",values);var menuConfig={};menuConfig[fields.values]=values;module.setup.menu(menuConfig);$.each(values,(function(index,item){if(item.selected===true){module.debug("Setting initial selection to",item[fields.value]);module.set.selected(item[fields.value]);if(!module.is.multiple()){return false}}}));if(module.has.selectInput()){module.disconnect.selectObserver();$input.html("");$input.append("<option disabled selected value></option>");$.each(values,(function(index,item){var value=settings.templates.deQuote(item[fields.value]),name=settings.templates.escape(item[fields.name]||"",settings.preserveHTML);$input.append('<option value="'+value+'"'+(item.selected===true?" selected":"")+">"+name+"</option>")}));module.observe.select()}}},event:{paste:function(event){var pasteValue=(event.originalEvent.clipboardData||window.clipboardData).getData("text"),tokens=pasteValue.split(settings.delimiter);tokens.forEach((function(value){module.set.selected(module.escape.htmlEntities(value.trim()),null,true,true)}));event.preventDefault()},change:function(){if(!internalChange){module.debug("Input changed, updating selection");module.set.selected()}},focus:function(){if(settings.showOnFocus&&!activated&&module.is.hidden()&&!pageLostFocus){focused=true;module.show()}},blur:function(event){pageLostFocus=document.activeElement===this;if(!activated&&!pageLostFocus){module.remove.activeLabel();module.hide()}},mousedown:function(){if(module.is.searchSelection(true)){willRefocus=true}else{activated=true}},mouseup:function(){if(module.is.searchSelection(true)){willRefocus=false}else{activated=false}},click:function(event){var $target=$(event.target);if($target.is($module)){if(!module.is.focusedOnSearch()){module.focusSearch()}else{module.show()}}},search:{focus:function(event){activated=true;if(module.is.multiple()){module.remove.activeLabel()}if(!focused&&!module.is.active()&&(settings.showOnFocus||event.type!=="focus"&&event.type!=="focusin")&&event.type!=="touchstart"){focused=true;module.search()}},blur:function(event){pageLostFocus=document.activeElement===this;if(module.is.searchSelection(true)&&!willRefocus){if(!itemActivated&&!pageLostFocus){if(settings.forceSelection){module.forceSelection()}else if(!settings.allowAdditions){module.remove.searchTerm()}module.hide()}}willRefocus=false}},clearIcon:{click:function(event){module.clear();if(module.is.searchSelection()){module.remove.searchTerm()}module.hide();event.stopPropagation()}},icon:{click:function(event){iconClicked=true;if(module.has.search()){if(!module.is.active()){if(settings.showOnFocus){module.focusSearch()}else{module.toggle()}}else{module.blurSearch()}}else{module.toggle()}event.stopPropagation()}},text:{focus:function(event){activated=true;module.focusSearch()}},input:function(event){if(module.is.multiple()||module.is.searchSelection()){module.set.filtered()}clearTimeout(module.timer);module.timer=setTimeout(module.search,settings.delay.search)},label:{click:function(event){var $label=$(this),$labels=$module.find(selector.label),$activeLabels=$labels.filter("."+className.active),$nextActive=$label.nextAll("."+className.active),$prevActive=$label.prevAll("."+className.active),$range=$nextActive.length>0?$label.nextUntil($nextActive).add($activeLabels).add($label):$label.prevUntil($prevActive).add($activeLabels).add($label);if(event.shiftKey){$activeLabels.removeClass(className.active);$range.addClass(className.active)}else if(event.ctrlKey){$label.toggleClass(className.active)}else{$activeLabels.removeClass(className.active);$label.addClass(className.active)}settings.onLabelSelect.apply(this,$labels.filter("."+className.active));event.stopPropagation()}},remove:{click:function(event){var $label=$(this).parent();if($label.hasClass(className.active)){module.remove.activeLabels()}else{module.remove.activeLabels($label)}event.stopPropagation()}},test:{toggle:function(event){var toggleBehavior=module.is.multiple()?module.show:module.toggle;if(module.is.bubbledLabelClick(event)||module.is.bubbledIconClick(event)){return}if(!module.is.multiple()||module.is.multiple()&&!module.is.active()){focused=true}if(module.determine.eventOnElement(event,toggleBehavior)&&event.type!=="touchstart"){event.preventDefault()}},hide:function(event){if(module.determine.eventInModule(event,module.hide)){if(element.id&&$(event.target).attr("for")===element.id){event.preventDefault()}}}},class:{mutation:function(mutations){mutations.forEach((function(mutation){if(mutation.attributeName==="class"){module.check.disabled()}}))}},select:{mutation:function(mutations){if(module.is.selectMutation(mutations)){module.debug("<select> modified, recreating menu");module.disconnect.selectObserver();module.refresh();module.setup.select();module.set.selected();module.observe.select()}}},menu:{mutation:function(mutations){var mutation=mutations[0],$addedNode=mutation.addedNodes?$(mutation.addedNodes[0]):$(false),$removedNode=mutation.removedNodes?$(mutation.removedNodes[0]):$(false),$changedNodes=$addedNode.add($removedNode),isUserAddition=$changedNodes.is(selector.addition)||$changedNodes.closest(selector.addition).length>0,isMessage=$changedNodes.is(selector.message)||$changedNodes.closest(selector.message).length>0;if(isUserAddition||isMessage){module.debug("Updating item selector cache");module.refreshItems()}else{module.debug("Menu modified, updating selector cache");module.refresh()}},mousedown:function(){itemActivated=true},mouseup:function(){itemActivated=false}},item:{mouseenter:function(event){var $target=$(event.target),$item=$(this),$subMenu=$item.children(selector.menu),$otherMenus=$item.siblings(selector.item).children(selector.menu),hasSubMenu=$subMenu.length>0,isBubbledEvent=$subMenu.find($target).length>0;if(!isBubbledEvent&&hasSubMenu){clearTimeout(module.itemTimer);module.itemTimer=setTimeout((function(){module.verbose("Showing sub-menu",$subMenu);$.each($otherMenus,(function(){module.animate.hide(false,$(this))}));module.animate.show(false,$subMenu)}),settings.delay.show);event.preventDefault()}},mouseleave:function(event){var $subMenu=$(this).find(selector.menu);if($subMenu.length>0){clearTimeout(module.itemTimer);module.itemTimer=setTimeout((function(){module.verbose("Hiding sub-menu",$subMenu);$subMenu.each((function(){module.animate.hide(false,$(this))}))}),settings.delay.hide)}},click:function(event,skipRefocus){var $choice=$(this),$target=event?$(event.target):$(""),$subMenu=$choice.find(selector.menu),text=module.get.choiceText($choice),value=module.get.choiceValue($choice,text),hasSubMenu=$subMenu.length>0,isBubbledEvent=$subMenu.find($target).length>0;if(document.activeElement.tagName.toLowerCase()!=="input"){$(document.activeElement).blur()}if(!isBubbledEvent&&(!hasSubMenu||settings.allowCategorySelection)){if(module.is.searchSelection()){if(settings.allowAdditions){module.remove.userAddition()}module.remove.filteredItem();if(!module.is.visible()){module.show()}module.remove.searchTerm();if(!module.is.focusedOnSearch()&&skipRefocus!==true){module.focusSearch(true)}}if(!settings.useLabels){module.remove.filteredItem();module.set.scrollPosition($choice)}module.determine.selectAction.call(this,text,value)}}},document:{keydown:function(event){var pressedKey=event.which,isShortcutKey=module.is.inObject(pressedKey,keys);if(isShortcutKey){var $label=$module.find(selector.label),$activeLabel=$label.filter("."+className.active),activeValue=$activeLabel.data(metadata.value),labelIndex=$label.index($activeLabel),labelCount=$label.length,hasActiveLabel=$activeLabel.length>0,hasMultipleActive=$activeLabel.length>1,isFirstLabel=labelIndex===0,isLastLabel=labelIndex+1==labelCount,isSearch=module.is.searchSelection(),isFocusedOnSearch=module.is.focusedOnSearch(),isFocused=module.is.focused(),caretAtStart=isFocusedOnSearch&&module.get.caretPosition(false)===0,isSelectedSearch=caretAtStart&&module.get.caretPosition(true)!==0;if(isSearch&&!hasActiveLabel&&!isFocusedOnSearch){return}if(pressedKey==keys.leftArrow){if((isFocused||caretAtStart)&&!hasActiveLabel){module.verbose("Selecting previous label");$label.last().addClass(className.active)}else if(hasActiveLabel){if(!event.shiftKey){module.verbose("Selecting previous label");$label.removeClass(className.active)}else{module.verbose("Adding previous label to selection")}if(isFirstLabel&&!hasMultipleActive){$activeLabel.addClass(className.active)}else{$activeLabel.prev(selector.siblingLabel).addClass(className.active).end()}event.preventDefault()}}else if(pressedKey==keys.rightArrow){if(isFocused&&!hasActiveLabel){$label.first().addClass(className.active)}if(hasActiveLabel){if(!event.shiftKey){module.verbose("Selecting next label");$label.removeClass(className.active)}else{module.verbose("Adding next label to selection")}if(isLastLabel){if(isSearch){if(!isFocusedOnSearch){module.focusSearch()}else{$label.removeClass(className.active)}}else if(hasMultipleActive){$activeLabel.next(selector.siblingLabel).addClass(className.active)}else{$activeLabel.addClass(className.active)}}else{$activeLabel.next(selector.siblingLabel).addClass(className.active)}event.preventDefault()}}else if(pressedKey==keys.deleteKey||pressedKey==keys.backspace){if(hasActiveLabel){module.verbose("Removing active labels");if(isLastLabel){if(isSearch&&!isFocusedOnSearch){module.focusSearch()}}$activeLabel.last().next(selector.siblingLabel).addClass(className.active);module.remove.activeLabels($activeLabel);if(!module.is.visible()){module.show()}event.preventDefault()}else if(caretAtStart&&!isSelectedSearch&&!hasActiveLabel&&pressedKey==keys.backspace){module.verbose("Removing last label on input backspace");$activeLabel=$label.last().addClass(className.active);module.remove.activeLabels($activeLabel);if(!module.is.visible()){module.show()}}}else{$activeLabel.removeClass(className.active)}}}},keydown:function(event){var pressedKey=event.which,isShortcutKey=module.is.inObject(pressedKey,keys)||event.key===settings.delimiter;if(isShortcutKey){var $currentlySelected=$item.not(selector.unselectable).filter("."+className.selected).eq(0),$activeItem=$menu.children("."+className.active).eq(0),$selectedItem=$currentlySelected.length>0?$currentlySelected:$activeItem,$visibleItems=$selectedItem.length>0?$selectedItem.siblings(":not(."+className.filtered+")").addBack():$menu.children(":not(."+className.filtered+")"),$subMenu=$selectedItem.children(selector.menu),$parentMenu=$selectedItem.closest(selector.menu),inVisibleMenu=$parentMenu.hasClass(className.visible)||$parentMenu.hasClass(className.animating)||$parentMenu.parent(selector.menu).length>0,hasSubMenu=$subMenu.length>0,hasSelectedItem=$selectedItem.length>0,selectedIsSelectable=$selectedItem.not(selector.unselectable).length>0,delimiterPressed=event.key===settings.delimiter&&module.is.multiple(),isAdditionWithoutMenu=settings.allowAdditions&&(pressedKey==keys.enter||delimiterPressed),$nextItem,isSubMenuItem;if(isAdditionWithoutMenu){if(selectedIsSelectable&&settings.hideAdditions){module.verbose("Selecting item from keyboard shortcut",$selectedItem);module.event.item.click.call($selectedItem,event)}if(module.is.searchSelection()){module.remove.searchTerm()}if(module.is.multiple()){event.preventDefault()}}if(module.is.visible()){if(pressedKey==keys.enter||delimiterPressed){if(pressedKey==keys.enter&&hasSelectedItem&&hasSubMenu&&!settings.allowCategorySelection){module.verbose("Pressed enter on unselectable category, opening sub menu");pressedKey=keys.rightArrow}else if(selectedIsSelectable){module.verbose("Selecting item from keyboard shortcut",$selectedItem);module.event.item.click.call($selectedItem,event);if(module.is.searchSelection()){module.remove.searchTerm();if(module.is.multiple()){$search.focus()}}}event.preventDefault()}if(hasSelectedItem){if(pressedKey==keys.leftArrow){isSubMenuItem=$parentMenu[0]!==$menu[0];if(isSubMenuItem){module.verbose("Left key pressed, closing sub-menu");module.animate.hide(false,$parentMenu);$selectedItem.removeClass(className.selected);$parentMenu.closest(selector.item).addClass(className.selected);event.preventDefault()}}if(pressedKey==keys.rightArrow){if(hasSubMenu){module.verbose("Right key pressed, opening sub-menu");module.animate.show(false,$subMenu);$selectedItem.removeClass(className.selected);$subMenu.find(selector.item).eq(0).addClass(className.selected);event.preventDefault()}}}if(pressedKey==keys.upArrow){$nextItem=hasSelectedItem&&inVisibleMenu?$selectedItem.prevAll(selector.item+":not("+selector.unselectable+")").eq(0):$item.eq(0);if($visibleItems.index($nextItem)<0){module.verbose("Up key pressed but reached top of current menu");event.preventDefault();return}else{module.verbose("Up key pressed, changing active item");$selectedItem.removeClass(className.selected);$nextItem.addClass(className.selected);module.set.scrollPosition($nextItem);if(settings.selectOnKeydown&&module.is.single()&&!$nextItem.hasClass(className.actionable)){module.set.selectedItem($nextItem)}}event.preventDefault()}if(pressedKey==keys.downArrow){$nextItem=hasSelectedItem&&inVisibleMenu?$selectedItem.nextAll(selector.item+":not("+selector.unselectable+")").eq(0):$item.eq(0);if($nextItem.length===0){module.verbose("Down key pressed but reached bottom of current menu");event.preventDefault();return}else{module.verbose("Down key pressed, changing active item");$item.removeClass(className.selected);$nextItem.addClass(className.selected);module.set.scrollPosition($nextItem);if(settings.selectOnKeydown&&module.is.single()&&!$nextItem.hasClass(className.actionable)){module.set.selectedItem($nextItem)}}event.preventDefault()}if(pressedKey==keys.pageUp){module.scrollPage("up");event.preventDefault()}if(pressedKey==keys.pageDown){module.scrollPage("down");event.preventDefault()}if(pressedKey==keys.escape){module.verbose("Escape key pressed, closing dropdown");module.hide();event.stopPropagation()}}else{if(pressedKey==keys.enter||delimiterPressed){event.preventDefault()}if(pressedKey==keys.downArrow&&!module.is.visible()){module.verbose("Down key pressed, showing dropdown");module.show();event.preventDefault()}}}else{if(!module.has.search()){module.set.selectedLetter(String.fromCharCode(pressedKey))}}}},trigger:{change:function(){var inputElement=$input[0];if(inputElement){var events=document.createEvent("HTMLEvents");module.verbose("Triggering native change event");events.initEvent("change",true,false);inputElement.dispatchEvent(events)}}},determine:{selectAction:function(text,value){selectActionActive=true;module.verbose("Determining action",settings.action);if($.isFunction(module.action[settings.action])){module.verbose("Triggering preset action",settings.action,text,value);module.action[settings.action].call(element,text,value,this)}else if($.isFunction(settings.action)){module.verbose("Triggering user action",settings.action,text,value);settings.action.call(element,text,value,this)}else{module.error(error.action,settings.action)}selectActionActive=false},eventInModule:function(event,callback){var $target=$(event.target),inDocument=$target.closest(document.documentElement).length>0,inModule=$target.closest($module).length>0;callback=$.isFunction(callback)?callback:function(){};if(inDocument&&!inModule){module.verbose("Triggering event",callback);callback();return true}else{module.verbose("Event occurred in dropdown, canceling callback");return false}},eventOnElement:function(event,callback){var $target=$(event.target),$label=$target.closest(selector.siblingLabel),inVisibleDOM=document.body.contains(event.target),notOnLabel=$module.find($label).length===0||!(module.is.multiple()&&settings.useLabels),notInMenu=$target.closest($menu).length===0;callback=$.isFunction(callback)?callback:function(){};if(inVisibleDOM&&notOnLabel&&notInMenu){module.verbose("Triggering event",callback);callback();return true}else{module.verbose("Event occurred in dropdown menu, canceling callback");return false}}},action:{nothing:function(){},activate:function(text,value,element){value=value!==undefined?value:text;if(module.can.activate($(element))){module.set.selected(value,$(element));if(!module.is.multiple()&&!(!settings.collapseOnActionable&&$(element).hasClass(className.actionable))){module.hideAndClear()}}},select:function(text,value,element){value=value!==undefined?value:text;if(module.can.activate($(element))){module.set.value(value,text,$(element));if(!module.is.multiple()&&!(!settings.collapseOnActionable&&$(element).hasClass(className.actionable))){module.hideAndClear()}}},combo:function(text,value,element){value=value!==undefined?value:text;module.set.selected(value,$(element));module.hideAndClear()},hide:function(text,value,element){module.set.value(value,text,$(element));module.hideAndClear()}},get:{id:function(){return id},defaultText:function(){return $module.data(metadata.defaultText)},defaultValue:function(){return $module.data(metadata.defaultValue)},placeholderText:function(){if(settings.placeholder!="auto"&&typeof settings.placeholder=="string"){return settings.placeholder}return $module.data(metadata.placeholderText)||""},text:function(){return settings.preserveHTML?$text.html():$text.text()},query:function(){return String($search.val()).trim()},searchWidth:function(value){value=value!==undefined?value:$search.val();$sizer.text(value);return Math.ceil($sizer.width()+(module.is.edge()?3:1))},selectionCount:function(){var values=module.get.values(),count;count=module.is.multiple()?Array.isArray(values)?values.length:0:module.get.value()!==""?1:0;return count},transition:function($subMenu){return settings.transition==="auto"?module.is.upward($subMenu)?"slide up":"slide down":settings.transition},userValues:function(){var values=module.get.values(true);if(!values){return false}values=Array.isArray(values)?values:[values];return $.grep(values,(function(value){return module.get.item(value)===false}))},uniqueArray:function(array){return $.grep(array,(function(value,index){return $.inArray(value,array)===index}))},caretPosition:function(returnEndPos){var input=$search[0],range,rangeLength;if(returnEndPos&&"selectionEnd"in input){return input.selectionEnd}else if(!returnEndPos&&"selectionStart"in input){return input.selectionStart}if(document.selection){input.focus();range=document.selection.createRange();rangeLength=range.text.length;if(returnEndPos){return rangeLength}range.moveStart("character",-input.value.length);return range.text.length-rangeLength}},value:function(){var value=$input.length>0?$input.val():$module.data(metadata.value),isEmptyMultiselect=Array.isArray(value)&&value.length===1&&value[0]==="";return value===undefined||isEmptyMultiselect?"":value},values:function(raw){var value=module.get.value();if(value===""){return""}return!module.has.selectInput()&&module.is.multiple()?typeof value=="string"?(raw?value:module.escape.htmlEntities(value)).split(settings.delimiter):"":value},remoteValues:function(){var values=module.get.values(),remoteValues=false;if(values){if(typeof values=="string"){values=[values]}$.each(values,(function(index,value){var name=module.read.remoteData(value);module.verbose("Restoring value from session data",name,value);if(name){if(!remoteValues){remoteValues={}}remoteValues[value]=name}}))}return remoteValues},choiceText:function($choice,preserveHTML){preserveHTML=preserveHTML!==undefined?preserveHTML:settings.preserveHTML;if($choice){if($choice.find(selector.menu).length>0){module.verbose("Retrieving text of element with sub-menu");$choice=$choice.clone();$choice.find(selector.menu).remove();$choice.find(selector.menuIcon).remove()}return $choice.data(metadata.text)!==undefined?$choice.data(metadata.text):preserveHTML?$choice.html()&&$choice.html().trim():$choice.text()&&$choice.text().trim()}},choiceValue:function($choice,choiceText){choiceText=choiceText||module.get.choiceText($choice);if(!$choice){return false}return $choice.data(metadata.value)!==undefined?String($choice.data(metadata.value)):typeof choiceText==="string"?String(settings.ignoreSearchCase?choiceText.toLowerCase():choiceText).trim():String(choiceText)},inputEvent:function(){var input=$search[0];if(input){return input.oninput!==undefined?"input":input.onpropertychange!==undefined?"propertychange":"keyup"}return false},selectValues:function(){var select={},oldGroup=[],values=[];$module.find("option").each((function(){var $option=$(this),name=$option.html(),disabled=$option.attr("disabled"),value=$option.attr("value")!==undefined?$option.attr("value"):name,text=$option.data(metadata.text)!==undefined?$option.data(metadata.text):name,group=$option.parent("optgroup");if(settings.placeholder==="auto"&&value===""){select.placeholder=name}else{if(group.length!==oldGroup.length||group[0]!==oldGroup[0]){values.push({type:"header",divider:settings.headerDivider,name:group.attr("label")||""});oldGroup=group}values.push({name:name,value:value,text:text,disabled:disabled})}}));if(settings.placeholder&&settings.placeholder!=="auto"){module.debug("Setting placeholder value to",settings.placeholder);select.placeholder=settings.placeholder}if(settings.sortSelect){if(settings.sortSelect===true){values.sort((function(a,b){return a.name.localeCompare(b.name)}))}else if(settings.sortSelect==="natural"){values.sort((function(a,b){return a.name.toLowerCase().localeCompare(b.name.toLowerCase())}))}else if($.isFunction(settings.sortSelect)){values.sort(settings.sortSelect)}select[fields.values]=values;module.debug("Retrieved and sorted values from select",select)}else{select[fields.values]=values;module.debug("Retrieved values from select",select)}return select},activeItem:function(){return $item.filter("."+className.active)},selectedItem:function(){var $selectedItem=$item.not(selector.unselectable).filter("."+className.selected);return $selectedItem.length>0?$selectedItem:$item.eq(0)},itemWithAdditions:function(value){var $items=module.get.item(value),$userItems=module.create.userChoice(value),hasUserItems=$userItems&&$userItems.length>0;if(hasUserItems){$items=$items.length>0?$items.add($userItems):$userItems}return $items},item:function(value,strict){var $selectedItem=false,shouldSearch,isMultiple;value=value!==undefined?value:module.get.values()!==undefined?module.get.values():module.get.text();isMultiple=module.is.multiple()&&Array.isArray(value);shouldSearch=isMultiple?value.length>0:value!==undefined&&value!==null;strict=value===""||value===false||value===true?true:strict||false;if(shouldSearch){$item.each((function(){var $choice=$(this),optionText=module.get.choiceText($choice),optionValue=module.get.choiceValue($choice,optionText);if(optionValue===null||optionValue===undefined){return}if(isMultiple){if($.inArray(module.escape.htmlEntities(String(optionValue)),value.map((function(v){return String(v)})))!==-1){$selectedItem=$selectedItem?$selectedItem.add($choice):$choice}}else if(strict){module.verbose("Ambiguous dropdown value using strict type check",$choice,value);if(optionValue===value){$selectedItem=$choice;return true}}else{if(settings.ignoreCase){optionValue=optionValue.toLowerCase();value=value.toLowerCase()}if(module.escape.htmlEntities(String(optionValue))===module.escape.htmlEntities(String(value))){module.verbose("Found select item by value",optionValue,value);$selectedItem=$choice;return true}}}))}return $selectedItem},displayType:function(){return $module.hasClass("column")?"flex":settings.displayType}},check:{maxSelections:function(selectionCount){if(settings.maxSelections){selectionCount=selectionCount!==undefined?selectionCount:module.get.selectionCount();if(selectionCount>=settings.maxSelections){module.debug("Maximum selection count reached");if(settings.useLabels){$item.addClass(className.filtered);module.add.message(message.maxSelections)}return true}else{module.verbose("No longer at maximum selection count");module.remove.message();module.remove.filteredItem();if(module.is.searchSelection()){module.filterItems()}return false}}return true},disabled:function(){$search.attr("tabindex",module.is.disabled()?-1:0)}},restore:{defaults:function(preventChangeTrigger){module.clear(preventChangeTrigger);module.restore.defaultText();module.restore.defaultValue()},defaultText:function(){var defaultText=module.get.defaultText(),placeholderText=module.get.placeholderText;if(defaultText===placeholderText){module.debug("Restoring default placeholder text",defaultText);module.set.placeholderText(defaultText)}else{module.debug("Restoring default text",defaultText);module.set.text(defaultText)}},placeholderText:function(){module.set.placeholderText()},defaultValue:function(){var defaultValue=module.get.defaultValue();if(defaultValue!==undefined){module.debug("Restoring default value",defaultValue);if(defaultValue!==""){module.set.value(defaultValue);module.set.selected()}else{module.remove.activeItem();module.remove.selectedItem()}}},labels:function(){if(settings.allowAdditions){if(!settings.useLabels){module.error(error.labels);settings.useLabels=true}module.debug("Restoring selected values");module.create.userLabels()}module.check.maxSelections()},selected:function(){module.restore.values();if(module.is.multiple()){module.debug("Restoring previously selected values and labels");module.restore.labels()}else{module.debug("Restoring previously selected values")}},values:function(){module.set.initialLoad();if(settings.apiSettings&&settings.saveRemoteData&&module.get.remoteValues()){module.restore.remoteValues()}else{module.set.selected()}var value=module.get.value();if(value&&value!==""&&!(Array.isArray(value)&&value.length===0)){$input.removeClass(className.noselection)}else{$input.addClass(className.noselection)}module.remove.initialLoad()},remoteValues:function(){var values=module.get.remoteValues();module.debug("Recreating selected from session data",values);if(values){if(module.is.single()){$.each(values,(function(value,name){module.set.text(name)}))}else{$.each(values,(function(value,name){module.add.label(value,name)}))}}}},read:{remoteData:function(value){var name;if(window.Storage===undefined){module.error(error.noStorage);return}name=sessionStorage.getItem(value+elementNamespace);return name!==undefined?name:false}},save:{defaults:function(){module.save.defaultText();module.save.placeholderText();module.save.defaultValue()},defaultValue:function(){var value=module.get.value();module.verbose("Saving default value as",value);$module.data(metadata.defaultValue,value)},defaultText:function(){var text=module.get.text();module.verbose("Saving default text as",text);$module.data(metadata.defaultText,text)},placeholderText:function(){var text;if(settings.placeholder!==false&&$text.hasClass(className.placeholder)){text=module.get.text();module.verbose("Saving placeholder text as",text);$module.data(metadata.placeholderText,text)}},remoteData:function(name,value){if(window.Storage===undefined){module.error(error.noStorage);return}module.verbose("Saving remote data to session storage",value,name);sessionStorage.setItem(value+elementNamespace,name)}},clear:function(preventChangeTrigger){if(module.is.multiple()&&settings.useLabels){module.remove.labels($module.find(selector.label),preventChangeTrigger)}else{module.remove.activeItem();module.remove.selectedItem();module.remove.filteredItem()}module.set.placeholderText();module.clearValue(preventChangeTrigger)},clearValue:function(preventChangeTrigger){module.set.value("",null,null,preventChangeTrigger)},scrollPage:function(direction,$selectedItem){var $currentItem=$selectedItem||module.get.selectedItem(),$menu=$currentItem.closest(selector.menu),menuHeight=$menu.outerHeight(),currentScroll=$menu.scrollTop(),itemHeight=$item.eq(0).outerHeight(),itemsPerPage=Math.floor(menuHeight/itemHeight),newScroll=direction=="up"?currentScroll-itemHeight*itemsPerPage:currentScroll+itemHeight*itemsPerPage,$selectableItem=$item.not(selector.unselectable),isWithinRange,$nextSelectedItem,elementIndex;elementIndex=direction=="up"?$selectableItem.index($currentItem)-itemsPerPage:$selectableItem.index($currentItem)+itemsPerPage;isWithinRange=direction=="up"?elementIndex>=0:elementIndex<$selectableItem.length;$nextSelectedItem=isWithinRange?$selectableItem.eq(elementIndex):direction=="up"?$selectableItem.first():$selectableItem.last();if($nextSelectedItem.length>0){module.debug("Scrolling page",direction,$nextSelectedItem);$currentItem.removeClass(className.selected);$nextSelectedItem.addClass(className.selected);if(settings.selectOnKeydown&&module.is.single()&&!$nextItem.hasClass(className.actionable)){module.set.selectedItem($nextSelectedItem)}$menu.scrollTop(newScroll)}},set:{filtered:function(){var isMultiple=module.is.multiple(),isSearch=module.is.searchSelection(),isSearchMultiple=isMultiple&&isSearch,searchValue=isSearch?module.get.query():"",hasSearchValue=typeof searchValue==="string"&&searchValue.length>0,searchWidth=module.get.searchWidth(),valueIsSet=searchValue!=="";if(isMultiple&&hasSearchValue){module.verbose("Adjusting input width",searchWidth,settings.glyphWidth);$search.css("width",searchWidth)}if(hasSearchValue||isSearchMultiple&&valueIsSet){module.verbose("Hiding placeholder text");$text.addClass(className.filtered)}else if(!isMultiple||isSearchMultiple&&!valueIsSet){module.verbose("Showing placeholder text");$text.removeClass(className.filtered)}},empty:function(){$module.addClass(className.empty)},loading:function(){$module.addClass(className.loading)},placeholderText:function(text){text=text||module.get.placeholderText();module.debug("Setting placeholder text",text);module.set.text(text);$text.addClass(className.placeholder)},tabbable:function(){if(module.is.searchSelection()){module.debug("Added tabindex to searchable dropdown");$search.val("");module.check.disabled();$menu.attr("tabindex",-1)}else{module.debug("Added tabindex to dropdown");if($module.attr("tabindex")===undefined){$module.attr("tabindex",0);$menu.attr("tabindex",-1)}}},initialLoad:function(){module.verbose("Setting initial load");initialLoad=true},activeItem:function($item){if(settings.allowAdditions&&$item.filter(selector.addition).length>0){$item.addClass(className.filtered)}else{$item.addClass(className.active)}},partialSearch:function(text){var length=module.get.query().length;$search.val(text.slice(0,length))},scrollPosition:function($item,forceScroll){var edgeTolerance=5,$menu,hasActive,offset,itemOffset,menuOffset,menuScroll,menuHeight,abovePage,belowPage;$item=$item||module.get.selectedItem();$menu=$item.closest(selector.menu);hasActive=$item&&$item.length>0;forceScroll=forceScroll!==undefined?forceScroll:false;if(module.get.activeItem().length===0){forceScroll=false}if($item&&$menu.length>0&&hasActive){itemOffset=$item.position().top;$menu.addClass(className.loading);menuScroll=$menu.scrollTop();menuOffset=$menu.offset().top;itemOffset=$item.offset().top;offset=menuScroll-menuOffset+itemOffset;if(!forceScroll){menuHeight=$menu.height();belowPage=menuScroll+menuHeight<offset+edgeTolerance;abovePage=offset-edgeTolerance<menuScroll}module.debug("Scrolling to active item",offset);if(forceScroll||abovePage||belowPage){$menu.scrollTop(offset)}$menu.removeClass(className.loading)}},text:function(text,isNotPlaceholder){if(settings.action==="combo"){module.debug("Changing combo button text",text,$combo);if(settings.preserveHTML){$combo.html(text)}else{$combo.text(text)}}else if(settings.action==="activate"){if(text!==module.get.placeholderText()||isNotPlaceholder){$text.removeClass(className.placeholder)}module.debug("Changing text",text,$text);$text.removeClass(className.filtered);if(settings.preserveHTML){$text.html(text)}else{$text.text(text)}}},selectedItem:function($item){var value=module.get.choiceValue($item),searchText=module.get.choiceText($item,false),text=module.get.choiceText($item);module.debug("Setting user selection to item",$item);module.remove.activeItem();module.set.partialSearch(searchText);module.set.activeItem($item);module.set.selected(value,$item);module.set.text(text)},selectedLetter:function(letter){var $selectedItem=$item.filter("."+className.selected),alreadySelectedLetter=$selectedItem.length>0&&module.has.firstLetter($selectedItem,letter),$nextValue=false,$nextItem;if(alreadySelectedLetter){$nextItem=$selectedItem.nextAll($item).eq(0);if(module.has.firstLetter($nextItem,letter)){$nextValue=$nextItem}}if(!$nextValue){$item.each((function(){if(module.has.firstLetter($(this),letter)){$nextValue=$(this);return false}}))}if($nextValue){module.verbose("Scrolling to next value with letter",letter);module.set.scrollPosition($nextValue);$selectedItem.removeClass(className.selected);$nextValue.addClass(className.selected);if(settings.selectOnKeydown&&module.is.single()&&!$nextItem.hasClass(className.actionable)){module.set.selectedItem($nextValue)}}},direction:function($menu){if(settings.direction==="auto"){if(!$menu){module.remove.upward()}else if(module.is.upward($menu)){module.remove.upward($menu)}if(module.can.openDownward($menu)){module.remove.upward($menu)}else{module.set.upward($menu)}if(!module.is.leftward($menu)&&!module.can.openRightward($menu)){module.set.leftward($menu)}}else if(settings.direction==="upward"){module.set.upward($menu)}},upward:function($currentMenu){var $element=$currentMenu||$module;$element.addClass(className.upward)},leftward:function($currentMenu){var $element=$currentMenu||$menu;$element.addClass(className.leftward)},value:function(value,text,$selected,preventChangeTrigger){if(typeof text==="boolean"){preventChangeTrigger=text;$selected=undefined;text=undefined}if(value!==undefined&&value!==""&&!(Array.isArray(value)&&value.length===0)){$input.removeClass(className.noselection)}else{$input.addClass(className.noselection)}var escapedValue=module.escape.value(value),hasInput=$input.length>0,currentValue=module.get.values(),stringValue=value!==undefined?String(value):value;if(hasInput){if(!settings.allowReselection&&stringValue==currentValue){module.verbose("Skipping value update already same value",value,currentValue);if(!module.is.initialLoad()){return}}if(module.is.single()&&module.has.selectInput()&&module.can.extendSelect()){module.debug("Adding user option",value);module.add.optionValue(value)}module.debug("Updating input value",escapedValue,currentValue);internalChange=true;$input.val(escapedValue);if(settings.fireOnInit===false&&module.is.initialLoad()){module.debug("Input native change event ignored on initial load")}else if(preventChangeTrigger!==true){module.trigger.change()}internalChange=false}else{module.verbose("Storing value in metadata",escapedValue,$input);if(escapedValue!==currentValue){$module.data(metadata.value,stringValue)}}if(settings.fireOnInit===false&&module.is.initialLoad()){module.verbose("No callback on initial load",settings.onChange)}else if(preventChangeTrigger!==true){settings.onChange.call(element,value,text,$selected)}},active:function(){$module.addClass(className.active)},multiple:function(){$module.addClass(className.multiple)},visible:function(){$module.addClass(className.visible)},exactly:function(value,$selectedItem,preventChangeTrigger){if(typeof $selectedItem==="boolean"){preventChangeTrigger=$selectedItem;$selectedItem=undefined}module.debug("Setting selected to exact values");module.clear();module.set.selected(value,$selectedItem,preventChangeTrigger)},selected:function(value,$selectedItem,preventChangeTrigger,keepSearchTerm){if(typeof $selectedItem==="boolean"){keepSearchTerm=preventChangeTrigger;preventChangeTrigger=$selectedItem;$selectedItem=undefined}var isMultiple=module.is.multiple();$selectedItem=settings.allowAdditions?$selectedItem||module.get.itemWithAdditions(value):$selectedItem||module.get.item(value);if(!$selectedItem){return}module.debug("Setting selected menu item to",$selectedItem);if(module.is.multiple()){module.remove.searchWidth()}if(module.is.single()){module.remove.activeItem();module.remove.selectedItem()}else if(settings.useLabels){module.remove.selectedItem()}$selectedItem.each((function(){var $selected=$(this),selectedText=module.get.choiceText($selected),selectedValue=module.get.choiceValue($selected,selectedText),isFiltered=$selected.hasClass(className.filtered),isActive=$selected.hasClass(className.active),isActionable=$selected.hasClass(className.actionable),isUserValue=$selected.hasClass(className.addition),shouldAnimate=isMultiple&&$selectedItem&&$selectedItem.length===1;if(isActionable){if((!isMultiple||(!isActive||isUserValue))&&settings.apiSettings&&settings.saveRemoteData){module.save.remoteData(selectedText,selectedValue)}settings.onActionable.call(element,selectedValue,selectedText,$selected)}else if(isMultiple){if(!isActive||isUserValue){if(settings.apiSettings&&settings.saveRemoteData){module.save.remoteData(selectedText,selectedValue)}if(settings.useLabels){module.add.value(selectedValue,selectedText,$selected,preventChangeTrigger);module.add.label(selectedValue,selectedText,shouldAnimate);module.set.activeItem($selected);module.filterActive();module.select.nextAvailable($selectedItem)}else{module.add.value(selectedValue,selectedText,$selected,preventChangeTrigger);module.set.text(module.add.variables(message.count));module.set.activeItem($selected)}}else if(!isFiltered&&(settings.useLabels||selectActionActive)){module.debug("Selected active value, removing label");module.remove.selected(selectedValue)}}else{if(settings.apiSettings&&settings.saveRemoteData){module.save.remoteData(selectedText,selectedValue)}if(!keepSearchTerm&&!$selected.hasClass(className.actionable)){module.set.text(selectedText,true)}module.set.value(selectedValue,selectedText,$selected,preventChangeTrigger);$selected.addClass(className.active).addClass(className.selected)}}));if(!keepSearchTerm){module.remove.searchTerm()}if(module.is.allFiltered()){module.set.empty();module.hideMenu()}}},add:{label:function(value,text,shouldAnimate){var $next=module.is.searchSelection()?$search:$text,escapedValue=module.escape.value(value),$label;if(settings.ignoreCase){escapedValue=escapedValue.toLowerCase()}$label=$("<a />").addClass(className.label).attr("data-"+metadata.value,escapedValue).html(templates.label(escapedValue,text,settings.preserveHTML,settings.className));$label=settings.onLabelCreate.call($label,escapedValue,text);if(module.has.label(value)){module.debug("User selection already exists, skipping",escapedValue);return}if(settings.label.variation){$label.addClass(settings.label.variation)}if(shouldAnimate===true){module.debug("Animating in label",$label);$label.addClass(className.hidden).insertBefore($next).transition({animation:settings.label.transition,debug:settings.debug,verbose:settings.verbose,silent:settings.silent,duration:settings.label.duration})}else{module.debug("Adding selection label",$label);$label.insertBefore($next)}},message:function(message){var $message=$menu.children(selector.message),html=settings.templates.message(module.add.variables(message));if($message.length>0){$message.html(html)}else{$("<div/>").html(html).addClass(className.message).appendTo($menu)}},optionValue:function(value){var escapedValue=module.escape.value(value),$option=$input.find('option[value="'+module.escape.string(escapedValue)+'"]'),hasOption=$option.length>0;if(hasOption){return}module.disconnect.selectObserver();if(module.is.single()){module.verbose("Removing previous user addition");$input.find("option."+className.addition).remove()}$("<option/>").prop("value",escapedValue).addClass(className.addition).text(value).appendTo($input);module.verbose("Adding user addition as an <option>",value);module.observe.select()},userSuggestion:function(value){var $addition=$menu.children(selector.addition),$existingItem=module.get.item(value),alreadyHasValue=$existingItem&&$existingItem.not(selector.addition).length,hasUserSuggestion=$addition.length>0,html;if(settings.useLabels&&module.has.maxSelections()){return}if(value===""||alreadyHasValue){$addition.remove();return}if(hasUserSuggestion){$addition.data(metadata.value,value).data(metadata.text,value).attr("data-"+metadata.value,value).attr("data-"+metadata.text,value).removeClass(className.filtered);if(!settings.hideAdditions){html=settings.templates.addition(module.add.variables(message.addResult,value));$addition.html(html)}module.verbose("Replacing user suggestion with new value",$addition)}else{$addition=module.create.userChoice(value);$addition.prependTo($menu);module.verbose("Adding item choice to menu corresponding with user choice addition",$addition)}if(!settings.hideAdditions||module.is.allFiltered()){$addition.addClass(className.selected).siblings().removeClass(className.selected)}module.refreshItems()},variables:function(message,term){var hasCount=message.search("{count}")!==-1,hasMaxCount=message.search("{maxCount}")!==-1,hasTerm=message.search("{term}")!==-1,query;module.verbose("Adding templated variables to message",message);if(hasCount){message=message.replace("{count}",module.get.selectionCount())}if(hasMaxCount){message=message.replace("{maxCount}",settings.maxSelections)}if(hasTerm){query=term||module.get.query();message=message.replace("{term}",query)}return message},value:function(addedValue,addedText,$selectedItem,preventChangeTrigger){if(typeof addedText==="boolean"){preventChangeTrigger=addedText;$selectedItem=undefined;addedText=undefined}var currentValue=module.get.values(true),newValue;if(module.has.value(addedValue)){module.debug("Value already selected");return}if(addedValue===""){module.debug("Cannot select blank values from multiselect");return}if(Array.isArray(currentValue)){newValue=$selectedItem&&$selectedItem.hasClass(className.actionable)?currentValue:currentValue.concat([addedValue]);newValue=module.get.uniqueArray(newValue)}else{newValue=[addedValue]}if(module.has.selectInput()){if(module.can.extendSelect()){module.debug("Adding value to select",addedValue,newValue,$input);module.add.optionValue(addedValue)}}else{newValue=newValue.join(settings.delimiter);module.debug("Setting hidden input to delimited value",newValue,$input)}if(settings.fireOnInit===false&&module.is.initialLoad()){module.verbose("Skipping onadd callback on initial load",settings.onAdd)}else{settings.onAdd.call(element,addedValue,addedText,$selectedItem)}module.set.value(newValue,addedText,$selectedItem,preventChangeTrigger);module.check.maxSelections()}},remove:{active:function(){$module.removeClass(className.active)},activeLabel:function(){$module.find(selector.label).removeClass(className.active)},empty:function(){$module.removeClass(className.empty)},loading:function(){$module.removeClass(className.loading)},initialLoad:function(){initialLoad=false},upward:function($currentMenu){var $element=$currentMenu||$module;$element.removeClass(className.upward)},leftward:function($currentMenu){var $element=$currentMenu||$menu;$element.removeClass(className.leftward)},visible:function(){$module.removeClass(className.visible)},activeItem:function(){$item.removeClass(className.active)},filteredItem:function(){if(settings.useLabels&&module.has.maxSelections()){return}if(settings.useLabels&&module.is.multiple()){$item.not("."+className.active).removeClass(className.filtered)}else{$item.removeClass(className.filtered)}if(settings.hideDividers){$divider.removeClass(className.hidden)}module.remove.empty()},optionValue:function(value){var escapedValue=module.escape.value(value),$option=$input.find('option[value="'+module.escape.string(escapedValue)+'"]'),hasOption=$option.length>0;if(!hasOption||!$option.hasClass(className.addition)){return}module.disconnect.selectObserver();$option.remove();module.verbose("Removing user addition as an <option>",escapedValue);module.observe.select()},message:function(){$menu.children(selector.message).remove()},searchWidth:function(){$search.css("width","")},searchTerm:function(){module.verbose("Cleared search term");$search.val("");module.set.filtered()},userAddition:function(){$item.filter(selector.addition).remove()},selected:function(value,$selectedItem,preventChangeTrigger){$selectedItem=settings.allowAdditions?$selectedItem||module.get.itemWithAdditions(value):$selectedItem||module.get.item(value);if(!$selectedItem){return false}$selectedItem.each((function(){var $selected=$(this),selectedText=module.get.choiceText($selected),selectedValue=module.get.choiceValue($selected,selectedText);if(module.is.multiple()){if(settings.useLabels){module.remove.value(selectedValue,selectedText,$selected,preventChangeTrigger);module.remove.label(selectedValue)}else{module.remove.value(selectedValue,selectedText,$selected,preventChangeTrigger);if(module.get.selectionCount()===0){module.set.placeholderText()}else{module.set.text(module.add.variables(message.count))}}}else{module.remove.value(selectedValue,selectedText,$selected,preventChangeTrigger)}$selected.removeClass(className.filtered).removeClass(className.active);if(settings.useLabels){$selected.removeClass(className.selected)}}))},selectedItem:function(){$item.removeClass(className.selected)},value:function(removedValue,removedText,$removedItem,preventChangeTrigger){var values=module.get.values(true),newValue;if(module.has.selectInput()){module.verbose("Input is <select> removing selected option",removedValue);newValue=module.remove.arrayValue(removedValue,values);module.remove.optionValue(removedValue)}else{module.verbose("Removing from delimited values",removedValue);newValue=module.remove.arrayValue(removedValue,values);newValue=newValue.join(settings.delimiter)}if(settings.fireOnInit===false&&module.is.initialLoad()){module.verbose("No callback on initial load",settings.onRemove)}else{settings.onRemove.call(element,removedValue,removedText,$removedItem)}module.set.value(newValue,removedText,$removedItem,preventChangeTrigger);module.check.maxSelections()},arrayValue:function(removedValue,values){if(!Array.isArray(values)){values=[values]}values=$.grep(values,(function(value){return removedValue!=value}));module.verbose("Removed value from delimited string",removedValue,values);return values},label:function(value,shouldAnimate){var escapedValue=module.escape.value(value),$labels=$module.find(selector.label),$removedLabel=$labels.filter("[data-"+metadata.value+'="'+module.escape.string(settings.ignoreCase?escapedValue.toLowerCase():escapedValue)+'"]');module.verbose("Removing label",$removedLabel);$removedLabel.remove()},activeLabels:function($activeLabels){$activeLabels=$activeLabels||$module.find(selector.label).filter("."+className.active);module.verbose("Removing active label selections",$activeLabels);module.remove.labels($activeLabels)},labels:function($labels,preventChangeTrigger){$labels=$labels||$module.find(selector.label);module.verbose("Removing labels",$labels);$labels.each((function(){var $label=$(this),value=$label.data(metadata.value),stringValue=value!==undefined?String(value):value,isUserValue=module.is.userValue(stringValue);if(settings.onLabelRemove.call($label,value)===false){module.debug("Label remove callback cancelled removal");return}module.remove.message();if(isUserValue){module.remove.value(stringValue,stringValue,module.get.item(stringValue),preventChangeTrigger);module.remove.label(stringValue)}else{module.remove.selected(stringValue,false,preventChangeTrigger)}}))},tabbable:function(){if(module.is.searchSelection()){module.debug("Searchable dropdown initialized");$search.removeAttr("tabindex");$menu.removeAttr("tabindex")}else{module.debug("Simple selection dropdown initialized");$module.removeAttr("tabindex");$menu.removeAttr("tabindex")}},diacritics:function(text){return settings.ignoreDiacritics?text.normalize("NFD").replace(/[\u0300-\u036f]/g,""):text}},has:{menuSearch:function(){return module.has.search()&&$search.closest($menu).length>0},clearItem:function(){return $clear.length>0},search:function(){return $search.length>0},sizer:function(){return $sizer.length>0},selectInput:function(){return $input.is("select")},minCharacters:function(searchTerm){if(settings.minCharacters&&!iconClicked){searchTerm=searchTerm!==undefined?String(searchTerm):String(module.get.query());return searchTerm.length>=settings.minCharacters}iconClicked=false;return true},firstLetter:function($item,letter){var text,firstLetter;if(!$item||$item.length===0||typeof letter!=="string"){return false}text=module.get.choiceText($item,false);letter=letter.toLowerCase();firstLetter=String(text).charAt(0).toLowerCase();return letter==firstLetter},input:function(){return $input.length>0},items:function(){return $item.length>0},menu:function(){return $menu.length>0},subMenu:function($currentMenu){return($currentMenu||$menu).find(selector.menu).length>0},message:function(){return $menu.children(selector.message).length!==0},label:function(value){var escapedValue=module.escape.value(value),$labels=$module.find(selector.label);if(settings.ignoreCase){escapedValue=escapedValue.toLowerCase()}return $labels.filter("[data-"+metadata.value+'="'+module.escape.string(escapedValue)+'"]').length>0},maxSelections:function(){return settings.maxSelections&&module.get.selectionCount()>=settings.maxSelections},allResultsFiltered:function(){var $normalResults=$item.not(selector.addition);return $normalResults.filter(selector.unselectable).length===$normalResults.length},userSuggestion:function(){return $menu.children(selector.addition).length>0},query:function(){return module.get.query()!==""},value:function(value){return settings.ignoreCase?module.has.valueIgnoringCase(value):module.has.valueMatchingCase(value)},valueMatchingCase:function(value){var values=module.get.values(true),hasValue=Array.isArray(values)?values&&$.inArray(value,values)!==-1:values==value;return hasValue?true:false},valueIgnoringCase:function(value){var values=module.get.values(true),hasValue=false;if(!Array.isArray(values)){values=[values]}$.each(values,(function(index,existingValue){if(String(value).toLowerCase()==String(existingValue).toLowerCase()){hasValue=true;return false}}));return hasValue}},is:{active:function(){return $module.hasClass(className.active)},animatingInward:function(){return $menu.transition("is inward")},animatingOutward:function(){return $menu.transition("is outward")},bubbledLabelClick:function(event){return $(event.target).is("select, input")&&$module.closest("label").length>0},bubbledIconClick:function(event){return $(event.target).closest($icon).length>0},edge:function(){return!!window.chrome&&!!window.StyleMedia},empty:function(){return $module.hasClass(className.empty)},chrome:function(){return!!window.chrome&&!window.StyleMedia},alreadySetup:function(){return $module.is("select")&&$module.parent(selector.dropdown).data(moduleNamespace)!==undefined&&$module.prev().length===0},animating:function($subMenu){return $subMenu?$subMenu.transition&&$subMenu.transition("is animating"):$menu.transition&&$menu.transition("is animating")},leftward:function($subMenu){var $selectedMenu=$subMenu||$menu;return $selectedMenu.hasClass(className.leftward)},clearable:function(){return $module.hasClass(className.clearable)||settings.clearable},disabled:function(){return $module.hasClass(className.disabled)},focused:function(){return document.activeElement===$module[0]},focusedOnSearch:function(){return document.activeElement===$search[0]},allFiltered:function(){return(module.is.multiple()||module.has.search())&&!(!settings.hideAdditions&&module.has.userSuggestion())&&!module.has.message()&&module.has.allResultsFiltered()},hidden:function($subMenu){return!module.is.visible($subMenu)},initialLoad:function(){return initialLoad},inObject:function(needle,object){var found=false;$.each(object,(function(index,property){if(property==needle){found=true;return true}}));return found},multiple:function(){return $module.hasClass(className.multiple)},remote:function(){return settings.apiSettings&&module.can.useAPI()},noApiCache:function(){return settings.apiSettings&&!settings.apiSettings.cache},single:function(){return!module.is.multiple()},selectMutation:function(mutations){var selectChanged=false;$.each(mutations,(function(index,mutation){if($(mutation.target).is("select, option, optgroup")||$(mutation.addedNodes).is("select")){selectChanged=true;return false}}));return selectChanged},search:function(){return $module.hasClass(className.search)},searchSelection:function(deep){return module.has.search()&&(deep?$search.parents(selector.dropdown):$search.parent(selector.dropdown)).length===1},selection:function(){return $module.hasClass(className.selection)},userValue:function(value){return $.inArray(value,module.get.userValues())!==-1},upward:function($menu){var $element=$menu||$module;return $element.hasClass(className.upward)},visible:function($subMenu){return $subMenu?$subMenu.hasClass(className.visible):$menu.hasClass(className.visible)},verticallyScrollableContext:function(){var overflowY=$context[0]!==window?$context.css("overflow-y"):false;return overflowY=="auto"||overflowY=="scroll"},horizontallyScrollableContext:function(){var overflowX=$context[0]!==window?$context.css("overflow-X"):false;return overflowX=="auto"||overflowX=="scroll"}},can:{activate:function($item){return settings.useLabels||!module.has.maxSelections()||module.has.maxSelections()&&$item.hasClass(className.active)},openDownward:function($subMenu){var $currentMenu=$subMenu||$menu,canOpenDownward,onScreen,calculations;$currentMenu.addClass(className.loading);calculations={context:{offset:$context[0]===window?{top:0,left:0}:$context.offset(),scrollTop:$context.scrollTop(),height:$context.outerHeight()},menu:{offset:$currentMenu.offset(),height:$currentMenu.outerHeight()}};if(module.is.verticallyScrollableContext()){calculations.menu.offset.top+=calculations.context.scrollTop}if(module.has.subMenu($currentMenu)){calculations.menu.height+=$currentMenu.find(selector.menu).first().outerHeight()}onScreen={above:calculations.context.scrollTop<=calculations.menu.offset.top-calculations.context.offset.top-calculations.menu.height,below:calculations.context.scrollTop+calculations.context.height>=calculations.menu.offset.top-calculations.context.offset.top+calculations.menu.height};if(onScreen.below){module.verbose("Dropdown can fit in context downward",onScreen);canOpenDownward=true}else if(!onScreen.below&&!onScreen.above){module.verbose("Dropdown cannot fit in either direction, favoring downward",onScreen);canOpenDownward=true}else{module.verbose("Dropdown cannot fit below, opening upward",onScreen);canOpenDownward=false}$currentMenu.removeClass(className.loading);return canOpenDownward},openRightward:function($subMenu){var $currentMenu=$subMenu||$menu,canOpenRightward=true,isOffscreenRight=false,calculations;$currentMenu.addClass(className.loading);calculations={context:{offset:$context[0]===window?{top:0,left:0}:$context.offset(),scrollLeft:$context.scrollLeft(),width:$context.outerWidth()},menu:{offset:$currentMenu.offset(),width:$currentMenu.outerWidth()}};if(module.is.horizontallyScrollableContext()){calculations.menu.offset.left+=calculations.context.scrollLeft}isOffscreenRight=calculations.menu.offset.left-calculations.context.offset.left+calculations.menu.width>=calculations.context.scrollLeft+calculations.context.width;if(isOffscreenRight){module.verbose("Dropdown cannot fit in context rightward",isOffscreenRight);canOpenRightward=false}$currentMenu.removeClass(className.loading);return canOpenRightward},extendSelect:function(){return settings.allowAdditions||settings.apiSettings},show:function(){return!module.is.disabled()&&(module.has.items()||module.has.message())},useAPI:function(){return $.fn.api!==undefined}},animate:{show:function(callback,$subMenu){var $currentMenu=$subMenu||$menu,start=$subMenu?function(){}:function(){module.hideSubMenus();module.hideOthers();module.set.active()},transition;callback=$.isFunction(callback)?callback:function(){};module.verbose("Doing menu show animation",$currentMenu);module.set.direction($subMenu);transition=settings.transition.showMethod||module.get.transition($subMenu);if(module.is.selection()){module.set.scrollPosition(module.get.selectedItem(),true)}if(module.is.hidden($currentMenu)||module.is.animating($currentMenu)){if(transition==="none"){start();$currentMenu.transition({displayType:module.get.displayType()}).transition("show");callback.call(element)}else if($.fn.transition!==undefined&&$module.transition("is supported")){$currentMenu.transition({animation:transition+" in",debug:settings.debug,verbose:settings.verbose,silent:settings.silent,duration:settings.transition.showDuration||settings.duration,queue:true,onStart:start,displayType:module.get.displayType(),onComplete:function(){callback.call(element)}})}else{module.error(error.noTransition,transition)}}},hide:function(callback,$subMenu){var $currentMenu=$subMenu||$menu,start=$subMenu?function(){}:function(){module.unbind.intent();module.remove.active()},transition=settings.transition.hideMethod||module.get.transition($subMenu);callback=$.isFunction(callback)?callback:function(){};if(module.is.visible($currentMenu)||module.is.animating($currentMenu)){module.verbose("Doing menu hide animation",$currentMenu);if(transition==="none"){start();$currentMenu.transition({displayType:module.get.displayType()}).transition("hide");callback.call(element)}else if($.fn.transition!==undefined&&$module.transition("is supported")){$currentMenu.transition({animation:transition+" out",duration:settings.transition.hideDuration||settings.duration,debug:settings.debug,verbose:settings.verbose,silent:settings.silent,queue:false,onStart:start,displayType:module.get.displayType(),onComplete:function(){callback.call(element)}})}else{module.error(error.transition)}}}},hideAndClear:function(){module.remove.searchTerm();if(module.has.maxSelections()){return}if(module.has.search()){module.hide((function(){module.remove.filteredItem()}))}else{module.hide()}},delay:{show:function(){module.verbose("Delaying show event to ensure user intent");clearTimeout(module.timer);module.timer=setTimeout(module.show,settings.delay.show)},hide:function(){module.verbose("Delaying hide event to ensure user intent");clearTimeout(module.timer);module.timer=setTimeout(module.hide,settings.delay.hide)}},escape:{value:function(value){var multipleValues=Array.isArray(value),stringValue=typeof value==="string",isUnparsable=!stringValue&&!multipleValues,hasQuotes=stringValue&&value.search(regExp.quote)!==-1,values=[];if(isUnparsable||!hasQuotes){return value}module.debug("Encoding quote values for use in select",value);if(multipleValues){$.each(value,(function(index,value){values.push(value.replace(regExp.quote,"&quot;"))}));return values}return value.replace(regExp.quote,"&quot;")},string:function(text){text=String(text);return text.replace(regExp.escape,"\\$&")},htmlEntities:function(string){var badChars=/[<>"'`]/g,shouldEscape=/[&<>"'`]/,escape={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},escapedChar=function(chr){return escape[chr]};if(shouldEscape.test(string)){string=string.replace(/&(?![a-z0-9#]{1,12};)/gi,"&amp;");return string.replace(badChars,escapedChar)}return string}},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{module.error(error.method,query);return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize()}}));return returnedValue!==undefined?returnedValue:$allModules};$.fn.dropdown.settings={silent:false,debug:false,verbose:false,performance:true,on:"click",action:"activate",values:false,clearable:false,apiSettings:false,selectOnKeydown:true,minCharacters:0,filterRemoteData:false,saveRemoteData:true,throttle:200,context:window,direction:"auto",keepOnScreen:true,match:"both",fullTextSearch:"exact",ignoreDiacritics:false,hideDividers:false,placeholder:"auto",preserveHTML:true,sortSelect:false,forceSelection:false,allowAdditions:false,ignoreCase:false,ignoreSearchCase:true,hideAdditions:true,maxSelections:false,useLabels:true,delimiter:",",showOnFocus:false,allowReselection:false,allowTab:true,allowCategorySelection:false,fireOnInit:false,transition:"auto",duration:200,displayType:false,glyphWidth:1.037,headerDivider:true,collapseOnActionable:true,label:{transition:"scale",duration:200,variation:false},delay:{hide:300,show:200,search:20},onChange:function(value,text,$selected){},onAdd:function(value,text,$selected){},onRemove:function(value,text,$selected){},onActionable:function(value,text,$selected){},onSearch:function(searchTerm){},onLabelSelect:function($selectedLabels){},onLabelCreate:function(value,text){return $(this)},onLabelRemove:function(value){return true},onNoResults:function(searchTerm){return true},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",message:{addResult:"Add <b>{term}</b>",count:"{count} selected",maxSelections:"Max {maxCount} selections",noResults:"No results found.",serverError:"There was an error contacting the server"},error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",labels:"Allowing user additions currently requires the use of labels.",missingMultiple:"<select> requires multiple property to be set to correctly preserve multiple values",method:"The method you called is not defined.",noAPI:"The API module is required to load resources remotely",noStorage:"Saving remote data requires session storage",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",noNormalize:'"ignoreDiacritics" setting will be ignored. Browser does not support String().normalize(). You may consider including <https://cdn.jsdelivr.net/npm/unorm@1.4.1/lib/unorm.min.js> as a polyfill.'},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s:=@]/g,quote:/"/g},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholder",text:"text",value:"value"},fields:{remoteValues:"results",values:"values",disabled:"disabled",name:"name",description:"description",descriptionVertical:"descriptionVertical",value:"value",text:"text",type:"type",image:"image",imageClass:"imageClass",icon:"icon",iconClass:"iconClass",class:"class",divider:"divider",actionable:"actionable"},keys:{backspace:8,deleteKey:46,enter:13,escape:27,pageUp:33,pageDown:34,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40},selector:{addition:".addition",divider:".divider, .header",dropdown:".ui.dropdown",hidden:".hidden",icon:"> .dropdown.icon",input:'> input[type="hidden"], > select',item:".item",label:"> .label",remove:"> .label > .delete.icon",siblingLabel:".label",menu:".menu",message:".message",menuIcon:".dropdown.icon",search:"input.search, .menu > .search > input, .menu input.search",sizer:"> span.sizer",text:"> .text:not(.icon)",unselectable:".disabled, .filtered",clearIcon:"> .remove.icon"},className:{active:"active",addition:"addition",animating:"animating",description:"description",descriptionVertical:"vertical",disabled:"disabled",empty:"empty",dropdown:"ui dropdown",filtered:"filtered",hidden:"hidden transition",icon:"icon",image:"image",item:"item",label:"ui label",loading:"loading",menu:"menu",message:"message",multiple:"multiple",placeholder:"default",sizer:"sizer",search:"search",selected:"selected",selection:"selection",text:"text",upward:"upward",leftward:"left",visible:"visible",clearable:"clearable",noselection:"noselection",delete:"delete",header:"header",divider:"divider",groupIcon:"",unfilterable:"unfilterable",actionable:"actionable"}};$.fn.dropdown.settings.templates={deQuote:function(string,encode){return String(string).replace(/"/g,encode?"&quot;":"")},escape:function(string,preserveHTML){if(preserveHTML){return string}var badChars=/[<>"'`]/g,shouldEscape=/[&<>"'`]/,escape={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},escapedChar=function(chr){return escape[chr]};if(shouldEscape.test(string)){string=string.replace(/&(?![a-z0-9#]{1,12};)/gi,"&amp;");return string.replace(badChars,escapedChar)}return string},dropdown:function(select,fields,preserveHTML,className){var placeholder=select.placeholder||false,html="",escape=$.fn.dropdown.settings.templates.escape,deQuote=$.fn.dropdown.settings.templates.deQuote;html+='<i class="dropdown icon"></i>';if(placeholder){html+='<div class="default text">'+escape(placeholder,preserveHTML)+"</div>"}else{html+='<div class="text"></div>'}html+='<div class="'+deQuote(className.menu)+'">';html+=$.fn.dropdown.settings.templates.menu(select,fields,preserveHTML,className);html+="</div>";return html},menu:function(response,fields,preserveHTML,className){var values=response[fields.values]||[],html="",escape=$.fn.dropdown.settings.templates.escape,deQuote=$.fn.dropdown.settings.templates.deQuote;$.each(values,(function(index,option){var itemType=option[fields.type]?option[fields.type]:"item",isMenu=itemType.indexOf("menu")!==-1;if(itemType==="item"||isMenu){var maybeText=option[fields.text]?' data-text="'+deQuote(option[fields.text],true)+'"':"",maybeActionable=option[fields.actionable]?className.actionable+" ":"",maybeDisabled=option[fields.disabled]?className.disabled+" ":"",maybeDescriptionVertical=option[fields.descriptionVertical]?className.descriptionVertical+" ":"",hasDescription=escape(option[fields.description]||"",preserveHTML)!="";html+='<div class="'+deQuote(maybeActionable+maybeDisabled+maybeDescriptionVertical+(option[fields.class]?option[fields.class]:className.item))+'" data-value="'+deQuote(option[fields.value],true)+'"'+maybeText+">";if(isMenu){html+='<i class="'+(itemType.indexOf("left")!==-1?"left":"")+' dropdown icon"></i>'}if(option[fields.image]){html+='<img class="'+deQuote(option[fields.imageClass]?option[fields.imageClass]:className.image)+'" src="'+deQuote(option[fields.image])+'">'}if(option[fields.icon]){html+='<i class="'+deQuote(option[fields.icon]+" "+(option[fields.iconClass]?option[fields.iconClass]:className.icon))+'"></i>'}if(hasDescription){html+='<span class="'+deQuote(className.description)+'">'+escape(option[fields.description]||"",preserveHTML)+"</span>";html+=!isMenu?'<span class="'+deQuote(className.text)+'">':""}if(isMenu){html+='<span class="'+deQuote(className.text)+'">'}html+=escape(option[fields.name]||"",preserveHTML);if(isMenu){html+="</span>";html+='<div class="'+deQuote(itemType)+'">';html+=$.fn.dropdown.settings.templates.menu(option,fields,preserveHTML,className);html+="</div>"}else if(hasDescription){html+="</span>"}html+="</div>"}else if(itemType==="header"){var groupName=escape(option[fields.name]||"",preserveHTML),groupIcon=deQuote(option[fields.icon]?option[fields.icon]:className.groupIcon);if(groupName!==""||groupIcon!==""){html+='<div class="'+deQuote(option[fields.class]?option[fields.class]:className.header)+'">';if(groupIcon!==""){html+='<i class="'+deQuote(groupIcon+" "+(option[fields.iconClass]?option[fields.iconClass]:className.icon))+'"></i>'}html+=groupName;html+="</div>"}if(option[fields.divider]){html+='<div class="'+deQuote(className.divider)+'"></div>'}}}));return html},label:function(value,text,preserveHTML,className){var escape=$.fn.dropdown.settings.templates.escape,deQuote=$.fn.dropdown.settings.templates.deQuote;return escape(text,preserveHTML)+'<i class="'+deQuote(className.delete)+' icon"></i>'},message:function(message){return message},addition:function(choice){return choice}}})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Modal
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.modal=$.fn.modal=function(parameters){var $allModules=$(this),$window=$(window),$document=$(document),$body=$("body"),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){setTimeout(callback,0)},returnedValue;$allModules.each((function(){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.modal.settings,parameters):$.extend({},$.fn.modal.settings),selector=settings.selector,className=settings.className,namespace=settings.namespace,fields=settings.fields,error=settings.error,eventNamespace="."+namespace,moduleNamespace="module-"+namespace,$module=$(this),$context=[window,document].indexOf(settings.context)<0?$document.find(settings.context):$body,isBody=$context[0]===$body[0],$closeIcon=$module.find(selector.closeIcon),$inputs,$allModals,$otherModals,$focusedElement,$dimmable,$dimmer,isModalComponent=$module.hasClass("modal"),element=this,instance=isModalComponent?$module.data(moduleNamespace):undefined,ignoreRepeatedEvents=false,initialMouseDownInModal,initialMouseDownInScrollbar,initialBodyMargin="",tempBodyMargin="",keepScrollingClass=false,hadScrollbar=false,elementEventNamespace,id,observer,module;module={initialize:function(){module.create.id();if(!isModalComponent){module.create.modal();if(!$.isFunction(settings.onHidden)){settings.onHidden=function(){module.destroy();$module.remove()}}}$module.addClass(settings.class);if(settings.title!==""){$module.find(selector.title).html(module.helpers.escape(settings.title,settings.preserveHTML)).addClass(settings.classTitle)}if(settings.content!==""){$module.find(selector.content).html(module.helpers.escape(settings.content,settings.preserveHTML)).addClass(settings.classContent)}if(module.has.configActions()){var $actions=$module.find(selector.actions).addClass(settings.classActions);if($actions.length===0){$actions=$("<div/>",{class:className.actions+" "+(settings.classActions||"")}).appendTo($module)}else{$actions.empty()}settings.actions.forEach((function(el){var icon=el[fields.icon]?"<i "+(el[fields.text]?'aria-hidden="true"':"")+' class="'+module.helpers.deQuote(el[fields.icon])+' icon"></i>':"",text=module.helpers.escape(el[fields.text]||"",settings.preserveHTML),cls=module.helpers.deQuote(el[fields.class]||""),click=el[fields.click]&&$.isFunction(el[fields.click])?el[fields.click]:function(){};$actions.append($("<button/>",{html:icon+text,"aria-label":(el[fields.text]||el[fields.icon]||"").replace(/<[^>]+(>|$)/g,""),class:className.button+" "+cls,click:function(){var button=$(this);if(button.is(selector.approve)||button.is(selector.deny)||click.call(element,$module)===false){return}module.hide()}}))}))}module.cache={};module.verbose("Initializing dimmer",$context);module.create.dimmer();if(settings.allowMultiple){module.create.innerDimmer()}if(!settings.centered){$module.addClass("top aligned")}module.refreshModals();module.bind.events();module.observeChanges();module.instantiate();if(settings.autoShow){module.show()}},instantiate:function(){module.verbose("Storing instance of modal");instance=module;$module.data(moduleNamespace,instance)},create:{modal:function(){$module=$("<div/>",{class:className.modal,role:"dialog","aria-modal":true});if(settings.closeIcon){$closeIcon=$("<i/>",{class:className.close,role:"button",tabindex:0,"aria-label":settings.text.close});$module.append($closeIcon)}if(settings.title!==""){var titleId="_"+module.get.id()+"title";$module.attr("aria-labelledby",titleId);$("<div/>",{class:className.title,id:titleId}).appendTo($module)}if(settings.content!==""){var descId="_"+module.get.id()+"desc";$module.attr("aria-describedby",descId);$("<div/>",{class:className.content,id:descId}).appendTo($module)}if(module.has.configActions()){$("<div/>",{class:className.actions}).appendTo($module)}$context.append($module);element=$module[0]},dimmer:function(){var defaultSettings={debug:settings.debug,dimmerName:"modals"},dimmerSettings=$.extend(true,defaultSettings,settings.dimmerSettings);if($.fn.dimmer===undefined){module.error(error.dimmer);return}module.debug("Creating dimmer");$dimmable=$context.dimmer(dimmerSettings);keepScrollingClass=module.is.scrolling();if(settings.detachable){module.verbose("Modal is detachable, moving content into dimmer");$dimmable.dimmer("add content",$module)}else{module.set.undetached()}$dimmer=$dimmable.dimmer("get dimmer")},id:function(){id=(Math.random().toString(16)+"000000000").slice(2,10);elementEventNamespace="."+id;module.verbose("Creating unique id for element",id)},innerDimmer:function(){if($module.find(selector.dimmer).length===0){$("<div/>",{class:className.innerDimmer}).prependTo($module)}}},destroy:function(){if(observer){observer.disconnect()}module.verbose("Destroying previous modal");$module.removeData(moduleNamespace).off(eventNamespace);$window.off(elementEventNamespace);$dimmer.off(elementEventNamespace);$closeIcon.off(elementEventNamespace);if($inputs){$inputs.off(elementEventNamespace)}$context.dimmer("destroy")},observeChanges:function(){if("MutationObserver"in window){observer=new MutationObserver((function(mutations){if(settings.observeChanges){module.debug("DOM tree modified, refreshing");module.refresh()}module.refreshInputs()}));observer.observe(element,{childList:true,subtree:true});module.debug("Setting up mutation observer",observer)}},refresh:function(){module.remove.scrolling();module.cacheSizes();if(!module.can.useFlex()){module.set.modalOffset()}module.set.screenHeight();module.set.type()},refreshModals:function(){$otherModals=$module.siblings(selector.modal);$allModals=$otherModals.add($module)},refreshInputs:function(){if($inputs){$inputs.off("keydown"+elementEventNamespace)}$inputs=$module.find("[tabindex], :input").filter(":visible").filter((function(){return $(this).closest(".disabled").length===0}));$inputs.first().on("keydown"+elementEventNamespace,module.event.inputKeyDown.first);$inputs.last().on("keydown"+elementEventNamespace,module.event.inputKeyDown.last)},attachEvents:function(selector,event){var $toggle=$(selector);event=$.isFunction(module[event])?module[event]:module.toggle;if($toggle.length>0){module.debug("Attaching modal events to element",selector,event);$toggle.off(eventNamespace).on("click"+eventNamespace,event)}else{module.error(error.notFound,selector)}},bind:{events:function(){module.verbose("Attaching events");$module.on("click"+eventNamespace,selector.close,module.event.close).on("click"+eventNamespace,selector.approve,module.event.approve).on("click"+eventNamespace,selector.deny,module.event.deny);$closeIcon.on("keyup"+elementEventNamespace,module.event.closeKeyUp);$window.on("resize"+elementEventNamespace,module.event.resize)},scrollLock:function(){$dimmable[0].addEventListener("touchmove",module.event.preventScroll,{passive:false})}},unbind:{scrollLock:function(){$dimmable[0].removeEventListener("touchmove",module.event.preventScroll,{passive:false})}},get:{id:function(){return id},element:function(){return $module},settings:function(){return settings}},event:{approve:function(){if(ignoreRepeatedEvents||settings.onApprove.call(element,$(this))===false){module.verbose("Approve callback returned false cancelling hide");return}ignoreRepeatedEvents=true;module.hide((function(){ignoreRepeatedEvents=false}))},preventScroll:function(event){if(event.target.className.indexOf("dimmer")!==-1){event.preventDefault()}},deny:function(){if(ignoreRepeatedEvents||settings.onDeny.call(element,$(this))===false){module.verbose("Deny callback returned false cancelling hide");return}ignoreRepeatedEvents=true;module.hide((function(){ignoreRepeatedEvents=false}))},close:function(){module.hide()},closeKeyUp:function(event){var keyCode=event.which;if((keyCode===settings.keys.enter||keyCode===settings.keys.space)&&$module.hasClass(className.front)){module.hide()}},inputKeyDown:{first:function(event){var keyCode=event.which;if(keyCode===settings.keys.tab&&event.shiftKey){$inputs.last().focus();event.preventDefault()}},last:function(event){var keyCode=event.which;if(keyCode===settings.keys.tab&&!event.shiftKey){$inputs.first().focus();event.preventDefault()}}},mousedown:function(event){var $target=$(event.target),isRtl=module.is.rtl();initialMouseDownInModal=$target.closest(selector.modal).length>0;if(initialMouseDownInModal){module.verbose("Mouse down event registered inside the modal")}initialMouseDownInScrollbar=module.is.scrolling()&&(!isRtl&&$window.outerWidth()-settings.scrollbarWidth<=event.clientX||isRtl&&settings.scrollbarWidth>=event.clientX);if(initialMouseDownInScrollbar){module.verbose("Mouse down event registered inside the scrollbar")}},mouseup:function(event){if(!settings.closable){module.verbose("Dimmer clicked but closable setting is disabled");return}if(initialMouseDownInModal){module.debug("Dimmer clicked but mouse down was initially registered inside the modal");return}if(initialMouseDownInScrollbar){module.debug("Dimmer clicked but mouse down was initially registered inside the scrollbar");return}var $target=$(event.target),isInModal=$target.closest(selector.modal).length>0,isInDOM=$.contains(document.documentElement,event.target);if(!isInModal&&isInDOM&&module.is.active()&&$module.hasClass(className.front)){module.debug("Dimmer clicked, hiding all modals");if(settings.allowMultiple){if(!module.hideAll()){return}}else if(!module.hide()){return}module.remove.clickaway()}},debounce:function(method,delay){clearTimeout(module.timer);module.timer=setTimeout(method,delay)},keyboard:function(event){var keyCode=event.which;if(keyCode===settings.keys.escape){if(settings.closable){module.debug("Escape key pressed hiding modal");if($module.hasClass(className.front)){module.hide()}}else{module.debug("Escape key pressed, but closable is set to false")}event.preventDefault()}},resize:function(){if($dimmable.dimmer("is active")&&(module.is.animating()||module.is.active())){requestAnimationFrame(module.refresh)}}},toggle:function(){if(module.is.active()||module.is.animating()){module.hide()}else{module.show()}},show:function(callback){callback=$.isFunction(callback)?callback:function(){};module.refreshModals();module.set.dimmerSettings();module.set.dimmerStyles();module.showModal(callback)},hide:function(callback){callback=$.isFunction(callback)?callback:function(){};module.refreshModals();return module.hideModal(callback)},showModal:function(callback){callback=$.isFunction(callback)?callback:function(){};if(module.is.animating()||!module.is.active()){if(settings.onShow.call(element)===false){module.verbose("Show callback returned false cancelling show");return}hadScrollbar=module.has.scrollbar();module.showDimmer();module.cacheSizes();if(hadScrollbar){module.set.bodyMargin()}if(module.can.useFlex()){module.remove.legacy()}else{module.set.legacy();module.set.modalOffset();module.debug("Using non-flex legacy modal positioning.")}module.set.screenHeight();module.set.type();module.set.clickaway();if(!settings.allowMultiple&&module.others.active()){module.hideOthers(module.showModal)}else{ignoreRepeatedEvents=false;if(settings.allowMultiple){if(module.others.active()){$otherModals.filter("."+className.active).find(selector.dimmer).addClass("active")}if(settings.detachable){$module.detach().appendTo($dimmer)}}if(settings.transition&&$.fn.transition!==undefined&&$module.transition("is supported")){module.debug("Showing modal with css animations");$module.transition({debug:settings.debug,verbose:settings.verbose,silent:settings.silent,animation:(settings.transition.showMethod||settings.transition)+" in",queue:settings.queue,duration:settings.transition.showDuration||settings.duration,useFailSafe:true,onComplete:function(){settings.onVisible.apply(element);if(settings.keyboardShortcuts){module.add.keyboardShortcuts()}module.save.focus();module.set.active();module.refreshInputs();if(settings.autofocus){module.set.autofocus()}callback()}})}else{module.error(error.noTransition)}}}else{module.debug("Modal is already visible")}},hideModal:function(callback,keepDimmed,hideOthersToo){var $previousModal=$otherModals.filter("."+className.active).last();callback=$.isFunction(callback)?callback:function(){};if(settings.onHide.call(element,$(this))===false){module.verbose("Hide callback returned false cancelling hide");ignoreRepeatedEvents=false;return false}if(module.is.animating()||module.is.active()){module.debug("Hiding modal");if(settings.transition&&$.fn.transition!==undefined&&$module.transition("is supported")){module.remove.active();$module.transition({debug:settings.debug,verbose:settings.verbose,silent:settings.silent,animation:(settings.transition.hideMethod||settings.transition)+" out",queue:settings.queue,duration:settings.transition.hideDuration||settings.duration,useFailSafe:true,onStart:function(){if(!module.others.active()&&!module.others.animating()&&!keepDimmed){module.hideDimmer()}if(settings.keyboardShortcuts&&!module.others.active()){module.remove.keyboardShortcuts()}},onComplete:function(){module.unbind.scrollLock();if(settings.allowMultiple){$previousModal.addClass(className.front);$module.removeClass(className.front);if(hideOthersToo){$allModals.find(selector.dimmer).removeClass("active")}else{$previousModal.find(selector.dimmer).removeClass("active")}}if($.isFunction(settings.onHidden)){settings.onHidden.call(element)}module.remove.dimmerStyles();module.restore.focus();callback()}})}else{module.error(error.noTransition)}}},showDimmer:function(){if($dimmable.dimmer("is animating")||!$dimmable.dimmer("is active")){if(hadScrollbar){if(!isBody){$dimmer.css("top",$dimmable.scrollTop())}module.save.bodyMargin()}module.debug("Showing dimmer");$dimmable.dimmer("show")}else{module.debug("Dimmer already visible")}},hideDimmer:function(){if($dimmable.dimmer("is animating")||$dimmable.dimmer("is active")){module.unbind.scrollLock();$dimmable.dimmer("hide",(function(){if(hadScrollbar){module.restore.bodyMargin()}module.remove.clickaway();module.remove.screenHeight()}))}else{module.debug("Dimmer is not visible cannot hide")}},hideAll:function(callback){var $visibleModals=$allModals.filter("."+className.active+", ."+className.animating);callback=$.isFunction(callback)?callback:function(){};if($visibleModals.length>0){module.debug("Hiding all visible modals");var hideOk=true;$($visibleModals.get().reverse()).each((function(index,element){if(hideOk){hideOk=$(element).modal("hide modal",callback,false,true)}}));if(hideOk){module.hideDimmer()}return hideOk}},hideOthers:function(callback){var $visibleModals=$otherModals.filter("."+className.active+", ."+className.animating);callback=$.isFunction(callback)?callback:function(){};if($visibleModals.length>0){module.debug("Hiding other modals",$otherModals);$visibleModals.modal("hide modal",callback,true)}},others:{active:function(){return $otherModals.filter("."+className.active).length>0},animating:function(){return $otherModals.filter("."+className.animating).length>0}},add:{keyboardShortcuts:function(){module.verbose("Adding keyboard shortcuts");$document.on("keydown"+eventNamespace,module.event.keyboard)}},save:{focus:function(){var $activeElement=$(document.activeElement),inCurrentModal=$activeElement.closest($module).length>0;if(!inCurrentModal){$focusedElement=$(document.activeElement).blur()}},bodyMargin:function(){initialBodyMargin=$context.css((isBody?"margin-":"padding-")+(module.can.leftBodyScrollbar()?"left":"right"));var bodyMarginRightPixel=parseInt(initialBodyMargin.replace(/[^\d.]/g,"")),bodyScrollbarWidth=isBody?window.innerWidth-document.documentElement.clientWidth:$context[0].offsetWidth-$context[0].clientWidth;tempBodyMargin=bodyMarginRightPixel+bodyScrollbarWidth}},restore:{focus:function(){if($focusedElement&&$focusedElement.length>0&&settings.restoreFocus){$focusedElement.focus()}},bodyMargin:function(){var position=module.can.leftBodyScrollbar()?"left":"right";$context.css((isBody?"margin-":"padding-")+position,initialBodyMargin);$context.find(selector.bodyFixed.replace("right",position)).each((function(){var el=$(this),attribute=el.css("position")==="fixed"?"padding-"+position:position;el.css(attribute,"")}))}},remove:{active:function(){$module.removeClass(className.active)},legacy:function(){$module.removeClass(className.legacy)},clickaway:function(){if(!settings.detachable){$module.off("mousedown"+elementEventNamespace)}$dimmer.off("mousedown"+elementEventNamespace);$dimmer.off("mouseup"+elementEventNamespace)},dimmerStyles:function(){$dimmer.removeClass(className.inverted);$dimmable.removeClass(className.blurring)},bodyStyle:function(){if($context.attr("style")===""){module.verbose("Removing style attribute");$context.removeAttr("style")}},screenHeight:function(){module.debug("Removing page height");$context.css("height","");module.remove.bodyStyle()},keyboardShortcuts:function(){module.verbose("Removing keyboard shortcuts");$document.off("keydown"+eventNamespace)},scrolling:function(){if(!keepScrollingClass){$dimmable.removeClass(className.scrolling)}$module.removeClass(className.scrolling)}},cacheSizes:function(){$module.addClass(className.loading);var scrollHeight=$module.prop("scrollHeight"),modalWidth=$module.outerWidth(),modalHeight=$module.outerHeight();if(module.cache.pageHeight===undefined||modalHeight!==0){$.extend(module.cache,{pageHeight:$document.outerHeight(),width:modalWidth,height:modalHeight+settings.offset,scrollHeight:scrollHeight+settings.offset,contextHeight:isBody?$window.height():$dimmable.height()});module.cache.topOffset=-(module.cache.height/2)}$module.removeClass(className.loading);module.debug("Caching modal and container sizes",module.cache)},helpers:{deQuote:function(string){return String(string).replace(/"/g,"")},escape:function(string,preserveHTML){if(preserveHTML){return string}var badChars=/[<>"'`]/g,shouldEscape=/[&<>"'`]/,escape={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},escapedChar=function(chr){return escape[chr]};if(shouldEscape.test(string)){string=string.replace(/&(?![a-z0-9#]{1,12};)/gi,"&amp;");return string.replace(badChars,escapedChar)}return string}},can:{leftBodyScrollbar:function(){if(module.cache.leftBodyScrollbar===undefined){module.cache.leftBodyScrollbar=module.is.rtl()&&(module.is.iframe&&!module.is.firefox()||module.is.safari()||module.is.edge()||module.is.ie())}return module.cache.leftBodyScrollbar},useFlex:function(){if(settings.useFlex==="auto"){return settings.detachable&&!module.is.ie()}if(settings.useFlex&&module.is.ie()){module.debug("useFlex true is not supported in IE")}else if(settings.useFlex&&!settings.detachable){module.debug("useFlex true in combination with detachable false is not supported")}return settings.useFlex},fit:function(){var contextHeight=module.cache.contextHeight,verticalCenter=module.cache.contextHeight/2,topOffset=module.cache.topOffset,scrollHeight=module.cache.scrollHeight,height=module.cache.height,paddingHeight=settings.padding,startPosition=verticalCenter+topOffset;return scrollHeight>height?startPosition+scrollHeight+paddingHeight<contextHeight:height+paddingHeight*2<contextHeight}},has:{configActions:function(){return Array.isArray(settings.actions)&&settings.actions.length>0},scrollbar:function(){return isBody||$context.css("overflow-y")!=="hidden"}},is:{active:function(){return $module.hasClass(className.active)},ie:function(){if(module.cache.isIE===undefined){var isIE11=!window.ActiveXObject&&"ActiveXObject"in window,isIE="ActiveXObject"in window;module.cache.isIE=isIE11||isIE}return module.cache.isIE},animating:function(){return $module.transition("is supported")?$module.transition("is animating"):$module.is(":visible")},scrolling:function(){return $dimmable.hasClass(className.scrolling)},modernBrowser:function(){return!(window.ActiveXObject||"ActiveXObject"in window)},rtl:function(){if(module.cache.isRTL===undefined){module.cache.isRTL=$module.attr("dir")==="rtl"||$module.css("direction")==="rtl"||$body.attr("dir")==="rtl"||$body.css("direction")==="rtl"||$context.attr("dir")==="rtl"||$context.css("direction")==="rtl"}return module.cache.isRTL},safari:function(){if(module.cache.isSafari===undefined){module.cache.isSafari=/constructor/i.test(window.HTMLElement)||!!window.ApplePaySession}return module.cache.isSafari},edge:function(){if(module.cache.isEdge===undefined){module.cache.isEdge=!!window.setImmediate&&!module.is.ie()}return module.cache.isEdge},firefox:function(){if(module.cache.isFirefox===undefined){module.cache.isFirefox=!!window.InstallTrigger}return module.cache.isFirefox},iframe:function(){return!(self===top)}},set:{autofocus:function(){var $autofocus=$inputs.filter("[autofocus]"),$input=$autofocus.length>0?$autofocus.first():($inputs.length>1?$inputs.filter(":not(i.close)"):$inputs).first();if($input.length>0){$input.focus()}},bodyMargin:function(){var position=module.can.leftBodyScrollbar()?"left":"right";if(settings.detachable||module.can.fit()){$context.css((isBody?"margin-":"padding-")+position,tempBodyMargin+"px")}$context.find(selector.bodyFixed.replace("right",position)).each((function(){var el=$(this),attribute=el.css("position")==="fixed"?"padding-"+position:position;el.css(attribute,"calc("+el.css(attribute)+" + "+tempBodyMargin+"px)")}))},clickaway:function(){if(!settings.detachable){$module.on("mousedown"+elementEventNamespace,module.event.mousedown)}$dimmer.on("mousedown"+elementEventNamespace,module.event.mousedown);$dimmer.on("mouseup"+elementEventNamespace,module.event.mouseup)},dimmerSettings:function(){if($.fn.dimmer===undefined){module.error(error.dimmer);return}var defaultSettings={debug:settings.debug,dimmerName:"modals",closable:"auto",useFlex:module.can.useFlex(),duration:{show:settings.transition.showDuration||settings.duration,hide:settings.transition.hideDuration||settings.duration}},dimmerSettings=$.extend(true,defaultSettings,settings.dimmerSettings);if(settings.inverted){dimmerSettings.variation=dimmerSettings.variation!==undefined?dimmerSettings.variation+" inverted":"inverted"}$context.dimmer("setting",dimmerSettings)},dimmerStyles:function(){if(settings.inverted){$dimmer.addClass(className.inverted)}else{$dimmer.removeClass(className.inverted)}if(settings.blurring){$dimmable.addClass(className.blurring)}else{$dimmable.removeClass(className.blurring)}},modalOffset:function(){if(!settings.detachable){var canFit=module.can.fit();$module.css({top:!$module.hasClass("aligned")&&canFit?$document.scrollTop()+(module.cache.contextHeight-module.cache.height)/2:!canFit||$module.hasClass("top")?$document.scrollTop()+settings.padding:$document.scrollTop()+(module.cache.contextHeight-module.cache.height-settings.padding),marginLeft:-(module.cache.width/2)})}else{$module.css({marginTop:!$module.hasClass("aligned")&&module.can.fit()?-(module.cache.height/2):settings.padding/2,marginLeft:-(module.cache.width/2)})}module.verbose("Setting modal offset for legacy mode")},screenHeight:function(){if(module.can.fit()){$context.css("height","")}else if(!$module.hasClass("bottom")){module.debug("Modal is taller than page content, resizing page height");$context.css("height",module.cache.height+settings.padding*2)}},active:function(){$module.addClass(className.active+" "+className.front);$otherModals.filter("."+className.active).removeClass(className.front)},scrolling:function(){$dimmable.addClass(className.scrolling);$module.addClass(className.scrolling);module.unbind.scrollLock()},legacy:function(){$module.addClass(className.legacy)},type:function(){if(module.can.fit()){module.verbose("Modal fits on screen");if(!module.others.active()&&!module.others.animating()){module.remove.scrolling();module.bind.scrollLock()}}else if(!$module.hasClass("bottom")){module.verbose("Modal cannot fit on screen setting to scrolling");module.set.scrolling()}else{module.verbose("Bottom aligned modal not fitting on screen is unsupported for scrolling")}},undetached:function(){$dimmable.addClass(className.undetached)}},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){if($.isFunction(settings.templates[query])){settings.autoShow=true;settings.className.modal=settings.className.template;settings=$.extend(true,{},settings,settings.templates[query].apply(module,queryArguments));className=settings.className;namespace=settings.namespace;fields=settings.fields;error=settings.error}module.initialize()}if(!$.isFunction(settings.templates[query])){module.invoke(query)}}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize();returnedValue=$module}}));return returnedValue!==undefined?returnedValue:this};$.fn.modal.settings={name:"Modal",namespace:"modal",useFlex:"auto",offset:0,silent:false,debug:false,verbose:false,performance:true,observeChanges:false,allowMultiple:false,detachable:true,closable:true,autofocus:true,restoreFocus:true,autoShow:false,inverted:false,blurring:false,centered:true,dimmerSettings:{closable:false,useCSS:true},keyboardShortcuts:true,context:"body",queue:false,duration:500,transition:"scale",padding:50,scrollbarWidth:10,title:"",content:"",class:"",classTitle:"",classContent:"",classActions:"",closeIcon:false,actions:false,preserveHTML:true,fields:{class:"class",text:"text",icon:"icon",click:"click"},onShow:function(){},onVisible:function(){},onHide:function(){return true},onHidden:false,onApprove:function(){return true},onDeny:function(){return true},keys:{space:32,enter:13,escape:27,tab:9},selector:{title:"> .header",content:"> .content",actions:"> .actions",close:"> .close",closeIcon:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal",dimmer:"> .ui.dimmer",bodyFixed:"> .ui.fixed.menu, > .ui.right.toast-container, > .ui.right.sidebar, > .ui.fixed.nag, > .ui.fixed.nag > .close",prompt:".ui.input > input"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",inverted:"inverted",legacy:"legacy",loading:"loading",scrolling:"scrolling",undetached:"undetached",front:"front",close:"close icon",button:"ui button",modal:"ui modal",title:"header",content:"content",actions:"actions",template:"ui tiny modal",ok:"positive",cancel:"negative",prompt:"ui fluid input",innerDimmer:"ui inverted dimmer"},text:{ok:"Ok",cancel:"Cancel",close:"Close"}};$.fn.modal.settings.templates={getArguments:function(args){var queryArguments=[].slice.call(args);if($.isPlainObject(queryArguments[0])){return $.extend({handler:function(){},content:"",title:""},queryArguments[0])}else{if(!$.isFunction(queryArguments[queryArguments.length-1])){queryArguments.push((function(){}))}return{handler:queryArguments.pop(),content:queryArguments.pop()||"",title:queryArguments.pop()||""}}},alert:function(){var settings=this.get.settings(),args=settings.templates.getArguments(arguments),approveFn=args.handler;return{title:args.title,content:args.content,onApprove:approveFn,actions:[{text:settings.text.ok,class:settings.className.ok,click:approveFn}]}},confirm:function(){var settings=this.get.settings(),args=settings.templates.getArguments(arguments),approveFn=function(){args.handler(true)},denyFn=function(){args.handler(false)};return{title:args.title,content:args.content,onApprove:approveFn,onDeny:denyFn,actions:[{text:settings.text.ok,class:settings.className.ok,click:approveFn},{text:settings.text.cancel,class:settings.className.cancel,click:denyFn}]}},prompt:function(){var $this=this,settings=this.get.settings(),args=settings.templates.getArguments(arguments),input=$($.parseHTML(args.content)).filter(".ui.input"),approveFn=function(){var settings=$this.get.settings(),inputField=$this.get.element().find(settings.selector.prompt)[0];args.handler($(inputField).val())},denyFn=function(){args.handler(null)};if(input.length===0){args.content+='<p><div class="'+this.helpers.deQuote(settings.className.prompt)+'"><input placeholder="'+this.helpers.deQuote(args.placeholder||"")+'" type="text" value="'+this.helpers.deQuote(args.defaultValue||"")+'"></div></p>'}return{title:args.title,content:args.content,onApprove:approveFn,onDeny:denyFn,actions:[{text:settings.text.ok,class:settings.className.ok,click:approveFn},{text:settings.text.cancel,class:settings.className.cancel,click:denyFn}]}}}})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Nag
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.nag=function(parameters){var $allModules=$(this),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),returnedValue;$allModules.each((function(){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.nag.settings,parameters):$.extend({},$.fn.nag.settings),selector=settings.selector,error=settings.error,namespace=settings.namespace,eventNamespace="."+namespace,moduleNamespace=namespace+"-module",$module=$(this),$context=settings.context?[window,document].indexOf(settings.context)<0?$(document).find(settings.context):$(settings.context):$("body"),element=this,instance=$module.data(moduleNamespace),storage,module;module={initialize:function(){module.verbose("Initializing element");storage=module.get.storage();$module.on("click"+eventNamespace,selector.close,module.dismiss).data(moduleNamespace,module);if(settings.detachable&&$module.parent()[0]!==$context[0]){$module.detach().prependTo($context)}if(settings.displayTime>0){setTimeout(module.hide,settings.displayTime)}module.show()},destroy:function(){module.verbose("Destroying instance");$module.removeData(moduleNamespace).off(eventNamespace)},show:function(){if(module.should.show()&&!$module.is(":visible")){if(settings.onShow.call(element)===false){module.debug("onShow callback returned false, cancelling nag animation");return false}module.debug("Showing nag",settings.animation.show);if(settings.animation.show==="fade"){$module.fadeIn(settings.duration,settings.easing,settings.onVisible)}else{$module.slideDown(settings.duration,settings.easing,settings.onVisible)}}},hide:function(){if(settings.onHide.call(element)===false){module.debug("onHide callback returned false, cancelling nag animation");return false}module.debug("Hiding nag",settings.animation.hide);if(settings.animation.hide==="fade"){$module.fadeOut(settings.duration,settings.easing,settings.onHidden)}else{$module.slideUp(settings.duration,settings.easing,settings.onHidden)}},dismiss:function(event){if(module.hide()!==false&&settings.storageMethod){module.debug("Dismissing nag",settings.storageMethod,settings.key,settings.value,settings.expires);module.storage.set(settings.key,settings.value)}event.stopImmediatePropagation();event.preventDefault()},should:{show:function(){if(settings.persist){module.debug("Persistent nag is set, can show nag");return true}if(module.storage.get(settings.key)!=settings.value.toString()){module.debug("Stored value is not set, can show nag",module.storage.get(settings.key));return true}module.debug("Stored value is set, cannot show nag",module.storage.get(settings.key));return false}},get:{expirationDate:function(expires){if(typeof expires==="number"){expires=new Date(Date.now()+expires*864e5)}if(expires instanceof Date&&expires.getTime()){return expires.toUTCString()}else{module.error(error.expiresFormat)}},storage:function(){if(settings.storageMethod==="localstorage"&&window.localStorage!==undefined){module.debug("Using local storage");return window.localStorage}else if(settings.storageMethod==="sessionstorage"&&window.sessionStorage!==undefined){module.debug("Using session storage");return window.sessionStorage}else if("cookie"in document){module.debug("Using cookie");return{setItem:function(key,value,options){key=encodeURIComponent(key).replace(/%(2[346B]|5E|60|7C)/g,decodeURIComponent).replace(/[()]/g,escape);value=encodeURIComponent(value).replace(/%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,decodeURIComponent);var cookieOptions="";for(var option in options){if(options.hasOwnProperty(option)){cookieOptions+="; "+option;if(typeof options[option]==="string"){cookieOptions+="="+options[option].split(";")[0]}}}document.cookie=key+"="+value+cookieOptions},getItem:function(key){var cookies=document.cookie.split("; ");for(var i=0,il=cookies.length;i<il;i++){var parts=cookies[i].split("="),foundKey=parts[0].replace(/(%[\dA-F]{2})+/gi,decodeURIComponent);if(key===foundKey){return parts[1]||""}}},removeItem:function(key,options){storage.setItem(key,"",options)}}}else{module.error(error.noStorage)}},storageOptions:function(){var options={};if(settings.expires){options.expires=module.get.expirationDate(settings.expires)}if(settings.domain){options.domain=settings.domain}if(settings.path){options.path=settings.path}if(settings.secure){options.secure=settings.secure}if(settings.samesite){options.samesite=settings.samesite}return options}},clear:function(){module.storage.remove(settings.key)},storage:{set:function(key,value){var options=module.get.storageOptions();if(storage===window.localStorage&&options.expires){module.debug("Storing expiration value in localStorage",key,options.expires);storage.setItem(key+settings.expirationKey,options.expires)}module.debug("Value stored",key,value);try{storage.setItem(key,value,options)}catch(e){module.error(error.setItem,e)}},get:function(key){var storedValue;storedValue=storage.getItem(key);if(storage===window.localStorage){var expiration=storage.getItem(key+settings.expirationKey);if(expiration!==null&&expiration!==undefined&&new Date(expiration)<new Date){module.debug("Value in localStorage has expired. Deleting key",key);module.storage.remove(key);storedValue=null}}if(storedValue=="undefined"||storedValue=="null"||storedValue===undefined||storedValue===null){storedValue=undefined}return storedValue},remove:function(key){var options=module.get.storageOptions();options.expires=module.get.expirationDate(-1);if(storage===window.localStorage){storage.removeItem(key+settings.expirationKey)}storage.removeItem(key,options)}},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{module.error(error.method,query);return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize()}}));return returnedValue!==undefined?returnedValue:this};$.fn.nag.settings={name:"Nag",silent:false,debug:false,verbose:false,performance:true,namespace:"Nag",persist:false,displayTime:0,animation:{show:"slide",hide:"slide"},context:false,detachable:false,expires:30,domain:false,path:"/",secure:false,samesite:false,storageMethod:"cookie",key:"nag",value:"dismiss",expirationKey:"ExpirationDate",error:{noStorage:"Unsupported storage method",method:"The method you called is not defined.",setItem:"Unexpected error while setting value",expiresFormat:'"expires" must be a number of days or a Date Object'},className:{bottom:"bottom",fixed:"fixed"},selector:{close:"> .close.icon"},duration:500,easing:"easeOutQuad",onShow:function(){},onVisible:function(){},onHide:function(){},onHidden:function(){}};$.extend($.easing,{easeOutQuad:function(x,t,b,c,d){return-c*(t/=d)*(t-2)+b}})})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Search
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.search=function(parameters){var $allModules=$(this),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),returnedValue;$(this).each((function(){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.search.settings,parameters):$.extend({},$.fn.search.settings),className=settings.className,metadata=settings.metadata,regExp=settings.regExp,fields=settings.fields,selector=settings.selector,error=settings.error,namespace=settings.namespace,eventNamespace="."+namespace,moduleNamespace=namespace+"-module",$module=$(this),$prompt=$module.find(selector.prompt),$searchButton=$module.find(selector.searchButton),$results=$module.find(selector.results),$result=$module.find(selector.result),$category=$module.find(selector.category),element=this,instance=$module.data(moduleNamespace),disabledBubbled=false,resultsDismissed=false,module;module={initialize:function(){module.verbose("Initializing module");module.get.settings();module.determine.searchFields();module.bind.events();module.set.type();module.create.results();module.instantiate()},instantiate:function(){module.verbose("Storing instance of module",module);instance=module;$module.data(moduleNamespace,module)},destroy:function(){module.verbose("Destroying instance");$module.off(eventNamespace).removeData(moduleNamespace)},refresh:function(){module.debug("Refreshing selector cache");$prompt=$module.find(selector.prompt);$searchButton=$module.find(selector.searchButton);$category=$module.find(selector.category);$results=$module.find(selector.results);$result=$module.find(selector.result)},refreshResults:function(){$results=$module.find(selector.results);$result=$module.find(selector.result)},bind:{events:function(){module.verbose("Binding events to search");if(settings.automatic){$module.on(module.get.inputEvent()+eventNamespace,selector.prompt,module.event.input);$prompt.attr("autocomplete",module.is.chrome()?"fomantic-search":"off")}$module.on("focus"+eventNamespace,selector.prompt,module.event.focus).on("blur"+eventNamespace,selector.prompt,module.event.blur).on("keydown"+eventNamespace,selector.prompt,module.handleKeyboard).on("click"+eventNamespace,selector.searchButton,module.query).on("mousedown"+eventNamespace,selector.results,module.event.result.mousedown).on("mouseup"+eventNamespace,selector.results,module.event.result.mouseup).on("click"+eventNamespace,selector.result,module.event.result.click)}},determine:{searchFields:function(){if(parameters&&parameters.searchFields!==undefined){settings.searchFields=parameters.searchFields}}},event:{input:function(){if(settings.searchDelay){clearTimeout(module.timer);module.timer=setTimeout((function(){if(module.is.focused()){module.query()}}),settings.searchDelay)}else{module.query()}},focus:function(){module.set.focus();if(settings.searchOnFocus&&module.has.minimumCharacters()){module.query((function(){if(module.can.show()){module.showResults()}}))}},blur:function(event){var pageLostFocus=document.activeElement===this,callback=function(){module.cancel.query();module.remove.focus();module.timer=setTimeout(module.hideResults,settings.hideDelay)};if(pageLostFocus){return}resultsDismissed=false;if(module.resultsClicked){module.debug("Determining if user action caused search to close");$module.one("click.close"+eventNamespace,selector.results,(function(event){if(module.is.inMessage(event)||disabledBubbled){$prompt.focus();return}disabledBubbled=false;if(!module.is.animating()&&!module.is.hidden()){callback()}}))}else{module.debug("Input blurred without user action, closing results");callback()}},result:{mousedown:function(){module.resultsClicked=true},mouseup:function(){module.resultsClicked=false},click:function(event){module.debug("Search result selected");var $result=$(this),$title=$result.find(selector.title).eq(0),$link=$result.is("a[href]")?$result:$result.find("a[href]").eq(0),href=$link.attr("href")||false,target=$link.attr("target")||false,value=$title.length>0?$title.text():false,results=module.get.results(),result=$result.data(metadata.result)||module.get.result(value,results);var oldValue=module.get.value();if($.isFunction(settings.onSelect)){if(settings.onSelect.call(element,result,results)===false){module.debug("Custom onSelect callback cancelled default select action");disabledBubbled=true;return}}module.hideResults();if(value&&module.get.value()===oldValue){module.set.value(value)}if(href){event.preventDefault();module.verbose("Opening search link found in result",$link);if(target=="_blank"||event.ctrlKey){window.open(href)}else{window.location.href=href}}}}},ensureVisible:function($el){var elTop,elBottom,resultsScrollTop,resultsHeight;if($el.length===0){return}elTop=$el.position().top;elBottom=elTop+$el.outerHeight(true);resultsScrollTop=$results.scrollTop();resultsHeight=$results.height();if(elTop<0){$results.scrollTop(resultsScrollTop+elTop)}else if(resultsHeight<elBottom){$results.scrollTop(resultsScrollTop+(elBottom-resultsHeight))}},handleKeyboard:function(event){var $result=$module.find(selector.result),$category=$module.find(selector.category),$activeResult=$result.filter("."+className.active),currentIndex=$result.index($activeResult),resultSize=$result.length,hasActiveResult=$activeResult.length>0,keyCode=event.which,keys={backspace:8,enter:13,escape:27,upArrow:38,downArrow:40},newIndex;if(keyCode==keys.escape){if(!module.is.visible()){module.verbose("Escape key pressed, blurring search field");$prompt.blur()}else{module.hideResults()}event.stopPropagation();resultsDismissed=true}if(module.is.visible()){if(keyCode==keys.enter){module.verbose("Enter key pressed, selecting active result");if($result.filter("."+className.active).length>0){module.event.result.click.call($result.filter("."+className.active),event);event.preventDefault();return false}}else if(keyCode==keys.upArrow&&hasActiveResult){module.verbose("Up key pressed, changing active result");newIndex=currentIndex-1<0?currentIndex:currentIndex-1;$category.removeClass(className.active);$result.removeClass(className.active).eq(newIndex).addClass(className.active).closest($category).addClass(className.active);module.ensureVisible($result.eq(newIndex));event.preventDefault()}else if(keyCode==keys.downArrow){module.verbose("Down key pressed, changing active result");newIndex=currentIndex+1>=resultSize?currentIndex:currentIndex+1;$category.removeClass(className.active);$result.removeClass(className.active).eq(newIndex).addClass(className.active).closest($category).addClass(className.active);module.ensureVisible($result.eq(newIndex));event.preventDefault()}}else{if(keyCode==keys.enter){module.verbose("Enter key pressed, executing query");module.query();module.set.buttonPressed();$prompt.one("keyup",module.remove.buttonFocus)}}},setup:{api:function(searchTerm,callback){var apiSettings={debug:settings.debug,on:false,cache:settings.cache,action:"search",urlData:{query:searchTerm}},apiCallbacks={onSuccess:function(response,$module,xhr){module.parse.response.call(element,response,searchTerm);callback();if(settings.apiSettings&&typeof settings.apiSettings.onSuccess==="function"){settings.apiSettings.onSuccess.call(this,response,$module,xhr)}},onFailure:function(response,$module,xhr){module.displayMessage(error.serverError);callback();if(settings.apiSettings&&typeof settings.apiSettings.onFailure==="function"){settings.apiSettings.onFailure.call(this,response,$module,xhr)}},onAbort:function(status,$module,xhr){if(settings.apiSettings&&typeof settings.apiSettings.onAbort==="function"){settings.apiSettings.onAbort.call(this,status,$module,xhr)}},onError:function(errorMessage,$module,xhr){module.error();if(settings.apiSettings&&typeof settings.apiSettings.onError==="function"){settings.apiSettings.onError.call(this,errorMessage,$module,xhr)}}};$.extend(true,apiSettings,settings.apiSettings,apiCallbacks);module.verbose("Setting up API request",apiSettings);$module.api(apiSettings)}},can:{useAPI:function(){return $.fn.api!==undefined},show:function(){return module.is.focused()&&!module.is.visible()&&!module.is.empty()},transition:function(){return settings.transition&&$.fn.transition!==undefined&&$module.transition("is supported")}},is:{animating:function(){return $results.hasClass(className.animating)},chrome:function(){return!!window.chrome&&!window.StyleMedia},hidden:function(){return $results.hasClass(className.hidden)},inMessage:function(event){if(!event.target){return}var $target=$(event.target),isInDOM=$.contains(document.documentElement,event.target);return isInDOM&&$target.closest(selector.message).length>0},empty:function(){return $results.html()===""},visible:function(){return $results.filter(":visible").length>0},focused:function(){return $prompt.filter(":focus").length>0}},get:{settings:function(){if($.isPlainObject(parameters)&&parameters.searchFullText){settings.fullTextSearch=parameters.searchFullText;module.error(settings.error.oldSearchSyntax,element)}if(settings.ignoreDiacritics&&!String.prototype.normalize){settings.ignoreDiacritics=false;module.error(error.noNormalize,element)}},inputEvent:function(){var prompt=$prompt[0],inputEvent=prompt!==undefined&&prompt.oninput!==undefined?"input":prompt!==undefined&&prompt.onpropertychange!==undefined?"propertychange":"keyup";return inputEvent},value:function(){return $prompt.val()},results:function(){return $module.data(metadata.results)},result:function(value,results){var result=false;value=value!==undefined?value:module.get.value();results=results!==undefined?results:module.get.results();if(settings.type==="category"){module.debug("Finding result that matches",value);$.each(results,(function(index,category){if(Array.isArray(category.results)){result=module.search.object(value,category.results)[0];if(result){return false}}}))}else{module.debug("Finding result in results object",value);result=module.search.object(value,results)[0]}return result||false}},select:{firstResult:function(){module.verbose("Selecting first result");$result.first().addClass(className.active)}},set:{focus:function(){$module.addClass(className.focus)},loading:function(){$module.addClass(className.loading)},value:function(value){module.verbose("Setting search input value",value);$prompt.val(value)},type:function(type){type=type||settings.type;if(className[type]){$module.addClass(className[type])}},buttonPressed:function(){$searchButton.addClass(className.pressed)}},remove:{loading:function(){$module.removeClass(className.loading)},focus:function(){$module.removeClass(className.focus)},buttonPressed:function(){$searchButton.removeClass(className.pressed)},diacritics:function(text){return settings.ignoreDiacritics?text.normalize("NFD").replace(/[\u0300-\u036f]/g,""):text}},query:function(callback){callback=$.isFunction(callback)?callback:function(){};var searchTerm=module.get.value(),cache=module.read.cache(searchTerm);callback=callback||function(){};if(module.has.minimumCharacters()){if(cache){module.debug("Reading result from cache",searchTerm);module.save.results(cache.results);module.addResults(cache.html);module.inject.id(cache.results);callback()}else{module.debug("Querying for",searchTerm);if($.isPlainObject(settings.source)||Array.isArray(settings.source)){module.search.local(searchTerm);callback()}else if(module.can.useAPI()){module.search.remote(searchTerm,callback)}else{module.error(error.source);callback()}}settings.onSearchQuery.call(element,searchTerm)}else{module.hideResults()}},search:{local:function(searchTerm){var results=module.search.object(searchTerm,settings.source),searchHTML;module.set.loading();module.save.results(results);module.debug("Returned full local search results",results);if(settings.maxResults>0){module.debug("Using specified max results",results);results=results.slice(0,settings.maxResults)}if(settings.type=="category"){results=module.create.categoryResults(results)}searchHTML=module.generateResults({results:results});module.remove.loading();module.addResults(searchHTML);module.inject.id(results);module.write.cache(searchTerm,{html:searchHTML,results:results})},remote:function(searchTerm,callback){callback=$.isFunction(callback)?callback:function(){};if($module.api("is loading")){$module.api("abort")}module.setup.api(searchTerm,callback);$module.api("query")},object:function(searchTerm,source,searchFields){searchTerm=module.remove.diacritics(String(searchTerm));var results=[],exactResults=[],fuzzyResults=[],searchExp=searchTerm.replace(regExp.escape,"\\$&"),matchRegExp=new RegExp(regExp.beginsWith+searchExp,"i"),addResult=function(array,result){var notResult=$.inArray(result,results)==-1,notFuzzyResult=$.inArray(result,fuzzyResults)==-1,notExactResults=$.inArray(result,exactResults)==-1;if(notResult&&notFuzzyResult&&notExactResults){array.push(result)}};source=source||settings.source;searchFields=searchFields!==undefined?searchFields:settings.searchFields;if(!Array.isArray(searchFields)){searchFields=[searchFields]}if(source===undefined||source===false){module.error(error.source);return[]}$.each(searchFields,(function(index,field){$.each(source,(function(label,content){var fieldExists=typeof content[field]=="string"||typeof content[field]=="number";if(fieldExists){var text;if(typeof content[field]==="string"){text=module.remove.diacritics(content[field])}else{text=content[field].toString()}if(text.search(matchRegExp)!==-1){addResult(results,content)}else if(settings.fullTextSearch==="exact"&&module.exactSearch(searchTerm,text)){addResult(exactResults,content)}else if(settings.fullTextSearch===true&&module.fuzzySearch(searchTerm,text)){addResult(fuzzyResults,content)}}}))}));$.merge(exactResults,fuzzyResults);$.merge(results,exactResults);return results}},exactSearch:function(query,term){query=query.toLowerCase();term=term.toLowerCase();return term.indexOf(query)>-1},fuzzySearch:function(query,term){var termLength=term.length,queryLength=query.length;if(typeof query!=="string"){return false}query=query.toLowerCase();term=term.toLowerCase();if(queryLength>termLength){return false}if(queryLength===termLength){return query===term}search:for(var characterIndex=0,nextCharacterIndex=0;characterIndex<queryLength;characterIndex++){var queryCharacter=query.charCodeAt(characterIndex);while(nextCharacterIndex<termLength){if(term.charCodeAt(nextCharacterIndex++)===queryCharacter){continue search}}return false}return true},parse:{response:function(response,searchTerm){if(Array.isArray(response)){var o={};o[fields.results]=response;response=o}var searchHTML=module.generateResults(response);module.verbose("Parsing server response",response);if(response!==undefined){if(searchTerm!==undefined&&response[fields.results]!==undefined){module.addResults(searchHTML);module.inject.id(response[fields.results]);module.write.cache(searchTerm,{html:searchHTML,results:response[fields.results]});module.save.results(response[fields.results])}}}},cancel:{query:function(){if(module.can.useAPI()){$module.api("abort")}}},has:{minimumCharacters:function(){var searchTerm=module.get.value(),numCharacters=searchTerm.length;return numCharacters>=settings.minCharacters},results:function(){if($results.length===0){return false}var html=$results.html();return html!=""}},clear:{cache:function(value){var cache=$module.data(metadata.cache);if(!value){module.debug("Clearing cache",value);$module.removeData(metadata.cache)}else if(value&&cache&&cache[value]){module.debug("Removing value from cache",value);delete cache[value];$module.data(metadata.cache,cache)}}},read:{cache:function(name){var cache=$module.data(metadata.cache);if(settings.cache){module.verbose("Checking cache for generated html for query",name);return typeof cache=="object"&&cache[name]!==undefined?cache[name]:false}return false}},create:{categoryResults:function(results){var categoryResults={};$.each(results,(function(index,result){if(!result.category){return}if(categoryResults[result.category]===undefined){module.verbose("Creating new category of results",result.category);categoryResults[result.category]={name:result.category,results:[result]}}else{categoryResults[result.category].results.push(result)}}));return categoryResults},id:function(resultIndex,categoryIndex){var resultID=resultIndex+1,letterID,id;if(categoryIndex!==undefined){letterID=String.fromCharCode(97+categoryIndex);id=letterID+resultID;module.verbose("Creating category result id",id)}else{id=resultID;module.verbose("Creating result id",id)}return id},results:function(){if($results.length===0){$results=$("<div />").addClass(className.results).appendTo($module)}}},inject:{result:function(result,resultIndex,categoryIndex){module.verbose("Injecting result into results");var $selectedResult=categoryIndex!==undefined?$results.children().eq(categoryIndex).children(selector.results).first().children(selector.result).eq(resultIndex):$results.children(selector.result).eq(resultIndex);module.verbose("Injecting results metadata",$selectedResult);$selectedResult.data(metadata.result,result)},id:function(results){module.debug("Injecting unique ids into results");var categoryIndex=0,resultIndex=0;if(settings.type==="category"){$.each(results,(function(index,category){if(category.results.length>0){resultIndex=0;$.each(category.results,(function(index,result){if(result.id===undefined){result.id=module.create.id(resultIndex,categoryIndex)}module.inject.result(result,resultIndex,categoryIndex);resultIndex++}));categoryIndex++}}))}else{$.each(results,(function(index,result){if(result.id===undefined){result.id=module.create.id(resultIndex)}module.inject.result(result,resultIndex);resultIndex++}))}return results}},save:{results:function(results){module.verbose("Saving current search results to metadata",results);$module.data(metadata.results,results)}},write:{cache:function(name,value){var cache=$module.data(metadata.cache)!==undefined?$module.data(metadata.cache):{};if(settings.cache){module.verbose("Writing generated html to cache",name,value);cache[name]=value;$module.data(metadata.cache,cache)}}},addResults:function(html){if($.isFunction(settings.onResultsAdd)){if(settings.onResultsAdd.call($results,html)===false){module.debug("onResultsAdd callback cancelled default action");return false}}if(html){$results.html(html);module.refreshResults();if(settings.selectFirstResult){module.select.firstResult()}module.showResults()}else{module.hideResults((function(){$results.empty()}))}},showResults:function(callback){callback=$.isFunction(callback)?callback:function(){};if(resultsDismissed){return}if(!module.is.visible()&&module.has.results()){if(module.can.transition()){module.debug("Showing results with css animations");$results.transition({animation:settings.transition+" in",debug:settings.debug,verbose:settings.verbose,silent:settings.silent,duration:settings.duration,onShow:function(){var $firstResult=$module.find(selector.result).eq(0);module.ensureVisible($firstResult)},onComplete:function(){callback()},queue:true})}else{module.debug("Showing results with javascript");$results.stop().fadeIn(settings.duration,settings.easing)}settings.onResultsOpen.call($results)}},hideResults:function(callback){callback=$.isFunction(callback)?callback:function(){};if(module.is.visible()){if(module.can.transition()){module.debug("Hiding results with css animations");$results.transition({animation:settings.transition+" out",debug:settings.debug,verbose:settings.verbose,silent:settings.silent,duration:settings.duration,onComplete:function(){callback()},queue:true})}else{module.debug("Hiding results with javascript");$results.stop().fadeOut(settings.duration,settings.easing)}settings.onResultsClose.call($results)}},generateResults:function(response){module.debug("Generating html from response",response);var template=settings.templates[settings.type],isProperObject=$.isPlainObject(response[fields.results])&&!$.isEmptyObject(response[fields.results]),isProperArray=Array.isArray(response[fields.results])&&response[fields.results].length>0,html="";if(isProperObject||isProperArray){if(settings.maxResults>0){if(isProperObject){if(settings.type=="standard"){module.error(error.maxResults)}}else{response[fields.results]=response[fields.results].slice(0,settings.maxResults)}}if($.isFunction(template)){html=template(response,fields,settings.preserveHTML)}else{module.error(error.noTemplate,false)}}else if(settings.showNoResults){html=module.displayMessage(error.noResults,"empty",error.noResultsHeader)}settings.onResults.call(element,response);return html},displayMessage:function(text,type,header){type=type||"standard";module.debug("Displaying message",text,type,header);module.addResults(settings.templates.message(text,type,header));return settings.templates.message(text,type,header)},setting:function(name,value){if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){settings[name]=value}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if($allModules.length>1){title+=" "+"("+$allModules.length+")"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize()}}));return returnedValue!==undefined?returnedValue:this};$.fn.search.settings={name:"Search",namespace:"search",silent:false,debug:false,verbose:false,performance:true,type:"standard",minCharacters:1,selectFirstResult:false,apiSettings:false,source:false,searchOnFocus:true,searchFields:["id","title","description"],displayField:"",fullTextSearch:"exact",ignoreDiacritics:false,automatic:true,hideDelay:0,searchDelay:200,maxResults:7,cache:true,showNoResults:true,preserveHTML:true,transition:"scale",duration:200,easing:"easeOutExpo",onSelect:false,onResultsAdd:false,onSearchQuery:function(query){},onResults:function(response){},onResultsOpen:function(){},onResultsClose:function(){},className:{animating:"animating",active:"active",category:"category",empty:"empty",focus:"focus",hidden:"hidden",loading:"loading",results:"results",pressed:"down"},error:{source:"Cannot search. No source used, and Semantic API module was not included",noResultsHeader:"No Results",noResults:"Your search returned no results",logging:"Error in debug logging, exiting.",noEndpoint:"No search endpoint was specified",noTemplate:"A valid template name was not specified.",oldSearchSyntax:"searchFullText setting has been renamed fullTextSearch for consistency, please adjust your settings.",serverError:"There was an issue querying the server.",maxResults:"Results must be an array to use maxResults setting",method:"The method you called is not defined.",noNormalize:'"ignoreDiacritics" setting will be ignored. Browser does not support String().normalize(). You may consider including <https://cdn.jsdelivr.net/npm/unorm@1.4.1/lib/unorm.min.js> as a polyfill.'},metadata:{cache:"cache",results:"results",result:"result"},regExp:{escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,beginsWith:"(?:s|^)"},fields:{categories:"results",categoryName:"name",categoryResults:"results",description:"description",image:"image",price:"price",results:"results",title:"title",url:"url",action:"action",actionText:"text",actionURL:"url"},selector:{prompt:".prompt",searchButton:".search.button",results:".results",message:".results > .message",category:".category",result:".result",title:".title, .name"},templates:{escape:function(string,preserveHTML){if(preserveHTML){return string}var badChars=/[<>"'`]/g,shouldEscape=/[&<>"'`]/,escape={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},escapedChar=function(chr){return escape[chr]};if(shouldEscape.test(string)){string=string.replace(/&(?![a-z0-9#]{1,12};)/gi,"&amp;");return string.replace(badChars,escapedChar)}return string},message:function(message,type,header){var html="";if(message!==undefined&&type!==undefined){html+=""+'<div class="message '+type+'">';if(header){html+=""+'<div class="header">'+header+"</div>"}html+=' <div class="description">'+message+"</div>";html+="</div>"}return html},category:function(response,fields,preserveHTML){var html="",escape=$.fn.search.settings.templates.escape;if(response[fields.categoryResults]!==undefined){$.each(response[fields.categoryResults],(function(index,category){if(category[fields.results]!==undefined&&category.results.length>0){html+='<div class="category">';if(category[fields.categoryName]!==undefined){html+='<div class="name">'+escape(category[fields.categoryName],preserveHTML)+"</div>"}html+='<div class="results">';$.each(category.results,(function(index,result){if(result[fields.url]){html+='<a class="result" href="'+result[fields.url].replace(/"/g,"")+'">'}else{html+='<a class="result">'}if(result[fields.image]!==undefined){html+=""+'<div class="image">'+' <img src="'+result[fields.image].replace(/"/g,"")+'">'+"</div>"}html+='<div class="content">';if(result[fields.price]!==undefined){html+='<div class="price">'+escape(result[fields.price],preserveHTML)+"</div>"}if(result[fields.title]!==undefined){html+='<div class="title">'+escape(result[fields.title],preserveHTML)+"</div>"}if(result[fields.description]!==undefined){html+='<div class="description">'+escape(result[fields.description],preserveHTML)+"</div>"}html+=""+"</div>";html+="</a>"}));html+="</div>";html+=""+"</div>"}}));if(response[fields.action]){if(fields.actionURL===false){html+=""+'<div class="action">'+escape(response[fields.action][fields.actionText],preserveHTML)+"</div>"}else{html+=""+'<a href="'+response[fields.action][fields.actionURL].replace(/"/g,"")+'" class="action">'+escape(response[fields.action][fields.actionText],preserveHTML)+"</a>"}}return html}return false},standard:function(response,fields,preserveHTML){var html="",escape=$.fn.search.settings.templates.escape;if(response[fields.results]!==undefined){$.each(response[fields.results],(function(index,result){if(result[fields.url]){html+='<a class="result" href="'+result[fields.url].replace(/"/g,"")+'">'}else{html+='<a class="result">'}if(result[fields.image]!==undefined){html+=""+'<div class="image">'+' <img src="'+result[fields.image].replace(/"/g,"")+'">'+"</div>"}html+='<div class="content">';if(result[fields.price]!==undefined){html+='<div class="price">'+escape(result[fields.price],preserveHTML)+"</div>"}if(result[fields.title]!==undefined){html+='<div class="title">'+escape(result[fields.title],preserveHTML)+"</div>"}if(result[fields.description]!==undefined){html+='<div class="description">'+escape(result[fields.description],preserveHTML)+"</div>"}html+=""+"</div>";html+="</a>"}));if(response[fields.action]){if(fields.actionURL===false){html+=""+'<div class="action">'+escape(response[fields.action][fields.actionText],preserveHTML)+"</div>"}else{html+=""+'<a href="'+response[fields.action][fields.actionURL].replace(/"/g,"")+'" class="action">'+escape(response[fields.action][fields.actionText],preserveHTML)+"</a>"}}return html}return false}}};$.extend($.easing,{easeOutExpo:function(x){return x===1?1:1-Math.pow(2,-10*x)}})})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Tab
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isWindow=$.isWindow||function(obj){return obj!=null&&obj===obj.window};$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.tab=function(parameters){var $allModules=$.isFunction(this)?$(window):$(this),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],query=arguments[0],methodInvoked=typeof query=="string",queryArguments=[].slice.call(arguments,1),initializedHistory=false,returnedValue;$allModules.each((function(){var settings=$.isPlainObject(parameters)?$.extend(true,{},$.fn.tab.settings,parameters):$.extend({},$.fn.tab.settings),className=settings.className,metadata=settings.metadata,selector=settings.selector,error=settings.error,regExp=settings.regExp,eventNamespace="."+settings.namespace,moduleNamespace="module-"+settings.namespace,$module=$(this),$context,$tabs,cache={},firstLoad=true,recursionDepth=0,element=this,instance=$module.data(moduleNamespace),activeTabPath,parameterArray,module,historyEvent;module={initialize:function(){module.debug("Initializing tab menu item",$module);module.fix.callbacks();module.determineTabs();module.debug("Determining tabs",settings.context,$tabs);if(settings.auto){module.set.auto()}module.bind.events();if(settings.history&&!initializedHistory){module.initializeHistory();initializedHistory=true}var activeTab=module.determine.activeTab();if(settings.autoTabActivation&&instance===undefined&&activeTab==null){activeTab=settings.autoTabActivation===true?module.get.initialPath():settings.autoTabActivation;module.debug("No active tab detected, setting tab active",activeTab);module.changeTab(activeTab)}if(activeTab!=null&&settings.history){var autoUpdate=$.address.autoUpdate();$.address.autoUpdate(false);$.address.value(activeTab);$.address.autoUpdate(autoUpdate)}module.instantiate()},instantiate:function(){module.verbose("Storing instance of module",module);instance=module;$module.data(moduleNamespace,module)},destroy:function(){module.debug("Destroying tabs",$module);$module.removeData(moduleNamespace).off(eventNamespace)},bind:{events:function(){if(!$.isWindow(element)){module.debug("Attaching tab activation events to element",$module);$module.on("click"+eventNamespace,module.event.click)}}},determineTabs:function(){var $reference;if(settings.context==="parent"){if($module.closest(selector.ui).length>0){$reference=$module.closest(selector.ui);module.verbose("Using closest UI element as parent",$reference)}else{$reference=$module}$context=$reference.parent();module.verbose("Determined parent element for creating context",$context)}else if(settings.context){$context=[window,document].indexOf(settings.context)<0?$(document).find(settings.context):$(settings.context);module.verbose("Using selector for tab context",settings.context,$context)}else{$context=$("body")}if(settings.childrenOnly){$tabs=$context.children(selector.tabs);module.debug("Searching tab context children for tabs",$context,$tabs)}else{$tabs=$context.find(selector.tabs);module.debug("Searching tab context for tabs",$context,$tabs)}},fix:{callbacks:function(){if($.isPlainObject(parameters)&&(parameters.onTabLoad||parameters.onTabInit)){if(parameters.onTabLoad){parameters.onLoad=parameters.onTabLoad;delete parameters.onTabLoad;module.error(error.legacyLoad,parameters.onLoad)}if(parameters.onTabInit){parameters.onFirstLoad=parameters.onTabInit;delete parameters.onTabInit;module.error(error.legacyInit,parameters.onFirstLoad)}settings=$.extend(true,{},$.fn.tab.settings,parameters)}}},initializeHistory:function(){module.debug("Initializing page state");if($.address===undefined){module.error(error.state);return false}else{if(settings.historyType=="state"){module.debug("Using HTML5 to manage state");if(settings.path!==false){$.address.history(true).state(settings.path);$(window).trigger("popstate")}else{module.error(error.path);return false}}$.address.bind("change",module.event.history.change)}},event:{click:function(event){var tabPath=$(this).data(metadata.tab);if(tabPath!==undefined){if(settings.history){module.verbose("Updating page state",event);$.address.value(tabPath)}else{module.verbose("Changing tab",event);module.changeTab(tabPath)}event.preventDefault()}else{module.debug("No tab specified")}},history:{change:function(event){var tabPath=event.pathNames.join("/")||module.get.initialPath(),pageTitle=settings.templates.determineTitle(tabPath)||false;module.performance.display();module.debug("History change event",tabPath,event);historyEvent=event;if(tabPath!==undefined){module.changeTab(tabPath)}if(pageTitle){$.address.title(pageTitle)}}}},refresh:function(){if(activeTabPath){module.debug("Refreshing tab",activeTabPath);module.changeTab(activeTabPath)}},cache:{read:function(cacheKey){return cacheKey!==undefined?cache[cacheKey]:false},add:function(cacheKey,content){cacheKey=cacheKey||activeTabPath;module.debug("Adding cached content for",cacheKey);cache[cacheKey]=content},remove:function(cacheKey){cacheKey=cacheKey||activeTabPath;module.debug("Removing cached content for",cacheKey);delete cache[cacheKey]}},escape:{string:function(text){text=String(text);return text.replace(regExp.escape,"\\$&")}},set:{auto:function(){var url=typeof settings.path=="string"?settings.path.replace(/\/$/,"")+"/{$tab}":"/{$tab}";module.verbose("Setting up automatic tab retrieval from server",url);if($.isPlainObject(settings.apiSettings)){settings.apiSettings.url=url}else{settings.apiSettings={url:url}}},loading:function(tabPath){var $tab=module.get.tabElement(tabPath),isLoading=$tab.hasClass(className.loading);if(!isLoading){module.verbose("Setting loading state for",$tab);$tab.addClass(className.loading).siblings($tabs).removeClass(className.active+" "+className.loading);if($tab.length>0){settings.onRequest.call($tab[0],tabPath)}}},state:function(state){$.address.value(state)}},changeTab:function(tabPath){var pushStateAvailable=window.history&&window.history.pushState,shouldIgnoreLoad=pushStateAvailable&&settings.ignoreFirstLoad&&firstLoad,remoteContent=settings.auto||$.isPlainObject(settings.apiSettings),pathArray=remoteContent&&!shouldIgnoreLoad?module.utilities.pathToArray(tabPath):module.get.defaultPathArray(tabPath);tabPath=module.utilities.arrayToPath(pathArray);$.each(pathArray,(function(index,tab){var currentPathArray=pathArray.slice(0,index+1),currentPath=module.utilities.arrayToPath(currentPathArray),isTab=module.is.tab(currentPath),isLastIndex=index+1==pathArray.length,$tab=module.get.tabElement(currentPath),$anchor,nextPathArray,nextPath,isLastTab;module.verbose("Looking for tab",tab);if(isTab){module.verbose("Tab was found",tab);activeTabPath=currentPath;parameterArray=module.utilities.filterArray(pathArray,currentPathArray);if(isLastIndex){isLastTab=true}else{nextPathArray=pathArray.slice(0,index+2);nextPath=module.utilities.arrayToPath(nextPathArray);isLastTab=!module.is.tab(nextPath);if(isLastTab){module.verbose("Tab parameters found",nextPathArray)}}if(settings.onBeforeChange.call(element,currentPath)===false){module.debug("onBeforeChange returned false, cancelling tab change",$tab);return false}if(isLastTab&&remoteContent){if(!shouldIgnoreLoad){module.activate.navigation(currentPath);module.fetch.content(currentPath,tabPath)}else{module.debug("Ignoring remote content on first tab load",currentPath);firstLoad=false;module.cache.add(tabPath,$tab.html());module.activate.all(currentPath);settings.onFirstLoad.call($tab[0],currentPath,parameterArray,historyEvent);settings.onLoad.call($tab[0],currentPath,parameterArray,historyEvent)}return false}else{module.debug("Opened local tab",currentPath);module.activate.all(currentPath);if(!module.cache.read(currentPath)){module.cache.add(currentPath,true);module.debug("First time tab loaded calling tab init");settings.onFirstLoad.call($tab[0],currentPath,parameterArray,historyEvent)}settings.onLoad.call($tab[0],currentPath,parameterArray,historyEvent)}}else if(tabPath.search("/")==-1&&tabPath!==""){tabPath=module.escape.string(tabPath);$anchor=$("#"+tabPath+', a[name="'+tabPath+'"]');currentPath=$anchor.closest("[data-tab]").data(metadata.tab);$tab=module.get.tabElement(currentPath);if($anchor&&$anchor.length>0&&currentPath){module.debug("Anchor link used, opening parent tab",$tab,$anchor);if(settings.onBeforeChange.call(element,currentPath)===false){module.debug("onBeforeChange returned false, cancelling tab change",$tab);return false}if(!$tab.hasClass(className.active)){setTimeout((function(){module.scrollTo($anchor)}),0)}module.activate.all(currentPath);if(!module.cache.read(currentPath)){module.cache.add(currentPath,true);module.debug("First time tab loaded calling tab init");settings.onFirstLoad.call($tab[0],currentPath,parameterArray,historyEvent)}settings.onLoad.call($tab[0],currentPath,parameterArray,historyEvent);return false}}else{module.error(error.missingTab,$module,$context,currentPath);return false}}))},scrollTo:function($element){var scrollOffset=$element&&$element.length>0?$element.offset().top:false;if(scrollOffset!==false){module.debug("Forcing scroll to an in-page link in a hidden tab",scrollOffset,$element);$(document).scrollTop(scrollOffset)}},update:{content:function(tabPath,html,evaluateScripts){var $tab=module.get.tabElement(tabPath),tab=$tab[0];evaluateScripts=evaluateScripts!==undefined?evaluateScripts:settings.evaluateScripts;if(typeof settings.cacheType=="string"&&settings.cacheType.toLowerCase()=="dom"&&typeof html!=="string"){$tab.empty().append($(html).clone(true))}else{if(evaluateScripts){module.debug("Updating HTML and evaluating inline scripts",tabPath,html);$tab.html(html)}else{module.debug("Updating HTML",tabPath,html);tab.innerHTML=html}}}},fetch:{content:function(tabPath,fullTabPath){var $tab=module.get.tabElement(tabPath),apiSettings={dataType:"html",encodeParameters:false,on:"now",cache:settings.alwaysRefresh,headers:{"X-Remote":true},onSuccess:function(response){if(settings.cacheType=="response"){module.cache.add(fullTabPath,response)}module.update.content(tabPath,response);if(tabPath==activeTabPath){module.debug("Content loaded",tabPath);module.activate.tab(tabPath)}else{module.debug("Content loaded in background",tabPath)}settings.onFirstLoad.call($tab[0],tabPath,parameterArray,historyEvent);settings.onLoad.call($tab[0],tabPath,parameterArray,historyEvent);if(settings.loadOnce){module.cache.add(fullTabPath,true)}else if(typeof settings.cacheType=="string"&&settings.cacheType.toLowerCase()=="dom"&&$tab.children().length>0){setTimeout((function(){var $clone=$tab.children().clone(true);$clone=$clone.not("script");module.cache.add(fullTabPath,$clone)}),0)}else{module.cache.add(fullTabPath,$tab.html())}},urlData:{tab:fullTabPath}},request=$tab.api("get request")||false,existingRequest=request&&request.state()==="pending",requestSettings,cachedContent;fullTabPath=fullTabPath||tabPath;cachedContent=module.cache.read(fullTabPath);if(settings.cache&&cachedContent){module.activate.tab(tabPath);module.debug("Adding cached content",fullTabPath);if(!settings.loadOnce){if(settings.evaluateScripts=="once"){module.update.content(tabPath,cachedContent,false)}else{module.update.content(tabPath,cachedContent)}}settings.onLoad.call($tab[0],tabPath,parameterArray,historyEvent)}else if(existingRequest){module.set.loading(tabPath);module.debug("Content is already loading",fullTabPath)}else if($.api!==undefined){requestSettings=$.extend(true,{},settings.apiSettings,apiSettings);module.debug("Retrieving remote content",fullTabPath,requestSettings);module.set.loading(tabPath);$tab.api(requestSettings)}else{module.error(error.api)}}},activate:{all:function(tabPath){module.activate.tab(tabPath);module.activate.navigation(tabPath)},tab:function(tabPath){var $tab=module.get.tabElement(tabPath),$deactiveTabs=settings.deactivate=="siblings"?$tab.siblings($tabs):$tabs.not($tab),isActive=$tab.hasClass(className.active);module.verbose("Showing tab content for",$tab);if(!isActive){$tab.addClass(className.active);$deactiveTabs.removeClass(className.active+" "+className.loading);if($tab.length>0){settings.onVisible.call($tab[0],tabPath)}}},navigation:function(tabPath){var $navigation=module.get.navElement(tabPath),$deactiveNavigation=settings.deactivate=="siblings"?$navigation.siblings($allModules):$allModules.not($navigation),isActive=$navigation.hasClass(className.active);module.verbose("Activating tab navigation for",$navigation,tabPath);if(!isActive){$navigation.addClass(className.active);$deactiveNavigation.removeClass(className.active+" "+className.loading)}}},deactivate:{all:function(){module.deactivate.navigation();module.deactivate.tabs()},navigation:function(){$allModules.removeClass(className.active)},tabs:function(){$tabs.removeClass(className.active+" "+className.loading)}},is:{tab:function(tabName){return tabName!==undefined?module.get.tabElement(tabName).length>0:false}},get:{initialPath:function(){return $allModules.eq(0).data(metadata.tab)||$tabs.eq(0).data(metadata.tab)},path:function(){return $.address.value()},defaultPathArray:function(tabPath){return module.utilities.pathToArray(module.get.defaultPath(tabPath))},defaultPath:function(tabPath){var $defaultNav=$allModules.filter("[data-"+metadata.tab+'^="'+module.escape.string(tabPath)+'/"]').eq(0),defaultTab=$defaultNav.data(metadata.tab)||false;if(defaultTab){module.debug("Found default tab",defaultTab);if(recursionDepth<settings.maxDepth){recursionDepth++;return module.get.defaultPath(defaultTab)}module.error(error.recursion)}else{module.debug("No default tabs found for",tabPath,$tabs)}recursionDepth=0;return tabPath},navElement:function(tabPath){tabPath=tabPath||activeTabPath;return $allModules.filter("[data-"+metadata.tab+'="'+module.escape.string(tabPath)+'"]')},tabElement:function(tabPath){var $fullPathTab,$simplePathTab,tabPathArray,lastTab;tabPath=tabPath||activeTabPath;tabPathArray=module.utilities.pathToArray(tabPath);lastTab=module.utilities.last(tabPathArray);$fullPathTab=$tabs.filter("[data-"+metadata.tab+'="'+module.escape.string(tabPath)+'"]');$simplePathTab=$tabs.filter("[data-"+metadata.tab+'="'+module.escape.string(lastTab)+'"]');return $fullPathTab.length>0?$fullPathTab:$simplePathTab},tab:function(){return activeTabPath}},determine:{activeTab:function(){var activeTab=null;$tabs.each((function(_index,tab){var $tab=$(tab);if($tab.hasClass(className.active)){var tabPath=$(this).data(metadata.tab),$anchor=$allModules.filter("[data-"+metadata.tab+'="'+module.escape.string(tabPath)+'"]');if($anchor.hasClass(className.active)){activeTab=tabPath}}}));return activeTab}},utilities:{filterArray:function(keepArray,removeArray){return $.grep(keepArray,(function(keepValue){return $.inArray(keepValue,removeArray)==-1}))},last:function(array){return Array.isArray(array)?array[array.length-1]:false},pathToArray:function(pathName){if(pathName===undefined){pathName=activeTabPath}return typeof pathName=="string"?pathName.split("/"):[pathName]},arrayToPath:function(pathArray){return Array.isArray(pathArray)?pathArray.join("/"):false}},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{module.error(error.method,query);return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found}};if(methodInvoked){if(instance===undefined){module.initialize()}module.invoke(query)}else{if(instance!==undefined){instance.invoke("destroy")}module.initialize()}}));return returnedValue!==undefined?returnedValue:this};$.tab=function(){$(window).tab.apply(this,arguments)};$.fn.tab.settings={name:"Tab",namespace:"tab",silent:false,debug:false,verbose:false,performance:true,auto:false,history:false,historyType:"hash",path:false,context:false,childrenOnly:false,maxDepth:25,deactivate:"siblings",alwaysRefresh:false,cache:true,loadOnce:false,cacheType:"response",ignoreFirstLoad:false,apiSettings:false,evaluateScripts:"once",autoTabActivation:true,onFirstLoad:function(tabPath,parameterArray,historyEvent){},onLoad:function(tabPath,parameterArray,historyEvent){},onVisible:function(tabPath,parameterArray,historyEvent){},onRequest:function(tabPath,parameterArray,historyEvent){},onBeforeChange:function(tabPath){},templates:{determineTitle:function(tabArray){}},error:{api:"You attempted to load content without API module",method:"The method you called is not defined",missingTab:"Activated tab cannot be found. Tabs are case-sensitive.",noContent:"The tab you specified is missing a content url.",path:"History enabled, but no path was specified",recursion:"Max recursive depth reached",legacyInit:"onTabInit has been renamed to onFirstLoad in 2.0, please adjust your code.",legacyLoad:"onTabLoad has been renamed to onLoad in 2.0. Please adjust your code",state:"History requires Asual's Address library <https://github.com/asual/jquery-address>"},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s:=@]/g},metadata:{tab:"tab",loaded:"loaded",promise:"promise"},className:{loading:"loading",active:"active"},selector:{tabs:".ui.tab",ui:".ui"}}})(jQuery,window,document);
/*!
 * # Fomantic-UI 2.9.0 - Transition
 * http://github.com/fomantic/Fomantic-UI/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */(function($,window,document,undefined){"use strict";$.isFunction=$.isFunction||function(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"};window=typeof window!="undefined"&&window.Math==Math?window:typeof self!="undefined"&&self.Math==Math?self:Function("return this")();$.fn.transition=function(){var $allModules=$(this),moduleSelector=$allModules.selector||"",time=(new Date).getTime(),performance=[],moduleArguments=arguments,query=moduleArguments[0],queryArguments=[].slice.call(arguments,1),methodInvoked=typeof query==="string",returnedValue;$allModules.each((function(index){var $module=$(this),element=this,settings,instance,error,className,metadata,animationEnd,moduleNamespace,eventNamespace,module;module={initialize:function(){settings=module.get.settings.apply(element,moduleArguments);className=settings.className;error=settings.error;metadata=settings.metadata;eventNamespace="."+settings.namespace;moduleNamespace="module-"+settings.namespace;instance=$module.data(moduleNamespace)||module;animationEnd=module.get.animationEndEvent();if(methodInvoked){methodInvoked=module.invoke(query)}if(methodInvoked===false){module.verbose("Converted arguments into settings object",settings);if(settings.interval){module.delay(settings.interval)}else{module.animate()}module.instantiate()}},instantiate:function(){module.verbose("Storing instance of module",module);instance=module;$module.data(moduleNamespace,instance)},destroy:function(){module.verbose("Destroying previous module for",element);$module.removeData(moduleNamespace)},refresh:function(){module.verbose("Refreshing display type on next animation");delete module.displayType},forceRepaint:function(){module.verbose("Forcing element repaint");var $parentElement=$module.parent(),$nextElement=$module.next();if($nextElement.length===0){$module.detach().appendTo($parentElement)}else{$module.detach().insertBefore($nextElement)}},repaint:function(){module.verbose("Repainting element");var fakeAssignment=element.offsetWidth},delay:function(interval){var direction=module.get.animationDirection(),shouldReverse,delay;if(!direction){direction=module.can.transition()?module.get.direction():"static"}interval=interval!==undefined?interval:settings.interval;shouldReverse=settings.reverse=="auto"&&direction==className.outward;delay=shouldReverse||settings.reverse===true?($allModules.length-index)*interval:index*interval;module.debug("Delaying animation by",delay);setTimeout(module.animate,delay)},animate:function(overrideSettings){settings=overrideSettings||settings;if(!module.is.supported()){module.error(error.support);return false}module.debug("Preparing animation",settings.animation);if(module.is.animating()){if(settings.queue){if(!settings.allowRepeats&&module.has.direction()&&module.is.occurring()&&module.queuing!==true){module.debug("Animation is currently occurring, preventing queueing same animation",settings.animation)}else{module.queue(settings.animation)}return false}else if(!settings.allowRepeats&&module.is.occurring()){module.debug("Animation is already occurring, will not execute repeated animation",settings.animation);return false}else{module.debug("New animation started, completing previous early",settings.animation);instance.complete()}}if(module.can.animate()){module.set.animating(settings.animation)}else{module.error(error.noAnimation,settings.animation,element)}},reset:function(){module.debug("Resetting animation to beginning conditions");module.remove.animationCallbacks();module.restore.conditions();module.remove.animating()},queue:function(animation){module.debug("Queueing animation of",animation);module.queuing=true;$module.one(animationEnd+".queue"+eventNamespace,(function(){module.queuing=false;module.repaint();module.animate.apply(this,settings)}))},complete:function(event){if(event&&event.target===element){event.stopPropagation()}module.debug("Animation complete",settings.animation);module.remove.completeCallback();module.remove.failSafe();if(!module.is.looping()){if(module.is.outward()){module.verbose("Animation is outward, hiding element");module.restore.conditions();module.hide()}else if(module.is.inward()){module.verbose("Animation is outward, showing element");module.restore.conditions();module.show()}else{module.verbose("Static animation completed");module.restore.conditions();settings.onComplete.call(element)}}},force:{visible:function(){var style=$module.attr("style"),userStyle=module.get.userStyle(style),displayType=module.get.displayType(),overrideStyle=userStyle+"display: "+displayType+" !important;",inlineDisplay=$module[0].style.display,mustStayHidden=!displayType||inlineDisplay==="none"&&settings.skipInlineHidden||$module[0].tagName.match(/(script|link|style)/i);if(mustStayHidden){module.remove.transition();return false}module.verbose("Overriding default display to show element",displayType);$module.attr("style",overrideStyle);return true},hidden:function(){var style=$module.attr("style"),currentDisplay=$module.css("display"),emptyStyle=style===undefined||style==="";if(currentDisplay!=="none"&&!module.is.hidden()){module.verbose("Overriding default display to hide element");$module.css("display","none")}else if(emptyStyle){$module.removeAttr("style")}}},has:{direction:function(animation){var hasDirection=false;animation=animation||settings.animation;if(typeof animation==="string"){animation=animation.split(" ");$.each(animation,(function(index,word){if(word===className.inward||word===className.outward){hasDirection=true}}))}return hasDirection},inlineDisplay:function(){var style=$module.attr("style")||"";return Array.isArray(style.match(/display.*?;/,""))}},set:{animating:function(animation){module.remove.completeCallback();animation=animation||settings.animation;var animationClass=module.get.animationClass(animation);module.save.animation(animationClass);if(module.force.visible()){module.remove.hidden();module.remove.direction();module.start.animation(animationClass)}},duration:function(animationName,duration){duration=duration||settings.duration;duration=typeof duration=="number"?duration+"ms":duration;if(duration||duration===0){module.verbose("Setting animation duration",duration);$module.css({"animation-duration":duration})}},direction:function(direction){direction=direction||module.get.direction();if(direction==className.inward){module.set.inward()}else{module.set.outward()}},looping:function(){module.debug("Transition set to loop");$module.addClass(className.looping)},hidden:function(){$module.addClass(className.transition).addClass(className.hidden)},inward:function(){module.debug("Setting direction to inward");$module.removeClass(className.outward).addClass(className.inward)},outward:function(){module.debug("Setting direction to outward");$module.removeClass(className.inward).addClass(className.outward)},visible:function(){$module.addClass(className.transition).addClass(className.visible)}},start:{animation:function(animationClass){animationClass=animationClass||module.get.animationClass();module.debug("Starting tween",animationClass);$module.addClass(animationClass).one(animationEnd+".complete"+eventNamespace,module.complete);if(settings.useFailSafe){module.add.failSafe()}module.set.duration(settings.duration);settings.onStart.call(element)}},save:{animation:function(animation){if(!module.cache){module.cache={}}module.cache.animation=animation},displayType:function(displayType){if(displayType!=="none"){$module.data(metadata.displayType,displayType)}},transitionExists:function(animation,exists){$.fn.transition.exists[animation]=exists;module.verbose("Saving existence of transition",animation,exists)}},restore:{conditions:function(){var animation=module.get.currentAnimation();if(animation){$module.removeClass(animation);module.verbose("Removing animation class",module.cache)}module.remove.duration()}},add:{failSafe:function(){var duration=module.get.duration();module.timer=setTimeout((function(){$module.triggerHandler(animationEnd)}),duration+settings.failSafeDelay);module.verbose("Adding fail safe timer",module.timer)}},remove:{animating:function(){$module.removeClass(className.animating)},animationCallbacks:function(){module.remove.queueCallback();module.remove.completeCallback()},queueCallback:function(){$module.off(".queue"+eventNamespace)},completeCallback:function(){$module.off(".complete"+eventNamespace)},display:function(){$module.css("display","")},direction:function(){$module.removeClass(className.inward).removeClass(className.outward)},duration:function(){$module.css("animation-duration","")},failSafe:function(){module.verbose("Removing fail safe timer",module.timer);if(module.timer){clearTimeout(module.timer)}},hidden:function(){$module.removeClass(className.hidden)},visible:function(){$module.removeClass(className.visible)},looping:function(){module.debug("Transitions are no longer looping");if(module.is.looping()){module.reset();$module.removeClass(className.looping)}},transition:function(){$module.removeClass(className.transition).removeClass(className.visible).removeClass(className.hidden)}},get:{settings:function(animation,duration,onComplete){if(typeof animation=="object"){return $.extend(true,{},$.fn.transition.settings,animation)}else if(typeof onComplete=="function"){return $.extend({},$.fn.transition.settings,{animation:animation,onComplete:onComplete,duration:duration})}else if(typeof duration=="string"||typeof duration=="number"){return $.extend({},$.fn.transition.settings,{animation:animation,duration:duration})}else if(typeof duration=="object"){return $.extend({},$.fn.transition.settings,duration,{animation:animation})}else if(typeof duration=="function"){return $.extend({},$.fn.transition.settings,{animation:animation,onComplete:duration})}else{return $.extend({},$.fn.transition.settings,{animation:animation})}},animationClass:function(animation){var animationClass=animation||settings.animation,directionClass=module.can.transition()&&!module.has.direction()?module.get.direction()+" ":"";return className.animating+" "+className.transition+" "+directionClass+animationClass},currentAnimation:function(){return module.cache&&module.cache.animation!==undefined?module.cache.animation:false},currentDirection:function(){return module.is.inward()?className.inward:className.outward},direction:function(){return module.is.hidden()||!module.is.visible()?className.inward:className.outward},animationDirection:function(animation){var direction;animation=animation||settings.animation;if(typeof animation==="string"){animation=animation.split(" ");$.each(animation,(function(index,word){if(word===className.inward){direction=className.inward}else if(word===className.outward){direction=className.outward}}))}if(direction){return direction}return false},duration:function(duration){duration=duration||settings.duration;if(duration===false){duration=$module.css("animation-duration")||0}return typeof duration==="string"?duration.indexOf("ms")>-1?parseFloat(duration):parseFloat(duration)*1e3:duration},displayType:function(shouldDetermine){shouldDetermine=shouldDetermine!==undefined?shouldDetermine:true;if(settings.displayType){return settings.displayType}if(shouldDetermine&&$module.data(metadata.displayType)===undefined){var currentDisplay=$module.css("display");if(currentDisplay===""||currentDisplay==="none"){module.can.transition(true)}else{module.save.displayType(currentDisplay)}}return $module.data(metadata.displayType)},userStyle:function(style){style=style||$module.attr("style")||"";return style.replace(/display.*?;/,"")},transitionExists:function(animation){return $.fn.transition.exists[animation]},animationStartEvent:function(){var element=document.createElement("div"),animations={animation:"animationstart",OAnimation:"oAnimationStart",MozAnimation:"mozAnimationStart",WebkitAnimation:"webkitAnimationStart"},animation;for(animation in animations){if(element.style[animation]!==undefined){return animations[animation]}}return false},animationEndEvent:function(){var element=document.createElement("div"),animations={animation:"animationend",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"},animation;for(animation in animations){if(element.style[animation]!==undefined){return animations[animation]}}return false}},can:{transition:function(forced){var animation=settings.animation,transitionExists=module.get.transitionExists(animation),displayType=module.get.displayType(false),elementClass,tagName,$clone,currentAnimation,inAnimation,directionExists;if(transitionExists===undefined||forced){module.verbose("Determining whether animation exists");elementClass=$module.attr("class");tagName=$module.prop("tagName");$clone=$("<"+tagName+" />").addClass(elementClass).insertAfter($module);currentAnimation=$clone.addClass(animation).removeClass(className.inward).removeClass(className.outward).addClass(className.animating).addClass(className.transition).css("animationName");$clone.detach().insertAfter($module);inAnimation=$clone.addClass(className.inward).css("animationName");if(!displayType){$clone.detach().insertAfter($module);displayType=$clone.attr("class",elementClass).removeAttr("style").removeClass(className.hidden).removeClass(className.visible).show().css("display");module.verbose("Determining final display state",displayType);module.save.displayType(displayType)}$clone.remove();if(currentAnimation!=inAnimation){module.debug("Direction exists for animation",animation);directionExists=true}else if(currentAnimation=="none"||!currentAnimation){module.debug("No animation defined in css",animation);return}else{module.debug("Static animation found",animation,displayType);directionExists=false}module.save.transitionExists(animation,directionExists)}return transitionExists!==undefined?transitionExists:directionExists},animate:function(){return module.can.transition()!==undefined}},is:{animating:function(){return $module.hasClass(className.animating)},inward:function(){return $module.hasClass(className.inward)},outward:function(){return $module.hasClass(className.outward)},looping:function(){return $module.hasClass(className.looping)},occurring:function(animation){animation=animation||settings.animation;animation="."+animation.replace(" ",".");return $module.filter(animation).length>0},visible:function(){return $module.is(":visible")},hidden:function(){return $module.css("visibility")==="hidden"},supported:function(){return animationEnd!==false}},hide:function(){if(settings.onHide.call(element)===false){module.verbose("Hide callback returned false cancelling hide");return false}module.verbose("Hiding element");if(module.is.animating()){module.reset()}element.blur();module.remove.display();module.remove.visible();settings.onBeforeHide.call(element,module.hideNow)},hideNow:function(){module.set.hidden();module.force.hidden();settings.onHidden.call(element);settings.onComplete.call(element)},show:function(display){if(module.force.visible()&&settings.onShow.call(element)!==false){module.verbose("Showing element",display);module.remove.hidden();settings.onBeforeShow.call(element,module.showNow)}},showNow:function(){module.set.visible();settings.onVisible.call(element);settings.onComplete.call(element)},toggle:function(){if(module.is.visible()){module.hide()}else{module.show()}},stop:function(){module.debug("Stopping current animation");$module.triggerHandler(animationEnd)},stopAll:function(){module.debug("Stopping all animation");module.remove.queueCallback();$module.triggerHandler(animationEnd)},clear:{queue:function(){module.debug("Clearing animation queue");module.remove.queueCallback()}},enable:function(){module.verbose("Starting animation");$module.removeClass(className.disabled)},disable:function(){module.debug("Stopping animation");$module.addClass(className.disabled)},setting:function(name,value){module.debug("Changing setting",name,value);if($.isPlainObject(name)){$.extend(true,settings,name)}else if(value!==undefined){if($.isPlainObject(settings[name])){$.extend(true,settings[name],value)}else{settings[name]=value}}else{return settings[name]}},internal:function(name,value){if($.isPlainObject(name)){$.extend(true,module,name)}else if(value!==undefined){module[name]=value}else{return module[name]}},debug:function(){if(!settings.silent&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,settings.name+":");module.debug.apply(console,arguments)}}},verbose:function(){if(!settings.silent&&settings.verbose&&settings.debug){if(settings.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,settings.name+":");module.verbose.apply(console,arguments)}}},error:function(){if(!settings.silent){module.error=Function.prototype.bind.call(console.error,console,settings.name+":");module.error.apply(console,arguments)}},performance:{log:function(message){var currentTime,executionTime,previousTime;if(settings.performance){currentTime=(new Date).getTime();previousTime=time||currentTime;executionTime=currentTime-previousTime;time=currentTime;performance.push({Name:message[0],Arguments:[].slice.call(message,1)||"",Element:element,"Execution Time":executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var title=settings.name+":",totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,(function(index,data){totalTime+=data["Execution Time"]}));title+=" "+totalTime+"ms";if(moduleSelector){title+=" '"+moduleSelector+"'"}if($allModules.length>1){title+=" "+"("+$allModules.length+")"}if((console.group!==undefined||console.table!==undefined)&&performance.length>0){console.groupCollapsed(title);if(console.table){console.table(performance)}else{$.each(performance,(function(index,data){console.log(data["Name"]+": "+data["Execution Time"]+"ms")}))}console.groupEnd()}performance=[]}},invoke:function(query,passedArguments,context){var object=instance,maxDepth,found,response;passedArguments=passedArguments||queryArguments;context=context||element;if(typeof query=="string"&&object!==undefined){query=query.split(/[\. ]/);maxDepth=query.length-1;$.each(query,(function(depth,value){var camelCaseValue=depth!=maxDepth?value+query[depth+1].charAt(0).toUpperCase()+query[depth+1].slice(1):query;if($.isPlainObject(object[camelCaseValue])&&depth!=maxDepth){object=object[camelCaseValue]}else if(object[camelCaseValue]!==undefined){found=object[camelCaseValue];return false}else if($.isPlainObject(object[value])&&depth!=maxDepth){object=object[value]}else if(object[value]!==undefined){found=object[value];return false}else{return false}}))}if($.isFunction(found)){response=found.apply(context,passedArguments)}else if(found!==undefined){response=found}if(Array.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==undefined){returnedValue=[returnedValue,response]}else if(response!==undefined){returnedValue=response}return found!==undefined?found:false}};module.initialize()}));return returnedValue!==undefined?returnedValue:this};$.fn.transition.exists={};$.fn.transition.settings={name:"Transition",silent:false,debug:false,verbose:false,performance:true,namespace:"transition",interval:0,reverse:"auto",onStart:function(){},onComplete:function(){},onShow:function(){},onBeforeShow:function(callback){callback.call(this)},onVisible:function(){},onHide:function(){},onHidden:function(){},onBeforeHide:function(callback){callback.call(this)},useFailSafe:true,failSafeDelay:100,allowRepeats:false,displayType:false,animation:"fade",duration:false,queue:true,skipInlineHidden:false,metadata:{displayType:"display"},className:{animating:"animating",disabled:"disabled",hidden:"hidden",inward:"in",loading:"loading",looping:"looping",outward:"out",transition:"transition",visible:"visible"},error:{noAnimation:"Element is no longer attached to DOM. Unable to animate.  Use silent setting to suppress this warning in production.",repeated:"That animation is already occurring, cancelling repeated animation",method:"The method you called is not defined",support:"This browser does not support CSS animations"}}})(jQuery,window,document);var games={rby:{id:"rby",title:"Red, Blue and Yellow",nameLimit:10,dexLimit:151,loaded:false,locations:[{name:"Starter",value:0},{name:"Pallet Town",value:1},{name:"Route 1",value:2},{name:"Viridian City",value:3},{name:"Route 22",value:4},{name:"Route 2",value:5},{name:"Viridian Forest",value:6},{name:"Route 3",value:7},{name:"Route 4",value:8},{name:"Mt. Moon",value:9},{name:"Cerulean City",value:10},{name:"Route 24",value:11},{name:"Route 25",value:12},{name:"Route 5",value:13},{name:"Route 6",value:14},{name:"Vermillion City",value:15},{name:"Route 11",value:16},{name:"Diglett's Cave",value:17},{name:"Route 9",value:18},{name:"Route 10",value:19},{name:"Rock Tunnel",value:20},{name:"Pokémon Tower",value:21},{name:"Route 12",value:22},{name:"Route 8",value:23},{name:"Route 7",value:24},{name:"Celadon City",value:25},{name:"Route 16",value:26},{name:"Route 17",value:27},{name:"Route 18",value:28},{name:"Fuschia City",value:29},{name:"Safari Zone",value:30},{name:"Route 15",value:31},{name:"Route 14",value:32},{name:"Route 13",value:33},{name:"Power Plant",value:34},{name:"Route 19",value:35},{name:"Route 20",value:36},{name:"Seafoam Islands",value:37},{name:"Cinnabar Island",value:38},{name:"Pokémon Mansion",value:39},{name:"Route 21",value:40},{name:"Route 23",value:41},{name:"Victory Road",value:42},{name:"Cerulean Cave",value:43}]},gsc:{id:"gsc",title:"Gold, Silver and Crystal",nameLimit:10,dexLimit:251,loaded:false,locations:[{name:"Starter",value:0},{name:"New Bark Town",value:1},{name:"Route 29",value:2},{name:"Cherrygrove City",value:3},{name:"Route 30",value:4},{name:"Route 31",value:5},{name:"Dark Cave",value:6},{name:"Violet City",value:7},{name:"Sprout Tower",value:8},{name:"Route 32",value:9},{name:"Ruins of Alph",value:10},{name:"Union Cave",value:11},{name:"Route 33",value:12},{name:"Azalea Town",value:13},{name:"Slowpoke Well",value:14},{name:"Ilex Forest",value:15},{name:"Route 34",value:16},{name:"Goldenrod City",value:17},{name:"Route 35",value:18},{name:"National Park",value:19},{name:"Route 36",value:20},{name:"Route 37",value:21},{name:"Ecruteak City",value:22},{name:"Burned Tower",value:23},{name:"Tin Tower",value:24},{name:"Route 38",value:25},{name:"Route 39",value:26},{name:"Olivine City",value:27},{name:"Route 40",value:28},{name:"Route 41",value:29},{name:"Whirl Islands",value:30},{name:"Cianwood City",value:31},{name:"Route 42",value:32},{name:"Mt. Mortar",value:33},{name:"Mahogany Town",value:34},{name:"Rocket Hideout",value:35},{name:"Route 43",value:36},{name:"Lake of Rage",value:37},{name:"Route 44",value:38},{name:"Ice Path",value:39},{name:"Blackthorn City",value:40},{name:"Dragon's Den",value:41},{name:"Route 45",value:42},{name:"Dark Cave 2",value:43},{name:"Route 46",value:44},{name:"Route 27",value:45},{name:"Tohjo Falls",value:46},{name:"Route 26",value:47},{name:"Victory Road",value:48},{name:"Indigo Plateau",value:49},{name:"Vermillion City",value:50},{name:"Route 6",value:51},{name:"Saffron City",value:52},{name:"Route 5",value:53},{name:"Route 7",value:54},{name:"Route 8",value:55},{name:"Route 10",value:56},{name:"Rock Tunnel",value:57},{name:"Route 9",value:58},{name:"Cerulean City",value:59},{name:"Route 24",value:60},{name:"Route 25",value:61},{name:"Route 4",value:62},{name:"Route 16",value:63},{name:"Route 17",value:64},{name:"Route 18",value:65},{name:"Fuschia City",value:66},{name:"Route 15",value:67},{name:"Route 14",value:68},{name:"Route 13",value:69},{name:"Route 12",value:70},{name:"Route 11",value:71},{name:"Diglett's Cave",value:72},{name:"Route 2",value:73},{name:"Pewter City",value:74},{name:"Route 3",value:75},{name:"Mt. Moon",value:76},{name:"Viridian City",value:77},{name:"Route 1",value:78},{name:"Pallet Town",value:79},{name:"Route 21",value:80},{name:"Cinnabar Island",value:81},{name:"Route 20",value:82},{name:"Route 19",value:83},{name:"Route 22",value:84},{name:"Route 28",value:85},{name:"Mt. Silver",value:86}]},rse:{id:"rse",title:"Ruby, Sapphire and Emerald",nameLimit:10,dexLimit:386,loaded:false,locations:[{name:"Starter",value:0},{name:"Littleroot Town",value:1},{name:"Route 101",value:2},{name:"Route 102",value:3},{name:"Route 103",value:4},{name:"Petalburg City",value:5},{name:"Route 104",value:6},{name:"Petalburg Woods",value:7},{name:"Rustboro City",value:8},{name:"Route 115",value:9},{name:"Route 116",value:10},{name:"Rusturf Tunnel",value:11},{name:"Dewford Town",value:12},{name:"Route 106",value:13},{name:"Granite Cave",value:14},{name:"Route 107",value:15},{name:"Slateport City",value:16},{name:"Route 110",value:17},{name:"Altering Cave",value:18},{name:"New Mauville",value:19},{name:"Route 117",value:20},{name:"Route 111",value:21},{name:"Mirage Tower (Emerald)",value:22},{name:"Route 112",value:23},{name:"Fiery Path",value:24},{name:"Route 113",value:25},{name:"Route 114",value:26},{name:"Desert Underpass (Emerald)",value:27},{name:"Meteor Falls",value:28},{name:"Jagged Pass",value:29},{name:"Lavaridge Town",value:30},{name:"Route 118",value:31},{name:"Route 119",value:32},{name:"Fortree City",value:33},{name:"Route 120",value:34},{name:"Route 121",value:35},{name:"Safari Zone",value:36},{name:"Lilycove City",value:37},{name:"Route 122",value:38},{name:"Mt. Pyre",value:39},{name:"Route 123",value:40},{name:"Team Magma Hideout (Emerald)",value:41},{name:"Route 124",value:42},{name:"Mossdeep City",value:43},{name:"Route 125",value:44},{name:"Shoal Cave",value:45},{name:"Route 127",value:46},{name:"Route 128",value:47},{name:"Seafloor Cavern",value:48},{name:"Route 126",value:49},{name:"Sootopolis City",value:50},{name:"Cave of Origin",value:51},{name:"Route 129",value:52},{name:"Route 130",value:53},{name:"Route 131",value:54},{name:"Sky Pillar",value:55},{name:"Pacifidlog Town",value:56},{name:"Mirage Island",value:57},{name:"Route 105",value:58},{name:"Route 108",value:59},{name:"Abandoned Ship",value:60},{name:"Route 109",value:61},{name:"Route 132",value:62},{name:"Route 133",value:63},{name:"Route 134",value:64},{name:"Ever Grande City",value:65},{name:"Victory Road",value:66},{name:"S.S. Tidal",value:67},{name:"Battle Frontier",value:68},{name:"Artisan Cave",value:69}]},frlg:{id:"frlg",title:"FireRed and LeafGreen",nameLimit:10,dexLimit:386,loaded:false,locations:[{name:"Starter",value:0},{name:"Pallet Town",value:1},{name:"Route 1",value:2},{name:"Viridian City",value:3},{name:"Route 22",value:4},{name:"Route 2",value:5},{name:"Viridian Forest",value:6},{name:"Route 3",value:7},{name:"Route 4",value:8},{name:"Mt. Moon",value:9},{name:"Cerulean City",value:10},{name:"Route 24",value:11},{name:"Route 25",value:12},{name:"Route 5",value:13},{name:"Route 6",value:14},{name:"Vermillion City",value:15},{name:"Route 11",value:16},{name:"Diglett's Cave",value:17},{name:"Route 9",value:18},{name:"Route 10",value:19},{name:"Rock Tunnel",value:20},{name:"Pokémon Tower",value:21},{name:"Route 12",value:22},{name:"Route 8",value:23},{name:"Route 7",value:24},{name:"Celadon City",value:25},{name:"Route 16",value:26},{name:"Route 17",value:27},{name:"Route 18",value:28},{name:"Fuschia City",value:29},{name:"Safari Zone",value:30},{name:"Route 15",value:31},{name:"Route 14",value:32},{name:"Route 13",value:33},{name:"Power Plant",value:34},{name:"Route 19",value:35},{name:"Route 20",value:36},{name:"Seafoam Islands",value:37},{name:"Cinnabar Island",value:38},{name:"Pokémon Mansion",value:39},{name:"Route 21",value:40},{name:"One Island",value:41},{name:"Treasure Beach",value:42},{name:"Kindle Road",value:43},{name:"Mt. Ember",value:44},{name:"Cape Brink",value:45},{name:"Three Isle Port",value:46},{name:"Bond Bridge",value:47},{name:"Berry Forest",value:48},{name:"Route 23",value:49},{name:"Victory Road",value:50},{name:"Four Island",value:51},{name:"Icefall Cave",value:52},{name:"Five Island",value:53},{name:"Five Isle Meadow",value:54},{name:"Memorial Pillar",value:55},{name:"Water Labyrinth",value:56},{name:"Resort Gorgeous",value:57},{name:"Lost Cave",value:58},{name:"Water Path",value:59},{name:"Green Path",value:60},{name:"Pattern Bush",value:61},{name:"Outcast Island",value:62},{name:"Altering Cave",value:63},{name:"Ruin Valley",value:64},{name:"Trainer Tower",value:65},{name:"Canyon Entrance",value:66},{name:"Seavault Canyon",value:67},{name:"Tanoby Ruins",value:68},{name:"Cerulean Cave",value:69}]},dpp:{id:"dpp",title:"Diamond, Pearl and Platinum",nameLimit:10,dexLimit:493,loaded:false,locations:[{name:"Starter",value:0},{name:"Twinleaf Town",value:1},{name:"Route 201",value:2},{name:"Lake Verity",value:3},{name:"Route 202",value:4},{name:"Route 203",value:5},{name:"Oreburgh Gate",value:6},{name:"Oreburgh City",value:7},{name:"Oreburgh Mine",value:8},{name:"Route 207",value:9},{name:"Route 204",value:10},{name:"Ravaged Path",value:11},{name:"Floaroma Meadow",value:12},{name:"Route 205",value:13},{name:"Valley Windworks",value:14},{name:"Eterna Forest",value:15},{name:"The Old Chateau",value:16},{name:"Eterna City",value:17},{name:"Route 206",value:18},{name:"Wayward Cave",value:19},{name:"Mt. Coronet",value:20},{name:"Route 208",value:21},{name:"Hearthome City",value:22},{name:"Route 209",value:23},{name:"The Lost Tower",value:24},{name:"Solaceon Ruins",value:25},{name:"Route 210",value:26},{name:"Route 215",value:27},{name:"Veilstone City",value:28},{name:"Route 212",value:29},{name:"Trophy Garden",value:30},{name:"Pastoria City",value:31},{name:"Great Marsh",value:32},{name:"Route 213",value:33},{name:"Valor Lakefront",value:34},{name:"Lake Valor",value:35},{name:"Route 214",value:36},{name:"Ruin Maniac's Cave",value:37},{name:"Ruin Maniac's Tunnel",value:38},{name:"Celestic Town",value:39},{name:"Fuego Ironworks",value:40},{name:"Routes 219",value:41},{name:"Route 220",value:42},{name:"Route 221",value:43},{name:"Route 218",value:44},{name:"Canalave City",value:45},{name:"Iron Island",value:46},{name:"Route 211",value:47},{name:"Route 216",value:48},{name:"Route 217",value:49},{name:"Acuity Lakefront",value:50},{name:"Lake Acuity",value:51},{name:"Snowpoint Temple",value:52},{name:"Route 222",value:53},{name:"Sunyshore City",value:54},{name:"Route 223",value:55},{name:"Pokémon League",value:56},{name:"Victory Road",value:57},{name:"Route 224",value:58},{name:"Route 230",value:59},{name:"Route 229",value:60},{name:"Resort Area",value:61},{name:"Route 228",value:62},{name:"Route 226",value:63},{name:"Route 227",value:64},{name:"Stark Mountain",value:65},{name:"Route 225",value:66},{name:"Sendoff Spring",value:67},{name:"Turnback Cave",value:68},{name:"Distortion World",value:69},{name:"Spear Pillar",value:70},{name:"Newmoon Island",value:71},{name:"Flower Paradise",value:72},{name:"Hall of Origin",value:73}]},hgss:{id:"hgss",title:"HeartGold and SoulSilver",nameLimit:10,dexLimit:493,loaded:false,locations:[{name:"Starter",value:0},{name:"New Bark Town",value:1},{name:"Route 29",value:2},{name:"Cherrygrove City",value:3},{name:"Route 30",value:4},{name:"Route 31",value:5},{name:"Dark Cave",value:6},{name:"Violet City",value:7},{name:"Sprout Tower",value:8},{name:"Route 32",value:9},{name:"Ruins of Alph",value:10},{name:"Union Cave",value:11},{name:"Route 33",value:12},{name:"Azalea Town",value:13},{name:"Slowpoke Well",value:14},{name:"Ilex Forest",value:15},{name:"Route 34",value:16},{name:"Goldenrod City",value:17},{name:"Route 35",value:18},{name:"National Park",value:19},{name:"Route 36",value:20},{name:"Route 37",value:21},{name:"Ecruteak City",value:22},{name:"Burned Tower",value:23},{name:"Bell Tower",value:24},{name:"Route 38",value:25},{name:"Route 39",value:26},{name:"Olivine City",value:27},{name:"Route 40",value:28},{name:"Route 41",value:29},{name:"Whirl Islands",value:30},{name:"Cianwood City",value:31},{name:"Cliff Edge Gate",value:32},{name:"Route 47",value:33},{name:"Cliff Cave",value:34},{name:"Route 48",value:35},{name:"Safari Zone Gate",value:36},{name:"Safari Zone",value:37},{name:"Route 42",value:38},{name:"Mt. Mortar",value:39},{name:"Mahogany Town",value:40},{name:"Rocket Hideout",value:41},{name:"Route 43",value:42},{name:"Lake of Rage",value:43},{name:"Route 44",value:44},{name:"Ice Path",value:45},{name:"Blackthorn City",value:46},{name:"Dragon's Den",value:47},{name:"Route 45",value:48},{name:"Dark Cave 2",value:49},{name:"Route 46",value:50},{name:"Route 27",value:51},{name:"Tohjo Falls",value:52},{name:"Route 26",value:53},{name:"Victory Road",value:54},{name:"Indigo Plateau",value:55},{name:"Vermillion City",value:56},{name:"Route 6",value:57},{name:"Saffron City",value:58},{name:"Route 5",value:59},{name:"Route 7",value:60},{name:"Route 8",value:61},{name:"Route 10",value:62},{name:"Power Plant",value:63},{name:"Rock Tunnel",value:64},{name:"Route 9",value:65},{name:"Cerulean City",value:66},{name:"Route 24",value:67},{name:"Route 25",value:68},{name:"Route 4",value:69},{name:"Route 16",value:70},{name:"Route 17",value:71},{name:"Route 18",value:72},{name:"Fuschia City",value:73},{name:"Route 15",value:74},{name:"Route 14",value:75},{name:"Route 13",value:76},{name:"Route 12",value:77},{name:"Route 11",value:78},{name:"Diglett's Cave",value:79},{name:"Route 2",value:80},{name:"Pewter City",value:81},{name:"Route 3",value:82},{name:"Mt. Moon",value:83},{name:"Viridian City",value:84},{name:"Route 1",value:85},{name:"Pallet Town",value:86},{name:"Route 21",value:87},{name:"Cinnabar Island",value:88},{name:"Route 20",value:89},{name:"Route 19",value:90},{name:"Route 22",value:91},{name:"Route 28",value:92},{name:"Mt. Silver",value:93},{name:"Cerulean Cave",value:94}]},bw:{id:"bw",title:"Black and White",nameLimit:10,dexLimit:649,loaded:false,locations:[{name:"Starter",value:0},{name:"Nuvema Town",value:1},{name:"Route 1",value:2},{name:"Accumula Town",value:3},{name:"Route 2",value:4},{name:"Striaton City",value:5},{name:"Dreamyard",value:6},{name:"Route 3",value:7},{name:"Wellspring Cave",value:8},{name:"Nacrene City",value:9},{name:"Pinwheel Forest",value:10},{name:"Castelia City",value:11},{name:"Route 4",value:12},{name:"Desert Resort",value:13},{name:"Relic Castle",value:14},{name:"Route 16",value:15},{name:"Route 5",value:16},{name:"Driftveil Drawbridge",value:17},{name:"Driftveil City",value:18},{name:"Cold Storage",value:19},{name:"Route 6",value:20},{name:"Mistralton Cave",value:21},{name:"Chargestone Cave",value:22},{name:"Route 7",value:23},{name:"Celestial Tower",value:24},{name:"Twist Mountain",value:25},{name:"Iccirus City",value:26},{name:"Dragonspiral Tower",value:27},{name:"Route 8",value:28},{name:"Moor of Icirrus",value:29},{name:"Route 9",value:30},{name:"Route 10",value:31},{name:"Victory Road",value:32},{name:"Route 11",value:33},{name:"Village Bridge",value:34},{name:"Route 12",value:35},{name:"Route 13",value:36},{name:"Undella Town",value:37},{name:"Undella Bay",value:38},{name:"Route 14",value:39},{name:"Abundant Shrine",value:40},{name:"White Forest",value:41},{name:"Route 15",value:42},{name:"Marvelous Bridge",value:43},{name:"Lostlorn Forest",value:44},{name:"Route 17",value:45},{name:"Route 18",value:46},{name:"P2 Laboratory",value:47},{name:"Liberty Garden",value:48}]},bw2:{id:"bw2",title:"Black 2 and White 2",nameLimit:10,dexLimit:649,loaded:false,locations:[{name:"Starter",value:0},{name:"Aspertia City",value:1},{name:"Route 19",value:2},{name:"Floccesy Town",value:3},{name:"Route 20",value:4},{name:"Floccesy Ranch",value:5},{name:"Aspertia Gym",value:6},{name:"Virbank City",value:7},{name:"Virbank Complex",value:8},{name:"Castelia City",value:9},{name:"Castelia Sewers",value:10},{name:"Relic Passage",value:11},{name:"Route 4",value:12},{name:"Desert Resort",value:13},{name:"Relic Castle",value:14},{name:"Route 16",value:15},{name:"Lostlorn Forest",value:16},{name:"Route 5",value:17},{name:"Driftveil Drawbridge",value:18},{name:"Driftveil City",value:19},{name:"Route 6",value:20},{name:"Mistralton Cave",value:21},{name:"Chargestone Cave",value:22},{name:"Route 7",value:23},{name:"Celestial Tower",value:24},{name:"Reversal Mountain",value:25},{name:"Strange House",value:26},{name:"Undella Town",value:27},{name:"Undella Bay",value:28},{name:"Route 13",value:29},{name:"Route 12",value:30},{name:"Village Bridge",value:31},{name:"Route 11",value:32},{name:"Route 9",value:33},{name:"Seaside Cave",value:34},{name:"Route 21",value:35},{name:"Humilau City",value:36},{name:"Route 22",value:37},{name:"Giant Chasm",value:38},{name:"Route 23",value:39},{name:"Victory Road",value:40},{name:"Old Victory Road",value:41},{name:"Marvelous Bridge",value:42},{name:"Route 15",value:43},{name:"Route 14",value:44},{name:"Abundant Shrine",value:45},{name:"Moor of Icirrus",value:46},{name:"Icirrus City",value:47},{name:"Dragonspiral Tower",value:48},{name:"Twist Mountain",value:49},{name:"Clay Tunnel",value:50},{name:"Underground Ruins",value:51},{name:"Pinwheel Forest",value:52},{name:"Nacrene City",value:53},{name:"Route 3",value:54},{name:"Wellspring Cave",value:55},{name:"Striaton City",value:56},{name:"Dreamyard",value:57},{name:"Route 2",value:58},{name:"Accumula Town",value:59},{name:"Route 1",value:60},{name:"Route 17",value:61},{name:"Route 18",value:62},{name:"P2 Laboratory",value:63},{name:"Nature Preserve",value:64}]},xy:{id:"xy",title:"X and Y",nameLimit:12,dexLimit:721,loaded:false,locations:[{name:"Starter",value:0},{name:"Aquacorde Town",value:1},{name:"Route 2",value:2},{name:"Santalune Forest",value:3},{name:"Route 3",value:4},{name:"Route 22",value:5},{name:"Route 4",value:6},{name:"Lumiose City",value:7},{name:"Route 5",value:8},{name:"Route 6",value:9},{name:"Parfum Palace",value:10},{name:"Route 7",value:11},{name:"Battle Chateau",value:12},{name:"Connecting Cave",value:13},{name:"Route 8",value:14},{name:"Ambrette Town",value:15},{name:"Route 9",value:16},{name:"Glittering Cave",value:17},{name:"Cyllage City",value:18},{name:"Route 10",value:19},{name:"Route 11",value:20},{name:"Reflection Cave",value:21},{name:"Shalour City",value:22},{name:"Tower of Mystery",value:23},{name:"Route 12",value:24},{name:"Azure Bay",value:25},{name:"Route 13",value:26},{name:"Route 14",value:27},{name:"Laverre City",value:28},{name:"Route 15",value:29},{name:"Lost Hotel",value:30},{name:"Route 16",value:31},{name:"Frost Cavern",value:32},{name:"Route 17",value:33},{name:"Team Flare Secret HQ",value:34},{name:"Route 18",value:35},{name:"Couriway Town",value:36},{name:"Route 19",value:37},{name:"Route 20",value:38},{name:"Pokémon Village",value:39},{name:"Route 21",value:40},{name:"Victory Road",value:41},{name:"Terminus Cave",value:42},{name:"Sea Spirit's Den",value:43},{name:"Friend Safari",value:44}]},oras:{id:"oras",title:"Omega Ruby and Alpha Sapphire",nameLimit:12,dexLimit:721,loaded:false,locations:[{name:"Starter",value:0},{name:"Littleroot Town",value:1},{name:"Route 101",value:2},{name:"Route 102",value:3},{name:"Route 103",value:4},{name:"Petalburg City",value:5},{name:"Route 104",value:6},{name:"Petalburg Woods",value:7},{name:"Rustboro City",value:8},{name:"Route 115",value:9},{name:"Route 116",value:10},{name:"Rusturf Tunnel",value:11},{name:"Dewford Town",value:12},{name:"Route 106",value:13},{name:"Granite Cave",value:14},{name:"Route 107",value:15},{name:"Slateport City",value:16},{name:"Route 110",value:17},{name:"Altering Cave",value:18},{name:"New Mauville",value:19},{name:"Route 117",value:20},{name:"Route 111",value:21},{name:"Route 112",value:22},{name:"Fiery Path",value:23},{name:"Route 113",value:24},{name:"Route 114",value:25},{name:"Meteor Falls",value:26},{name:"Jagged Pass",value:27},{name:"Lavaridge Town",value:28},{name:"Route 118",value:29},{name:"Southern Island",value:30},{name:"Route 119",value:31},{name:"Fortree City",value:32},{name:"Route 120",value:33},{name:"Route 121",value:34},{name:"Safari Zone",value:35},{name:"Lilycove City",value:36},{name:"Route 122",value:37},{name:"Mt. Pyre",value:38},{name:"Route 123",value:39},{name:"Team Aqua/Magma Hideout Entrance",value:40},{name:"Route 124",value:41},{name:"Mossdeep City",value:42},{name:"Route 125",value:43},{name:"Shoal Cave",value:44},{name:"Route 127",value:45},{name:"Route 128",value:46},{name:"Seafloor Cavern",value:47},{name:"Route 126",value:48},{name:"Sootopolis City",value:49},{name:"Cave of Origin",value:50},{name:"Soaring",value:51},{name:"Route 129",value:52},{name:"Route 130",value:53},{name:"Route 131",value:54},{name:"Sky Pillar",value:55},{name:"Pacifidlog Town",value:56},{name:"Mirage Island",value:57},{name:"Route 105",value:58},{name:"Route 108",value:59},{name:"Abandoned Ship",value:60},{name:"Route 109",value:61},{name:"Route 132",value:62},{name:"Route 133",value:63},{name:"Route 134",value:64},{name:"Ever Grande City",value:65},{name:"Victory Road",value:66},{name:"S.S. Tidal",value:67},{name:"Pathless Plain",value:68},{name:"Nameless Cavern",value:69},{name:"Fabled Cave",value:70},{name:"Gnarled Den",value:71},{name:"Trackless Forest",value:72},{name:"Crescent Isle",value:73},{name:"Battle Resort",value:74},{name:"Mirage Cave",value:75},{name:"Mirage Forest",value:76},{name:"Mirage Island",value:77},{name:"Mirage Mountain",value:78}]},sm:{id:"sm",title:"Sun and Moon",nameLimit:12,dexLimit:802,loaded:false,locations:[{name:"Starter",value:0},{name:"Hau'oli Outskirts",value:1},{name:"Iki Town",value:2},{name:"Route 1",value:3},{name:"Melemele Sea",value:4},{name:"Hau'oli City",value:5},{name:"Route 2",value:6},{name:"Berry Fields",value:7},{name:"Verdant Cavern",value:8},{name:"Hau'oli Cemetery",value:9},{name:"Route 3",value:10},{name:"Melemele Meadow",value:11},{name:"Seaward Cave",value:12},{name:"Kala'e Bay",value:13},{name:"Ten Carat Hill",value:14},{name:"Hano Beach",value:15},{name:"Route 4",value:16},{name:"Paniola Town",value:17},{name:"Paniola Ranch",value:18},{name:"Route 5",value:19},{name:"Brooklet Hill",value:20},{name:"Route 6",value:21},{name:"Route 7",value:22},{name:"Wela Volcano Park",value:23},{name:"Route 8",value:24},{name:"Fossil Restoration Center",value:25},{name:"Lush Jungle",value:26},{name:"Diglett's Tunnel",value:27},{name:"Route 9",value:28},{name:"Konikoni City",value:29},{name:"Memorial Hill",value:30},{name:"Akala Outskirts",value:31},{name:"Malie City",value:32},{name:"Malie Garden",value:33},{name:"Route 10",value:34},{name:"Mount Hokulani",value:35},{name:"Route 11",value:36},{name:"Route 12",value:37},{name:"Secluded Shore",value:38},{name:"Blush Mountain",value:39},{name:"Route 13",value:40},{name:"Haina Desert",value:41},{name:"Tapu Village",value:42},{name:"Route 15",value:43},{name:"Aether House",value:44},{name:"Route 14",value:45},{name:"Thrifty Megamart",value:46},{name:"Route 16",value:47},{name:"Ula'ula Meadow",value:48},{name:"Lake of the Moone/Sunne",value:49},{name:"Route 17",value:50},{name:"Shady House",value:51},{name:"Seafolk Village",value:52},{name:"Poni Wilds",value:53},{name:"Ancient Poni Path",value:54},{name:"Poni Breaker Coast",value:55},{name:"Exeggutor Island",value:56},{name:"Vast Poni Canyon",value:57},{name:"Altar of the Moone/Sunne",value:58},{name:"Mount Lanakila",value:59},{name:"Poni Grove",value:60},{name:"Poni Plains",value:61},{name:"Poni Meadow",value:62},{name:"Resolution Cave",value:63},{name:"Poni Coast",value:64},{name:"Poni Gauntlet",value:65},{name:"Ruins of Conflict",value:66},{name:"Ruins of Life",value:67},{name:"Ruins of Abundance",value:68},{name:"Ruins of Hope",value:69}]},usum:{id:"usum",title:"Ultra Sun and Ultra Moon",nameLimit:12,dexLimit:807,loaded:false,locations:[{name:"Starter",value:0},{name:"Hau'oli Outskirts",value:1},{name:"Iki Town",value:2},{name:"Route 1",value:3},{name:"Melemele Sea",value:4},{name:"Hau'oli City",value:5},{name:"Route 2",value:6},{name:"Berry Fields",value:7},{name:"Verdant Cavern",value:8},{name:"Hau'oli Cemetery",value:9},{name:"Route 3",value:10},{name:"Melemele Meadow",value:11},{name:"Seaward Cave",value:12},{name:"Kala'e Bay",value:13},{name:"Ten Carat Hill",value:14},{name:"Hano Beach",value:15},{name:"Route 4",value:16},{name:"Paniola Town",value:17},{name:"Paniola Ranch",value:18},{name:"Route 5",value:19},{name:"Brooklet Hill",value:20},{name:"Route 6",value:21},{name:"Route 7",value:22},{name:"Wela Volcano Park",value:23},{name:"Dividing Peak Tunnel",value:24},{name:"Route 8",value:25},{name:"Fossil Restoration Center",value:26},{name:"Lush Jungle",value:27},{name:"Diglett's Tunnel",value:28},{name:"Route 9",value:29},{name:"Konikoni City",value:30},{name:"Memorial Hill",value:31},{name:"Akala Outskirts",value:32},{name:"Malie City",value:33},{name:"Malie Garden",value:34},{name:"Route 10",value:35},{name:"Mount Hokulani",value:36},{name:"Route 11",value:37},{name:"Route 12",value:38},{name:"Secluded Shore",value:39},{name:"Blush Mountain",value:40},{name:"Route 13",value:41},{name:"Haina Desert",value:42},{name:"Tapu Village",value:43},{name:"Route 15",value:44},{name:"Aether House",value:45},{name:"Route 14",value:46},{name:"Thrifty Megamart",value:47},{name:"Route 16",value:48},{name:"Ula'ula Meadow",value:49},{name:"Lake of the Moone/Sunne",value:50},{name:"Route 17",value:51},{name:"Shady House",value:52},{name:"Seafolk Village",value:53},{name:"Poni Wilds",value:54},{name:"Ancient Poni Path",value:55},{name:"Poni Breaker Coast",value:56},{name:"Exeggutor Island",value:57},{name:"Vast Poni Canyon",value:58},{name:"Altar of the Moone/Sunne",value:59},{name:"Mount Lanakila",value:60},{name:"Poni Grove",value:61},{name:"Poni Plains",value:62},{name:"Poni Meadow",value:63},{name:"Resolution Cave",value:64},{name:"Poni Coast",value:65},{name:"Poni Gauntlet",value:66},{name:"Ruins of Conflict",value:67},{name:"Ruins of Life",value:68},{name:"Ruins of Abundance",value:69},{name:"Ruins of Hope",value:70}]},swsh:{id:"swsh",title:"Sword and Shield",nameLimit:12,dexLimit:898,loaded:false,locations:[{name:"Starter",value:0},{name:"Slumbering Weald",value:1},{name:"Route 1",value:2},{name:"Wedgehurst",value:3},{name:"Route 2",value:4},{name:"Wild Area: Rolling Fields",value:5},{name:"Wild Area: Dappled Grove",value:6},{name:"Wild Area: West Lake Axewell",value:7},{name:"Wild Area: Watchtower Ruins",value:8},{name:"Wild Area: East Lake Axewell",value:9},{name:"Wild Area: South Lake Miloch",value:10},{name:"Wild Area: Giant's Seat",value:11},{name:"Wild Area: North Lake Miloch",value:12},{name:"Motostoke",value:13},{name:"Route 3",value:14},{name:"Galar Mine",value:15},{name:"Route 4",value:16},{name:"Route 5",value:17},{name:"Hulbury",value:18},{name:"Galar Mine No. 2",value:19},{name:"Motostoke Outskirts",value:20},{name:"Motostoke Stadium",value:21},{name:"Wild Area: Motostoke Riverbank",value:22},{name:"Wild Area: Bridge Field",value:23},{name:"Wild Area: Stony Wilderness",value:24},{name:"Wild Area: Giant's Mirror",value:25},{name:"Wild Area: Dusty Bowl",value:26},{name:"Wild Area: Giant's Cap",value:27},{name:"Wild Area: Hammerlocke Hills",value:28},{name:"Wild Area: Lake of Outrage",value:29},{name:"Route 6",value:30},{name:"Glimwood Tangle",value:31},{name:"Router 7",value:32},{name:"Route 8",value:33},{name:"Route 9",value:34},{name:"Wild Area: Axew's Eye",value:35},{name:"Isle of Armor: Fields of Honor",value:36},{name:"Isle of Armor: Soothing Wetlands",value:37},{name:"Isle of Armor: Forest of Focus",value:38},{name:"Isle of Armor: Challenge Beach",value:39},{name:"Isle of Armor: Brawlers' Cave",value:40},{name:"Isle of Armor: Challenge Road",value:41},{name:"Isle of Armor: Courageous Cavern",value:42},{name:"Isle of Armor: Loop Lagoon",value:43},{name:"Isle of Armor: Training Lowlands",value:44},{name:"Isle of Armor: Warm-Up Tunnel",value:45},{name:"Isle of Armor: Potbottom Desert",value:46},{name:"Isle of Armor: Workout Sea",value:47},{name:"Isle of Armor: Stepping-Stone Sea",value:48},{name:"Isle of Armor: Insular Sea",value:49},{name:"Isle of Armor: Honeycalm Sea",value:50},{name:"Isle of Armor: Honeycalm Island",value:51},{name:"Crown Tundra: Slippery Slope",value:52},{name:"Crown Tundra: Freezington",value:53},{name:"Crown Tundra: Max Lair",value:54},{name:"Crown Tundra: Frostpoint Field",value:55},{name:"Crown Tundra: Giant's Bed",value:56},{name:"Crown Tundra: Old Cemetery",value:57},{name:"Crown Tundra: Snowslide Slope",value:58},{name:"Crown Tundra: Tunnel to the Top",value:59},{name:"Crown Tundra: Path to the Peak",value:60},{name:"Crown Tundra: Crown Shrine",value:61},{name:"Crown Tundra: Giant's Foot",value:62},{name:"Crown Tundra: Roaring-Sea Caves",value:63},{name:"Crown Tundra: Frigrid Sea",value:64},{name:"Crown Tundra: Three-Point Pass",value:65},{name:"Crown Tundra: Ballimere Lake",value:66},{name:"Crown Tundra: Lakeside Cave",value:67},{name:"Crown Tundra: Dyna Tree Hill",value:68},{name:"Crown Tundra: Rock Peak Ruins",value:69},{name:"Crown Tundra: Iceberg Ruins",value:70},{name:"Crown Tundra: Iron Ruins",value:71},{name:"Crown Tundra: Split-Decision Ruins",value:72}]},sv:{id:"sv",title:"Scarlet and Violet",nameLimit:12,dexLimit:1008,loaded:false,locations:[{name:"Starter",value:0},{name:"Poco Path",value:1},{name:"Inlet Grotto",value:2},{name:"South Province: Area One",value:3},{name:"Pokémon League",value:4},{name:"South Province: Area Two",value:5},{name:"South Province: Area Three",value:6},{name:"East Province: Area One",value:7},{name:"East Province: Area Two",value:8},{name:"South Province: Area Four",value:9},{name:"South Province: Area Five",value:10},{name:"West Province: Area One",value:11},{name:"Asado Desert",value:12},{name:"West Paldean Sea",value:13},{name:"West Province: Area Two",value:14},{name:"West Province: Area Three",value:15},{name:"East Province: Area Three",value:16},{name:"East Paldean Sea",value:17},{name:"Tagtree Thicket",value:18},{name:"South Province: Area Six",value:19},{name:"Alfornada Cavern",value:20},{name:"South Paldean Sea",value:21},{name:"Dalizapa Passage",value:22},{name:"Glaseado Mountain",value:23},{name:"North Province: Area Three",value:24},{name:"North Paldean Sea",value:25},{name:"North Province: Area One",value:26},{name:"North Province: Area Two",value:27},{name:"Socarrat Trail",value:28},{name:"Casseroya Lake",value:29},{name:"Area Zero",value:30}]},custom:{id:"custom",title:"Custom Game",nameLimit:12,dexLimit:1008,loaded:false,locations:[{name:"Starter",value:0}]}};const pkmnData=[{name:"Bulbasaur",value:"bulbasaur",icon:"bulbasaur",exclude:["sv"]},{name:"Ivysaur",value:"ivysaur",icon:"ivysaur",exclude:["sv"]},{name:"Venusaur",value:"venusaur",icon:"venusaur",exclude:["sv"]},{name:"Charmander",value:"charmander",icon:"charmander"},{name:"Charmeleon",value:"charmeleon",icon:"charmeleon"},{name:"Charizard",value:"charizard",icon:"charizard"},{name:"Squirtle",value:"squirtle",icon:"squirtle",exclude:["sv"]},{name:"Wartortle",value:"wartortle",icon:"wartortle",exclude:["sv"]},{name:"Blastoise",value:"blastoise",icon:"blastoise",exclude:["sv"]},{name:"Caterpie",value:"caterpie",icon:"caterpie",exclude:["sv"]},{name:"Metapod",value:"metapod",icon:"metapod",exclude:["sv"]},{name:"Butterfree",value:"butterfree",icon:"butterfree",exclude:["sv"]},{name:"Weedle",value:"weedle",icon:"weedle",exclude:["swsh","sv"]},{name:"Kakuna",value:"kakuna",icon:"kakuna",exclude:["swsh","sv"]},{name:"Beedrill",value:"beedrill",icon:"beedrill",exclude:["swsh","sv"]},{name:"Pidgey",value:"pidgey",icon:"pidgey",exclude:["swsh","sv"]},{name:"Pidgeotto",value:"pidgeotto",icon:"pidgeotto",exclude:["swsh","sv"]},{name:"Pidgeot",value:"pidgeot",icon:"pidgeot",exclude:["swsh","sv"]},{name:"Rattata",value:"rattata",icon:"rattata",exclude:["swsh","sv"]},{name:"Raticate",value:"raticate",icon:"raticate",exclude:["swsh","sv"]},{name:"Spearow",value:"spearow",icon:"spearow",exclude:["swsh","sv"]},{name:"Fearow",value:"fearow",icon:"fearow",exclude:["swsh","sv"]},{name:"Ekans",value:"ekans",icon:"ekans",exclude:["swsh","sv"]},{name:"Arbok",value:"arbok",icon:"arbok",exclude:["swsh","sv"]},{name:"Pikachu",value:"pikachu",icon:"pikachu"},{name:"Raichu",value:"raichu",icon:"raichu"},{name:"Sandshrew",value:"sandshrew",icon:"sandshrew",exclude:["sv"]},{name:"Sandslash",value:"sandslash",icon:"sandslash",exclude:["sv"]},{name:"Nidoran♀",value:"nidoran-f",icon:"nidoran-f",exclude:["sv"]},{name:"Nidorina",value:"nidorina",icon:"nidorina",exclude:["sv"]},{name:"Nidoqueen",value:"nidoqueen",icon:"nidoqueen",exclude:["sv"]},{name:"Nidoran♂",value:"nidoran-m",icon:"nidoran-m",exclude:["sv"]},{name:"Nidorino",value:"nidorino",icon:"nidorino",exclude:["sv"]},{name:"Nidoking",value:"nidoking",icon:"nidoking",exclude:["sv"]},{name:"Clefairy",value:"clefairy",icon:"clefairy",exclude:["sv"]},{name:"Clefable",value:"clefable",icon:"clefable",exclude:["sv"]},{name:"Vulpix",value:"vulpix",icon:"vulpix",exclude:["sv"]},{name:"Ninetales",value:"ninetales",icon:"ninetales",exclude:["sv"]},{name:"Jigglypuff",value:"jigglypuff",icon:"jigglypuff"},{name:"Wigglytuff",value:"wigglytuff",icon:"wigglytuff"},{name:"Zubat",value:"zubat",icon:"zubat",exclude:["sv"]},{name:"Golbat",value:"golbat",icon:"golbat",exclude:["sv"]},{name:"Oddish",value:"oddish",icon:"oddish",exclude:["sv"]},{name:"Gloom",value:"gloom",icon:"gloom",exclude:["sv"]},{name:"Vileplume",value:"vileplume",icon:"vileplume",exclude:["sv"]},{name:"Paras",value:"paras",icon:"paras",exclude:["swsh","sv"]},{name:"Parasect",value:"parasect",icon:"parasect",exclude:["swsh","sv"]},{name:"Venonat",value:"venonat",icon:"venonat",exclude:["swsh"]},{name:"Venomoth",value:"venomoth",icon:"venomoth",exclude:["swsh"]},{name:"Diglett",value:"diglett",icon:"diglett"},{name:"Dugtrio",value:"dugtrio",icon:"dugtrio"},{name:"Meowth",value:"meowth",icon:"meowth"},{name:"Persian",value:"persian",icon:"persian"},{name:"Psyduck",value:"psyduck",icon:"psyduck"},{name:"Golduck",value:"golduck",icon:"golduck"},{name:"Mankey",value:"mankey",icon:"mankey",exclude:["swsh"]},{name:"Primeape",value:"primeape",icon:"primeape",exclude:["swsh"]},{name:"Growlithe",value:"growlithe",icon:"growlithe"},{name:"Arcanine",value:"arcanine",icon:"arcanine"},{name:"Poliwag",value:"poliwag",icon:"poliwag",exclude:["sv"]},{name:"Poliwhirl",value:"poliwhirl",icon:"poliwhirl",exclude:["sv"]},{name:"Poliwrath",value:"poliwrath",icon:"poliwrath",exclude:["sv"]},{name:"Abra",value:"abra",icon:"abra",exclude:["sv"]},{name:"Kadabra",value:"kadabra",icon:"kadabra",exclude:["sv"]},{name:"Alakazam",value:"alakazam",icon:"alakazam",exclude:["sv"]},{name:"Machop",value:"machop",icon:"machop",exclude:["sv"]},{name:"Machoke",value:"machoke",icon:"machoke",exclude:["sv"]},{name:"Machamp",value:"machamp",icon:"machamp",exclude:["sv"]},{name:"Bellsprout",value:"bellsprout",icon:"bellsprout",exclude:["swsh","sv"]},{name:"Weepinbell",value:"weepinbell",icon:"weepinbell",exclude:["swsh","sv"]},{name:"Victreebel",value:"victreebel",icon:"victreebel",exclude:["swsh","sv"]},{name:"Tentacool",value:"tentacool",icon:"tentacool",exclude:["sv"]},{name:"Tentacruel",value:"tentacruel",icon:"tentacruel",exclude:["sv"]},{name:"Geodude",value:"geodude",icon:"geodude",exclude:["swsh","sv"]},{name:"Graveler",value:"graveler",icon:"graveler",exclude:["swsh","sv"]},{name:"Golem",value:"golem",icon:"golem",exclude:["swsh","sv"]},{name:"Ponyta",value:"ponyta",icon:"ponyta",exclude:["sv"]},{name:"Rapidash",value:"rapidash",icon:"rapidash",exclude:["sv"]},{name:"Slowpoke",value:"slowpoke",icon:"slowpoke"},{name:"Slowbro",value:"slowbro",icon:"slowbro"},{name:"Magnemite",value:"magnemite",icon:"magnemite"},{name:"Magneton",value:"magneton",icon:"magneton"},{name:"Farfetch'd",value:"farfetchd",icon:"farfetchd",exclude:["sv"]},{name:"Doduo",value:"doduo",icon:"doduo",exclude:["swsh","sv"]},{name:"Dodrio",value:"dodrio",icon:"dodrio",exclude:["swsh","sv"]},{name:"Seel",value:"seel",icon:"seel",exclude:["swsh","sv"]},{name:"Dewgong",value:"dewgong",icon:"dewgong",exclude:["swsh","sv"]},{name:"Grimer",value:"grimer",icon:"grimer",exclude:["swsh"]},{name:"Muk",value:"muk",icon:"muk",exclude:["swsh"]},{name:"Shellder",value:"shellder",icon:"shellder"},{name:"Cloyster",value:"cloyster",icon:"cloyster"},{name:"Gastly",value:"gastly",icon:"gastly"},{name:"Haunter",value:"haunter",icon:"haunter"},{name:"Gengar",value:"gengar",icon:"gengar"},{name:"Onix",value:"onix",icon:"onix",exclude:["sv"]},{name:"Drowzee",value:"drowzee",icon:"drowzee",exclude:["swsh"]},{name:"Hypno",value:"hypno",icon:"hypno",exclude:["swsh"]},{name:"Krabby",value:"krabby",icon:"krabby",exclude:["sv"]},{name:"Kingler",value:"kingler",icon:"kingler",exclude:["sv"]},{name:"Voltorb",value:"voltorb",icon:"voltorb",exclude:["swsh"]},{name:"Electrode",value:"electrode",icon:"electrode",exclude:["swsh"]},{name:"Exeggcute",value:"exeggcute",icon:"exeggcute",exclude:["sv"]},{name:"Exeggutor",value:"exeggutor",icon:"exeggutor",exclude:["sv"]},{name:"Cubone",value:"cubone",icon:"cubone",exclude:["sv"]},{name:"Marowak",value:"marowak",icon:"marowak",exclude:["sv"]},{name:"Hitmonlee",value:"hitmonlee",icon:"hitmonlee",exclude:["sv"]},{name:"Hitmonchan",value:"hitmonchan",icon:"hitmonchan",exclude:["sv"]},{name:"Lickitung",value:"lickitung",icon:"lickitung",exclude:["sv"]},{name:"Koffing",value:"koffing",icon:"koffing",exclude:["sv"]},{name:"Weezing",value:"weezing",icon:"weezing",exclude:["sv"]},{name:"Rhyhorn",value:"rhyhorn",icon:"rhyhorn",exclude:["sv"]},{name:"Rhydon",value:"rhydon",icon:"rhydon",exclude:["sv"]},{name:"Chansey",value:"chansey",icon:"chansey"},{name:"Tangela",value:"tangela",icon:"tangela",exclude:["sv"]},{name:"Kangaskhan",value:"kangaskhan",icon:"kangaskhan",exclude:["sv"]},{name:"Horsea",value:"horsea",icon:"horsea",exclude:["sv"]},{name:"Seadra",value:"seadra",icon:"seadra",exclude:["sv"]},{name:"Goldeen",value:"goldeen",icon:"goldeen",exclude:["sv"]},{name:"Seaking",value:"seaking",icon:"seaking",exclude:["sv"]},{name:"Staryu",value:"staryu",icon:"staryu",exclude:["sv"]},{name:"Starmie",value:"starmie",icon:"starmie",exclude:["sv"]},{name:"Mr. Mime",value:"mr-mime",icon:"mr-mime",exclude:["sv"]},{name:"Scyther",value:"scyther",icon:"scyther"},{name:"Jynx",value:"jynx",icon:"jynx",exclude:["sv"]},{name:"Electabuzz",value:"electabuzz",icon:"electabuzz",exclude:["sv"]},{name:"Magmar",value:"magmar",icon:"magmar",exclude:["sv"]},{name:"Pinsir",value:"pinsir",icon:"pinsir",exclude:["sv"]},{name:"Tauros",value:"tauros",icon:"tauros"},{name:"Magikarp",value:"magikarp",icon:"magikarp"},{name:"Gyarados",value:"gyarados",icon:"gyarados"},{name:"Lapras",value:"lapras",icon:"lapras",exclude:["sv"]},{name:"Ditto",value:"ditto",icon:"ditto"},{name:"Eevee",value:"eevee",icon:"eevee"},{name:"Vaporeon",value:"vaporeon",icon:"vaporeon"},{name:"Jolteon",value:"jolteon",icon:"jolteon"},{name:"Flareon",value:"flareon",icon:"flareon"},{name:"Porygon",value:"porygon",icon:"porygon",exclude:["sv"]},{name:"Omanyte",value:"omanyte",icon:"omanyte",exclude:["sv"]},{name:"Omastar",value:"omastar",icon:"omastar",exclude:["sv"]},{name:"Kabuto",value:"kabuto",icon:"kabuto",exclude:["sv"]},{name:"Kabutops",value:"kabutops",icon:"kabutops",exclude:["sv"]},{name:"Aerodactyl",value:"aerodactyl",icon:"aerodactyl",exclude:["sv"]},{name:"Snorlax",value:"snorlax",icon:"snorlax",exclude:["sv"]},{name:"Articuno",value:"articuno",icon:"articuno"},{name:"Zapdos",value:"zapdos",icon:"zapdos"},{name:"Moltres",value:"moltres",icon:"moltres"},{name:"Dratini",value:"dratini",icon:"dratini"},{name:"Dragonair",value:"dragonair",icon:"dragonair"},{name:"Dragonite",value:"dragonite",icon:"dragonite"},{name:"Mewtwo",value:"mewtwo",icon:"mewtwo"},{name:"Mew",value:"mew",icon:"mew"},{name:"Chikorita",value:"chikorita",icon:"chikorita",exclude:["swsh","sv"]},{name:"Bayleef",value:"bayleef",icon:"bayleef",exclude:["swsh","sv"]},{name:"Meganium",value:"meganium",icon:"meganium",exclude:["swsh","sv"]},{name:"Cyndaquil",value:"cyndaquil",icon:"cyndaquil",exclude:["swsh"]},{name:"Quilava",value:"quilava",icon:"quilava",exclude:["swsh"]},{name:"Typhlosion",value:"typhlosion",icon:"typhlosion",exclude:["swsh"]},{name:"Totodile",value:"totodile",icon:"totodile",exclude:["swsh","sv"]},{name:"Croconaw",value:"croconaw",icon:"croconaw",exclude:["swsh","sv"]},{name:"Feraligatr",value:"feraligatr",icon:"feraligatr",exclude:["swsh","sv"]},{name:"Sentret",value:"sentret",icon:"sentret",exclude:["swsh","sv"]},{name:"Furret",value:"furret",icon:"furret",exclude:["swsh","sv"]},{name:"Hoothoot",value:"hoothoot",icon:"hoothoot",exclude:["sv"]},{name:"Noctowl",value:"noctowl",icon:"noctowl",exclude:["sv"]},{name:"Ledyba",value:"ledyba",icon:"ledyba",exclude:["swsh","sv"]},{name:"Ledian",value:"ledian",icon:"ledian",exclude:["swsh","sv"]},{name:"Spinarak",value:"spinarak",icon:"spinarak",exclude:["swsh","sv"]},{name:"Ariados",value:"ariados",icon:"ariados",exclude:["swsh","sv"]},{name:"Crobat",value:"crobat",icon:"crobat",exclude:["sv"]},{name:"Chinchou",value:"chinchou",icon:"chinchou",exclude:["sv"]},{name:"Lanturn",value:"lanturn",icon:"lanturn",exclude:["sv"]},{name:"Pichu",value:"pichu",icon:"pichu"},{name:"Cleffa",value:"cleffa",icon:"cleffa",exclude:["sv"]},{name:"Igglybuff",value:"igglybuff",icon:"igglybuff"},{name:"Togepi",value:"togepi",icon:"togepi",exclude:["sv"]},{name:"Togetic",value:"togetic",icon:"togetic",exclude:["sv"]},{name:"Natu",value:"natu",icon:"natu",exclude:["sv"]},{name:"Xatu",value:"xatu",icon:"xatu",exclude:["sv"]},{name:"Mareep",value:"mareep",icon:"mareep",exclude:["swsh"]},{name:"Flaaffy",value:"flaaffy",icon:"flaaffy",exclude:["swsh"]},{name:"Ampharos",value:"ampharos",icon:"ampharos",exclude:["swsh"]},{name:"Bellossom",value:"bellossom",icon:"bellossom",exclude:["sv"]},{name:"Marill",value:"marill",icon:"marill"},{name:"Azumarill",value:"azumarill",icon:"azumarill"},{name:"Sudowoodo",value:"sudowoodo",icon:"sudowoodo"},{name:"Politoed",value:"politoed",icon:"politoed",exclude:["sv"]},{name:"Hoppip",value:"hoppip",icon:"hoppip",exclude:["swsh"]},{name:"Skiploom",value:"skiploom",icon:"skiploom",exclude:["swsh"]},{name:"Jumpluff",value:"jumpluff",icon:"jumpluff",exclude:["swsh"]},{name:"Aipom",value:"aipom",icon:"aipom",exclude:["swsh","sv"]},{name:"Sunkern",value:"sunkern",icon:"sunkern",exclude:["swsh"]},{name:"Sunflora",value:"sunflora",icon:"sunflora",exclude:["swsh"]},{name:"Yanma",value:"yanma",icon:"yanma",exclude:["swsh","sv"]},{name:"Wooper",value:"wooper",icon:"wooper"},{name:"Quagsire",value:"quagsire",icon:"quagsire"},{name:"Espeon",value:"espeon",icon:"espeon"},{name:"Umbreon",value:"umbreon",icon:"umbreon"},{name:"Murkrow",value:"murkrow",icon:"murkrow",exclude:["swsh"]},{name:"Slowking",value:"slowking",icon:"slowking"},{name:"Misdreavus",value:"misdreavus",icon:"misdreavus",exclude:["swsh"]},{name:"Unown",value:"unown",icon:"unown",exclude:["swsh","sv"]},{name:"Wobbuffet",value:"wobbuffet",icon:"wobbuffet",exclude:["sv"]},{name:"Girafarig",value:"girafarig",icon:"girafarig",exclude:["swsh"]},{name:"Pineco",value:"pineco",icon:"pineco",exclude:["swsh"]},{name:"Forretress",value:"forretress",icon:"forretress",exclude:["swsh"]},{name:"Dunsparce",value:"dunsparce",icon:"dunsparce"},{name:"Gligar",value:"gligar",icon:"gligar",exclude:["swsh","sv"]},{name:"Steelix",value:"steelix",icon:"steelix",exclude:["sv"]},{name:"Snubbull",value:"snubbull",icon:"snubbull",exclude:["swsh","sv"]},{name:"Granbull",value:"granbull",icon:"granbull",exclude:["swsh","sv"]},{name:"Qwilfish",value:"qwilfish",icon:"qwilfish"},{name:"Scizor",value:"scizor",icon:"scizor"},{name:"Shuckle",value:"shuckle",icon:"shuckle",exclude:["sv"]},{name:"Heracross",value:"heracross",icon:"heracross"},{name:"Sneasel",value:"sneasel",icon:"sneasel"},{name:"Teddiursa",value:"teddiursa",icon:"teddiursa",exclude:["swsh"]},{name:"Ursaring",value:"ursaring",icon:"ursaring",exclude:["swsh"]},{name:"Slugma",value:"slugma",icon:"slugma",exclude:["swsh","sv"]},{name:"Magcargo",value:"magcargo",icon:"magcargo",exclude:["swsh","sv"]},{name:"Swinub",value:"swinub",icon:"swinub",exclude:["sv"]},{name:"Piloswine",value:"piloswine",icon:"piloswine",exclude:["sv"]},{name:"Corsola",value:"corsola",icon:"corsola",exclude:["sv"]},{name:"Remoraid",value:"remoraid",icon:"remoraid",exclude:["sv"]},{name:"Octillery",value:"octillery",icon:"octillery",exclude:["sv"]},{name:"Delibird",value:"delibird",icon:"delibird"},{name:"Mantine",value:"mantine",icon:"mantine",exclude:["sv"]},{name:"Skarmory",value:"skarmory",icon:"skarmory",exclude:["sv"]},{name:"Houndour",value:"houndour",icon:"houndour",exclude:["swsh"]},{name:"Houndoom",value:"houndoom",icon:"houndoom",exclude:["swsh"]},{name:"Kingdra",value:"kingdra",icon:"kingdra",exclude:["sv"]},{name:"Phanpy",value:"phanpy",icon:"phanpy",exclude:["swsh"]},{name:"Donphan",value:"donphan",icon:"donphan",exclude:["swsh"]},{name:"Porygon2",value:"porygon2",icon:"porygon2",exclude:["sv"]},{name:"Stantler",value:"stantler",icon:"stantler",exclude:["swsh"]},{name:"Smeargle",value:"smeargle",icon:"smeargle",exclude:["swsh","sv"]},{name:"Tyrogue",value:"tyrogue",icon:"tyrogue",exclude:["sv"]},{name:"Hitmontop",value:"hitmontop",icon:"hitmontop",exclude:["sv"]},{name:"Smoochum",value:"smoochum",icon:"smoochum",exclude:["sv"]},{name:"Elekid",value:"elekid",icon:"elekid",exclude:["sv"]},{name:"Magby",value:"magby",icon:"magby",exclude:["sv"]},{name:"Miltank",value:"miltank",icon:"miltank",exclude:["sv"]},{name:"Blissey",value:"blissey",icon:"blissey"},{name:"Raikou",value:"raikou",icon:"raikou",exclude:["sv"]},{name:"Entei",value:"entei",icon:"entei",exclude:["sv"]},{name:"Suicune",value:"suicune",icon:"suicune",exclude:["sv"]},{name:"Larvitar",value:"larvitar",icon:"larvitar"},{name:"Pupitar",value:"pupitar",icon:"pupitar"},{name:"Tyranitar",value:"tyranitar",icon:"tyranitar"},{name:"Lugia",value:"lugia",icon:"lugia",exclude:["sv"]},{name:"Ho-Oh",value:"ho-oh",icon:"ho-oh",exclude:["sv"]},{name:"Celebi",value:"celebi",icon:"celebi",exclude:["sv"]},{name:"Treecko",value:"treecko",icon:"treecko",exclude:["sv"]},{name:"Grovyle",value:"grovyle",icon:"grovyle",exclude:["sv"]},{name:"Sceptile",value:"sceptile",icon:"sceptile",exclude:["sv"]},{name:"Torchic",value:"torchic",icon:"torchic",exclude:["sv"]},{name:"Combusken",value:"combusken",icon:"combusken",exclude:["sv"]},{name:"Blaziken",value:"blaziken",icon:"blaziken",exclude:["sv"]},{name:"Mudkip",value:"mudkip",icon:"mudkip",exclude:["sv"]},{name:"Marshtomp",value:"marshtomp",icon:"marshtomp",exclude:["sv"]},{name:"Swampert",value:"swampert",icon:"swampert",exclude:["sv"]},{name:"Poochyena",value:"poochyena",icon:"poochyena",exclude:["swsh","sv"]},{name:"Mightyena",value:"mightyena",icon:"mightyena",exclude:["swsh","sv"]},{name:"Zigzagoon",value:"zigzagoon",icon:"zigzagoon",exclude:["sv"]},{name:"Linoone",value:"linoone",icon:"linoone",exclude:["sv"]},{name:"Wurmple",value:"wurmple",icon:"wurmple",exclude:["swsh","sv"]},{name:"Silcoon",value:"silcoon",icon:"silcoon",exclude:["swsh","sv"]},{name:"Beautifly",value:"beautifly",icon:"beautifly",exclude:["swsh","sv"]},{name:"Cascoon",value:"cascoon",icon:"cascoon",exclude:["swsh","sv"]},{name:"Dustox",value:"dustox",icon:"dustox",exclude:["swsh","sv"]},{name:"Lotad",value:"lotad",icon:"lotad",exclude:["sv"]},{name:"Lombre",value:"lombre",icon:"lombre",exclude:["sv"]},{name:"Ludicolo",value:"ludicolo",icon:"ludicolo",exclude:["sv"]},{name:"Seedot",value:"seedot",icon:"seedot",exclude:["sv"]},{name:"Nuzleaf",value:"nuzleaf",icon:"nuzleaf",exclude:["sv"]},{name:"Shiftry",value:"shiftry",icon:"shiftry",exclude:["sv"]},{name:"Taillow",value:"taillow",icon:"taillow",exclude:["swsh","sv"]},{name:"Swellow",value:"swellow",icon:"swellow",exclude:["swsh","sv"]},{name:"Wingull",value:"wingull",icon:"wingull"},{name:"Pelipper",value:"pelipper",icon:"pelipper"},{name:"Ralts",value:"ralts",icon:"ralts"},{name:"Kirlia",value:"kirlia",icon:"kirlia"},{name:"Gardevoir",value:"gardevoir",icon:"gardevoir"},{name:"Surskit",value:"surskit",icon:"surskit",exclude:["swsh"]},{name:"Masquerain",value:"masquerain",icon:"masquerain",exclude:["swsh"]},{name:"Shroomish",value:"shroomish",icon:"shroomish",exclude:["swsh"]},{name:"Breloom",value:"breloom",icon:"breloom",exclude:["swsh"]},{name:"Slakoth",value:"slakoth",icon:"slakoth",exclude:["swsh"]},{name:"Vigoroth",value:"vigoroth",icon:"vigoroth",exclude:["swsh"]},{name:"Slaking",value:"slaking",icon:"slaking",exclude:["swsh"]},{name:"Nincada",value:"nincada",icon:"nincada",exclude:["sv"]},{name:"Ninjask",value:"ninjask",icon:"ninjask",exclude:["sv"]},{name:"Shedinja",value:"shedinja",icon:"shedinja",exclude:["sv"]},{name:"Whismur",value:"whismur",icon:"whismur",exclude:["sv"]},{name:"Loudred",value:"loudred",icon:"loudred",exclude:["sv"]},{name:"Exploud",value:"exploud",icon:"exploud",exclude:["sv"]},{name:"Makuhita",value:"makuhita",icon:"makuhita",exclude:["swsh"]},{name:"Hariyama",value:"hariyama",icon:"hariyama",exclude:["swsh"]},{name:"Azurill",value:"azurill",icon:"azurill"},{name:"Nosepass",value:"nosepass",icon:"nosepass",exclude:["swsh","sv"]},{name:"Skitty",value:"skitty",icon:"skitty",exclude:["swsh","sv"]},{name:"Delcatty",value:"delcatty",icon:"delcatty",exclude:["swsh","sv"]},{name:"Sableye",value:"sableye",icon:"sableye"},{name:"Mawile",value:"mawile",icon:"mawile",exclude:["sv"]},{name:"Aron",value:"aron",icon:"aron",exclude:["sv"]},{name:"Lairon",value:"lairon",icon:"lairon",exclude:["sv"]},{name:"Aggron",value:"aggron",icon:"aggron",exclude:["sv"]},{name:"Meditite",value:"meditite",icon:"meditite",exclude:["swsh"]},{name:"Medicham",value:"medicham",icon:"medicham",exclude:["swsh"]},{name:"Electrike",value:"electrike",icon:"electrike",exclude:["sv"]},{name:"Manectric",value:"manectric",icon:"manectric",exclude:["sv"]},{name:"Plusle",value:"plusle",icon:"plusle",exclude:["swsh","sv"]},{name:"Minun",value:"minun",icon:"minun",exclude:["swsh","sv"]},{name:"Volbeat",value:"volbeat",icon:"volbeat",exclude:["swsh","sv"]},{name:"Illumise",value:"illumise",icon:"illumise",exclude:["swsh","sv"]},{name:"Roselia",value:"roselia",icon:"roselia",exclude:["sv"]},{name:"Gulpin",value:"gulpin",icon:"gulpin",exclude:["swsh"]},{name:"Swalot",value:"swalot",icon:"swalot",exclude:["swsh"]},{name:"Carvanha",value:"carvanha",icon:"carvanha",exclude:["sv"]},{name:"Sharpedo",value:"sharpedo",icon:"sharpedo",exclude:["sv"]},{name:"Wailmer",value:"wailmer",icon:"wailmer",exclude:["sv"]},{name:"Wailord",value:"wailord",icon:"wailord",exclude:["sv"]},{name:"Numel",value:"numel",icon:"numel",exclude:["swsh"]},{name:"Camerupt",value:"camerupt",icon:"camerupt",exclude:["swsh"]},{name:"Torkoal",value:"torkoal",icon:"torkoal"},{name:"Spoink",value:"spoink",icon:"spoink",exclude:["swsh"]},{name:"Grumpig",value:"grumpig",icon:"grumpig",exclude:["swsh"]},{name:"Spinda",value:"spinda",icon:"spinda",exclude:["swsh","sv"]},{name:"Trapinch",value:"trapinch",icon:"trapinch",exclude:["sv"]},{name:"Vibrava",value:"vibrava",icon:"vibrava",exclude:["sv"]},{name:"Flygon",value:"flygon",icon:"flygon",exclude:["sv"]},{name:"Cacnea",value:"cacnea",icon:"cacnea",exclude:["swsh"]},{name:"Cacturne",value:"cacturne",icon:"cacturne",exclude:["swsh"]},{name:"Swablu",value:"swablu",icon:"swablu"},{name:"Altaria",value:"altaria",icon:"altaria"},{name:"Zangoose",value:"zangoose",icon:"zangoose",exclude:["swsh"]},{name:"Seviper",value:"seviper",icon:"seviper",exclude:["swsh"]},{name:"Lunatone",value:"lunatone",icon:"lunatone",exclude:["sv"]},{name:"Solrock",value:"solrock",icon:"solrock",exclude:["sv"]},{name:"Barboach",value:"barboach",icon:"barboach"},{name:"Whiscash",value:"whiscash",icon:"whiscash"},{name:"Corphish",value:"corphish",icon:"corphish",exclude:["sv"]},{name:"Crawdaunt",value:"crawdaunt",icon:"crawdaunt",exclude:["sv"]},{name:"Baltoy",value:"baltoy",icon:"baltoy",exclude:["sv"]},{name:"Claydol",value:"claydol",icon:"claydol",exclude:["sv"]},{name:"Lileep",value:"lileep",icon:"lileep",exclude:["sv"]},{name:"Cradily",value:"cradily",icon:"cradily",exclude:["sv"]},{name:"Anorith",value:"anorith",icon:"anorith",exclude:["sv"]},{name:"Armaldo",value:"armaldo",icon:"armaldo",exclude:["sv"]},{name:"Feebas",value:"feebas",icon:"feebas",exclude:["sv"]},{name:"Milotic",value:"milotic",icon:"milotic",exclude:["sv"]},{name:"Castform",value:"castform",icon:"castform",exclude:["swsh","sv"]},{name:"Kecleon",value:"kecleon",icon:"kecleon",exclude:["swsh","sv"]},{name:"Shuppet",value:"shuppet",icon:"shuppet",exclude:["swsh"]},{name:"Banette",value:"banette",icon:"banette",exclude:["swsh"]},{name:"Duskull",value:"duskull",icon:"duskull",exclude:["sv"]},{name:"Dusclops",value:"dusclops",icon:"dusclops",exclude:["sv"]},{name:"Tropius",value:"tropius",icon:"tropius",exclude:["swsh"]},{name:"Chimecho",value:"chimecho",icon:"chimecho",exclude:["swsh","sv"]},{name:"Absol",value:"absol",icon:"absol",exclude:["sv"]},{name:"Wynaut",value:"wynaut",icon:"wynaut",exclude:["sv"]},{name:"Snorunt",value:"snorunt",icon:"snorunt"},{name:"Glalie",value:"glalie",icon:"glalie"},{name:"Spheal",value:"spheal",icon:"spheal",exclude:["sv"]},{name:"Sealeo",value:"sealeo",icon:"sealeo",exclude:["sv"]},{name:"Walrein",value:"walrein",icon:"walrein",exclude:["sv"]},{name:"Clamperl",value:"clamperl",icon:"clamperl",exclude:["swsh","sv"]},{name:"Huntail",value:"huntail",icon:"huntail",exclude:["swsh","sv"]},{name:"Gorebyss",value:"gorebyss",icon:"gorebyss",exclude:["swsh","sv"]},{name:"Relicanth",value:"relicanth",icon:"relicanth",exclude:["sv"]},{name:"Luvdisc",value:"luvdisc",icon:"luvdisc",exclude:["swsh"]},{name:"Bagon",value:"bagon",icon:"bagon"},{name:"Shelgon",value:"shelgon",icon:"shelgon"},{name:"Salamence",value:"salamence",icon:"salamence"},{name:"Beldum",value:"beldum",icon:"beldum",exclude:["sv"]},{name:"Metang",value:"metang",icon:"metang",exclude:["sv"]},{name:"Metagross",value:"metagross",icon:"metagross",exclude:["sv"]},{name:"Regirock",value:"regirock",icon:"regirock",exclude:["sv"]},{name:"Regice",value:"regice",icon:"regice",exclude:["sv"]},{name:"Registeel",value:"registeel",icon:"registeel",exclude:["sv"]},{name:"Latias",value:"latias",icon:"latias",exclude:["sv"]},{name:"Latios",value:"latios",icon:"latios",exclude:["sv"]},{name:"Kyogre",value:"kyogre",icon:"kyogre"},{name:"Groudon",value:"groudon",icon:"groudon"},{name:"Rayquaza",value:"rayquaza",icon:"rayquaza"},{name:"Jirachi",value:"jirachi",icon:"jirachi",exclude:["sv"]},{name:"Deoxys",value:"deoxys",icon:"deoxys",exclude:["swsh","sv"]},{name:"Turtwig",value:"turtwig",icon:"turtwig",exclude:["swsh","sv"]},{name:"Grotle",value:"grotle",icon:"grotle",exclude:["swsh","sv"]},{name:"Torterra",value:"torterra",icon:"torterra",exclude:["swsh","sv"]},{name:"Chimchar",value:"chimchar",icon:"chimchar",exclude:["swsh","sv"]},{name:"Monferno",value:"monferno",icon:"monferno",exclude:["swsh","sv"]},{name:"Infernape",value:"infernape",icon:"infernape",exclude:["swsh","sv"]},{name:"Piplup",value:"piplup",icon:"piplup",exclude:["swsh","sv"]},{name:"Prinplup",value:"prinplup",icon:"prinplup",exclude:["swsh","sv"]},{name:"Empoleon",value:"empoleon",icon:"empoleon",exclude:["swsh","sv"]},{name:"Starly",value:"starly",icon:"starly",exclude:["swsh"]},{name:"Staravia",value:"staravia",icon:"staravia",exclude:["swsh"]},{name:"Staraptor",value:"staraptor",icon:"staraptor",exclude:["swsh"]},{name:"Bidoof",value:"bidoof",icon:"bidoof",exclude:["swsh","sv"]},{name:"Bibarel",value:"bibarel",icon:"bibarel",exclude:["swsh","sv"]},{name:"Kricketot",value:"kricketot",icon:"kricketot",exclude:["swsh"]},{name:"Kricketune",value:"kricketune",icon:"kricketune",exclude:["swsh"]},{name:"Shinx",value:"shinx",icon:"shinx"},{name:"Luxio",value:"luxio",icon:"luxio"},{name:"Luxray",value:"luxray",icon:"luxray"},{name:"Budew",value:"budew",icon:"budew",exclude:["sv"]},{name:"Roserade",value:"roserade",icon:"roserade",exclude:["sv"]},{name:"Cranidos",value:"cranidos",icon:"cranidos",exclude:["swsh","sv"]},{name:"Rampardos",value:"rampardos",icon:"rampardos",exclude:["swsh","sv"]},{name:"Shieldon",value:"shieldon",icon:"shieldon",exclude:["swsh","sv"]},{name:"Bastiodon",value:"bastiodon",icon:"bastiodon",exclude:["swsh","sv"]},{name:"Burmy",value:"burmy",icon:"burmy",exclude:["swsh","sv"]},{name:"Wormadam",value:"wormadam",icon:"wormadam",exclude:["swsh","sv"]},{name:"Mothim",value:"mothim",icon:"mothim",exclude:["swsh","sv"]},{name:"Combee",value:"combee",icon:"combee"},{name:"Vespiquen",value:"vespiquen",icon:"vespiquen"},{name:"Pachirisu",value:"pachirisu",icon:"pachirisu",exclude:["swsh"]},{name:"Buizel",value:"buizel",icon:"buizel",exclude:["swsh"]},{name:"Floatzel",value:"floatzel",icon:"floatzel",exclude:["swsh"]},{name:"Cherubi",value:"cherubi",icon:"cherubi",exclude:["sv"]},{name:"Cherrim",value:"cherrim",icon:"cherrim",exclude:["sv"]},{name:"Shellos",value:"shellos",icon:"shellos"},{name:"Gastrodon",value:"gastrodon",icon:"gastrodon"},{name:"Ambipom",value:"ambipom",icon:"ambipom",exclude:["swsh","sv"]},{name:"Drifloon",value:"drifloon",icon:"drifloon"},{name:"Drifblim",value:"drifblim",icon:"drifblim"},{name:"Buneary",value:"buneary",icon:"buneary",exclude:["sv"]},{name:"Lopunny",value:"lopunny",icon:"lopunny",exclude:["sv"]},{name:"Mismagius",value:"mismagius",icon:"mismagius",exclude:["swsh"]},{name:"Honchkrow",value:"honchkrow",icon:"honchkrow",exclude:["swsh"]},{name:"Glameow",value:"glameow",icon:"glameow",exclude:["swsh","sv"]},{name:"Purugly",value:"purugly",icon:"purugly",exclude:["swsh","sv"]},{name:"Chingling",value:"chingling",icon:"chingling",exclude:["swsh","sv"]},{name:"Stunky",value:"stunky",icon:"stunky"},{name:"Skuntank",value:"skuntank",icon:"skuntank"},{name:"Bronzor",value:"bronzor",icon:"bronzor"},{name:"Bronzong",value:"bronzong",icon:"bronzong"},{name:"Bonsly",value:"bonsly",icon:"bonsly"},{name:"Mime Jr.",value:"mime-jr",icon:"mime-jr",exclude:["sv"]},{name:"Happiny",value:"happiny",icon:"happiny"},{name:"Chatot",value:"chatot",icon:"chatot",exclude:["swsh","sv"]},{name:"Spiritomb",value:"spiritomb",icon:"spiritomb"},{name:"Gible",value:"gible",icon:"gible"},{name:"Gabite",value:"gabite",icon:"gabite"},{name:"Garchomp",value:"garchomp",icon:"garchomp"},{name:"Munchlax",value:"munchlax",icon:"munchlax",exclude:["sv"]},{name:"Riolu",value:"riolu",icon:"riolu"},{name:"Lucario",value:"lucario",icon:"lucario"},{name:"Hippopotas",value:"hippopotas",icon:"hippopotas"},{name:"Hippowdon",value:"hippowdon",icon:"hippowdon"},{name:"Skorupi",value:"skorupi",icon:"skorupi",exclude:["sv"]},{name:"Drapion",value:"drapion",icon:"drapion",exclude:["sv"]},{name:"Croagunk",value:"croagunk",icon:"croagunk"},{name:"Toxicroak",value:"toxicroak",icon:"toxicroak"},{name:"Carnivine",value:"carnivine",icon:"carnivine",exclude:["swsh","sv"]},{name:"Finneon",value:"finneon",icon:"finneon",exclude:["swsh"]},{name:"Lumineon",value:"lumineon",icon:"lumineon",exclude:["swsh"]},{name:"Mantyke",value:"mantyke",icon:"mantyke",exclude:["sv"]},{name:"Snover",value:"snover",icon:"snover"},{name:"Abomasnow",value:"abomasnow",icon:"abomasnow"},{name:"Weavile",value:"weavile",icon:"weavile"},{name:"Magnezone",value:"magnezone",icon:"magnezone"},{name:"Lickilicky",value:"lickilicky",icon:"lickilicky",exclude:["sv"]},{name:"Rhyperior",value:"rhyperior",icon:"rhyperior",exclude:["sv"]},{name:"Tangrowth",value:"tangrowth",icon:"tangrowth",exclude:["sv"]},{name:"Electivire",value:"electivire",icon:"electivire",exclude:["sv"]},{name:"Magmortar",value:"magmortar",icon:"magmortar",exclude:["sv"]},{name:"Togekiss",value:"togekiss",icon:"togekiss",exclude:["sv"]},{name:"Yanmega",value:"yanmega",icon:"yanmega",exclude:["swsh","sv"]},{name:"Leafeon",value:"leafeon",icon:"leafeon"},{name:"Glaceon",value:"glaceon",icon:"glaceon"},{name:"Gliscor",value:"gliscor",icon:"gliscor",exclude:["swsh","sv"]},{name:"Mamoswine",value:"mamoswine",icon:"mamoswine",exclude:["sv"]},{name:"Porygon-Z",value:"porygon-z",icon:"porygon-z",exclude:["sv"]},{name:"Gallade",value:"gallade",icon:"gallade"},{name:"Probopass",value:"probopass",icon:"probopass",exclude:["swsh","sv"]},{name:"Dusknoir",value:"dusknoir",icon:"dusknoir",exclude:["sv"]},{name:"Froslass",value:"froslass",icon:"froslass"},{name:"Rotom",value:"rotom",icon:"rotom"},{name:"Uxie",value:"uxie",icon:"uxie"},{name:"Mesprit",value:"mesprit",icon:"mesprit"},{name:"Azelf",value:"azelf",icon:"azelf"},{name:"Dialga",value:"dialga",icon:"dialga"},{name:"Palkia",value:"palkia",icon:"palkia"},{name:"Heatran",value:"heatran",icon:"heatran"},{name:"Regigigas",value:"regigigas",icon:"regigigas",exclude:["sv"]},{name:"Giratina",value:"giratina",icon:"giratina"},{name:"Cresselia",value:"cresselia",icon:"cresselia"},{name:"Phione",value:"phione",icon:"phione",exclude:["swsh","sv"]},{name:"Manaphy",value:"manaphy",icon:"manaphy",exclude:["swsh","sv"]},{name:"Darkrai",value:"darkrai",icon:"darkrai",exclude:["swsh","sv"]},{name:"Shaymin",value:"shaymin",icon:"shaymin",exclude:["swsh","sv"]},{name:"Arceus",value:"arceus",icon:"arceus",exclude:["swsh"]},{name:"Victini",value:"victini",icon:"victini",exclude:["sv"]},{name:"Snivy",value:"snivy",icon:"snivy",exclude:["swsh","sv"]},{name:"Servine",value:"servine",icon:"servine",exclude:["swsh","sv"]},{name:"Serperior",value:"serperior",icon:"serperior",exclude:["swsh","sv"]},{name:"Tepig",value:"tepig",icon:"tepig",exclude:["swsh","sv"]},{name:"Pignite",value:"pignite",icon:"pignite",exclude:["swsh","sv"]},{name:"Emboar",value:"emboar",icon:"emboar",exclude:["swsh","sv"]},{name:"Oshawott",value:"oshawott",icon:"oshawott",exclude:["swsh"]},{name:"Dewott",value:"dewott",icon:"dewott",exclude:["swsh"]},{name:"Samurott",value:"samurott",icon:"samurott",exclude:["swsh"]},{name:"Patrat",value:"patrat",icon:"patrat",exclude:["swsh","sv"]},{name:"Watchog",value:"watchog",icon:"watchog",exclude:["swsh","sv"]},{name:"Lillipup",value:"lillipup",icon:"lillipup",exclude:["sv"]},{name:"Herdier",value:"herdier",icon:"herdier",exclude:["sv"]},{name:"Stoutland",value:"stoutland",icon:"stoutland",exclude:["sv"]},{name:"Purrloin",value:"purrloin",icon:"purrloin",exclude:["sv"]},{name:"Liepard",value:"liepard",icon:"liepard",exclude:["sv"]},{name:"Pansage",value:"pansage",icon:"pansage",exclude:["swsh","sv"]},{name:"Simisage",value:"simisage",icon:"simisage",exclude:["swsh","sv"]},{name:"Pansear",value:"pansear",icon:"pansear",exclude:["swsh","sv"]},{name:"Simisear",value:"simisear",icon:"simisear",exclude:["swsh","sv"]},{name:"Panpour",value:"panpour",icon:"panpour",exclude:["swsh","sv"]},{name:"Simipour",value:"simipour",icon:"simipour",exclude:["swsh","sv"]},{name:"Munna",value:"munna",icon:"munna",exclude:["sv"]},{name:"Musharna",value:"musharna",icon:"musharna",exclude:["sv"]},{name:"Pidove",value:"pidove",icon:"pidove",exclude:["sv"]},{name:"Tranquill",value:"tranquill",icon:"tranquill",exclude:["sv"]},{name:"Unfezant",value:"unfezant",icon:"unfezant",exclude:["sv"]},{name:"Blitzle",value:"blitzle",icon:"blitzle",exclude:["swsh","sv"]},{name:"Zebstrika",value:"zebstrika",icon:"zebstrika",exclude:["swsh","sv"]},{name:"Roggenrola",value:"roggenrola",icon:"roggenrola",exclude:["sv"]},{name:"Boldore",value:"boldore",icon:"boldore",exclude:["sv"]},{name:"Gigalith",value:"gigalith",icon:"gigalith",exclude:["sv"]},{name:"Woobat",value:"woobat",icon:"woobat",exclude:["sv"]},{name:"Swoobat",value:"swoobat",icon:"swoobat",exclude:["sv"]},{name:"Drilbur",value:"drilbur",icon:"drilbur",exclude:["sv"]},{name:"Excadrill",value:"excadrill",icon:"excadrill",exclude:["sv"]},{name:"Audino",value:"audino",icon:"audino",exclude:["sv"]},{name:"Timburr",value:"timburr",icon:"timburr",exclude:["sv"]},{name:"Gurdurr",value:"gurdurr",icon:"gurdurr",exclude:["sv"]},{name:"Conkeldurr",value:"conkeldurr",icon:"conkeldurr",exclude:["sv"]},{name:"Tympole",value:"tympole",icon:"tympole",exclude:["sv"]},{name:"Palpitoad",value:"palpitoad",icon:"palpitoad",exclude:["sv"]},{name:"Seismitoad",value:"seismitoad",icon:"seismitoad",exclude:["sv"]},{name:"Throh",value:"throh",icon:"throh",exclude:["sv"]},{name:"Sawk",value:"sawk",icon:"sawk",exclude:["sv"]},{name:"Sewaddle",value:"sewaddle",icon:"sewaddle",exclude:["swsh","sv"]},{name:"Swadloon",value:"swadloon",icon:"swadloon",exclude:["swsh","sv"]},{name:"Leavanny",value:"leavanny",icon:"leavanny",exclude:["swsh","sv"]},{name:"Venipede",value:"venipede",icon:"venipede",exclude:["sv"]},{name:"Whirlipede",value:"whirlipede",icon:"whirlipede",exclude:["sv"]},{name:"Scolipede",value:"scolipede",icon:"scolipede",exclude:["sv"]},{name:"Cottonee",value:"cottonee",icon:"cottonee",exclude:["sv"]},{name:"Whimsicott",value:"whimsicott",icon:"whimsicott",exclude:["sv"]},{name:"Petilil",value:"petilil",icon:"petilil"},{name:"Lilligant",value:"lilligant",icon:"lilligant"},{name:"Basculin",value:"basculin",icon:"basculin"},{name:"Sandile",value:"sandile",icon:"sandile"},{name:"Krokorok",value:"krokorok",icon:"krokorok"},{name:"Krookodile",value:"krookodile",icon:"krookodile"},{name:"Darumaka",value:"darumaka",icon:"darumaka",exclude:["sv"]},{name:"Darmanitan",value:"darmanitan",icon:"darmanitan",exclude:["sv"]},{name:"Maractus",value:"maractus",icon:"maractus",exclude:["sv"]},{name:"Dwebble",value:"dwebble",icon:"dwebble",exclude:["sv"]},{name:"Crustle",value:"crustle",icon:"crustle",exclude:["sv"]},{name:"Scraggy",value:"scraggy",icon:"scraggy",exclude:["sv"]},{name:"Scrafty",value:"scrafty",icon:"scrafty",exclude:["sv"]},{name:"Sigilyph",value:"sigilyph",icon:"sigilyph",exclude:["sv"]},{name:"Yamask",value:"yamask",icon:"yamask",exclude:["sv"]},{name:"Cofagrigus",value:"cofagrigus",icon:"cofagrigus",exclude:["sv"]},{name:"Tirtouga",value:"tirtouga",icon:"tirtouga",exclude:["sv"]},{name:"Carracosta",value:"carracosta",icon:"carracosta",exclude:["sv"]},{name:"Archen",value:"archen",icon:"archen",exclude:["sv"]},{name:"Archeops",value:"archeops",icon:"archeops",exclude:["sv"]},{name:"Trubbish",value:"trubbish",icon:"trubbish",exclude:["sv"]},{name:"Garbodor",value:"garbodor",icon:"garbodor",exclude:["sv"]},{name:"Zorua",value:"zorua",icon:"zorua"},{name:"Zoroark",value:"zoroark",icon:"zoroark"},{name:"Minccino",value:"minccino",icon:"minccino",exclude:["sv"]},{name:"Cinccino",value:"cinccino",icon:"cinccino",exclude:["sv"]},{name:"Gothita",value:"gothita",icon:"gothita"},{name:"Gothorita",value:"gothorita",icon:"gothorita"},{name:"Gothitelle",value:"gothitelle",icon:"gothitelle"},{name:"Solosis",value:"solosis",icon:"solosis",exclude:["sv"]},{name:"Duosion",value:"duosion",icon:"duosion",exclude:["sv"]},{name:"Reuniclus",value:"reuniclus",icon:"reuniclus",exclude:["sv"]},{name:"Ducklett",value:"ducklett",icon:"ducklett",exclude:["swsh","sv"]},{name:"Swanna",value:"swanna",icon:"swanna",exclude:["swsh","sv"]},{name:"Vanillite",value:"vanillite",icon:"vanillite",exclude:["sv"]},{name:"Vanillish",value:"vanillish",icon:"vanillish",exclude:["sv"]},{name:"Vanilluxe",value:"vanilluxe",icon:"vanilluxe",exclude:["sv"]},{name:"Deerling",value:"deerling",icon:"deerling",exclude:["swsh"]},{name:"Sawsbuck",value:"sawsbuck",icon:"sawsbuck",exclude:["swsh"]},{name:"Emolga",value:"emolga",icon:"emolga",exclude:["sv"]},{name:"Karrablast",value:"karrablast",icon:"karrablast",exclude:["sv"]},{name:"Escavalier",value:"escavalier",icon:"escavalier",exclude:["sv"]},{name:"Foongus",value:"foongus",icon:"foongus"},{name:"Amoonguss",value:"amoonguss",icon:"amoonguss"},{name:"Frillish",value:"frillish",icon:"frillish",exclude:["sv"]},{name:"Jellicent",value:"jellicent",icon:"jellicent",exclude:["sv"]},{name:"Alomomola",value:"alomomola",icon:"alomomola",exclude:["swsh"]},{name:"Joltik",value:"joltik",icon:"joltik",exclude:["sv"]},{name:"Galvantula",value:"galvantula",icon:"galvantula",exclude:["sv"]},{name:"Ferroseed",value:"ferroseed",icon:"ferroseed",exclude:["sv"]},{name:"Ferrothorn",value:"ferrothorn",icon:"ferrothorn",exclude:["sv"]},{name:"Klink",value:"klink",icon:"klink",exclude:["sv"]},{name:"Klang",value:"klang",icon:"klang",exclude:["sv"]},{name:"Klinklang",value:"klinklang",icon:"klinklang",exclude:["sv"]},{name:"Tynamo",value:"tynamo",icon:"tynamo",exclude:["swsh"]},{name:"Eelektrik",value:"eelektrik",icon:"eelektrik",exclude:["swsh"]},{name:"Eelektross",value:"eelektross",icon:"eelektross",exclude:["swsh"]},{name:"Elgyem",value:"elgyem",icon:"elgyem",exclude:["sv"]},{name:"Beheeyem",value:"beheeyem",icon:"beheeyem",exclude:["sv"]},{name:"Litwick",value:"litwick",icon:"litwick",exclude:["sv"]},{name:"Lampent",value:"lampent",icon:"lampent",exclude:["sv"]},{name:"Chandelure",value:"chandelure",icon:"chandelure",exclude:["sv"]},{name:"Axew",value:"axew",icon:"axew"},{name:"Fraxure",value:"fraxure",icon:"fraxure"},{name:"Haxorus",value:"haxorus",icon:"haxorus"},{name:"Cubchoo",value:"cubchoo",icon:"cubchoo"},{name:"Beartic",value:"beartic",icon:"beartic"},{name:"Cryogonal",value:"cryogonal",icon:"cryogonal"},{name:"Shelmet",value:"shelmet",icon:"shelmet",exclude:["sv"]},{name:"Accelgor",value:"accelgor",icon:"accelgor",exclude:["sv"]},{name:"Stunfisk",value:"stunfisk",icon:"stunfisk",exclude:["sv"]},{name:"Mienfoo",value:"mienfoo",icon:"mienfoo",exclude:["sv"]},{name:"Mienshao",value:"mienshao",icon:"mienshao",exclude:["sv"]},{name:"Druddigon",value:"druddigon",icon:"druddigon",exclude:["sv"]},{name:"Golett",value:"golett",icon:"golett",exclude:["sv"]},{name:"Golurk",value:"golurk",icon:"golurk",exclude:["sv"]},{name:"Pawniard",value:"pawniard",icon:"pawniard"},{name:"Bisharp",value:"bisharp",icon:"bisharp"},{name:"Bouffalant",value:"bouffalant",icon:"bouffalant",exclude:["sv"]},{name:"Rufflet",value:"rufflet",icon:"rufflet"},{name:"Braviary",value:"braviary",icon:"braviary"},{name:"Vullaby",value:"vullaby",icon:"vullaby",exclude:["sv"]},{name:"Mandibuzz",value:"mandibuzz",icon:"mandibuzz",exclude:["sv"]},{name:"Heatmor",value:"heatmor",icon:"heatmor",exclude:["sv"]},{name:"Durant",value:"durant",icon:"durant",exclude:["sv"]},{name:"Deino",value:"deino",icon:"deino"},{name:"Zweilous",value:"zweilous",icon:"zweilous"},{name:"Hydreigon",value:"hydreigon",icon:"hydreigon"},{name:"Larvesta",value:"larvesta",icon:"larvesta"},{name:"Volcarona",value:"volcarona",icon:"volcarona"},{name:"Cobalion",value:"cobalion",icon:"cobalion",exclude:["sv"]},{name:"Terrakion",value:"terrakion",icon:"terrakion",exclude:["sv"]},{name:"Virizion",value:"virizion",icon:"virizion",exclude:["sv"]},{name:"Tornadus",value:"tornadus",icon:"tornadus"},{name:"Thundurus",value:"thundurus",icon:"thundurus"},{name:"Reshiram",value:"reshiram",icon:"reshiram",exclude:["sv"]},{name:"Zekrom",value:"zekrom",icon:"zekrom",exclude:["sv"]},{name:"Landorus",value:"landorus",icon:"landorus"},{name:"Kyurem",value:"kyurem",icon:"kyurem",exclude:["sv"]},{name:"Keldeo",value:"keldeo",icon:"keldeo",exclude:["sv"]},{name:"Meloetta",value:"meloetta",icon:"meloetta",exclude:["swsh"]},{name:"Genesect",value:"genesect",icon:"genesect",exclude:["sv"]},{name:"Chespin",value:"chespin",icon:"chespin",exclude:["swsh"]},{name:"Quilladin",value:"quilladin",icon:"quilladin",exclude:["swsh"]},{name:"Chesnaught",value:"chesnaught",icon:"chesnaught",exclude:["swsh"]},{name:"Fennekin",value:"fennekin",icon:"fennekin",exclude:["swsh"]},{name:"Braixen",value:"braixen",icon:"braixen",exclude:["swsh"]},{name:"Delphox",value:"delphox",icon:"delphox",exclude:["swsh"]},{name:"Froakie",value:"froakie",icon:"froakie",exclude:["swsh"]},{name:"Frogadier",value:"frogadier",icon:"frogadier",exclude:["swsh"]},{name:"Greninja",value:"greninja",icon:"greninja",exclude:["swsh"]},{name:"Bunnelby",value:"bunnelby",icon:"bunnelby",exclude:["sv"]},{name:"Diggersby",value:"diggersby",icon:"diggersby",exclude:["sv"]},{name:"Fletchling",value:"fletchling",icon:"fletchling"},{name:"Fletchinder",value:"fletchinder",icon:"fletchinder"},{name:"Talonflame",value:"talonflame",icon:"talonflame"},{name:"Scatterbug",value:"scatterbug",icon:"scatterbug",exclude:["swsh"]},{name:"Spewpa",value:"spewpa",icon:"spewpa",exclude:["swsh"]},{name:"Vivillon",value:"vivillon",icon:"vivillon",exclude:["swsh"]},{name:"Litleo",value:"litleo",icon:"litleo",exclude:["swsh"]},{name:"Pyroar",value:"pyroar",icon:"pyroar",exclude:["swsh"]},{name:"Flabébé",value:"flabebe",icon:"flabebe",exclude:["swsh"]},{name:"Floette",value:"floette",icon:"floette",exclude:["swsh"]},{name:"Florges",value:"florges",icon:"florges",exclude:["swsh"]},{name:"Skiddo",value:"skiddo",icon:"skiddo",exclude:["swsh"]},{name:"Gogoat",value:"gogoat",icon:"gogoat",exclude:["swsh"]},{name:"Pancham",value:"pancham",icon:"pancham",exclude:["sv"]},{name:"Pangoro",value:"pangoro",icon:"pangoro",exclude:["sv"]},{name:"Furfrou",value:"furfrou",icon:"furfrou",exclude:["swsh","sv"]},{name:"Espurr",value:"espurr",icon:"espurr",exclude:["sv"]},{name:"Meowstic",value:"meowstic",icon:"meowstic",exclude:["sv"]},{name:"Honedge",value:"honedge",icon:"honedge",exclude:["sv"]},{name:"Doublade",value:"doublade",icon:"doublade",exclude:["sv"]},{name:"Aegislash",value:"aegislash",icon:"aegislash",exclude:["sv"]},{name:"Spritzee",value:"spritzee",icon:"spritzee",exclude:["sv"]},{name:"Aromatisse",value:"aromatisse",icon:"aromatisse",exclude:["sv"]},{name:"Swirlix",value:"swirlix",icon:"swirlix",exclude:["sv"]},{name:"Slurpuff",value:"slurpuff",icon:"slurpuff",exclude:["sv"]},{name:"Inkay",value:"inkay",icon:"inkay",exclude:["sv"]},{name:"Malamar",value:"malamar",icon:"malamar",exclude:["sv"]},{name:"Binacle",value:"binacle",icon:"binacle",exclude:["sv"]},{name:"Barbaracle",value:"barbaracle",icon:"barbaracle",exclude:["sv"]},{name:"Skrelp",value:"skrelp",icon:"skrelp"},{name:"Dragalge",value:"dragalge",icon:"dragalge"},{name:"Clauncher",value:"clauncher",icon:"clauncher"},{name:"Clawitzer",value:"clawitzer",icon:"clawitzer"},{name:"Helioptile",value:"helioptile",icon:"helioptile",exclude:["sv"]},{name:"Heliolisk",value:"heliolisk",icon:"heliolisk",exclude:["sv"]},{name:"Tyrunt",value:"tyrunt",icon:"tyrunt",exclude:["sv"]},{name:"Tyrantrum",value:"tyrantrum",icon:"tyrantrum",exclude:["sv"]},{name:"Amaura",value:"amaura",icon:"amaura",exclude:["sv"]},{name:"Aurorus",value:"aurorus",icon:"aurorus",exclude:["sv"]},{name:"Sylveon",value:"sylveon",icon:"sylveon"},{name:"Hawlucha",value:"hawlucha",icon:"hawlucha"},{name:"Dedenne",value:"dedenne",icon:"dedenne"},{name:"Carbink",value:"carbink",icon:"carbink"},{name:"Goomy",value:"goomy",icon:"goomy"},{name:"Sliggoo",value:"sliggoo",icon:"sliggoo"},{name:"Goodra",value:"goodra",icon:"goodra"},{name:"Klefki",value:"klefki",icon:"klefki"},{name:"Phantump",value:"phantump",icon:"phantump",exclude:["sv"]},{name:"Trevenant",value:"trevenant",icon:"trevenant",exclude:["sv"]},{name:"Pumpkaboo",value:"pumpkaboo",icon:"pumpkaboo",exclude:["sv"]},{name:"Gourgeist",value:"gourgeist",icon:"gourgeist",exclude:["sv"]},{name:"Bergmite",value:"bergmite",icon:"bergmite"},{name:"Avalugg",value:"avalugg",icon:"avalugg"},{name:"Noibat",value:"noibat",icon:"noibat"},{name:"Noivern",value:"noivern",icon:"noivern"},{name:"Xerneas",value:"xerneas",icon:"xerneas",exclude:["sv"]},{name:"Yveltal",value:"yveltal",icon:"yveltal",exclude:["sv"]},{name:"Zygarde",value:"zygarde",icon:"zygarde",exclude:["sv"]},{name:"Diancie",value:"diancie",icon:"diancie"},{name:"Hoopa",value:"hoopa",icon:"hoopa",exclude:["swsh"]},{name:"Volcanion",value:"volcanion",icon:"volcanion"},{name:"Rowlet",value:"rowlet",icon:"rowlet"},{name:"Dartrix",value:"dartrix",icon:"dartrix"},{name:"Decidueye",value:"decidueye",icon:"decidueye"},{name:"Litten",value:"litten",icon:"litten",exclude:["sv"]},{name:"Torracat",value:"torracat",icon:"torracat",exclude:["sv"]},{name:"Incineroar",value:"incineroar",icon:"incineroar",exclude:["sv"]},{name:"Popplio",value:"popplio",icon:"popplio",exclude:["sv"]},{name:"Brionne",value:"brionne",icon:"brionne",exclude:["sv"]},{name:"Primarina",value:"primarina",icon:"primarina",exclude:["sv"]},{name:"Pikipek",value:"pikipek",icon:"pikipek",exclude:["swsh","sv"]},{name:"Trumbeak",value:"trumbeak",icon:"trumbeak",exclude:["swsh","sv"]},{name:"Toucannon",value:"toucannon",icon:"toucannon",exclude:["swsh","sv"]},{name:"Yungoos",value:"yungoos",icon:"yungoos",exclude:["swsh"]},{name:"Gumshoos",value:"gumshoos",icon:"gumshoos",exclude:["swsh"]},{name:"Grubbin",value:"grubbin",icon:"grubbin",exclude:["sv"]},{name:"Charjabug",value:"charjabug",icon:"charjabug",exclude:["sv"]},{name:"Vikavolt",value:"vikavolt",icon:"vikavolt",exclude:["sv"]},{name:"Crabrawler",value:"crabrawler",icon:"crabrawler",exclude:["swsh"]},{name:"Crabominable",value:"crabominable",icon:"crabominable",exclude:["swsh"]},{name:"Oricorio",value:"oricorio",icon:"oricorio",exclude:["swsh"]},{name:"Cutiefly",value:"cutiefly",icon:"cutiefly",exclude:["sv"]},{name:"Ribombee",value:"ribombee",icon:"ribombee",exclude:["sv"]},{name:"Rockruff",value:"rockruff",icon:"rockruff"},{name:"Lycanroc",value:"lycanroc",icon:"lycanroc"},{name:"Wishiwashi",value:"wishiwashi",icon:"wishiwashi",exclude:["sv"]},{name:"Mareanie",value:"mareanie",icon:"mareanie"},{name:"Toxapex",value:"toxapex",icon:"toxapex"},{name:"Mudbray",value:"mudbray",icon:"mudbray"},{name:"Mudsdale",value:"mudsdale",icon:"mudsdale"},{name:"Dewpider",value:"dewpider",icon:"dewpider",exclude:["sv"]},{name:"Araquanid",value:"araquanid",icon:"araquanid",exclude:["sv"]},{name:"Fomantis",value:"fomantis",icon:"fomantis"},{name:"Lurantis",value:"lurantis",icon:"lurantis"},{name:"Morelull",value:"morelull",icon:"morelull",exclude:["sv"]},{name:"Shiinotic",value:"shiinotic",icon:"shiinotic",exclude:["sv"]},{name:"Salandit",value:"salandit",icon:"salandit"},{name:"Salazzle",value:"salazzle",icon:"salazzle"},{name:"Stufful",value:"stufful",icon:"stufful",exclude:["sv"]},{name:"Bewear",value:"bewear",icon:"bewear",exclude:["sv"]},{name:"Bounsweet",value:"bounsweet",icon:"bounsweet"},{name:"Steenee",value:"steenee",icon:"steenee"},{name:"Tsareena",value:"tsareena",icon:"tsareena"},{name:"Comfey",value:"comfey",icon:"comfey",exclude:["sv"]},{name:"Oranguru",value:"oranguru",icon:"oranguru"},{name:"Passimian",value:"passimian",icon:"passimian"},{name:"Wimpod",value:"wimpod",icon:"wimpod",exclude:["sv"]},{name:"Golisopod",value:"golisopod",icon:"golisopod",exclude:["sv"]},{name:"Sandygast",value:"sandygast",icon:"sandygast"},{name:"Palossand",value:"palossand",icon:"palossand"},{name:"Pyukumuku",value:"pyukumuku",icon:"pyukumuku",exclude:["sv"]},{name:"Type: Null",value:"type-null",icon:"type-null",exclude:["sv"]},{name:"Silvally",value:"silvally",icon:"silvally",exclude:["sv"]},{name:"Minior",value:"minior",icon:"minior",exclude:["swsh","sv"]},{name:"Komala",value:"komala",icon:"komala",exclude:["swsh"]},{name:"Turtonator",value:"turtonator",icon:"turtonator",exclude:["sv"]},{name:"Togedemaru",value:"togedemaru",icon:"togedemaru",exclude:["sv"]},{name:"Mimikyu",value:"mimikyu",icon:"mimikyu"},{name:"Bruxish",value:"bruxish",icon:"bruxish",exclude:["swsh"]},{name:"Drampa",value:"drampa",icon:"drampa",exclude:["sv"]},{name:"Dhelmise",value:"dhelmise",icon:"dhelmise",exclude:["sv"]},{name:"Jangmo-o",value:"jangmo-o",icon:"jangmo-o",exclude:["sv"]},{name:"Hakamo-o",value:"hakamo-o",icon:"hakamo-o",exclude:["sv"]},{name:"Kommo-o",value:"kommo-o",icon:"kommo-o",exclude:["sv"]},{name:"Tapu Koko",value:"tapu-koko",icon:"tapu-koko",exclude:["sv"]},{name:"Tapu Lele",value:"tapu-lele",icon:"tapu-lele",exclude:["sv"]},{name:"Tapu Bulu",value:"tapu-bulu",icon:"tapu-bulu",exclude:["sv"]},{name:"Tapu Fini",value:"tapu-fini",icon:"tapu-fini",exclude:["sv"]},{name:"Cosmog",value:"cosmog",icon:"cosmog",exclude:["sv"]},{name:"Cosmoem",value:"cosmoem",icon:"cosmoem",exclude:["sv"]},{name:"Solgaleo",value:"solgaleo",icon:"solgaleo",exclude:["sv"]},{name:"Lunala",value:"lunala",icon:"lunala",exclude:["sv"]},{name:"Nihilego",value:"nihilego",icon:"nihilego",exclude:["sv"]},{name:"Buzzwole",value:"buzzwole",icon:"buzzwole",exclude:["sv"]},{name:"Pheromosa",value:"pheromosa",icon:"pheromosa",exclude:["sv"]},{name:"Xurkitree",value:"xurkitree",icon:"xurkitree",exclude:["sv"]},{name:"Celesteela",value:"celesteela",icon:"celesteela",exclude:["sv"]},{name:"Kartana",value:"kartana",icon:"kartana",exclude:["sv"]},{name:"Guzzlord",value:"guzzlord",icon:"guzzlord",exclude:["sv"]},{name:"Necrozma",value:"necrozma",icon:"necrozma",exclude:["sv"]},{name:"Magearna",value:"magearna",icon:"magearna"},{name:"Marshadow",value:"marshadow",icon:"marshadow",exclude:["sv"]},{name:"Poipole",value:"poipole",icon:"poipole",exclude:["sv"]},{name:"Naganadel",value:"naganadel",icon:"naganadel",exclude:["sv"]},{name:"Stakataka",value:"stakataka",icon:"stakataka",exclude:["sv"]},{name:"Blacephalon",value:"blacephalon",icon:"blacephalon",exclude:["sv"]},{name:"Zeraora",value:"zeraora",icon:"zeraora",exclude:["sv"]},{name:"Meltan",value:"meltan",icon:"meltan",exclude:["sv"]},{name:"Melmetal",value:"melmetal",icon:"melmetal",exclude:["sv"]},{name:"Grookey",value:"grookey",icon:"grookey"},{name:"Thwackey",value:"thwackey",icon:"thwackey"},{name:"Rillaboom",value:"rillaboom",icon:"rillaboom"},{name:"Scorbunny",value:"scorbunny",icon:"scorbunny"},{name:"Raboot",value:"raboot",icon:"raboot"},{name:"Cinderace",value:"cinderace",icon:"cinderace"},{name:"Sobble",value:"sobble",icon:"sobble"},{name:"Drizzile",value:"drizzile",icon:"drizzile"},{name:"Inteleon",value:"inteleon",icon:"inteleon"},{name:"Skwovet",value:"skwovet",icon:"skwovet"},{name:"Greedent",value:"greedent",icon:"greedent"},{name:"Rookidee",value:"rookidee",icon:"rookidee"},{name:"Corvisquire",value:"corvisquire",icon:"corvisquire"},{name:"Corviknight",value:"corviknight",icon:"corviknight"},{name:"Blipbug",value:"blipbug",icon:"blipbug",exclude:["sv"]},{name:"Dottler",value:"dottler",icon:"dottler",exclude:["sv"]},{name:"Orbeetle",value:"orbeetle",icon:"orbeetle",exclude:["sv"]},{name:"Nickit",value:"nickit",icon:"nickit",exclude:["sv"]},{name:"Thievul",value:"thievul",icon:"thievul",exclude:["sv"]},{name:"Gossifleur",value:"gossifleur",icon:"gossifleur",exclude:["sv"]},{name:"Eldegoss",value:"eldegoss",icon:"eldegoss",exclude:["sv"]},{name:"Wooloo",value:"wooloo",icon:"wooloo",exclude:["sv"]},{name:"Dubwool",value:"dubwool",icon:"dubwool",exclude:["sv"]},{name:"Chewtle",value:"chewtle",icon:"chewtle"},{name:"Drednaw",value:"drednaw",icon:"drednaw"},{name:"Yamper",value:"yamper",icon:"yamper",exclude:["sv"]},{name:"Boltund",value:"boltund",icon:"boltund",exclude:["sv"]},{name:"Rolycoly",value:"rolycoly",icon:"rolycoly"},{name:"Carkol",value:"carkol",icon:"carkol"},{name:"Coalossal",value:"coalossal",icon:"coalossal"},{name:"Applin",value:"applin",icon:"applin"},{name:"Flapple",value:"flapple",icon:"flapple"},{name:"Appletun",value:"appletun",icon:"appletun"},{name:"Silicobra",value:"silicobra",icon:"silicobra"},{name:"Sandaconda",value:"sandaconda",icon:"sandaconda"},{name:"Cramorant",value:"cramorant",icon:"cramorant",exclude:["sv"]},{name:"Arrokuda",value:"arrokuda",icon:"arrokuda"},{name:"Barraskewda",value:"barraskewda",icon:"barraskewda"},{name:"Toxel",value:"toxel",icon:"toxel"},{name:"Toxtricity",value:"toxtricity",icon:"toxtricity"},{name:"Sizzlipede",value:"sizzlipede",icon:"sizzlipede",exclude:["sv"]},{name:"Centiskorch",value:"centiskorch",icon:"centiskorch",exclude:["sv"]},{name:"Clobbopus",value:"clobbopus",icon:"clobbopus",exclude:["sv"]},{name:"Grapploct",value:"grapploct",icon:"grapploct",exclude:["sv"]},{name:"Sinistea",value:"sinistea",icon:"sinistea"},{name:"Polteageist",value:"polteageist",icon:"polteageist"},{name:"Hatenna",value:"hatenna",icon:"hatenna"},{name:"Hattrem",value:"hattrem",icon:"hattrem"},{name:"Hatterene",value:"hatterene",icon:"hatterene"},{name:"Impidimp",value:"impidimp",icon:"impidimp"},{name:"Morgrem",value:"morgrem",icon:"morgrem"},{name:"Grimmsnarl",value:"grimmsnarl",icon:"grimmsnarl"},{name:"Obstagoon",value:"obstagoon",icon:"obstagoon",exclude:["sv"]},{name:"Perrserker",value:"perrserker",icon:"perrserker"},{name:"Cursola",value:"cursola",icon:"cursola",exclude:["sv"]},{name:"Sirfetch'd",value:"sirfetchd",icon:"sirfetchd",exclude:["sv"]},{name:"Mr. Rime",value:"mr-rime",icon:"mr-rime",exclude:["sv"]},{name:"Runerigus",value:"runerigus",icon:"runerigus",exclude:["sv"]},{name:"Milcery",value:"milcery",icon:"milcery",exclude:["sv"]},{name:"Alcremie",value:"alcremie",icon:"alcremie",exclude:["sv"]},{name:"Falinks",value:"falinks",icon:"falinks"},{name:"Pincurchin",value:"pincurchin",icon:"pincurchin"},{name:"Snom",value:"snom",icon:"snom"},{name:"Frosmoth",value:"frosmoth",icon:"frosmoth"},{name:"Stonjourner",value:"stonjourner",icon:"stonjourner"},{name:"Eiscue",value:"eiscue",icon:"eiscue"},{name:"Indeedee",value:"indeedee",icon:"indeedee"},{name:"Morpeko",value:"morpeko",icon:"morpeko",exclude:["sv"]},{name:"Cufant",value:"cufant",icon:"cufant"},{name:"Copperajah",value:"copperajah",icon:"copperajah"},{name:"Dracozolt",value:"dracozolt",icon:"dracozolt",exclude:["sv"]},{name:"Arctozolt",value:"arctozolt",icon:"arctozolt",exclude:["sv"]},{name:"Dracovish",value:"dracovish",icon:"dracovish",exclude:["sv"]},{name:"Arctovish",value:"arctovish",icon:"arctovish",exclude:["sv"]},{name:"Duraludon",value:"duraludon",icon:"duraludon",exclude:["sv"]},{name:"Dreepy",value:"dreepy",icon:"dreepy"},{name:"Drakloak",value:"drakloak",icon:"drakloak"},{name:"Dragapult",value:"dragapult",icon:"dragapult"},{name:"Zacian",value:"zacian",icon:"zacian"},{name:"Zamazenta",value:"zamazenta",icon:"zamazenta"},{name:"Eternatus",value:"eternatus",icon:"eternatus"},{name:"Kubfu",value:"kubfu",icon:"kubfu"},{name:"Urshifu",value:"urshifu",icon:"urshifu"},{name:"Zarude",value:"zarude",icon:"zarude"},{name:"Regieleki",value:"regieleki",icon:"regieleki"},{name:"Regidrago",value:"regidrago",icon:"regidrago"},{name:"Glastrier",value:"glastrier",icon:"glastrier"},{name:"Spectrier",value:"spectrier",icon:"spectrier"},{name:"Calyrex",value:"calyrex",icon:"calyrex"},{name:"Wyrdeer",value:"wyrdeer",icon:"wyrdeer"},{name:"Kleavor",value:"kleavor",icon:"kleavor"},{name:"Ursaluna",value:"ursaluna",icon:"ursaluna"},{name:"Basculegion",value:"basculegion",icon:"basculegion"},{name:"Sneasler",value:"sneasler",icon:"sneasler"},{name:"Overqwil",value:"overqwil",icon:"overqwil"},{name:"Enamorus",value:"enamorus",icon:"enamorus"},{name:"Sprigatito",value:"sprigatito",icon:"sprigatito"},{name:"Floragato",value:"floragato",icon:"floragato"},{name:"Meowscarada",value:"meowscarada",icon:"meowscarada"},{name:"Fuecoco",value:"fuecoco",icon:"fuecoco"},{name:"Crocalor",value:"crocalor",icon:"crocalor"},{name:"Skeledirge",value:"skeledirge",icon:"skeledirge"},{name:"Quaxly",value:"quaxly",icon:"quaxly"},{name:"Quaxwell",value:"quaxwell",icon:"quaxwell"},{name:"Quaquaval",value:"quaquaval",icon:"quaquaval"},{name:"Lechonk",value:"lechonk",icon:"lechonk"},{name:"Oinkologne",value:"oinkologne",icon:"oinkologne"},{name:"Tarountula",value:"tarountula",icon:"tarountula"},{name:"Spidops",value:"spidops",icon:"spidops"},{name:"Nymble",value:"nymble",icon:"nymble"},{name:"Lokix",value:"lokix",icon:"lokix"},{name:"Pawmi",value:"pawmi",icon:"pawmi"},{name:"Pawmo",value:"pawmo",icon:"pawmo"},{name:"Pawmot",value:"pawmot",icon:"pawmot"},{name:"Tandemaus",value:"tandemaus",icon:"tandemaus"},{name:"Maushold",value:"maushold",icon:"maushold"},{name:"Fidough",value:"fidough",icon:"fidough"},{name:"Dachsbun",value:"dachsbun",icon:"dachsbun"},{name:"Smoliv",value:"smoliv",icon:"smoliv"},{name:"Dolliv",value:"dolliv",icon:"dolliv"},{name:"Arboliva",value:"arboliva",icon:"arboliva"},{name:"Squawkabilly",value:"squawkabilly",icon:"squawkabilly"},{name:"Nacli",value:"nacli",icon:"nacli"},{name:"Naclstack",value:"naclstack",icon:"naclstack"},{name:"Garganacl",value:"garganacl",icon:"garganacl"},{name:"Charcadet",value:"charcadet",icon:"charcadet"},{name:"Armarouge",value:"armarouge",icon:"armarouge"},{name:"Ceruledge",value:"ceruledge",icon:"ceruledge"},{name:"Tadbulb",value:"tadbulb",icon:"tadbulb"},{name:"Bellibolt",value:"bellibolt",icon:"bellibolt"},{name:"Wattrel",value:"wattrel",icon:"wattrel"},{name:"Kilowattrel",value:"kilowattrel",icon:"kilowattrel"},{name:"Maschiff",value:"maschiff",icon:"maschiff"},{name:"Mabosstiff",value:"mabosstiff",icon:"mabosstiff"},{name:"Shroodle",value:"shroodle",icon:"shroodle"},{name:"Grafaiai",value:"grafaiai",icon:"grafaiai"},{name:"Bramblin",value:"bramblin",icon:"bramblin"},{name:"Brambleghast",value:"brambleghast",icon:"brambleghast"},{name:"Toedscool",value:"toedscool",icon:"toedscool"},{name:"Toedscruel",value:"toedscruel",icon:"toedscruel"},{name:"Klawf",value:"klawf",icon:"klawf"},{name:"Capsakid",value:"capsakid",icon:"capsakid"},{name:"Scovillain",value:"scovillain",icon:"scovillain"},{name:"Rellor",value:"rellor",icon:"rellor"},{name:"Rabsca",value:"rabsca",icon:"rabsca"},{name:"Flittle",value:"flittle",icon:"flittle"},{name:"Espathra",value:"espathra",icon:"espathra"},{name:"Tinkatink",value:"tinkatink",icon:"tinkatink"},{name:"Tinkatuff",value:"tinkatuff",icon:"tinkatuff"},{name:"Tinkaton",value:"tinkaton",icon:"tinkaton"},{name:"Wiglett",value:"wiglett",icon:"wiglett"},{name:"Wugtrio",value:"wugtrio",icon:"wugtrio"},{name:"Bombirdier",value:"bombirdier",icon:"bombirdier"},{name:"Finizen",value:"finizen",icon:"finizen"},{name:"Palafin",value:"palafin",icon:"palafin"},{name:"Varoom",value:"varoom",icon:"varoom"},{name:"Revavroom",value:"revavroom",icon:"revavroom"},{name:"Cyclizar",value:"cyclizar",icon:"cyclizar"},{name:"Orthworm",value:"orthworm",icon:"orthworm"},{name:"Glimmet",value:"glimmet",icon:"glimmet"},{name:"Glimmora",value:"glimmora",icon:"glimmora"},{name:"Greavard",value:"greavard",icon:"greavard"},{name:"Houndstone",value:"houndstone",icon:"houndstone"},{name:"Flamigo",value:"flamigo",icon:"flamigo"},{name:"Cetoddle",value:"cetoddle",icon:"cetoddle"},{name:"Cetitan",value:"cetitan",icon:"cetitan"},{name:"Veluza",value:"veluza",icon:"veluza"},{name:"Dondozo",value:"dondozo",icon:"dondozo"},{name:"Tatsugiri",value:"tatsugiri",icon:"tatsugiri"},{name:"Annihilape",value:"annihilape",icon:"annihilape"},{name:"Clodsire",value:"clodsire",icon:"clodsire"},{name:"Farigiraf",value:"farigiraf",icon:"farigiraf"},{name:"Dudunsparce",value:"dudunsparce",icon:"dudunsparce"},{name:"Kingambit",value:"kingambit",icon:"kingambit"},{name:"Great Tusk",value:"greattusk",icon:"greattusk"},{name:"Scream Tail",value:"screamtail",icon:"screamtail"},{name:"Brute Bonnet",value:"brutebonnet",icon:"brutebonnet"},{name:"Flutter Mane",value:"fluttermane",icon:"fluttermane"},{name:"Slither Wing",value:"slitherwing",icon:"slitherwing"},{name:"Sandy Shocks",value:"sandyshocks",icon:"sandyshocks"},{name:"Iron Treads",value:"irontreads",icon:"irontreads"},{name:"Iron Bundle",value:"ironbundle",icon:"ironbundle"},{name:"Iron Hands",value:"ironhands",icon:"ironhands"},{name:"Iron Jugulis",value:"ironjugulis",icon:"ironjugulis"},{name:"Iron Moth",value:"ironmoth",icon:"ironmoth"},{name:"Iron Thorns",value:"ironthorns",icon:"ironthorns"},{name:"Frigibax",value:"frigibax",icon:"frigibax"},{name:"Arctibax",value:"arctibax",icon:"arctibax"},{name:"Baxcalibur",value:"baxcalibur",icon:"baxcalibur"},{name:"Gimmighoul",value:"gimmighoul",icon:"gimmighoul"},{name:"Gholdengo",value:"gholdengo",icon:"gholdengo"},{name:"Wo-Chien",value:"wo-chien",icon:"wo-chien"},{name:"Chien-Pao",value:"chien-pao",icon:"chien-pao"},{name:"Ting-Lu",value:"ting-lu",icon:"ting-lu"},{name:"Chi-Yu",value:"chi-yu",icon:"chi-yu"},{name:"Roaring Moon",value:"roaringmoon",icon:"roaringmoon"},{name:"Iron Valiant",value:"ironvaliant",icon:"ironvaliant"},{name:"Koraidon",value:"koraidon",icon:"koraidon"},{name:"Miraidon",value:"miraidon",icon:"miraidon"}];(function($){$.tablesort=function($table,settings){var self=this;this.$table=$table;this.$thead=this.$table.find("thead");this.settings=$.extend({},$.tablesort.defaults,settings);this.$sortCells=this.$thead.length>0?this.$thead.find("th:not(.no-sort)"):this.$table.find("th:not(.no-sort)");this.$sortCells.on("click.tablesort",(function(){self.sort($(this))}));this.index=null;this.$th=null;this.direction=null};$.tablesort.prototype={sort:function(th,direction){var start=new Date,self=this,table=this.$table,rowsContainer=table.find("tbody").length>0?table.find("tbody"):table,rows=rowsContainer.find("tr").has("td, th"),cells=rows.find(":nth-child("+(th.index()+1)+")").filter("td, th"),sortedMap=[];var unsortedValues=cells.map((function(idx,cell){return $(this).data().sortValue}));if(unsortedValues.length===0)return;if(this.index!==th.index()){this.direction="asc";this.index=th.index()}else if(direction!=="asc"&&direction!=="desc")this.direction=this.direction==="asc"?"desc":"asc";else this.direction=direction;direction=this.direction=="asc"?1:-1;self.$table.trigger("tablesort:start",[self]);self.$table.css("display");setTimeout((function(){self.$sortCells.removeClass(self.settings.asc+" "+self.settings.desc);for(var i=0,length=unsortedValues.length;i<length;i++){sortedMap.push({index:i,cell:cells[i],row:rows[i],value:unsortedValues[i]})}sortedMap.sort((function(a,b){return self.settings.compare(a.value,b.value,direction)*direction}));$.each(sortedMap,(function(i,entry){rowsContainer.append(entry.row)}));th.addClass(self.settings[self.direction]);self.$table.trigger("tablesort:complete",[self]);self.$table.css("display")}),unsortedValues.length>2e3?200:10)},destroy:function(){this.$sortCells.off("click.tablesort");this.$table.data("tablesort",null);return null}};$.tablesort.defaults={asc:"sorted ascending",desc:"sorted descending",compare:function(a,b,direction){if(a===""||a===null)return direction===1?1:-1;if(b===""||b===null)return direction===1?-1:1;if(a===b)return 0;return a<b?-1:1}};$.fn.tablesort=function(settings){var table,sortable,previous;return this.each((function(){table=$(this);previous=table.data("tablesort");if(previous){previous.destroy()}table.data("tablesort",new $.tablesort(table,settings))}))}})(window.jQuery);if(location.protocol==="https:"&&"serviceWorker"in navigator){try{navigator.serviceWorker.register("/nuzlocke-tracker/serviceworker.js",{scope:"/nuzlocke-tracker/"})}catch(e){console.error(e)}}if(!localStorage.getItem("selectedGame")){localStorage.setItem("selectedGame","rby")}let selectedGame=games[localStorage.getItem("selectedGame")]?localStorage.getItem("selectedGame"):"rby";function escapeHTML(str,jsContext){const string=new Option(str).innerHTML;if(jsContext){string.replace(/"/g,'"').replace(/'/g,"'").replace(/\n/g,"\\n").replace(/\/r/g,"\\r")}else{string.replace(/"/g,"&quot;")}return string}function renderMain(){let linksString="";let segmentsString="";for(const game in games){linksString+='<a class="item" data-tab="'+games[game].id+'">'+games[game].title+"</a>";segmentsString+='<div class="ui bottom attached segment tab" data-tab="'+games[game].id+'">'+'<div class="ui secondary stackable menu">'+'<div class="horizontally fitted item">'+'<h2 class="ui header">'+games[game].title+"</h2>"+"</div>"+'<div class="right horizontally fitted item">'+'<button class="ui basic fluid button addLocation"><i class="plus icon"></i>Add location</button>'+'<button class="ui basic icon button gameSettings" title="Game settings"><i class="settings icon"></i></button>'+"</div>"+"</div>"+'<table class="ui table sortable selectable">'+"<thead>"+"<tr>"+'<th class="center aligned four wide">Location</th>'+'<th class="center aligned four wide">Encounter</th>'+'<th class="center aligned four wide">Nickname</th>'+'<th class="center aligned three wide">Status</th>'+'<th class="center aligned no-sort one wide disabled"></th>'+"</tr>"+"</thead>"+'<tbody id="'+games[game].id+'-locations">'+"</tbody>"+"</table>"+"</div>"}return'<div class="ui stackable top attached borderless menu">'+'<div id="gameMenu" class="ui dropdown item">'+'<i class="sidebar icon"></i>'+"Games"+'<i class="dropdown icon"></i>'+'<div class="menu">'+linksString+"</div>"+"</div>"+'<div class="right horizontally fitted item dataControls">'+'<button id="saveData" class="ui green button"><i class="download icon"></i>Export</button>'+'<input id="fileLoader" accept=".json, application/json" type="file">'+'<label id="loadData" class="ui blue button fileInput" for="fileLoader"><i class="upload icon"></i>Import</label>'+'<button id="resetData" class="ui red button"><i class="remove icon"></i>Reset</button>'+"</div>"+"</div>"+segmentsString}function renderLocations(game,darkTheme){string="";game.locations.forEach(((location,index)=>{const locationValue=escapeHTML(location.value);const locationName=localStorage.getItem(game.id+location.value+"-name");const locationEncounter=localStorage.getItem(game.id+location.value+"-encounter");const locationNickname=localStorage.getItem(game.id+location.value+"-nickname");const locationStatus=localStorage.getItem(game.id+location.value+"-status");string+="<tr"+(location.order!==undefined?' class="customLocation"':"")+">"+'<td data-sort-value="'+index+'">'+escapeHTML(location.name)+"</td>"+'<td data-sort-value="'+(locationEncounter?escapeHTML(locationEncounter):"")+'">'+'<div data-name="'+(locationName?escapeHTML(locationName):"")+'" data-value="'+(locationEncounter?escapeHTML(locationEncounter):"")+'" id="'+game.id+locationValue+'-encounter" class="ui'+(darkTheme?" inverted":"")+' fluid search selection long dropdown encounter-picker" aria-label="'+location.name+' encounter">'+'<input value="'+(locationEncounter?escapeHTML(locationEncounter):"")+'" aria-label="'+location.name+' encounter" name="pokemon" type="hidden">'+'<i class="dropdown icon"></i>'+'<div class="default text">Encounter</div>'+'<div class="menu"></div>'+"</div>"+"</td>"+'<td data-sort-value="'+(locationNickname?escapeHTML(locationNickname):"")+'">'+'<div class="ui'+(darkTheme?" inverted":"")+' fluid input">'+'<input autocomplete="off" maxlength="'+game.nameLimit+'" class="nickname-input" value="'+(locationNickname?escapeHTML(locationNickname):"")+'" id="'+game.id+locationValue+'-nickname" name="nickname" placeholder="Nickname" type="text" aria-label="'+location.name+' nickname">'+"</div>"+"</td>"+'<td data-sort-value="'+(locationStatus?escapeHTML(locationStatus):"")+'">'+'<div id="'+game.id+locationValue+'-status" class="ui'+(darkTheme?" inverted":"")+' fluid selection long dropdown" aria-label="'+location.name+' status">'+'<input value="'+(locationStatus?escapeHTML(locationStatus):"")+'" name="status" type="hidden">'+'<i class="dropdown icon"></i>'+'<div class="default text">Status</div>'+'<div class="menu">'+'<div class="item" data-value="captured"><i class="check icon"></i>Captured</div>'+'<div class="item" data-value="received"><i class="gift icon"></i>Received</div>'+'<div class="item" data-value="traded"><i class="exchange icon"></i>Traded</div>'+'<div class="item" data-value="missed"><i class="ban icon"></i>Missed</div>'+'<div class="item" data-value="stored"><i class="hdd icon"></i>Stored</div>'+'<div class="item" data-value="deceased"><i class="skull icon"></i>Deceased</div>'+"</div>"+"</div>"+"</td>"+'<td><div title="Delete" class="ui'+(darkTheme?" inverted":"")+' basic singleReset fluid icon button" data-location-id="'+locationValue+'"><i class="remove icon"></i></div></td>'+"</tr>"}));return string}function resetGame(game,removeLocations){games[selectedGame].locations.forEach((location=>{clearLocation(selectedGame+location.value)}));if(removeLocations){localStorage.removeItem(selectedGame+"-custom-locations");games[selectedGame].locations=games[selectedGame].locations.filter((location=>location.value[0]!=="c"))}}function filterByProperty(array,property){const values={};return array.filter((entry=>{const value=entry[property];if(values[value]!==undefined){return false}else{values[value]=true;return true}}))}function uploadFile(input){if(input.files&&input.files[0]){file=input.files[0];fr=new FileReader;fr.onload=()=>{try{const data=JSON.parse(fr.result);if(data&&data.hasOwnProperty("locations")){const locations=filterByProperty(data.locations,"id");resetGame(data.id,true);$("#disableDexLimit").prop("checked",data.settings&&data.settings.disableDexLimit);toggleDexLimit(data.id);if(data.customLocations.length){const customLocations=filterByProperty(data.customLocations,"value");localStorage.setItem(data.id+"-custom-locations",JSON.stringify(customLocations))}else{localStorage.removeItem(data.id+"-custom-locations")}locations.forEach((location=>{populateLocation(data.id,location)}));updateTab(data.id,true);if(localStorage.getItem("selectedGame")!==data.id){$("#gameMenu .menu").find('.item[data-tab="'+data.id+'"]').click()}}else{$("#errorMessage").removeClass("hidden");$("#messageHeader").text("Incorrect format");$("#messageContent").text("The uploaded file contains invalid data")}}catch(e){console.error(e);$("#errorMessage").removeClass("hidden");$("#messageHeader").text("Could not read file");$("#messageContent").text("The uploaded file was not recognized as valid JSON")}};fr.readAsText(file)}}function populateLocation(game,data){const id=game+data.id;const encounterElm=$("#"+id+"-encounter");const nicknameElm=$("#"+id+"-nickname");const statusElm=$("#"+id+"-status");if(data.encounter){encounterElm.dropdown("set value",data.encounter);encounterElm.dropdown("set text",'<i class="pkmn '+data.encounter+'"></i>'+data.name);encounterElm.data("name",data.name);localStorage.setItem(id+"-encounter",data.encounter);localStorage.setItem(id+"-name",data.name)}else{encounterElm.closest("td").data("sortValue","");encounterElm.dropdown("clear");localStorage.removeItem(id+"-encounter");localStorage.removeItem(id+"-name")}if(data.nickname){nicknameElm.val(data.nickname);localStorage.setItem(id+"-nickname",data.nickname)}else{nicknameElm.val("").closest("td").data("sortValue","");localStorage.removeItem(id+"-nickname")}if(data.status){statusElm.dropdown("set selected",data.status);localStorage.setItem(id+"-status",data.status)}else{statusElm.closest("td").data("sortValue","");statusElm.dropdown("clear");localStorage.removeItem(id+"-status")}}function clearLocation(id){const encounter=id+"-encounter";const nickname=id+"-nickname";const status=id+"-status";const name=id+"-name";$("#"+encounter).dropdown("clear");$("#"+encounter).closest("td").data("sortValue","");$("#"+nickname).val("").closest("td").data("sortValue","");$("#"+status).dropdown("clear");$("#"+status).closest("td").data("sortValue","");localStorage.removeItem(encounter);localStorage.removeItem(nickname);localStorage.removeItem(status);localStorage.removeItem(name)}function sortLocations(game){const locations=games[game].locations.filter((location=>location.value[0]!=="c"));let customLocations=JSON.parse(localStorage.getItem(game+"-custom-locations")||"[]");let initialLength=customLocations.length;if(initialLength){customLocations.sort(((a,b)=>a.order<b.order?-1:a.order>b.order?1:0));while(customLocations.length!==0){const locationRemoval=[];initialLength=customLocations.length;customLocations.forEach(((customLocation,index)=>{const insertIndex=locations.findIndex((e=>e.value==customLocation.order));if(insertIndex!==-1){locations.splice(insertIndex+1,0,customLocations[index]);locationRemoval.push(customLocation.value)}}));customLocations=customLocations.filter((location=>!locationRemoval.includes(location.value)));if(initialLength===customLocations.length){break}}}games[game].locations=locations}function toggleDexLimit(tab){const value=$("#disableDexLimit").prop("checked");if(value){localStorage.setItem(tab+"-disable-dex-limit",true)}else{localStorage.removeItem(tab+"-disable-dex-limit")}}function initTab(tab){$("#"+tab+"-locations .ui.dropdown").dropdown({onChange:function(value,name){$(this).closest("td").data("sortValue",value);localStorage.setItem($(this).prop("id"),value)}});$("#"+tab+"-locations .encounter-picker").dropdown({onChange:function(value,name){const regex=new RegExp(/[^>]*$/,"i");const elm=$(this);if(value&&name){elm.closest("td").data("sortValue",value);elm.data("name",name);localStorage.setItem(elm.prop("id").slice(0,-9)+"name",regex.exec(name));localStorage.setItem(elm.prop("id"),value);elm.find(".search").blur()}},onShow:function(){const value=$(this).dropdown("get value");$(this).dropdown("change values",localStorage.getItem(tab+"-disable-dex-limit")?pkmnData:pkmnData.slice(0,games[tab].dexLimit).filter((pokemon=>pokemon.exclude===undefined||!pokemon.exclude.includes(tab))));if(value){$(this).dropdown("set selected",value);setTimeout((()=>{this.querySelector('[data-value="'+value+'"]').scrollIntoView({block:"center"})}),10)}$(this).find(".search").focus()},onHide:function(){const elm=$(this);const value=elm.dropdown("get value");const name=elm.data("name");elm.find(".search").val("");elm.dropdown("change values",[]);if(value){elm.dropdown("set value",value);elm.dropdown("set text",name)}else{elm.dropdown("restore placeholder text")}},className:{icon:"pkmn"},forceSelection:false,ignoreCase:true,ignoreDiacritics:true,selectOnKeydown:false});$("#"+tab+'-locations .encounter-picker[data-name!=""]').each((function(){const value=escapeHTML($(this).data("value"));$(this).dropdown("set value",value);$(this).dropdown("set text",'<i class="pkmn '+value+'"></i>'+$(this).data("name"))}));$("#"+tab+"-locations").closest("table").tablesort();$("#"+tab+"-locations").closest("table").find("th").first().trigger("click")}function saveData(game){const blobData={id:game,locations:[],customLocations:JSON.parse(localStorage.getItem(game+"-custom-locations")||"[]"),settings:{}};if(localStorage.getItem(game+"-disable-dex-limit")){blobData.settings.disableDexLimit=true}games[game].locations.forEach((location=>{const encounter=localStorage.getItem(game+location.value+"-encounter");const name=localStorage.getItem(game+location.value+"-name");const nickname=localStorage.getItem(game+location.value+"-nickname");const status=localStorage.getItem(game+location.value+"-status");if(encounter||name||nickname||status){blobData.locations.push({id:location.value,encounter:encounter,name:name,nickname:nickname,status:status})}}));const link=document.createElement("a");const blob=new Blob([JSON.stringify(blobData)],{type:"application/json;charset=utf-8"});link.setAttribute("href",URL.createObjectURL(blob));link.setAttribute("download",game+"."+(new Date).toISOString().slice(0,10)+".json");link.click()}function addLocation(location,game){const customLocations=JSON.parse(localStorage.getItem(game+"-custom-locations")||"[]");if(customLocations.length){location.value="c"+(parseInt(customLocations[customLocations.length-1].value.slice(1))+1)}else{location.value="c0"}const duplicateLocationOrder=customLocations.findIndex((e=>e.order==location.order));if(duplicateLocationOrder!==-1){customLocations[duplicateLocationOrder].order=location.value}customLocations.push(location);localStorage.setItem(game+"-custom-locations",JSON.stringify(customLocations));updateTab(game,true)}function removeLocation(value,game){const customLocations=JSON.parse(localStorage.getItem(game+"-custom-locations")||"[]");const location=customLocations.find((location=>location.value==value));const dependantLocation=customLocations.findIndex((e=>e.order==location.value));if(dependantLocation!==-1){customLocations[dependantLocation].order=location.order}customLocations.splice(customLocations.findIndex((e=>e.value==location.value)),1);localStorage.setItem(game+"-custom-locations",JSON.stringify(customLocations));updateTab(game,true)}function updateTab(game,updateDropdown){sortLocations(game);$("#"+game+"-locations").html(renderLocations(games[game],localStorage.getItem("darkTheme")==="true"));initTab(game);if(updateDropdown){updateLocationDropdown()}games[game].loaded=true}function updateLocationDropdown(){const locations=[];games[selectedGame].locations.forEach((location=>{locations.push({name:"After "+escapeHTML(location.name),value:location.value})}));$("#locationOrder").dropdown("change values",locations);$("#locationOrder").dropdown("set selected","0")}sortLocations(selectedGame);const darkTheme=localStorage.getItem("darkTheme")==="true";$("#dark-theme").prop("checked",darkTheme).on("change",(function(){localStorage.setItem("darkTheme",this.checked);document.body.classList.toggle("dark-theme",this.checked);if(this.checked){$(".ui:not(.footer)").addClass("inverted")}else{$(".ui:not(.footer)").removeClass("inverted")}}));$("#disableDexLimit").on("change",(()=>{toggleDexLimit(selectedGame)}));document.body.classList.toggle("dark-theme",darkTheme);if(darkTheme){$(".ui.loading.segment").addClass("inverted")}$((()=>{$(document).on("click","#saveData",(()=>{saveData(selectedGame)})).on("click",".singleReset.button",(function(){const id=selectedGame+$(this).data("locationId");if($(this).closest("tr").hasClass("customLocation")){$("#clearModal").data("target",$(this).data("locationId"));$("#clearModal").modal("show")}else{clearLocation(id)}})).on("change",".nickname-input",(function(){const elm=$(this);if(elm.val()){elm.closest("td").data("sortValue",elm.val());localStorage.setItem(elm.prop("id"),elm.val())}else{elm.closest("td").data("sortValue","");localStorage.removeItem(elm.prop("id"))}}));$("#resetModal").modal({onApprove:e=>{resetGame(selectedGame,e.data("action")==="remove");updateTab(selectedGame,true)}});$("#clearModal").modal({onApprove:function(e){if(e.data("action")==="clear"){clearLocation(selectedGame+$(this).data("target"))}else if(e.data("action")==="remove"){clearLocation(selectedGame+$(this).data("target"));removeLocation($(this).data("target"),selectedGame)}$(this).removeData("target")}});$("#importModal").modal({onApprove:()=>{uploadFile($("#fileLoader")[0])}});$("#customLocationName").on("input",(function(){$(this).parent(".field").toggleClass("error",false)}));$("#locationModal").modal({onApprove:()=>{const locationName=$("#customLocationName").val().trim();$("#customLocationName").parent().toggleClass("error",locationName==false);if(locationName==false){return false}addLocation({name:locationName,order:$("#locationOrder").dropdown("get value")||"0"},selectedGame);$("#customLocationName").val("");$("#locationOrder").dropdown("set selected","0")}});$(".message .close").on("click",(function(){$(this).closest(".message").transition("fade")}));$("#mainContent").html(renderMain());$("#"+selectedGame+"-locations").html(renderLocations(games[selectedGame],darkTheme));$('[data-tab="'+selectedGame+'"]').addClass("active");$("#gameMenu .menu .item").tab({onFirstLoad:tabPath=>{if(!games[tabPath].loaded){updateTab(tabPath,false)}},onLoad:tabPath=>{selectedGame=tabPath;localStorage.setItem("selectedGame",tabPath);updateLocationDropdown();$("#disableDexLimit").prop("checked",localStorage.getItem(tabPath+"-disable-dex-limit"))}});$("#resetModal").modal("attach events","#resetData","show");$("#locationModal").modal("attach events",".addLocation","show");$("#settingsModal").modal("attach events",".gameSettings","show");$("#fileLoader").on("change",(()=>{$("#importModal").modal("show")}));$("#gameMenu").dropdown();$("#locationOrder").dropdown({onChange:value=>{$("#locationOrder").val(value)}});if(darkTheme){$(".ui:not(.footer)").addClass("inverted")}initTab(selectedGame);updateLocationDropdown();$("#disableDexLimit").prop("checked",localStorage.getItem(selectedGame+"-disable-dex-limit"))}));