# dump

[`dump` online tutorial](https://arthas.aliyun.com/doc/arthas-tutorials?language=en&id=command-dump)

::: tip
Dump the bytecode for the particular classes to the specified directory.
:::

The dump command is used to dump the bytecode of classes actually running in the JVM to a specified directory. It is suitable for bulk downloading the bytecode of classes in a specific package directory. If you need to decompile a single class or view class information in real-time, you can refer to [jad](/en/doc/jad.md).

## Options

|                  Name | Specification                                                               |
| --------------------: | :-------------------------------------------------------------------------- |
|       _class-pattern_ | class name pattern                                                          |
|                `[c:]` | hashcode of the [class loader](classloader.md) that loaded the target class |
| `[classLoaderClass:]` | The class name of the ClassLoader that executes the expression.             |
|                `[d:]` | set the destination directory for class files                               |
|                 `[E]` | turn on regex match, the default behavior is wild card match                |

## Usage

```bash
$ dump java.lang.String
 HASHCODE  CLASSLOADER  LOCATION
 null                   /Users/admin/logs/arthas/classdump/java/lang/String.class
Affect(row-cnt:1) cost in 119 ms.
```

```bash
$ dump demo.*
 HASHCODE  CLASSLOADER                                    LOCATION
 3d4eac69  +-sun.misc.Launcher$AppClassLoader@3d4eac69    /Users/admin/logs/arthas/classdump/sun.misc.Launcher$AppClassLoader-3d4eac69/demo/MathGame.class
             +-sun.misc.Launcher$ExtClassLoader@66350f69
Affect(row-cnt:1) cost in 39 ms.
```

```bash
$ dump -d /tmp/output java.lang.String
 HASHCODE  CLASSLOADER  LOCATION
 null                   /tmp/output/java/lang/String.class
Affect(row-cnt:1) cost in 138 ms.
```

- Specify classLoader

Note that the hashcode changes, you need to check the current ClassLoader information first, and extract the hashcode corresponding to the ClassLoader.

if you use`-c`, you have to manually type hashcode by `-c <hashcode>`.

```bash
$ dump -c 3d4eac69 demo.*
```

For classloader with only one instance, it can be specified by `--classLoaderClass` using class name, which is more convenient to use.

```bash
$ dump --classLoaderClass sun.misc.Launcher$AppClassLoader demo.*
 HASHCODE  CLASSLOADER                                    LOCATION
 3d4eac69  +-sun.misc.Launcher$AppClassLoader@3d4eac69    /Users/admin/logs/arthas/classdump/sun.misc.Launcher$AppClassLoader-3d4eac69/demo/MathGame.class
             +-sun.misc.Launcher$ExtClassLoader@66350f69
Affect(row-cnt:1) cost in 39 ms.
```

- PS: Here the classLoaderClass in java 8 is sun.misc.Launcher$AppClassLoader, while in java 11 it's jdk.internal.loader.ClassLoaders$AppClassLoader. Currently killercoda using java 11.

The value of `--classloaderclass` is the class name of classloader. It can only work when it matches a unique classloader instance. The purpose is to facilitate the input of general commands. However, `-c <hashcode>` is dynamic.
