# Learn C: Code Snippets

Welcome to the Learn C Code Snippets repository! This repository contains all the code snippets used in the tutorials on learn-c.org. It's designed to help you follow along with the lessons and practice your C programming skills.

## Contents

The repository is organized by tutorial topics. Each topic has its own directory containing the relevant code snippets. Here's a brief overview of the directory structure:

	.
	├── 01_Hello_World
	│   └── hello_world.c
 	│   └── task.md
	├── 02_Variables_and_Types
	│   └── variables_and_types.c
  	│   └── task.md
	├── 03_Arrays
	│   └── arrays.c
  	│   └── task.md
	...

## Getting Started

To get started, simply clone the repository and navigate to the topic of interest. You can compile and run the examples using a C compiler like gcc.
Prerequisites

- C compiler (e.g., gcc)
- Basic knowledge of C programming

### Cloning the Repository

  ```bash
  $ git clone https://github.com/Arichikurumo/learn-c-snippets.git
  $ cd learn-c-snippets
  ```
### Running the Code

Navigate to the directory containing the code snippet you want to run and compile it using your C compiler. For example:
	
	cd 01_Hello_World
	gcc hello_world.c -o hello_world
	./hello_world

## Contributing
Contributions are welcome! If you find an issue or have a suggestion, please open an issue or create a pull request. Make sure to follow the existing code style and include comments where necessary.

### Creating a Pull Request

    Fork the repository
    Create a new branch (git checkout -b feature/my-feature)
    Commit your changes (git commit -am 'Add new feature')
    Push to the branch (git push origin feature/my-feature)
    Create a new Pull Request

## License

This project is licensed under the Apache License. See the LICENSE file for details.

## Acknowledgements

Thanks to [learn-c.org](https://learn-c.org) for providing the tutorials and the initial inspiration for this repository.

Happy coding!
