/*! Foundation styling wrapper for RowReorder
 * ©2018 SpryMedia Ltd - datatables.net/license
 */

(function (factory) {
  if (typeof define === "function" && define.amd) {
    // AMD
    define(["jquery", "datatables.net-zf", "datatables.net-rowreorder"], function ($) {
      return factory($, window, document);
    });
  } else if (typeof exports === "object") {
    // CommonJS
    module.exports = function (root, $) {
      if (!root) {
        root = window;
      }

      if (!$ || !$.fn.dataTable) {
        $ = require("datatables.net-zf")(root, $).$;
      }

      if (!$.fn.dataTable.RowReorder) {
        require("datatables.net-rowreorder")(root, $);
      }

      return factory($, root, root.document);
    };
  } else {
    // Browser
    factory(jQuery, window, document);
  }
})(function ($, window, document, undefined) {
  return $.fn.dataTable;
});
