/*! Semanic UI styling wrapper for FixedHeader
 * ©2018 SpryMedia Ltd - datatables.net/license
 */

(function (factory) {
  if (typeof define === "function" && define.amd) {
    // AMD
    define(["jquery", "datatables.net-se", "datatables.net-fixedheader"], function ($) {
      return factory($, window, document);
    });
  } else if (typeof exports === "object") {
    // CommonJS
    module.exports = function (root, $) {
      if (!root) {
        root = window;
      }

      if (!$ || !$.fn.dataTable) {
        $ = require("datatables.net-se")(root, $).$;
      }

      if (!$.fn.dataTable.FixedHeader) {
        require("datatables.net-fixedheader")(root, $);
      }

      return factory($, root, root.document);
    };
  } else {
    // Browser
    factory(jQuery, window, document);
  }
})(function ($, window, document, undefined) {
  return $.fn.dataTable;
});
