#!/usr/bin/env sh
#
# Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

# Get standard environment variables
PRGDIR=`dirname "$PRG"`

# Only set ARCADEDB_HOME if not already set
[ -f "$ARCADEDB_HOME"/bin/console.sh ] || ARCADEDB_HOME=`cd "$PRGDIR/.." ; pwd`

# Raspberry Pi check (Java VM does not run with -server argument on ARMv6)
if [ `uname -m` != "armv6l" ]; then
  JAVA_OPTS="$JAVA_OPTS -server "
fi

# Set JavaHome if it exists
if [ -f "${JAVA_HOME}/bin/java" ]; then
   JAVA=${JAVA_HOME}/bin/java
else
   JAVA=java
fi


if [ -z "$JAVA_OPTS_SCRIPT" ] ; then
    JAVA_OPTS_SCRIPT="-XX:+HeapDumpOnOutOfMemoryError \
        --add-exports java.management/sun.management=ALL-UNNAMED \
        --add-opens java.base/java.util.concurrent.atomic=ALL-UNNAMED \
        --add-opens java.base/java.nio.channels.spi=ALL-UNNAMED \
        --add-opens java.base/java.lang=ALL-UNNAMED \
        -Dpolyglot.engine.WarnInterpreterOnly=false \
        -Djava.awt.headless=true \
        -Dfile.encoding=UTF8 \
        --illegal-access=deny"
fi

if [ $# -gt 0 ] ; then
    exec "$JAVA" $JAVA_OPTS \
        $ARCADEDB_OPTS_MEMORY \
        $JAVA_OPTS_SCRIPT \
        $ARCADEDB_SETTINGS \
        -cp "$ARCADEDB_HOME/lib/*" \
        $ARGS com.arcadedb.console.Console "$@"
else
    exec "$JAVA" $JAVA_OPTS \
        $ARCADEDB_OPTS_MEMORY \
        $JAVA_OPTS_SCRIPT \
        $ARCADEDB_SETTINGS \
        -cp "$ARCADEDB_HOME/lib/*" \
        $ARGS com.arcadedb.console.Console
fi
