import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook

def globals = [:]

// defines a sample LifeCycleHook that prints some output to the Gremlin Server console.
// note that the name of the key in the "global" map is unimportant.
globals << [hook : [
        onStartUp: { ctx ->
            ctx.logger.info("Executed once at startup of Gremlin Server.")
        },
        onShutDown: { ctx ->
            ctx.logger.info("Executed once at shutdown of Gremlin Server.")
        }
] as LifeCycleHook]

// define the default TraversalSource to bind queries to - this one will be named "graph".
globals << [graph : traversal().withEmbedded(graph)]
// define the default TraversalSource to bind queries to - this one will be named "g".
globals << [g : traversal().withEmbedded(graph)]
