/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated by: ParserGeneratorCC: Do not edit this line. SimpleCharStream.java Version 1.1 */
/* ParserGeneratorCCOptions:SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.arcadedb.graphql.parser;

import java.io.*;
import java.nio.charset.*;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 */
public
class SimpleCharStream extends AbstractCharStream
{
  private Reader m_aIS;

  /** Constructor. */
  public SimpleCharStream(final Reader dstream,
                          final int startline,
                          final int startcolumn,
                          final int buffersize)
  {
    super (startline, startcolumn, buffersize);
    m_aIS = dstream;
  }

  /** Constructor. */
  public SimpleCharStream(final Reader dstream,
                          final int startline,
                          final int startcolumn)
  {
    this(dstream, startline, startcolumn, DEFAULT_BUF_SIZE);
  }

  /** Constructor. */
  public SimpleCharStream(final Reader dstream)
  {
    this(dstream, 1, 1, DEFAULT_BUF_SIZE);
  }

  /** Reinitialise. */
  public void reInit(final Reader dstream,
                     final int startline,
                     final int startcolumn,
                     final int buffersize)
  {
    m_aIS = dstream;
    super.reInit (startline, startcolumn, buffersize);
  }

  /** Reinitialise. */
  public void reInit(final Reader dstream,
                     final int startline,
                     final int startcolumn)
  {
    reInit(dstream, startline, startcolumn, DEFAULT_BUF_SIZE);
  }

  /** Reinitialise. */
  public void reInit(final Reader dstream)
  {
    reInit(dstream, 1, 1, DEFAULT_BUF_SIZE);
  }

  /** Constructor. */
  public SimpleCharStream(final InputStream dstream,
                          final Charset encoding,
                          final int startline,
                          final int startcolumn,
                          final int buffersize)
  {
    this(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
  }

  /** Constructor. */
  public SimpleCharStream(final InputStream dstream,
                          final Charset encoding,
                          final int startline,
                          final int startcolumn)
  {
    this(dstream, encoding, startline, startcolumn, DEFAULT_BUF_SIZE);
  }

  /** Constructor. */
  public SimpleCharStream(final InputStream dstream,
                          final Charset encoding)
  {
    this(dstream, encoding, 1, 1, DEFAULT_BUF_SIZE);
  }

  /** Reinitialise. */
  public void reInit(final InputStream dstream,
                     final Charset encoding)
  {
    reInit(dstream, encoding, 1, 1, DEFAULT_BUF_SIZE);
  }

  /** Reinitialise. */
  public void reInit(final InputStream dstream,
                     final Charset encoding,
                     final int startline,
                     final int startcolumn)
  {
    reInit(dstream, encoding, startline, startcolumn, DEFAULT_BUF_SIZE);
  }

  /** Reinitialise. */
  public void reInit(final InputStream dstream,
                     final Charset encoding,
                     final int startline,
                     final int startcolumn,
                     final int buffersize)
  {
    reInit(new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
  }

  @Override
  protected int streamRead (final char[] aBuf, final int nOfs, final int nLen) throws IOException
  {
    return m_aIS.read (aBuf, nOfs, nLen);
  }

  @Override
  protected void streamClose () throws IOException
  {
    if (m_aIS != null)
      m_aIS.close ();
  }
}
/* ParserGeneratorCC - OriginalChecksum=288df214d89d601f3bd87b0d29305baf (do not edit this line) */
