/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated by: JJTree: Do not edit this line. Node.java Version 1.1 */
/* ParserGeneratorCCOptions:MULTI=false,NODE_USES_PARSER=false,VISITOR=false,TRACK_TOKENS=false,NODE_PREFIX=AST,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.arcadedb.graphql.parser;

/* All AST nodes must implement this interface.  It provides basic
   machinery for constructing the parent and child relationships
   between nodes. */

import java.io.*;

public
interface Node extends Serializable {
  /** This method is called after the node has been made the current
    node.  It indicates that child nodes can now be added to it. */
  void jjtOpen();

  /** This method is called after all the child nodes have been
    added. */
  void jjtClose();

  /**
   * Set the parent node of this node
   * @param n parent node to set
   */
  void jjtSetParent(Node n);

  /**
   * @return parent node
   */
  Node jjtGetParent();

  /**
   * This method tells the node to add its argument to the node's
   * list of children.
   * @param n node to add as a child
   * @param i zero-based index where to add the child
   */
  void jjtAddChild(Node n, int i);

  /**
   * This method returns a child node. The children are numbered
   * from zero, left to right.
   * @param i zero-baeed child index
   */
  Node jjtGetChild(int i);

  /**
   * @return the number of children the node has. Always &ge; 0.
   */
  int jjtGetNumChildren();

  int getId();
}
/* ParserGeneratorCC - OriginalChecksum=9e98cbfeabe2d9744f96749c7480aa19 (do not edit this line) */
