/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OTruncateClassStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Database;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.Schema;

import java.util.*;

public class TruncateTypeStatement extends DDLStatement {
  protected Identifier typeName;
  protected boolean    polymorphic = false;
  protected boolean    unsafe      = false;

  public TruncateTypeStatement(final int id) {
    super(id);
  }

  @Override
  public ResultSet executeDDL(final CommandContext context) {
    final Database db = context.getDatabase();
    final Schema schema = db.getSchema();
    final DocumentType typez = schema.getType(typeName.getStringValue());
    if (typez == null) {
      throw new CommandExecutionException("Schema Class not found: " + typeName);
    }

    final long recs = context.getDatabase().countType(typeName.getStringValue(), polymorphic);
    if (recs > 0 && !unsafe) {
      if (typez.isSubTypeOf("V")) {
        throw new CommandExecutionException(
            "'TRUNCATE TYPE' command cannot be used on not empty vertex classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
      } else if (typez.isSubTypeOf("E")) {
        throw new CommandExecutionException(
            "'TRUNCATE TYPE' command cannot be used on not empty edge classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
      }
    }

    final InternalResultSet rs = new InternalResultSet();
    final Collection<DocumentType> subTypes = typez.getSubTypes();
    if (polymorphic && !unsafe) {// for multiple inheritance
      for (final DocumentType subType : subTypes) {
        final long subTypeRecs = context.getDatabase().countType(typeName.getStringValue(), false);
        if (subTypeRecs > 0) {
          if (subType.isSubTypeOf("V")) {
            throw new CommandExecutionException("'TRUNCATE TYPE' command cannot be used on not empty vertex classes (" + subType.getName()
                + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
          } else if (subType.isSubTypeOf("E")) {
            throw new CommandExecutionException("'TRUNCATE TYPE' command cannot be used on not empty edge classes (" + subType.getName()
                + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
          }
        }
      }
    }

    db.scanType(typeName.getStringValue(), polymorphic, rec -> {
      rec.delete();
      return true;
    });

    final ResultInternal result = new ResultInternal(context.getDatabase());
    result.setProperty("operation", "truncate type");
    result.setProperty("typeName", typeName.getStringValue());
    rs.add(result);

    return rs;
  }

  @Override
  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("TRUNCATE TYPE " + typeName.toString());
    if (polymorphic) {
      builder.append(" POLYMORPHIC");
    }
    if (unsafe) {
      builder.append(" UNSAFE");
    }
  }

  @Override
  public TruncateTypeStatement copy() {
    final TruncateTypeStatement result = new TruncateTypeStatement(-1);
    result.typeName = typeName == null ? null : typeName.copy();
    result.polymorphic = polymorphic;
    result.unsafe = unsafe;
    return result;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    final TruncateTypeStatement that = (TruncateTypeStatement) o;

    if (polymorphic != that.polymorphic)
      return false;
    if (unsafe != that.unsafe)
      return false;
    return Objects.equals(typeName, that.typeName);
  }

  @Override
  public int hashCode() {
    int result = typeName != null ? typeName.hashCode() : 0;
    result = 31 * result + (polymorphic ? 1 : 0);
    result = 31 * result + (unsafe ? 1 : 0);
    return result;
  }
}
/* JavaCC - OriginalChecksum=301f993f6ba2893cb30c8f189674b974 (do not edit this line) */
