/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OReturnStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;

import java.util.*;

public class ReturnStatement extends SimpleExecStatement {
  protected Expression expression;

  public ReturnStatement(final int id) {
    super(id);
  }

  @Override
  public ResultSet executeSimple(final CommandContext context) {
    final InternalResultSet rs = new InternalResultSet();

    final Object result = expression == null ? null : expression.execute((Result) null, context);
    if (result instanceof Result) {
      rs.add((Result) result);
    } else if (result instanceof Identifiable) {
      final ResultInternal res = new ResultInternal((Document) ((Identifiable) result).getRecord());
      rs.add(res);
    } else if (result instanceof Iterable) {
      for (Object o : (Iterable) result) {
        final Result r;
        if (o instanceof Result)
          r = (Result) o;
        else if (o instanceof Map)
          r = new ResultInternal((Map) o);
        else
          r = new ResultInternal(Map.of("value", o));
        rs.add(r);
      }
    } else if (result instanceof ResultSet) {
      if (!((ResultSet) result).hasNext()) {
        try {
          ((ResultSet) result).reset();
        } catch (final UnsupportedOperationException ignore) {
          // just try to reset the RS, in case it was already used during the script execution
          // already
          // You can have two cases here:
          // - a result stored in a LET, that is always resettable, as it's copied
          // - a result from a direct query (eg. RETURN SELECT...), that is new or just empty, so
          // this operation does not hurt
        }
      }
      return (ResultSet) result;
    } else {
      final ResultInternal res = new ResultInternal(context.getDatabase());
      res.setProperty("value", result);
      rs.add(res);
    }
    return rs;
  }

  @Override
  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("RETURN");
    if (expression != null) {
      builder.append(" ");
      expression.toString(params, builder);
    }
  }

  @Override
  public ReturnStatement copy() {
    final ReturnStatement result = new ReturnStatement(-1);
    result.expression = expression == null ? null : expression.copy();
    return result;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    final ReturnStatement that = (ReturnStatement) o;

    return Objects.equals(expression, that.expression);
  }

  @Override
  public int hashCode() {
    return expression != null ? expression.hashCode() : 0;
  }
}
/* JavaCC - OriginalChecksum=c72ec860d1fa92cbf52e42ae1c2935c0 (do not edit this line) */
