/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. ORecordAttribute.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Document;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;

public class RecordAttribute extends SimpleNode {
  protected String name;

  public RecordAttribute(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append(name);
  }

  public RecordAttribute copy() {
    final RecordAttribute result = new RecordAttribute(-1);
    result.name = name;
    return result;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    final RecordAttribute that = (RecordAttribute) o;

    return Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return name != null ? name.hashCode() : 0;
  }

  public String getName() {
    return name;
  }

  public void setName(final String name) {
    this.name = name;
  }

  public Object evaluate(final Result iCurrentRecord, final CommandContext context) {
    if (name.equalsIgnoreCase("@rid")) {
      return iCurrentRecord.getIdentity().orElse(null);
    } else if (name.equalsIgnoreCase("@type")) {
      return iCurrentRecord.getElement().map(Document::getTypeName).orElse(null);
    } else if (name.equalsIgnoreCase("@cat") && iCurrentRecord.getElement().isPresent()) {
      final Document record = iCurrentRecord.getElement().get();
      if (record instanceof Vertex)
        return "v";
      else if (record instanceof Edge)
        return "e";
      else
        return "d";

    } else if (name.equalsIgnoreCase("@in") && //
        iCurrentRecord.getElement().isPresent() && iCurrentRecord.getElement().get() instanceof Edge) {
      return iCurrentRecord.getElement().get().asEdge().getIn();
    } else if (name.equalsIgnoreCase("@out") && //
        iCurrentRecord.getElement().isPresent() && iCurrentRecord.getElement().get() instanceof Edge) {
      return iCurrentRecord.getElement().get().asEdge().getOut();
    }
    return null;
  }
}
/* JavaCC - OriginalChecksum=45ce3cd16399dec7d7ef89f8920d02ae (do not edit this line) */
