/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OInteger.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import java.util.*;

public class PInteger extends PNumber {

  protected Number value;

  public PInteger(final int id) {
    super(id);
  }

  public Number getValue() {
    return value;
  }

  public void setValue(final int sign, String stringValue) {
    final int radix = radix(stringValue);
    stringValue = convertToJavaByRadix(stringValue, radix);

    if (stringValue.endsWith("L") || stringValue.endsWith("l")) {
      value = Long.parseLong(stringValue.substring(0, stringValue.length() - 1), radix) * sign;
    } else {
      final long longValue = Long.parseLong(stringValue, radix) * sign;
      if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
        value = longValue;
      } else {
        value = (int) longValue;
      }
    }
  }

  private String convertToJavaByRadix(final String stringValue, final int radix) {
    if (radix == 16) {
      if (stringValue.charAt(0) == '-') {
        return "-" + stringValue.substring(3);
      } else {
        return stringValue.substring(2);
      }
    }
    return stringValue;
  }

  private int radix(String stringValue) {
    if (stringValue.startsWith("-")) {
      stringValue = stringValue.substring(1);
    }
    if (stringValue.length() > 2 && stringValue.substring(0, 2).equalsIgnoreCase("0x")) {
      return 16;
    }
    if (stringValue.length() > 1 && stringValue.charAt(0) == '0') {
      return 8;
    }
    return 10;
  }

  public PInteger setValue(final Number value) {
    this.value = value;
    return this;
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("" + value);
  }

  public PInteger copy() {
    final PInteger result = new PInteger(-1);
    result.value = value;
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { value };
  }
}
/* JavaCC - OriginalChecksum=2e6eee6366ff4e864dd6c8184d2766f5 (do not edit this line) */
