/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OCollection.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Record;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;
import java.util.stream.*;

public class PCollection extends SimpleNode {
  protected List<Expression> expressions = new ArrayList<>();

  public PCollection(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("[");
    boolean first = true;
    for (final Expression expr : expressions) {
      if (!first) {
        builder.append(", ");
      }
      expr.toString(params, builder);
      first = false;
    }
    builder.append("]");
  }

  public void add(final Expression exp) {
    this.expressions.add(exp);
  }

  public Object execute(final Record iCurrentRecord, final CommandContext context) {
    final List<Object> result = new ArrayList<Object>();
    for (final Expression exp : expressions) {
      result.add(exp.execute(iCurrentRecord, context));
    }
    return result;
  }

  public Object execute(final Result iCurrentRecord, final CommandContext context) {
    final List<Object> result = new ArrayList<Object>();
    for (final Expression exp : expressions) {
      result.add(exp.execute(iCurrentRecord, context));
    }
    return result;
  }

  public boolean isAggregate(final CommandContext context) {
    for (final Expression exp : this.expressions) {
      if (exp.isAggregate(context)) {
        return true;
      }
    }
    return false;
  }

  public PCollection splitForAggregation(final AggregateProjectionSplit aggregateProj, final CommandContext context) {
    if (isAggregate(context)) {
      final PCollection result = new PCollection(-1);
      for (final Expression exp : this.expressions) {
        if (exp.isAggregate(context) || exp.isEarlyCalculated(context)) {
          result.expressions.add(exp.splitForAggregation(aggregateProj, context));
        } else {
          throw new CommandExecutionException("Cannot mix aggregate and non-aggregate operations in a collection: " + this);
        }
      }
      return result;
    } else {
      return this;
    }
  }

  public boolean isEarlyCalculated(final CommandContext context) {
    for (final Expression exp : expressions) {
      if (!exp.isEarlyCalculated(context)) {
        return false;
      }
    }
    return true;
  }

  public PCollection copy() {
    final PCollection result = new PCollection(-1);
    result.expressions = expressions == null ? null : expressions.stream().map(x -> x.copy()).collect(Collectors.toList());
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { expressions };
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return expressions.toArray(new SimpleNode[expressions.size()]);
  }

  public List<Expression> getExpressions() {
    return expressions;
  }
}
/* JavaCC - OriginalChecksum=c93b20138b2ae58c5f76e458c34b5946 (do not edit this line) */
