/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OOrderBy.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;
import java.util.stream.*;

public class OrderBy extends SimpleNode {
  protected List<OrderByItem> items;

  public OrderBy() {
    super(-1);
  }

  public OrderBy(final int id) {
    super(id);
  }

  public List<OrderByItem> getItems() {
    return items;
  }

  public void setItems(final List<OrderByItem> items) {
    this.items = items;
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    if (items != null && items.size() > 0) {
      builder.append("ORDER BY ");
      for (int i = 0; i < items.size(); i++) {
        if (i > 0) {
          builder.append(", ");
        }
        items.get(i).toString(params, builder);
      }
    }
  }

  public int compare(final Result a, final Result b, final CommandContext context) {
    for (final OrderByItem item : items) {
      final int result = item.compare(a, b, context);
      if (result != 0) {
        return result > 0 ? 1 : -1;
      }
    }
    return 0;
  }

  public OrderBy copy() {
    final OrderBy result = new OrderBy(-1);
    result.items = items == null ? null : items.stream().map(x -> x.copy()).collect(Collectors.toList());
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return items.toArray(new OrderByItem[items.size()]);
  }

  public void extractSubQueries(final SubQueryCollector collector) {
    if (items != null) {
      for (final OrderByItem item : items) {
        item.extractSubQueries(collector);
      }
    }
  }
}
/* JavaCC - OriginalChecksum=d5529400217169f15e556e5dc6fe4f5b (do not edit this line) */
