/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. ONotInCondition.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Identifiable;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;

public class NotInCondition extends BooleanExpression {

  protected Expression            left;
  protected BinaryCompareOperator operator;
  protected SelectStatement       rightStatement;

  protected Object         right;
  protected InputParameter rightParam;
  protected MathExpression rightMathExpression;

  private static final Object UNSET           = new Object();
  private final        Object inputFinalValue = UNSET;

  public NotInCondition(final int id) {
    super(id);
  }

  @Override
  public Boolean evaluate(final Identifiable currentRecord, final CommandContext context) {
    final Object leftVal = left.execute(currentRecord, context);
    Object rightVal = null;
    if (rightStatement != null) {
      rightVal = InCondition.executeQuery(rightStatement, context);
    } else if (rightParam != null) {
      rightVal = rightParam.getValue(context.getInputParameters());
    } else if (rightMathExpression != null) {
      rightVal = rightMathExpression.execute(currentRecord, context);
    }
    if (rightVal == null) {
      return true;
    }
    return !InCondition.evaluateExpression(leftVal, rightVal);
  }

  @Override
  public Boolean evaluate(final Result currentRecord, final CommandContext context) {
    final Object leftVal = left.execute(currentRecord, context);
    Object rightVal = null;
    if (rightStatement != null) {
      rightVal = InCondition.executeQuery(rightStatement, context);
    } else if (rightParam != null) {
      rightVal = rightParam.getValue(context.getInputParameters());
    } else if (rightMathExpression != null) {
      rightVal = rightMathExpression.execute(currentRecord, context);
    }
    if (rightVal == null) {
      return true;
    }
    return !InCondition.evaluateExpression(leftVal, rightVal);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {

    left.toString(params, builder);
    builder.append(" NOT IN ");
    if (rightStatement != null) {
      builder.append("(");
      rightStatement.toString(params, builder);
      builder.append(")");
    } else if (right != null) {
      builder.append(convertToString(right));
    } else if (rightParam != null) {
      rightParam.toString(params, builder);
    } else if (rightMathExpression != null) {
      rightMathExpression.toString(params, builder);
    }
  }

  private String convertToString(final Object o) {
    if (o instanceof String) {
      return "\"" + ((String) o).replace("\"", "\\\"") + "\"";
    }
    return o.toString();
  }

  @Override
  public NotInCondition copy() {
    final NotInCondition result = new NotInCondition(-1);
    result.operator = operator == null ? null : operator.copy();
    result.left = left == null ? null : left.copy();
    result.rightMathExpression = rightMathExpression == null ? null : rightMathExpression.copy();
    result.rightStatement = rightStatement == null ? null : rightStatement.copy();
    result.rightParam = rightParam == null ? null : rightParam.copy();
    result.right = right;
    return result;
  }

  @Override
  public void extractSubQueries(final SubQueryCollector collector) {
    if (left != null)
      left.extractSubQueries(collector);

    if (rightMathExpression != null) {
      rightMathExpression.extractSubQueries(collector);
    } else if (rightStatement != null) {
      final Identifier alias = collector.addStatement(rightStatement);
      rightMathExpression = new BaseExpression(alias);
      rightStatement = null;
    }
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { left, operator, rightStatement, right, rightParam, rightMathExpression, inputFinalValue };
  }

  @Override
  public List<String> getMatchPatternInvolvedAliases() {
    final List<String> leftX = left == null ? null : left.getMatchPatternInvolvedAliases();
    final List<String> rightX = rightMathExpression == null ? null : rightMathExpression.getMatchPatternInvolvedAliases();

    final List<String> result = new ArrayList<String>();
    if (leftX != null) {
      result.addAll(leftX);
    }
    if (rightX != null) {
      result.addAll(rightX);
    }

    return result.isEmpty() ? null : result;
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { left, rightStatement, rightMathExpression };
  }
}
/* JavaCC - OriginalChecksum=8fb82bf72cc7d9cbdf2f9e2323ca8ee1 (do not edit this line) */
