/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OMatchFilterItem.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import java.util.*;

public class MatchFilterItem extends SimpleNode {
  protected Expression         typeName;
  protected Expression         typeNames;
  protected Identifier         bucketName;
  protected PInteger           bucketId;
  protected Rid                rid;
  protected Identifier         alias;
  protected WhereClause        filter;
  protected WhereClause        whileCondition;
  protected ArrayRangeSelector depth;
  protected PInteger           maxDepth;
  protected Boolean            optional;
  protected Identifier         depthAlias;
  protected Identifier         pathAlias;

  public MatchFilterItem(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    if (typeName != null) {
      builder.append("type: ");
      typeName.toString(params, builder);
      return;
    }
    if (typeNames != null) {
      builder.append("types: ");
      typeNames.toString(params, builder);
      return;
    }
    if (bucketName != null) {
      builder.append("bucket: ");
      bucketName.toString(params, builder);
      return;
    }
    if (bucketId != null) {
      builder.append("bucket: ");
      bucketId.toString(params, builder);
      return;
    }
    if (rid != null) {
      builder.append("rid: ");
      rid.toString(params, builder);
      return;
    }

    if (alias != null) {
      builder.append("as: ");
      alias.toString(params, builder);
      return;
    }

    if (maxDepth != null) {
      builder.append("maxdepth: ");
      maxDepth.toString(params, builder);
      return;
    }

    if (filter != null) {
      builder.append("where: (");
      filter.toString(params, builder);
      builder.append(")");
      return;
    }

    if (whileCondition != null) {
      builder.append("while: (");
      whileCondition.toString(params, builder);
      builder.append(")");
      return;
    }

    if (optional != null) {
      builder.append("optional: ");
      builder.append(optional);
      return;
    }

    if (depthAlias != null) {
      builder.append("depthAlias: ");
      depthAlias.toString(params, builder);
      return;
    }

    if (pathAlias != null) {
      builder.append("pathAlias: ");
      pathAlias.toString(params, builder);
    }

  }

  @Override
  public MatchFilterItem copy() {
    final MatchFilterItem result = new MatchFilterItem(-1);
    result.typeName = typeName == null ? null : typeName.copy();
    result.typeNames = typeNames == null ? null : typeNames.copy();
    result.bucketName = bucketName == null ? null : bucketName.copy();
    result.bucketId = bucketId == null ? null : bucketId.copy();
    result.rid = rid == null ? null : rid.copy();
    result.alias = alias == null ? null : alias.copy();
    result.filter = filter == null ? null : filter.copy();
    result.whileCondition = whileCondition == null ? null : whileCondition.copy();
    result.depth = depth == null ? null : depth.copy();
    result.maxDepth = maxDepth == null ? null : maxDepth.copy();
    result.optional = optional;
    result.depthAlias = depthAlias == null ? null : depthAlias.copy();
    result.pathAlias = pathAlias == null ? null : pathAlias.copy();
    return result;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    final MatchFilterItem that = (MatchFilterItem) o;

    if (!Objects.equals(typeName, that.typeName))
      return false;
    if (!Objects.equals(typeNames, that.typeNames))
      return false;
    if (!Objects.equals(bucketName, that.bucketName))
      return false;
    if (!Objects.equals(bucketId, that.bucketId))
      return false;
    if (!Objects.equals(rid, that.rid))
      return false;
    if (!Objects.equals(alias, that.alias))
      return false;
    if (!Objects.equals(filter, that.filter))
      return false;
    if (!Objects.equals(whileCondition, that.whileCondition))
      return false;
    if (!Objects.equals(depth, that.depth))
      return false;
    if (!Objects.equals(maxDepth, that.maxDepth))
      return false;
    if (!Objects.equals(optional, that.optional))
      return false;
    if (!Objects.equals(depthAlias, that.depthAlias))
      return false;
    return Objects.equals(pathAlias, that.pathAlias);
  }

  @Override
  public int hashCode() {
    int result = typeName != null ? typeName.hashCode() : 0;
    result = 31 * result + (typeNames != null ? typeNames.hashCode() : 0);
    result = 31 * result + (bucketName != null ? bucketName.hashCode() : 0);
    result = 31 * result + (bucketId != null ? bucketId.hashCode() : 0);
    result = 31 * result + (rid != null ? rid.hashCode() : 0);
    result = 31 * result + (alias != null ? alias.hashCode() : 0);
    result = 31 * result + (filter != null ? filter.hashCode() : 0);
    result = 31 * result + (whileCondition != null ? whileCondition.hashCode() : 0);
    result = 31 * result + (depth != null ? depth.hashCode() : 0);
    result = 31 * result + (maxDepth != null ? maxDepth.hashCode() : 0);
    result = 31 * result + (optional != null ? optional.hashCode() : 0);
    result = 31 * result + (depthAlias != null ? depthAlias.hashCode() : 0);
    result = 31 * result + (pathAlias != null ? pathAlias.hashCode() : 0);
    return result;
  }
}
/* JavaCC - OriginalChecksum=74bf4765509f102180cac29f2295031e (do not edit this line) */
