/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OLevelZeroIdentifier.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Record;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.query.sql.executor.AggregationContext;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;

public class LevelZeroIdentifier extends SimpleNode {
  protected FunctionCall functionCall;
  protected Boolean      self;
  protected PCollection  collection;

  public LevelZeroIdentifier(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    if (functionCall != null) {
      functionCall.toString(params, builder);
    } else if (Boolean.TRUE.equals(self)) {
      builder.append("@this");
    } else if (collection != null) {
      collection.toString(params, builder);
    }
  }

  public Object execute(final Record iCurrentRecord, final CommandContext context) {
    if (functionCall != null) {
      return functionCall.execute(iCurrentRecord, context);
    }
    if (collection != null) {
      return collection.execute(iCurrentRecord, context);
    }
    if (Boolean.TRUE.equals(self)) {
      return iCurrentRecord;
    }
    throw new UnsupportedOperationException();
  }

  public Object execute(final Result iCurrentRecord, final CommandContext context) {
    if (functionCall != null) {
      return functionCall.execute(iCurrentRecord, context);
    }
    if (collection != null) {
      return collection.execute(iCurrentRecord, context);
    }
    if (Boolean.TRUE.equals(self)) {
      return iCurrentRecord;
    }
    throw new UnsupportedOperationException();
  }

  public boolean isIndexedFunctionCall(final CommandContext context) {
    if (functionCall != null)
      return functionCall.isIndexedFunctionCall(context);

    return false;
  }

  public long estimateIndexedFunction(final FromClause target, final CommandContext context, final BinaryCompareOperator operator, final Object right) {
    if (functionCall != null)
      return functionCall.estimateIndexedFunction(target, context, operator, right);

    return -1;
  }

  public Iterable<Record> executeIndexedFunction(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (functionCall != null) {
      return functionCall.executeIndexedFunction(target, context, operator, right);
    }
    return null;
  }

  /**
   * tests if current expression is an indexed function AND that function can also be executed without using the index
   *
   * @param target   the query target
   * @param context  the execution context
   * @param operator
   * @param right
   *
   * @return true if current expression is an indexed function AND that function can also be executed without using the index, false otherwise
   */
  public boolean canExecuteIndexedFunctionWithoutIndex(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.functionCall == null) {
      return false;
    }
    return functionCall.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
  }

  /**
   * tests if current expression is an indexed function AND that function can be used on this target
   *
   * @param target   the query target
   * @param context  the execution context
   * @param operator
   * @param right
   *
   * @return true if current expression involves an indexed function AND that function can be used on this target, false otherwise
   */
  public boolean allowsIndexedFunctionExecutionOnTarget(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.functionCall == null) {
      return false;
    }
    return functionCall.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
  }

  /**
   * tests if current expression is an indexed function AND the function has also to be executed after the index search.
   * In some cases, the index search is accurate, so this condition can be excluded from further evaluation. In other cases
   * the result from the index is a superset of the expected result, so the function has to be executed anyway for further filtering
   *
   * @param target  the query target
   * @param context the execution context
   *
   * @return true if current expression is an indexed function AND the function has also to be executed after the index search.
   */
  public boolean executeIndexedFunctionAfterIndexSearch(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.functionCall == null) {
      return false;
    }
    return functionCall.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
  }

  public boolean isExpand() {
    if (functionCall != null) {
      return functionCall.isExpand();
    }
    return false;
  }

  public Expression getExpandContent() {
    if (functionCall.getParams().size() != 1) {
      throw new CommandExecutionException("Invalid expand expression: " + functionCall.toString());
    }
    return functionCall.getParams().get(0);
  }

  public boolean isAggregate(final CommandContext context) {
    if (functionCall != null && functionCall.isAggregate(context)) {
      return true;
    }
    return collection != null && collection.isAggregate(context);
  }

  public boolean isCount() {
    return functionCall != null && functionCall.name.getStringValue().equalsIgnoreCase("count");
  }

  public boolean isEarlyCalculated(final CommandContext context) {
    if (functionCall != null && functionCall.isEarlyCalculated(context))
      return true;

    if (Boolean.TRUE.equals(self))
      return false;

    return collection != null && collection.isEarlyCalculated(context);
  }

  public SimpleNode splitForAggregation(final AggregateProjectionSplit aggregateProj, final CommandContext context) {
    if (isAggregate(context)) {
      final LevelZeroIdentifier result = new LevelZeroIdentifier(-1);
      if (functionCall != null) {
        final SimpleNode node = functionCall.splitForAggregation(aggregateProj, context);
        if (node instanceof FunctionCall) {
          result.functionCall = (FunctionCall) node;
        } else {
          return node;
        }
      } else if (collection != null) {
        result.collection = collection.splitForAggregation(aggregateProj, context);
        return result;
      } else {
        throw new IllegalStateException();
      }
      return result;
    } else {
      return this;
    }
  }

  public AggregationContext getAggregationContext(final CommandContext context) {
    if (isAggregate(context)) {
      if (functionCall != null) {
        return functionCall.getAggregationContext(context);
      }
    }
    throw new CommandExecutionException("cannot aggregate on " + this);
  }

  public LevelZeroIdentifier copy() {
    final LevelZeroIdentifier result = new LevelZeroIdentifier(-1);
    result.functionCall = functionCall == null ? null : functionCall.copy();
    result.self = self;
    result.collection = collection == null ? null : collection.copy();
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { functionCall, self, collection };
  }

  public void setCollection(final PCollection collection) {
    this.collection = collection;
  }

  public FunctionCall getFunctionCall() {
    return functionCall;
  }

  public Boolean getSelf() {
    return self;
  }

  public PCollection getCollection() {
    return collection;
  }

  public void extractSubQueries(final Identifier letAlias, final SubQueryCollector collector) {
    if (this.functionCall != null) {
      this.functionCall.extractSubQueries(letAlias, collector);
    }
  }

  public void extractSubQueries(final SubQueryCollector collector) {
    if (this.functionCall != null) {
      this.functionCall.extractSubQueries(collector);
    }
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { functionCall, collection };
  }
}
/* JavaCC - OriginalChecksum=0305fcf120ba9395b4c975f85cdade72 (do not edit this line) */
