/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OLetItem.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import java.util.*;

public class LetItem extends SimpleNode {
  Identifier varName;
  Expression expression;
  Statement  query;

  public LetItem(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    varName.toString(params, builder);
    builder.append(" = ");
    if (expression != null)
      expression.toString(params, builder);
    else if (query != null) {
      builder.append("(");
      query.toString(params, builder);
      builder.append(")");
    }
  }

  public LetItem copy() {
    final LetItem result = new LetItem(-1);
    result.varName = varName.copy();
    result.expression = expression == null ? null : expression.copy();
    result.query = query == null ? null : query.copy();
    return result;
  }

  public void setVarName(final Identifier varName) {
    this.varName = varName;
  }

  public void setExpression(final Expression expression) {
    this.expression = expression;
  }

  public void setQuery(final Statement query) {
    this.query = query;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { varName, expression, query };
  }

  public Identifier getVarName() {
    return varName;
  }

  public Expression getExpression() {
    return expression;
  }

  public Statement getQuery() {
    return query;
  }

  public void extractSubQueries(final SubQueryCollector collector) {
    //this is to transform LET expressions with subqueries in simple LET, plus LET with query only, so the direct query is ignored
    if (expression != null)
      expression.extractSubQueries(varName, collector);
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { expression, query };
  }
}
/* JavaCC - OriginalChecksum=bb3cd298d79f50d72f6842e6d6ea4fb2 (do not edit this line) */
