/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OInstanceofCondition.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.Record;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.schema.DocumentType;

import java.util.*;

public class InstanceofCondition extends BooleanExpression {

  protected Expression left;
  protected Identifier right;
  protected String     rightString;

  public InstanceofCondition(final int id) {
    super(id);
  }

  @Override
  public Boolean evaluate(final Identifiable currentRecord, final CommandContext context) {
    if (currentRecord == null) {
      return false;
    }
    final Record record = currentRecord.getRecord();
    if (record == null) {
      return false;
    }
    if (!(record instanceof Document)) {
      return false;
    }
    final Document doc = (Document) record;
    final String typez = doc.getTypeName();
    if (typez == null) {
      return false;
    }
    if (right != null) {
      return typez.equals(right.getStringValue());
    } else if (rightString != null) {
      return typez.equals(decode(rightString));
    }
    return false;
  }

  @Override
  public Boolean evaluate(final Result currentRecord, final CommandContext context) {
    if (currentRecord == null)
      return false;

    if (!currentRecord.isElement())
      return false;

    final Record record = currentRecord.getElement().get().getRecord();
    if (record == null)
      return false;

    if (!(record instanceof Document))
      return false;

    final Document doc = (Document) record;
    final DocumentType typez = doc.getType();
    if (typez == null)
      return false;

    if (right != null)
      return typez.isSubTypeOf(right.getStringValue());
    else if (rightString != null)
      return typez.isSubTypeOf(decode(rightString));

    return false;
  }

  private String decode(final String rightString) {
    if (rightString == null)
      return null;
    return BaseExpression.decode(rightString.substring(1, rightString.length() - 1));
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    left.toString(params, builder);
    builder.append(" instanceof ");
    if (right != null) {
      right.toString(params, builder);
    } else if (rightString != null) {
      builder.append(rightString);
    }
  }

  @Override
  public InstanceofCondition copy() {
    final InstanceofCondition result = new InstanceofCondition(-1);
    result.left = left.copy();
    result.right = right == null ? null : right.copy();
    result.rightString = rightString;
    return result;
  }

  @Override
  public void extractSubQueries(final SubQueryCollector collector) {
    left.extractSubQueries(collector);
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { left, right, rightString };
  }

  @Override
  public List<String> getMatchPatternInvolvedAliases() {
    return left == null ? null : left.getMatchPatternInvolvedAliases();
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { left };
  }
}
/* JavaCC - OriginalChecksum=0b5eb529744f307228faa6b26f0592dc (do not edit this line) */
