/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OIndexIdentifier.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import java.util.*;

public class IndexIdentifier extends SimpleNode {

  public enum Type {
    INDEX, VALUES, VALUESASC, VALUESDESC
  }

  protected Type       type;
  protected String     indexNameString;
  protected Identifier indexName;

  public IndexIdentifier(final int id) {
    super(id);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    switch (type) {
    case INDEX:
      builder.append("INDEX");
      break;
    case VALUES:
      builder.append("INDEXVALUES");
      break;
    case VALUESASC:
      builder.append("INDEXVALUESASC");
      break;
    case VALUESDESC:
      builder.append("INDEXVALUESDESC");
      break;
    }
    builder.append(":");
    if (indexNameString != null) {
      builder.append(indexNameString);
    } else {
      indexName.toString(params, builder);
    }
  }

  public String getIndexName() {
    if (indexName != null)
      return indexName.getStringValue();

    return indexNameString;
  }

  public Type getType() {
    return type;
  }

  public IndexIdentifier copy() {
    final IndexIdentifier result = new IndexIdentifier(-1);
    result.type = type;
    result.indexNameString = indexNameString;
    result.indexName = indexName.copy();
    return result;
  }

  @Override
  public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    final IndexIdentifier that = (IndexIdentifier) o;

    if (type != that.type)
      return false;
    if (!Objects.equals(indexNameString, that.indexNameString))
      return false;
    return Objects.equals(indexName, that.indexName);
  }

  @Override
  public int hashCode() {
    int result = type != null ? type.hashCode() : 0;
    result = 31 * result + (indexNameString != null ? indexNameString.hashCode() : 0);
    result = 31 * result + (indexName != null ? indexName.hashCode() : 0);
    return result;
  }

  public void setType(final Type type) {
    this.type = type;
  }

  public void setIndexNameString(final String indexNameString) {
    this.indexNameString = indexNameString;
  }

  public void setIndexName(final Identifier indexName) {
    this.indexName = indexName;
  }

  @Override
  public String toString() {
    return getIndexName();
  }
}
/* JavaCC - OriginalChecksum=025f134fd4b27b84210738cdb6dd027c (do not edit this line) */
