/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OFloatingPoint.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import java.util.*;

public class FloatingPoint extends PNumber {
  protected int    sign        = 1;
  protected String stringValue = null;
  Number finalValue = null;

  public FloatingPoint(final int id) {
    super(id);
  }

  @Override
  public Number getValue() {
    if (finalValue != null) {
      return finalValue;
    }
    if (stringValue.endsWith("F") || stringValue.endsWith("f")) {
      try {
        finalValue = Float.parseFloat(stringValue.substring(0, stringValue.length() - 1)) * sign;
      } catch (final Exception ignore) {
        return null;//TODO NaN?
      }
    } else if (stringValue.endsWith("D") || stringValue.endsWith("d")) {
      try {
        finalValue = Double.parseDouble(stringValue.substring(0, stringValue.length() - 1)) * sign;
      } catch (final Exception ignore) {
        return null;//TODO NaN?
      }
    } else {
      try {
        final double returnValue = Double.parseDouble(stringValue) * sign;
        if (Math.abs(returnValue) < Float.MAX_VALUE) {
          finalValue = (float) returnValue;
        } else {
          finalValue = returnValue;
        }
      } catch (final Exception ignore) {
        return null;//TODO NaN?
      }
    }
    return finalValue;
  }

  public int getSign() {
    return sign;
  }

  public void setSign(final int sign) {
    this.sign = sign;
  }

  public String getStringValue() {
    return stringValue;
  }

  public void setStringValue(final String stringValue) {
    this.stringValue = stringValue;
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    if (sign == -1) {
      builder.append("-");
    }
    builder.append(stringValue);
  }

  @Override
  public FloatingPoint copy() {
    final FloatingPoint result = new FloatingPoint(-1);
    result.sign = sign;
    result.stringValue = stringValue;
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { sign, stringValue };
  }
}
/* JavaCC - OriginalChecksum=46acfb589f666717595e28f1b19611ae (do not edit this line) */
