/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OCreateEdgeStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.query.sql.executor.BasicCommandContext;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.CreateEdgeExecutionPlanner;
import com.arcadedb.query.sql.executor.InsertExecutionPlan;
import com.arcadedb.query.sql.executor.ResultSet;

import java.util.*;

public class CreateEdgeStatement extends Statement {
  protected Identifier targetType;
  protected Identifier targetBucketName;
  protected Expression leftExpression;
  protected Expression rightExpression;
  protected InsertBody body;
  protected boolean    ifNotExists;
  protected boolean    unidirectional = false;

  public CreateEdgeStatement(final int id) {
    super(id);
  }

  @Override
  public ResultSet execute(final Database database, final Object[] args, final CommandContext parentcontext,
      final boolean usePlanCache) {
    final BasicCommandContext context = new BasicCommandContext();
    if (parentcontext != null)
      context.setParentWithoutOverridingChild(parentcontext);

    context.setDatabase(database);
    context.setInputParameters(args);

    final boolean implicitTransaction = ((DatabaseInternal) database).checkTransactionIsActive(database.isAutoTransaction());
    try {
      final InsertExecutionPlan executionPlan = createExecutionPlan(context);
      executionPlan.executeInternal();
      return new LocalResultSet(executionPlan);
    } finally {
      if (implicitTransaction)
        database.commit();
    }
  }

  @Override
  public ResultSet execute(final Database database, final Map params, final CommandContext parentcontext,
      final boolean usePlanCache) {
    final BasicCommandContext context = new BasicCommandContext();
    if (parentcontext != null) {
      context.setParentWithoutOverridingChild(parentcontext);
    }
    context.setDatabase(database);
    context.setInputParameters(params);

    final boolean implicitTransaction = ((DatabaseInternal) database).checkTransactionIsActive(database.isAutoTransaction());
    try {
      final InsertExecutionPlan executionPlan = createExecutionPlan(context);
      executionPlan.executeInternal();
      return new LocalResultSet(executionPlan);
    } finally {
      if (implicitTransaction)
        database.commit();
    }
  }

  public InsertExecutionPlan createExecutionPlan(final CommandContext context) {
    final CreateEdgeExecutionPlanner planner = new CreateEdgeExecutionPlanner(this);
    return planner.createExecutionPlan(context);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("CREATE EDGE");
    if (targetType != null) {
      builder.append(" ");
      targetType.toString(params, builder);
      if (targetBucketName != null) {
        builder.append(" BUCKET ");
        targetBucketName.toString(params, builder);
      }
    }
    builder.append(" FROM ");
    leftExpression.toString(params, builder);

    builder.append(" TO ");
    rightExpression.toString(params, builder);

    if (unidirectional)
      builder.append(" UNIDIRECTIONAL");

    if (ifNotExists)
      builder.append(" IF NOT EXISTS");

    if (body != null) {
      builder.append(" ");
      body.toString(params, builder);
    }
  }

  @Override
  public CreateEdgeStatement copy() {
    final CreateEdgeStatement result = new CreateEdgeStatement(-1);
    result.targetType = targetType == null ? null : targetType.copy();
    result.targetBucketName = targetBucketName == null ? null : targetBucketName.copy();
    result.leftExpression = leftExpression == null ? null : leftExpression.copy();
    result.rightExpression = rightExpression == null ? null : rightExpression.copy();
    result.ifNotExists = ifNotExists;
    result.unidirectional = unidirectional;
    result.body = body == null ? null : body.copy();
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { targetType, targetBucketName, leftExpression, rightExpression, unidirectional, ifNotExists, body };
  }

  public Identifier getTargetType() {
    return targetType;
  }

  public Identifier getTargetBucketName() {
    return targetBucketName;
  }

  public Expression getLeftExpression() {
    return leftExpression;
  }

  public Expression getRightExpression() {
    return rightExpression;
  }

  public boolean ifNotExists() {
    return ifNotExists;
  }

  public boolean isUnidirectional() {
    return unidirectional;
  }

  public InsertBody getBody() {
    return body;
  }
}
/* JavaCC - OriginalChecksum=2d3dc5693940ffa520146f8f7f505128 (do not edit this line) */
