/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OCreateClusterStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Database;
import com.arcadedb.engine.Bucket;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;

import java.util.*;

public class CreateBucketStatement extends DDLStatement {
  protected Identifier name;
  protected boolean    ifNotExists = false;
  protected boolean    blob        = false;

  public CreateBucketStatement(final int id) {
    super(id);
  }

  @Override
  public ResultSet executeDDL(final CommandContext context) {
    final Database db = context.getDatabase();
    final String bucketName = name.getStringValue();
    if (db.getSchema().existsBucket(bucketName)) {
      if (ifNotExists)
        return new InternalResultSet();
      throw new CommandExecutionException("Bucket '" + bucketName + "' already exists");
    }
    final Bucket bucket = db.getSchema().createBucket(bucketName);

    final ResultInternal result = new ResultInternal(context.getDatabase());
    result.setProperty("operation", "create bucket");
    result.setProperty("bucketName", bucketName);
    result.setProperty("bucketId", bucket.getFileId());

    final InternalResultSet rs = new InternalResultSet();
    rs.add(result);
    return rs;
  }

  @Override
  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("CREATE ");
    if (blob)
      builder.append("BLOB ");

    builder.append("BUCKET ");
    name.toString(params, builder);
    if (ifNotExists)
      builder.append(" IF NOT EXISTS");
  }

  @Override
  public CreateBucketStatement copy() {
    final CreateBucketStatement result = new CreateBucketStatement(-1);
    result.name = name == null ? null : name.copy();
    result.ifNotExists = this.ifNotExists;
    result.blob = blob;
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { name, ifNotExists, blob };
  }
}
/* JavaCC - OriginalChecksum=6011a26678f2175aa456a0a6c094cb13 (do not edit this line) */
